/****************************************************************************
**
** Copyright (C) 2014 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the autotests of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtDebug>

#include "qacceltreeresourceloader_p.h"
#include "qnetworkaccessdelegator_p.h"

#include "Global.h"
#include "TestBaseLine.h"
#include "TestGroup.h"

#include "XSDTestSuiteHandler.h"
#include "XSDTSTestCase.h"

using namespace QPatternistSDK;

extern QNetworkAccessManager s_networkManager;

XSDTestSuiteHandler::XSDTestSuiteHandler(const QUrl &catalogFile) : m_ts(0)
                                                                    , m_catalogFile(catalogFile)
                                                                    , m_inSchemaTest(false)
                                                                    , m_inInstanceTest(false)
                                                                    , m_inTestGroup(false)
                                                                    , m_inDescription(false)
                                                                    , m_schemaBlacklisted(false)
                                                                    , m_counter(0)
{
    Q_ASSERT(!m_catalogFile.isRelative());
    m_ts = new TestSuite();
    m_topLevelGroup = new TestGroup(m_ts);
    m_topLevelGroup->setTitle("XML Schema Test Suite");
    m_ts->appendChild(m_topLevelGroup);

    // exclude these test cases, as they break our current state machine
    m_blackList << QLatin1String("addB099")
                << QLatin1String("addB118")
                << QLatin1String("elemJ003")
                << QLatin1String("elemJ011")
                << QLatin1String("elemZ004")
                << QLatin1String("elemZ020")
                << QLatin1String("groupH021v")
                << QLatin1String("groupJ009v")
                << QLatin1String("name00101m2")
                << QLatin1String("schL5")
                << QLatin1String("ste110")
                << QLatin1String("stZ007")
                << QLatin1String("stZ047")
                << QLatin1String("stZ055")
                << QLatin1String("addB049")
                << QLatin1String("addB068")
                << QLatin1String("addB078")
                << QLatin1String("addB078A")
                << QLatin1String("addB078B")
                << QLatin1String("addB167")
                << QLatin1String("addB191")
                << QLatin1String("isDefault060_2")
                << QLatin1String("isDefault069")
                << QLatin1String("annotB025")
                << QLatin1String("base64Binary_enumeration003_1321")
                << QLatin1String("anyURI_a001_1336")
                << QLatin1String("anyURI_a001_1336")
                << QLatin1String("anyURI_a003_1338")
                << QLatin1String("anyURI_a004_1339")
                << QLatin1String("anyURI_b004_1354")
                << QLatin1String("anyURI_b004_1354")
                << QLatin1String("anyURI_b006_1356")
                << QLatin1String("QName_length001_1357")
                << QLatin1String("QName_length003_1359")
                << QLatin1String("QName_minLength003_1362")
                << QLatin1String("QName_maxLength001_1364")
                << QLatin1String("NOTATION_length001_1372")
                << QLatin1String("NOTATION_length003_1374")
                << QLatin1String("NOTATION_minLength003_1377")
                << QLatin1String("NOTATION_maxLength001_1379")
                << QLatin1String("hexBinary003_2069")
                << QLatin1String("QName009_2092")
                << QLatin1String("dtZ107447_a_2245")
                << QLatin1String("elemE001")
                << QLatin1String("elemE002")
                << QLatin1String("elemE003")
                << QLatin1String("elemE004")
                << QLatin1String("elemE005")
                << QLatin1String("elemT026")
                << QLatin1String("elemT027")
                << QLatin1String("elemT028")
                << QLatin1String("elemT029")
                << QLatin1String("elemT054")
                << QLatin1String("elemT055")
                << QLatin1String("elemT056")
                << QLatin1String("elemT057")
                << QLatin1String("elemZ006")
                << QLatin1String("elemZ007")
                << QLatin1String("elemZ026")
                << QLatin1String("elemZ027_c")
                << QLatin1String("elemZ028c")
                << QLatin1String("elemZ028d")
                << QLatin1String("elemZ028f1")
                << QLatin1String("elemZ028f1")
                << QLatin1String("elemZ028f2")
                << QLatin1String("elemZ028f2")
                << QLatin1String("elemZ028f3")
                << QLatin1String("elemZ028f3")
                << QLatin1String("elemZ031")
                << QLatin1String("errF001")
                << QLatin1String("idC019")
                << QLatin1String("idL100")
                << QLatin1String("idZ011")
                << QLatin1String("idZ015")
                << QLatin1String("mgO013")
                << QLatin1String("particlesA012")
                << QLatin1String("particlesA013")
                << QLatin1String("particlesA014")
                << QLatin1String("particlesA015")
                << QLatin1String("particlesHa161")
                << QLatin1String("particlesHb008")
                << QLatin1String("particlesHb011")
                << QLatin1String("particlesIe003")
                << QLatin1String("particlesIg003")
                << QLatin1String("particlesIg004")
                << QLatin1String("particlesJb003")
                << QLatin1String("particlesJd003")
                << QLatin1String("particlesJf003")
                << QLatin1String("particlesJk003")
                << QLatin1String("particlesOb001")
                << QLatin1String("particlesOb002")
                << QLatin1String("particlesOb004")
                << QLatin1String("particlesOb008")
                << QLatin1String("particlesOb009")
                << QLatin1String("particlesOb013")
                << QLatin1String("particlesOb018")
                << QLatin1String("particlesQ005")
                << QLatin1String("particlesS002")
                << QLatin1String("particlesT002")
                << QLatin1String("particlesT009")
                << QLatin1String("particlesT014")
                << QLatin1String("particlesV001")
                << QLatin1String("particlesV002")
                << QLatin1String("particlesV020")
                << QLatin1String("particlesZ001")
                << QLatin1String("particlesZ005")
                << QLatin1String("particlesZ007")
                << QLatin1String("particlesZ023")
                << QLatin1String("particlesZ024")
                << QLatin1String("particlesZ026")
                << QLatin1String("particlesZ028")
                << QLatin1String("particlesZ033_c")
                << QLatin1String("particlesZ033_d")
                << QLatin1String("particlesZ033_e")
                << QLatin1String("particlesZ033_f")
                << QLatin1String("particlesZ033_g")
                << QLatin1String("particlesZ034_a1")
                << QLatin1String("particlesZ034_a2")
                << QLatin1String("particlesZ034_a3")
                << QLatin1String("particlesZ034_b")
                << QLatin1String("particlesZ035_a")
                << QLatin1String("particlesZ035_b")
                << QLatin1String("particlesZ036_a")
                << QLatin1String("particlesZ036_b1")
                << QLatin1String("particlesZ036_b2")
                << QLatin1String("particlesZ036_c")
/*
                << QLatin1String("reC65")
                << QLatin1String("reC66")
                << QLatin1String("reC67")
                << QLatin1String("reC68")
                << QLatin1String("reF58")
                << QLatin1String("reG50")
                << QLatin1String("reJ11")
                << QLatin1String("reJ13")
                << QLatin1String("reJ19")
                << QLatin1String("reJ21")
                << QLatin1String("reJ23")
                << QLatin1String("reJ25")
                << QLatin1String("reJ29")
                << QLatin1String("reJ31")
                << QLatin1String("reJ33")
                << QLatin1String("reJ35")
                << QLatin1String("reJ61")
                << QLatin1String("reJ69")
                << QLatin1String("reJ75")
                << QLatin1String("reJ77")
                << QLatin1String("reL98")
                << QLatin1String("reL99")
                << QLatin1String("reM98")
                << QLatin1String("reN99")
                << QLatin1String("reS21")
                << QLatin1String("reS42")
                << QLatin1String("reT63")
                << QLatin1String("reT84")
                << QLatin1String("reDG2")
                << QLatin1String("RegexTest_9")
                << QLatin1String("RegexTest_11")
                << QLatin1String("RegexTest_14")
                << QLatin1String("RegexTest_15")
                << QLatin1String("RegexTest_16")
                << QLatin1String("RegexTest_17")
                << QLatin1String("RegexTest_23")
                << QLatin1String("RegexTest_24")
                << QLatin1String("RegexTest_25")
                << QLatin1String("RegexTest_26")
                << QLatin1String("RegexTest_27")
                << QLatin1String("RegexTest_28")
                << QLatin1String("RegexTest_30")
                << QLatin1String("RegexTest_30")
                << QLatin1String("RegexTest_33")
                << QLatin1String("RegexTest_34")
                << QLatin1String("RegexTest_34")
                << QLatin1String("RegexTest_43")
                << QLatin1String("RegexTest_44")
                << QLatin1String("RegexTest_45")
                << QLatin1String("RegexTest_46")
                << QLatin1String("RegexTest_47")
                << QLatin1String("RegexTest_48")
                << QLatin1String("RegexTest_49")
                << QLatin1String("RegexTest_50")
                << QLatin1String("RegexTest_51")
                << QLatin1String("RegexTest_52")
                << QLatin1String("RegexTest_53")
                << QLatin1String("RegexTest_54")
                << QLatin1String("RegexTest_55")
                << QLatin1String("RegexTest_56")
                << QLatin1String("RegexTest_57")
                << QLatin1String("RegexTest_57")
                << QLatin1String("RegexTest_58")
                << QLatin1String("RegexTest_58")
                << QLatin1String("RegexTest_65")
                << QLatin1String("RegexTest_113")
                << QLatin1String("RegexTest_116")
                << QLatin1String("RegexTest_119")
                << QLatin1String("RegexTest_120")
                << QLatin1String("RegexTest_121")
                << QLatin1String("RegexTest_141")
                << QLatin1String("RegexTest_142")
                << QLatin1String("RegexTest_143")
                << QLatin1String("RegexTest_145")
                << QLatin1String("RegexTest_146")
                << QLatin1String("RegexTest_147")
                << QLatin1String("RegexTest_148")
                << QLatin1String("RegexTest_149")
                << QLatin1String("RegexTest_150")
                << QLatin1String("RegexTest_151")
                << QLatin1String("RegexTest_152")
                << QLatin1String("RegexTest_154")
                << QLatin1String("RegexTest_155")
                << QLatin1String("RegexTest_156")
                << QLatin1String("RegexTest_157")
                << QLatin1String("RegexTest_158")
                << QLatin1String("RegexTest_163")
                << QLatin1String("RegexTest_164")
                << QLatin1String("RegexTest_165")
                << QLatin1String("RegexTest_166")
                << QLatin1String("RegexTest_167")
                << QLatin1String("RegexTest_168")
                << QLatin1String("RegexTest_169")
                << QLatin1String("RegexTest_170")
                << QLatin1String("RegexTest_171")
                << QLatin1String("RegexTest_172")
                << QLatin1String("RegexTest_173")
                << QLatin1String("RegexTest_174")
                << QLatin1String("RegexTest_178")
                << QLatin1String("RegexTest_194")
                << QLatin1String("RegexTest_194")
                << QLatin1String("RegexTest_195")
                << QLatin1String("RegexTest_195")
                << QLatin1String("RegexTest_196")
                << QLatin1String("RegexTest_196")
                << QLatin1String("RegexTest_197")
                << QLatin1String("RegexTest_198")
                << QLatin1String("RegexTest_199")
                << QLatin1String("RegexTest_200")
                << QLatin1String("RegexTest_200")
                << QLatin1String("RegexTest_201")
                << QLatin1String("RegexTest_201")
                << QLatin1String("RegexTest_202")
                << QLatin1String("RegexTest_202")
                << QLatin1String("RegexTest_203")
                << QLatin1String("RegexTest_204")
                << QLatin1String("RegexTest_205")
                << QLatin1String("RegexTest_206")
                << QLatin1String("RegexTest_207")
                << QLatin1String("RegexTest_208")
                << QLatin1String("RegexTest_209")
                << QLatin1String("RegexTest_209")
                << QLatin1String("RegexTest_210")
                << QLatin1String("RegexTest_210")
                << QLatin1String("RegexTest_211")
                << QLatin1String("RegexTest_211")
                << QLatin1String("RegexTest_212")
                << QLatin1String("RegexTest_213")
                << QLatin1String("RegexTest_214")
                << QLatin1String("RegexTest_215")
                << QLatin1String("RegexTest_216")
                << QLatin1String("RegexTest_217")
                << QLatin1String("RegexTest_218")
                << QLatin1String("RegexTest_220")
                << QLatin1String("RegexTest_221")
                << QLatin1String("RegexTest_222")
                << QLatin1String("RegexTest_226")
                << QLatin1String("RegexTest_230")
                << QLatin1String("RegexTest_232")
                << QLatin1String("RegexTest_233")
                << QLatin1String("RegexTest_294")
                << QLatin1String("RegexTest_294")
                << QLatin1String("RegexTest_295")
                << QLatin1String("RegexTest_295")
                << QLatin1String("RegexTest_299")
                << QLatin1String("RegexTest_300")
                << QLatin1String("RegexTest_301")
                << QLatin1String("RegexTest_302")
                << QLatin1String("RegexTest_303")
                << QLatin1String("RegexTest_304")
                << QLatin1String("RegexTest_305")
                << QLatin1String("RegexTest_306")
                << QLatin1String("RegexTest_307")
                << QLatin1String("RegexTest_308")
                << QLatin1String("RegexTest_309")
                << QLatin1String("RegexTest_310")
                << QLatin1String("RegexTest_311")
                << QLatin1String("RegexTest_312")
                << QLatin1String("RegexTest_313")
                << QLatin1String("RegexTest_314")
                << QLatin1String("RegexTest_315")
                << QLatin1String("RegexTest_315")
                << QLatin1String("RegexTest_316")
                << QLatin1String("RegexTest_316")
                << QLatin1String("RegexTest_317")
                << QLatin1String("RegexTest_317")
                << QLatin1String("RegexTest_440")
                << QLatin1String("RegexTest_441")
                << QLatin1String("RegexTest_442")
                << QLatin1String("RegexTest_443")
                << QLatin1String("RegexTest_448")
                << QLatin1String("RegexTest_449")
                << QLatin1String("RegexTest_450")
                << QLatin1String("RegexTest_451")
                << QLatin1String("RegexTest_458")
                << QLatin1String("RegexTest_464")
                << QLatin1String("RegexTest_464")
                << QLatin1String("RegexTest_465")
                << QLatin1String("RegexTest_469")
                << QLatin1String("RegexTest_470")
                << QLatin1String("RegexTest_471")
                << QLatin1String("RegexTest_472")
                << QLatin1String("RegexTest_473")
                << QLatin1String("RegexTest_477")
                << QLatin1String("RegexTest_478")
                << QLatin1String("RegexTest_478")
                << QLatin1String("RegexTest_479")
                << QLatin1String("RegexTest_480")
                << QLatin1String("RegexTest_481")
                << QLatin1String("RegexTest_482")
                << QLatin1String("RegexTest_482")
                << QLatin1String("RegexTest_483")
                << QLatin1String("RegexTest_483")
                << QLatin1String("RegexTest_484")
                << QLatin1String("RegexTest_487")
                << QLatin1String("RegexTest_516")
                << QLatin1String("RegexTest_516")
                << QLatin1String("RegexTest_517")
                << QLatin1String("RegexTest_517")
                << QLatin1String("RegexTest_518")
                << QLatin1String("RegexTest_518")
                << QLatin1String("RegexTest_519")
                << QLatin1String("RegexTest_519")
                << QLatin1String("RegexTest_521")
                << QLatin1String("RegexTest_523")
                << QLatin1String("RegexTest_524")
                << QLatin1String("RegexTest_524")
                << QLatin1String("RegexTest_586")
                << QLatin1String("RegexTest_587")
                << QLatin1String("RegexTest_592")
                << QLatin1String("RegexTest_593")
                << QLatin1String("RegexTest_594")
                << QLatin1String("RegexTest_595")
                << QLatin1String("RegexTest_596")
                << QLatin1String("RegexTest_597")
                << QLatin1String("RegexTest_598")
                << QLatin1String("RegexTest_599")
                << QLatin1String("RegexTest_600")
                << QLatin1String("RegexTest_601")
                << QLatin1String("RegexTest_602")
                << QLatin1String("RegexTest_603")
                << QLatin1String("RegexTest_604")
                << QLatin1String("RegexTest_605")
                << QLatin1String("RegexTest_648")
                << QLatin1String("RegexTest_655")
                << QLatin1String("RegexTest_688")
                << QLatin1String("RegexTest_696")
                << QLatin1String("RegexTest_697")
                << QLatin1String("RegexTest_698")
                << QLatin1String("RegexTest_700")
                << QLatin1String("RegexTest_701")
                << QLatin1String("RegexTest_702")
                << QLatin1String("RegexTest_703")
                << QLatin1String("RegexTest_704")
                << QLatin1String("RegexTest_705")
                << QLatin1String("RegexTest_706")
                << QLatin1String("RegexTest_707")
                << QLatin1String("RegexTest_717")
                << QLatin1String("RegexTest_718")
                << QLatin1String("RegexTest_719")
                << QLatin1String("RegexTest_724")
                << QLatin1String("RegexTest_725")
                << QLatin1String("RegexTest_726")
                << QLatin1String("RegexTest_727")
                << QLatin1String("RegexTest_728")
                << QLatin1String("RegexTest_729")
                << QLatin1String("RegexTest_730")
                << QLatin1String("RegexTest_731")
                << QLatin1String("RegexTest_732")
                << QLatin1String("RegexTest_733")
                << QLatin1String("RegexTest_743")
                << QLatin1String("RegexTest_755")
                << QLatin1String("RegexTest_756")
                << QLatin1String("RegexTest_761")
                << QLatin1String("RegexTest_762")
                << QLatin1String("RegexTest_781")
                << QLatin1String("RegexTest_782")
                << QLatin1String("RegexTest_783")
                << QLatin1String("RegexTest_790")
                << QLatin1String("RegexTest_791")
                << QLatin1String("RegexTest_824")
                << QLatin1String("RegexTest_826")
                << QLatin1String("RegexTest_827")
                << QLatin1String("RegexTest_836")
                << QLatin1String("RegexTest_837")
                << QLatin1String("RegexTest_841")
                << QLatin1String("RegexTest_842")
                << QLatin1String("RegexTest_843")
                << QLatin1String("RegexTest_844")
                << QLatin1String("RegexTest_845")
                << QLatin1String("RegexTest_846")
                << QLatin1String("RegexTest_847")
                << QLatin1String("RegexTest_848")
                << QLatin1String("RegexTest_851")
                << QLatin1String("RegexTest_852")
                << QLatin1String("RegexTest_853")
                << QLatin1String("RegexTest_854")
                << QLatin1String("RegexTest_855")
                << QLatin1String("RegexTest_856")
                << QLatin1String("RegexTest_857")
                << QLatin1String("RegexTest_861")
                << QLatin1String("RegexTest_862")
                << QLatin1String("RegexTest_863")
                << QLatin1String("RegexTest_864")
                << QLatin1String("RegexTest_865")
                << QLatin1String("RegexTest_866")
                << QLatin1String("RegexTest_870")
                << QLatin1String("RegexTest_879")
                << QLatin1String("RegexTest_880")
                << QLatin1String("RegexTest_888")
                << QLatin1String("RegexTest_889")
                << QLatin1String("RegexTest_890")
                << QLatin1String("RegexTest_891")
                << QLatin1String("RegexTest_892")
                << QLatin1String("RegexTest_893")
                << QLatin1String("RegexTest_894")
                << QLatin1String("RegexTest_895")
                << QLatin1String("RegexTest_896")
                << QLatin1String("RegexTest_897")
                << QLatin1String("RegexTest_898")
                << QLatin1String("RegexTest_899")
                << QLatin1String("RegexTest_900")
                << QLatin1String("RegexTest_901")
                << QLatin1String("RegexTest_902")
                << QLatin1String("RegexTest_903")
                << QLatin1String("RegexTest_904")
                << QLatin1String("RegexTest_905")
                << QLatin1String("RegexTest_906")
                << QLatin1String("RegexTest_907")
                << QLatin1String("RegexTest_908")
                << QLatin1String("RegexTest_909")
                << QLatin1String("RegexTest_910")
                << QLatin1String("RegexTest_911")
                << QLatin1String("RegexTest_912")
                << QLatin1String("RegexTest_913")
                << QLatin1String("RegexTest_914")
                << QLatin1String("RegexTest_915")
                << QLatin1String("RegexTest_916")
                << QLatin1String("RegexTest_917")
                << QLatin1String("RegexTest_918")
                << QLatin1String("RegexTest_919")
                << QLatin1String("RegexTest_920")
                << QLatin1String("RegexTest_921")
                << QLatin1String("RegexTest_922")
                << QLatin1String("RegexTest_923")
                << QLatin1String("RegexTest_924")
                << QLatin1String("RegexTest_925")
                << QLatin1String("RegexTest_926")
                << QLatin1String("RegexTest_928")
                << QLatin1String("RegexTest_929")
                << QLatin1String("RegexTest_930")
                << QLatin1String("RegexTest_936")
                << QLatin1String("RegexTest_937")
                << QLatin1String("RegexTest_938")
                << QLatin1String("RegexTest_939")
                << QLatin1String("RegexTest_940")
                << QLatin1String("RegexTest_941")
                << QLatin1String("RegexTest_942")
                << QLatin1String("RegexTest_943")
                << QLatin1String("RegexTest_944")
                << QLatin1String("RegexTest_945")
                << QLatin1String("RegexTest_946")
                << QLatin1String("RegexTest_949")
                << QLatin1String("RegexTest_950")
                << QLatin1String("RegexTest_951")
                << QLatin1String("RegexTest_952")
                << QLatin1String("RegexTest_953")
                << QLatin1String("RegexTest_954")
                << QLatin1String("RegexTest_955")
                << QLatin1String("RegexTest_956")
                << QLatin1String("RegexTest_957")
                << QLatin1String("RegexTest_958")
                << QLatin1String("RegexTest_959")
                << QLatin1String("RegexTest_960")
                << QLatin1String("RegexTest_961")
                << QLatin1String("RegexTest_962")
                << QLatin1String("RegexTest_963")
                << QLatin1String("RegexTest_964")
                << QLatin1String("RegexTest_976")
                << QLatin1String("RegexTest_977")
                << QLatin1String("RegexTest_988")
                << QLatin1String("RegexTest_989")
                << QLatin1String("RegexTest_990")
                << QLatin1String("RegexTest_991")
                << QLatin1String("RegexTest_994")
                << QLatin1String("RegexTest_995")
                << QLatin1String("RegexTest_996")
                << QLatin1String("RegexTest_997")
                << QLatin1String("RegexTest_1000")
                << QLatin1String("RegexTest_1001")
                << QLatin1String("RegexTest_1002")
                << QLatin1String("RegexTest_1003")
                << QLatin1String("RegexTest_1004")
                << QLatin1String("RegexTest_1007")
                << QLatin1String("RegexTest_1008")
                << QLatin1String("RegexTest_1009")
                << QLatin1String("RegexTest_1010")
                << QLatin1String("RegexTest_1011")
                << QLatin1String("RegexTest_1012")
                << QLatin1String("RegexTest_1013")
                << QLatin1String("RegexTest_1014")
                << QLatin1String("RegexTest_1015")
                << QLatin1String("RegexTest_1016")
                << QLatin1String("RegexTest_1017")
                << QLatin1String("RegexTest_1018")
                << QLatin1String("RegexTest_1019")
                << QLatin1String("RegexTest_1070")
                << QLatin1String("RegexTest_1071")
                << QLatin1String("RegexTest_1076")
                << QLatin1String("RegexTest_1077")
                << QLatin1String("RegexTest_1078")
                << QLatin1String("RegexTest_1079")
                << QLatin1String("RegexTest_1080")
                << QLatin1String("RegexTest_1081")
                << QLatin1String("RegexTest_1082")
                << QLatin1String("RegexTest_1083")
                << QLatin1String("RegexTest_1084")
                << QLatin1String("RegexTest_1085")
                << QLatin1String("RegexTest_1086")
                << QLatin1String("RegexTest_1087")
                << QLatin1String("RegexTest_1088")
                << QLatin1String("RegexTest_1089")
                << QLatin1String("RegexTest_1132")
                << QLatin1String("RegexTest_1139")
                << QLatin1String("RegexTest_1172")
                << QLatin1String("RegexTest_1180")
                << QLatin1String("RegexTest_1181")
                << QLatin1String("RegexTest_1182")
                << QLatin1String("RegexTest_1184")
                << QLatin1String("RegexTest_1185")
                << QLatin1String("RegexTest_1186")
                << QLatin1String("RegexTest_1187")
                << QLatin1String("RegexTest_1188")
                << QLatin1String("RegexTest_1189")
                << QLatin1String("RegexTest_1190")
                << QLatin1String("RegexTest_1191")
                << QLatin1String("RegexTest_1201")
                << QLatin1String("RegexTest_1202")
                << QLatin1String("RegexTest_1203")
                << QLatin1String("RegexTest_1208")
                << QLatin1String("RegexTest_1209")
                << QLatin1String("RegexTest_1210")
                << QLatin1String("RegexTest_1211")
                << QLatin1String("RegexTest_1212")
                << QLatin1String("RegexTest_1213")
                << QLatin1String("RegexTest_1214")
                << QLatin1String("RegexTest_1215")
                << QLatin1String("RegexTest_1216")
                << QLatin1String("RegexTest_1217")
                << QLatin1String("RegexTest_1227")
                << QLatin1String("RegexTest_1239")
                << QLatin1String("RegexTest_1240")
                << QLatin1String("RegexTest_1245")
                << QLatin1String("RegexTest_1246")
                << QLatin1String("RegexTest_1265")
                << QLatin1String("RegexTest_1266")
                << QLatin1String("RegexTest_1267")
                << QLatin1String("RegexTest_1274")
                << QLatin1String("RegexTest_1275")
                << QLatin1String("RegexTest_1308")
                << QLatin1String("RegexTest_1310")
                << QLatin1String("RegexTest_1311")
                << QLatin1String("RegexTest_1320")
                << QLatin1String("RegexTest_1321")
                << QLatin1String("RegexTest_1322")
                << QLatin1String("RegexTest_1323")
                << QLatin1String("RegexTest_1324")
                << QLatin1String("RegexTest_1325")
                << QLatin1String("RegexTest_1326")
                << QLatin1String("RegexTest_1327")
                << QLatin1String("RegexTest_1328")
                << QLatin1String("RegexTest_1329")
                << QLatin1String("RegexTest_1330")
                << QLatin1String("RegexTest_1331")
                << QLatin1String("RegexTest_1332")
                << QLatin1String("RegexTest_1335")
                << QLatin1String("RegexTest_1336")
                << QLatin1String("RegexTest_1337")
                << QLatin1String("RegexTest_1338")
                << QLatin1String("RegexTest_1339")
                << QLatin1String("RegexTest_1340")
                << QLatin1String("RegexTest_1341")
                << QLatin1String("RegexTest_1345")
                << QLatin1String("RegexTest_1346")
                << QLatin1String("RegexTest_1347")
                << QLatin1String("RegexTest_1348")
                << QLatin1String("RegexTest_1349")
                << QLatin1String("RegexTest_1350")
                << QLatin1String("RegexTest_1354")
                << QLatin1String("RegexTest_1363")
                << QLatin1String("RegexTest_1364")
                << QLatin1String("RegexTest_1365")
                << QLatin1String("RegexTest_1372")
                << QLatin1String("RegexTest_1373")
                << QLatin1String("RegexTest_1374")
                << QLatin1String("RegexTest_1375")
                << QLatin1String("RegexTest_1376")
                << QLatin1String("RegexTest_1377")
                << QLatin1String("RegexTest_1378")
                << QLatin1String("RegexTest_1379")
                << QLatin1String("RegexTest_1380")
                << QLatin1String("RegexTest_1381")
                << QLatin1String("RegexTest_1382")
                << QLatin1String("RegexTest_1383")
                << QLatin1String("RegexTest_1384")
                << QLatin1String("RegexTest_1385")
                << QLatin1String("RegexTest_1386")
                << QLatin1String("RegexTest_1387")
                << QLatin1String("RegexTest_1388")
                << QLatin1String("RegexTest_1389")
                << QLatin1String("RegexTest_1390")
                << QLatin1String("RegexTest_1391")
                << QLatin1String("RegexTest_1392")
                << QLatin1String("RegexTest_1393")
                << QLatin1String("RegexTest_1394")
                << QLatin1String("RegexTest_1395")
                << QLatin1String("RegexTest_1396")
                << QLatin1String("RegexTest_1397")
                << QLatin1String("RegexTest_1398")
                << QLatin1String("RegexTest_1399")
                << QLatin1String("RegexTest_1400")
                << QLatin1String("RegexTest_1401")
                << QLatin1String("RegexTest_1402")
                << QLatin1String("RegexTest_1403")
                << QLatin1String("RegexTest_1404")
                << QLatin1String("RegexTest_1405")
                << QLatin1String("RegexTest_1406")
                << QLatin1String("RegexTest_1407")
                << QLatin1String("RegexTest_1408")
                << QLatin1String("RegexTest_1409")
                << QLatin1String("RegexTest_1410")
                << QLatin1String("RegexTest_1412")
                << QLatin1String("RegexTest_1413")
                << QLatin1String("RegexTest_1414")
                << QLatin1String("RegexTest_1420")
                << QLatin1String("RegexTest_1421")
                << QLatin1String("RegexTest_1422")
                << QLatin1String("RegexTest_1423")
                << QLatin1String("RegexTest_1424")
                << QLatin1String("RegexTest_1425")
                << QLatin1String("RegexTest_1426")
                << QLatin1String("RegexTest_1427")
                << QLatin1String("RegexTest_1428")
                << QLatin1String("RegexTest_1429")
                << QLatin1String("RegexTest_1430")
                << QLatin1String("RegexTest_1433")
                << QLatin1String("RegexTest_1434")
                << QLatin1String("RegexTest_1435")
                << QLatin1String("RegexTest_1436")
                << QLatin1String("RegexTest_1437")
                << QLatin1String("RegexTest_1438")
                << QLatin1String("RegexTest_1439")
                << QLatin1String("RegexTest_1440")
                << QLatin1String("RegexTest_1441")
                << QLatin1String("RegexTest_1442")
                << QLatin1String("RegexTest_1443")
                << QLatin1String("RegexTest_1444")
                << QLatin1String("RegexTest_1445")
                << QLatin1String("RegexTest_1446")
                << QLatin1String("RegexTest_1447")
                << QLatin1String("RegexTest_1448")
                << QLatin1String("RegexTest_1451")
                << QLatin1String("RegexTest_1452")
                << QLatin1String("RegexTest_1453")
                << QLatin1String("RegexTest_1454")
                << QLatin1String("RegexTest_1455")
                << QLatin1String("RegexTest_1456")
                << QLatin1String("RegexTest_1472")
                << QLatin1String("RegexTest_1473")
                << QLatin1String("RegexTest_1474")
                << QLatin1String("RegexTest_1475")
                << QLatin1String("RegexTest_1478")
                << QLatin1String("RegexTest_1479")
                << QLatin1String("RegexTest_1480")
                << QLatin1String("RegexTest_1481")
                << QLatin1String("RegexTest_1484")
                << QLatin1String("RegexTest_1485")
                << QLatin1String("RegexTest_1486")
                << QLatin1String("RegexTest_1487")
                << QLatin1String("RegexTest_1488")
                << QLatin1String("RegexTest_1491")
                << QLatin1String("RegexTest_1492")
                << QLatin1String("RegexTest_1493")
                << QLatin1String("RegexTest_1494")
                << QLatin1String("RegexTest_1495")
                << QLatin1String("RegexTest_1496")
                << QLatin1String("RegexTest_1497")
                << QLatin1String("RegexTest_1498")
                << QLatin1String("RegexTest_1499")
                << QLatin1String("RegexTest_1500")
                << QLatin1String("RegexTest_1501")
                << QLatin1String("RegexTest_1502")
                << QLatin1String("RegexTest_1503")
                << QLatin1String("RegexTest_1543")
                << QLatin1String("RegexTest_1544")
                << QLatin1String("reZ001")
*/
                << QLatin1String("schA2")
                << QLatin1String("schA5")
                << QLatin1String("schA7")
                << QLatin1String("schD8")
                << QLatin1String("schG3")
                << QLatin1String("schG6")
                << QLatin1String("schG9")
                << QLatin1String("schG11")
                << QLatin1String("schG12")
                << QLatin1String("schU1")
                << QLatin1String("schU3")
                << QLatin1String("schU4")
                << QLatin1String("schU5")
                << QLatin1String("schZ004")
                << QLatin1String("schZ005")
                << QLatin1String("schZ012_a")
                << QLatin1String("stZ041")
                << QLatin1String("wildZ010");

}

bool XSDTestSuiteHandler::startElement(const QString &namespaceURI,
                                        const QString &localName,
                                        const QString &/*qName*/,
                                        const QXmlAttributes &atts)
{
    if(namespaceURI != QString::fromLatin1("http://www.w3.org/XML/2004/xml-schema-test-suite/"))
        return true;

    if (localName == QLatin1String("testSet")) {
        m_currentTestSet = new TestGroup(m_topLevelGroup);
        Q_ASSERT(m_currentTestSet);
        m_currentTestSet->setTitle(atts.value("name"));
        m_topLevelGroup->appendChild(m_currentTestSet);
    } else if (localName == QLatin1String("testGroup")) {
        m_currentTestGroup = new TestGroup(m_currentTestSet);
        Q_ASSERT(m_currentTestGroup);
        m_currentTestGroup->setTitle(atts.value("name"));
        m_currentTestSet->appendChild(m_currentTestGroup);
        m_inTestGroup = true;
    } else if (localName == QLatin1String("schemaTest")) {
        if (m_blackList.contains(atts.value("name"))) {
            m_currentTestCase = 0;
            m_schemaBlacklisted = true;
            return true;
        }
        m_schemaBlacklisted = false;

        m_currentTestCase = new XSDTSTestCase(TestCase::Standard, m_currentTestGroup, XSDTSTestCase::SchemaTest);
        Q_ASSERT(m_currentTestCase);
        m_counter++;
        m_currentTestCase->setName(QString::number(m_counter) + atts.value("name"));
        m_currentTestGroup->appendChild(m_currentTestCase);
        m_currentTestCase->setParent(m_currentTestGroup);

        m_inSchemaTest = true;
    } else if (localName == QLatin1String("instanceTest")) {
        if (m_schemaBlacklisted) {
            m_currentTestCase = 0;
            return true;
        }

        m_currentTestCase = new XSDTSTestCase(TestCase::Standard, m_currentTestGroup, XSDTSTestCase::InstanceTest);
        Q_ASSERT(m_currentTestCase);
        m_counter++;
        m_currentTestCase->setName(QString::number(m_counter) + atts.value("name"));
        m_currentTestGroup->appendChild(m_currentTestCase);

        m_inInstanceTest = true;
    } else if (localName == QLatin1String("schemaDocument") || localName == QLatin1String("instanceDocument")) {
        if (m_inSchemaTest) {
            m_currentTestCase->setSchemaUri(QUrl(atts.value("xlink:href")));
            if (m_currentSchemaLink.isEmpty()) // we only use the first schema document for validation
                m_currentSchemaLink = atts.value("xlink:href");
        }
        if (m_inInstanceTest) {
            m_currentTestCase->setInstanceUri(QUrl(atts.value("xlink:href")));
            m_currentTestCase->setSchemaUri(QUrl(m_currentSchemaLink));
        }
    } else if (localName == QLatin1String("expected") && (m_inSchemaTest || m_inInstanceTest)) {
        TestBaseLine *baseLine = new TestBaseLine(TestBaseLine::SchemaIsValid);
        if (atts.value("validity") == QLatin1String("valid")) {
            baseLine->setDetails(QLatin1String("true"));
            m_currentTestCase->setName(m_currentTestCase->name() + QLatin1String(" tokoe:valid"));
        } else {
            baseLine->setDetails(QLatin1String("false"));
            m_currentTestCase->setName(m_currentTestCase->name() + QLatin1String(" tokoe:invalid"));
        }

        m_currentTestCase->addBaseLine(baseLine);
    } else if (localName == QLatin1String("documentation") && m_inTestGroup) {
        m_inDescription = true;
    }

    return true;
}

bool XSDTestSuiteHandler::endElement(const QString &/*namespaceURI*/,
                                      const QString &localName,
                                      const QString &/*qName*/)
{
    if (localName == QLatin1String("testGroup")) {
        m_inTestGroup = false;
        m_currentTestGroup->setDescription(m_documentation);
        m_documentation.clear();
        m_currentSchemaLink.clear();

        if (m_currentTestGroup->childCount() == 0)
            m_currentTestSet->removeLast();
    } else if (localName == QLatin1String("schemaTest"))
        m_inSchemaTest = false;
    else if (localName == QLatin1String("instanceTest"))
        m_inInstanceTest = false;
    else if (localName == QLatin1String("documentation"))
        m_inDescription = false;

    return true;
}

bool XSDTestSuiteHandler::characters(const QString &ch)
{
    if (m_inDescription)
        m_documentation += ch;

    return true;
}

TestSuite *XSDTestSuiteHandler::testSuite() const
{
    return m_ts;
}

// vim: et:ts=4:sw=4:sts=4

