/* packet-dcerpc-dce122.c
 * Common defines for dce122
 * Copyright 2002, Jaime Fournier <Jaime.Fournier@hush.com>
 * This information is based off the released idl files from opengroup.
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"

#include <epan/value_string.h>
#include "packet-dcerpc-dce122.h"

static const value_string dce_error_vals[] = {
{ 0, "SUCCESS", },
{ 539918337, "event already in set" },
{ 539918338, "event still part of some set" },
{ 539918339, "illegal, invalid or inconsistent arguments" },
{ 539918340, "too many initialized devices" },
{ 539918341, "no such device" },
{ 539918342, "device no longer available" },
{ 543465473, "Unacceptable user supplied argument" },
{ 543465474, "Object has been updated" },
{ 543465475, "Search matched more than one item" },
{ 543465476, "Can't allocate working memory" },
{ 543465477, "Can't get cell configuration information" },
{ 543465478, "Specified item already exists" },
{ 543465479, "Error in configuration parameters" },
{ 543465480, "No such fileset family" },
{ 543465481, "No such fileset entry" },
{ 543465482, "fileset family already exists" },
{ 543465483, "bad fileset family name" },
{ 543465484, "bad dump level name" },
{ 543465485, "dump level already exists" },
{ 543465486, "No such dump level" },
{ 543465487, "No such parent dump level" },
{ 543465488, "bad expiration date" },
{ 543465489, "Bad tape coordinator id" },
{ 543465490, "tape coordinator id already exists" },
{ 543465491, "No such tape coordinator id" },
{ 543465492, "Bad butc connection handle" },
{ 543465493, "No butc connection handles available" },
{ 543465494, "bad job specification" },
{ 543465495, "No such job" },
{ 543465496, "Too many dump/restore sessions in progress" },
{ 543465497, "No such server" },
{ 543465498, "No such aggregate" },
{ 543465499, "Version mismatch between bak and butc" },
{ 543465500, "error creating thread" },
{ 543465501, "Lock has not been acquired" },
{ 543465502, "Lock already acquired" },
{ 543465503, "Internal error" },
{ 543465504, "bad internal queue" },
{ 543465505, "exception raised" },
{ 543662081, "process not active" },
{ 543662082, "no such entity" },
{ 543662083, "can't do operation now" },
{ 543662084, "entity already exists" },
{ 543662085, "failed to create entity" },
{ 543662086, "index out of range" },
{ 543662087, "you are not authorized for this operation" },
{ 543662088, "syntax error in create parameter" },
{ 543662089, "I/O error" },
{ 543662090, "network problem" },
{ 543662091, "unrecognized bnode type" },
{ 543662092, "unable to install file on server machine" },
{ 543662093, "internal date parsing error in the bosserver" },
{ 543662094, "illegal user list entry type" },
{ 543662095, "error from the security system" },
{ 543662096, "error returned from DCE key mgmt system; check bosserver log" },
{ 543662097, "memory exhaustion in bosserver" },
{ 543662098, "specified admin list file not found" },
{ 543662099, "user or group not recognized by security registry" },
{ 543662100, "unexpected internal error; check bosserver log" },
{ 543662101, "operation not yet implemented" },
{ 543662102, "specified executable not found" },
{ 543662103, "time parameter required for cron type bnode" },
{ 543920129, "dump with specified id already exists" },
{ 543920130, "no dump matching the id was found" },
{ 543920131, "no dump matching the name was found" },
{ 543920132, "no tape matching the name was found" },
{ 543920133, "no tape matching the name was found" },
{ 543920134, "entry doesn't exist" },
{ 543920135, "reference to a tape not being used" },
{ 543920136, "dump of database failed" },
{ 543920137, "access to database denied" },
{ 543920138, "incompatible version numbers" },
{ 543920139, "argument too long or out of range" },
{ 543920140, "sequence of operations incorrect" },
{ 543920141, "inconsistent or unsupported flags bit combination" },
{ 543920142, "requested list too large" },
{ 543920143, "index to iterator function is out of range" },
{ 543920144, "bad database block type" },
{ 543920145, "dumpinfo database empty" },
{ 543920146, "lock is not set" },
{ 543920147, "lock is held by another user" },
{ 543920148, "attempt to lock a lock already held" },
{ 543920149, "interface incompatible" },
{ 543920150, "Ubik I/O error" },
{ 543920151, "bad database address" },
{ 543920152, "backup database is inconsistent" },
{ 543920153, "internal error encountered in backup database server" },
{ 543920154, "error reading cell database" },
{ 543920155, "cell name not found" },
{ 543920156, "database empty or corrupted" },
{ 543920157, "Ubik ClientInit failed" },
{ 543920158, "couldn't allocate entry" },
{ 543920159, "can't allocate memory" },
{ 543920160, "error creating thread" },
{ 543920161, "invalid server group name" },
{ 543920162, "reference to dump already in use" },
{ 543920163, "reference to dump not in use" },
{ 543920164, "reference to tape already in use" },
{ 543920165, "dump to be deleted is not an initial dump" },
{ 543920166, "duplicate tape name" },
{ 546545665, "error in dump/restore process " },
{ 546545666, "ungraceful abort " },
{ 546545667, "the dump/restore has already been aborted" },
{ 546545668, "unable to end dump/restore since work in progress" },
{ 546545669, "some of the dump/restores were unsuccessful" },
{ 546545670, "could not abort the process " },
{ 546545671, "the dump/restore process was aborted by request" },
{ 546545672, "No dump task with specified ID" },
{ 546545673, "No tasks active" },
{ 546545679, "no filesets on this tape" },
{ 546545680, "tape not loaded or drive offline" },
{ 546545681, "internal error" },
{ 546545682, "memory allocation failure" },
{ 546545683, "invalid tape coordinator port offset" },
{ 546545684, "invalid debug level input" },
{ 546545685, "invalid tape config file name" },
{ 546545686, "tape coordinator already running on this tcid" },
{ 546545687, "operation on thread failed" },
{ 546545688, "invalid task" },
{ 546545689, "invalid bakserver group name" },
{ 546545690, "failed to scan tape" },
{ 546545691, "invalid host" },
{ 546545692, "No more dumps on this tape" },
{ 546586625, "interface incompatible" },
{ 546586626, "there is not a mounted tape" },
{ 546586627, "multiple simulataneous mounts not permitted" },
{ 546586628, "can't mount tape" },
{ 546586629, "error during tape dismount" },
{ 546586630, "tape I/O error" },
{ 546586631, "write operation on read-only tape" },
{ 546586632, "operation inappropriate in this context" },
{ 546586633, "read file ended before all data read" },
{ 546586634, "write a zero length file" },
{ 546586635, "end of tape" },
{ 546586636, "problem reading configuration" },
{ 546586637, "argument too long or out of range" },
{ 546586638, "unexpected end of volume data" },
{ 546586639, "no tape loaded or device offline" },
{ 546586640, "memory allocation failure" },
{ 546586641, "end of dump" },
{ 551956481, "More than the maximum number of parameters defined" },
{ 551956482, "Internal parsing error" },
{ 551956483, "Too many values specified after a CMD_SINGLE switch" },
{ 551956484, "Too many parameters specified" },
{ 551956485, "Two or more mutually exclusive parameters used" },
{ 551956486, "Impossibly few arguments specified" },
{ 551956487, "unrecognized or ambiguous command name" },
{ 551956488, "unrecognized or ambiguous switch name" },
{ 551956489, "<unused>" },
{ 551956490, "Insufficient required parameters provided" },
{ 551956491, "Invalid argument value given" },
{ 551956492, "No appropriate commands found" },
{ 551956493, "Interactive mode not available for specified command or suite" },
{ 551956494, "Command execution aborted at user request" },
{ 551956495, "Token too large" },
{ 552005633, "Required pointer parameter has NULL value" },
{ 552005634, "Not enough space in buffer passed to routine" },
{ 552005635, "Malformed host name" },
{ 552005636, "failed to disable cancels" },
{ 552005637, "failed to reenable cancels" },
{ 552005638, "memory allocation failure" },
{ 552005639, "no bindings for this entry" },
{ 552005640, "too many objects in group entry" },
{ 552005641, "Unable to find required credentials to complete requested operation" },
{ 552005642, "Unauthenticated mode forced due to use of short machine name" },
{ 552005643, "one of the uuid parameters is nil" },
{ 552005644, "no objects in group entry" },
{ 556613633, "Not enough space in buffer passed to routine" },
{ 556613634, "Malformed host name" },
{ 556613635, "Error returned from security service" },
{ 556613636, "Error returned from rpc service" },
{ 556613637, "Error returned from threads service" },
{ 556613638, "Requested access denied" },
{ 556613639, "Access check operation requested before server initialization" },
{ 556613640, "Dfsauth operation requested before client initialization" },
{ 556613641, "Requested dfsauth operation not supported in noauth mode" },
{ 556613642, "Required pointer parameter has NULL value" },
{ 556613643, "Unable to obtain value of required environment variable (debugging only)" },
{ 556613644, "Generation of a pathname that is too long was attempted" },
{ 556613645, "Principal name cannot be defaulted in kernel mode" },
{ 556613646, "Unable to dynamically allocate required memory" },
{ 556613647, "Local host DCE name database appears to be corrupted" },
{ 556613648, "No network credentials found for current login context" },
{ 556613649, "Attempt to perform operation that requires root access" },
{ 556613650, "Attempt to use localauth identity on a machine that does not have an identity" },
{ 556613651, "Unable to find a valid key in local keyfile" },
{ 556613652, "Requested protection level is not supported by the RPC system" },
{ 556613653, "File system open error" },
{ 556613654, "File system close error" },
{ 556613655, "File system stat error" },
{ 556613656, "File system read error" },
{ 556613657, "File system write error" },
{ 556613658, "File system rename error" },
{ 556613659, "File system unlink error" },
{ 556613660, "Client is using unsupported authentication service" },
{ 556904449, "Too many bytes in acl byte buffer" },
{ 556904450, "Too few bytes in acl byte buffer" },
{ 556904451, "ACL entry not found" },
{ 556904452, "ACL entry already exists" },
{ 556904453, "Unrecognized entry type" },
{ 556904454, "Unrecognized entry class" },
{ 556904455, "Unimplemented entry type" },
{ 556904456, "Error returned from security service" },
{ 556904457, "Name required for specified entry type" },
{ 556904458, "Attempt to remove required ACL entry" },
{ 556904459, "Buffer allocation error" },
{ 556904460, "Requested access (implicitly) denied by ACL" },
{ 556904461, "Requested access explicitly denied by ACL" },
{ 556904462, "File in which ACL creation was requested already exists" },
{ 556904463, "Attempt to parse ACL by incorrect ACL manager" },
{ 556904464, "ACL contains an entry not appropriate for the ACL manager type" },
{ 556904465, "ACL manager requires parameters not passed to routine" },
{ 556904466, "Required ACL entry missing from ACL" },
{ 556904467, "Required pointer parameter has NULL value" },
{ 556904468, "Unrecognized ACL manager type uuid" },
{ 556904469, "ACL entry type is too large to be processed by current code" },
{ 556904470, "Duplicate ACL entry found" },
{ 556904471, "Specified ACL file not found" },
{ 556904472, "Flat ACL buffer is of incorrect form" },
{ 556904473, "User or group not recognized by Registry Server" },
{ 556904474, "Non-local entry type encountered running in local mode" },
{ 556904475, "File system open error" },
{ 556904476, "File system close error" },
{ 556904477, "File system stat error" },
{ 556904478, "File system read error" },
{ 556904479, "File system write error" },
{ 556904480, "Removed unauthenticated entry from ACL" },
{ 556904481, "Found unauthenticated entry from ACL" },
{ 565575681, "insufficient space on aggregate" },
{ 565575682, "container had no allocation handle" },
{ 565575683, "invalid aggregate handle" },
{ 565575684, "invalid anode handle" },
{ 565575685, "index was out of range or anode was invalid" },
{ 565575686, "illegal undefined or inconsistent arguments" },
{ 565575687, "invalid device object" },
{ 565575688, "the acl or plist file handle was invalid" },
{ 565575689, "illegal undefined or inconsistent flag value" },
{ 565575690, "a volume table index was invalid" },
{ 565575691, "fid uniquifier didn't match" },
{ 565575692, "fid volume id didn't match" },
{ 565575693, "invalid volume handle" },
{ 565575694, "invalid file handle" },
{ 565575695, "file's link count would be negative" },
{ 565575696, "no further volumes are in the aggregate" },
{ 565575697, "no further container are in the volume" },
{ 565575698, "block was past the allocated end of the container" },
{ 565575699, "block address was too large" },
{ 565575700, "specified device already has an aggregate" },
{ 565575701, "too many initialized aggregates" },
{ 565575702, "Specified volume id already exists" },
{ 565575703, "Specified volume name already exists" },
{ 565575704, "Specified anode index already exists" },
{ 565575705, "no transaction specified when one was required" },
{ 565575706, "block was interior to the container but was unallocated" },
{ 565575707, "Specified anode index doesn't exist" },
{ 565575708, "the anode did not contain a file" },
{ 565575709, "the container did not contain a volume table" },
{ 565575710, "the bitmap wasn't consistent w/ superblock" },
{ 565575711, "the superblock did not lead to an AVL" },
{ 565575712, "the file didn't point to an acl container" },
{ 565575713, "container was stored inline or fragmented" },
{ 565575714, "container was stored inline or blocked" },
{ 565575715, "container was stored fragmented or blocked" },
{ 565575716, "an anode being deleted is still open" },
{ 565575717, "an anode is not empty" },
{ 565575718, "other containers using these blocks for copy-on-write purposes" },
{ 565575719, "read operation extends past container's length" },
{ 565575720, "specified size of the status area was too large" },
{ 565575721, "supplied status data extends too far" },
{ 565575722, "insufficient memory to open another anode" },
{ 565575723, "insufficient quota on volume" },
{ 565575724, "copy-on-write is illegal for this container" },
{ 565575725, "block allocation of log is in error" },
{ 565575726, "block allocation for bitmap failed" },
{ 565575727, "error in copy-on-write reference" },
{ 565575728, "management of multiple quota procedures not yet implemented" },
{ 565575729, "initialization entry point called more than once" },
{ 565575730, "object or module not properly initialized" },
{ 565575731, "tried to insert a block that was already allocated" },
{ 565575732, "tried to insert a block at invalid location" },
{ 565575733, "bad block insertion parameters" },
{ 565575734, "a rock was specified whose value was zero" },
{ 565575735, "a volume was referenced while (going) offline" },
{ 565575736, "an aggregate was referenced while (going) offline" },
{ 565575737, "system-special file is or would be made too big" },
{ 565575738, "the container did not contain a volume header" },
{ 565575739, "volume doesn't have a root directory" },
{ 565575740, "not yet implemented" },
{ 565575741, "operation being done piecemeal is not finished" },
{ 565575742, "anode must be copy-on-write" },
{ 565575743, "write operation encountered an inconsistent state" },
{ 565575744, "existing fragment group can not be extended" },
{ 565575745, "aggregate has some open volumes" },
{ 565575746, "volume has some open anodes" },
{ 565575747, "a volume being deleted is still open" },
{ 565575748, "new length is inconsistent with storage method" },
{ 565575749, "expected error code not encountered" },
{ 565575750, "script version number unknown to test program" },
{ 565575751, "iterator value indicates previous was last" },
{ 565575752, "aux type inappropriate for non-dir files" },
{ 565575753, "anode block/offset pair was invalid" },
{ 565575754, "same block is referenced more than once from two different anodes" },
{ 565575755, "failure on storage request during salvage" },
{ 565575756, "copy on write block reference not in use in bitmap" },
{ 565575757, "bad Block anode has copy on write references" },
{ 565575758, "copy On Write pointer is incorrect" },
{ 565575759, "block references beyond anode length" },
{ 565575760, "block references beyond device length" },
{ 565575761, "block reference to indirect block has inconsistent header" },
{ 565575762, "backing anode has invalid indirect block" },
{ 565575763, "block not allocated" },
{ 565575764, "handle reserved for exclusive use of creator" },
{ 565575765, "file has a positive link count" },
{ 565575766, "aggregate may be damaged" },
{ 565575767, "illegal operation on copy on write anode" },
{ 565575768, "block is purged" },
{ 572616705, "Stale context" },
{ 572616706, "Internal corruption" },
{ 572616707, "RPC binding contains no UUID" },
{ 572616708, "Revocation RPC call failed--host still up" },
{ 572616709, "Server initializing after restart: wait and retry" },
{ 572616710, "Server finished with tokens after crash" },
{ 572616711, "Fileset reestablishing tokens after move" },
{ 572616712, "Fileset finished with tokens after move" },
{ 572616713, "Authentication level too high for this fileserver" },
{ 572616714, "Authentication level too low for this fileserver" },
{ 572616715, "Authentication level too high for this fileset" },
{ 572616716, "Authentication level too low for this fileset" },
{ 572616717, "Authentication level too high somehow" },
{ 572616718, "Authentication level too low somehow" },
{ 572825601, "could not attach fileset" },
{ 572825602, "could not detach fileset" },
{ 572825603, "illegal aggregate" },
{ 572825604, "bad fileset name" },
{ 572825605, "insufficient privilege for fileset operation" },
{ 572825606, "error from fileset location database" },
{ 572825607, "fileset moved" },
{ 572825608, "illegal fileset operation" },
{ 572825609, "badly formatted dump" },
{ 572825610, "restoring bad format dump" },
{ 572825611, "fileset release failed" },
{ 572825612, "fileset still in use by ftserver" },
{ 572825613, "out of virtual memory in ftserver" },
{ 572825614, "no such fileset" },
{ 572825615, "more than one read/write fileset" },
{ 572825616, "not all entries successfully processed" },
{ 572825617, "I/O error" },
{ 572825618, "the operation is not yet implemented" },
{ 572825619, "FLDB client not initialized" },
{ 572825620, "fldb entry is missing its R/W ID" },
{ 572825621, "fldb entry is missing its R/O ID" },
{ 572825622, "fldb entry is missing its backup ID" },
{ 572825623, "bad rpc binding handle returned" },
{ 572825624, "malformed server address" },
{ 572825625, "I/O error in pipe" },
{ 572825626, "source fileset is inconsistent" },
{ 572825627, "specified group not in specified cell" },
{ 572825628, "fldb entry inconsistency" },
{ 572825629, "fileset already exists in a different site" },
{ 572825630, "cannot restore replicated filesets" },
{ 572825631, "fts spare3" },
{ 572825632, "fts spare4" },
{ 572825633, "could not attach fileset" },
{ 572825634, "could not detach fileset" },
{ 572825635, "aggregate not present and exported" },
{ 572825636, "bad fileset name" },
{ 572825637, "insufficient privilege for fileset operation" },
{ 572825638, "error from fileset location database" },
{ 572825639, "fileset moved" },
{ 572825640, "illegal fileset operation" },
{ 572825641, "badly formatted dump" },
{ 572825642, "restoring bad format dump" },
{ 572825643, "fileset release failed" },
{ 572825644, "fileset still in use by ftserver" },
{ 572825645, "fileset is offline" },
{ 572825646, "out of virtual memory in ftserver" },
{ 572825647, "no such fileset" },
{ 572825648, "more than one read/write fileset" },
{ 572825649, "I/O error" },
{ 572825650, "Transaction already exists" },
{ 572825651, "Transaction doesn't exist" },
{ 572825652, "internal error releasing transaction" },
{ 572825653, "Fileset already deleted" },
{ 572825654, "Fileset locally mounted" },
{ 572825655, "incremental dump date begins after target completes" },
{ 572825656, "incremental dump version begins after target completes" },
{ 572825657, "incremental dump completes before target does" },
{ 572825658, "incremental dump decreases target's version" },
{ 572825659, "dump contains a bad ACL" },
{ 572825660, "dump contains an ACL with an unknown entry type" },
{ 572825661, "unsupported data transfer protocol" },
{ 572833793, "Aggregate is already attached" },
{ 572833794, "Obsolete error code number 1" },
{ 572833795, "Aggregate is not attached" },
{ 572833796, "Aggregate may need to be recovered" },
{ 572833797, "Fileset is locally mounted" },
{ 572833798, "This fileset has no backing fileset" },
{ 572833799, "Fileset does not exist" },
{ 572833800, "Name is too long" },
{ 572833801, "ID is not unique" },
{ 572833802, "Name is not unique" },
{ 572833803, "Fileset ID is malformed" },
{ 572833804, "The aggregate is in use; detach before continuing" },
{ 572833805, "Obsolete error code number 2" },
{ 572833806, "Cannot find corresponding character device" },
{ 572833807, "Device is locked; an administrative operation may be in progress" },
{ 572833808, "Must specify a block device" },
{ 572833809, "Must specify a character device" },
{ 572833810, "Must specify a device" },
{ 572833811, "Dump stream is corrupted" },
{ 572833812, "Out of memory" },
{ 572833813, "Date of incremental dump is newer than the last modification" },
{ 572833814, "Version of incremental dump is newer than the last modification" },
{ 572833815, "End date of incremental dump is older than the last modification" },
{ 572833816, "End version of incremental dump is older than the last modification" },
{ 572833817, "Specified mount type is unknown" },
{ 572833818, "Specified fileset is not head of fileset chain" },
{ 572833819, "The restored fileset is inconsistent" },
{ 572833820, "Validation failure for the ACL being restored" },
{ 572833821, "ACL being restored has a bad entry type" },
{ 572833822, "Mismatch between aggregate minor version number and DM management status; run salvage" },
{ 572833823, "DM aggregate being attached as native Episode aggregate and without -force switch; check dfstab file" },
{ 572833824, "Non-DM aggregate being attached as DM aggregate; check dfstab file" },
{ 572833825, "Validation failure for the extended attribute list being restored" },
{ 585773057, "Bad token." },
{ 585773058, "Client host is down." },
{ 585773059, "Only some of the tokens are revoked." },
{ 585773060, "Unrecognized host pointer (not used)." },
{ 585773061, "Revoke operation failed." },
{ 585773062, "Don't need the token issued by async grant." },
{ 585773063, "Revocation failed but host isn't down yet." },
{ 585773064, "Interface is no longer supported." },
{ 589672449, "specified set not found" },
{ 589672450, "specified log not found" },
{ 589672451, "cannot open specified dump file" },
{ 589672452, "Date at time 0.000000 was: ..24s" },
{ 589672453, "could not allocate the memory for bulk set info structure" },
{ 589672454, "could not allocate the memory for bulk log info structure" },
{ 589672455, "-follow not supported for user-level tracing" },
{ 589672456, "-sleep not supported for user-level tracing" },
{ 589672457, "-sleep can only be used with -follow" },
{ 589672458, "file names for dumps of user-level tracing cannot contain '/'." },
{ 589672459, "invalid operation on set" },
{ 589672460, "cannot change state of set" },
{ 589672461, "only the first 64 sets are recognized" },
{ 589672462, "only the first 64 logs are recognized" },
{ 589672463, "specified log is unallocated" },
{ 589672464, "specified log has zero size" },
{ 589672465, "zero-length record detected" },
{ 589672466, "-log not yet supported for user-level tracing" },
{ 589672467, "-raw not yet supported for user-level tracing" },
{ 589672469, "Logging .d recs <=.d usec" },
{ 589672470, "Logged .d records in .d usec (min .d/max .d)" },
{ 609947649, "the buffer address given was invalid" },
{ 609947650, "the log/buffer package was reinitialized" },
{ 609947651, "the specified memory region is too small" },
{ 609947652, "the buffer is not valid" },
{ 609947653, "the log has not been recovered" },
{ 609947654, "the specified log was not valid" },
{ 609947655, "the specified transaction is not valid" },
{ 609947656, "the specified transaction is no longer valid" },
{ 609947657, "the specified buffer could not be deleted" },
{ 609947658, "the specified transaction is active" },
{ 609947659, "the specified transaction has ended" },
{ 609947660, "the specified transaction has completed" },
{ 609947661, "the specified transaction has committed" },
{ 609947663, "the specified value is not valid" },
{ 609947664, "the specified operation is not valid" },
{ 609947665, "no buffers were available to satisfy the request" },
{ 609947666, "the log was not active" },
{ 609947667, "there are no free log buffers" },
{ 609947669, "the requested log already exists" },
{ 609947670, "an insufficient # of buffers were given to the log" },
{ 609947671, "duplicate request to log_Shutdown" },
{ 609947672, "there is no available space on the log device" },
{ 609947673, "one or more arguments was invalid" },
{ 609947674, "could not read log in for recovery" },
{ 609947675, "an invalid start record was found in the log" },
{ 609947676, "a transaction was detected out-of-order" },
{ 609947677, "an error was encountered during recovery" },
{ 609947678, "an invalid reference was found" },
{ 609947679, "an invalid log record was found" },
{ 609947680, "an internal sanity check failed" },
{ 609947681, "an invalid log page was encountered" },
{ 609947682, "a null pointer ref was detected" },
{ 609947683, "an invalid pointer was detected" },
{ 609947684, "an invalid record type was found during redo" },
{ 609947685, "an invalid record type was found during undo" },
{ 609947686, "an I/O error was detected during recovery" },
{ 609947687, "performed recovery" },
{ 609947688, "recovery must be run on this aggregate" },
{ 609947689, "the requested operation would block" },
{ 609947690, "a log page with a bad pass number was found" },
{ 609947691, "an uncommitted kill preceded a metadata record" },
{ 609947692, "an uncommitted metadata preceded a kill record" },
{ 648998913, "Invalid parameter" },
{ 648998914, "Volume Version log too short for that" },
{ 648998915, "Given volume is not a replica" },
{ 648998916, "Given volume is not on this server" },
{ 648998917, "Minimum pounce interval not yet expired" },
{ 648998918, "Ignoring your request" },
{ 648998919, "Unknown replication type" },
{ 648998920, "Out of (stable) storage" },
{ 648998921, "Destroy volume rather than bring it up" },
{ 648998922, "Cell ID mismatch" },
{ 648998923, "End of returned items" },
{ 648998924, "Draft volume being created" },
{ 648998925, "Old replica volume busy" },
{ 648998926, "A recent attempt to establish a connection failed" },
{ 648998927, "A connection reset attempt failed" },
{ 654880769, "insufficient memory to salvage " },
{ 655257601, "SCX All OK: new-style exporter" },
{ 655257602, "New-style exporter: needs a RESET" },
{ 655257603, "SCX spare 1" },
{ 655257604, "SCX spare 2" },
{ 655257605, "SCX spare 3" },
{ 655257606, "SCX spare 4" },
{ 655257607, "SCX spare 5" },
{ 655257608, "SCX spare 6" },
{ 655257609, "SCX spare 7" },
{ 655257610, "SCX spare 8" },
{ 655257611, "SCX spare 9" },
{ 655257612, "SCX spare 10" },
{ 655257613, "SCX spare 11" },
{ 655257614, "SCX spare 12" },
{ 655257615, "SCX spare 13" },
{ 655257616, "SCX spare 14" },
{ 655257617, "SCX spare 15" },
{ 655257618, "SCX spare 16" },
{ 655257619, "SCX spare 17" },
{ 655257620, "SCX spare 18" },
{ 655257621, "SCX spare 19" },
{ 655257622, "SCX spare 20" },
{ 655257623, "SCX spare 21" },
{ 655257624, "SCX spare 22" },
{ 655257625, "SCX spare 23" },
{ 655257626, "SCX spare 24" },
{ 655257627, "SCX spare 25" },
{ 655257628, "SCX spare 26" },
{ 655257629, "SCX spare 27" },
{ 655257630, "SCX spare 28" },
{ 655257631, "SCX spare 29" },
{ 655257632, "SCX spare 30" },
{ 655257633, "SCX spare 31" },
{ 655257634, "SCX spare 32" },
{ 655257635, "SCX spare 33" },
{ 655257636, "SCX spare 34" },
{ 655257637, "SCX spare 35" },
{ 655257638, "SCX spare 36" },
{ 655257639, "SCX spare 37" },
{ 655257640, "SCX spare 38" },
{ 655257641, "SCX spare 39" },
{ 655257642, "SCX spare 40" },
{ 655257643, "SCX All OK: init-flags base value" },
{ 663076865, "Illegal host specified" },
{ 663076866, "Incorrect file specification" },
{ 663076867, "Token type given is not a legal token type" },
{ 663076868, "Invalid token ID specified" },
{ 663076869, "TKM entry is locked by another entity" },
{ 663076870, "TKM does not know about specified file" },
{ 663076871, "Attempt to fulfill request took longer than time limit specified" },
{ 663076872, "Token requested was in conflict with another (non-revocable) token" },
{ 663076873, "Invalid or inconsistent token description given" },
{ 663076874, "Token request was queued for later consideration" },
{ 663076875, "Token was deleted from token database during locking" },
{ 663076876, "TKM does not know about specified token" },
{ 663076877, "Token permission set not within MaxToken for named volume" },
{ 663076878, "Too many outstanding tokens on the fid specified" },
{ 663076879, "Too many outstanding tokens held by the host specified" },
{ 663076880, "Token request conflicted with non-revocable token, try again" },
{ 663076881, "Token manager operation not supported" },
{ 663076882, "Token manager unable to get required memory for operation" },
{ 663076883, "Internal code for not TRYAGAIN" },
{ 663076884, "Tokens for 64 bit byteranges cannot be granted yet" },
{ 668147713, "no quorum elected" },
{ 668147714, "not synchronization site (should work on sync site)" },
{ 668147715, "too many hosts" },
{ 668147716, "I/O error writing dbase or log" },
{ 668147717, "mysterious internal error" },
{ 668147718, "major synchronization error" },
{ 668147719, "file not found when processing dbase" },
{ 668147720, "bad lock range size (must be 1)" },
{ 668147721, "read error reprocessing log" },
{ 668147722, "problems with host name" },
{ 668147723, "bad operation for this transaction type" },
{ 668147724, "two commits or aborts done to transaction" },
{ 668147725, "operation done after abort (or commit)" },
{ 668147726, "no servers appear to be up" },
{ 668147727, "premature EOF" },
{ 668147728, "error writing log file" },
{ 668147729, "unsupported address family" },
{ 668147730, "inconsistent cell name" },
{ 668147731, "security group bad or missing" },
{ 668147732, "server group name bad or missing" },
{ 668147733, "server uuid bad or missing" },
{ 668147734, "memory allocation failure" },
{ 668147735, "host not a member of server group" },
{ 668147736, "too many bindings per server" },
{ 668147737, "inconsistent principal name from binding" },
{ 668147738, "I/O error in ubik pipe" },
{ 668147739, "two sync sites prevent dead lock" },
{ 668147740, "rpc runtime exception caught" },
{ 668147741, "vote thread pool queue operation failed" },
{ 668147742, "clock skew among servers too high" },
{ 668147743, "repeatedly failed to obtain ubik lock" },
{ 668147744, "permission denied for attempted operation" },
{ 668147745, "no space left on database device" },
{ 668147746, "invalid DB pathname" },
{ 668147747, "bad file descriptor" },
{ 668147748, "cannot start async RPC call is in progress" },
{ 668147749, "cannot end async RPC no call in progress" },
{ 668147750, "down level server does not support this request" },
{ 668147751, "invalid opcode in bulk update request" },
{ 668147752, "null pointer passed to ubik routine" },
{ 670412801, "Recoverable error" },
{ 670412802, "Unrecoverable error" },
{ 670412803, "Object is not in export list" },
{ 670412804, "Can't create/open file" },
{ 670412805, "Can't write file" },
{ 670412806, "Unsupported rpc interface" },
{ 676372481, "FLDB: fileset Id entry already exists in fldb" },
{ 676372482, "FLDB: unsuccessful read from fldb" },
{ 676372483, "FLDB: fileset name entry exists in fldb" },
{ 676372484, "FLDB: internal creation failure" },
{ 676372485, "FLDB: no such entry" },
{ 676372486, "FLDB: fldb is empty" },
{ 676372487, "FLDB: fileset name is illegal" },
{ 676372488, "FLDB: index is out of range" },
{ 676372489, "FLDB: bad fileset type" },
{ 676372490, "FLDB: illegal server number (out of range)" },
{ 676372491, "FLDB: bad partition number" },
{ 676372492, "FLDB: run out of space for Replication sites" },
{ 676372493, "FLDB: no such Replication server site exists" },
{ 676372494, "FLDB: replication site already exists" },
{ 676372495, "FLDB: parent R/W entry not found" },
{ 676372496, "FLDB: illegal Reference Count number" },
{ 676372497, "FLDB: fldb size for attributes exceeded" },
{ 676372498, "FLDB: bad incoming fldb entry" },
{ 676372499, "FLDB: illegal max fsid increment" },
{ 676372500, "FLDB: RO/BACK id already hashed" },
{ 676372501, "FLDB: fldb entry is already locked" },
{ 676372502, "FLDB: bad fileset operation code" },
{ 676372503, "FLDB: bad release lock type" },
{ 676372504, "FLDB: status report: last release was aborted" },
{ 676372505, "FLDB: invalid replication site server flag" },
{ 676372506, "FLDB: no permission access" },
{ 676372507, "FLDB: malloc(realloc) failed to alloc enough memory" },
{ 676372508, "FLDB: site table corrupted" },
{ 676372509, "FLDB: cannot remove last address for a site" },
{ 676372510, "FLDB: out of space for addresses for a site" },
{ 676372511, "FLDB: address already exists in this site" },
{ 676372512, "FLDB: address already exists in another site" },
{ 676372513, "FLDB: facility is not yet implemented" },
{ 676372514, "FLDB: at end of list" },
{ 676372515, "FLDB: no remaining quota for creations on a server" },
{ 676372516, "FLDB: the given server does not exist" },
{ 676372517, "FLDB: bad site cookie value given" },
{ 676372518, "FLDB: internal inconsistency detected" },
{ 676372519, "FLDB: no such server in FLDB" },
{ 676372520, "FLDB: fileset ID was not reserved" },
{ 676372521, "FLDB: site entry is still in use" },
{ 676372522, "FLDB: FL entry refers to a deleted site" },
{ 676372523, "FLDB: cannot create FLDB with read-only operation" },
{ 676372524, "FLDB: principal name too long" },
{ 688001025, "No entry found" },
{ 688001026, "Not enough room in buffer" },
{ 688001027, "Named base attribute doesn't exist" },
{ 688001028, "Conflicting base attribute" },
{ 691089409, "lowest bound for persistent errors" },
{ 691089410, "fileset not present and exported on server: already deleted/moved" },
{ 691089411, "bad opcode passed to dump" },
{ 691089412, "bad dump format" },
{ 691089413, "bad ftserver ops vector passed in" },
{ 691089414, "fileset deleted by repserver" },
{ 691089415, "fileset inconsistent" },
{ 691089416, "bad fileset ops vector passed in" },
{ 691089417, "fileset out of service pending a move cleanup" },
{ 691089418, "fileset out of service pending clone completion" },
{ 691089419, "fileset is being detached" },
{ 691089420, "license for fileset or software is missing or expired" },
{ 691089421, "replica not current enough" },
{ 691089422, "fileset is locally mounted" },
{ 691089423, "future persistent volerr 14" },
{ 691089424, "future persistent volerr 15" },
{ 691089425, "future persistent volerr 16" },
{ 691089426, "future persistent volerr 17" },
{ 691089427, "future persistent volerr 18" },
{ 691089428, "future persistent volerr 19" },
{ 691089429, "future persistent volerr 20" },
{ 691089430, "future persistent volerr 21" },
{ 691089431, "future persistent volerr 22" },
{ 691089432, "future persistent volerr 23" },
{ 691089433, "future persistent volerr 24" },
{ 691089434, "future persistent volerr 25" },
{ 691089435, "future persistent volerr 26" },
{ 691089436, "future persistent volerr 27" },
{ 691089437, "future persistent volerr 28" },
{ 691089438, "future persistent volerr 29" },
{ 691089439, "future persistent volerr 30" },
{ 691089440, "future persistent volerr 31" },
{ 691089441, "future persistent volerr 32" },
{ 691089442, "future persistent volerr 33" },
{ 691089443, "future persistent volerr 34" },
{ 691089444, "future persistent volerr 35" },
{ 691089445, "future persistent volerr 36" },
{ 691089446, "future persistent volerr 37" },
{ 691089447, "future persistent volerr 38" },
{ 691089448, "future persistent volerr 39" },
{ 691089449, "future persistent volerr 40" },
{ 691089450, "future persistent volerr 41" },
{ 691089451, "future persistent volerr 42" },
{ 691089452, "future persistent volerr 43" },
{ 691089453, "future persistent volerr 44" },
{ 691089454, "future persistent volerr 45" },
{ 691089455, "future persistent volerr 46" },
{ 691089456, "future persistent volerr 47" },
{ 691089457, "future persistent volerr 48" },
{ 691089458, "future persistent volerr 49" },
{ 691089459, "future persistent volerr 50" },
{ 691089460, "future persistent volerr 51" },
{ 691089461, "future persistent volerr 52" },
{ 691089462, "future persistent volerr 53" },
{ 691089463, "future persistent volerr 54" },
{ 691089464, "future persistent volerr 55" },
{ 691089465, "future persistent volerr 56" },
{ 691089466, "future persistent volerr 57" },
{ 691089467, "future persistent volerr 58" },
{ 691089468, "future persistent volerr 59" },
{ 691089469, "future persistent volerr 60" },
{ 691089470, "future persistent volerr 61" },
{ 691089471, "future persistent volerr 62" },
{ 691089472, "future persistent volerr 63" },
{ 691089473, "future persistent volerr 64" },
{ 691089474, "future persistent volerr 65" },
{ 691089475, "future persistent volerr 66" },
{ 691089476, "future persistent volerr 67" },
{ 691089477, "future persistent volerr 68" },
{ 691089478, "future persistent volerr 69" },
{ 691089479, "future persistent volerr 70" },
{ 691089480, "future persistent volerr 71" },
{ 691089481, "future persistent volerr 72" },
{ 691089482, "future persistent volerr 73" },
{ 691089483, "future persistent volerr 74" },
{ 691089484, "future persistent volerr 75" },
{ 691089485, "future persistent volerr 76" },
{ 691089486, "future persistent volerr 77" },
{ 691089487, "future persistent volerr 78" },
{ 691089488, "future persistent volerr 79" },
{ 691089489, "future persistent volerr 80" },
{ 691089490, "future persistent volerr 81" },
{ 691089491, "future persistent volerr 82" },
{ 691089492, "future persistent volerr 83" },
{ 691089493, "future persistent volerr 84" },
{ 691089494, "future persistent volerr 85" },
{ 691089495, "future persistent volerr 87" },
{ 691089496, "future persistent volerr 88" },
{ 691089497, "future persistent volerr 89" },
{ 691089498, "future persistent volerr 90" },
{ 691089499, "future persistent volerr 91" },
{ 691089500, "future persistent volerr 92" },
{ 691089501, "future persistent volerr 93" },
{ 691089502, "future persistent volerr 94" },
{ 691089503, "future persistent volerr 95" },
{ 691089504, "future persistent volerr 96" },
{ 691089505, "future persistent volerr 97" },
{ 691089506, "future persistent volerr 98" },
{ 691089507, "future persistent volerr 99" },
{ 691089508, "future persistent volerr 100" },
{ 691089509, "lowest bound for transient errors" },
{ 691089510, "fileset being deleted/moved" },
{ 691089511, "fileset being dumped" },
{ 691089512, " fileset being restored" },
{ 691089513, "fileset being cloned" },
{ 691089514, "fileset being recloned" },
{ 691089515, "list filesets" },
{ 691089516, "get status on fileset" },
{ 691089517, "create new fileset" },
{ 691089518, "fileset being released" },
{ 691089519, "set quota on fileset" },
{ 691089520, "testing for fileset existence" },
{ 691089521, "set flags on fileset" },
{ 691089522, "set status on fileset" },
{ 691089523, "copy the clone to a new location" },
{ 691089524, "release-clone fileset being copied" },
{ 691089525, "fileset being dumped to tape" },
{ 691089526, "fileset being restored from tape" },
{ 691089527, "repserver getting status on fileset" },
{ 691089528, "repserver setting status on fileset" },
{ 691089529, "repserver setting fileset version" },
{ 691089530, "repserver cloning fileset" },
{ 691089531, "repserver editing fileset status" },
{ 691089532, "repserver clearing fileset status" },
{ 691089533, "repserver uncloning fileset" },
{ 691089534, "repserver switching filesets" },
{ 691089535, "repserver getting fileset changes" },
{ 691089536, "repserver forwarding fileset" },
{ 691089537, "no more memory" },
{ 691089538, "pipe i/o failure" },
{ 691089539, "fileset is over quota" },
{ 691089540, "replica earlier than latest seen" },
{ 691089541, "fileset being moved" },
{ 691089542, "fileset operation sequence being started" },
{ 691089543, "license for fileset or software is expired or missing" },
{ 691089544, "replica not known to be current enough" },
{ 691089545, "external file manager is still working on this file" },
{ 691089546, "file is externally managed for the next 1 second" },
{ 691089547, "file is externally managed for the next 4 seconds" },
{ 691089548, "file is externally managed for the next 16 seconds" },
{ 691089549, "file is externally managed for the next 64 seconds" },
{ 691089550, "file is externally managed for the next 256 seconds" },
{ 691089551, "file is externally managed for the next 1024 seconds" },
{ 691089552, "future transient volerr 43" },
{ 691089553, "future transient volerr 44" },
{ 691089554, "future transient volerr 45" },
{ 691089555, "future transient volerr 46" },
{ 691089556, "future transient volerr 47" },
{ 691089557, "future transient volerr 48" },
{ 691089558, "future transient volerr 49" },
{ 691089559, "future transient volerr 50" },
{ 691089560, "future transient volerr 51" },
{ 691089561, "future transient volerr 52" },
{ 691089562, "future transient volerr 53" },
{ 691089563, "future transient volerr 54" },
{ 691089564, "future transient volerr 55" },
{ 691089565, "future transient volerr 56" },
{ 691089566, "future transient volerr 57" },
{ 691089567, "future transient volerr 58" },
{ 691089568, "future transient volerr 59" },
{ 691089569, "future transient volerr 60" },
{ 691089570, "future transient volerr 61" },
{ 691089571, "future transient volerr 62" },
{ 691089572, "future transient volerr 63" },
{ 691089573, "future transient volerr 64" },
{ 691089574, "future transient volerr 65" },
{ 691089575, "future transient volerr 66" },
{ 691089576, "future transient volerr 67" },
{ 691089577, "future transient volerr 68" },
{ 691089578, "future transient volerr 69" },
{ 691089579, "future transient volerr 70" },
{ 691089580, "future transient volerr 71" },
{ 691089581, "future transient volerr 72" },
{ 691089582, "future transient volerr 73" },
{ 691089583, "future transient volerr 74" },
{ 691089584, "future transient volerr 75" },
{ 691089585, "future transient volerr 76" },
{ 691089586, "future transient volerr 77" },
{ 691089587, "future transient volerr 78" },
{ 691089588, "future transient volerr 79" },
{ 691089589, "future transient volerr 80" },
{ 691089590, "future transient volerr 81" },
{ 691089591, "future transient volerr 82" },
{ 691089592, "future transient volerr 83" },
{ 691089593, "future transient volerr 84" },
{ 691089594, "future transient volerr 85" },
{ 691089595, "future transient volerr 87" },
{ 691089596, "future transient volerr 88" },
{ 691089597, "future transient volerr 89" },
{ 691089598, "future transient volerr 90" },
{ 691089599, "future transient volerr 91" },
{ 691089600, "future transient volerr 92" },
{ 691089601, "future transient volerr 93" },
{ 691089602, "future transient volerr 94" },
{ 691089603, "future transient volerr 95" },
{ 691089604, "future transient volerr 96" },
{ 691089605, "future transient volerr 97" },
{ 691089606, "future transient volerr 98" },
{ 691089607, "future transient volerr 99" },
{ 691089608, "future transient volerr 100" },
{ 691089609, "upper bound for transient errors" },
{ 700735489, "agfs_Unmount vfsp .#x aggrid .d" },
{ 700735490, "agfs_Unmount failed code .d" },
{ 700735491, "agfs_Unmount result code .d" },
{ 700878849, "bnode_GetString entered" },
{ 700878850, "bnode_GetString returning .d" },
{ 700878851, "bnode_GetParm entered" },
{ 700878852, "bnode_GetParm returning .d" },
{ 700878853, "bnode_GetStat entered" },
{ 700878854, "bnode_GetStat returning .d" },
{ 700878855, "bnode_RestartP entered" },
{ 700878856, "bnode_RestartP returning .d" },
{ 700878857, "bnode_Check entered" },
{ 700878858, "bnode_Check returning .d" },
{ 700878859, "bnode_HasCore entered" },
{ 700878860, "bnode_HasCore returning .d" },
{ 700878861, "bnode_WaitAll entered" },
{ 700878862, "bnode_WaitAll returning .d" },
{ 700878863, "bnode_WaitStatus entered" },
{ 700878864, "bnode_WaitStatus returning .d" },
{ 700878865, "bnode_SetStat entered" },
{ 700878866, "bnode_SetStat returning .d" },
{ 700878867, "bnode_SetGoal entered" },
{ 700878868, "bnode_SetGoal returning .d" },
{ 700878869, "bnode_SetFileGoal entered" },
{ 700878870, "bnode_SetFileGoal returning .d" },
{ 700878871, "bnode_InitFileGoal entered" },
{ 700878872, "bnode_InitFileGoal returning .d" },
{ 700878873, "bnode_ApplyInstance entered" },
{ 700878874, "bnode_ApplyInstance returning .d" },
{ 700878875, "bnode_Create entered" },
{ 700878876, "bnode_Create returning .d" },
{ 700878877, "bnode_DeleteName entered" },
{ 700878878, "bnode_DeleteName returning .d" },
{ 700878879, "bnode_Delete entered" },
{ 700878880, "bnode_Delete returning .d" },
{ 700878881, "bnode_PendingTimeout entered" },
{ 700878882, "bnode_PendingTimeout returning .d" },
{ 700878883, "bnode_SetTimeout entered" },
{ 700878884, "bnode_SetTimeout returning .d" },
{ 700878885, "bnode_InitBnode entered" },
{ 700878886, "bnode_InitBnode returning .d" },
{ 700878887, "bnode_DoExec entered" },
{ 700878888, "bnode_DoExec: about to exec .s with .d args" },
{ 700878889, "bnode_DoExec: about to return .d (this is an error condition!)" },
{ 700878890, "bnode_NewProc entered bnode name: .s" },
{ 700878891, "bnode_NewProc: returning .d" },
{ 700878892, "bnode_StopProc entered" },
{ 700878893, "bnode_StopProc: returning .d" },
{ 700878894, "bnode_Deactivate entered" },
{ 700878895, "bnode_Deactivate: returning .d" },
{ 700878896, "bnode_IdValid entered" },
{ 700878897, "bnode_IdValid returning .d" },
{ 700878898, "bosserver: about to listen for network requests." },
{ 700878899, "bosserver: NCS_Init about to call rpc_server_listen" },
{ 700878900, "bosserver: NCS_Init returned from rpc_server_listen" },
{ 700878901, ".s called." },
{ 700878902, ".s returning: .s." },
{ 700878903, "BOSSVR_GetServerStatus entered" },
{ 700878904, "BOSSVR_GetServerStatus returning .d" },
{ 700878905, "BOSSVR_CreateBnode params: name = .s type = .s cmdLine = .s .s . . ." },
{ 700878906, " .s .s .s .s" },
{ 700878907, "BOSSVR_GetStatus params: instance .s." },
{ 700878908, "BOSSVR_GetInstanceInfo params: process: .s." },
{ 700878909, "BOSSVR_AddSUser params: name: .s type: .s." },
{ 700878910, ".s exiting; returning name: .s" },
{ 700878911, "BOSSVR_GetDates params: file: .s" },
{ 700878912, "BOSSVR_ListKeys: we have the wrong key and can't free it: .s" },
{ 700878913, "BOSSVR_ListKeys: can't free key: .s" },
{ 700878914, "BOSSVR_AddKey: can't free key: .s" },
{ 700887041, "sec_id_parse_name: entry name=.s" },
{ 700887042, "sec_id_parse_name: exit code:.d " },
{ 700887043, "dfs_GetJunctionName: entry" },
{ 700887044, "dfs_GetJunctionName: exit code:.d " },
{ 700887045, "malloc: string of dfs junction: err" },
{ 700887046, "rpc_ns_entry_inq_resolution: entry" },
{ 700887047, "rpc_ns_entry_inq_resolution: exit code:.d " },
{ 700887048, "ubik_ClientInit: entry" },
{ 700887049, "ubik_ClientInit: exit code:.d " },
{ 700887050, "dnsGetHandle: err" },
{ 700887051, "dnsEnumAttr: entry" },
{ 700887052, "dnsEnumAttr: exit code:.d " },
{ 700887053, "rpc_binding_inq_object: entry conns:.x" },
{ 700887054, "rpc_binding_inq_object: exit conns:.x code:.d" },
{ 700887055, "rpcx_binding_to_sockaddr: entry conns:.x" },
{ 700887056, "rpcx_binding_to_sockaddr: exit conns:.x code:.d" },
{ 700887057, "helper read: entry" },
{ 700887058, "helper read: exit code:.d " },
{ 700887059, "ProcessRequest: entry" },
{ 700887060, "ProcessRequest: exit code:.d " },
{ 700887061, "helper write: entry" },
{ 700887062, "helper write: exit code:.d " },
{ 700887063, "do_auth_request: entry" },
{ 700887064, "do_auth_request: exit code:.d " },
{ 700887065, "pioctl returned invalid opcode:.d " },
{ 700887066, "principal: .s expires: .s" },
{ 700887067, "cred file: .s" },
{ 700887068, "no flservers available" },
{ 700887069, "freelist exhausted, queuing call" },
{ 700887070, "License server sent event:.d " },
{ 700887071, "license event type .d .s" },
{ 700887072, "condensing request: .d" },
{ 700887073, "ProcessRequest: entry, opcode .d" },
{ 700887074, "ProcessRequest: took .d seconds, exit code:.d" },
{ 700887075, "Dispatch: waiting for memory" },
{ 700887076, "BetterError: given .d and default .d, returning .d" },
{ 700887077, "helper write failed: errno:.d, tid:.d opcode:.d outSize:.d" },
{ 700887078, "helper read failed: errno:.d, retrying in .d seconds" },
{ 700887079, "adding req id=.d to .s-pri queue, now having .d item(s)" },
{ 700887080, "removing req id=.d from .s-pri queue, now having .d item(s) left" },
{ 700887081, "req .d: condensing .s-pri queue: from .d to .d item(s)" },
{ 700887082, "ProcessRequest: entry, opcode .d; req .d" },
{ 700887083, "req .d: op .d, size .d" },
{ 700887084, "name lookup request (size .d): .s" },
{ 700887085, "get_cred(pag .d, euid .d):" },
{ 700887086, "get_cred(): server .s, level .d, protocol .d" },
{ 700887087, "build_msg(pag .d, euid .d, credpag .d, credeuid .d):" },
{ 700887088, "build_msg(): crlvl .d, crprotoc .d, exp .d, server .s" },
{ 700887089, "decode_msg()" },
{ 700887090, "UNKNOWN MESSAGE TYPE" },
{ 700887091, "gen_block()" },
{ 700887092, "gen_key()" },
{ 700887093, "register_server(server .s)" },
{ 700887094, "Substituting for sec_id_parse_name: results are ``.s'' and ``.s''" },
{ 700887095, "Entry is local cell: .s" },
{ 700887096, "Dispatch: waiting for memory for output buffer of size:.d" },
{ 701087745, "CM write vp .x, off .lld, len .d" },
{ 701087746, "CM read vp .x, off .lld, len .d, flen .lld" },
{ 701087747, "CM write vp .x, error .d" },
{ 701087748, "CM read vp .x, error .d" },
{ 701087749, "CM bioread vp .x, off .lld, len .d, bflags .x" },
{ 701087750, "CM biowrite vp .x, off .lld, len .d, bflags .x" },
{ 701087751, "CM bioread done code .d" },
{ 701087752, "CM biowrite done code .d" },
{ 701087753, "CM cm_lookup .x .s" },
{ 701087754, "CM cm_GetACLCache vp .x pag .x" },
{ 701087755, "CM foundaclcache rights .x" },
{ 701087756, "CM addacl vp .x pag .x rights .#x" },
{ 701087757, "CM free all acls vp .x" },
{ 701087758, "CM invalidate acl vp .x, user .x" },
{ 701087759, "CM bkg found req .d, vp .x" },
{ 701087760, "CM cm_NewCell .s" },
{ 701087761, "CM creating cell .s" },
{ 701087762, "CM looking for cell .s" },
{ 701087763, "CM start VL_GetCellInfo" },
{ 701087764, "CM end VL_GetCellInfo, code .d" },
{ 701087765, "CM cm_ConnByAddr: creating conn type .#x, conn .x" },
{ 701087766, "CM stomping binding .x" },
{ 701087767, "CM mark conn bad for pag .x" },
{ 701087768, "CM GC conns .#x" },
{ 701087769, "CM get TGT time .x for pag .x" },
{ 701087770, "CM start AFS_SetContext conn .x srv level .#x" },
{ 701087771, "CM end AFS_SetContext code .d" },
{ 701087772, "CM cm_ConnByMHosts server type .x" },
{ 701087773, "CM cm_ConnByMHosts: all filesets bad" },
{ 701087774, "CM cm_ConnByMHosts: fileset Id(.d) went busy" },
{ 701087775, "CM cm_ConnByAddr server type .#x, serverp .x" },
{ 701087776, "CM cm_ConnByMHosts: found  .d-th server down" },
{ 701087777, "CM cm_ConnByMHosts: reason .d for volume .d" },
{ 701087778, "CM running cm_CheckVolumeNames" },
{ 701087779, "CM running FlushActiveSCaches" },
{ 701087780, "CM flushactivescaches starting .d concurrent storebacks" },
{ 701087781, "CM running write through dslots" },
{ 701087782, "CM servertokenmgt running .d subops" },
{ 701087783, "CM running minor renewlazyreps" },
{ 701087784, "CM running major renewlazyreps" },
{ 701087785, "CM RenewLazyReps refresh vol .d, age .d, mtl .d totiv .d" },
{ 701087786, "CM Renewlazyreps about to refresh .d vols" },
{ 701087787, "CM running CheckOnVOLRoot" },
{ 701087788, "CM running refreshkeepalives" },
{ 701087789, "CM called RefreshKA with .d fids, code .d" },
{ 701087790, "CM running gcexporter" },
{ 701087791, "CM running Ping Servers" },
{ 701087792, "CM Ping Servers queuing at time .x" },
{ 701087793, "CM Ping Servers done at time .x" },
{ 701087794, "CM running pingservers no adjust" },
{ 701087795, "CM running Check Down Servers" },
{ 701087796, "CM getdcache failed to find vp .x, chunk .d" },
{ 701087797, "CM getdcache found vp .x, chunk .d in dcp .x" },
{ 701087798, "CM fetchDCache scp .x, dcp .x" },
{ 701087799, "CM faking 0 byte entry locally" },
{ 701087800, "CM start  AFS_Readdir at position .d" },
{ 701087801, "CM end AFS_Readdir, code .d" },
{ 701087802, "CM start  AFS_FetchData at position .d" },
{ 701087803, "CM end AFS_FetchData, code .d" },
{ 701087804, "CM storeallsegments vp .x" },
{ 701087805, "CM locally smushing scp .x, dcp .x" },
{ 701087806, "CM in cm_GetDownD, need space .d" },
{ 701087807, "CM in flushDCache, dcp .x" },
{ 701087808, "CM cm_StoreDCache scp .x, dcp .x" },
{ 701087809, "CM cm_StoreDCache starts store" },
{ 701087810, "CM cm_StoreDCache starts end, code .d" },
{ 701087811, "CM cm_InvalidateAllSegments scp .x" },
{ 701087812, "CM nh_dolookup dvp .x, name .s" },
{ 701087813, "CM nh_dolookup calling AFS_Lookup" },
{ 701087814, "CM nh_dolookup back from AFS_Lookup, code .d" },
{ 701087815, "CM cm_pioctl vp .x, opcode .d" },
{ 701087816, "CM start AFS_StoreACL" },
{ 701087817, "CM end AFS_StoreACL, code .d" },
{ 701087818, "CM start AFS_FetchACL" },
{ 701087819, "CM end AFS_FetchACL, code .d" },
{ 701087820, "CM start removemount RPC" },
{ 701087821, "CM end removemount RPC, code .d" },
{ 701087822, "CM cm_Analyze: conn .x, code .d, pag .x" },
{ 701087823, "CM cm_Analyze: volerr subcode .d" },
{ 701087824, "CM cm_Analyze: host stale" },
{ 701087825, "CM cm_Analyze: doing busy retry, vol.low .d" },
{ 701087826, "CM cm_Analyze: doing fast busy retry, vol.low .d, code .d" },
{ 701087827, "CM cm_Analyze: check loc of volume .d: result .d, gotNewLoc .d" },
{ 701087828, "CM starting checkvldb's vlgetentrybyid" },
{ 701087829, "CM checkvldb's vlgetentrybyid done, code .d" },
{ 701087830, "CM havetoken revalidate replicated vol .d, time .x" },
{ 701087831, "CM start AFS_FetchStatus" },
{ 701087832, "CM end AFS_FetchStatus code .d" },
{ 701087833, "CM begin AFS_StoreStatus" },
{ 701087834, "CM end AFS_StoreStatus, code .d" },
{ 701087835, "CM scanstatus vp .x, flags .#x" },
{ 701087836, "CM begin AFS_LookupRoot" },
{ 701087837, "CM end AFS_LookupRoot, code .d" },
{ 701087838, "CM pingserver server .x" },
{ 701087839, "CM checkdownservers server .x" },
{ 701087840, "CM begin AFS_GetTime" },
{ 701087841, "CM end AFS_GetTime, code .d" },
{ 701087842, "CM getaccessbits starting fetch for vp .x" },
{ 701087843, "CM getaccessbits end fetch, code .d" },
{ 701087844, "CM checkvolsync updates time when vv current for vol .d to .d" },
{ 701087845, "CM checkvolsync sees vv going back, vol .d, to vv.low .d" },
{ 701087846, "CM checkvolsync notes .d fids from vol.low .d, to vv.low .d" },
{ 701087847, "CM TKN_Probe called" },
{ 701087848, "CM TKN_InitTokenState called" },
{ 701087849, "CM TKN_InitTokenState's server is .x" },
{ 701087850, "CM TKN_InitTokenState returning code .d" },
{ 701087851, "CM TKN_InitTokenState start TSR" },
{ 701087852, "CM TKN_InitTokenState end TSR" },
{ 701087853, "CM TKN_TokenRevoke start" },
{ 701087854, "CM Revoke one token; type .#x" },
{ 701087855, "CM revoking .d tokens from server .x" },
{ 701087856, "CM revoking here tokens for volume .#x" },
{ 701087857, "CM RevokeHereTokens: checkvolumeinfo, Error .d" },
{ 701087858, "CM RevokeHereTokens end" },
{ 701087859, "CM VL_RESTORETOKENS is set" },
{ 701087860, "CM revoking from vp .x, rights .#x, id .#x,,.#x, flags .#x" },
{ 701087861, "CM revoke for vp .x returns code .d" },
{ 701087862, "CM TKN_SetParams called" },
{ 701087863, "CM TKN_GetServerInterfaces called" },
{ 701087864, "CM TKN_GetServerInterfaces returns code .d" },
{ 701087865, "CM begin AFS_GetToken for vp .x, rights .#x" },
{ 701087866, "CM end AFS_GetToken, code .d" },
{ 701087867, "CM begin AFS_ReleaseTokens for .d tokens" },
{ 701087868, "CM end AFS_ReleaseTokens, code .d" },
{ 701087869, "CM configure cell .s" },
{ 701087870, "CM configure cell returned code .d" },
{ 701087871, "CM in cm_fhtovp" },
{ 701087872, "CM cm_open vp .x, flags .#x" },
{ 701087873, "CM cm_close vp .x, flags .#x" },
{ 701087874, "CM cm_write vp .x, flag .#x" },
{ 701087875, "CM write overflows chunk, max .d, len .d" },
{ 701087876, "CM cm_read vp .x, nolock .d" },
{ 701087877, "CM waiting for fetchack, dcp .x" },
{ 701087878, "CM waiting for data to arrive, validPos is .d" },
{ 701087879, "CM in ioctl, vp .x" },
{ 701087880, "CM in cm_getattr, vp .x, flag .#x" },
{ 701087881, "CM in cm_setattr, vp .x, flag .#x" },
{ 701087882, "CM in cm_access, vp .x, mode .#x" },
{ 701087883, "CM lookup failed to find good '..' back pointer" },
{ 701087884, "CM found fid .x..x..x..x (hex)" },
{ 701087885, "CM lookup crossing mount point" },
{ 701087886, "CM mount point points to fid .x..x..x..x" },
{ 701087887, "CM mount point lookup failed" },
{ 701087888, "CM lookup returning vp .x" },
{ 701087889, "CM lookup connection failure" },
{ 701087890, "CM create dvp .x, name .s, mode .#x" },
{ 701087891, "CM begin AFS_CreateFile" },
{ 701087892, "CM end AFS_CreateFile, code .d" },
{ 701087893, "CM in EvalMountPoint, vp .x" },
{ 701087894, "CM create's scache search returns .#x" },
{ 701087895, "CM remove dvp .x, name .s" },
{ 701087896, "CM begin AFS_RemoveFile" },
{ 701087897, "CM end AFS_RemoveFile, code .d" },
{ 701087898, "CM hard link to vp .x, from dir .x name .s" },
{ 701087899, "CM begin AFS_HardLink" },
{ 701087900, "CM end AFS_HardLink, code .d" },
{ 701087901, "CM rename old vp .x, old name .s, new vp .x, new name .s" },
{ 701087902, "CM begin AFS_Rename" },
{ 701087903, "CM end AFS_Rename, code .d" },
{ 701087904, "CM mkdir dvp .x, name .s" },
{ 701087905, "CM begin AFS_MakeDir" },
{ 701087906, "CM end AFS_MakeDir, code .d" },
{ 701087907, "CM removedir dvp .x, name .s" },
{ 701087908, "CM begin AFS_RemoveDir" },
{ 701087909, "CM end AFS_RemoveDir, code .d" },
{ 701087910, "CM cm_readdir vp .x, len .d" },
{ 701087911, "CM readdir filePos .d, chunk .d" },
{ 701087912, "CM lookup cookie returned .d" },
{ 701087913, "CM lookup cookie failed, trying from chunk .d" },
{ 701087914, "CM readdir resync, filePos .d, from chunk .d" },
{ 701087915, "CM readdir reading from chunk .d, relative pos .d" },
{ 701087916, "CM readdir returning new offset .d, code .d" },
{ 701087917, "CM symlink creating dvp .x, name .s" },
{ 701087918, "CM begin AFS_SymLink" },
{ 701087919, "CM end AFS_SymLink, code .d" },
{ 701087920, "CM readlink vp .x" },
{ 701087921, "CM fsync vp .x" },
{ 701087922, "CM inactive vp .x" },
{ 701087923, "CM bmap vp .x" },
{ 701087924, "CM strategy bp .x" },
{ 701087925, "CM user strat, vp .x, bp->flags .#x" },
{ 701087926, "CM noop" },
{ 701087927, "CM mergestatus vp .x, tokenp .x, flags .#x" },
{ 701087928, "CM mergestatus ctime OK for merging, local mod flags .#x" },
{ 701087929, "CM mergestatus add pag .x rights .#x" },
{ 701087930, "CM updatestatus dirvalequalp == .d" },
{ 701087931, "CM begin AFS_Quota " },
{ 701087932, "CM end AFS_Quota, code .d" },
{ 701087933, "CM cm_getacl vp .x" },
{ 701087934, "CM begin AFS_GetAcl" },
{ 701087935, "CM end AFS_GetAcl, code .d" },
{ 701087936, "CM cm_setacl vp .x" },
{ 701087937, "CM begin AFS_SetAcl" },
{ 701087938, "CM end AFS_SetAcl, code .d" },
{ 701087939, "CM Install vol entry for volume ID .d" },
{ 701087940, "CM begin VL_GetEntryByID" },
{ 701087941, "CM end VL_GetEntryByID, code .d" },
{ 701087942, "CM getvolbyname looking for volume .s" },
{ 701087943, "CM begin VL_GetVolByName" },
{ 701087944, "CM end VL_GetVolByName, code .d" },
{ 701087945, "CM setting vol name for vol .x to .s" },
{ 701087946, "CM in afs_xsetgroups" },
{ 701087947, "CM used to be CM_TRACE_SETPAG" },
{ 701087948, "CM getfreeaclent recycles acl entry from vp .x" },
{ 701087949, "CM cm_GetCell failed to find cell .x..x" },
{ 701087950, "CM cm_GetCellByName failed to find cell .s" },
{ 701087951, "CM cm_ConnByAddr using conn .x, service .#x" },
{ 701087952, "CM in cm_ResetUserConns for pag .x" },
{ 701087953, "CM in cm_FlushQueuedServerTokens for server .x" },
{ 701087954, "CM in GetDOnLine, scp .x, dcp .x" },
{ 701087955, "CM getdonline: getting tokens to get chunk online" },
{ 701087956, "CM cm_SyncDCache syncing all chunks from vp .x" },
{ 701087957, "CM cm_SyncDCache fail (ETIMEDOUT) from vp .x" },
{ 701087958, "CM TruncateAllSegments truncating vp .x to .d" },
{ 701087959, "CM getdowndslot recycling dcp .x" },
{ 701087960, "CM invalidateoneseg vp .x, dcp .x" },
{ 701087961, "CM clearing online state for vp .x, dcp .x" },
{ 701087962, "CM setting online token ID for vp .x, dcp .x" },
{ 701087963, "CM in nh_enter, scp .x, name .s, vnode .#x" },
{ 701087964, "CM in nh_delete, scp .x, name .s" },
{ 701087965, "CM nh_deleted_vp for scp .x" },
{ 701087966, "CM releaselockf vp .x, type .x, start .d, lastbyte .d" },
{ 701087967, "CM cm_SetLockF vp .x, type .x, start .d, lastbyte .d" },
{ 701087968, "CM cm_TryLockRevoke vp .x, type .x colA .x colB .x" },
{ 701087969, "CM cm_TryLockRevoke: No lockf found vp .x" },
{ 701087970, "CM lock token conflict" },
{ 701087971, "CM setlockf: blocked locally == .d" },
{ 701087972, "CM checkerror returning code .d" },
{ 701087973, "CM cm_GetScache vp .x, volume.low .#x, vnode .#x" },
{ 701087974, "CM MarkTime vp .x, time .x, flags .#x" },
{ 701087975, "CM SyncSCache vp .x" },
{ 701087976, "CM SyncSCache fail (ETIMEDOUT) from vp .x" },
{ 701087977, "CM recycling scache .#x, really" },
{ 701087978, "CM resetting all bind mount points" },
{ 701087979, "CM lost race in reclaim, scp .x" },
{ 701087980, "CM server .x just marked down" },
{ 701087981, "CM cm_shutdown called!" },
{ 701087982, "CM StabilizeSCache waiting vp .x" },
{ 701087983, "CM StabilizeDCache waiting vp .x, dcp .x (1)" },
{ 701087984, "CM StabilizeDCache waiting vp .x, dcp .x (2)" },
{ 701087985, "CM cache fetch proc dcp .x, new pos .d" },
{ 701087986, "CM cm_FreeAllCookies, scp .x" },
{ 701087987, "CM reserveblocks emergency, scp .x, truncating dcp .x!" },
{ 701087988, "CM gettokens vp .x, rights.low .#x" },
{ 701087989, "CM token revoke race occurred" },
{ 701087990, "CM in DoPartialWrite" },
{ 701087991, "CM in cm_read, getting chunk online manually" },
{ 701087992, "CM cm_read: read past chunk EOF, padding with zeroes" },
{ 701087993, "CM read starting prefetch for offset .d" },
{ 701087994, "CM swapping out vol structure at .x" },
{ 701087995, "CM async grant RPC vp .x type .#x range(.d:.d)" },
{ 701087996, "CM async grant returns code .d" },
{ 701087997, "CM async can't find fid's server" },
{ 701087998, "CM async done, states .#x, code .d" },
{ 701087999, "CM TKN_AsyncGrant fid .x..x..x..x, rights .#x" },
{ 701088000, "CM TKN_AsyncGrant done for vp .#x" },
{ 701088001, "CM Refresh Tokens at time .x, opcount .d" },
{ 701088002, "CM Refresh Tokens done at time .x" },
{ 701088003, "CM start UpdateTokensLifetime" },
{ 701088004, "CM Update Tokens for scp .x" },
{ 701088005, "CM start AFS_SetParams" },
{ 701088006, "CM end AFS_SetParams code .d" },
{ 701088007, "CM restore move tokens" },
{ 701088008, "CM recover token renew = .d" },
{ 701088009, "CM start TSR AFS_GetToken, type .#x, verNum .d,.d" },
{ 701088010, "CM end TSR AFS_GetToken, code .d, type .#x, verNum .d,.d" },
{ 701088011, "CM RecoverTokenState, flags .#x, tsrMode .d" },
{ 701088012, "CM cm_ReadVDir exit resid .d" },
{ 701088013, "CM get a new tgt for pag .x, lifetime .x" },
{ 701088014, "CM Trybind on name = .s" },
{ 701088015, "CM Trybind: cannot get helper" },
{ 701088016, "CM Trybind: read helper returns avpp  .x, replyCode .d" },
{ 701088017, "CM  and ctime .#x,.#x vs .#x,.#x" },
{ 701088018, "CM TSR Async start with server .x type .#x" },
{ 701088019, "CM TSR Async end with server .x" },
{ 701088020, "CM Wake up async grant from server .x START" },
{ 701088021, "CM Wake up async grant END" },
{ 701088022, "CM GetTokens mapping token conflict to volume busy" },
{ 701088023, "CM Get HERE Token for volume .#x, request .#x" },
{ 701088024, "CM HERE token GC revoke, code .d" },
{ 701088025, "CM GetHereToken in RecoverTokenState failed, code .d" },
{ 701088026, "CM RevokeHereTokens Relinquish! code = .d" },
{ 701088027, "CM RevokeHereTokens end, code .d" },
{ 701088028, "CM someone else is doing TSR-move, nowait = .d" },
{ 701088029, "CM TSR-CRASH-MOVE for volume .#x" },
{ 701088030, "CM TSR-MOVE has dirty data in volume .#x, tsr-mode .x" },
{ 701088031, "CM havetokens: vol .d known .x: past hard limit .d" },
{ 701088032, "CM havetokens: vol .d known .x, tried .x: past check interval .d" },
{ 701088033, "CM pagein vp .x off .x len .x rw=.d" },
{ 701088034, "CM pagein done code .d" },
{ 701088035, "CM pageout vp .x off .x len .x flags=.x" },
{ 701088036, "CM pageout done code .d" },
{ 701088037, "CM vmrw vp .x, write=.d, off=.#x, len=.#x" },
{ 701088038, "CM Simulating token revoke, scp=.#x rights.low=.#x" },
{ 701088039, "CM TKN_TokenRevoke: incoming server .x not scp .x's RW server .x, and no hereServerp for volp .x" },
{ 701088040, "CM TKN_TokenRevoke: incoming server .x neither scp .x's RW server .x nor hereServerp .x" },
{ 701088041, "CM TKN_TokenRevoke: incoming server .x not scp .x's RW server .x, but same as volp .x's hereServerp" },
{ 701088042, "CM cm strategy done, vp .#x, code .d, left .#x" },
{ 701088043, "CM TSR fid .x..x..x..x, data version .u,,.u vs .u,,.u" },
{ 701088044, "CM TSR fid .x..x..x..x, modChunks .d, modFlags .#x;" },
{ 701088045, "CM TSR: server back up, fid .x..x..x..x, gettoken flags now .#x" },
{ 701088046, "CM TSR: volume back up, fid .x..x..x..x, gettoken flags now .#x" },
{ 701088047, "CM token async grant race occurred" },
{ 701088048, "CM marking scache .#x bad (code is .d)" },
{ 701088049, "CM TSR fid .x..x..x..x, tsrMode .#x, have LOCKS" },
{ 701088050, "CM TSR fid .x..x..x..x, tsrMode .#x, move finished early" },
{ 701088051, "CM STKN_InitTokenState: no server (IP .#x, UUID .x/.x/.x/.x)" },
{ 701088052, "CM STKN_TokenRevoke: no server (IP .#x, UUID .x/.x/.x/.x)" },
{ 701088053, "CM STKN_AsyncGrant: no server (IP .#x, UUID .x/.x/.x/.x)" },
{ 701088054, "CM cm_ConnByAddr: setting UUID .x/.x/.x/.x in connp .x" },
{ 701088055, "CM cm_ConnByAddr: passing other UUID .x/.x/.x/.x for connp .x" },
{ 701088056, "CM cm_ConnByMHosts: found changed gen. count .d -> .d" },
{ 701088057, "CM cm_ConnByAddr: new I/F, server .#lx needs a reset, calling with DO_RESET" },
{ 701088058, "CM cm_ConnAndReset: conn .#lx, server .#lx, service .#lx" },
{ 701088059, "CM cm_ConnAndReset: conn .#lx, server .#lx: reset .d tokens" },
{ 701088060, "CM cm_ConnAndReset: conn .#lx, service .#lx: calling AFS_SetContext" },
{ 701088061, "CM cm_ConnAndReset: conn .#lx: AFS_SetContext result is .d" },
{ 701088062, "CM TSR: can't obtain by ID, fid .x..x..x..x, gettoken flags now .#x" },
{ 701088063, "CM TSR fid .x..x..x..x, have LOCKS; gettoken flags .#lx, token types .#lx" },
{ 701088064, "CM TSR: move finished already, fid .x..x..x..x, gettoken flags now .#x, tsrMode now .#x" },
{ 701088065, "CM cm_StoreDCache: store was invalid, fid .x..x..x..x, from .lu,,.lu for .lu, code .d" },
{ 701088066, "CM cm_StoreDCache: store was invalid, scp .x, fid .x..x..x..x, code .d" },
{ 701088067, "CM cm_InvalidateAllSegments: invalidating active store, fid .x..x..x..x, scp states .#lx, storeCount .d, code .d" },
{ 701088068, "CM cm_InvalidateOneSegment: invalidating active seg, scp .x, fid .x..x..x..x, dcp states .#lx, code .d" },
{ 701088069, "CM cm_StoreSCache: store was invalid, scp .x, fid .x..x..x..x, code .d" },
{ 701088070, "CM cm_setacl: store was invalid, scp .x, fid .x..x..x..x, code .d" },
{ 701088071, "CM cm_setacl: cm_Conn set invalid, scp .x, fid .x..x..x..x, code .d" },
{ 701088072, "CM cm_StoreSCache: cm_Conn set invalid, scp .x, fid .x..x..x..x, code .d" },
{ 701088073, "CM cm_StoreDCache: cm_Conn set invalid, fid .x..x..x..x, from .lu,,.lu for .lu, code .d" },
{ 701088074, "CM cm_StoreDCache: cm_Conn set invalid, scp .x, fid .x..x..x..x, code .d" },
{ 701088075, "CM RevokeHereToken: holding ID .lu,,.lu for vol .lu,,.lu, so giving .lu,,.lu back to server .x" },
{ 701088076, "CM RevokeHereToken: unrecognized cell .lu,,.lu, fid .x..x..x..x, so giving .lu,,.lu back to server .x" },
{ 701088077, "CM start recheck AFS_SetContext: conn .x srv level .#x" },
{ 701088078, "CM end recheck AFS_SetContext: code .d" },
{ 701088079, "CM cm_ConnAndReset: SECONDARY waiting for PRIMARY: conn .#lx, server .#lx, service .#lx" },
{ 701088080, "CM cm_ConnAndReset: waiting for mutex: conn .#lx, server .#lx, service .#lx" },
{ 701088081, "CM checkvolsync, same vv: updates time when vv current for vol .lu,,.lu from .lu to .lu" },
{ 701088082, "CM checkvolsync, advanced vv: updates time when vv current for vol .lu,,.lu from .lu to .lu" },
{ 701088083, "CM checkvolsync sees vv going back, vol .lu,,.lu, from vv .lu,,.lu to vv .lu,,.lu" },
{ 701088084, "CM checkvolsync notes .d fids from vol .lu,,.lu, incidental vv .lu,,.lu, to vv .lu,,.lu" },
{ 701088085, "CM checkvolsync flushed .d fids from vol .lu,,.lu" },
{ 701088086, "CM checkvolsync finally advances vv for vol .lu,,.lu from .lu,,.lu to .lu,,.lu; reallyvv .lu,,.lu" },
{ 701088087, "CM cm_FindServerIP: found .#x type .d in serverp .#x" },
{ 701088088, "CM cm_FindServerIP: could not find .#x type .d" },
{ 701088089, "CM cm_SetServerRank: FX server .#x -> .d" },
{ 701088090, "CM cm_SetServerRank: REP server .#x -> .d" },
{ 701088091, "CM cm_SetServerRank: FL server .#x -> .d" },
{ 701088092, "CM cm_SetServerRank: Existing Qd rank for .#x[.d] -> .d" },
{ 701088093, "CM cm_SetServerRank: Adding Qd rank request for .#x[.d] -> .d" },
{ 701088094, "CM cm_DefaultRank addr .#x type .#x" },
{ 701088095, "CM cm_DefaultRank found sister server .#x rank .d" },
{ 701088096, "CM cm_DefaultRank Found Qd Req rank .d" },
{ 701088097, "CM cm_DefaultRank computed default rank .d" },
{ 701088098, "CM cm_ReSortServers: sorting volumes referencing server .#x" },
{ 701088099, "CM cm_ReSortCellSrvs: sorting cells referencing server .#x" },
{ 701088100, "CM cm_ConnByMHosts: At position .d old server .#x new server .#x" },
{ 701088101, "CM cm_ConnByMHosts: This index [.d] timeBad .#x EarliestIx .d code .d" },
{ 701088102, "CM cm_ConnByMHosts: found either bad server .#x or gen. count changed .d -> .d" },
{ 701088103, "CM cm_ConnByMHosts: The server at index .d is now NULL" },
{ 701088104, "CM cm_ConnByMHosts: cm_ConnByAddr failed (fatal=.d)" },
{ 701088105, "CM cm_ConnByMHosts: found gen. count changed after cm_ConnByHost .d -> .d" },
{ 701088106, "CM Finished marking scache .#x bad (code is .d)" },
{ 701088107, "CM cm_GetSLock(scp=.#x, tokens=.#x..) discovers async status of .d" },
{ 701088108, "CM cm_GetSLock(scp=.#x, tokens=.#x..) gets code .d from GetTokensRange" },
{ 701088109, "CM cm_write calls cm_FindDCache(scp=.#x, pos=.#x), returns EIO" },
{ 701088110, "CM cm_GetDLock calls GetDOnLine(scp=.#x, dcp=.#x, tokentype=.x,,.x..): code .d" },
{ 701088111, "CM cm_write calls cm_CFileRDWR, scp=.#x, dcp=.#x: code .d, resid .#x" },
{ 701088112, "CM cm_write calls DoPartialWrite(scp=.#x, lastoffs=.#x...): code .d" },
{ 701088113, "CM cm_StoreAllSegments calls StoreSCache(scp=.#x, aflags=.#x..): code .d" },
{ 701088114, "CM cm_StoreAllSegments calls StoreDCache(scp=.#x, dcp=.#x, aflags=.#x..): code .d" },
{ 701088115, "CM DoPartialWrite calls cm_StoreDCache(scp=.#x, dcp=.#x, ...): code .d" },
{ 701088116, "CM bkgDaemon done with req .#x opcode .d: code .d" },
{ 701088117, "CM bkgWait read req .#x and got code .d" },
{ 701088118, "CM bkgQueue returns req .#x, doing op .d on .#x" },
{ 701088119, "CM bkgRelease releasing req .#x" },
{ 701088120, "CM cm_FlushExists considering flushing name .s in dir .#x for EEXIST error" },
{ 701088121, "CM cm_FlushExists: nh_lookup returns code=.d, vnode=.d" },
{ 701088122, "CM cm_FlushExists FLUSHING name .s in dir .#x for EEXIST error" },
{ 701088123, "CM checkvolsync: flushing(#.d) fid .x..x..x..x, type .d vp .x" },
{ 701088124, "CM checkvolsync: we flushed input fid .x..x..x..x, so return CM_REP_ADVANCED_AGAIN" },
{ 701088125, "CM cm_GetDOnLine: Checking for fetch: scp dv .lu,,.lu, dcp dv .lu,,.lu, scp type .ld" },
{ 701088126, "CM cm_NeedRPC(.lu,,.lu): Yes, we have to make an RPC" },
{ 701088127, "CM cm_ConnAndReset: RPC rejection in .d seconds!" },
{ 701088128, "CM cm_ConnByAddr: RPC rejection in .d seconds!" },
{ 701088129, "CM cm_putapage throwing away page past EOF. scp .x length .x offset .x" },
{ 701088130, "CM cm_getpage request fully past EOF, scp .x scp->m.Length .x offset .x len .x" },
{ 701088131, "CM cm_setfl vp .x, oflags .#x, nflags .#x" },
{ 701088132, "CM cm_CheckOpens(.x, .d): opens .d, v_count .d" },
{ 701088133, "CM cm_CheckOpens: opens .d, readers .d, writers .d, shareds .d; CLEARING" },
{ 701088134, "CM cm_addmap(.x): prot .#lx, flags .#lx: setting RMAPPED, WMAPPED" },
{ 701088135, "CM cm_getpage(.x): setting RMAPPED, WMAPPED" },
{ 701088136, "CM cm_map(.x): prot .#lx, maxprot .#lx, flags .#lx; setting RMAPPED, WMAPPED" },
{ 701088137, "CM cm_RefreshKeepAlives(): calling .x with .d fids, for example .x..x..x..x" },
{ 701088138, "CM cm_RefreshKeepAlives(), spot .d: adding fid .d for .x: .x..x..x..x" },
{ 701088139, "CM cm_RefreshKeepAlives(): overwriting expr of .x (fid .x..x..x..x), was .d" },
{ 701088140, "CM cm_StoreDCache: storing chunk without tokens, fid .x..x..x..x, from .lu,,.lu for .lu (scp = .x)" },
{ 701088141, "CM cm_StoreDCache: storing offline chunk, fid .x..x..x..x, from .lu,,.lu for .lu (dcp = .x)" },
{ 701088142, "CM cm_ReclaimVDirs: Vdir count is .d, so reclaiming" },
{ 701088143, "CM cm_ReclaimVDirs: scp .x, name '.s', giving vp .x; vdirp states .#lx" },
{ 701088144, "CM cm_ReclaimVDirs: Ending; inspected .d vdirs; freed .d vdirs; count .d" },
{ 701088145, "CM cm_GCVDirs: Ending; vdir count is now .d, after .d loops" },
{ 701088146, "CM cm_GCVDirs: advancing minTimeout from .d to .d" },
{ 701088147, "CM cm_GCVDirs: Bypassing GC since only .d seconds since .d" },
{ 701088148, "CM cm_ConnByMHosts: Sleep interrupted" },
{ 701088149, "CM cm_Analyze: TKM-induced sleep interrupted" },
{ 701088150, "CM cm_Analyze: vol-induced sleep interrupted" },
{ 701088151, "CM cm_RevalidateCellRoot: from volid .lu,,.lu to .lu,,.lu (.s)" },
{ 701088152, "CM cm_DoCellRootScp: using fid .x..x..x..x" },
{ 701088153, "CM used to be CM_TRACE_QUEUESETSIZE" },
{ 701088154, "CM start AFS_SetParams, server .x, to set client size of .#x" },
{ 701088155, "CM end AFS_SetParams got server size of .#x: code .d" },
{ 701088156, "CM TKN_SetParams called: flag .d, mask .#x" },
{ 701088157, "CM cm_RecoverSCacheToken: racing revoke for fid .x..x..x..x, ID .lu,,.lu" },
{ 701088158, "CM cm_BulkFetchStatus: scp .x" },
{ 701088159, "CM bulkstat: offset .d out of range .d" },
{ 701088160, "CM bulkstat: server does not export bulkstat" },
{ 701088161, "CM bulkstat: some other client changed dir" },
{ 701088162, "CM bulkstat: some other thread changed dir" },
{ 701088163, "CM bulkstat: token revoked" },
{ 701088164, "CM bulkstat: error for file .s" },
{ 701088165, "CM cm_BulkFetchStatus: scp .x, error .d" },
{ 701088166, "CM bulkstat: error for file .s" },
{ 701088167, "CM cm_RestoreMoveTokens: About to check tokens; orig=.x, new=.x" },
{ 701088168, "CM cm_RestoreMoveTokens: VALIDATE on!  Fid .x..x..x..x, token flags .#x, server .x, types .x" },
{ 701088169, "CM cm_RestoreMoveTokens: on old server!  Fid .x..x..x..x, token flags .#x, server .x, types .x" },
{ 701088170, "CM cm_RestoreMoveTokens: not on new server!  Fid .x..x..x..x, token flags .#x, server .x, types .x" },
{ 701088171, "CM cm_StripRedundantTokens: token id .lu,,.lu types .x reduced by id .lu,,.lu types .x" },
{ 701088172, "CM cm_StripRedundantTokens: token .x, id .lu,,.lu, types .x reduced to .x" },
{ 701088173, "CM cm_ServerDown(.x): (lastcall=.d + TTL=.d) later than now=.d: server stays up" },
{ 701088174, "CM tryLockRevoke preserving .lx: type .d, [.lx...lx]" },
{ 701088175, "CM tryLockRevoke blocked preserving type .d [.lx...lx] pid .d" },
{ 701088176, "CM tryLockRevoke returning token type .d, id .lx,,.lx, flags .#lx" },
{ 701088177, "CM cm_Analyze: conn .x, code .d, pag .x, fid .x..x..x..x" },
{ 701088178, "CM cm_AdjustSize: dcp .x has chunkBytes .x, startDirty .x, endDirty .x" },
{ 701088179, "CM cm_AdjustSize: newSize .x: now chunkBytes .x, startDirty .x, endDirty .x" },
{ 701088180, "CM cm_QuickDiscard: dcp .x starts with chunkBytes .x, startDirty .x, endDirty .x" },
{ 701088181, "CM cm_SetChunkDirtyRange: dcp .x starts with startDirty .x, endDirty .x" },
{ 701088182, "CM cm_SetChunkDirtyRange: given start=.x, end=.x; ends with startDirty .x, endDirty .x" },
{ 701088183, "CM cm_HotWireSegment: scp .x, dcp .x, offset .x, checkLength .x" },
{ 701088184, "CM cm_HotWireSegment: dcp .x (being hotwired) starts with chunkBytes .x, startDirty .x, endDirty .x" },
{ 701088185, "CM cm_MergeStatus(.x): overwriting our cached .lu,,.lu with low half of .lu,,.lu" },
{ 701088186, "CM cm_GetDOnLine: scp length now 0,,.#x, chunk start .x, chunkBytes .x" },
{ 701088187, "CM cm_Conn: conn .x already in use (callCount .d); recycling." },
{ 701088188, "CM mark TGT expired for pag .x" },
{ 701088189, "CM TGTLifeTime(pag .x) gives time .x, expired .d" },
{ 701088190, "CM cm_ReactToAuthCodes: conn .x, authn .d, authz .d" },
{ 701088191, "CM cm_ReactToAuthnCodes: server .x (.d...d): max goes to .d" },
{ 701088192, "CM cm_ReactToAuthnCodes: server .x (.d...d): min goes to .d" },
{ 701088193, "CM cm_ReactToAuthnCodes: volume .x (.d...d): max goes to .d" },
{ 701088194, "CM cm_ReactToAuthnCodes: volume .x (.d...d): min goes to .d" },
{ 701088195, "CM cm_Conn: volp .x, cell flags .d: authn LB .d exceeds UB .d" },
{ 701088196, "CM cm_Conn: volp .x, cell flags .d: authn LB .d >none (UB .d), but authz NONE" },
{ 701088197, "CM cm_Conn: volp .x, cell flags .d: authn .d raised to LB .d" },
{ 701088198, "CM cm_Conn: volp .x, cell flags .d: authn .d lowered to UB .d" },
{ 701088199, "CM cm_Conn: giving up.  forceUnauth .d, exp'd .d, authn .d, authz .d" },
{ 701088200, "CM cm_ConnByAddr using conn .x, service .#x, authn .d, authz .d" },
{ 701088201, "CM cm_ConnByAddr authenticating conn .x: result .d, authn .d, authz .d" },
{ 701088202, "CM cm_InstallVolumeEntry: volume .lu,,.lu has bad min/max auth limits: min .d, max .d" },
{ 701088203, "CM GCOldConn: GCing tgt entry .x with pag .x, time .d, flags .#x" },
{ 701088204, "CM newtgt(pag .x, lifetime .x) called" },
{ 701088205, "CM newtgt(): lifeTime expired: returning EINVAL" },
{ 701088206, "CM newtgt(): mypag .x, pag .x: not super-user, so returning EACCES" },
{ 701088207, "CM cm_ConnByAddr: isExp .d, cached conn expiry .d, forceUnauth .d: restarting." },
{ 701088208, "CM cm_ConnByAddr: unsupported_authn: taking maxSupp from .d to .d; LB currently .d" },
{ 701088209, "CM cm_ReactToAuthCodes: unsupported_authn: taking maxSupp from .d to .d; LB currently .d" },
{ 701088210, "CM cm_ReactToAuthnCodes: raised LB .d -> .d but cannot raise UB .d past maxSupp .d" },
{ 701088211, "CM cm_PCreateMountPoint: vnode .x" },
{ 701088212, "CM cm_PCreateMountPoint returns code .d" },
{ 701088213, "CM cm_AddrRankPut(addr=.#lx, svc=.ld, rank=.ld)" },
{ 701088214, "CM cm_AddrRankGet(addr=.#lx, svc=.ld) yields rank=.ld returning .ld" },
{ 701088215, "CM cm_AddrRankCompute(addr=.#lx) returning .ld" },
{ 701088216, "CM cm_SiteAlloc(svc=.ld, addrvp=.#lx, addrvcnt=.ld)" },
{ 701088217, "CM cm_SiteAlloc(svc=.ld, addrvp=.#lx) returns sitep=.#lx" },
{ 701088218, "CM cm_SiteAddrReplace(sitep=.#lx, addrvp=.#lx, addrvcnt=.ld)" },
{ 701088219, "CM cm_SiteAddrReplace(sitep=.#lx) same addrs, returning" },
{ 701088220, "CM cm_SiteAddrReplace(sitep=.#lx) returning" },
{ 701088221, "CM SiteAddrUpdate(sitep=.#lx) same-addr=.ld, new-addr=.ld" },
{ 701088222, "CM SiteAddrUpdate(sitep=.#lx) addr-gen bumped to=.ld" },
{ 701088223, "CM cm_SiteAddrSetRankAll(addr=.#lx, svc=.ld, rank=.ld)" },
{ 701088224, "CM cm_SiteAddrSetRankAll(addr=.#lx) setting for sitep=.#lx" },
{ 701088225, "CM cm_SiteAddrSetRankAll(addr=.#lx) addr-gen bumped to=.ld" },
{ 701088226, "CM cm_SiteAddrSetRankAll(addr=.#lx) returning" },
{ 701088227, "CM cm_SiteAddrDown(sitep=.#lx, addr=.#lx)" },
{ 701088228, "CM cm_SiteAddrDown(sitep=.#lx) addr-gen bumped to=.ld" },
{ 701088229, "CM cm_SiteAddrDown(sitep=.#lx) returning .ld" },
{ 701088230, "CM cm_SiteAddrUp(sitep=.#lx, addr=.#lx)" },
{ 701088231, "CM cm_SiteAddrUp(sitep=.#lx) addr-gen bumped to=.ld" },
{ 701088232, "CM cm_SiteAddrUp(sitep=.#lx) returning" },
{ 701088233, "CM cm_SiteAddrMarkAllUp(sitep=.#lx, ifAllDown=.ld)" },
{ 701088234, "CM cm_SiteAddrMarkAllUp(sitep=.#lx) addr-gen bumped to=.ld" },
{ 701088235, "CM cm_SiteAddrMarkAllUp(sitep=.#lx) returning" },
{ 701088236, "CM cm_ConnByMHosts(service=.#lx) last-server info reused" },
{ 701088237, "CM cm_ConnByMHosts(service=.#lx) try-addr=.#lx, got-addr=.#lx, successful, returning connp=.#lx" },
{ 701088238, "CM cm_ConnByMHosts: addr or host gen count change noticed" },
{ 701088239, "CM cm_ConnByHost(service=.#lx) try-addr=.#lx, got-addr=.#lx, with result connp=.#lx" },
{ 701088240, "CM cm_ReviveAddrsForServers() entered" },
{ 701088241, "CM cm_ReviveAddrsForServers() returning" },
{ 701088242, "CM ReviveAddrsForServer(serverp=.#lx) entered" },
{ 701088243, "CM ReviveAddrsForServer(serverp=.#lx) in progress, returning" },
{ 701088244, "CM ReviveAddrsForServer(serverp=.#lx) no conn for addr=.#lx" },
{ 701088245, "CM ReviveAddrsForServer(serverp=.#lx) tried addr=.#lx with result code=.ld" },
{ 701088246, "CM ReviveAddrsForServer(serverp=.#lx) returning" },
{ 701088247, "CM cm_FxRepAddrFetch() entered" },
{ 701088248, "CM cm_FxRepAddrFetch() queue request failed" },
{ 701088249, "CM cm_FxRepAddrFetch() returning" },
{ 701088250, "CM FxRepAddrFetch(fxserverp=.#lx, repserverp=.#lx) entered" },
{ 701088251, "CM FxRepAddrFetch() unable to get conn" },
{ 701088252, "CM FxRepAddrFetch() start VL_GetSiteInfo()" },
{ 701088253, "CM FxRepAddrFetch() end VL_GetSiteInfo(), code=.ld" },
{ 701088254, "CM FxRepAddrFetch(fxserverp=.#lx, repserverp=.#lx) returning" },
{ 701088255, "CM 64-bit server (.p) maxFileSize is .#x,,.#x" },
{ 701088256, "CM 32-bit server (.p) maxFileSize is .#x,,.#x" },
{ 701088257, "CM mergestatus length .u,,.u too long" },
{ 701088258, "CM cm_SiteAddrRankOverride(sitep=.#lx, addr=.#lx) entered" },
{ 701088259, "CM cm_SiteAddrRankOverride(sitep=.#lx) addr-gen bumped to=.ld" },
{ 701088260, "CM cm_SiteAddrRankOverride(sitep=.#lx) returning" },
{ 701088261, "CM cm_ReactToBindAddrChange(connp=.#lx, doOverride=.ld) conn-addr=.#lx, bind-addr=.#lx" },
{ 701088262, "CM cm_ReactToBindAddrChange(connp=.#lx, doOverride=.ld) err getting addr=.ld" },
{ 701088263, "CM running cm_ResetAuthnForServers()" },
{ 701088264, "CM .s" },
{ 701088265, "CM addacl entry: vp .x; conn flags .x, pag .x, uid .x" },
{ 701088266, "CM getaclcache entry: vp .x; conn flags .x, pag .x, uid .x" },
{ 701088267, "CM conn .x, authn .d authz .d: setting rreq connflags to .x" },
{ 701088268, "CM cm_FlushTransient flushing name .s in dir .#x for error .d" },
{ 701088269, "CM cm_readdir: nonzero tag .d or highoffset .d (node .d, name `.s'); returning ERANGE" },
{ 701088270, "CM cm_lockctl: vp .#x, whence .d, start .lld len .lld" },
{ 701088271, "CM cm_SetLockF vp .x, type .x, start .lld, lastbyte .lld" },
{ 701088272, "CM tryLockRevoke preserving .lx: type .d, [.llx...llx]" },
{ 701088273, "CM tryLockRevoke blocked preserving type .d [.llx...llx] pid .d" },
{ 701088274, "CM releaselockf vp .x, type .x, start .lld, lastbyte .lld" },
{ 701088275, "CM start  AFS_FetchData at position .lld" },
{ 701088276, "CM cm_GetDOnLine: scp length now .#llx, chunk start .llx, chunkBytes .x" },
{ 701088277, "CM TruncateAllSegments truncating vp .x to .lld" },
{ 701088278, "CM bulkstat: offset .lld out of range .d,,.d" },
{ 701088279, "CM cache fetch proc dcp .x, new pos .lld" },
{ 701088280, "CM waiting for data to arrive, validPos is .lld" },
{ 701088281, "CM cm_write calls cm_FindDCache(scp=.#x, pos=.#llx), returns EIO" },
{ 701088282, "CM cm_write calls DoPartialWrite(scp=.#x, lastoffs=.#llx...): code .d" },
{ 701088283, "CM read starting prefetch for offset .lld" },
{ 701088284, "CM cm_HotWireSegment: scp .x, dcp .x, offset .llx, checkLength .llx" },
{ 701088285, "CM pagein vp .x off .llx len .x rw=.d" },
{ 701088286, "CM vmrw vp .x, write=.d, off=.#llx, len=.#x" },
{ 701088287, "CM cm_putapage throwing away page past EOF. scp .x length .x offset .llx" },
{ 701088288, "CM pageout vp .x off .llx len .x flags=.x" },
{ 701088289, "CM at len=.d; kluster got page, offset .llu, delta .d, hilim .llu" },
{ 701088290, "CM writing past end-of-world: biggest .lu,,.lu, first .lu,,.lu, last .lu,,.lu; EFBIG." },
{ 701088291, "CM truncing past end-of-world: biggest .lu,,.lu, this .lu,,.lu; EFBIG." },
{ 701088292, "CM page-writing past EOW: start .llx past limit .llx; resid .ld; EFBIG." },
{ 701088293, "CM set online token ID for vp .x, dcp .x, to .#x,,.#x" },
{ 701088294, "CM set online tokID for dcp .x to .#x,,.#x (input id .#x,,.#x)" },
{ 701088295, "CM found token match, id .#x,,.#x, [.#x,,.#x .. .#x,,.#x], type .#x" },
{ 701088296, "CM cm_HotWireSegment ... has tokenID .#x,,.#x, flags .#x, validPos .lld" },
{ 701088297, "CM HaveTokensRange uses tokid .#x,,.#x types .#x to satisfy part of .#x requested" },
{ 701088298, "CM HaveTokensRange uses tokid .#x,,.#x types .#x to satisfy part of .#x requested ..." },
{ 701088299, "CM HaveTokensRange uses tokid .#x,,.#x types .#x to MATCH .#x requested ..." },
{ 701088300, "CM ... since its range [.#x,,.#x .. .#x,,.#x] covers requested [.#x,,.#x .. .#x,,.#x]" },
{ 701088301, "CM ... revoking range [.#x,,.#x .. .#x,,.#x]" },
{ 701088302, "CM cm_MergeStatus: current serverchg .d..06d; incoming chg .d..06d" },
{ 701088303, "CM cm_ConnByAddr authenticating conn .x: principal .s, addr .x" },
{ 701088304, "CM cm_ConnByAddr: creating conn type .#x, addr .x, conn .x" },
{ 701088305, "CM cm_ConnByAddr server type .#x, serverp .x, addr .x" },
{ 701088306, "CM ran minor renewlazyrep, vol .x, .d,,.u" },
{ 701088307, "CM in cm_GetDownD, flags .#x, number .d, discards=.d" },
{ 701088308, "CM cm_GetDownD: found .d entries in initial scan" },
{ 701088309, "CM in cm_GetDownD, discarding .d" },
{ 701088310, "CM in cm_GetDownD, GC .d" },
{ 701088311, "CM in cm_GetDownD, get it all .d" },
{ 701088312, "CM in cm_GetDownD, will reclaim .d" },
{ 701088313, "CM in cm_GetDownD, discard 1" },
{ 701088314, "CM in cm_GetDownD, freed .d" },
{ 701088315, "CM calling VL_GetEntryByID without commit requested, type .d" },
{ 701088316, "CM cm_ReactToAuthnCodes: rreq (.d...d): max goes to .d" },
{ 701088317, "CM cm_ReactToAuthnCodes: rreq (.d...d): min goes to .d" },
{ 701088318, "CM bulkstat: another change raced ahead of us (cached .d..06d != incoming .d..06d)" },
{ 701088319, "CM truncating(cm_GetDownD), count of discarded chunks is .d, should be 0" },
{ 701088320, "CM in cm_GetDownD, too many flags set on discarded chunk: .x" },
{ 701088321, "CM in cm_GetDownD, refcount .d on discarded chunk, should be 0" },
{ 701088322, "CM cm_ConnByAddr: unsupported_authn: maxsuppAuthn mask now .#x; LB currently .d" },
{ 701088323, "CM cm_Conn: server .x, unsupp mask .#x: NOTHING in [.d...d]" },
{ 701088324, "CM cm_ConnByHost: (try-addr=.#lx, svc=.ld, rank = never)" },
{ 701088325, "CM cm_SiteAddrRankOverride: Address .#lx assigned new rank .ld (old rank = never)" },
{ 701088326, "CM .s: no server (IP .#x, UUID .x/.x/.x/.x)" },
{ 701088327, "CM GuessServer: server .x uses 1024-byte blocks based on fid .x..x..x..x length .lld, blocksUsed .ld" },
{ 701088328, "CM GuessServer: server .x uses 512-byte blocks based on fid .x..x..x..x length .lld, blocksUsed .ld" },
{ 701088329, "CM GuessServer: volume .x (fid .x..x..x..x) min alloc is .d (from blocksUsed=.d)" },
{ 701088330, "CM cm_PurgeExtraData: dcp .x at pos .#llx can use toktype .d of token .x,,.x" },
{ 701088331, "CM cm_JettisonUnwantedTokens: dumping types .x of token .x,,.x; .x left" },
{ 701088332, "CM cm_JettisonUnwantedTokens done with scp .x (server .x): still need .x whole-file types and .x subrange types" },
{ 701088333, "CM cm_PurgeExtraLocks: scp .x may need token .x,,.x range [.llx .. .llx] ..." },
{ 701088334, "CM cm_PurgeExtraLocks: ... types .x to handle locktype .x, [.llx...llx]" },
{ 701088335, "CM cm_VerifyNeededLocks: UNSATISFIED LOCK for scp .x, locktype .x, [.llx...llx]" },
{ 701088336, "CM cm_VerifyNeededData: UNSATISFIED DATA for scp .x, tokentype .x, [.x,,.x .. .x,,.x] ..." },
{ 701088337, "CM cm_VerifyNeededData: ... dcp .x, flags .x, started at .x,,.x" },
{ 701088338, "CM cm_RecoverSCacheToken: scp .x, tokid .x,,.x, adding required whole-file types .x to existing .x" },
{ 701088339, "CM cm_RecoverSCacheToken: scp .x, tokid .x,,.x, restricting token types .x to needed .x" },
{ 701088340, "CM cm_RecoverSCacheToken: scp .x, got tokid .x,,.x; no longer need whole-file bits .x of .x" },
{ 701088341, "CM cm_RecoverSCacheToken: got whole-file tokid .x,,.x; no longer need bits .x in whole-file .x or range .x" },
{ 701088342, "CM mark pag .x .d? gone : expired" },
{ 701088343, "CM cm_ConnByMHosts simply delaying for .d seconds" },
{ 701088344, "CM cm_RemoveFromParentVDir: Attempting to remove scp .x, name '.s', vdirp states .x" },
{ 701088345, "CM cm_RemoveFromParentVDir: Removed scp .x, name '.s', from pvp .x; vdirp states .x" },
{ 701088346, "CM cm_IdleSCaches: beginning to idle stat cache" },
{ 701088347, "CM cm_IdleSCaches: Failed to flush cm_rootVnode scp .x" },
{ 701088348, "CM cm_IdleSCaches: Finished, returning .d, with .d retries left, and SLRU .s empty" },
{ 701088349, "CM cm_Analyze: sleep interrupted" },
{ 701088350, "CM getdcache found vp .x, chunk .d in dcp .x, slot .x" },
{ 701088351, "CM getndcaches put vp .x, chunk .d in dcp .x, slot .x" },
{ 701088352, "CM in flushDCache, dcp .x, slot .x" },
{ 701088353, "CM faking 0 byte entry locally, version .u,,.u" },
{ 701088354, "CM fetchdcache finishing: setting dcp .x, slot .x to have dv version .u,,.u" },
{ 701088355, "CM cm_GetDOnLine: Checking for fetch: scp dv .lu,,.lu, dcp dv .lu,,.lu, scp type .ld, slot .x" },
{ 701088356, "CM invalidateoneseg vp .x, dcp .x, slot .x" },
{ 701088357, "CM clearing online state for vp .x, dcp .x, slot .x" },
{ 701088358, "CM reading dcp .x from file slot .x: version .u,,.u, token .x,,.x" },
{ 701088359, "CM reading file slot .x into a temp buffer: version .u,,.u, token .x,,.x" },
{ 701088360, "CM storing dcp .x (dv .u,,.u) into file slot .x: result .d" },
{ 701088361, "CM VM writing=.d at .llx: data .08x-.08x (.d bytes max)" },
{ 701088362, "CM PUSH accepting at position .llx: data .08x-.08x (.d bytes max)" },
{ 701088363, "CM PULL sending from chunk position .lx: data .08x-.08x (.d bytes max)" },
{ 701088364, "CM memcache read at .lx: data .08x-.08x (.d bytes max)" },
{ 701088365, "CM memcache write at .lx: data .08x-.08x (.d bytes max)" },
{ 701088366, "CM cm_GetTokensRange(vp .x): restricting renewal of token .x from .x to requested bits (id .x,,.x)" },
{ 701088367, "CM cm_GetTokensRange(vp .x): seeking .x; STATUS_READ not held; dropping token .x,,.x with rights .x" },
{ 701088368, "CM cm_GetTokensRange(vp .x): seeking .x; STATUS_READ *is* held; accepting token .x,,.x with rights .x" },
{ 701088369, "CM cm_GetTokensRange(vp .x): seeking .x; STATUS_READ *revoked*; dropping STATUS_READ from token .x,,.x with rights .x" },
{ 701088370, "CM cm_TerminateTokenGrant: count decrs to .d, my seq is .d,,.d" },
{ 701088371, "CM cm_TerminateTokenGrant: oldest seq is .d,,.d; .d freed, .d remaining" },
{ 701088372, "CM TokenGrant: seq .d,,.d had revoked bits .x in ID .#x,,.#x, reducing incoming bits .x" },
{ 701088373, "CM Update async cred: credp .x, pag .x" },
{ 701088374, "CM cm_map: vp .x, flags .x" },
{ 701088375, "FS_Attach entry, opcode_mode 0x.x" },
{ 701088376, "FS_Attach exit, return code 0x.x" },
{ 701088377, "FS_CHDIR entry, opcode_mode 0x.x" },
{ 701088378, "FS_CHDIR exit, return code 0x.x" },
{ 701088379, "FS_CHFILEPTR entry, opcode_mode 0x.x" },
{ 701088380, "FS_CHFILEPTR exit, return code 0x.x" },
{ 701088381, "FS_CLOSE entry, opcode_mode 0x.x" },
{ 701088382, "FS_CLOSE exit, return code 0x.x" },
{ 701088383, "FS_COMMIT entry, opcode_mode 0x.x" },
{ 701088384, "FS_COMMIT exit, return code 0x.x" },
{ 701088385, "FS_COPY entry, opcode_mode 0x.x" },
{ 701088386, "FS_COPY exit, return code 0x.x" },
{ 701088387, "FS_DELETE entry, opcode_mode 0x.x" },
{ 701088388, "FS_DELETE exit, return code 0x.x" },
{ 701088389, "FS_EXIT entry, opcode_mode 0x.x" },
{ 701088390, "FS_EXIT exit, return code 0x.x" },
{ 701088391, "FS_FILEATTRIBUTE entry, opcode_mode 0x.x" },
{ 701088392, "FS_FILEATTRIBUTE exit, return code 0x.x" },
{ 701088393, "FS_FILEINFO entry, opcode_mode 0x.x" },
{ 701088394, "FS_FILEINFO exit, return code 0x.x" },
{ 701088395, "FS_FILEIO entry, opcode_mode 0x.x" },
{ 701088396, "FS_FILEIO exit, return code 0x.x" },
{ 701088397, "FS_FINDCLOSE entry, opcode_mode 0x.x" },
{ 701088398, "FS_FINDCLOSE exit, return code 0x.x" },
{ 701088399, "FS_FINDFIRST entry, opcode_mode 0x.x" },
{ 701088400, "FS_FINDFIRST exit, directory handle 0x.x, return code 0x.x" },
{ 701088401, "FS_FINDFROMNAME entry, opcode_mode 0x.x" },
{ 701088402, "FS_FINDFROMNAME exit, return code 0x.x" },
{ 701088403, "FS_FINDNEXT entry, directory handle 0x.x, opcode_mode 0x.x" },
{ 701088404, "FS_FINDNEXT exit, directory handle 0x.x, return code 0x.x" },
{ 701088405, "FS_FINDNOTIFYCLOSE entry, opcode_mode 0x.x" },
{ 701088406, "FS_FINDNOTIFYCLOSE exit, return code 0x.x" },
{ 701088407, "FS_FINDNOTIFYFIRST entry, opcode_mode 0x.x" },
{ 701088408, "FS_FINDNOTIFYFIRST exit, return code 0x.x" },
{ 701088409, "FS_FINDNOTIFYNEXT entry, opcode_mode 0x.x" },
{ 701088410, "FS_FINDNOTIFYNEXT exit, return code 0x.x" },
{ 701088411, "FS_FLUSHBUF entry, opcode_mode 0x.x" },
{ 701088412, "FS_FLUSHBUF exit, return code 0x.x" },
{ 701088413, "FS_FSCTL entry, opcode_mode 0x.x" },
{ 701088414, "FS_FSCTL exit, return code 0x.x" },
{ 701088415, "FS_FSINFO entry, opcode_mode 0x.x" },
{ 701088416, "FS_FSINFO exit, return code 0x.x" },
{ 701088417, "FS_INIT entry, opcode_mode 0x.x" },
{ 701088418, "FS_INIT exit, return code 0x.x" },
{ 701088419, "FS_IOCTL entry, opcode_mode 0x.x" },
{ 701088420, "FS_IOCTL exit, return code 0x.x" },
{ 701088421, "FS_MKDIR entry, opcode_mode 0x.x" },
{ 701088422, "FS_MKDIR exit, return code 0x.x" },
{ 701088423, "FS_MOUNT entry, opcode_mode 0x.x" },
{ 701088424, "FS_MOUNT exit, return code 0x.x" },
{ 701088425, "FS_MOVE entry, opcode_mode 0x.x" },
{ 701088426, "FS_MOVE exit, return code 0x.x" },
{ 701088427, "FS_NEWSIZE entry, opcode_mode 0x.x" },
{ 701088428, "FS_NEWSIZE exit, return code 0x.x" },
{ 701088429, "FS_NMPIPE entry, opcode_mode 0x.x" },
{ 701088430, "FS_NMPIPE exit, return code 0x.x" },
{ 701088431, "FS_OPENCREATE entry, opcode_mode 0x.x" },
{ 701088432, "FS_OPENCREATE exit, return code 0x.x" },
{ 701088433, "FS_PATHINFO entry, opcode_mode 0x.x" },
{ 701088434, "FS_PATHINFO exit, return code 0x.x" },
{ 701088435, "FS_PROCESSNAME entry, opcode_mode 0x.x" },
{ 701088436, "FS_PROCESSNAME exit, return code 0x.x" },
{ 701088437, "FS_READ entry, opcode_mode 0x.x" },
{ 701088438, "FS_READ exit, return code 0x.x" },
{ 701088439, "FS_RMDIR entry, opcode_mode 0x.x" },
{ 701088440, "FS_RMDIR exit, return code 0x.x" },
{ 701088441, "FS_SETSWAP entry, opcode_mode 0x.x" },
{ 701088442, "FS_SETSWAP exit, return code 0x.x" },
{ 701088443, "FS_SHUTDOWN entry, opcode_mode 0x.x" },
{ 701088444, "FS_SHUTDOWN exit, return code 0x.x" },
{ 701088445, "FS_WRITE entry, opcode_mode 0x.x" },
{ 701088446, "FS_WRITE exit, return code 0x.x" },
{ 701088447, "FS_DEBUG entry, opcode_mode 0x.x" },
{ 701088448, "FS_DEBUG exit, return code 0x.x" },
{ 701088449, "FS_AlLOCATEPAGESPACE entry, opcode_mode 0x.x" },
{ 701088450, "FS_AlLOCATEPAGESPACE exit, return code 0x.x" },
{ 701088451, "FS_DOPAGEIO entry, opcode_mode 0x.x" },
{ 701088452, "FS_DOPAGEIO exit, return code 0x.x" },
{ 701088453, "FS_CANCELLOCKREQUEST entry, opcode_mode 0x.x" },
{ 701088454, "FS_CANCELLOCKREQUEST exit, return code 0x.x" },
{ 701088455, "FS_FILELOCKS entry, opcode_mode 0x.x" },
{ 701088456, "FS_FILELOCKS exit, return code 0x.x" },
{ 701088457, "FS_OPENPAGEFILE entry, opcode_mode 0x.x" },
{ 701088458, "FS_OPENPAGEFILE exit, return code 0x.x" },
{ 701088459, "FS unknown opcode entry, opcode_mode 0x.x" },
{ 701088460, "FS unknown opcode exit, opcode_mode 0x.x, return code 0x.x" },
{ 701088461, "CM cm_StoreDCache start store, chunk .d, len .d, smask .x" },
{ 701202433, "dmb_Init_Routine called" },
{ 701202434, "NewSession: no old session id .d: code .d" },
{ 701202435, "findSession: no old session id .d: returning EINVAL" },
{ 701202436, "stashIdent: xcred (.#x) but no EPAC: code .d" },
{ 701202437, "stashIdent: auth .d of .d, .d gps, overflow at .d bytes" },
{ 701202438, "stashIdent: auth .d, fgs .d of .d, overflow at .d bytes" },
{ 701202439, "HandleToFs: discr .d not a FS; flags .#x, so returning EINVAL" },
{ 701202440, "HandleToFs: discr .d not a file; flags .#x, so returning EINVAL" },
{ 701202441, "HandleToFs: aggrId .d not found; returning EBADF" },
{ 701202442, "HandleToFile: discr .d, returning .d" },
{ 701202443, "GetRefs: sid is DM_NO_SESSION, so returning EINVAL" },
{ 701202444, "GetRefs: flags .#x (incl. NOFS), but fp .#x is FS, so returning EINVAL" },
{ 701202445, "GetRefs: flags .#x (incl. NOFILE), but fp .#x is file, so returning EINVAL" },
{ 701202446, "GetRefs: flags .#x (incl. NEEDX), but fp .#x is not xlocked (.#x), so returning EACCES" },
{ 701202447, "GetRefs: flags .#x (incl. NEEDS), but fp .#x is not slocked (.#x), so returning EACCES" },
{ 701202448, "GetRefs: file not found on list for token .d, so returning EINVAL" },
{ 701202449, "GetRefs: token .d not found on list for session .d, so returning EINVAL" },
{ 701202450, "SetDisp: evset .x,,.x includes MOUNT event on non-global FS: EINVAL" },
{ 701202451, "SetDisp: evset .x,,.x includes non-MOUNT event on global FS: EINVAL" },
{ 701202452, "ObjRefOp: op .d, result .d" },
{ 701202453, "ThingToHdl: path .s, result .d" },
{ 701202454, "ThingToHdl: fd .d isn't, code .d" },
{ 701202455, "ThingToHdl: agfs result .d" },
{ 701202456, "ThingToHdl: non-agfs given; code .d" },
{ 701202457, "dmb_Pending(sid .d, token .d, .d secs): returns .d" },
{ 701202458, "dmb_GetTokenAuth(sid .d, token .d): output length .d, code .d" },
{ 701202459, "dmb_SetAcl: src .#x is FS, not file; returning EINVAL" },
{ 701202460, "dmb_SetAcl: src .#x NEEDX (flags .#x); returning EACCES" },
{ 701202461, "dmb_DirNToHdl: string length (.d) wrong: returning EINVAL" },
{ 701202462, "MoveEvent returning .d" },
{ 701202463, "SendEvent: event id .d, type .d, state .d, session flags .#x" },
{ 701202464, "AwaitReply: event id .d, type .d, state .d: about to wait" },
{ 701202465, "AwaitReply: event id .d, type .d, response .d, errcode .d" },
{ 701202466, "PollReply finishes: event id .d, type .d; response .d, errcode .d" },
{ 701202467, "ExchangeMountEvent: aggrid .d session .#x, response .d, errcode .d)" },
{ 701202468, "ExchangeMountEvent: SILLY answer for aggrid .d (sp .#x, response .d, errcode .d)" },
{ 701202469, "LockOp: op .d, flags currently .#x, desiring .#x; result pre-set to .d" },
{ 701202470, "dmab error conversion code .d to .d" },
{ 701202471, "GetRefs: result code .d" },
{ 701202472, "NewBareEvent: event id .d, type .d, pairid .d" },
{ 701202473, "RespondEvent finishes: event id .d, type .d; response .d, errcode .d" },
{ 701202474, "dmb_GetBulkAll: xflags .#x" },
{ 701202475, "dmb_GetBulkAttr: xflags .#x" },
{ 701202476, "dmb_GetDirAttrs: xflags .#x" },
{ 701218817, "ag_dmepiAttach: dev .#x, vnode .x" },
{ 701218818, "ag_dmepiAttach: internal error .d" },
{ 701218819, "ag_dmepiAttach: sub-attach returns code .d" },
{ 701218820, "ag_dmepiAttach: no ops vector for type .d" },
{ 701218821, "ag_dmepiAttach: returning .d" },
{ 701218822, "ag_dmepiDetach: aggr .#x" },
{ 701218823, "ag_dmepiDetach: returning .d" },
{ 701218824, "ag_dmepiStat: aggr .#x" },
{ 701218825, "ag_dmepiStat: returning .d" },
{ 701218826, "ag_dmepiVolCreate: aggr .#x, vid .u,,.u, flags .#x" },
{ 701218827, "ag_dmepiVolCreate: returning .d" },
{ 701218828, "ag_dmepiVolInfo: aggr .#x, index .d" },
{ 701218829, "ag_dmepiVolInfo: returning .d" },
{ 701218830, "ag_dmepiSync: aggr .#x, type .d" },
{ 701218831, "ag_dmepiSync: returning .d" },
{ 701218832, "vol_dmepiOpen: volp .#x, opentype .d, openerr .#x" },
{ 701218833, "vol_dmepiOpen: volp .#x, myconcurr .d, subconcurr .d" },
{ 701218834, "vol_dmepiOpen: returning .d" },
{ 701218835, "vol_dmepiScan: volp .#x, position .d" },
{ 701218836, "vol_dmepiScan: returning .d" },
{ 701218837, "vol_dmepiClose: volp .#x, isAbort .d" },
{ 701218838, "vol_dmepiClose: returning .d" },
{ 701218839, "vol_dmepiDeplete: volp .#x" },
{ 701218840, "vol_dmepiDeplete: returning .d" },
{ 701218841, "vol_dmepiDestroy: volp .#x" },
{ 701218842, "vol_dmepiDestroy: returning .d" },
{ 701218843, "vol_dmepiAttach: volp .#x" },
{ 701218844, "vol_dmepiAttach: returning .d" },
{ 701218845, "vol_dmepiDetach: volp .#x, anyForce .d" },
{ 701218846, "vol_dmepiDetach: returning .d" },
{ 701218847, "vol_dmepiGetStatus: volp .#x, statusp .#x" },
{ 701218848, "vol_dmepiGetStatus: returning .d" },
{ 701218849, "vol_dmepiSetStatus: volp .#x, mask .#x, statusp .#x" },
{ 701218850, "vol_dmepiSetStatus: returning .d" },
{ 701218851, "vol_dmepiCreate: volp .#x, position .d" },
{ 701218852, "vol_dmepiCreate: returning .d" },
{ 701218853, "vol_dmepiRead: volp .#x, position .d,,.d, length .d" },
{ 701218854, "vol_dmepiRead: returning .d, len .d" },
{ 701218855, "vol_dmepiWrite: volp .#x, fid .x..x..x..x, position .d,,.d, length .d" },
{ 701218856, "vol_dmepiWrite: returning .d" },
{ 701218857, "vol_dmepiReadHole: volp .#x, fid .x..x..x..x, holedesc .#x" },
{ 701218858, "vol_dmepiReadHole: returning .d" },
{ 701218859, "vol_dmepiTruncate: volp .#x, fid .x..x..x..x, new size .d,,.d" },
{ 701218860, "vol_dmepiTruncate: returning .d" },
{ 701218861, "vol_dmepiDelete: volp .#x, fid .x..x..x..x" },
{ 701218862, "vol_dmepiDelete: returning .d" },
{ 701218863, "vol_dmepiGetattr: volp .#x, fid .x..x..x..x" },
{ 701218864, "vol_dmepiGetattr: returning .d" },
{ 701218865, "vol_dmepiSetattr: volp .#x, fid .x..x..x..x" },
{ 701218866, "vol_dmepiSetattr: returning .d" },
{ 701218867, "vol_dmepiGetAcl: volp .#x, fid .x..x..x..x, which .d" },
{ 701218868, "vol_dmepiGetAcl: returning .d" },
{ 701218869, "vol_dmepiSetAcl: volp .#x, fid .x..x..x..x, index .d, which .d" },
{ 701218870, "vol_dmepiSetAcl: returning .d" },
{ 701218871, "vol_dmepiClone: volp .#x, vol2p .#x" },
{ 701218872, "vol_dmepiClone: returning .d" },
{ 701218873, "vol_dmepiReclone: volp .#x, vol2p .#x" },
{ 701218874, "vol_dmepiReclone: returning .d" },
{ 701218875, "vol_dmepiUnclone: volp .#x, vol2p .#x" },
{ 701218876, "vol_dmepiUnclone: returning .d" },
{ 701218877, "vol_dmepiVget: volp .#x, fid .x..x..x..x" },
{ 701218878, "vol_dmepiVget: returning .d, vnode .#x" },
{ 701218879, "vol_dmepiRoot: volp .#x" },
{ 701218880, "vol_dmepiRoot: returning .d, vnode .#x" },
{ 701218881, "vol_dmepiIsRoot: volp .#x, fid .x..x..x..x" },
{ 701218882, "vol_dmepiIsRoot: returning .d, flag .d" },
{ 701218883, "vol_dmepiGetVV: volp .#x" },
{ 701218884, "vol_dmepiGetVV: returning .d, vv .d,,.d" },
{ 701218885, "vol_dmepiSetDyStat: volp .#x" },
{ 701218886, "vol_dmepiSetDyStat: returning .d" },
{ 701218887, "vol_dmepiSetNewVID: volp .#x, id .d,,.d" },
{ 701218888, "vol_dmepiSetNewVID: returning .d" },
{ 701218889, "vol_dmepiCopyAcl: volp .#x, fid .x..x..x..x, dest .d, ix .d" },
{ 701218890, "vol_dmepiCopyAcl: returning .d" },
{ 701218891, "vol_dmepiFreeDyStat: volp .#x" },
{ 701218892, "vol_dmepiFreeDyStat: returning .d" },
{ 701218893, "vol_dmepiConcurr: volp .#x, myconcurr .d, subconcurr .d" },
{ 701218894, "vol_dmepiSwapIDs: volp .#x/id .d,,.d, volp .#x/id .d,,.d" },
{ 701218895, "vol_dmepiSwapIDs: returning .d" },
{ 701218896, "vol_dmepiSync: volp .#x, guarantee .d" },
{ 701218897, "vol_dmepiSync: returning .d" },
{ 701218898, "vol_dmepiPushStatus: volp .#x" },
{ 701218899, "vol_dmepiPushStatus: returning .d" },
{ 701218900, "vol_dmepiReaddir: volp .#x, fid .x..x..x..x, position .d,,.d, len .d" },
{ 701218901, "vol_dmepiReaddir: returning .d, numEntries .d" },
{ 701218902, "vol_dmepiAppenddir: volp .#x, fid .x..x..x..x, .d entries, preserve .d" },
{ 701218903, "vol_dmepiAppenddir: returning .d" },
{ 701218904, "vol_dmepiGetZLC: volp .#x, iter .#x" },
{ 701218905, "vol_dmepiGetZLC: returning .d" },
{ 701218906, "vol_dmepiGetNextHoles: volp .#x, fid .x..x..x..x, iter .#x" },
{ 701218907, "vol_dmepiGetNextHoles: returning .d" },
{ 701218908, "vol_dmepiBulkSetStatus: .d volumes" },
{ 701218909, "vol_dmepiBulkSetStatus: returning .d" },
{ 701218910, "getVfs: creating new VFS at .#x to be linked to existing at .#x; now .d exist" },
{ 701218911, "getvNode: vnode .#x already converted" },
{ 701218912, "getvNode: vnode .#x already linked to covered vnode .#x" },
{ 701218913, "getvNode: allocating fresh vnode .#x to cover .#x (.d allocated so far, .d on freelist)" },
{ 701218914, "getvNode: reusing free vnode .#x to cover .#x (.d allocated so far, .d on freelist)" },
{ 701218915, "cvtVnode: NOT converting node .#x: cvted .d, cantCvt .d" },
{ 701218916, "cvtVnode: converting node .#x to node .#x, code .d" },
{ 701218917, "dmvn_open(.#x, .#x): covering .#x" },
{ 701218918, "dmvn_open: returning node .#x, code .d" },
{ 701218919, "dmvn_close(.#x, .#x): covering .#x" },
{ 701218920, "dmvn_close: returning code .d" },
{ 701218921, "dmvn_rdwr(.#x, .d, .d): covering .#x" },
{ 701218922, "dmvn_rdwr: returning code .d" },
{ 701218923, "dmvn_ioctl(.#x, .d, .d): covering .#x" },
{ 701218924, "dmvn_ioctl: returning code .d" },
{ 701218925, "dmvn_select(.#x, .d): covering .#x" },
{ 701218926, "dmvn_select: returning code .d" },
{ 701218927, "dmvn_getattr(.#x, .d): covering .#x" },
{ 701218928, "dmvn_getattr: returning code .d" },
{ 701218929, "dmvn_setattr(.#x, .d): covering .#x" },
{ 701218930, "dmvn_setattr: returning code .d" },
{ 701218931, "dmvn_access(.#x, .d): covering .#x" },
{ 701218932, "dmvn_access: returning code .d" },
{ 701218933, "dmvn_lookup(.#x, .s): covering .#x" },
{ 701218934, "dmvn_lookup: returning code .d" },
{ 701218935, "dmvn_create(.#x, .s, .d): covering .#x" },
{ 701218936, "dmvn_create: returning code .d" },
{ 701218937, "dmvn_remove(.#x, .s): covering .#x" },
{ 701218938, "dmvn_remove: returning code .d" },
{ 701218939, "dmvn_link(.#x, .#x, .s): second node NOT CVTED--use VOPN_LINK" },
{ 701218940, "dmvn_link(.#x, .#x, .s): " },
{ 701218941, "..... covering .#x, .#x: " },
{ 701218942, "dmvn_link: returning code .d" },
{ 701218943, "dmvn_rename(.#x, .s .#x, .s): second node NOT CVTED--use VOPN_RENAME" },
{ 701218944, "dmvn_rename(.#x, .s, .#x, .s): " },
{ 701218945, "..... covering .#x, .#x: " },
{ 701218946, "dmvn_rename: returning code .d" },
{ 701218947, "dmvn_mkdir(.#x, .s): covering .#x" },
{ 701218948, "dmvn_mkdir: returning code .d" },
{ 701218949, "dmvn_rmdir(.#x, .s, .#x): covering .#x" },
{ 701218950, "dmvn_rmdir: returning code .d" },
{ 701218951, "dmvn_readdir(.#x, .d): covering .#x" },
{ 701218952, "dmvn_readdir: returning code .d" },
{ 701218953, "dmvn_symlink(.#x, .s, .s): covering .#x" },
{ 701218954, "dmvn_symlink: returning code .d" },
{ 701218955, "dmvn_readlink(.#x): covering .#x" },
{ 701218956, "dmvn_readlink: returning code .d" },
{ 701218957, "dmvn_fsync(.#x): covering .#x" },
{ 701218958, "dmvn_fsync: returning code .d" },
{ 701218959, "dmvn_inactive(.#x): punt; new ref count .d > 0" },
{ 701218960, "dmvn_inactive(.#x): covers .#x; freeing vp" },
{ 701218961, "dmvn_inactive: freeing vfsp .#x that covers vfsp .#x; .d vfsp's" },
{ 701218962, "dmvn_bmap(.#x, .d): covering .#x" },
{ 701218963, "dmvn_bmap: returning code .d" },
{ 701218964, "dmvn_lockctl(.#x, .d): covering .#x" },
{ 701218965, "dmvn_lockctl: returning code .d" },
{ 701218966, "dmvn_fid(.#x): covering .#x" },
{ 701218967, "dmvn_fid: returning code .d" },
{ 701218968, "dmvn_hold(.#x): covering .#x" },
{ 701218969, "dmvn_hold: returning code .d" },
{ 701218970, "dmvn_rele(.#x): covering .#x" },
{ 701218971, "dmvn_rele: returning code .d" },
{ 701218972, "dmvn_setacl(.#x, .d, .d): covering .#x" },
{ 701218973, ".... (source vp .#x covering .#x) ...." },
{ 701218974, "dmvn_setacl: returning code .d" },
{ 701218975, "dmvn_getacl(.#x, .d): covering .#x" },
{ 701218976, "dmvn_getacl: returning code .d" },
{ 701218977, "dmvn_afsfid(.#x, .d): covering .#x" },
{ 701218978, "dmvn_afsfid: returning code .d" },
{ 701218979, "dmvn_getvolume(.#x): covering .#x" },
{ 701218980, "dmvn_getvolume: returning code .d, volp .#x" },
{ 701218981, "dmvn_getlength(.#x): covering .#x" },
{ 701218982, "dmvn_getlength: returning code .d, length .#llx" },
{ 701218983, "dmvn_map(.#x, .#x, .d): covering .#x" },
{ 701218984, "dmvn_map: returning code .d" },
{ 701218985, "dmvn_unmap(.#x, .d): covering .#x" },
{ 701218986, "dmvn_unmap: returning code .d" },
{ 701218987, "dmvn_read(.#x, .d): covering .#x" },
{ 701218988, "dmvn_read: returning code .d" },
{ 701218989, "dmvn_write(.#x, .d): covering .#x" },
{ 701218990, "dmvn_write: returning code .d" },
{ 701218991, "dmvn_realvp(.#x): covering .#x" },
{ 701218992, "dmvn_realvp: returning vnode .#x, code .d" },
{ 701218993, "dmvn_rwlock(.#x, .d): covering .#x" },
{ 701218994, "dmvn_rwlock: returning" },
{ 701218995, "dmvn_rwunlock(.#x, .d): covering .#x" },
{ 701218996, "dmvn_rwunlock: returning" },
{ 701218997, "dmvn_seek(.#x): covering .#x" },
{ 701218998, "dmvn_seek: returning code .d" },
{ 701218999, "dmvn_space(.#x, .d, .d): covering .#x" },
{ 701219000, "dmvn_space: returning code .d" },
{ 701219001, "dmvn_getpage(.#x, .d): covering .#x" },
{ 701219002, "dmvn_getpage: returning code .d" },
{ 701219003, "dmvn_putpage(.#x, .d): covering .#x" },
{ 701219004, "dmvn_putpage: returning code .d" },
{ 701219005, "dmvn_addmap(.#x, .d): covering .#x" },
{ 701219006, "dmvn_addmap: returning code .d" },
{ 701219007, "dmvn_delmap(.#x, .d): covering .#x" },
{ 701219008, "dmvn_delmap: returning code .d" },
{ 701219009, "dmvn_pageio(.#x, .d): covering .#x" },
{ 701219010, "dmvn_pageio: returning code .d" },
{ 701219011, "dmvn_setfl(.#x, .d, .d): covering .#x" },
{ 701219012, "dmvn_setfl: returning code .d" },
{ 701219013, "dmvn_dispose(.#x, .d, .d): covering .#x" },
{ 701219014, "dmvn_dispose: returning" },
{ 701219015, "dmvn_setsecattr(.#x, .d): covering .#x" },
{ 701219016, "dmvn_setsecattr: returning code .d" },
{ 701219017, "dmvn_getsecattr(.#x, .d): covering .#x" },
{ 701219018, "dmvn_getsecattr: returning code .d" },
{ 701219019, "dmvfs_root(.#x) called" },
{ 701219020, "dmvfs_root: returning code .d, vnode .#x" },
{ 701219021, "dmvfs_statfs(.#x): covering vfs .#x" },
{ 701219022, "dmvfs_statfs: returning code .d" },
{ 701219023, "dmvfs_sync(.#x): covering aggr .#x" },
{ 701219024, "dmvfs_sync: returning code .d" },
{ 701219025, "dmvfs_vget(.#x) called" },
{ 701219026, "dmvfs_vget: returning code .d, vnode .#x" },
{ 701219027, "dmvfs_vfsgetvolume(.#x) called" },
{ 701219028, "dmvfs_vfsgetvolume: returning code .d, volp .#x" },
{ 701219029, "dmvfs_mount(.#x) called; mounted-on vp .x" },
{ 701219030, "dmvfs_mount: returning code .d" },
{ 701219031, "dmvfs_unmount(.#x) called; covered op is .x" },
{ 701219032, "dmvfs_unmount: returning code .d" },
{ 701219033, "vol_dmepiDMWait(vol .#x, .#x) entered" },
{ 701219034, "vol_dmepiDMFree(vol .#x, .#x) entered" },
{ 701219035, "registerDmptr(.#x): tid .#x; .d in use, .d on free list" },
{ 701219036, "unRegisterDmptr(.#x): tid .#x; .d left in use, .d on free list" },
{ 701219037, "InterlockVnop(.#x..): ckbits .#x, adp->flags .#x, vnopflags .#x" },
{ 701219038, "preDetach(aggrp .#x): creating preunmount evt, fsp .#x, ID .d" },
{ 701219039, "preDetach: event created, code .d, pointer .#x" },
{ 701219040, "preDetach: response: .d, retcode .d" },
{ 701219041, "postDetach(aggrp .#x): creating unmount evt, fsp .#x, code .d" },
{ 701219042, "postDetach: event created, code .d, pointer .#x" },
{ 701219043, "postDetach: response received" },
{ 701219044, "dmepi_checkLock(.#x): ckbits .#x in .#x, flags .#x" },
{ 701219045, "dmvn_inactive(.x): covered .x, LOCKED: .x; LC is .d" },
{ 701219046, "endVnop LEAVING dmptr: dmptr .x, evset .x, flags .d" },
{ 701219047, "endVnop reclaiming dmptr: dmptr .x, evset .x, flags .d" },
{ 701219048, "dmwait waiting: dmptr .x, evset .x, flags .d, evp .x" },
{ 701219049, "dmwait--why?: dmptr .x, evset .x, flags .d" },
{ 701219050, "ag_dmepiVolCreate: bailing from CREATE response (.d, code .d)" },
{ 701219051, "throwAttributeEvt: ptr .#x, dt_change now .d, from .s" },
{ 701219052, "eventPre: new type=.d event, pair .d; vp1 .#x, vp2 .#x" },
{ 701219053, "eventPost: new type=.d event, pair .d; vp1 .#x, vp2 .#x" },
{ 701219054, "eventSyncPost: new type=.d event, pair .d; vp1 .#x, vp2 .#x" },
{ 701219055, "checkWhetherDone: expecting wait, pair .d; flags .#x, sequence .d" },
{ 701219056, "checkWhetherDone: pair .d; raw delay .d, log4 .d, truncDelay .d" },
{ 701219057, "abortPost: new type=.d event, pair .d; vp1 .#x, vp2 .#x" },
{ 701219058, "abortSyncPost: new type=.d event, pair .d; vp1 .#x, vp2 .#x" },
{ 701219059, "gcEvSets: abandoned set, pair .d; started .d, last resp .d" },
{ 701219060, "gcEvSets: new CANCEL event, pair .d" },
{ 701219061, "dmefs_getHdl: need to evaluate handle for vp .#x" },
{ 701219062, "dmefs_setEventList: aggr .#x: changing from .x,,.x to .x,,.x" },
{ 701219063, "dmefs_setEventList: vp .#x: changing from .x,,.x to .x,,.x (lkp code .d)" },
{ 701219064, "safeGetVol: vol .#x, .d,,.d, unsafe: states .#x, accstat .#x" },
{ 701219065, "setLock: aggr .#x, to right .d, flags .#x" },
{ 701219066, "setLock: vp .#x, to right .d, flags .#x" },
{ 701219067, "setLock: done; right .d, code .d" },
{ 701219068, "getPath: fsp .#x: lengths .d and .d, so EINVAL" },
{ 701219069, "getPath: fsp .#x: volid .d,,.d: returns .d" },
{ 701219070, "getPath: fsp .#x: fid .x..x..x..x: returns .d" },
{ 701219071, "getPath: fsp .#x: discr .d, fid .x..x..x..x: returns .d" },
{ 701219072, "getPath: fsp .#x: done; returning .d" },
{ 701219073, "dmepi_getAcl: vp .#x, which=.d" },
{ 701219074, "dmepi_getAcl: vp .#x, outlen .d, code .d" },
{ 701219075, "dmepi_setAcl: vp .#x, svp .#x, tgt which=.d, src which=.d" },
{ 701219076, "dmepi_setAcl: vp .#x, code .d" },
{ 701219077, "dmepi_getFtInfo: aggrp .#x, cookie .d, buflen .d" },
{ 701219078, "dmepi_getFtInfo: aggrp .#x, ocookie .d, obuflen .d; code .d" },
{ 701219079, "dmepi_dirNToHdl: vp .#x, name '.s'" },
{ 701219080, "dmepi_dirNToHdl: returning code .d" },
{ 701219081, "dmepi_getFileAttr: vp .#x, mask .#x" },
{ 701219082, "dmepi_getFileAttr: vp .#x, returning code .d" },
{ 701219083, "dmepi_getDirAttrs: vp .#x, pos .x,,.x, mask .#x, size .d" },
{ 701219084, "dmepi_getDirAttrs: vp .#x, pos .x,,.x, used .d, returning code .d" },
{ 701219085, "dmepi_getDirAttrs: READDIR returns code .d; of room for .#x, offset left at .#x and resid at .#x" },
{ 701219086, "dmepi_getDirAttrs: VOPX_READDIR simply errs out with code .d" },
{ 701219087, "dmepi_getDirAttrs: at EOF (blksize .#x, out resid .#x)" },
{ 701219088, "dmepi_getDirAttrs: offset .#x: VOPX_LOOKUP(.s) gives vp .x, code .d" },
{ 701219089, "dmepi_getDirAttrs: got error code .d from a vnode op" },
{ 701219090, "dmepi_getDirAttrs: buffer full (.d > .d); dir offset .#x, buf offset .d" },
{ 701219091, "dmepi_getDirAttrs: consuming .d bytes of dir, .d bytes to go; dir offset .#x, buf offset .d" },
{ 701219092, "dmepi_getDirAttrs: overwriting offset .x,,.x with .x; dir offset .#x, buf offset .d" },
{ 701219093, "dmepi_getDirAttrs: Updating offset to .x,,.x; dir offset .#x, buf offset .d" },
{ 701219094, "dmepi_getBulkAttr: aggrp .#x, volix .d, vnix .d, mask .#x" },
{ 701219095, "dmepi_getBulkAttr: volix .d, vnix .d, used .d bytes, returning code .d" },
{ 701219096, "dmepi_getBulkAttr: volix .d is id .d,,.d; lookup result is .d" },
{ 701219097, "dmvfs_mount() returns ENOSYS since epiops=.x and cvtedVfs=.x" },
{ 701219098, "dmefs_getHdl: vp .#x, bad handle length .d; returning code EBADF." },
{ 701219099, "vol_dmepiOpen(volp .#x): ckbits .#x, aggrflags .#x; eventp .x" },
{ 701219100, "dmepi_getBulkAttr: ... and moreFlag is .d" },
{ 701219101, "dmepi_getBulkAttr: Setting moreFlag; bneeded (.d) > bufleft (.d); vix .d, vnix .d" },
{ 701219102, "vol_dmepiOpenVolume(volp .#x): ops .#x, event ptr .#x" },
{ 701219103, "vol_dmepiOpenVolume: vol_open failed; returning code .d" },
{ 701219104, "vol_dmepiOpenVolume returns success" },
{ 701219105, "vol_dmepiCloseVolume(volp .#x): inCode .d" },
{ 701219106, "vol_dmepiCloseVolume returns code .d" },
{ 701219107, "dmvn_setxtdattr(.#x): covering .#x" },
{ 701219108, "dmvn_setxtdattr: returning code .d" },
{ 701219109, "dmvn_getxtdattr(.#x): covering .#x" },
{ 701219110, "dmvn_getxtdattr: returning code .d" },
{ 701219111, "dmefs_setEventList: replaced; code .d" },
{ 701219112, "dmefs_setEventList: added; code .d" },
{ 701219113, "dmefs_setEventList: on-disk replace returns .d" },
{ 701219114, "dmepi_setDmAttr: vp .#x, name '.s', value len=.d, newdmtime=.d" },
{ 701219115, "dmefs_setDmAttr: replaced; code .d" },
{ 701219116, "dmefs_setDmAttr: added; code .d" },
{ 701219117, "dmepi_setDmAttr returns code .d" },
{ 701219118, "dmefs_NewDtime: replaced; code .d" },
{ 701219119, "dmefs_NewDtime: added; code .d" },
{ 701219120, "dmepi_getDmAttr: vp .#x, name '.s', buflen .d" },
{ 701219121, "dmepi_getDmAttr returns outlen .d, code .d" },
{ 701219122, "dmepi_rmDmAttr: vp .#x, name '.s', newdmtime=.d" },
{ 701219123, "dmefs_rmDmAttr: removal returns code .d" },
{ 701219124, "dmepi_rmDmAttr returns code .d" },
{ 701219125, "dmepi_getAllDmAttr: vp .#x, buflen .d" },
{ 701219126, "dmepi_getAllDmAttr returns outlen .d, code .d" },
{ 701219127, "dmepi_getBulkAll: aggrp .#x, volix .d, vnix .d, mask .#x" },
{ 701219128, "dmepi_getBulkAll: volix .d, vnix .d, used .d bytes, returning code .d" },
{ 701219129, "dmepi_getBulkAll: volix .d is id .d,,.d; lookup result is .d" },
{ 701219130, "dmepi_getBulkAll: ... and moreFlag is .d" },
{ 701219131, "dmepi_LockFS(right .#x, aggrp .#x): adp flags are .#x, ..." },
{ 701219132, "... vnops are rd=.d, wr=.d; volopens are rd=.d, wr=.d" },
{ 701219133, "dmepi_LockFile(right .#x, vp .#x): dmlockState is .#x, ..." },
{ 701219134, "... vnops are rd=.d, wr=.d" },
{ 701219135, "dmepi_setFileAttr: vp .#x, mask .#x" },
{ 701219136, "dmepi_setFileAttr returns code .d" },
{ 701219137, "cvtVnode: node .#x has BAD regions length .d" },
{ 701219138, "dmepi_getRegion(.#x) called, space for .d regions" },
{ 701219139, "dmepi_getRegion returns code .d" },
{ 701219140, "dmepi_setRegion returns EINVAL because of bad flag value[.d] .#x" },
{ 701219141, "dmepi_setRegion returns EINVAL; .d'th region (starting .lu,,.lu, flags .#x) has 0 size (to EOF), not at end of .d regions" },
{ 701219142, "dmepi_setRegion returns EINVAL; .d'th region (.lu,,.lu for .lu,,.lu) overlaps next region (starting .lu,,.lu)" },
{ 701219143, "dmepi_setRegion(.#x) called with .d regions" },
{ 701219144, "dmepi_setRegion returns code .d, exactflag .d" },
{ 701219145, "dmepi_getRegion: type is .d, not VREG; returning code EINVAL" },
{ 701219146, "dmepi_setRegion: type is .d, not VREG; returning code EINVAL" },
{ 701219147, "dmepi_getAllocInfo(.#x) called, addr .lu,,.lu, space for .d extents" },
{ 701219148, "dmepi_getAllocInfo: type is .d, not VREG; returning code EINVAL" },
{ 701219149, "dmepi_getAllocInfo returns code .d, retval .d, addr .lu,,.lu, .d extents" },
{ 701219150, "dataEventCheck: doing (rgop) .x on vp .x, from .lu,,.lu for .lu,,.lu" },
{ 701219151, "dataEventCheck: considering ix .d, offset .lu,,.lu, len .lu,,.lu, rgops .x" },
{ 701219152, "dataEventCheck: no matches, so no event" },
{ 701219153, "dataEventCheck: matching for evtype .d, offset .lu,,.lu, len .lu,,.lu, rgops .x" },
{ 701219154, "dataEventCheck: returning code .d (getting volume pointer)" },
{ 701219155, "getSeq(type .d): looking, from .x,,.x for .x,,.x" },
{ 701219156, "findSeq: checking one from .x,,.x for .x,,.x" },
{ 701219157, "getSeq: no matches" },
{ 701219158, "dmepi_readInvis vp .#x, off .#x,.#x, len .#x,.#x" },
{ 701219159, "dmepi_readInvis done vp .#x, code .d,  readlen .#x,.#x" },
{ 701219160, "dmvn_readInvis vp .#x, off .#x,.#x, len .#x,.#x" },
{ 701219161, "dmvn_readInvis done vp .#x, code .d, readlen .#x,.#x" },
{ 701219162, "dmepi_writeInvis vp .#x, off .#x,.#x, len .#x,.#x" },
{ 701219163, "dmepi_writeInvis done vp .#x, code .d, writelen .#x,.#x bytes" },
{ 701219164, "dmvn_writeInvis vp .#x, off .#x,.#x, len .#x,.#x" },
{ 701219165, "dmvn_writeInvis done vp .#x, code .d, writelen .#x,.#x" },
{ 701219166, "dmepi_punchHole vp .#x, off .#x,.#x, len .#x,.#x" },
{ 701219167, "dmepi_punchHole vp .#x, code .d" },
{ 701219168, "dmvn_punch vp .#x, off .#x,.#x, len .#x,.#x, flag .#x" },
{ 701219169, "dmvn_punch vp .#x, code .d" },
{ 701219170, "dmepi_probeHole vp .#x, off .#x,.#x, len .#x,.#x" },
{ 701219171, "dmepi_probeHole vp .#x, code .d, off .#x,.#x, len .#x,.#x" },
{ 701219172, "dmvn_probehole vp .#x, off .#x,.#x, len .#x,.#x, flag .#x" },
{ 701219173, "dmvn_probehole vp .#x, code .d, off .#x,.#x, len .#x,.#x" },
{ 701219174, "dmvn_ckregion(vp .#x, off .#x,,.#x for .#x,,.#x, isWrite .d)" },
{ 701219175, "dmvn_ckregion(vp .#x) returning code .d" },
{ 701219176, "dmefs_BusyCode(pairid .d): raw delay .d, log4 .d, truncDelay .d" },
{ 701219177, "dmepi_setRetDestroy aggrp .#x, attr '.s', doEnable .d" },
{ 701219178, "dmepi_setRetDestroy returning code .d" },
{ 701219179, "dmvn_inactive: enqueuing locked vnode .#x" },
{ 701219180, "dmvn_inactive: vp .#x, getVol errors with code .d" },
{ 701219181, "dmvn_inactive: vp .#x, getHdl errors with code .d" },
{ 701219182, "makeDestroy(vp .#x, evtset .x,,.x) called" },
{ 701219183, "processOneInactive, vp .#x: covers .#x; freeing vp" },
{ 701219184, "badCov: no vnode for .#x at line .d, file .s" },
{ 701219185, "inactiveDaemon, aggrid .d, did .d non-waits: about to call with wait (SQ .d)" },
{ 701219186, "inactiveDaemon, aggrid .d, back from waiting call; .d pending, SQ .d" },
{ 701219187, "inactiveDaemon, aggrid .d: finishing" },
{ 701219188, "processOneInactive(aggrid .d, wait=.d): taking vp .#x" },
{ 701219189, "processOneInactive, vp .#x: calling StartVnodeOp w/flags .#x before getattr" },
{ 701219190, "processOneInactive(vp .#x): punt; new ref count .d > 0" },
{ 701219191, "processOneInactive(vp .#x): linkcount guess still < 0, so putting back on queue" },
{ 701219192, "processOneInactive(vp .#x): linkcount 0, so generating DESTROY evts" },
{ 701219193, "processOneInactive(vp .#x): punt; no destroys; new ref count .d > 0" },
{ 701219194, "processOneInactive(vp .#x): deallocating vnode.  Count now .d, waiters .d" },
{ 701219195, "awaitAllInactive(agid .d): about to wait for first" },
{ 701219196, "awaitAllInactive(agid .d): all done" },
{ 701219197, "awaitAllInactive(agid .d): about to sleep; count .d, waiters .d" },
{ 701219198, "awaitAllInactive(agid .d): back from sleep; count .d, waiters .d" },
{ 701219199, "FlushCovers(volid .lu,,.lu) called" },
{ 701219200, "FlushCovers(volid .lu,,.lu) returning" },
{ 701219201, "FlushCovers(volp=0) called" },
{ 701219202, "FlushCovers(volp=0) returning" },
{ 701219203, "dmvn_space off .d len .d" },
{ 701219204, "dmvn_getextentinfo vp .#x, off .#llx, nextents .d" },
{ 701219205, "dmvn_getextentinfo end vp .#x, off .#llx, flags .#x, nextents .d" },
{ 701219206, "dmvn_getextentinfo failed vp .#x, code .d" },
{ 701219207, "dmepi_getAllocInfo extent ix .d, exttype .d, extoff .#x, extlen .#x" },
{ 701219208, "dmepi_getAllocInfo ix .d type .d to ix .d type .d" },
{ 701219209, "dmepi_getAllocInfo stoff .#x,,.#x, stlen .#x,,.#x, dsttype .d" },
{ 701219210, "dmepi_getAllocInfo soff .#x,,.#x, slen .#x,,.#x, dsttype .d" },
{ 701219211, "dmepi_getAllocInfo dstIx .d, type .d, dstoff .#x,,.#x, dstlen .#x,,.#x" },
{ 701219212, "px waiting for event pairid .d, flags .#x, sequence .d" },
{ 701219213, "abandon_Seq: abandoned set, pair .d" },
{ 701219214, "dmvn_pathconf(.#x, .d): covering .#x" },
{ 701219215, "dmvn_pathconf: returning code .d" },
{ 701219216, "getvNode: moribund dm vnode .#x, covered vnode .#x, code .d" },
{ 701219217, "dmepi_getAllocInfo type RES, dstIx .d, dstoff .#x,,.#x, dstlen .#x,,.#x" },
{ 701219218, "dmepi_checkLock(.#x): lockstate .#x, setting .#x" },
{ 701219219, "dmepi_uncheckLock(.#x): lockstate .#x, unsetting XCLLOCKWAITING and SHRLOCKWAITING" },
{ 701219220, "dmepi_LockFile(.#x), lockState .#x, unlock bit .#x" },
{ 701219221, "dmepi_LockFile nonblocking (right .#x, vp .#x): dmlockState is .#x, ..." },
{ 701219222, "dmepi_LockFile locking right .#x in vp .#x, current lockstate .#x, fp current flags .#x" },
{ 701219223, "dmepi_checkLock(.#x) incr wr op count to .d" },
{ 701219224, "dmepi_checkLock(.#x) incr rd op count to .d" },
{ 701219225, "dmepi_uncheckLock(.#x) decr wr op count to .d" },
{ 701219226, "dmepi_uncheckLock(.#x) decr rd op count to .d" },
{ 701219227, "vol_dmepiReadPurgeHole: volp .#x, fid .x..x..x..x, holedesc .#x" },
{ 701219228, "vol_dmepiReadPurgeHole: returning code .d" },
{ 701219229, "vol_dmepiPunch: fid .x..x..x..x, offset .#x,,.#x, length .#x,,.#x, flags .#x" },
{ 701219230, "vol_dmepiPunch: returning code .d" },
{ 701219231, "vol_dmepiGetXtdattr: fid .x..x..x..x" },
{ 701219232, "vol_dmepiGetXtdattr: returning code .d" },
{ 701219233, "vol_dmepiSetXtdattr: fid .x..x..x..x" },
{ 701219234, "vol_dmepiSetXtdattr: returning code .d" },
{ 701219235, "findSeq(type .d): looking, from .x,,.x for .x,,.x" },
{ 701219236, "dmepi_getBulkAll: DMAPI v2.3a version" },
{ 701219237, "dmepi_getBulkAll: CAE XDSM version" },
{ 701219238, "dmvn_finfo(.#x): covering .#x" },
{ 701219239, "dmvn_finfo: returning code .d" },
{ 701219240, "dmefs_CheckWhetherDone: not waiting, vp .#x, volp .#x, pairid .d, sequence .d" },
{ 701219241, "dmepi_getBulkAll: volix .d, id .d,,.d, has max index of .d (code .d)" },
{ 701219242, "dmepi_getBulkAttr: volix .d, id .d,,.d, has max index of .d (code .d)" },
{ 701219243, "dmefs_CheckWhetherDone: not waiting, vp .#x, adp .#x, pairid .d, sequence .d" },
{ 701219244, "dmepi_GetDFSToken wants tokens for .#x vp .d action .#x, .#x flags .d notinuse" },
{ 701219245, "dmepi_GetDFSToken returns .#d" },
{ 701219246, "dmepi_ReturnDFSToken entered" },
{ 701219247, "dmepi_ReturnDFSToken returning token for .#x list id .#x id" },
{ 701219248, "dmepih_RevokeToken wants token .#x types: .#x, .#x" },
{ 701219249, "dmepi_LockFileExtended entered" },
{ 701219250, "dmepi_LockFileExtended exit" },
{ 701219251, "dmepi_getFtInfo: aggrp .#x, code2 .d, code3 .d, code4 .d" },
{ 701247489, "dacl_FindMatchingListEntry: entered" },
{ 701247490, "dacl_FindMatchingListEntry: user uuid is: `.s'" },
{ 701247491, "dacl_FindMatchingListEntry: unable to translate user uuid into string" },
{ 701247492, "dacl_FindMatchingListEntry: group uuid is: `.s'" },
{ 701247493, "dacl_FindMatchingListEntry: unable to translate group uuid into string" },
{ 701247494, "dacl_FindMatchingListEntry: realm uuid is: `.s'" },
{ 701247495, "dacl_FindMatchingListEntry: unable to translate realm uuid into string" },
{ 701247496, "dacl_FindMatchingListEntry: considering user id: `.s'" },
{ 701247497, "dacl_FindMatchingListEntry: unable to translate user entry uuid into string" },
{ 701247498, "dacl_FindMatchingListEntry: match found" },
{ 701247499, "dacl_FindMatchingListEntry: considering group id: `.s'" },
{ 701247500, "dacl_FindMatchingListEntry: unable to translate group entry uuid into string" },
{ 701247501, "dacl_FindMatchingListEntry: match found" },
{ 701247502, "dacl_FindMatchingListEntry: considering foreign other id: `.s'" },
{ 701247503, "dacl_FindMatchingListEntry: unable to translate foreign other entry uuid into string" },
{ 701247504, "dacl_FindMatchingListEntry: match found" },
{ 701247505, "dacl_FindMatchingListEntry: considering foreign user id: `.s'@`.s'" },
{ 701247506, "dacl_FindMatchingListEntry: unable to translate foreign user's realm uuid into string" },
{ 701247507, "dacl_FindMatchingListEntry: unable to translate foreign user entry uuid into string" },
{ 701247508, "dacl_FindMatchingListEntry: match found" },
{ 701247509, "dacl_FindMatchingListEntry: considering foreign user id: `.s'@`.s'" },
{ 701247510, "dacl_FindMatchingListEntry: unable to translate foreign user's realm uuid into string" },
{ 701247511, "dacl_FindMatchingListEntry: unable to translate foreign user entry uuid into string" },
{ 701247512, "dacl_FindMatchingListEntry: match found" },
{ 701247513, ".s: realmIdP is NULL" },
{ 701247514, ".s: realm is.s default" },
{ 701247515, "dacl_epi_CheckAccessParams: error manager type (.s) requires object and group uuids in access comparison" },
{ 701247516, "dacl_epi_CheckAccessParams: error manager type (.s) requires permission bits in access computation" },
{ 701247517, "dacl_CheckAccessParams: error manager type (.s) requires object and group uuids in access comparison" },
{ 701247518, "dacl_CheckAccessParams: error manager type (.s) requires permission bits in access computation" },
{ 701247519, "dacl_ReadFromAnode: Episode aux data read error: .ld" },
{ 701247520, "dacl_ReadFromAnode: unable to allocate .d bytes of memory" },
{ 701247521, "dacl_SizeOfFlatList: byte count up to .d (incl. entry .d header)" },
{ 701247522, "dacl_SizeOfFlatList: byte count up to .d (incl. entry .d)" },
{ 701247523, "dacl_SizeOfFlatAcl: entered" },
{ 701247524, "dacl_SizeOfFlatAcl: byte count up to .d (incl. acl header)" },
{ 701247525, "dacl_SizeOfFlatAcl: byte count up to .d (incl. simple entries)" },
{ 701247526, "dacl_SizeOfFlatAcl: byte count up to .d (incl. complex entries)" },
{ 701247527, "dacl_SizeOfFlatAcl: exiting, returning .d" },
{ 701247528, "dacl_FlattenExtendedInfo: entered, bytes left: .d" },
{ 701247529, "dacl_FlattenExtendedInfo: Error: not enough bytes for extended entry data (.d needed, .d left)" },
{ 701247530, "dacl_FlattenExtendedInfo: Error: not enough bytes for extended entry header (.d needed, .d left)" },
{ 701247531, "dacl_FlattenExtendedInfo: exiting, returning .#x, bytes left: .d" },
{ 701247532, "dacl_FlattenAclEntry: entered, bytes left: .d" },
{ 701247533, "dacl_FlattenAclEntry: Error: not enough bytes for single epi_uuid (.d needed, .d left)" },
{ 701247534, "dacl_FlattenAclEntry: Error: not enough bytes for single epi_uuid (.d needed, .d left)" },
{ 701247535, "dacl_FlattenAclEntry: Error: not enough bytes for two epi_uuids (.d needed, .d left)" },
{ 701247536, "dacl_FlattenAclEntry: Error: not enough bytes for entry header (.d needed, .d left)" },
{ 701247537, "dacl_FlattenAclEntry: exiting, returning .#x, bytes left: .d" },
{ 701247538, "dacl_FlattenAclWithModeBits: entered" },
{ 701247539, "dacl_FlattenAclWithModeBits: buffer bytes: .d" },
{ 701247540, "dacl_FlattenAclWithModeBits: not enough space given for flattening ACL" },
{ 701247541, "dacl_FlattenAclWithModeBits: Error: not enough bytes for acl header (.d needed, .d left)" },
{ 701247542, "dacl_FlattenAclWithModeBits: exiting, returning .#x, bytes in buffer: .d" },
{ 701247543, "dacl_FlattenExtendedInfo: Warning: unexpected buffer misalignment" },
{ 701247544, "dacl_FlattenAclEntry: Warning: unexpected pointer misalignment" },
{ 701247545, "dacl_FlattenAclWithModeBits: Warning: unexpected pointer misalignment" },
{ 701247546, "dacl_TestSimpleEntryInAcl: entered, entry type: .#x" },
{ 701247547, "dacl_TestSimpleEntryInAcl: exiting, entry was.s found" },
{ 701247548, "dacl_TestComplexEntryInList: entered, entry type: .#x" },
{ 701247549, "dacl_TestComplexEntryInList: checking entry number .d, type is .#x" },
{ 701247550, "dacl_TestComplexEntryInList: exiting, entry was.s found" },
{ 701247551, "dacl_TestComplexEntryInAcl: entered, entry type: .#x" },
{ 701247552, "dacl_TestComplexEntryInAcl: exiting, entry was.s found" },
{ 701247553, "dacl_AddEntryToAcl: entry type has a much larger value than expected: .#x" },
{ 701247554, "dacl_AddEntryToAcl: Warning: attempt to insert duplicate ACL entry of entry type .ld" },
{ 701247555, "dacl_AddEntryToAcl: Warning: attempt to insert duplicate ACL entry of entry type .ld" },
{ 701247556, "dacl_ModifyAclEntry: warning: attempt to modify non-existent acl entry" },
{ 701247557, "dacl_DeleteAclEntry: warning: attempt to remove non-existent acl entry" },
{ 701247558, "dacl_DeleteAclEntry: warning: attempt to remove required acl entry: .s" },
{ 701247559, ".s: entered" },
{ 701247560, ".s: principal uuid is: `.s'" },
{ 701247561, ".s: unable to translate uuid into string" },
{ 701247562, "dacl_ParseExtendedInfo: entered, bytes in buffer: .d" },
{ 701247563, "dacl_ParseExtendedInfo: Error: not enough bytes for extended entry data (.d needed, .d left)" },
{ 701247564, "dacl_ParseExtendedInfo: Error: not enough bytes for extended entry header (.d needed, .d left)" },
{ 701247565, "dacl_ParseExtendedInfo: exiting, returning .#x, bytes left: .d" },
{ 701247566, "dacl_ParseAclEntry: entered, bytes left: .d" },
{ 701247567, "dacl_ParseAclEntry: found userobj entry" },
{ 701247568, "dacl_ParseAclEntry: found groupobj entry" },
{ 701247569, "dacl_ParseAclEntry: found otherobj entry" },
{ 701247570, "dacl_ParseAclEntry: found mask obj entry" },
{ 701247571, "dacl_ParseAclEntry: found anyother entry" },
{ 701247572, "dacl_ParseAclEntry: found unauth entry" },
{ 701247573, "dacl_ParseAclEntry: Error: duplicate ACL entry found of type .ld" },
{ 701247574, "dacl_ParseAclEntry: found user entry" },
{ 701247575, "dacl_ParseAclEntry: found group entry" },
{ 701247576, "dacl_ParseAclEntry: Error: not enough bytes for single epi_uuid (.d needed, .d left)" },
{ 701247577, "dacl_ParseAclEntry: found foreign other entry" },
{ 701247578, "dacl_ParseAclEntry: Error: not enough bytes for single epi_uuid (.d needed, .d left)" },
{ 701247579, "dacl_ParseAclEntry: found foreign user entry" },
{ 701247580, "dacl_ParseAclEntry: found foreign group entry" },
{ 701247581, "dacl_ParseAclEntry: Error: not enough bytes for an epi_uuid and an epi_principal_id (.d needed, .d left)" },
{ 701247582, "dacl_ParseAclEntry: found extended entry" },
{ 701247583, "dacl_ParseAclEntry: Error: not enough bytes for entry header (.d needed, .d left)" },
{ 701247584, "dacl_ParseAclEntry: exiting, returning .#x, bytes left: .d" },
{ 701247585, "dacl_ParseAclDiskOption: entered, bytes in buffer: .d" },
{ 701247586, "dacl_ParseAclDiskOption: Error: acl mgr uuid passed does not match mgr uuid in acl to be parsed" },
{ 701247587, "dacl_ParseAclDiskOption: required mgr uuid is: .s" },
{ 701247588, "dacl_ParseAclDiskOption: unable to translate required mgr uuid in ACL to string" },
{ 701247589, "dacl_ParseAclDiskOption: mgr uuid in ACL is: .s" },
{ 701247590, "dacl_ParseAclDiskOption: unable to translate mgr uuid in ACL to string" },
{ 701247591, "dacl_ParseAclDiskOption: realm uuid is: .s" },
{ 701247592, "dacl_ParseAclDiskOption: unable to translate realm uuid in ACL to string" },
{ 701247593, "dacl_ParseAclDiskOption: Error: not enough bytes for acl header (.d needed, .d left)" },
{ 701247594, "dacl_ParseAclDiskOption: Error: .d bytes left-over after acl parse" },
{ 701247595, "dacl_ParseAclDiskOption: exiting, returning .#x, bytes left: .d" },
{ 701247596, "dacl_ParseExtendedInfo: Warning: unexpected buffer misalignment" },
{ 701247597, "dacl_ParseExtendedInfo: Error: unable to allocate .d bytes of buffer space" },
{ 701247598, "dacl_ParseAclEntry: Warning: unexpected buffer misalignment" },
{ 701247599, "dacl_ParseAclEntry: entry type has a much larger value than expected: .#x" },
{ 701247600, "dacl_CheckObjPtrsFromAcl: Error: required user object entry missing on ACL" },
{ 701247601, "dacl_CheckObjPtrsFromAcl: Error: required group object entry missing on ACL" },
{ 701247602, "dacl_CheckObjPtrsFromAcl: Error: required other object entry missing on ACL" },
{ 701247603, "dacl_ParseAclDiskOption: Warning: unexpected buffer misalignment" },
{ 701247604, "dacl_ParseAclDiskOption: Error: unable to allocate .d bytes of buffer space for list .d" },
{ 701247605, "dacl_PermsetsToPermBits: Error: required parameter, permBitsP, is NULL" },
{ 701247606, "dacl_WriteToDisk: .s write: .s" },
{ 701247607, "dacl_WriteToDisk: .s close: .s" },
{ 701247608, "dacl_WriteToDisk: .s open: .s" },
{ 701247609, "dacl_CreateAclOnDisk: entered, filename is .s" },
{ 701247610, "dacl_CreateAclOnDisk: about to create ACL" },
{ 701247611, "dacl_CreateAclOnDisk: Warning: user_obj and group_obj perms ignored for ACL mgr type .s" },
{ 701247612, "dacl_CreateAclOnDisk: .s afs_syscall to write ACL: .s" },
{ 701247613, "dacl_CreateAclOnDisk: error flattening new ACL for Episode write: .s" },
{ 701247614, "dacl_CreateAclOnDisk: file already exists" },
{ 701247615, "dacl_CreateAclOnDisk: .s stat: .s" },
{ 701247616, "dacl_CreateAclOnDisk: .s stat: .s" },
{ 701247617, "dacl_CreateAclOnDisk: exiting, returning .ld" },
{ 701247618, "dacl_PrintRealmName: sec_id_gen_name error on name: .d" },
{ 701247619, "dacl_PrintRealmName: sec_id_gen_name error on name: .s" },
{ 701247620, "dacl_ReadFromDisk: Error: unable to allocate .d bytes of buffer space" },
{ 701247621, "dacl_ReadFromDisk: entered, filename is .s" },
{ 701247622, "dacl_ReadFromDisk: .s read: .s" },
{ 701247623, "dacl_ReadFromDisk: .s fstat: .s" },
{ 701247624, "dacl_ReadFromDisk: .s close: .s" },
{ 701247625, "dacl_ReadFromDisk: .s open: .s" },
{ 701247626, "dacl_ReadFromDisk: exiting, returning .#x" },
{ 701247627, "dacl_From_SecAcl_ExtendedInfo: unable to allocate buffer for extended bytes for daclEntryP" },
{ 701247628, "dacl_From_SecAcl: unable to allocate buffer for complex entry array" },
{ 701247629, "dacl_From_SecAcl: duplicate simple entry, type .d, found in secAclP" },
{ 701247630, "dacl_From_SecAcl: something strange happened in identifying the entry type" },
{ 701247631, "dacl_From_SecAcl: unrecognized entry type, .d, found in secAclP" },
{ 701247632, "dacl_From_SecAcl: error allocating extended entry array buffer" },
{ 701247633, "dacl_From_SecAcl: error incorrect ACL manager uuid in secAclP" },
{ 701247634, "dacl_To_SecAcl_ExtendedInfo: error allocating buffer for extended info for secAclEntryP" },
{ 701247635, "dacl_To_SecAcl: unrecoginzed entry type, .d, found in daclP" },
{ 701247636, "dacl_To_SecAcl: error allocating buffer for secAclP entries" },
{ 701247637, "dacl_InitPac: no passwd file entry found for .s" },
{ 701247638, "dacl_InitPac: no group file entry found for .s" },
{ 701247639, "dacl_AddLocalGroupToPac: no group file entry found for .s" },
{ 701247640, "dacl_InitAclEntryFromStrings: entered" },
{ 701247641, "dacl_InitAclEntryFromStrings: name string `.s' ignored for acl entry type: .s" },
{ 701247642, "dacl_InitAclEntryFromStrings: data string `.s' ignored for acl entry type: .s" },
{ 701247643, "dacl_InitAclEntryFromStrings: no passwd file entry found for .s" },
{ 701247644, "dacl_InitAclEntryFromStrings: entry type .s cannot be mapped locally" },
{ 701247645, "dacl_InitAclEntryFromStrings: no group file entry found for .s" },
{ 701247646, "dacl_InitAclEntryFromStrings: entry type .s cannot be mapped locally" },
{ 701247647, "dacl_InitAclEntryFromStrings: exiting, returning: .s" },
{ 701247648, "dacl_NameAndTypeStringsFromEntry entered" },
{ 701247649, "dacl_NameAndTypeStringsFromEntry: no passwd file entry found for uid .d" },
{ 701247650, "dacl_NameAndTypeStringsFromEntry: entry type .d cannot be mapped locally" },
{ 701247651, "dacl_NameAndTypeStringsFromEntry: no group file entry found for if .d" },
{ 701247652, "dacl_NameAndTypeStringsFromEntry: entry type .s cannot be mapped locally" },
{ 701247653, "dacl_NameAndTypeStringsFromEntry exiting; returning .ld" },
{ 701247654, "dacl_NameAndTypeStringsFromEntry exiting; returning .s" },
{ 701247655, "dacl_InitPac: sec_rgy_pgo_name_to_id raised an exception on name: .d; see stdout" },
{ 701247656, "dacl_InitPac: .s error on name: .s: .s" },
{ 701247657, "dacl_InitPac: sec_rgy_pgo_name_to_id raised an exception on name: .s; see stdout" },
{ 701247658, "dacl_InitPac: .s error on name: .s: .s" },
{ 701247659, "dacl_InitPac: sec_id_parse_name raised an exception on name: .s; see stdout" },
{ 701247660, "dacl_InitPac: sec_id_parse_name error on name: .s: .s" },
{ 701247661, "dacl_AddLocalGroupToPac: buffer allocation error" },
{ 701247662, "dacl_AddLocalGroupToPac: sec_rgy_pgo_name_to_id error on name: .s; see stdout" },
{ 701247663, "dacl_AddLocalGroupToPac: .s error on name: .s: .s" },
{ 701247664, "dacl_InitAclEntryFromStrings: attempt to add an entry type (.#x) inappropriate for the ACL mgr type: .s" },
{ 701247665, "dacl_InitAclEntryFromStrings: error on uuid comparison: .s" },
{ 701247666, "dacl_InitAclEntryFromStrings: sec_id_parse_name raised an exception in name: .s; see stdout" },
{ 701247667, "dacl_InitAclEntryFromStrings: sec_id_parse_name error on name: .s: .s" },
{ 701247668, "dacl_InitAclEntryFromStrings: error, name required for given acl entry type: .s" },
{ 701247669, "dacl_InitAclEntryFromStrings: error, name required for given acl entry type: .s" },
{ 701247670, "dacl_InitAclEntryFromStrings: error on uuid comparison: .s" },
{ 701247671, "dacl_InitAclEntryFromStrings: sec_id_parse_group raised an exception in name: .s; see stdout" },
{ 701247672, "dacl_InitAclEntryFromStrings: sec_id_parse_group error on name: .s: .s" },
{ 701247673, "dacl_InitAclEntryFromStrings: error, name required for given acl entry type: .s" },
{ 701247674, "dacl_NameAndTypeStringsFromEntry: .s returned an error: .s" },
{ 701247675, "dacl_NameAndTypeStringsFromEntry: sec_rgy_pgo_unix_num_to_id raised an exception; see stdout" },
{ 701247676, "dacl_NameAndTypeStringsFromEntry: sec_rgy_pgo_unix_num_to_id returned an error: .s" },
{ 701247677, "dacl_NameAndTypeStringsFromEntry: sec_rgy_site_open returned an error: .s" },
{ 701247678, "dacl_NameAndTypeStringsFromEntry: sec_id_gen_name raised an exception; see stdout" },
{ 701247679, "dacl_NameAndTypeStringsFromEntry: sec_id_gen_name returned an error: .s" },
{ 701247680, "dacl_NameAndTypeStringsFromEntry: sec_id_gen_group raised an exception; see stdout" },
{ 701247681, "dacl_NameAndTypeStringsFromEntry: sec_id_gen_group returned an error: .s" },
{ 701247682, "dacl_NameAndTypeStringsFromEntry: sec_id_gen_name raised an exception; see stdout" },
{ 701247683, "dacl_NameAndTypeStringsFromEntry: sec_id_gen_name returned an error: .s" },
{ 701247684, "dacl_EntryType_FromString: entered" },
{ 701247685, "dacl_EntryType_FromString: copied type .#x for string .s" },
{ 701247686, "dacl_EntryType_FromString: exiting, returning .#x" },
{ 701247687, "dacl_ParsePermsetString: considering character .c" },
{ 701247688, "dacl_ParsePermsetString: about to add perm, current permset: .#x" },
{ 701247689, "dacl_ParsePermsetString: added perm for character .c, current permset: .#x" },
{ 701247690, "dacl_ExtendedInfoUuidTranslate: entered, bytes in buffer: .d" },
{ 701247691, "dacl_ExtendedInfoUuidTranslate: Error: not enough bytes for extended entry data (.d needed, .d left)" },
{ 701247692, "dacl_ExtendedInfoUuidTranslate: Error: not enough bytes for extended entry header (.d needed, .d left)" },
{ 701247693, "dacl_ExtendedInfoUuidTranslate: exiting, returning .#x, bytes left: .d" },
{ 701247694, "dacl_AclEntryUuidTranslate: entered, bytes left: .d" },
{ 701247695, "dacl_AclEntryUuidTranslate: Error: not enough bytes for single epi_uuid_t (.d needed, .d left)" },
{ 701247696, "dacl_AclEntryUuidTranslate: Error: not enough bytes for two epi_uuid_ts (.d needed, .d left)" },
{ 701247697, "dacl_AclEntryUuidTranslate: Error: not enough bytes for entry header (.d needed, .d left)" },
{ 701247698, "dacl_AclEntryUuidTranslate: exiting, returning .#x, bytes left: .d" },
{ 701247699, "dacl_BufferUuidTranslate entered, bytes in buffer: .d" },
{ 701247700, "dacl_BufferUuidTranslate: Error: not enough bytes for acl header (.d needed, .d left)" },
{ 701247701, "dacl_BufferUuidTranslate: Error: .d bytes left-over after acl parse" },
{ 701247702, "dacl_BufferUuidTranslate: exiting, returning .#x, bytes left: .d" },
{ 701247703, "dacl_ExtendedInfoUuidTranslate: Warning: unexpected pointer misalignment" },
{ 701247704, "dacl_AclEntryUuidTranslate: Warning: unexpected pointer misalignment" },
{ 701247705, "dacl_BufferUuidTranslate: Error: unable to allocate .d bytes of buffer space" },
{ 701247706, "dacl_ComplexList_Validate: Error: entry specifies foreign user within default realm, repairing" },
{ 701247707, "dacl_ComplexList_Validate: Error:  entry specifies foreign user within default realm, failing validation" },
{ 701247708, "dacl_ComplexList_Validate: Error: entry specifies foreign group within default realm, repairing" },
{ 701247709, "dacl_ComplexList_Validate: Error:  entry specifies foreign group within default realm, failing validation" },
{ 701247710, "dacl_ComplexList_Validate: Error: foreign other entry specifies default cell, no repair done" },
{ 701247711, "dacl_ValidateBuffer: error parsing ACL buffer: .ld" },
{ 701247712, "dacl_ValidateBuffer: error parsing ACL buffer: .s" },
{ 701272065, "dmrpc_Init called" },
{ 701272066, "dmrpc_Init: memory alloc failure" },
{ 701272067, "dmrpc_Init exiting with success" },
{ 701272068, "dmrpc_finish called" },
{ 701272069, "dmrpc_finish: forcing detach with .d pending reads" },
{ 701272070, "dmrpc_finish: fails with EAGAIN; .d pending reads" },
{ 701272071, "dmrpc_finish: .d reqs allocated .d on free list" },
{ 701272072, "dmrpc_finish: returning 0" },
{ 701272073, "dmrpc_close: clearing .d opens" },
{ 701272074, "dmrpc_close: returning 0" },
{ 701272075, "dmrpc_read: starting; uiop .x" },
{ 701272076, "dmrpc_read: done; uiop .x returning .d" },
{ 701272077, "dmrpc_write: interrupted code .d; returning EINTR" },
{ 701272078, "dmrpc_write: awakened with code .d" },
{ 701272079, "dmrpc_write: starting; uiop .x" },
{ 701272080, "dmrpc_write: dispatching type .d length .#x" },
{ 701272081, "dmrpc_write: done; uiop .x returning .d" },
{ 701272082, "dmrpc_ioctl: starting; cmd .#x arg .#x" },
{ 701272083, "dmrpc_ioctl: done; cmd .#x arg .#x; returning .d" },
{ 701272084, "dmrpc_poll: starting; events .#x" },
{ 701272085, "dmrpc_poll: done; in evts .#x out evts .#x" },
{ 701280257, "dfsauth_client_GrabLock entered" },
{ 701280258, "dfsauth_client_GrabLock exiting, returning .s" },
{ 701280259, "dfsauth_client_GrabLock exiting, returning .lu" },
{ 701280260, "dfsauth_client_ReleaseLock entered" },
{ 701280261, "dfsauth_client_ReleaseLock exiting, returning .s" },
{ 701280262, "dfsauth_client_ReleaseLock exiting, returning .lu" },
{ 701280263, "dfsauth_EstablishLocalAuthContext entered" },
{ 701280264, "dfsauth_EstablishLocalAuthContext: about to call sec_login_setup_identity with name: `.s'" },
{ 701280265, "dfsauth_EstablishLocalAuthContext: sec_login_setup_identity returned" },
{ 701280266, "dfsauth_EstablishLocalAuthContext: about to call sec_login_refresh_identity with name: `.s'" },
{ 701280267, "dfsauth_EstablishLocalAuthContext: sec_login_refresh_identity returned" },
{ 701280268, "dfsauth_EstablishLocalAuthContext: about to call sec_login_valid_from_keytable" },
{ 701280269, "dfsauth_EstablishLocalAuthContext: returned from sec_login_valid_from_keytable" },
{ 701280270, "dfsauth_EstablishLocalAuthContext: about to call sec_login_set_context" },
{ 701280271, "dfsauth_EstablishLocalAuthContext: sec_login_set_context returned" },
{ 701280272, "dfsauth_EstablishLocalAuthContext: dfsauth_PrinName_GetBaseName reported failure: .s" },
{ 701280273, "dfsauth_EstablishLocalAuthContext: dfsauth_PrinName_GetBaseName reported failure: .lu" },
{ 701280274, "dfsauth_EstablishLocalAuthContext: attempt to setup local auth, not from root" },
{ 701280275, "dfsauth_EstablishLocalAuthContext exiting, returning .s" },
{ 701280276, "dfsauth_EstablishLocalAuthContext exiting, returning .lu" },
{ 701280277, "AutoRefreshThread: TGT will expire at .d" },
{ 701280278, "AutoRefreshThread: Refreshing TGT" },
{ 701280279, "dfsauth_client_InitAuthContext entered" },
{ 701280280, "dfsauth_client_InitAuthContext exiting, returning .s" },
{ 701280281, "dfsauth_client_InitAuthContext exiting, returning .lu" },
{ 701280282, "dfsauth_client_InitBindingAuth entered" },
{ 701280283, "dfsauth_client_InitBindingAuth: about to call rpc_binding_inq_auth_info" },
{ 701280284, "dfsauth_client_InitBindingAuth: about to call rpc_binding_set_auth_info, authn svc = .s, principal name: .s" },
{ 701280285, "dfsauth_client_InitBindingAuth: rpc_binding_set_auth_info returned" },
{ 701280286, "dfsauth_client_InitBindingAuth: PrinName_GetName reported failure: .s" },
{ 701280287, "dfsauth_client_InitBindingAuth: PrinName_GetName reported failure: .lu" },
{ 701280288, "dfsauth_client_InitBindingAuth exiting, returning .s" },
{ 701280289, "dfsauth_client_InitBindingAuth exiting, returning .lu" },
{ 701280290, "dfsauth_client_InitAuthentication entered" },
{ 701280291, "dfsauth_client_InitAuthentication: serverLocationP: .s, useNoAuth? .s, useLocalAuth? .s" },
{ 701280292, "dfsauth_client_InitAuthentication: about to call rpc_binding_set_auth_info, authn svc = .s, principal name: .s" },
{ 701280293, "dfsauth_client_InitAuthentication: rpc_binding_set_auth_info returned" },
{ 701280294, "dfsauth_client_InitAuthentication: PrinName_GetName reported failure: .s" },
{ 701280295, "dfsauth_client_InitAuthentication: PrinName_GetName reported failure: .lu" },
{ 701280296, "dfsauth_client_InitAuthentication exiting, returning .s" },
{ 701280297, "dfsauth_client_InitAuthentication exiting, returning .lu" },
{ 701280298, "dfsauth_client_InitNullAuthentication entered" },
{ 701280299, "dfsauth_client_InitNullAuthentication: serverLocationP: .s, useNoAuth? .s, useLocalAuth? .s" },
{ 701280300, "dfsauth_client_InitNullAuthentication: about to call rpc_mgmt_inq_server_princ_name" },
{ 701280301, "dfsauth_client_InitNullAuthentication: returned from call to rpc_mgmt_inq_server_princ_name" },
{ 701280302, "dfsauth_client_InitNullAuthentication: rpc_mgmt_inq_server_princ_name returned error .s" },
{ 701280303, "dfsauth_client_InitNullAuthentication: about to call rpc_binding_set_auth_info, authn svc = .s, principal name: .s" },
{ 701280304, "dfsauth_client_InitNullAuthentication: rpc_binding_set_auth_info returned" },
{ 701280305, "dfsauth_client_InitNullAuthentication: PrinName_GetName reported failure: .s" },
{ 701280306, "dfsauth_client_InitNullAuthentication: PrinName_GetName reported failure: .lu" },
{ 701280307, "dfsauth_client_InitNullAuthentication exiting, returning .s" },
{ 701280308, "dfsauth_client_InitNullAuthentication exiting, returning .lu" },
{ 701280309, "dfsauth_client_SetFullEncryption entered" },
{ 701280310, "dfsauth_client_SetFullEncryption exiting, returning .s" },
{ 701280311, "dfsauth_client_SetFullEncryption exiting, returning .lu" },
{ 701280312, "dfsauth_client_ResetDefaultEncryption entered" },
{ 701280313, "dfsauth_client_ResetDefaultEncryption exiting, returning .s" },
{ 701280314, "dfsauth_client_ResetDefaultEncryption exiting, returning .lu" },
{ 701280315, "dfsauth_client_CleanupAuthentication entered" },
{ 701280316, "dfsauth_client_CleanupAuthentication exiting, returning .s" },
{ 701280317, "dfsauth_client_CleanupAuthentication exiting, returning .lu" },
{ 701280318, "dfsauth_EstablishLocalAuthContext: sec_login_valid_from_keytable raised an exception; see stdout" },
{ 701280319, "dfsauth_EstablishLocalAuthContext: unexpected authorization error returned from sec_login_valid_from_keytable" },
{ 701280320, "dfsauth_EstablishLocalAuthContext: error from sec_login_valid_from_keytable for principal .s: .s" },
{ 701280321, "dfsauth_EstablishLocalAuthContext: sec_login_purge_context error: .s" },
{ 701280322, "dfsauth_EstablishLocalAuthContext: sec_login_set_context raised an exception; see stdout" },
{ 701280323, "dfsauth_EstablishLocalAuthContext: sec_login_set_context error: .s" },
{ 701280324, "dfsauth_client_InitBindingAuth: rpc_binding_set_auth_info raised an exception; see stdout" },
{ 701280325, "dfsauth_client_InitBindingAuth: rpc_binding_set_auth_info error: .s" },
{ 701280326, "dfsauth_client_InitBindingAuth: rpc_binding_inq_auth_info raised an exception; see stdout" },
{ 701280327, "dfsauth_client_InitBindingAuth: rpc_binding_inq_auth_info error: .s" },
{ 701280328, "dfsauth_client_InitAuthentication: rpc_binding_set_auth_info raised an exception; see stdout" },
{ 701280329, "dfsauth_client_InitAuthentication: rpc_binding_set_auth_info error: .s" },
{ 701280330, "dfsauth_client_InitNullAuthentication: rpc_binding_set_auth_info raised an exception; see stdout" },
{ 701280331, "dfsauth_client_InitNullAuthentication: rpc_binding_set_auth_info error: .s" },
{ 701280332, "dfsauth_client_SetFullEncryption: rpc_binding_set_auth_info raised an exception; see stdout" },
{ 701280333, "dfsauth_client_SetFullEncryption: rpc_binding_set_auth_info error: .s" },
{ 701280334, "dfsauth_client_SetFullEncryption: rpc_binding_set_auth_info raised an exception; see stdout" },
{ 701280335, "dfsauth_client_SetFullEncryption: rpc_binding_set_auth_info error: .s" },
{ 701280336, "dfsauth_client_SetFullEncryption: rpc_binding_inq_auth_info raised an exception; see stdout" },
{ 701280337, "dfsauth_client_SetFullEncryption: Error: authentication info required for full encryption: (no noauth)" },
{ 701280338, "dfsauth_client_SetFullEncryption: rpc_binding_inq_auth_info error: .s" },
{ 701280339, "dfsauth_client_ResetDefaultEncryption: rpc_binding_set_auth_info raised an exception; see stdout" },
{ 701280340, "dfsauth_client_ResetDefaultEncryption: rpc_binding_set_auth_info error: .s" },
{ 701280341, "dfsauth_client_ResetDefaultEncryption: rpc_binding_inq_auth_info raised an exception; see stdout" },
{ 701280342, "dfsauth_client_ResetDefaultEncryption: rpc_binding_inq_auth_info error: .s" },
{ 701280343, "dfsauth_client_CleanupAuthentication: sec_login_purge_context raised an exception; see stdout" },
{ 701280344, "dfsauth_client_CleanupAuthentication: sec_login_purge_context error: .s" },
{ 701280345, ".s: Error: required pointer parameter, .s, has NULL value" },
{ 701280346, "dfsauth_InitKeytab: keyfile name `.s' too long; using `foobar' instead" },
{ 701280347, "dfsauth_InitKeytab: error getting default keytab name" },
{ 701280348, "dfsauth_InitKeytab: error resolving keytab name" },
{ 701280349, "dfsauth_InitKeytab: error registering ops: .s" },
{ 701280350, "dfsauth_InitKeytab: error registering ops: .lu" },
{ 701280351, "dfsauth_Keytab_AddKey: error converting principal name to salt" },
{ 701280352, "dfsauth_PassKey_Add: entered: principal name: .s, kvno: .d" },
{ 701280353, "dfsauth_PassKey_Add: error adding password: .s" },
{ 701280354, "dfsauth_PassKey_Add: error adding password: .lu" },
{ 701280355, "dfsauth_PassKey_Add: error adding key: .s" },
{ 701280356, "dfsauth_PassKey_Add: error adding key: .lu" },
{ 701280357, "dfsauth_PassKey_Add: error initializing key table: .s" },
{ 701280358, "dfsauth_PassKey_Add: error initializing key table: .lu" },
{ 701280359, "dfsauth_PassKey_Add: error getting principal name: .s" },
{ 701280360, "dfsauth_PassKey_Add: error getting principal name: .lu" },
{ 701280361, "dfsauth_PassKey_Add: exiting, returning .s" },
{ 701280362, "dfsauth_PassKey_Add: exiting, returning .lu" },
{ 701280363, "dfsauth_PassKey_Remove: entered: principal name: .s, kvno: .d" },
{ 701280364, "dfsauth_PassKey_Remove: error removing password: .s" },
{ 701280365, "dfsauth_PassKey_Remove: error removing password: .lu" },
{ 701280366, "dfsauth_PassKey_Remove: error removing key: .s" },
{ 701280367, "dfsauth_PassKey_Remove: error removing key: .lu" },
{ 701280368, "dfsauth_PassKey_Remove: error initializing key table: .s" },
{ 701280369, "dfsauth_PassKey_Remove: error initializing key table: .lu" },
{ 701280370, "dfsauth_PassKey_Remove: error getting principal name: .s" },
{ 701280371, "dfsauth_PassKey_Remove: error getting principal name: .lu" },
{ 701280372, "dfsauth_PassKey_Remove: exiting, returning .s" },
{ 701280373, "dfsauth_PassKey_Remove: exiting, returning .lu" },
{ 701280374, "dfsauth_PassKey_Change: entered: principal name: .s, kvno: .d" },
{ 701280375, "dfsauth_PassKey_Change: error changing password: .s" },
{ 701280376, "dfsauth_PassKey_Change: error changing password: .lu" },
{ 701280377, "dfsauth_PassKey_Change: error changing key: .s" },
{ 701280378, "dfsauth_PassKey_Change: error changing key: .lu" },
{ 701280379, "dfsauth_PassKey_Change: error initializing key table: .s" },
{ 701280380, "dfsauth_PassKey_Change: error initializing key table: .lu" },
{ 701280381, "dfsauth_PassKey_Change: error getting principal name: .s" },
{ 701280382, "dfsauth_PassKey_Change: error getting principal name: .lu" },
{ 701280383, "dfsauth_PassKey_Change: exiting, returning .s" },
{ 701280384, "dfsauth_PassKey_Change: exiting, returning .lu" },
{ 701280385, "dfsauth_KeyTab_GetLocalKrb5Key entered" },
{ 701280386, "dfsauth_KeyTab_GetLocalKrb5Key: about to call sec_key_mgmt_get_key" },
{ 701280387, "dfsauth_KeyTab_GetLocalKrb5Key: returned from sec_key_mgmt_get_key" },
{ 701280388, "dfsauth_KeyTab_GetLocalKrb5Key: sec_key_mgmt_free_key returned error: .s" },
{ 701280389, "dfsauth_KeyTab_GetLocalKrb5Key: sec_key_mgmt_get_key returned wrong key type: .u" },
{ 701280390, "dfsauth_KeyTab_GetLocalKrb5Key: sec_key_mgmt_get_key returned error: .s" },
{ 701280391, "dfsauth_KeyTab_GetLocalKrb5Key exiting, returning .#x" },
{ 701280392, "dfsauth_Keytab_GetLocalPasswdKey entered" },
{ 701280393, "dfsauth_Keytab_GetLocalPasswdKey exiting, returning .#x" },
{ 701280394, "dfsauth_Keytab_GetLocalKey entered" },
{ 701280395, "dfsauth_Keytab_GetLocalKey exiting, returning .#x" },
{ 701280396, "dfsauth_PrinName_MakePrincipalName entered, base name is: .s" },
{ 701280397, "dfsauth_PrinName_MakePrincipalName: buffer too small, need at least .d characters; have .d characters" },
{ 701280398, "dfsauth_PrinName_MakePrincipalName exiting, returning .d, constructed name is: .s" },
{ 701280399, "dfsauth_PrinName_GetName entered" },
{ 701280400, "dfsauth_PrinName_GetName: basename is .s, adding suffix? .s" },
{ 701280401, "dfsauth_PrinName_GetName exiting, returning principal .s, value .#x" },
{ 701280402, "dfsauth_pathnames_GrabLock entered" },
{ 701280403, "dfsauth_pathnames_GrabLock exiting, returning .s" },
{ 701280404, "dfsauth_pathnames_GrabLock exiting, returning .lu" },
{ 701280405, "dfsauth_pathnames_ReleaseLock entered" },
{ 701280406, "dfsauth_pathnames_ReleaseLock exiting, returning .s" },
{ 701280407, "dfsauth_pathnames_ReleaseLock exiting, returning .lu" },
{ 701280408, "dfsauth_InitPathnames: entered" },
{ 701280409, "dfsauth_InitPathnames exiting, returning .s" },
{ 701280410, "dfsauth_InitPathnames exiting, returning .lu" },
{ 701280411, "dfsauth_server_SetNoAuthStatus: entered" },
{ 701280412, "dfsauth_server_SetNoAuthStatus exiting, returning .s" },
{ 701280413, "dfsauth_server_SetNoAuthStatus exiting, returning .lu" },
{ 701280414, "dfsauth_server_GetNoAuthStatus: entered" },
{ 701280415, "dfsauth_server_GetNoAuthStatus exiting, returning .s" },
{ 701280416, "dfsauth_server_GetNoAuthStatus exiting, returning .lu" },
{ 701280417, "dfsauth_GenerateAdminListPath: entered" },
{ 701280418, "dfsauth_GenerateAdminListPath exiting, returning .s" },
{ 701280419, "dfsauth_GenerateAdminListPath exiting, returning .lu" },
{ 701280420, "dfsauth_InitPathnames: Error: unable to get base directory environment variable" },
{ 701280421, ".s: .s: .s of NoAuth file, .s . . ." },
{ 701280422, ", returned error: .s" },
{ 701280423, "dfsauth_get_local_host_uuid entered" },
{ 701280424, "dfsauth_get_local_host_uuid: unable to get local principal name: .s" },
{ 701280425, "dfsauth_get_local_host_uuid exiting, returning .s" },
{ 701280426, "dfsauth_rpc_mgmt_authz_check entered" },
{ 701280427, "dfsauth_rpc_mgmt_authz_check: requested operation is .s" },
{ 701280428, "dfsauth_rpc_mgmt_authz_check: requested operation is .s" },
{ 701280429, "dfsauth_rpc_mgmt_authz_check: requested operation is .s" },
{ 701280430, "dfsauth_rpc_mgmt_authz_check: requested operation is .s" },
{ 701280431, "dfsauth_rpc_mgmt_authz_check: requested operation is .s" },
{ 701280432, "dfsauth_rpc_mgmt_authz_check: found name authzn; name = .s" },
{ 701280433, "dfsauth_rpc_mgmt_authz_check: binding has no auth info, checking noauth" },
{ 701280434, "dfsauth_rpc_mgmt_authz_check: rpc_binding_inq_auth_client error: .s" },
{ 701280435, "dfsauth_rpc_mgmt_authz_check: Error: unable to get client principal uuid" },
{ 701280436, "dfsauth_rpc_mgmt_authz_check: Error: unable to get local host principal uuid: .s" },
{ 701280437, "dfsauth_rpc_mgmt_authz_check exiting, returning .s" },
{ 701280438, "dfsauth_get_local_host_uuid: rpc_binding_inq_auth_client raised an exception; see stdout" },
{ 701280439, "dfsauth_get_local_host_uuid: unable to get local principal uuid: .s" },
{ 701280440, "dfsauth_rpc_mgmt_authz_check: rpc_binding_inq_auth_client raised an exception; see stdout" },
{ 701280441, "dfsauth_sec_key_mgmt_free_key: unexpected error freeing key data storage: .s" },
{ 701280442, "dfsauth_sec_key_mgmt_keyinfo: Warning: real checksum length (.d) != dfsauth checksum length (.d)" },
{ 701280443, "dfsauth_sec_key_mgmt_keyinfo: sec_rgy_acct_lookup error checking account change date: .s" },
{ 701280444, "dfsauth_sec_key_mgmt_keyinfo: sec_id_parse_name error: .s" },
{ 701280445, "dfsauth_server_GrabLock entered" },
{ 701280446, "dfsauth_server_GrabLock exiting, returning .s" },
{ 701280447, "dfsauth_server_GrabLock exiting, returning .lu" },
{ 701280448, "dfsauth_server_ReleaseLock entered" },
{ 701280449, "dfsauth_server_ReleaseLock exiting, returning .s" },
{ 701280450, "dfsauth_server_ReleaseLock exiting, returning .lu" },
{ 701280451, "dfsauth_CheckServerNoAuth: server is checking noauth status" },
{ 701280452, "dfsauth_CheckServerNoAuth: server is assuming noauth mode" },
{ 701280453, "dfsauth_CheckServerNoAuth: server is.s running in noauth mode" },
{ 701280454, "dfsauth_server_InitAuth: about to call .s with principal name .s" },
{ 701280455, "dfsauth_server_InitAuth: returned from .s" },
{ 701280456, "dfsauth_server_InitAuth: dfsauth_PrinName_GetName returned error: .lu" },
{ 701280457, "dfsauth_server_InitAuth: dfsauth_PrinName_GetName returned error: .s" },
{ 701280458, "dfsauth_server_CheckAuthorizationAclOptional: entered" },
{ 701280459, "dfsauth_server_CheckAuthorizationAclOptional: server is not running no auth, will check id" },
{ 701280460, "dfsauth_server_CheckAuthorizationAclOptional: about to call .s" },
{ 701280461, "dfsauth_server_CheckAuthorizationAclOptional: found authn svc: .s" },
{ 701280462, "dfsauth_server_CheckAuthorizationAclOptional: found authn level: .d" },
{ 701280463, "dfsauth_server_CheckAuthorizationAclOptional: found authz svc: .s" },
{ 701280464, "dfsauth_server_CheckAuthorizationAclOptional: found name authzn; name = .s" },
{ 701280465, "dfsauth_server_CheckAuthorizationAclOptional: error reading acl from disk: .lu" },
{ 701280466, "dfsauth_server_CheckAuthorizationAclOptional: error reading acl from disk: .s" },
{ 701280467, "dfsauth_server_CheckAuthorizationAclOptional: .s unrecognized authzn svc found in binding: .#x" },
{ 701280468, "dfsauth_server_CheckAuthorizationAclOptional: binding has no auth info, checking noauth" },
{ 701280469, "dfsauth_server_CheckAuthorizationAclOptional: .s error: .s" },
{ 701280470, "dfsauth_server_CheckAuthorizationAclOptional: exiting, returning .d" },
{ 701280471, "dfsauth_server_InitAuth: sec_id_parse_name raised an exception; see stdout" },
{ 701280472, "dfsauth_server_InitAuth: unable to parse global name: .s (.s)" },
{ 701280473, "dfsauth_server_InitAuth: unable to bind to a registry site: .s (.s)" },
{ 701280474, "dfsauth_server_InitAuth: rpc_server_register_auth_info raised an exception; see stdout" },
{ 701280475, "dfsauth_server_InitAuth: unable to register authn info: .s" },
{ 701280476, "dfsauth_server_CheckAuthorizationAclOptional: rpc_binding_inq_auth_client raised an exception; see stdout" },
{ 701280477, "dfsauth_server_CheckAdminListAccessBegin: entered" },
{ 701280478, "dfsauth_server_CheckAdminListAccessBegin: returns .x" },
{ 701280479, "dfsauth_server_CheckAdminListAccessNext: entered" },
{ 701280480, "dfsauth_server_CheckAdminListAccessNext: returns .x" },
{ 701280481, "AutoRefreshThread: exiting since dfsauth_client_initialized is turned off" },
{ 701280482, "AutoRefreshThread: exiting since can't get expiration time: .d" },
{ 701280483, "dfsauth_server_GetClientIdentity: entered (.#x, .#x, .#x)" },
{ 701280484, "dfsauth_server_GetClientIdentity: returns .x (st=.x)" },
{ 701280485, "... authn level = .d" },
{ 701366273, "epia_Strategy(bp=.#x): zero length xfer because new file length is .#x" },
{ 701366274, "BufRead: anode .#x bp .#x offset .#x length .#x" },
{ 701366275, "BufWrite anode .#x bp .#x offset .#x length .#x" },
{ 701366276, "epia_Strategy(bp=.#x): epia_Read anode .#x offset .#x length .#x" },
{ 701366278, "BufRead(h=.#x): QIO bp .#x disk block .#x length .#x" },
{ 701366279, "BufWrite(h=.#x): QIO bp .#x disk block .#x length .#x" },
{ 701366280, "bp .#x: pagelist .#x .d page(s)" },
{ 701366281, "pages: .#x .#x .#x .#x" },
{ 701366282, "osi_bio_clean(bp=.#x): flags = .#x" },
{ 701366283, "NotifyAndUnmapBufs(bp=.#x code=.#x unmap = .d" },
{ 701366284, "pvn_read_done: bp .#x pages .#x flags .#x" },
{ 701366285, "pvn_write_done: bp .#x pages .#x flags .#x" },
{ 701366286, "anode layer converted error .lu to error .lu in file .s at line .d" },
{ 701366287, "epif_Open: vol .#x, fid index .lu, epiv index .lu, epiv_OpenAnode failed, code .lu" },
{ 701366288, "epif_Open: vol .#x, fid .lu..lu, GetHandle failed, code .lu" },
{ 701366289, "queue_sick_vnode: vp .#x bp .#x block .#llx length .#x" },
{ 701366290, "release_sick_vnode: vp .#x" },
{ 701366291, "read thread .#x waiting for busy disk block .d dev .d .d" },
{ 701366292, "write thread .#x waiting for busy disk block .d dev .d .d" },
{ 701366293, "epif_ChangeLink anode .#x link delta .d delete .d (suspect) current link count .d" },
{ 701366294, "epix_CheckBlockAllocation off .#llx emptyblks .#llx ibAddr .#lx outLen .#llx" },
{ 701366295, "epix_CheckBlockAllocation off .#llx ibAddr .d highest ix .d start ix .d" },
{ 701366296, "epix_CheckBlockAllocation multiplies by .#x to get .#llx" },
{ 701366297, "epix_CheckBlockAllocation diff .llx bigger than MAX_OSI_OFF_T/(span .#x) so we use MAX_OSI_OFF_T" },
{ 701366298, "epix_CheckBlockAllocation MIN with btoab(maxoff) to get .#llx result in bytes is .#llx" },
{ 701411329, "WaitForTran(.d): to complete from state .#x" },
{ 701411330, "WaitForTran(.d): wakeup in state .#x" },
{ 701411331, "WaitForTran(.d): start GCtran" },
{ 701411332, "WaitForTran(.d): end GCtran" },
{ 701411333, "WaitForTran(.d): start wait for any" },
{ 701411334, "WaitForTran(.d): end wait for any" },
{ 701411335, "CompleteEC: ecSize is .d" },
{ 701411336, "elbl_StartTran: logfull; .d running active size data/tran=.d/.d" },
{ 701411337, "AllocBuffer: found no clean buffers in .dK pool" },
{ 701452289, "lfswrite V .x F .x..x..x..x O .d L .d" },
{ 701452290, "lfswriteZeros V .x F .x..x..x..x O .d L .d" },
{ 701452291, "lfspgout FID .x..x..x..x FL .d FO .d NP .d" },
{ 701452292, "   diskw FID .x..x..x..x FO .d WL .d DB .d" },
{ 701452293, "   diskwZeros FID .x..x..x..x FO .d WL .d DB .d" },
{ 701452294, "vnva_GetAttr: evp .#x ap .#x extended .d" },
{ 701452295, "vnva_GetAttr end: md .#x perms .#x anonperms .#x" },
{ 701452296, "vnax_GetAnonAccess: aclLen .#x perms .#x" },
{ 701452297, "vnax_GetAccess: pacListP .#x aclP .#x perms .#x code .d" },
{ 701452298, "vnax_GetAccess: pacListP .#x perms .#x" },
{ 701452299, "vnax_GetAccess: code .d, .x" },
{ 701452300, ".s" },
{ 701452301, "vol_efsOpen: vid .lu has no last index: code .lu" },
{ 701452302, "vol_efsTwiddleInconBit: vid .lu, turnon=.lu" },
{ 701452303, "vol_efsTwiddleInconBit: vid .lu, returning .lu" },
{ 701452304, "vol_efsClose: vid .lu, isabort .lu, returning .lu" },
{ 701452305, "vol_efsDeplete: vid .lu; beginning init pass" },
{ 701452306, "vol_efsDeplete: vid .lu; ending init pass" },
{ 701452307, "vol_efsAttach: attaching vid .lu" },
{ 701452308, "vol_efsDetach: detaching vid .lu" },
{ 701452309, "vol_efsDetach: vid .lu: count .lu != (.lu + 1), so failing" },
{ 701452310, "vol_efsDetach: vid .lu: InUse code .lu, so failing" },
{ 701452311, "vol_efsDetach: vid .lu: succeeding" },
{ 701452312, "vol_efsClone: vids .lu and .lu; beginning init pass" },
{ 701452313, "vol_efsClone: vids .lu and .lu; ending init pass" },
{ 701452314, "efsSomeClone, reclone=.ld: vids .lu and .lu; beginning init pass" },
{ 701452315, "efsSomeClone, reclone=.ld: vids .lu and .lu; ending init pass" },
{ 701452316, "vnm_StopUse: vid .lu; flags=.lu; .lu vnodes to scan" },
{ 701452317, "vnm_StopUse: vid .lu; evp .#lx (#.ld) flags .#lx: sleeping for WAITFORME" },
{ 701452318, "vnm_StopUse: vid .lu; evp .#lx (#.ld) flags .#lx: shutting down" },
{ 701452319, "vnm_StopUse: vid .lu; finished" },
{ 701452320, "vnm_FindVnode: sleeping for .#lx: flags .#lx" },
{ 701452321, "vnm_Inuse: sleeping for .#lx: flags .#lx" },
{ 701452322, "efs_reclaim: sleeping for .#lx: flags .#lx" },
{ 701452323, "vnm_StopUse: back from calling vnm_SyncVnodes()" },
{ 701452324, "efs_PageInDaemon: bp .#x blkno .#x bcount .#x flags .#x" },
{ 701452325, "efs_PageinDaemon: calling efs_pagein(.#x) (vp .#x)" },
{ 701452326, "efs_PageinDaemon: bp .#x finished" },
{ 701452327, "efs_PageOutDaemon: bp .#x blkno .#x bcount .#x flags .#x" },
{ 701452328, "efs_PageOutDaemon: calling efs_PageOut(.#x) (vp .#x)" },
{ 701452329, "efs_PageOutDaemon: bp .#x finished" },
{ 701452330, "PageUnprotectDaemon: bp .#x blkno .#x bcount .#x flags .#x" },
{ 701452331, "PageUnprotectDaemon: calling efs_PageUnprotect(.#x) (vp .#x)" },
{ 701452332, "PageUnprotectDaemon: bp .#x finished" },
{ 701452333, "vol_efsScan: in vid .lu epif_GetStatus fails on fid.index .lu with code .lu" },
{ 701452334, "vnode layer converted error .lu to error .lu in file .s at line .d" },
{ 701452335, ".s: evp .#x fid .lu vnva_GetAttr failed with code .lu" },
{ 701452336, "efs_lookup: name .s in non-dir object devp .#x, fid .lu fails, code .lu" },
{ 701452337, "efs_lookup: name .s in unlinked dir devp .#x fid .lu fails, code .lu" },
{ 701452338, "vnax_CanAccess: devp .#x fid .lu, epif_GetStatus returns .lu" },
{ 701452339, "efs_lookup: name .s in devp .#x fid .lu, vnax_CanAccess fails code .lu" },
{ 701452340, "efs_create: name .s in devp .#x fid .lu, failed code .d" },
{ 701452341, "efs_create: name .s in devp .#x fid .lu, succeeded evp .#x" },
{ 701452342, "vnva_GetAttr: evp .#x ap .#x fid.index .lu epif_GetStatus fails with code .lu" },
{ 701452343, "EV_DEPHANTOM: evp .#x is stale" },
{ 701452344, "vol_efsDetach: vid .lu: count .lu; had already been detached or destroyed" },
{ 701452345, "ReleVnVol(.#x): releasing vnode .#x" },
{ 701452346, "VFtoEV, vid .d: saving vn in voldata .#x: replacing .#x with .#x" },
{ 701452347, "efs_CopyAcl, vid .d: saving vn in voldata .#x: replacing .#x with .#x" },
{ 701452348, "vnm_VnodeBusy: evp .#x, flags .#lx" },
{ 701452349, "vnm_VnodeNotBusy: evp .#x, flags .#lx" },
{ 701452350, "vnm_VnodeNotBusy: waking evp .#x" },
{ 701452351, "vnm_VnodeNotBusy: wakeup any with evp .#x" },
{ 701452352, "vnm_WaitForBusyVnode: evp .#x, lock .#x" },
{ 701452353, "vnm_WaitForAnyBusyVnode: lock .#x" },
{ 701452354, "efs_unmount: vol .#x, epig_CloseVolume failed, code .#x" },
{ 701452355, "efs_unmount: aggr .#x, epig_CloseAggregate failed, code .#x" },
{ 701452356, "efs_unmount: vfsp .#x, vol .#x, avl .#x starting" },
{ 701452357, "efs_unmount: vfsp .#x, vol .#x, avl .#x completed" },
{ 701452358, "efs_unmount: vfsp .#x got .#x from vnm_Inuse, returning EBUSY" },
{ 701452359, "efs_unmount: success of forced unmount of vfsp .#x inspite of code .#x from vnm_Inuse" },
{ 701452360, "vnm_Inuse: busy vnode .#x, index .#x, ref count .d, state .#x" },
{ 701452361, "vol_efsSetAcl: unauthenticated entry from .s acl for fid .#x..#x, volume id .#x..#x was removed" },
{ 701452362, "ValidateRename: trouble obtaining locks on src .s, targ .s after .d loops" },
{ 701452363, "efs_vmread .#x off .lld len .ld" },
{ 701452364, "efs_vmwrite .#x off .lld len .ld" },
{ 701452365, "efs_getpage .#x off .#llx len .#x rw .#x" },
{ 701452366, "efs_getpage failed code .d" },
{ 701452367, "efs_getpage returns .d pages (prot = .#x)" },
{ 701452368, "efs_putpage .#x off .#llx len .#x flags .#x" },
{ 701452369, "efs_putapage .#x off .#llx flags .#x" },
{ 701452370, "efs_GetContents .#x off .lld len .ld rblk .#x" },
{ 701452371, "putcontents" },
{ 701452372, "create dirty zero pages for .#x .#llx -> .#llx" },
{ 701452373, "zero to end of page vp .#x off .lld" },
{ 701452374, "CreateBlock vp .#x off .lld len .lld first block .#x" },
{ 701452375, "CreateBlock fails with code .d" },
{ 701452376, "CopyBlock vp .#x off .lld remaining .d rblk .#x" },
{ 701452377, "CopyBlock fails with code .d" },
{ 701452378, "efs_HoldContents .#x off .lld len .d" },
{ 701452379, "efs_ZeroBytes vp .#x dblk .#x len .d" },
{ 701452380, "vol_efsDeplete: vid .lu; done with code .d" },
{ 701452381, "vol_efsGetStatus: vid .lu, VV .d" },
{ 701452382, "vol_efsGetStatus with code .d gets new vid .lu, states .#x VV .d" },
{ 701452383, "vol_efsScan in vid .d to position .d" },
{ 701452384, "vol_efsScan in vid .d past EOF to position .d" },
{ 701452385, "vol_efsScan in vid .d at position .d to a deleted file" },
{ 701452386, "vol_efsCreate in vid .d at position .d" },
{ 701452387, "vol_efsCreate: file exists, new unique .d, old unique .d" },
{ 701452388, "vol_efsCreate(vid .d, position .d) failed with code .d" },
{ 701452389, "vol_efsCreate(vid .d, position .d) succeeded" },
{ 701452390, "vol_efsAppenddir, vid .d, dir .d, entries .d, preserve .d" },
{ 701452391, "vol_efsAppenddir: entry .s, vnum .d, off .d, pieces .d" },
{ 701452392, "vol_efsAppenddir(vid .d, dir .d) failed with code .d" },
{ 701452393, "vol_efsAppenddir(vid .d, dir .d) succeeded" },
{ 701452394, "vol_efsTruncate(vid .d, vnum .d, newsz .lld) failed with code .d" },
{ 701452395, "vol_efsTruncate(vid .d, vnum .d, newsz .lld) succeeded" },
{ 701452396, "vol_efsDelete in vid .d the fid .#x..#x, code .d" },
{ 701452397, "vol_efsGetAttr with code .d sees linkCount .d, VV .d" },
{ 701452398, "vol_efsSetAttr with code .d sees linkCount .d, VV .d" },
{ 701452399, "efs_rename of .#x/.s to .#x/.s failed" },
{ 701452400, "efs_rename code .d" },
{ 701452401, "vol_efsRead evp .#x, off .lld, len .d, fileLen .lld" },
{ 701452402, "vol_efsWrite evp .#x, off .lld, len .lld, fileLen .lld" },
{ 701452403, "vol_efsReadHole volp .#x, fid .x..x..x..x, off .lu,,.lu, len .d" },
{ 701452404, "vol_efsReadHole error from VFtoEV, volp .#x, fid .x..x..x..x, code .d" },
{ 701452405, "vol_efsReadHole on vdev file, volp .#x, fid .x..x..x..x, code .d" },
{ 701452406, "vol_efsReadHole past file EOF, evp .#x, filelen .lld, offset .#lld, code .d" },
{ 701452407, "vol_efsReadHole error from vol_efsBioWait/copyout, evp .#x, code .d" },
{ 701452408, "vol_efsReadHole error from osi_ZeroUData uaddr .#x, zero len .#llx, code .d" },
{ 701452409, "efs_setup_ra evp .#x, raOff .#llx, reason .d" },
{ 701452410, "efs_setup_ra evp.#x, raOff .#llx, rLen .#llx, raLen .#x" },
{ 701452411, "efs_do_ra evp .#x, off .#llx, len .#x" },
{ 701452412, "efs_getpage_io evp 0x.x, off 0x.llx, rLen 0x.x, delta 0x.x" },
{ 701452413, "efsx_getacl: non delegation aware client requested evp .#x, .d type acl with delegate entries, code .d" },
{ 701452414, "vnax_GetAccess unauth access on vp .#x by uid .d" },
{ 701452415, "vnax_GetAccess foreign access on no ACL vp .#x by PAC list .#x" },
{ 701452416, "vnd_dirLookup: found negative cache devp .#x, name .s" },
{ 701452417, "vnd_dirLookup: found positive cache devp .#x, name .s, fid .#x..#x" },
{ 701452418, "vnd_dirLookup: dir_Lookup devp .#x, name .s failed with code .d" },
{ 701452419, "vnd_dirLookup: enter negative cache devp .#x, name .s" },
{ 701452420, "vnd_dirLookup: enter positive cache devp .#x, name .s, fid .#x..#x" },
{ 701452421, "vnd_dirCheck: found negative cache devp .#x, name .s. Invalidate cache" },
{ 701452422, "vnd_dirCheck: found positive cache devp .#x, name .s, fid .#x..#x. Invalidate cache" },
{ 701452423, "vnd_Rename: invalidate dir cache for so vp .#x" },
{ 701452424, "vnd_Rename: invalidate sd vp .#x, sname .s, td vp .#x, tname .s" },
{ 701452425, "Episode: OpenVnode vol id (low word) .#x, fid index .#x, evp .#x, code .d" },
{ 701452426, "Episode: Recycle vnode .#x, vol id (low word) .#x, fid .#x..#x" },
{ 701452427, "vol_efsDetach: detaching vid .lu, anyForce .#x" },
{ 701452428, "vnva_SetAttr invalidating access cache for vp .#x" },
{ 701452429, "vnva_SetAcl invalidating access cache for vp .#x" },
{ 701452430, "Episode: KillCacheStatus invalidating access cache for vp .#x" },
{ 701452431, "Episode: ReinitVnode invalidating access cache for vp .#x" },
{ 701452432, "vnax_CanAccess: access cache hit, evp .#x, uid .#x, cached .#x, desired .#x" },
{ 701452433, "vnax_CanAccess: access cache miss, evp .#x, uid .#x, desired .#x" },
{ 701452434, "vnax_CanAccess: access cache update, evp .#x, uid .#x, cached .#x, desired .#x" },
{ 701452435, "vol_efsGetAttr (vid .d, pos .d) outputs info on deleted file" },
{ 701452436, "vol_efsGetNextHoles volp .#x, fid .x..x..x..x, off .lu,,.lu" },
{ 701452437, "vol_efsGetNextHoles error from VFtoEV, volp .#x, fid .x..x..x..x, code .d" },
{ 701452438, "vol_efsGetNextHoles on vdev file, volp .#x, fid .x..x..x..x, code .d" },
{ 701452439, "vol_efsGetNextHoles error from osi_ZeroUData uaddr .#x, zero len .#x, code .d" },
{ 701452440, "vol_efsGetNextHoles error from osi_ZeroUData (at end) uaddr .#x, zero len .#x, code .d" },
{ 701452441, "vol_efsGetNextHoles error from vol_efsBioWait/copyout, evp .#x, code .d" },
{ 701452442, "vol_efsGetNextHoles: range [.#llx .. .#llx) becomes [.#llx .. .#llx)" },
{ 701452443, "vnm_Truncate evp .#x, len .lld, flags .#x" },
{ 701452444, "vnm_Truncate failed evp .#x, len .lld, flags .#x, code .d" },
{ 701452445, "vnm_Truncate passed evp .#x, len .lld, flags .#x" },
{ 701452446, "efs_vmread .#x off .lld len .ld, result .d" },
{ 701452447, "efs_vmwrite ends .#x off .lld resid .d, result .d" },
{ 701452448, "efsx_punch evp .#x, flags .#x, off .#x,.#x, len .#x,.#x" },
{ 701452449, "efsx_punch finished evp .#x, code .d" },
{ 701452450, "efsx_readinvis vp .#x, off .#x,.#x, len .#x,.#x" },
{ 701452451, "efsx_readinvis vp .#x, code .d, outlen #.x,#.x" },
{ 701452452, "efsx_writeinvis vp .#x, off .#x,.#x, len .#x,.#x" },
{ 701452453, "efsx_writeinvis vp .#x, code .d, outlen #.x,#.x" },
{ 701452454, "efsx_probehole vp .#x, in offset .#x,,.#x, in length .#x,,.#x" },
{ 701452455, "efsx_probehole vp .#x, code .d, out offset .#x,,.#x, out length .#x,,.#x" },
{ 701452456, "vnm_StopUse: volid .#x,,.#x openbits .#x, oldopen .#x" },
{ 701452457, "vnm_StopUse: volid .#x,,.#x processed .d vnodes" },
{ 701452458, "vol_efsAppenddir: entry .s, vnum .d, codeset tag .d (NONZERO); failing with EINVAL" },
{ 701452459, "efs_MWB vp .#x, off .lld, len .d, flags .#x" },
{ 701452460, "efs_MWB vp .#x, purged region at offset .lld, alen .lld, code .d" },
{ 701452461, "CreateBlock vp .#x, off .d, len .d, internalflags .#x" },
{ 701452462, "efs_vmwrite vp .#x, purged region at offset .d, size .d, code .d" },
{ 701452463, "efs_getextentinfo vp .#x, offset .#llx, nextents .d, flags .#x" },
{ 701452464, "efs_getextentinfo vp .#x, file length .#llx" },
{ 701452465, "efs_getextentinfo findblocks offset .#llx, dblk .#x, wLen .#x, rLen .#x" },
{ 701452466, "efs_getextentinfo end vp .#x, offset .#llx, nextents .d, flags .#x" },
{ 701452467, "OpenVnode: failed to open anode for fid .#x..#x with code .lu, returning ESTALE" },
{ 701452468, "ag_efsAttach aggregate hdr disk flags .#x, attach flags .#x, code .d" },
{ 701452469, "vol_efsPunch fid .x..x..x..x, offset .#x,,.#x, length .#x,,.#x, flags .#x" },
{ 701452470, "vol_efsPunch code .d" },
{ 701452471, "vol_efsGetXtdattr fid .x..x..x..x" },
{ 701452472, "vol_efsGetXtdattr code .d" },
{ 701452473, "vol_efsSetXtdattr fid .x..x..x..x" },
{ 701452474, "vol_efsSetXtdattr code .d" },
{ 701452475, "EV_DEPHANTOM (line #.d): evp .#x is stale" },
{ 701452476, "efs_GetVolume: evp .#x is stale" },
{ 701452477, "efs_DiscardVM vp .#x, oldLen .lld, newLen .lld, fpage .ld" },
{ 701452478, "efs_Promote vp .#x, src .d, dest .d" },
{ 701452479, "efs_Promote result .ld" },
{ 701452480, "efs_PutContents vp .#x, wblk .#x, len .ld, unlock .d" },
{ 701452481, " zlp info dblk .#x, ioOff .lld, zoff .ld, iolen .ld" },
{ 701452482, "efs_StabilizeVM vp .#x, fpage .ld, npages .ld" },
{ 701452483, "efs_read_strategy bp .#x, evp .#x, off .lld, flen .lld" },
{ 701452484, "disk read off .lld len .ld dblk .#x, ioflags .#x" },
{ 701452485, "efs_write_strategy bp .#x, evp .#x, off .lld, alen .lld" },
{ 701452486, "disk write off .lld len .ld dblk .#x, ioflags .#x" },
{ 701452487, "CreateBlock vp .#x, off .d, len .d" },
{ 701452488, "CreateBlock ends vp .#x len .lld first block .#x, code .d" },
{ 701452489, "vnva_SetAttr: evp .#x, mask .#x, markmask .#x" },
{ 701452490, "efs_GetContentsNoVM begin evp .#x len .d rblk .d" },
{ 701452491, "efs_GetContentsNoVM done code .d" },
{ 701452492, "efs_PutContentsNoVM begin evp .#x len .d rblk .d" },
{ 701452493, "efs_PutContentsNoVM done code .d" },
{ 701452494, "efs_AsyncGetContentsNoVM begin evp .#x len .d rblk .d" },
{ 701452495, "efs_AsyncPutContentsNoVM begin evp .#x len .d rblk .d" },
{ 701452496, "efsx_readinvis: len = .#llx, rlen = .#llx, osize = .#llx, iolen = .#llx" },
{ 701452497, "zlistAdd evp .#x, page .d" },
{ 701452498, "zlistAdd FULL inlist .d" },
{ 701452499, "zlistRelease evp .#x page .d, is reader .d" },
{ 701452500, "disk zero failed code .d, page .d" },
{ 701452501, "vnd_Rename: delete prefix trans .d, do/undo .d code .d" },
{ 701452502, "vnd_Rename: create or replace error code .d" },
{ 701452503, "vnd_Rename: fixdotdot trans .d do/undo .d code .d" },
{ 701452504, "vnd_Rename: delete_suffix trans .d code .d" },
{ 701575169, "flserver calling dfs_GetJunctionName for .s" },
{ 701575170, "flserver calling dfsauth_server_InitAuthentication" },
{ 701575171, "flserver calling ubik_ServerInit" },
{ 701575172, "flserver calling ubik_GetServerList" },
{ 701575173, "ubik_GetServerList returns .d servers" },
{ 701575174, "flserver ready to service requests" },
{ 701575175, "flserver unregistering interface" },
{ 701575176, "vlwrite(trans=0x.x, off=.d, buf=0x.x, len=.d) entered" },
{ 701575177, "vlwrite returns .d" },
{ 701575178, "vlread(trans=0x.x, off=.d, buf=0x.x, len=.d) entered" },
{ 701575179, "vlread returns .d" },
{ 701575180, "vlentrywrite(trans=0x.x, off=.d, buf=0x.x, len=.d) entered" },
{ 701575181, "vlentryread(trans=0x.x, off=.d, buf=0x.x, len=.d) entered" },
{ 701575182, "vlentrywrite returns .d" },
{ 701575183, "vlentryread returns .d" },
{ 701575184, "write_vital_vlheader(trans=0x.x) entered" },
{ 701575185, "write_vital_vlheader returns .d" },
{ 701575186, "CheckInit(trans=0x.x) entered" },
{ 701575187, "CheckInit: check for db update" },
{ 701575188, "CheckInit: reread db" },
{ 701575189, "CheckInit: initialize fldb header" },
{ 701575190, "CheckInit: fldb initialization failed, errorcode=.d" },
{ 701575191, "CheckInit returns 0" },
{ 701575192, "AllocBlock(trans=0x.x, tentry=0x.x, errp=0x.x) entered" },
{ 701575193, "AllocBlock failed in read, err=.d" },
{ 701575194, "AllocBlock failed because blockindex = 0" },
{ 701575195, "AllocBlock failed in write, err=.d" },
{ 701575196, "AllocBlock returns blockindex .d" },
{ 701575197, "FreeBlock(trans=0x.x, blockindex=.d) entered" },
{ 701575198, "FreeBlock returns .d" },
{ 701575199, "FindById(trans=0x.x, volid=.d,,.d, voltix=.d, tentry=0x.x, ...) entered" },
{ 701575200, "FindById: hash volid to .d" },
{ 701575201, "FindById returns blockindex .d (errorcode = .d)" },
{ 701575202, "FindByName(trans=0x.x, volname=.s, tentry=0x.x, errp=0x.x) entered" },
{ 701575203, "FindByName: hash volid to .d" },
{ 701575204, "FindByName returns blockindex .d (errorcode = .d)" },
{ 701575205, "ThreadVLentry (trans=0x.x, blockindex=.d, tentry=0x.x) entered" },
{ 701575206, "ThreadVLentry returns .d" },
{ 701575207, "UnthreadVLentry (trans=0x.x, blockindex=.d, aentry=0x.x) entered" },
{ 701575208, "UnthreadVLentry returns .d" },
{ 701575209, "HashVolid(trans=0x.x, voltix=.d, blockindex=.d, tentry=0x.x) entered" },
{ 701575210, "HashVolid returns .d" },
{ 701575211, "UnhashVolid(trans=0x.x, voltix=.d, blockindex=.d, aentry=0x.x) entered" },
{ 701575212, "UnhashVolid returns .d" },
{ 701575213, "HashVolname(trans=0x.x, blockindex=.d, aentry=0x.x) entered" },
{ 701575214, "HashVolname returns .d" },
{ 701575215, "UnhashVolname(trans=0x.x, blockindex=.d, aentry=0x.x) entered" },
{ 701575216, "UnhashVolname returns .d" },
{ 701575217, "NextEntry (trans=0x.x, blockindex=.d, tentry=0x.x, remaining=0x.x) entered" },
{ 701575218, "NextEntry returns .d (remaining = .d)" },
{ 701575219, "Init_VLdbase (transPP=0x.x, locktype=.d, op=.d) entered (readany=.d)" },
{ 701575220, "InitVLdbase returns .d" },
{ 701575221, "VL_CreateEntry(connp=0x.x, newentry=0x.x) entered" },
{ 701575222, "VL_CreateEntry returns .d" },
{ 701575223, "VL_DeleteEntry(connp=0x.x, volid=.d,,.d, voltype=.d) entered" },
{ 701575224, "VL_DeleteEntry returns .d" },
{ 701575225, "VL_GetEntryByID (connp=0x.x, volid=.d,,.d, voltype=.d, aentry=0x.x) entered" },
{ 701575226, "VL_GetEntryByID returns .d" },
{ 701575227, "VL_GetEntryByName (connp=0x.x, volname=.s, aentry=0x.x) entered" },
{ 701575228, "VL_GetEntryByName returns .d" },
{ 701575229, "VL_GetNewVolumeId (connp=0x.x, Maxvolidbump=.d, Addrp=0x.x, newvolumeid=0x.x) entered" },
{ 701575230, "VL_GetNewVolumeId returns new volume .d,,.d" },
{ 701575231, "VL_GetNewVolumeId returns .d" },
{ 701575232, "VL_ReplaceEntry (connp=0x.x, volid=.d,,.d, voltype=.d, newentry=0x.x, ...) entered" },
{ 701575233, "VL_ReplaceEntry returns .d" },
{ 701575234, "VL_SetLock (connp=0x.x, volid=.d,,.d, voltype=.d, voloper=.d) entered" },
{ 701575235, "VL_SetLock returns .d" },
{ 701575236, "VL_ReleaseLock (connp=0x.x, volid=.d,,.d, voltype=.d, releasetype=.d) entered" },
{ 701575237, "VL_ReleaseLock returns .d" },
{ 701575238, "VL_ListEntry (connp=0x.x, prev=.d, count=0x.x, next=0x.x, ...) entered" },
{ 701575239, "VL_ListEntry returns .d" },
{ 701575240, "VL_ListByAttributes(connp=0x.x, attributes=0x.x, cookie=0x.x, nentries=0x.x, ...) entered" },
{ 701575241, "VL_ListByAttributes returns .d" },
{ 701575242, "VL_GetStats(connp=0x.x, stats=0x.x, vital_header=0x.x) entered" },
{ 701575243, "VL_GetStats returns .d" },
{ 701575244, "VL_AddAddress(connp=0x.x, OldAddr=0x.x, AddrToAdd=0x.x) entered" },
{ 701575245, "VL_AddAddress returns .d" },
{ 701575246, "VL_RemoveAddress(connp=0x.x, AddrToRemove=0x.x) entered" },
{ 701575247, "VL_RemoveAddress returns .d" },
{ 701575248, "VL_ChangeAddress(connp=0x.x, OldAddr=0x.x, NewAddr=0x.x) entered" },
{ 701575249, "VL_ChangeAddress returns .d" },
{ 701575250, "VL_GetCellInfo(connp=0x.x, MyCell=0x.x) entered" },
{ 701575251, "VL_GetCellInfo returns .d" },
{ 701575252, "VL_GetNextServersByID (connp=0x.x, volid=.d,,.d, voltype=.d, startHere=.d, ...) entered" },
{ 701575253, "VL_GetNextServersByID returns .d" },
{ 701575254, "VL_GetNextServersByName (connp=0x.x, volname=.s, startHere=.d, ...) entered" },
{ 701575255, "VL_GetNextServersByName returns .d" },
{ 701575256, "VL_GetSiteInfo(connp=0x.x, OldAddr=0x.x, FullSiteInfo=0x.x) entered" },
{ 701575257, "VL_GetSiteInfo returns .d" },
{ 701575258, "VL_GenerateSites(connp=0x.x, startHere=.d, ..., TheseSites=0x.x, nSites=0x.x) entered" },
{ 701575259, "VL_GenerateSites returns .d" },
{ 701575260, "VL_GenerateSites returning .d sites at 0x.x" },
{ 701575261, "VL_GetNewVolumeIds (connp=0x.x, numWanted=.d, Addrp=0x.x, newIDs=0x.x) entered" },
{ 701575262, "VL_GetNewVolumeIds returns .d" },
{ 701575263, "VL_CreateServer (connp=0x.x, FullSiteInfo=0x.x) entered" },
{ 701575264, "VL_CreateServer returns .d" },
{ 701575265, "VL_Probe(connp=0x.x) entered" },
{ 701575266, "VL_GetCEntryByID (connp=0x.x, volid=.d,,.d, voltype=.d, centryp=0x.x) entered" },
{ 701575267, "VL_GetCEntryById returns .d" },
{ 701575268, "VL_GetCEntryByName (connp=0x.x, volname=.s, centryp=0x.x) entered" },
{ 701575269, "VL_GetCEntryByName returns .d" },
{ 701575270, "VL_GetCNextServersByID (connp=0x.x, volid=.d,,.d, voltype=.d, startHere=.d, ...) entered" },
{ 701575271, "VL_GetCNextServersByID storing entry in 0x.x, flags in 0x.x" },
{ 701575272, "VL_GetCNextServerByID returns .d" },
{ 701575273, "VL_GetCNextServersByName (connp=0x.x, volname=.s, startHere=.d, ...) entered" },
{ 701575274, "VL_GetCNextServersByName storing entry in 0x.x, flags in 0x.x" },
{ 701575275, "VL_GetCNextServerByName returns .d" },
{ 701575276, "VL_AlterServer(connp=0x.x, AddrOfHost=0x.x, AttrsP=0x.x) entered" },
{ 701575277, "VL_AlterServer returns .d" },
{ 701575278, "VL_ExpandSiteCookie (connp=0x.x, Cookie=.d, FullSiteInfo=0x.x) entered" },
{ 701575279, "VL_ExpandSiteCookie returns .d" },
{ 701575280, "VL_GetServerInterfaces (connp=0x.x, serverInterfacesP=0x.x) entered" },
{ 701575281, "VL_GetServerInterfaces returns .d" },
{ 701575282, "RemoveEntry(trans=0x.x, entryptr=.d, tentry=0x.x) entered" },
{ 701575283, "RemoveEntry returns .d" },
{ 701575284, "FreeSiteQuota(trans=0x.x, tentry=0x.x) entered" },
{ 701575285, "FreeSiteQuota returns .d" },
{ 701575286, "vldbentry_to_vlentry(atrans=0x.x, VldbEntry=0x.x, VlEntry=0x.x) entered" },
{ 701575287, "vldbentry_to_vlentry returns 0" },
{ 701575288, "vlentry_to_vldbentry(trans, VlEntry, VldbEntry) entered" },
{ 701575289, "vlentry_to_vldbentry returns 0" },
{ 701575290, "vlentry_to_comvldbentry(trans=0x.x, vlentp=0x.x, comvldbp=0x.x) entered" },
{ 701575291, "vlentry_to_comvldbentry returns 0" },
{ 701575292, "InvalidOperation: .d" },
{ 701575293, "InvalidRelease: releasetype" },
{ 701575294, "NotFlAdmin(connp=0x.x) entered" },
{ 701575295, "NotFlAdmin returns .d" },
{ 701575296, "AuthForSiteDesc(connp=0x.x, descp=0x.x, ...) entered" },
{ 701575297, "AuthForSiteDesc returns .d, ok=.d" },
{ 701575298, "AuthForAddress(connp=0x.x, trans=0x.x, addrp=0x.x, ...) entered" },
{ 701575299, "AuthForAddress returns .d, ok=.d" },
{ 701575300, "AuthForVlEntry(connp=0x.x, trans=0x.x, vlentryp=0x.x, ...) entered" },
{ 701575301, "AuthForVlEntry returns .d, ok=.d" },
{ 701575302, "GetSite(trans=0x.x, SitePtr=.d, descBuffP=0x.x) entered" },
{ 701575303, "GetSite returns .d" },
{ 701575304, "CarefullyGetSite(trans=0x.x, SitePtr=.d, descBuffP=0x.x) entered" },
{ 701575305, "CarefullyGetSite returns .d" },
{ 701575306, "PutSite(trans=0x.x, SitePtr=.d, descBuffP=0x.x, needLock=.d) entered" },
{ 701575307, "PutSite returns .d" },
{ 701575308, "quotaCheck(trans=0x.x, descaddr=.d, descp=0x.x, quotaIncr=.d) entered" },
{ 701575309, "quotaCheck returns .d" },
{ 701575310, "EnsureAddrEntry(trans=0x.x, Addr=0x.x, OutPtr=0x.x, " },
{ 701575311, "\tDoAlloc=.d, WhichAddr=0x.x, quotaIncr=.d)" },
{ 701575312, "EnsureAddrEntry returns .d" },
{ 701607937, "SFTSERVER_CreateTrans(.#lx, .lu,,.lu, .lu, .#lx, OUT <transIdp>) entered" },
{ 701607938, "SFTSERVER_CreateTrans(#.ld) returns .ld, *transId = .ld" },
{ 701607939, "SFTSERVER_AbortTrans(.#lx, .lu) entered" },
{ 701607940, "SFTSERVER_AbortTrans returns .ld" },
{ 701607941, "SFTSERVER_DeleteTrans(.#lx, .lu) entered" },
{ 701607942, "SFTSERVER_DeleteTrans returns .ld" },
{ 701607943, "SFTSERVER_CreateVolume(.#lx, .lu, .s, .#lx," },
{ 701607944, "\t.#lx, .lu,,.lu, .lu,,.lu, OUT <transIdP>) entered" },
{ 701607945, "SFTSERVER_CreateVolume(#.ld) returns .ld, *transId = .ld" },
{ 701607946, "SFTSERVER_DeleteVolume(.#lx, .ld) entered" },
{ 701607947, "SFTSERVER_DeleteVolume(#.ld) returns .ld" },
{ 701607948, "SFTSERVER_Dump(.#lx, .ld," },
{ 701607949, "\t{.#lx, {.lu, .lu}, .lu,,.lu}," },
{ 701607950, "\t.#lx) entered" },
{ 701607951, "SFTSERVER_Dump returns .ld" },
{ 701607952, "SFTSERVER_Restore(.#lx, .lu, .#lx, .#lx) entered" },
{ 701607953, "SFTSERVER_Restore returns .ld" },
{ 701607954, "SFTSERVER_Forward(.#lx, .lu," },
{ 701607955, "\t{.#lx, {.lu, .lu}, .lu,,.lu}," },
{ 701607956, "\t.#lx, .#lx, .lu/.lu) entered" },
{ 701607957, "SFTSERVER_Forward returns .ld" },
{ 701607958, "SFTSERVER_Clone(.#lx, .lu, .#lx, .s," },
{ 701607959, "\t.lu,,.lu) entered" },
{ 701607960, "SFTSERVER_Clone(#.ld) returns .ld" },
{ 701607961, "SFTSERVER_ReClone(.#lx, .lu, .lu,,.lu) entered" },
{ 701607962, "SFTSERVER_ReClone(#.ld) returns .ld" },
{ 701607963, "SFTSERVER_GetFlags(.#lx, .lu, OUT <OutFlagsp>) entered" },
{ 701607964, "SFTSERVER_GetFlags(#.ld) returns .ld, *OutFlagsp = .#lx" },
{ 701607965, "SFTSERVER_SetFlags(.#lx, .lu, .#lx) entered" },
{ 701607966, "SFTSERVER_SetFlags(#.ld) returns .ld" },
{ 701607967, "SFTSERVER_GetStatus(.#lx, .lu, OUT .#lx) entered" },
{ 701607968, "SFTSERVER_GetStatus(#.ld) returns .ld" },
{ 701607969, "SFTSERVER_SetStatus(.#lx, .lu, .#lx, .#lx) entered" },
{ 701607970, "SFTSERVER_SetStatus(#.ld) returns .ld" },
{ 701607971, "SFTSERVER_ListVolumes(.#lx, .lu, {.lu, <uuid>}, OUT <outCookieP>, OUT <statEntries>) entered" },
{ 701607972, "SFTSERVER_ListVolumes returns .ld, *outCookieP = {.lu, <uuid>}, *statEntries = {.lu, <ftserver_status_val[]>}" },
{ 701607973, "SFTSERVER_ListAggregates(.#lx, {.lu, <uuid>}, OUT <outCookieP>, OUT <aggrList>) entered" },
{ 701607974, "SFTSERVER_ListAggregates returns .ld, *outCookieP = {.lu, <uuid>}, *aggrList = {.lu, <ftserver_aggrEntries_val[]>}" },
{ 701607975, "SFTSERVER_AggregateInfo(.#lx, .lu, OUT <aggrInfop>) entered" },
{ 701607976, "SFTSERVER_AggregateInfo returns .ld, *aggrInfop = {.s, .s, .lu," },
{ 701607977, "\t.lu, .lu, .lu}" },
{ 701607978, "SFTSERVER_Monitor(.#lx, OUT <entriesp>) entered" },
{ 701607979, "SFTSERVER_Monitor returns .ld, *entriesp = {.lu, ftserver_transStatus_val[]}" },
{ 701607980, "SFTSERVER_GetOneVolStatus(.#lx, .lu,,.lu, .lu, <spare1>, OUT .#lx) entered" },
{ 701607981, "SFTSERVER_GetOneVolStatus(#.ld) returns .ld" },
{ 701607982, "SFTSERVER_GetServerInterfaces(.#lx, OUT <serverInterfacesP>) entered" },
{ 701607983, "SFTSERVER_GetServerInterfaces returns .lu, *serverInterfacesP = {.lu, <dfs_interfaceList_val[]>}" },
{ 701607984, "SFTSERVER_SwapIDs(.#lx, .lu, .lu) entered" },
{ 701607985, "SFTSERVER_SwapIDs(#.ld) returns .ld" },
{ 701607986, "getOrigStatus({..., .ld, .ld, .lu,,.lu, .ld, ...}) entered" },
{ 701607987, "getOrigStatus(#.ld) returns .ld" },
{ 701607988, "DeleteTrans(.#lx, .lu, .ld) entered" },
{ 701607989, "DeleteTrans(#.ld) returns .ld" },
{ 701607990, "ftserver_DeleteVolume({..., .ld, .ld, .lu,,.lu, .ld, ...}) entered" },
{ 701607991, "ftserver_DeleteVolume(#.ld) returns .ld" },
{ 701607992, "forwardPull(.#lx, .#lx, .lu, OUT <outSizeP>) entered" },
{ 701607993, "forwardPull returns void, *outSizeP = .lu" },
{ 701607994, "forwardWriter(.#lx," },
{ 701607995, "\t{.#lx, {.lu, .lu}, .lu,,.lu}," },
{ 701607996, "\t{..., .ld, .ld, .lu,,.lu, .ld, ...}) entered" },
{ 701607997, "forwardWriter(#.ld) exits with .ld" },
{ 701607998, "vols_Forward({..., .ld, .ld, .lu,,.lu, .ld, ...}," },
{ 701607999, "\t.#lx, .lu," },
{ 701608000, "\t{.#lx, {.lu, .lu}, .lu,,.lu}," },
{ 701608001, "\t.#lx, .#lx, .lu) entered" },
{ 701608002, "vols_Forward(#.ld) returns .ld" },
{ 701608003, "ftserver_Clone({..., .ld, .ld, .lu,,.lu, .ld, ...}," },
{ 701608004, "\t.lu,,.lu, .s, .#lx) entered" },
{ 701608005, "ftserver_Clone(#.ld) returns .ld" },
{ 701608006, "vols_ReClone({..., .ld, .ld, .lu,,.lu, .ld, ...}," },
{ 701608007, "\t{..., .ld, .ld, .lu,,.lu, .ld, ...}) entered" },
{ 701608008, "vols_ReClone(#.ld) returns .ld" },
{ 701608009, "ftserver_UnClone({..., .ld, .ld, .lu,,.lu, .ld, ...}," },
{ 701608010, "\t{..., .ld, .ld, .lu,,.lu, .ld, ...}) entered" },
{ 701608011, "ftserver_UnClone(#.ld) returns .ld" },
{ 701608012, "vols_FillBaseType({..., .ld, .ld, .lu,,.lu, .ld, ...}) entered" },
{ 701608013, "vols_FillBaseType(#.ld) returns .ld" },
{ 701608014, "vol_syscall(.ld, .#lx, .#lx, .#lx," },
{ 701608015, "\t.#lx) entered" },
{ 701608016, "vol_syscall returns .ld" },
{ 701608017, "ag_syscall(.ld, .#lx, .#lx, .#lx," },
{ 701608018, "\t.#lx) entered" },
{ 701608019, "ag_syscall returns .ld" },
{ 701608020, "ftserver_NewTrans(.lu,,.lu, .lu, OUT <codep>)" },
{ 701608021, "ftserver_NewTrans(#.ld) returns .#lx (t_transId = .lu), *codep = .ld" },
{ 701608022, "ftserver_FindTrans(.ld) entered" },
{ 701608023, "ftserver_FindTrans(#.ld) returns .#lx (t_aggrId = .lu, t_volId = .lu,,.lu)" },
{ 701608024, "ftserver_DeleteTrans({..., .ld, .ld, .lu,,.lu, .ld, ...}," },
{ 701608025, "\t.ld) entered" },
{ 701608026, "ftserver_DeleteTrans(#.ld) returns .ld" },
{ 701608027, "ftserver_PutTrans({..., .ld, .ld, .lu,,.lu, .ld, ...}" },
{ 701608028, "ftserver_PutTrans(#.ld) returns .ld" },
{ 701608029, "ftserver_GCTrans(void) entered" },
{ 701608030, "ftserver_GCTrans returns .ld" },
{ 701608031, "ftserver_SwapTransStates({..., .ld, .ld, .lu,,.lu, .ld, ...}," },
{ 701608032, "\t{..., .ld, .ld, .lu,,.lu, .ld, ...}) entered" },
{ 701608033, "ftserver_SwapTransStates returns .ld" },
{ 701608034, "vols_Lock(.s) called" },
{ 701608035, "vols_Lock(.s) disables cancels: old state=.ld, cancelCode=.ld" },
{ 701608036, "vols_Unlock(.s) called: old state=.ld" },
{ 701608037, "vols_Unlock(.s) has re-enabled cancels (code .ld)" },
{ 701608038, ".s: Authorization failure, code .ld" },
{ 701608039, ".s: caught exception (code .ld): .s" },
{ 701608040, ".s: Need to drain the input pipe; code so far = .lu" },
{ 701608041, ".s: Draining done, .ld bytes in .ld calls" },
{ 701608042, "SFTSERVER_ConnectSock(.#lx, .ld, .#lx, .#lx)" },
{ 701608043, "SFTSERVER_ConnectSock TCP clntAddr(.ld, .ld, .#lx)" },
{ 701608044, "SFTSERVER_ConnectSock UNIX clntAddr(.ld, .s)" },
{ 701608045, "SFTSERVER_ConnectSock Unsupported protocol(.ld)" },
{ 701608046, "SFTSERVER_ConnectSock TCP srvrAddr(.ld, .ld, .#lx)" },
{ 701608047, "SFTSERVER_ConnectSock UNIX srvrAddr(.ld, .s)" },
{ 701608048, "SFTSERVER_ConnectSock returns .ld" },
{ 701608049, "SFTSERVER_DisconnectSock(.#lx, .ld)" },
{ 701608050, "SFTSERVER_DisconnectSock returns .ld" },
{ 701608051, "SFTSERVER_ListenSock(.#lx, .ld, .#lx)" },
{ 701608052, "SFTSERVER_ListenSock TCP srvrAddr(.ld, .ld, .#lx)" },
{ 701608053, "SFTSERVER_ListenSock returns .ld" },
{ 701608054, "SFTSERVER_AcceptSock(.#lx, .ld, .#lx)" },
{ 701608055, "SFTSERVER_AcceptSock TCP srvrAddr(.ld, .ld, .#lx)" },
{ 701608056, "SFTSERVER_AcceptSock returns .ld" },
{ 701612033, "ftu_AggrGetInfo(.lu, OUT <aggrInfoP>) entered" },
{ 701612034, "ftu_AggrGetInfo returns .ld, *aggrInfoP = {.s, .s, .ld," },
{ 701612035, "\t.ld, .ld, .ld}" },
{ 701612036, "ftu_AggrSync(.lu, .d) entered" },
{ 701612037, "ftu_AggrSync returns .ld" },
{ 701612038, "ftu_AggrCreateFsetWithStatus(.lu, .u,,.u, {..., .u,,.u, ..., .#lx" },
{ 701612039, "\t..., .s, ...}, .#lx) entered" },
{ 701612040, "ftu_AggrCreateFsetWithStatus returns .ld" },
{ 701612041, "ftu_AggrOpenFset(.lu, .u,,.u, .#lx," },
{ 701612042, "\t.lu (.s), OUT <fsetDescP>) entered" },
{ 701612043, "ftu_AggrOpenFset returns .ld, *fsetDescP = .ld" },
{ 701612044, "ftu_AggrCloseFset(.ld) entered" },
{ 701612045, "ftu_AggrCloseFset returns .ld" },
{ 701612046, "ftu_AggrAbortFsetOpen(.ld) entered" },
{ 701612047, "ftu_AggrAbortFsetOpen returns .ld" },
{ 701612048, "ftu_AggrEnumerateFsets(.lu, INOUT *indexP = .u, .#lx, .u, OUT <numFsetsReturnedP>) entered" },
{ 701612049, "ftu_AggrEnumerateFsets returns .ld, *indexP = .u, *numFsetsReturnedP = .u" },
{ 701612050, "ftu_AggrLookupFset(.lu, .s, OUT <fsetIdP>) entered" },
{ 701612051, "ftu_AggrLookupFset returns .ld, *fsetIdP = .u,,.u" },
{ 701612052, "ftu_AggrLookupFset returns .ld" },
{ 701612053, "ftu_FsetGetStatus(.ld, OUT <fsetStatusP>) entered" },
{ 701612054, "ftu_FsetGetStatus returns .ld, *fsetStatusP = {.u,,.u, .u,,.u, ... .#lx," },
{ 701612055, "\t.lu (.s), .lx, ..., .s}" },
{ 701612056, "ftu_FsetSetStatus(.ld, .#lx, {.u,,.u, ... .#lx, ...}) entered" },
{ 701612057, "ftu_FsetSetStatus returns .ld" },
{ 701612058, "ftu_FsetBulkSetStatus(.u" },
{ 701612059, "\t, {.ld, .#lx, .u,,.u}" },
{ 701612060, ") entered" },
{ 701612061, "ftu_FsetBulkSetStatus returns .ld" },
{ 701612062, "ftu_FsetPushStatus(.ld) entered" },
{ 701612063, "ftu_FsetPushStatus returns .ld" },
{ 701612064, "ftu_FsetSync(.ld, .ld) entered" },
{ 701612065, "ftu_FsetSync returns .ld" },
{ 701612066, "ftu_FsetClone(.ld, .u,,.u, .s, .#lx) entered" },
{ 701612067, "ftu_FsetClone: Raising .s limit on fset .u,,.u to .u,,.u (was .u,,.u)" },
{ 701612068, "ftu_FsetClone: Zeroing bogus back ID in fset .u,,.u (was .u,,.u)" },
{ 701612069, "ftu_FsetClone returns .ld" },
{ 701612070, "ftu_FsetReclone(.ld) entered" },
{ 701612071, "ftu_FsetReclone returns .ld" },
{ 701612072, "ftu_FsetRecloneInto(.ld, .u,,.u) entered" },
{ 701612073, "ftu_FsetRecloneInto returns .ld" },
{ 701612074, "RecloneIntoAdjacentFset: Raising .s limit on fset .u,,.u to .u,,.u (was .u,,.u)" },
{ 701612075, "DestroyFset(.ld, .ld) entered" },
{ 701612076, "DestroyFset: Ignoring bogus back ID in fset .u,,.u (was .u,,.u)" },
{ 701612077, "DestroyFset: Ignoring bogus fwd. ID in fset .u,,.u (was .u,,.u)" },
{ 701612078, "DestroyFset: Raising .s limit on fset .u,,.u to .u,,.u (was .u,,.u)" },
{ 701612079, "DestroyFset returns .ld" },
{ 701612080, "ftu_FsetDumpToPipe(.ld," },
{ 701612081, "\t{.#lx, {.lu, .lu}, .lu,,.lu}," },
{ 701612082, "\t.#lx) entered" },
{ 701612083, "ftu_FsetDumpToPipe returns .ld" },
{ 701612084, "ftu_FsetRestoreFromPipe(.ld, .#lx, .#lx) entered" },
{ 701612085, "ftu_FsetRestoreFromPipe returns .ld" },
{ 701612086, "ftu_AggrSyscall(.ld, .#lx, .#lx, .#lx" },
{ 701612087, "\t.#lx) entered" },
{ 701612088, "ftu_AggrSyscall returns .ld" },
{ 701612089, "ftu_VolSyscall(.ld, .#lx, .#lx, .#lx," },
{ 701612090, "\t.#lx) entered" },
{ 701612091, "ftu_VolSyscall returns .ld" },
{ 701612092, "ftu_FsetCloneWithKA: Failed to open (and thus destroy) .s (.u,,.u)" },
{ 701612093, "vols_DumpVolume: Caught exception: .s" },
{ 701612094, ".s(.ld, .ld, .#lx," },
{ 701612095, "\t.#lx, .#lx) entered" },
{ 701612096, ".s returns .ld" },
{ 701612097, "ftutil_VolDepleteAux(.ld, .#lx, .#lx, .#lx) entered" },
{ 701612098, "ftutil_VolDepleteAux returns .ld" },
{ 701612099, "ftu_FsetSwapIds(.ld, .ld) entered" },
{ 701612100, "ftu_FsetSwapIds returns .ld" },
{ 701612101, "ftu_VolSyscall(.ld) returns .ld" },
{ 701612102, "vols_RestoreVnode: can't set acl type .d in vnode .d: error .d" },
{ 701612103, "vols_DumpData: reading at offset .#llx for length .#lx" },
{ 701612104, "vols_DumpData: op returns .d, len .#lx; holeOff .#lx,,.lx, holeLen .#lx,,.lx" },
{ 701931521, "FSHS fshs_GetHost, cookie .x" },
{ 701931522, "FSHS fshs_FindHost, cookie .x" },
{ 701931523, "FSHS find a prime host .x" },
{ 701931524, "FSHS find a sec host : .x, its prime host : .x" },
{ 701931525, "FSHS allocate a prime host .x" },
{ 701931526, "FSHS allocate a sec host .x" },
{ 701931527, "FSHS find a host from slow path .x" },
{ 701931528, "FSHS find a down host from slow path .x" },
{ 701931529, "FSHS callback fails with ipaddr .x" },
{ 701931530, "FSHS find a host in fast path .x" },
{ 701931531, "FSHS cannot find a host in fast path" },
{ 701931532, "FSHS PutHost ref = .d" },
{ 701931533, "FSHS fshs_GCHost .x ref .d" },
{ 701931534, "FSHS GC a prime host" },
{ 701931535, "FSHS MarkSecHostBad: prime .x sec .x" },
{ 701931536, "FSHS fshs_UpdateHostList called" },
{ 701931537, "FSHS fshs_AssignHost .x, ipaddr .x" },
{ 701931538, "FSHS fshs_FreeHost .x" },
{ 701931539, "FSHS fshs_CheckHost START .x" },
{ 701931540, "FSHS fshs_CheckHost END" },
{ 701931541, "FSHS CheckHost: stale princ .x ref .d" },
{ 701931542, "FSHS fshs_HostCheckDaemon .." },
{ 701931543, "FSHS fshs_Enumerate END" },
{ 701931544, "FSHS fshs_Enumerate START" },
{ 701931545, "FSHS fshs_SetRecoveryParam.. " },
{ 701931546, "FSHS fshs_AllocPrincipal START.." },
{ 701931547, "FSHS fshs_AllocPrincipal END.." },
{ 701931548, "FSHS fshs_FreePrincipal .x" },
{ 701931549, "FSHS fshs_FindPrincipal.. " },
{ 701931550, "FSHS found a princ slow .x ref .d" },
{ 701931551, "FSHS found a princ fast .x ref .d" },
{ 701931552, "FSHS rock hits .d, misses .d, cache empty .d, repop .d" },
{ 701931553, "FSHS fshs_GetPrincipal START" },
{ 701931554, "FSHS fshs_GetPrincipal END .x, ref .d" },
{ 701931555, "FSHS find a princ (fast path) .x, ref .d" },
{ 701931556, "FSHS assign a princ (slow path) .x" },
{ 701931557, "FSHS fshs_PutPrincipal .x ref .d" },
{ 701931558, "FSHS fshs_GCPrinc from host .x" },
{ 701931559, "FSHS fshs_GCPrinc found a stale princ .x" },
{ 701931560, "FSHS fshs_GetStalePrincipals START" },
{ 701931561, "FSHS fshs_GetStalePrincipals END" },
{ 701931562, "FSHS fshs_getcred: princp .x, anonymous uid .d" },
{ 701931563, "FSHS fshs_RevokeToken host .x" },
{ 701931564, "FSHS fshs_AsyncGrant host .x" },
{ 701931565, "FSHS tokenint_InitTokenState host .x" },
{ 701931566, "FSHS TKN_TokenRevoke code = .d" },
{ 701931567, "FSHS set callback binding host .x" },
{ 701931568, "FSHS fshs_RevokeToken host .x: flags .#x, .d token(s)" },
{ 701931569, "FSHS fshs_RevokeToken: host .x is down; succeeding vacuously" },
{ 701931570, "FSHS fshs_RevokeToken: RPC timeout (.d secs) exceeded for host .x; marking it DOWN" },
{ 701931571, "FSHS fshs_RevokeToken: lifetime (.d secs) exceeded for host .x; marking it DOWN" },
{ 701931572, "FSHS fshs_GetHost: host .x, states .#lx, flags .#lx: forcing null return" },
{ 701931573, "FSHS fshs_GetTSRCode: host .x, returning .#lx" },
{ 701931574, "FSHS fshs_CreateHost: creating host .x, primary=.d, flags=.#lx; host states now .#lx" },
{ 701931575, "FSHS     and host .x has fshost flags of .#lx" },
{ 701931576, "FSHS fshs_CreateHost: clearing host .#lx" },
{ 701931577, "FSHS fshs_CreateHost: calling TKN_InitTokenState on host .#lx (NOW OBSOLETE)" },
{ 701931578, "FSHS fshs_CreateHost: host .x TKN_InitTokenState returned (NOW OBSOLETE) .ld" },
{ 701931579, "FSHS fshs_CreateHost: host .x cleared: states now .#lx, returning .ld" },
{ 701931580, "FSHS fshs_CreateHost: returning .ld" },
{ 701931581, "FSHS fshs_RevokeToken: host .x refused .d HERE tokens for fileset .lu,,.lu; marking it DOWN" },
{ 701931582, "FSHS entered fshs_SetupDelegationChain" },
{ 701931583, "FSHS entering sec_cred_get_initiator" },
{ 701931584, "FSHS entering sec_cred_initialize_cursor" },
{ 701931585, "FSHS found pa: user .d, group .d, num_groups .d" },
{ 701931586, "FSHS entering sec_cred_get_delegate" },
{ 701931587, "FSHS CreateHost: BindingFromInBinding failed, host .x, code .d, try given binding" },
{ 701931588, "FSHS CreateHost: Can't set rpc call timeout for host .x code .d" },
{ 701931589, "FSHS CreateHost: Trying to call .x/.d rather than .x/.d (net byte order)" },
{ 701931590, "FSHS CreateHost: Result (host .x) is .d" },
{ 701931591, "FSHS fshs_getcred: princp .x is local: uid .d, gid .d, ngroups .d" },
{ 701931592, "FSHS fshs_CheckAuthn: cookie .x, hostp .x, hostp->flags .x..." },
{ 701931593, "FSHS ... minAuthn .d, maxAuthn .d, this .d: result .d" },
{ 701931594, "FSHS fshs_InqContext: inq_auth_caller returns .d (authnLevel .d, authnSvc .d, authzSvc .d) (NOW OBSOLETE)" },
{ 701931595, "FSHS fshs_InqContext: inq_auth_caller returns authz .d, principal name '.s' (NOW OBSOLETE)" },
{ 701931596, "FSHS CreateHost: Authenticating host .x, reverse-binding, as self to .s: result .d" },
{ 701931597, "FSHS CreateHost: Authenticating host .x, given binding, as self to .s: result .d" },
{ 701931598, "FSHS CreateHost: Host .x, addr .x, changing port from .#x to .#x" },
{ 701931599, "FSHS CreateHost: Authenticating host .x, new port binding, as self to .s: result .d" },
{ 701931600, "FSHS fshs_RevokeToken, host .x marked DOWN: lifetime (.d secs) exceeded, err count .d too big, or time since OK rvk .d too big" },
{ 701931601, "FSHS fshs_RevokeToken, Host .x skipping tokenID .lu,,.lu from clamped set." },
{ 701931602, "FSHS fshs_RevokeToken, Host .x: all .d tokens in revoke request were clamped: skipped." },
{ 701931603, "FSHS fshs_RevokeToken (host .x has address .x, rpcguarantee .d secs.)" },
{ 701931604, "FSHS fshs_RevokeToken: host .x (addr .x) refused .d HERE tokens for fileset .lu,,.lu; marking it DOWN" },
{ 701931605, "FSHS fshs_RevokeToken: host .x (addr .x) ignores forceflag .#x, refused types .x,,.x; marking it DOWN" },
{ 701931606, "FSHS fshs_RevokeToken: we revoked .x,,.x from host .x, addr .x, but it refused to revoke .x,,.x" },
{ 701931607, "FSHS fshs_RevokeToken host .x, addr .x: flags .#x, .d token(s)" },
{ 701931608, "FSHS TKN_TokenRevoke to address .x: code = .d" },
{ 701931609, "FSHS fshs_AsyncGrant host .x, addr .x" },
{ 701931610, "FSHS fshs_AsyncGrant host .x, addr .x, RPC returned .d" },
{ 701931611, "FSHS tokenint_InitTokenState host .x, addr .x, tsrCode .#x" },
{ 701931612, "FSHS tokenint_InitTokenState host .x, addr .x: rpc returned .d" },
{ 701931613, "FSHS find a prime host .x, addr .x" },
{ 701931614, "FSHS     and host .x has fshost flags of .#lx, addr .x" },
{ 701931615, "FSHS CreateHost: Authenticating host .x, addr .x, given binding, as self to .s: result .d" },
{ 701931616, "FSHS CreateHost: Authenticating host .x, addr .x, reverse-binding, as self to .s: result .d" },
{ 701931617, "FSHS fshs_loadContext: inq_auth_caller authnLevel .d, authnSvc .d, authzSvc .d" },
{ 701931618, "FSHS fshs_loadContext: inq_auth_caller, caller is unauthenticated .d" },
{ 701931619, "FSHS fshs_loadContext: inq_auth_caller failed, code .d" },
{ 701931620, "FSHS CreateHost: Host .x: changing addr from type .d, ip .x, port .#x..." },
{ 701931621, "... to type .d, ip .x, port .#x (authn .d)" },
{ 701931622, "FSHS newSAddr: Host .x: adding IP .x, port .d; addr count now .d" },
{ 701931623, "FSHS fshs_NewAddr: Host .x: killing IP .x; error .d; addr count now .d" },
{ 701931624, "FSHS fshs_CreateHost: Host .x, addr count .d: changing port from .d to .d" },
{ 701931625, "FSHS fshs_PickAddr: all addresses for host .x are dead (code .d, count .d)" },
{ 701931626, "FSHS fshs_PickAddr: host .x: picking IP .x port .d" },
{ 701931627, "FSHS fshs_ReviveAddrs: host .x: reviving IP .x with last error .d; error addr count now .d" },
{ 701931628, "FSHS fshs_AddrReact: all addresses for host .x are dead (count .d)" },
{ 701931629, "FSHS fshs_AddrReact: host .x: ip addr .x redirected to .x" },
{ 701931630, "FSHS fshs_AddrReact: host .x: ip addr .x got err .d, no replacement" },
{ 701931631, "FSHS fshs_AddrReact: host .x: ip addr .x got err .d, so moving to ip .x" },
{ 701931632, "FSHS newSAddr: Host .x: reviving existing IP .x (killed at .d with .d)" },
{ 701931633, "FSHS TKN_TokenRevoke to address .x rtns code .d in .d secs" },
{ 702357505, "TKC gettoken start vcp 0x.x type 0x.x" },
{ 702357506, "TKC gettoken back, code .d" },
{ 702357507, "TKC revoke start vcp 0x.x, rights 0x.x" },
{ 702357508, "TKC revoke back, code .d" },
{ 702357509, "GLUE read vp 0x.x, off 0x.x len 0x.x" },
{ 702357510, "GLUE read code .d, 0x.x bytes left" },
{ 702357511, "GLUE write vp 0x.x, off 0x.x len 0x.x" },
{ 702357512, "GLUE write code .d, 0x.x bytes left" },
{ 702357513, "GLUE purge vp 0x.x" },
{ 702357514, "GLUE getacl: start, vp .#x" },
{ 702357515, "GLUE getacl: xvfs_GetVolume failed with .d" },
{ 702357516, "GLUE getacl: tkc_Get failed; returning EINVAL" },
{ 702357517, "GLUE getacl: vp .#x, returning .d" },
{ 702357518, "GLUE setacl: start, vp .#x" },
{ 702357519, "GLUE setacl: xvfs_GetVolume failed with .d" },
{ 702357520, "GLUE setacl: tkc_Get failed; returning EINVAL" },
{ 702357521, "GLUE setacl: vp .#x, returning .d" },
{ 702357522, "tkc_Get(type=.x) called" },
{ 702357523, "tkc_Get has tokens: .x" },
{ 702357524, "tkc_Get fails to get tokens: code .d" },
{ 702357525, "tkc_Get gets tokens: .x" },
{ 702357526, "tkc_Put puts .x; dataHolds now .d" },
{ 702357527, "tkc_Release puts .x; refCount now .d" },
{ 702357528, "tkc_GetTokens(.x, .d) called" },
{ 702357529, "tkc_GetTokens() terminates with code .d (returns 0)" },
{ 702357530, "tkc_ReleaseTokens called, size of .d" },
{ 702357531, "tkc_PutTokens called, size of .d" },
{ 702357532, "tkchs_RevokeToken called with revokeLen = .d" },
{ 702357533, "GLUE getxtdattr: start, vp .#x" },
{ 702357534, "GLUE getxtdattr: xvfs_GetVolume failed with .d" },
{ 702357535, "GLUE getxtdattr: tkc_Get failed; returning EINVAL" },
{ 702357536, "GLUE getxtdattr: vp .#x, returning .d" },
{ 702357537, "GLUE setxtdattr: start, vp .#x" },
{ 702357538, "GLUE setxtdattr: xvfs_GetVolume failed with .d" },
{ 702357539, "GLUE setxtdattr: tkc_Get failed; returning EINVAL" },
{ 702357540, "GLUE setxtdattr: vp .#x, returning .d" },
{ 702357541, "GLUE read vp 0x.x, off .#lx,,.lx len .#x" },
{ 702357542, "GLUE write vp 0x.x, off .#lx,,.lx len 0x.x" },
{ 702357543, "GLUE punch: start, vp .#x" },
{ 702357544, "GLUE punch: xvfs_GetVolume failed with .d" },
{ 702357545, "GLUE punch: tkc_Get failed; returning EINVAL" },
{ 702357546, "GLUE punch: vp .#x, returning .d" },
{ 702357547, "TKC getlocks vcp .#x, type .#x, range .lx,,.lx through .lx,,.lx" },
{ 702357548, "TKC putlocks vcp .#x, range .lx,,.lx through .lx,,.lx" },
{ 702357549, "GLUE x->v vp 0x.x, write=.d, off .#lx,,.lx len .#x" },
{ 703262721, "PX .s" },
{ 703262722, "PX in SetContext, Flag .x" },
{ 703262723, "PX in LookupRoot Volume .x..x" },
{ 703262724, "PX LookupRoot returning Vnode .x, Unique .x, code .d" },
{ 703262725, "PX FetchData Fid .x..x..x..x, Pos .d, Len .d, Flags 0x.x" },
{ 703262726, "PX FetchData returns code .d" },
{ 703262727, "PX FetchACL Fid .x..x..x..x, aclType .d" },
{ 703262728, "PX FetchACL returns .d" },
{ 703262729, "PX FetchStatus Fid .x..x..x..x, Flags 0x.x" },
{ 703262730, "PX FetchStatus returns .d" },
{ 703262731, "PX StoreData fid .x..x..x..x, mask .x, position .d, length .d" },
{ 703262732, "PX StoreData returns .d" },
{ 703262733, "PX StoreACL Fid .x..x..x..x, acl type .d, acl fid .x..x..x..x" },
{ 703262734, "PX StoreACL returns .d" },
{ 703262735, "PX StoreStatus fid .x..x..x..x mask 0x.x" },
{ 703262736, "PX StoreStatus returns .d" },
{ 703262737, "PX RemoveFile dirfid .x..x..x..x name .s, retID .d..d" },
{ 703262738, "PX RemoveFile returns .d" },
{ 703262739, "PX CreateFile dir .x..x..x..x, name .s, mask 0x.x" },
{ 703262740, "PX CreateFile returns fid .x..x..x..x, new token ID .d..d, code .d" },
{ 703262741, "PX Rename from .x..x..x..x/.s to .x..x..x..x/.s" },
{ 703262742, "PX Rename returns .d" },
{ 703262743, "PX Symlink dir .x..x..x..x/.s points at .s, mask 0x.x" },
{ 703262744, "PX Symlink returned .x..x..x..x code .d" },
{ 703262745, "PX Link .x..x..x..x/.s points to fid .x..x..x..x" },
{ 703262746, "PX Link returns .d" },
{ 703262747, "PX MakeDir .x..x..x..x/.s, mask 0x.x" },
{ 703262748, "PX Makedir returns .x..x..x..x (tid .d..d) code .d" },
{ 703262749, "PX RemoveDir .x..x..x..x/.s retID .d..d" },
{ 703262750, "PX RemoveDir returns .d" },
{ 703262751, "PX Readdir .x..x..x..x offset .d, size .d" },
{ 703262752, "PX Readdir returns next offset .d, code .d" },
{ 703262753, "PX Lookup .x..x..x..x/.s, flags 0x.x" },
{ 703262754, "PX Lookup returns fid .x..x..x..x (tid .d..d), code .d" },
{ 703262755, "PX GetStatistics" },
{ 703262756, "PX GetStatistics returned .d" },
{ 703262757, "PX ReleaseTokens returning .d tokens" },
{ 703262758, "PX ReleaseTokens returns .d" },
{ 703262759, "PX GetToken fid .x..x..x..x type 0x.x, id .d..d, flags 0x.x" },
{ 703262760, "PX GetToken returns id .d..d, rights 0x.x..x, code .d" },
{ 703262761, "PX GetTime" },
{ 703262762, "PX GetTime returns .d" },
{ 703262763, "PX BulkFetchVV cell .x..x, .d vols, Flags .d" },
{ 703262764, "PX BulkFetchVV returns code .d" },
{ 703262765, "PX BulkKeepAlive .d fids, flags 0x.x" },
{ 703262766, "PX BulkKeepAlive returns .d" },
{ 703262767, "PX Quota Fid .x..x..x..x, quota .d, Flags .d" },
{ 703262768, "PX Quota returns .d" },
{ 703262769, "PX GetServerInterfaces" },
{ 703262770, "PX SetParams" },
{ 703262771, "PX SetParams returns .d" },
{ 703262772, "PX in runTokens" },
{ 703262773, "PX runTokens action .d, mid .d, fid .x..x..x..x flags 0x.x" },
{ 703262774, "PX runTokens returned code .d, exp .d" },
{ 703262775, "PX runTokens applies to .d" },
{ 703262776, "PX runTokens can't return, code .d" },
{ 703262777, "PX runTokens done, .d current entries" },
{ 703262778, "PX runTokens deleting expired entries" },
{ 703262779, "PX in bulk keepalive" },
{ 703262780, "PX BKA growing from .d to .d" },
{ 703262781, "PX BKA execs .d, now .d reads" },
{ 703262782, "PX in PeriodicKA" },
{ 703262783, "PX RevokeSet len .d" },
{ 703262784, "PX RevokeSet found it (index .d)" },
{ 703262785, "PX RevokeSet holding token" },
{ 703262786, "PX Revokeset relinquishing token" },
{ 703262787, "PX Revokeset abandoning tokens" },
{ 703262788, "PX rdwr bad file type for op .d, type is .d (failing)" },
{ 703262789, "PX checkflservers checking .d servers" },
{ 703262790, "PX starting fls probe" },
{ 703262791, "PX end fls probe, code .d" },
{ 703262792, "PX in px_initFLServers" },
{ 703262793, "PX leaving px_initFLServers, .d servers" },
{ 703262794, "PX flgetentrybyid for id .d..d" },
{ 703262795, "PX flgetentrybyid server down conn 0x.x" },
{ 703262796, "PX calling flserver conn .x" },
{ 703262797, "PX flserver call done, code .d" },
{ 703262798, "PX RPC exception while pushing" },
{ 703262799, "PX RPC exception while pulling" },
{ 703262800, "PX in pxvc_Cleanups" },
{ 703262801, "PX piping data for length .d" },
{ 703262802, "PX end piping data" },
{ 703262803, "PX GetToken output range: .lu,,.lu thru .lu,,.lu" },
{ 703262804, "PX GetToken input range: .lu,,.lu thru .lu,,.lu" },
{ 703262805, "PX CreateFile couldn't get token on new fid .x..x..x..x: code .d" },
{ 703262806, "PX Symlink couldn't get token on new fid .x..x..x..x: code .d" },
{ 703262807, "PX MakeDir couldn't get token on new fid .x..x..x..x: code .d" },
{ 703262808, "PX RPC exception (.d) while pushing" },
{ 703262809, "PX RPC exception (.d) while pulling" },
{ 703262810, "PX px_SetSync found a R/W volume .lu,,.lu (states .#x) that claims to be repserver managed" },
{ 703262811, "PX BKA gets new fid .x..x..x..x, exec .d, timeout .d" },
{ 703262812, "PX BKA extends lifetime of fid .x..x..x..x, exec .d, timeout .d" },
{ 703262813, "PX RevokeSet holding token .x,,.x on fid .x..x..x..x until .d, flags .x" },
{ 703262814, "PX Revokeset relinquishing old token .x,,.x on fid .x..x..x..x, flags .x" },
{ 703262815, "PX runTokens sees horrible tkm_GetToken error .d, fid .x..x..x..x, position .d" },
{ 703262816, "PX StoreData from host without tokens fid .x..x..x..x, off .d len .d (getrights code = .d)" },
{ 703262817, "PX px_ComputeTokenRecoveryTime: Bringing server UP after a crash  (now=.d, initRecTime=.d, endRecTime=.d, interval=.d)" },
{ 703262818, "PX px_ComputeTokenRecoveryTime: Extending the recovery time (rpcRate=.d, endRecTime=.d, now=.d)" },
{ 703262819, "PX px_ComputeTokenRecoveryTime: rpcRate is .d, as ((.d - .d) * 10) / .d" },
{ 703262820, "PX px_RunCheckingDaemons: Bringing server UP after a crash (now=.d, endRecTime=.d)" },
{ 703262821, "PX Pre DCE 1.1 client requesting fid .#x..#x, vp .#x, acl type .d" },
{ 703262822, "PX BulkFetchStatus: fid .x..x..x..x, offset .d, size .d" },
{ 703262823, "PX BulkFetchStatus: pipe broke while draining" },
{ 703262824, "PX Bulkstat: bad flag parameter" },
{ 703262825, "PX Bulkstat: called during post recovery" },
{ 703262826, "PX Bulkstat: bad context" },
{ 703262827, "PX Bulkstat: cannot get principal" },
{ 703262828, "PX Bulkstat: lookup error on dir .x..x..x..x" },
{ 703262829, "PX Bulkstat: attr on dir .x..x..x..x" },
{ 703262830, "PX Bulkstat: cannot file file .s" },
{ 703262831, "PX Bulkstat: no fid for vp .x" },
{ 703262832, "PX Bulkstat: tkset relock: return" },
{ 703262833, "PX Bulkstat: cannot stat vp .x" },
{ 703262834, "PX Bulkstat: broken pipe: return" },
{ 703262835, "PX BulkFetchStatus: fid .x..x..x..x, new offset .d, error .d" },
{ 703262836, "PX Attempt to truncate via SETLENGTH, old .x, new .x" },
{ 703262837, "PX StoreData: vp .x: Store of .d,,.u for .d will overrun new length of .d,,.u--returning EINVAL" },
{ 703262838, "PX 64-bit host (.p) maxFileSize is .#x,,.#x" },
{ 703262839, "PX 32-bit host (.p) maxFileSize is .#x,,.#x" },
{ 703262840, "PX Lookup fid .x..x..x..x maps to volp .#x, vp .#x" },
{ 703262841, "PX px_rdwr(rw=.d) decides on a big buffer (.d rather than .d)" },
{ 703262842, "PX px_read asked vnop for .d bytes; got .d" },
{ 703262843, "PX px_write asked PULL routine for .d bytes; got .d" },
{ 703262844, "PX px_write calls VOPX_RDWR for .d bytes; resid .d, .d written; Length .d" },
{ 703262845, "PX CheckFlags: inconsistent flags .#x: returning EINVAL." },
{ 703262846, "PX CheckFlags: secondary call, flags .#x: returning EINVAL." },
{ 703262847, "PX NameTagOK: tag .d nonzero (len .d, name `.s'); bad name." },
{ 703262848, "PX FileNameOK: name ends with @sys (name `.s'); bad name." },
{ 703262849, "PX FileNameOK: name contains slash (name `.s'); bad name." },
{ 703262850, "PX SymLink: link codeset tag .d is not zero; returning EINVAL." },
{ 703262851, "PX NameTagOK: file name has null first byte (tag .d, len .d); bad name." },
{ 703262852, "PX FetchData Fid .x..x..x..x, Pos .d,,.u, Len .d, Flags .#x" },
{ 703262853, "PX StoreData fid .x..x..x..x, mask .x, position .d,,.u, length .d" },
{ 703262854, "PX StoreData from host without tokens fid .x..x..x..x, off .d,,.u len .d (getrights code = .d)" },
{ 703262855, "PX Attempt to truncate via SETLENGTH, old .x,,.x, new .x,,.x" },
{ 703262856, "PX Allowing FORCEDOWN revocations, princ .x, IP .x, ruid .d, flags .#x" },
{ 703262857, "PX DIS-allowing FORCEDOWN revocations, princ .x, IP .x, ruid .d, flags .#x" },
{ 703262858, "PX Quota Fid .x..x..x..x, op .d, Flags .x" },
{ 703262859, "PX Quota returns .d" },
{ 703262860, "PX SetContext returns .d" },
{ 703262861, "PX Bulkstat: broken pipe (exception .d): return" },
{ 703262862, "PX BulkFetchStatus: pipe broke (exception .d) while draining" },
{ 703262863, "PX AFS_GetToken: returning volerr .d to somebody's TSR" },
{ 703262864, "PX AFS_GetToken: returning volerr .d since they're new and not a renewal" },
{ 703262865, "PX ClientHadFormerToken: too many tokens in tkset" },
{ 703262866, "PX ClientHadFormerToken: error .d from GetFileRightsIgnoring" },
{ 703262867, "PX ClientHadFormerToken: client .x had .x, and client asks for .x: return .d" },
{ 703262868, "PX EvaluateWildcard: volp .x, turned fid .x..x..x..x into .x..x" },
{ 703262869, "PX EvaluateWildcard: volp .x: failed on fid .x..x..x..x: code .d" },
{ 703557633, "in .d" },
{ 703557634, "Global mutex is initialized and locked" },
{ 703557635, ".s: .s about to call rpc_register_dfs_server(tkn)" },
{ 703557636, ".s: .s returned from rpc_register_dfs_server(tkn)" },
{ 703557637, ".s: .s about to call rpc_register_dfs_server(rep)" },
{ 703557638, ".s: .s returned from rpc_register_dfs_server(rep)" },
{ 703557639, "Releasing the global mutex to allow background processing" },
{ 703557640, "[.lu,,.lu: delay .lu secs: .s]" },
{ 703557641, "[.lu,,.lu: renew .lu secs: .s]" },
{ 703557642, "GetLVStatus  calling AGOPEN" },
{ 703557643, "GetLVStatus calling GETSTATUS" },
{ 703557644, "GetLVStatus calling CLOSE" },
{ 703557645, ".s: .s" },
{ 703557646, "Interpreted vldb entry for .s .d reps, mySite=.d" },
{ 703557647, "NeedSetVol figuring VV" },
{ 703557648, "NeedSetVol TRUE: no lvp" },
{ 703557649, "NeedSetVol TRUE: lvp ID .lu,,.lu not .lu,,.lu" },
{ 703557650, "NeedSetVol TRUE: don't have lv states" },
{ 703557651, "NeedSetVol TRUE: need set bits .#lx -> .#lx" },
{ 703557652, "NeedSetVol TRUE: new tknExp time .lu..06lu -> .lu..06lu" },
{ 703557653, "NeedSetVol TRUE: new Curr time .lu..06lu -> .lu..06lu" },
{ 703557654, "NeedSetVol TRUE: new PingCurr time .lu..06lu -> .lu..06lu" },
{ 703557655, "NeedSetVol: no change needed" },
{ 703557656, "SetOpenVol calling SETVV" },
{ 703557657, "SetOpenVol calling SYNC" },
{ 703557658, "SetOpenVol: Set VV for .lu,,.lu: .s" },
{ 703557659, "SetOpenVol calling GETSTATUS" },
{ 703557660, "UpdateLocal: calling SetOpenVol" },
{ 703557661, "UpdateLocal: calling CLOSE" },
{ 703557662, "SetOpenVol returning .lu" },
{ 703557663, "CheckSetOpenVol: calling SetOpenVol" },
{ 703557664, "CheckSetOpenVol: returning .lu" },
{ 703557665, "UpdateLocal calling AGOPEN" },
{ 703557666, "UpdateLocal: returning .lu" },
{ 703557667, "SetLVStatus calling AGOPEN" },
{ 703557668, "SetLVStatus calling SETSTATUS to .#lx" },
{ 703557669, "SetLVStatus calling CheckSetOpenVol" },
{ 703557670, "SetLVStatus calling SYNC" },
{ 703557671, "SetLVStatus: Set states for LV .lu,,.lu: .#lx" },
{ 703557672, "SetLVStatus returning .d" },
{ 703557673, "Destroying volume .lu,,.lu...." },
{ 703557674, "Destroyvolume calling GETSTATUS" },
{ 703557675, "DestroyVolume calling SETSTATUS" },
{ 703557676, "DestroyVolume about to loop" },
{ 703557677, "DestroyVolume calling CLOSE" },
{ 703557678, "DestroyVolume returning .lu" },
{ 703557679, "LoseWVT signals actNowCond" },
{ 703557680, ".s: STKN_Probe() called" },
{ 703557681, ".s: STKN_InitTokenState() called" },
{ 703557682, ".s: STKN_InitTokenState about to get global lock" },
{ 703557683, ".s: STKN_InitTokenState got global lock" },
{ 703557684, ".s: STKN_InitTokenState released global lock and returns" },
{ 703557685, ".s: STKN_TokenRevoke() called with .ld revocations" },
{ 703557686, "STKN_TokenRevoke: calling LoseWVT, fid .s" },
{ 703557687, ".s: STKN_GetCellName() called" },
{ 703557688, ".s: STKN_GetCellName() returning .s" },
{ 703557689, ".s: STKN_GetCellName() returning no-name" },
{ 703557690, ".s: STKN_GetLock() called" },
{ 703557691, ".s: STKN_GetCE() called" },
{ 703557692, ".s" },
{ 703557693, "GetToken result: .ld" },
{ 703557694, "CloneAVolume called" },
{ 703557695, "AG_VOLCREATE returns .ld, errno .d" },
{ 703557696, "CloneAVolume calling AGOPEN(.d)" },
{ 703557697, "CloneAVolume calling SETSTATUS" },
{ 703557698, "CloneAVolume calling PUSHSTATUS" },
{ 703557699, "CloneAVolume calling VolClone" },
{ 703557700, "CloneAVolume calling SYNC(1)" },
{ 703557701, "CloneAVolume calling CLOSE(1)" },
{ 703557702, "CloneAVolume calling SYNC(2)" },
{ 703557703, "CloneAVolume calling CLOSE(2)" },
{ 703557704, "Getting dump for vol .lu,,.lu" },
{ 703557705, "Incremental from version .lu,,.lu" },
{ 703557706, "CompleteNewVol calling GETSTATUS" },
{ 703557707, "CompleteNewVol calling SETSTATUS" },
{ 703557708, "CompleteNewVol calling CheckSetOpenVol" },
{ 703557709, "CompleteNewVol calling SYNC" },
{ 703557710, "CompleteNewVol calling CLOSE" },
{ 703557711, "ClearBackingID calling SETSTATUS" },
{ 703557712, "ClearBackingID calling SYNC" },
{ 703557713, "ClearBackingID calling CLOSE" },
{ 703557714, "EliminateJunkVolume calling AGOPEN(2)" },
{ 703557715, "EliminateJunkVolume calling VolUnClone" },
{ 703557716, "EliminateJunkVolume calling SYNC(1)" },
{ 703557717, "EliminateJunkVolume calling CLOSE(1)" },
{ 703557718, "EliminateJunkVolume calling VolDestroy" },
{ 703557719, "EliminateJunkVolume calling CLOSE(2)" },
{ 703557720, "EliminateJunkVolume returned from CLOSE(2)" },
{ 703557721, "CompleteAndSwitch calling AGOPEN(2)" },
{ 703557722, "CompleteAndSwitch calling SetOpenVol" },
{ 703557723, "CompleteAndSwitch calling SWAPVOLIDS" },
{ 703557724, "CompleteAndSwitch calling GETSTATUS" },
{ 703557725, "CompleteAndSwitch calling SYNC(1)" },
{ 703557726, "CompleteAndSwitch calling SYNC(2)" },
{ 703557727, "CompleteAndSwitch calling CLOSE(1)" },
{ 703557728, "CompleteAndSwitch calling CLOSE(2)" },
{ 703557729, "CompleteAndSwitch: Got states for LV .lu,,.lu: .#lx" },
{ 703557730, "CheckWithVLDB signals actNowCond" },
{ 703557731, "Found incomplete volume .lu,,.lu" },
{ 703557732, "ProcessBundle() handles .d Attns." },
{ 703557733, "BulkFetchVV result: .ld" },
{ 703557734, "StartImporting(): .d replicas want attention" },
{ 703557735, "[.lu,,.lu] Refreshing primary's last-call time" },
{ 703557736, "GetTime result: .ld" },
{ 703557737, "CheckVLDBRelationship signals actNowCond" },
{ 703557738, ".s: REP_Probe called" },
{ 703557739, ".s: REP_CheckReplicationConfig called" },
{ 703557740, ".s: REP_AllCheckReplicationConfig called" },
{ 703557741, ".s: REP_GetServerInterfaces called" },
{ 703557742, "BundleKeepAlives: .d on this pass" },
{ 703557743, "BundleKeepAlives(.lu,,.lu): calling .s: .ld fexs, .ld executing" },
{ 703557744, "BundleKeepAlives: retval .ld" },
{ 703557745, "PruneAndCheckKA(.lu,,.lu): from .lu to .lu used" },
{ 703557746, ".s: ForceKeepAlive() called" },
{ 703557747, "[.lu,,.lu] Freeing volChanged .lu,,.lu -> .lu,,.lu, .ld fids" },
{ 703557748, "Background thread spawned: checking initialization mutex" },
{ 703557749, "Background thread passed check on initialization mutex.  Looping" },
{ 703557750, "bkg: RenewTokens sleeps .ld secs" },
{ 703557751, "bkg: StartImporting sleeps .ld secs" },
{ 703557752, "bkg: ForceKeepAlives sleeps .ld secs" },
{ 703557753, "bkg: DoWillCalls sleeps .ld secs" },
{ 703557754, "bkg: ExpireVolChanges sleeps .ld secs" },
{ 703557755, "Sleeping for .lu seconds (on actNowCond)" },
{ 703557756, "bkg: now .lu, tgt .lu, .s: .s" },
{ 703557757, ".s: REP_KeepFilesAlive called" },
{ 703557758, "REP_KeepFilesAlive: got .lu fids, flags .lu" },
{ 703557759, "Num/MaxKAs for .lu,,.lu: .lu, .lu (old max .lu)" },
{ 703557760, "[.lu,,.lu] No vol for vsn .lu,,.lu" },
{ 703557761, "[.lu,,.lu] Making a volChanged object from .lu,,.lu to .lu,,.lu" },
{ 703557762, ".s: REP_GetRepStatus(.lu) called." },
{ 703557763, "getVolChanged calling AGOPEN" },
{ 703557764, "getVolChanged calling SCAN" },
{ 703557765, "getVolChanged calling CLOSE" },
{ 703557766, "getVolChanged after CLOSE" },
{ 703557767, ".s: REP_GetVolChangedFiles called." },
{ 703557768, ".s: REP_GetOneRepStatus called" },
{ 703557769, ".s: REP_GetRepServerStatus called" },
{ 703557770, "rep_doUpdate signals actNowCond" },
{ 703557771, ".s: REP_UpdateSelf called" },
{ 703557772, ".s: REP_Spare1 called" },
{ 703557773, ".s: REP_Spare2 called" },
{ 703557774, ".s: REP_Spare3 called" },
{ 703557775, ".s" },
{ 703557776, "Got an FLDB connection object" },
{ 703557777, "can't deplete incomplete local vol .lu,,.lu: .s" },
{ 703557778, "Found VLDB entry: .lu,,.lu" },
{ 703557779, "...but we were already handling that one" },
{ 703557780, "can't open local vol .lu,,.lu: .s" },
{ 703557781, "can't get status for local vol .lu,,.lu: .s" },
{ 703557782, "can't close local vol .lu,,.lu: .s" },
{ 703557783, "can't destroy incomplete local vol .lu,,.lu: .s" },
{ 703557784, "Got states for LV .lu,,.lu: .#lx" },
{ 703557785, "can't close local vol .lu,,.lu after destroying it: .s" },
{ 703557786, "LV .lu,,.lu is destroyed" },
{ 703557787, ".s: .d aggregates to scan" },
{ 703557788, ".s: skipping non-Episode aggregate .s, ID .ld, type .ld" },
{ 703557789, ".s: scanning aggregate .s, ID .ld, type .ld" },
{ 703557790, ".s: got a local volume to manage: id .lu,,.lu, name .s, states .#lx" },
{ 703557791, ".s: done with scanning for local volumes.  Rationalizing..." },
{ 703557792, ".s: done rationalizing local volumes" },
{ 703557793, ".s: adding .lu,,.lu due to discovered JUNK." },
{ 703557794, ".s: attaching junk .lu,,.lu to rep .lu,,.lu" },
{ 703557795, ".s: adding .lu,,.lu (.lu,,.lu) due to a discovered volume." },
{ 703557796, "This machine has .d net address(es)." },
{ 703557797, ".s" },
{ 703557798, "DoWillCalls: connecting to .s" },
{ 703557799, "DoWillCalls: cannot connect to .s; errno=.d" },
{ 703557800, "DoWillCalls, flags .d: exception .s" },
{ 703557801, "DoWillCalls: .s (.s) failed: .s" },
{ 703557802, "Listening for net calls (calling rpc_server_listen)" },
{ 703557803, "Starting the token-revocation listener thread" },
{ 703557804, "Revocation socket is: inet/.s/.d" },
{ 703557805, ".s: .d binding(s)" },
{ 703557806, ".lu,,.lu: .s" },
{ 703557807, ".s: No R/W site for fileset .s" },
{ 703557808, "Release-style replicated fileset .s, rw=.lu,,.lu, ro=.lu,,.lu, with no R/O on primary!" },
{ 703557809, "Interpreted vldb entry for .lu,,.lu (.s): .d reps, mySite=.d" },
{ 703557810, "STKN_TokenRevoke: calling LoseWVT, fid .lu/.lu/.lu/.lu, id .lu,,.lu, type .#lx" },
{ 703557811, "repq_Init(.#x)" },
{ 703557812, "repq_Enter(.#x, .#x, .lu)" },
{ 703557813, "repq_Enter returning .#x" },
{ 703557814, "repq_Delete(.#x, .#x)" },
{ 703557815, "repq_Delete: item is in use--deferring the delete" },
{ 703557816, "repq_Delete returning" },
{ 703557817, "repq_Get(.#x)" },
{ 703557818, "repq_Get: queue is empty--waiting indefinitely" },
{ 703557819, "repq_Get: waiting until .lu" },
{ 703557820, "repq_Get returning .#x, *outCookieP=.#x" },
{ 703557821, "repq_Put(.#x, .#x, .lu)" },
{ 703557822, "repq_Delete: performing deferred delete" },
{ 703557823, "repq_Put: setting deadline to .lu" },
{ 703557824, "repq_Delete returning" },
{ 703557825, "repq_ResetDeadline(.#x, .#x, .lu)" },
{ 703557826, "repq_ResetDeadline: item is in use" },
{ 703557827, "repq_ResetDeadline returning" },
{ 703557828, "repq: waking up waiters" },
{ 703557829, "reph_GetHost(.s, .lu, .s)" },
{ 703557830, "reph_GetHost returning .#x" },
{ 703557831, "reph_PutHost(.#x [.s])" },
{ 703557832, "reph_GetConn(.#x [.s], .lu)" },
{ 703557833, "reph_GetConn returning .lu, *outConnPP=.#x" },
{ 703557834, "reph_ResetConn(.#x [.s], .#x, .lu)" },
{ 703557835, "reph_ResetConn: failed to refresh auth context, code=.ld" },
{ 703557836, "reph_ResetConn: reset failed, code=.ld" },
{ 703557837, "reph_ResetConn returning .lu, *callersConnPP=.#x" },
{ 703557838, "reph_PutConn(.#x)" },
{ 703557839, "reph_PutConn: losing last reference--destroying connection" },
{ 703557840, "reph_MergeSuccess: last success at .lu" },
{ 703557841, "SetNewConn(.#x [.s], .#x, .lu)" },
{ 703557842, "SetNewConn: Waiting for racing set context" },
{ 703557843, "SetNewConn returning .lu, *connPP=.#x" },
{ 703557844, "SetNewConn: Trying another address (#.lu), reason=.lu" },
{ 703557845, "SetContext(.#x [.s], .#x)" },
{ 703557846, "SetContext returning .lu" },
{ 703557847, "REP_KeepFilesAlive: cell .lu,,.lu, vol .lu,,.lu, [.d...d)" },
{ 703557848, "REP_KeepFilesAlive: matched replica .#lx" },
{ 703557849, "BundleKeepAlives: adding .x..x..x..x with dally .d, exec .d" },
{ 703557850, "BundleKeepAlives: .d,,.d (.x, .x) sent, flags now .#lx" },
{ 703557851, "BundleKeepAlives: .d,,.d (.x, .x) reduces next-call time to .d;" },
{ 703557852, "....got req at .d, dally .d secs, last sent at .d" },
{ 703557853, "StartImporting rp=.#lx look=.lu flags=.#lx" },
{ 703557854, "WantsAdvance look=.lu now=.lu" },
{ 703557855, "WantsAdvance know VLDB" },
{ 703557856, "WantsAdvance junked, deleted or zapped done" },
{ 703557857, "WantsAdvance eliminated junk" },
{ 703557858, "WantsAdvance (A) P=.#lx" },
{ 703557859, "WantsAdvance (B) B=.#lx" },
{ 703557860, "WantsAdvance (F) (M) P=.lx" },
{ 703557861, "WantsAdvance (I) (J) WVTLeft=.#lx,.#lx now=.lu look=.lu" },
{ 703557862, "WantsAdvance have WVT, ok start P=.#lx B=.#lx" },
{ 703557863, "WantsAdvance (G) next=.lu" },
{ 703557864, "WantsAdvance maybe no WVT look=.lu next=.lu" },
{ 703557865, "WantsAdvance bottom next=.lu" },
{ 703557866, "CloneLocalReplica: opened R/W .lu,,.lu as .d: getting status" },
{ 703557867, "CloneLocalReplica: got R/W .lu,,.lu status; problem states = .#lx" },
{ 703557868, "CloneLocalReplica: R/W .lu,,.lu, Pub=.#lx; cloning/recloning." },
{ 703557869, "CloneLocalReplica: R/W .lu,,.lu; clone/reclone done; getting stat of R/O .lu,,.lu" },
{ 703557870, "CloneLocalReplica: fixing states of R/O .lu,,.lu, from .#lx to .#lx" },
{ 703557871, "recordCaller(SREP_.s): inq_auth_caller failed with .d" },
{ 703557872, "recordCaller(SREP_.s): called us .s, with svc .d, level .d" },
{ 703557873, "getPrincName(.x): got .s (from primary for .s)." },
{ 703557874, "getPrincName(.x): err .d from VL_GetSiteInfo." },
{ 703557875, "getPrincName(.x): got .s from FLDB." },
{ 703557876, "DoWillCalls: cannot connect to .s; cannot get correct principal" },
{ 703557877, "DoWillCalls: cannot connect to .s with princ '.s'; auth code .d" },
{ 703557878, "getPrincName(.x): re-validates old entry '.s'." },
{ 703557879, "STKN_TokenRevoke: declining revocation, fid .lu/.lu/.lu/.lu, token id .lu,,.lu, attempted .#x, keeping .#x" },
{ 703557880, "GetNewAuthn: host .x, .s, old level .d, code .d:" },
{ 703557881, "GetNewAuthn: Authmask .#x -> .#x; no possible authn level!" },
{ 703557882, "GetNewAuthn: Authmask .#x -> .#x; going from .d to .d." },
{ 703557883, "(reph_GetConn conn at .#x has type .d, authn .d)" },
{ 703705089, "ERR: .s" },
{ 703705090, "INF: .s" },
{ 703705091, ".s" },
{ 703705092, "OSI cred to pag .x" },
{ 703705093, "OSI cred to thread pag .x tid .x" },
{ 703705094, "OSI setpag err .d, parm1 .x parm2 .x" },
{ 703705095, "OSI install pag .x" },
{ 703705096, "OSI install thread pag .x tid .x" },
{ 703705097, "OSI set pag .x" },
{ 703705098, "OSI set thread pag .x tid .x" },
{ 703705099, "OSI set thread unauth tid .x" },
{ 703705100, "OSI reset pag" },
{ 703705101, "OSI reset thread pag, tid .x" },
{ 703873025, "TKM gettoken fid .#x..#x..#x..#x flags .#x type .#x..#x for host .#x" },
{ 703873026, "TKM return token fid .#x..#x..#x..#x TID ..#x..#x rights .#x..#x" },
{ 703873027, "TKM async grant host .#x, TID .#x..#x, reqID .#x" },
{ 703873028, "TKM async done, code .d" },
{ 703873029, "TKM revoke start: conflictq .#x host .#x, .d tokens" },
{ 703873030, "TKM revoke: hshost revoke returns conflictq .#x host .#x code .d" },
{ 703873031, "TKM revoke refused, token id .#x..#x, revoke .#x,.#x, refused .#x,.#x, refused time .#x" },
{ 703873032, "TKM revoke success, token id .#x..#x, revoke .#x..#x" },
{ 703873033, "TKM revoke complete conflictq .#x, host .#x, code .#x" },
{ 703873034, "TKM Started periodic token cleanup at .d" },
{ 703873035, "TKM Finished periodic token cleanup at .d" },
{ 703873036, "TKM Adjusting expiration time to .d" },
{ 703873037, "TKM Started token GC at .d" },
{ 703873038, "TKM GC ended with only .d tokens free" },
{ 703873039, "TKM looking at GC candidate .#x..#x" },
{ 703873040, "TKM will GC  .#x..#x expiration .d" },
{ 703873041, "TKM GetRights host .#x fid .#x..#x..#x..#x (range .#x..#x -> .#x..#x)" },
{ 703873042, "TKM gettoken back, code .d, type .#x..#x, TID .#x..#x" },
{ 703873043, "TKM DeleteConflictQ(.#x)" },
{ 703873044, "TKM Remove Conflict token id .#x..#x from Q .#x returns ix .d" },
{ 703873045, "TKM Add Conflict 1 to Q .#x, token id .#x..#x, host .#x, revoke .#x" },
{ 703873046, "TKM Add Conflict 2 token id .#x..#x, slice grant .#x, last refused rights .#x at time .#x" },
{ 703873047, "" },
{ 703873048, "TKM gettoken byte range is (.#x,,.#x -> .#x,,.#x)" },
{ 703873049, "TKM getvoltoken volume .#x..#x, token type .#x, flags .#x, granted volume token mask .#x, granted file token mask .#x" },
{ 703873050, "TKM parallel revoke start, conflictq .#x, revoke count .d, flags .d" },
{ 703873051, "TKM parallel revoke empty conflictq .#x" },
{ 703873052, "TKM parallel revoke preproceess conflictq .#x, code .d" },
{ 703873053, "TKM parallel revoke after preprocess empty conflictq .#x" },
{ 703873054, "TKM parallel revoke end, conflictq .#x, code .d" },
{ 703873055, "TKM parallel revoke invoke revoke threads conflictq .#x, this revoke count .d" },
{ 703873056, "TKM preprocess conflictq .#x, token id .#x..#x, to revoke .#x, revocation of .#x last denied at time .#x" },
{ 703873057, "TKM gettoken endRange truncated to .#x,,.#x" },
{ 703873058, "TKM AdjustAccepted: no internal token for client ID .#x..#x, bits .#x--dropping token" },
{ 703873059, "TKM AdjustAccepted: client ID .#x..#x not internal .#x..#x (client bits .#x, our bits .#x)--dropping token" },
{ 703873060, "TKM AdjustAccepted: ID .#x..#x: accepted bits .#x more than ours .#x--dropping extras" },
{ 703873061, "TKM begin doGC" },
{ 703873062, "TKM end doGC, reclaimed .d out of .d tkns in .d secs" },
{ 703873063, "TKM TryAsyncGrantsOnList: Processing queued grants list .#x against revoked types .#x" },
{ 703873064, "TKM AsyncGrantThread: Starting to process asyncTryQ .#x" },
{ 703873065, "TKM ClearAsyncGrants: Clearing out async grants for volId .lu,,.lu" },
{ 703873066, "TKM ClearAsyncGrants: Volume .#x: Cleared .d tokens on file lists and .d tokens on volume list" },
{ 703873067, "TKM .s" },
{ 703889409, "tpq_Init: minThreads=.d, medMaxThreads=.d, highMaxThreads=.d, threadEnnui=.d" },
{ 703889410, "tpq_Init: returns pool pointer .x" },
{ 703889411, "tpq_Adjust: poolHandle=.x, flags=.x . . ." },
{ 703889412, "tpq_Adjust: minThreads=.d, medMaxThreads=.d, highMaxThreads=.d, threadEnnui=.d" },
{ 703889413, "(tpq) CreatePoolEntry(.x) entered" },
{ 703889414, "(tpq) CreatePoolEntry: created thread for thread pool .x, entry=.x" },
{ 703889415, "tpq_GrowThreadPool(.x, .d, entryPP)" },
{ 703889416, "tpq_GrowThreadPool: okay to create thread for pool .x" },
{ 703889417, "tpq_ShutdownPool(.x) called" },
{ 703889418, "tpq_ShutdownPool(.x) completed" },
{ 703889419, "tpq_HelperDie(.x, .x) called" },
{ 703889420, "tpq_GCThreads(.x) called" },
{ 703889421, "tpq_GCThreads(.x): tell entry .x to die" },
{ 703889422, "tpq_DispatcherThread(.x) started" },
{ 703889423, "tpq_DispatcherThread(.x) ready to run .x, priority=.d, graceExpired=.d" },
{ 703889424, "tpq_DispatcherThread(.x) has thread to run .x, thread=.x" },
{ 703889425, "tpq_DispatcherThread(.x) sleep with interval=.d" },
{ 703889426, "tpq_DispatcherThread(.x) awake!!" },
{ 703889427, "tpq_DispatcherThread(.x) rest in peace" },
{ 703889428, "tpq_WakeDispatcher(.x) called" },
{ 703889429, "tpq_HelperThread(.x) for pool .x started" },
{ 703889430, "tpq_HelperThread(.x) I'm dying <gasp>" },
{ 703889431, "tpq_HelperThread(.x) found .x on my private queue (pool=.x)" },
{ 703889432, "tpq_HelperThread(.x) .x done, reschedule interval = .d" },
{ 703889433, "tpq_HelperThread(.x) checking queues" },
{ 703889434, "tpq_HelperThread(.x) found .x to run" },
{ 703889435, "tpq_HelperThread(.x) .x done, reschedule interval = .d" },
{ 703889436, "tpq_HelperThread(.x) (pool .x) to sleep: perchance to dream" },
{ 703889437, "(tpq) EnqueueEntry(.x, .x) called, priority = .d, grace period = .d" },
{ 703889438, "tpq_QueueRequest(pool=.x, op=.x, arg=.x, priority=.d, ..." },
{ 703889439, "                 gracePeriod=.d, resched=.d, dropDead=.d)" },
{ 703889440, "tpq_DequeueRequest(pool=.x, entry=.x)" },
{ 703889441, "(tpq) GCQueue(pool=.x, priority=.d, now=.d)" },
{ 703889442, "tpq_FindQueue(pool=.x, priority=.d, now=.d, ...)" },
{ 703889443, "tpq_FindQueue(pool=.x,...) returns nextExpired=.d, graceExpired=.d, entry=.x" },
{ 703889444, "tpq_SetRescheduleInterval(entry=.x, old=.d, new=.d)" },
{ 703889445, "tpq_HelperThread(.x) for pool .x: waiting for initial lock" },
{ 703889446, "tpq_HelperThread(.x) for pool .x: lock released" },
{ 704008193, "END .s .d" },
{ 704008194, "ag_ufsHold(aggrp=0x.x refCount=.d)" },
{ 704008195, "ag_ufsRele(aggrp=0x.x refCount=.d)" },
{ 704008196, "IN ag_ufsLock(aggrp=0x.x type=.d)" },
{ 704008197, "IN ag_ufsUnlock(aggrp=0x.x)" },
{ 704008198, "IN ag_ufsStat(aggrp=0x.x)" },
{ 704008199, "IN ag_ufsVolCreate(flags=0x.x)" },
{ 704008200, "IN ag_ufsVolinfo(index=.d)" },
{ 704008201, "IN ag_ufsDetach()" },
{ 704008202, "IN ag_ufsAttach()" },
{ 704008203, "   ag_ufsAttach: usa_mountedon='.s'" },
{ 704008204, "ag_ufsSync() = 0" },
{ 704008205, "IN vol_ufsHold(volp=0x.x v_count=.d)" },
{ 704008206, "IN vol_ufsRele(volp=0x.x v_count=.d)" },
{ 704008207, "IN vol_ufsLock(volp=0x.x type=.d)" },
{ 704008208, "IN vol_ufsUnlock(volp=0x.x type=.d)" },
{ 704008209, "IN vol_ufsOpen(volp=0x.x type=.d errorType=.d)" },
{ 704008210, "   vol_ufsOpen(concurrency=.d)" },
{ 704008211, "IN vol_ufsSeek(volp=0x.x position=.d)" },
{ 704008212, "IN vol_ufsTell(volp=0x.x handlerp=ox.x)" },
{ 704008213, "IN vol_ufsScan(volp=0x.x position=.d)" },
{ 704008214, "IN vol_ufsClose(volp=0x.x isabort=.d)" },
{ 704008215, "vol_ufsDeplete(volp=0x.x v_count=.d) = EINVAL" },
{ 704008216, "vol_ufsDestroy(volp=0x.x v_count=.d) = EINVAL" },
{ 704008217, "IN vol_ufsAttach(volp=0x.x ta=0x.x)" },
{ 704008218, "IN vol_ufsDetach(volp=0x.x)" },
{ 704008219, "IN vol_ufsGetStatus(volp=0x.x statusp=0x.x)" },
{ 704008220, "IN vol_ufsSetStatus(volp=0x.x mask=0x.x)" },
{ 704008221, "IN vol_ufsCreate(volp=0x.x position=.d xvattrp=0x.x)" },
{ 704008222, "IN vol_ufsRead(volp=0x.x fid=.x..x..x..x position=.d,,.d len=.d)" },
{ 704008223, "IN vol_ufsWrite(volp=0x.x fid=.x..x..x..x position=.d,,.d len=.d)" },
{ 704008224, "IN vol_ufsReadHole(volp=0x.x fid=.x..x..x..x readHoleP=0x.x)" },
{ 704008225, "IN vol_ufsTruncate(volp=0x.x fid=.x..x..x..x newsize=.d,,.d)" },
{ 704008226, "IN vol_ufsDelete(volp=0x.x fid=.x..x..x..x)" },
{ 704008227, "IN vol_ufsGetattr(volp=0x.x fid=.x..x..x..x xvattrp=0x.x)" },
{ 704008228, "IN vol_ufsSetattr(volp=0x.x fid=.x..x..x..x xvattrp=0x.x)" },
{ 704008229, "IN vol_ufsGetAcl(volp=0x.x fid=.x..x..x..x aclp=0x.x)" },
{ 704008230, "IN vol_ufsSetAcl(volp=0x.x fid=.x..x..x..x aclp=0x.x)" },
{ 704008231, "vol_ufsClone(volp=0x.x vol2_p=0x.x) = EINVAL" },
{ 704008232, "vol_ufsReclone(volp=0x.x vol2_p=0x.x) = EINVAL" },
{ 704008233, "vol_ufsUnclone(volp=0x.x vol2_p=0x.x) = EINVAL" },
{ 704008234, "IN vol_ufsVget(volp=0x.x fid=.x..x..x..x)" },
{ 704008235, "IN vol_ufsRoot(volp=0x.x)" },
{ 704008236, "vol_ufsIsRoot(volp=0x.x fid=.x..x..x..x flag=.d)" },
{ 704008237, "vol_ufsGetVV(volp=0x.x vv=.d,,.d)" },
{ 704008238, "IN vol_ufsSetDyStat(volp=0x.x vsp=0x.x)" },
{ 704008239, "vol_ufsSetNewVID(volp=0x.x newid=.d,,.d)" },
{ 704008240, "vol_ufsCopyAcl(volp=0x.x Fid=.x..x..x..x destw=.d index=.d) = ENOTTY" },
{ 704008241, "IN vol_ufsFreeDyStat(volp=0x.x fsDatap=0x.x)" },
{ 704008242, "vol_ufsConcurr(volp=0x.x type=.d errorType=.d *concurr=.d)" },
{ 704008243, "vol_ufsSwapIDs(vol1p=0x.x vol1->volID=.d,,.d vol2_p=0x.x vol2->volID=.d,,.d)" },
{ 704008244, "vol_ufsSync(volp=0x.x volId=.d,,.d guarantee=.d)" },
{ 704008245, "vol_ufsPushStatus(volp=0x.x volId=.d,,.d)" },
{ 704008246, "vol_ufsReaddir(volp=0x.x volId=.d,,.d)" },
{ 704008247, "vol_ufsAppenddir(volp=0x.x volId=.d,,.d)" },
{ 704008248, "vol_ufsGetZLC(volp=0x.x volId=.d,,.d iterP=0x.x VpP=0x.x)" },
{ 704008249, "IN vol_ufsGetNextHoles(volp=0x.x volId=.d,,.d)" },
{ 704008250, "vol_ufsBulkSetStatus(arrayLen=.d statusArray=.x) = EINVAL" },
{ 704008251, "END ag_ufsLock() .d" },
{ 704008252, "END ag_ufsUnlock() .d" },
{ 704008253, "END ag_ufsStat() .d" },
{ 704008254, "END ag_ufsVolCreate() .d" },
{ 704008255, "END ag_ufsVolInfo(): index != 1: .d" },
{ 704008256, "END ag_ufsVolInfo(): no volume: .d" },
{ 704008257, "END ag_ufsVolInfo(): .d" },
{ 704008258, "END ag_ufsDetach(): .d" },
{ 704008259, "END ag_ufsAttach(): code .d from osi_copyin()" },
{ 704008260, "END ag_ufsAttach(): code .d from osi_lookupname()" },
{ 704008261, "END ag_ufsAttach(): MOUNT_UFS (.d) != vfs_mtype (.d)" },
{ 704008262, "END ag_ufsAttach(): returning EINVAL (.d)" },
{ 704008263, "END ag_ufsAttach(): returning 0" },
{ 704008264, "END vol_ufsHold()" },
{ 704008265, "END vol_ufsRele()" },
{ 704008266, "END vol_ufsLock(): .d" },
{ 704008267, "END vol_ufsUnlock(): .d" },
{ 704008268, "END vol_ufsOpen(): .d" },
{ 704008269, "END vol_ufsSeek(): .d" },
{ 704008270, "END vol_ufsTell(): 0" },
{ 704008271, "END vol_ufsScan(): vol_ufsSeek returns .d" },
{ 704008272, "END vol_ufsScan(): .d" },
{ 704008273, "END vol_ufsClose(): 0" },
{ 704008274, "END vol_ufsAttach(): no v_paggrp so returning .d" },
{ 704008275, "END vol_ufsAttach(): 0" },
{ 704008276, "END vol_ufsDetach(): .d" },
{ 704008277, "END vol_ufsGetStatus(): ag_ufsStat returns .d" },
{ 704008278, "END vol_ufsGetStatus(): 0" },
{ 704008279, "END vol_ufsSetStatus(): .d" },
{ 704008280, "END vol_ufsCreate(): vol_ufsDelete returns .d" },
{ 704008281, "END vol_ufsCreate(): vol_ufsScan returns .d" },
{ 704008282, "END vol_ufsCreate(): vol_ufsCreate_mach returns .d" },
{ 704008283, "END vol_ufsRead(): VOL_VGET returns .d" },
{ 704008284, "END vol_ufsRead(): .d" },
{ 704008285, "END vol_ufsWrite(): VOL_VGET returns .d" },
{ 704008286, "END vol_ufsWrite(): .d" },
{ 704008287, "END vol_ufsReadHole(): .d" },
{ 704008288, "END vol_ufsTruncate(): VOL_VGET returns .d" },
{ 704008289, "END vol_ufsTruncate(): .d" },
{ 704008290, "END vol_ufsDelete(): .d" },
{ 704008291, "END vol_ufsGetattr(): VOL_VGET returns .d" },
{ 704008292, "END vol_ufsGetattr(): .d" },
{ 704008293, "END vol_ufsSetattr(): VOL_VGET returns .d" },
{ 704008294, "END vol_ufsSetattr(): .d" },
{ 704008295, "END vol_ufsGetAcl(): VOL_VGET returns .d" },
{ 704008296, "END vol_ufsGetAcl(): .d" },
{ 704008297, "END vol_ufsSetAcl(): VOL_VGET returns .d" },
{ 704008298, "END vol_ufsSetAcl(): .d" },
{ 704008299, "END vol_ufsVget(): .d" },
{ 704008300, "END vol_ufsRoot(): VFSX_ROOT returns a null pointer: .d" },
{ 704008301, "END vol_ufsRoot(): .d" },
{ 704008302, "END vol_ufsSetDyStat(): 0" },
{ 704008303, "END vol_ufsFreeDyStat(): 0" },
{ 704008304, "END vol_ufsReaddir(): VOL_VGET returns .d" },
{ 704008305, "END vol_ufsReaddir(): .d" },
{ 704008306, "END vol_ufsAppenddir(): VOL_VGET returns .d" },
{ 704008307, "END vol_ufsAppenddir(): .d" },
{ 704008308, "END vol_ufsGetNextHoles(): VOL_VGET returns .d" },
{ 704008309, "END vol_ufsGetNextHoles(): .d" },
{ 704008310, "IN vol_ufsReadPurgeHole(volp=0x.x fid=.x..x..x..x readHoleP=.#x)" },
{ 704008311, "END vol_ufsReadPurgeHole(): .d" },
{ 704008312, "form GPFS fid: .#x, .#x, .#x" },
{ 704028673, "ubik_ServerInit(myHost=0x.x, nsGroupP=.s, secGroupP=.s, pathName=.s) entered" },
{ 704028674, "ubik_ServerInit returns (errorcode=.ld)" },
{ 704028675, "ubik_GetServerList returns (groupName=.s, groupSize=.ld, errorcode=.ld)" },
{ 704028676, "ContactQuorum (host=.s, func=0x.x, transPtr=0x.x)" },
{ 704028677, "ContactQuorum(transPtr=0x.x) returns (errorcode=.ld)" },
{ 704028678, "ubik_BeginTrans (transMode=.ld)" },
{ 704028679, "ubik_BeginTrans returns (transPtr=0x.x, errorcode=.ld)" },
{ 704028680, "ubik_AbortTrans (transPtr=0x.x)" },
{ 704028681, "ubik_AbortTrans(transPtr=0x.x) returns( errorcode=.ld)" },
{ 704028682, "ubik_EndTrans (transPtr=0x.x)" },
{ 704028683, "ubik_EndTrans(transPtr=0x.x) returns (errorcode=.ld)" },
{ 704028684, "ubik_Read (transPtr=0x.x, buffer=0x.x, length=.ld)" },
{ 704028685, "ubik_Read(transPtr=0x.x) returns (errorcode=.ld)" },
{ 704028686, "ubik_Write (transPtr=0x.x, buffer=0x.x, length=.ld)" },
{ 704028687, "ubik_Write(transPtr=0x.x) returns (errorcode=.ld)" },
{ 704028688, "ubik_Seek (transPtr=0x.x, fileid=.ld, position=.ld)" },
{ 704028689, "ubik_Seek(transPtr=0x.x) returns (errorcode=.ld)" },
{ 704028690, "ubik_Tell (transPtr=0x.x)" },
{ 704028691, "ubik_Tell(transPtr=0x.x) returns (fileid=.ld, position=.ld)" },
{ 704028692, "ubik_Truncate (transPtr=0x.x, length=.ld)" },
{ 704028693, "ubik_Truncate(transPtr=0x.x) returns (errorcode=.ld)" },
{ 704028694, "ubik_SetLock (transPtr=0x.x, position=.ld, length=.ld, type=.ld)" },
{ 704028695, "ubik_SetLock(transPtr=0x.x) returns (errorcode=.ld)" },
{ 704028696, "ubik_WaitVersion (our version .ld..ld, wait for .ld..ld)" },
{ 704028697, "ubik_thrPoolLookup, use ubik thread pool" },
{ 704028698, "ubik_thrPoolLookup, use default thread pool" },
{ 704028699, "SUBIKDISK_GetServerInterfaces (handle=0x.x)" },
{ 704028700, "SUBIKDISK_GetServerInterfaces(handle=0x.x) returns (errorcode=.ld)" },
{ 704028701, "SUBIKDISK_Begin (handle=0x.x, transId .ld..ld)" },
{ 704028702, "SUBIKDISK_Beginx(handle=0x.x) returns (errorcode=.ld)" },
{ 704028703, "SUBIKDISK_Commit (handle=0x.x, transId .ld..ld)" },
{ 704028704, "SUBIKDISK_Commit(handle=0x.x) returns (errorcode=.ld)" },
{ 704028705, "SUBIKDISK_ReleaseLocks (handle=0x.x, transId .ld..ld)" },
{ 704028706, "SUBIKDISK_ReleaseLocks(handle=0x.x) returns (errorcode=.ld)" },
{ 704028707, "SUBIKDISK_Abort (handle=0x.x, transId .ld..ld)" },
{ 704028708, "SUBIKDISK_Abort(handle=0x.x) returns (errorcode=.ld)" },
{ 704028709, "SUBIKDISK_Lock (handle=0x.x, transId .ld..ld)" },
{ 704028710, "SUBIKDISK_Lock (file=.ld, pos=.ld, len=.ld, type=.ld)" },
{ 704028711, "SUBIKDISK_Lock(handle=0x.x) returns (errorcode=.ld)" },
{ 704028712, "SUBIKDISK_Write (handle=0x.x, transId .ld..ld)" },
{ 704028713, "SUBIKDISK_Write (file=.ld, pos=.ld, len=.ld, buffer=0x.x)" },
{ 704028714, "SUBIKDISK_Write(handle=0x.x) returns (errorcode=.ld)" },
{ 704028715, "SUBIKDISK_Truncate (handle=0x.x, transId .ld..ld)" },
{ 704028716, "SUBIKDISK_Truncate (file=.ld, len=.ld)" },
{ 704028717, "SUBIKDISK_Truncate(handle=0x.x) returns (errorcode=.ld)" },
{ 704028718, "SUBIKDISK_GetVersion (handle=0x.x)" },
{ 704028719, "SUBIKDISK_GetVersion(handle=0x.x) returns (version .ld..ld, errorcode=.ld)" },
{ 704028720, "SUBIKDISK_GetFile (handle=0x.x, file=.ld, pipe=0x.x)" },
{ 704028721, "SUBIKDISK_GetFile(handle=0x.x) returns (version .ld..ld, errorcode=.ld)" },
{ 704028722, "SUBIKDISK_SendFile (handle=0x.x, file=.ld, len=.ld, pipe=0x.x)" },
{ 704028723, "SUBIKDISK_SendFile (version .ld..ld)" },
{ 704028724, "SUBIKDISK_SendFile(handle=0x.x) returns (errorcode=.ld)" },
{ 704028725, "SUBIKDISK_Probe (handle=0x.x)" },
{ 704028726, "SUBIKVOTE_GetServerInterfaces (handle=0x.x)" },
{ 704028727, "SUBIKVOTE_Beacon (host=.s, state=.ld, start=.ld)" },
{ 704028728, "SUBIKVOTE_Beacon (version .ld..ld, transId .ld..ld)" },
{ 704028729, "SUBIKVOTE_Beacon host .s not found in configuration, vote=.d" },
{ 704028730, "SUBIKVOTE_Beacon host .s not lowest, lowest host .s, vote=.d" },
{ 704028731, "SUBIKVOTE_Beacon host .s not sync site, sync site .s,vote=.d" },
{ 704028732, "SUBIKVOTE_Beacon(host=.s) returns (vote=.ld, errorcode=.ld)" },
{ 704028733, "SUBIKVOTE_Beacon(handle=0x.x) returns (host=.s, errorcode=.ld)" },
{ 704028734, "recovery running on host .s in state 0x.x" },
{ 704028735, "recovery marking host .s as up" },
{ 704028736, "recovery running on sync site, state 0x.x" },
{ 704028737, "recovery got bad db version .ld..ld from server .s" },
{ 704028738, "recovery failed to get version from server .s, errorcode=.ld" },
{ 704028739, "recovery found best db version .ld..ld on server .s" },
{ 704028740, "recovery failed to find best db, replies=.ld, errorcode=.ld" },
{ 704028741, "recovery fetching database version .ld..ld from server .s" },
{ 704028742, "recovery fetched db version .ld..ld, errorcode=.ld" },
{ 704028743, "recovery already has latest db version .ld..ld, state 0x.x" },
{ 704028744, "recovery labelling db .ld..ld, errorcode=.ld" },
{ 704028745, "recovery sending db to .s, errorcode=.ld" },
{ 704028746, "recovery aborting all open transactions" },
{ 704028747, "recovery noticed server going down, db to be sent on wake up" },
{ 704028748, "recovery detected transaction mismatch; current transId.ld..ld, incoming transId .ld..ld, aborting current transaction" },
{ 704028749, "received vote .ld from server .s, errorcode=.ld" },
{ 704028750, "received .ld votes from .ld servers" },
{ 704028751, "udisk_LogOpcode (opcode=.ld, sync=.ld)" },
{ 704028752, "udisk_LogEnd (version .ld..ld)" },
{ 704028753, "udisk_LogTruncate (file=.ld, length=.ld)" },
{ 704028754, "udisk_LogWriteData (file=.ld, buffer=0x.x, pos=.ld, len=.ld)" },
{ 704028755, "udisk_read (trans=0x.x)" },
{ 704028756, "udisk_read (file=.ld, buffer=0x.x, pos=.ld, len=.ld)" },
{ 704028757, "udisk_truncate (trans=0x.x, file=.ld, len=.ld)" },
{ 704028758, "udisk_write (trans=0x.x)" },
{ 704028759, "udisk_write (file=.ld, buffer=0x.x, pos=.ld, len=.ld)" },
{ 704028760, "udisk_begin (type=.ld)" },
{ 704028761, "udisk_begin returns (trans=0x.x)" },
{ 704028762, "udisk_commit (trans=0x.x)" },
{ 704028763, "udisk_abort (trans=0x.x)" },
{ 704028764, "udisk_end (trans=0x.x)" },
{ 704028765, "udisk_begin setting DBWRITING bit; flags 0x.x" },
{ 704028766, "udisk_begin unsetting DBWRITING bit; flags 0x.x" },
{ 704028767, "ulock_SetLock (trans=0x.x)" },
{ 704028768, "ulock_SetLock (pos=.ld, len=.ld, type=.ld, wait=.ld)" },
{ 704028769, "ulock_ReleaseAllLocks (trans=0x.x)" },
{ 704028770, "ubik low level lock attempt to hold" },
{ 704028771, "ubik low level lock held" },
{ 704028772, "ubik low level lock attempt to release" },
{ 704028773, "ubik low level lock released" },
{ 704028774, "ubik version lock attempt to hold" },
{ 704028775, "ubik version lock held" },
{ 704028776, "ubik version lock attempt to release" },
{ 704028777, "ubik version lock released" },
{ 704028778, "ubik_sleep waiting for writer to finish; flags 0x.x" },
{ 704028779, "upipe_FilePull reading=.ld, read=.ld, errorcode=.ld" },
{ 704028780, "upipe_FilePush writing=.ld, wrote=.ld, errorcode=.ld" },
{ 704028781, "ubik RPC generated exception .s, in file .s at line .ld" },
{ 704028782, "upipe_FilePull entered" },
{ 704028783, "upipe_FilePull exit, read .ld bytes" },
{ 704028784, "upipe_FilePush entered, .ld bytes requested" },
{ 704028785, "upipe_FilePush exit" },
{ 704028786, "failed to queue a concurrent beacon RPC" },
{ 704028787, "failed to begin concurrent beacons" },
{ 704028788, "failed to queue a concurrent probe RPC" },
{ 704028789, "failed to begin concurrent probes" },
{ 704028790, "clock skew .ld between servers too high" },
{ 704028791, "original server count .ld, tallied .ld, count from namespace .ld" },
{ 704028792, "failed to queue request that keeps name space and configuration in sync" },
{ 704028793, "caller not part of configuration, result of verification: .s" },
{ 704028794, "bump tid counter by .d" },
{ 704028795, "calling urecovery_CheckTid from .s" },
{ 704028796, "write trans has to wait for existing writer" },
{ 704028797, "writer has exited, go ahead and do the write" },
{ 704028798, "wakeup the sleeping writer" },
{ 704028799, "writer has exited, go ahead and propagate the database" },
{ 704028800, "ShouldIRun: Yes; no known sync site (lastYes vote given at .lu)" },
{ 704028801, "ShouldIRun: No; .#lx claimed to be sync (.ld) at time .ld" },
{ 704028802, "ShouldIRun: No; .#lx is available and lower than us (.#lx)" },
{ 704028803, "ShouldIRun: Yes; nobody better than us now" },
{ 704028804, "uvote_ResetState: Resetting our configuration" },
{ 704028805, "SUBIKDISK_Probe exit (code=.ld)" },
{ 704028806, "sending probe to host .s" },
{ 704028807, "probe to host .s failed, code= .ld" },
{ 704028808, "ubik_Flush (transPtr=0x.x)" },
{ 704028809, "ubik_Flush(transPtr=0x.x) returns (errorcode=.ld)" },
{ 704028810, "SUBIKDISK_BulkUpdate (handle=0x.x, transId .ld..ld)" },
{ 704028811, "SUBIKDISK_BulkUpdate (uop=.ld, arg1=.ld, arg2=.ld, arg3=.ld," },
{ 704028812, "                      arg4=.ld, length=.ld, data=0x.x)" },
{ 704028813, "SUBIKDISK_BulkUpdate(handle=0x.x) returns (errorcode=.ld)" },
{ 704028814, "DiskRpcCall (host=.s, func=0x.x, transPtr=0x.x)" },
{ 704028815, "DiskRpcCall(transPtr=0x.x) returns (errorcode=.ld)" },
{ 704028816, "ContactQuorum (func=0x.x, transPtr=0x.x, pver=.d, compat=0x.x)" },
{ 704028817, "AsyncContactQuorum (func=0x.x, transPtr=0x.x, pver=.d, compat=0x.x)" },
{ 704028818, "AsyncContactQuorum(transPtr=0x.x) returns (errorcode=.ld)" },
{ 704028819, "WaitContactQuorum (transPtr=0x.x)" },
{ 704028820, "WaitContactQuorum(transPtr=0x.x) returns (errorcode=.ld)" },
{ 704028821, "PANIC: .s failed during commit (errorcode=.ld)" },
{ 704028822, "SUBIKVOTE_Beacon(handle=0x.x) returns (host=.s, errorcode=.ld)" },
{ 704196609, "vnl_alloc(flock=.lx, end=.lld): allocates .lx" },
{ 704196610, "vnl_free(rlock=.x) called" },
{ 704196611, "vnl_adjust(flock=.x, type=.d, start=.llx, end=.llx) called" },
{ 704196612, "vnl_adjust: list .x, starting rlock .x, type .d, start=.llx" },
{ 704196613, "vnl_adjust: element .x, next .x, elt start .llx, *end .llx" },
{ 704196614, "vnl_adjust: skipping; element ID .d/.x differs from given .d/.x" },
{ 704196615, "vnl_adjust: skipping; data end .llx less than given start .llx" },
{ 704196616, "vnl_adjust: same type .d: deleting since elt start .llx > given start .llx; end now .llx" },
{ 704196617, "vnl_adjust: same type .d: deleting since elt end .llx < given end .llx: given start now .llx" },
{ 704196618, "vnl_adjust: same type .d: noop on rlock [.llx...llx], elt start .llx" },
{ 704196619, "vnl_adjust: diff types, non-overlap (elt st .llx > given end .llx, or elt end .llx < given start .llx)" },
{ 704196620, "vnl_adjust: elt end .llx > given end .llx, elt start .llx, new lock after .lx" },
{ 704196621, "vnl_adjust: elt start .llx < given start .llx, so cutting elt end to .llx (given end .llx)" },
{ 704196622, "vnl_adjust: deleting lock .lx, type .d, [.llx...llx]" },
{ 704479233, "afscall_aggr(op=.ld)" },
{ 704479234, "afscall_aggr returns .ld" },
{ 704479235, "ag_volcreate(aggr .ld, id .lu,,.lu, flags .ld): calling AG_VOLCREATE" },
{ 704479236, "ag_volcreate returns .ld" },
{ 704479237, "ag_attach: params are .lx, .lx, .lx" },
{ 704479238, "ag_attach: returns code .ld from osi_copyin()" },
{ 704479239, "ag_attach: ag_GetAggr found the aggr; returning EEXIST" },
{ 704479240, "unused" },
{ 704479241, "unused" },
{ 704479242, "ag_attach: osi_getvdev returns .ld" },
{ 704479243, "ag_attach: AGGR_ATTACH_NOEXPORT set, so return .ld" },
{ 704479244, "ag_attach: Already exported--returning .ld" },
{ 704479245, "ag_attach: Registered after noexport--returning .ld" },
{ 704479246, "ag_attach: unknown aggregate type: returning .ld" },
{ 704479247, "ag_attach: .ld returned from dependent attach-op" },
{ 704479248, "ag_attach: no ag-operations vector: returning .ld" },
{ 704479249, "ag_attach: ag_NewAggr returned .ld" },
{ 704479250, "ag_aggrInfo: for aggrid .ld" },
{ 704479251, "ag_aggrInfo returns .ld" },
{ 704479252, "ag_aggrEnumerate(.ld, .lx, .lx) called" },
{ 704479253, "ag_aggrEnumerate: outlen .ld (for .ld aggrs) too small; return .ld" },
{ 704479254, "ag_aggrEnumerate: returning .ld" },
{ 704479255, "ag_volEnumerate(.ld, .lx, .lx, .lx) called" },
{ 704479256, "ag_volEnumerate returns .ld from osi_copyin" },
{ 704479257, "ag_volEnumerate can't store .ld bytes (.d vols): code .ld" },
{ 704479258, "ag_volEnumerate: agid .lu, going for .lu vol(s)" },
{ 704479259, "ag_volEnumerate: AG_VOLINFO, index .ld, gives code .ld" },
{ 704479260, "ag_volEnumerate: index .ld, returning code .ld" },
{ 704479261, "ag_volEnumerate: VOL_GETSTATUS for ix .ld returns code .ld" },
{ 704479262, "ag_volEnumerate: batch done: returning code .ld" },
{ 704479263, "ag_volEnumerate: ag_GetAggr(.ld) returns null; returning ENODEV" },
{ 704479264, "ag_RegisterVolumes: registering on aggr .ld" },
{ 704479265, "ag_RegisterVolumes: AG_VOLINFO ix .ld gives .lu,,.lu, code .ld" },
{ 704479266, "ag_RegisterVolumes: vol_Attach(.lu,,.lu) gives states .x, code .ld" },
{ 704479267, "ag_RegisterVolumes: finished code .d" },
{ 704479268, "ag_UnRegisterVolumes: unregistering on aggr .ld" },
{ 704479269, "ag_UnRegisterVolumes: AG_VOLINFO ix .ld gives .lu,,.lu, code .ld" },
{ 704479270, "ag_UnRegisterVolumes: volreg_Lookup(.lu,,.lu) returns .ld" },
{ 704479271, "ag_UnRegisterVolumes: vol .lu,,.lu is busy: returning .ld" },
{ 704479272, "ag_UnRegisterVolumes: can't open vol .lu,,.lu: code .ld" },
{ 704479273, "ag_UnRegisterVolumes: vol_Detach(.lu,,.lu) returns .ld" },
{ 704479274, "ag_UnRegisterVolumes: after VOL_RELE(.lu,,.lu), code is .ld" },
{ 704479275, "ag_NewAggr(.s, .ld, .#lx) called" },
{ 704479276, "ag_NewAggr: .#lx already exists to match" },
{ 704479277, "ag_NewAggr: aggr id .d, aggr structure .#lx, code .d" },
{ 704479278, "ag_PutAggr: decreasing ref count on aggr .lx" },
{ 704479279, "ag_PutAggr: FINAL decreasing of ref count on aggr .lx" },
{ 704479280, "ag_PutAggr: returning code .ld" },
{ 704479281, "ag_PutAggr: pointer .lx not in list: returning ENOENT" },
{ 704479282, "ag_attach: ag_GetAggr found the aggr; returning .d from register-vols" },
{ 704479283, "ag_fsHold: aggr .#x, ref now .d" },
{ 704479284, "ag_fsRele: aggr .#x, ref now .d" },
{ 704479285, "ag_fsLock: aggr .#x, type .d: obtaining lock" },
{ 704479286, "ag_fsLock: returning code .d" },
{ 704479287, "ag_fsUnlock: aggr .#x, type .d: releasing lock" },
{ 704479288, "ag_fsUnlock: returning code .d" },
{ 704479289, "ag_fsDMHold: aggr .#x" },
{ 704479290, "ag_fsDMRele: aggr .#x" },
{ 704479291, "ag_volcreate: vol_Attach for new volume returned code .d" },
{ 704479292, "ag_volcreate: AG_VOLINFO failed for fresh volume with code .d" },
{ 704479293, "ag_volcreate: AG_VOLCREATE failed with code .d" },
{ 704479294, "ag_attach: resulting code .d" },
{ 704479295, "ag_UnRegisterVolumes: starting system-wide DNLC purge" },
{ 704479296, "ag_UnRegisterVolumes: finished system-wide DNLC purge" },
{ 704565249, "vol syscall .lu: bit not set (accstatus .lu), line .lu" },
{ 704565250, "afscall_volser: op .lu" },
{ 704565251, "afscall_volser: no such volume as .lu: code .lu" },
{ 704565252, "afscall_volser: no volume desc for .lu: code .lu" },
{ 704565253, "afscall_volser: volop_close waking grabber for .lu" },
{ 704565254, "afscall_volser: volop_close waking looker for .lu" },
{ 704565255, "afscall_volser: cloneop: diff aggr for .lu (.lu) and .lu (.lu)" },
{ 704565256, "afscall_volser: cloneop: diff volops for .lu and .lu" },
{ 704565257, "afscall_volser: no volume desc for clone second .lu: code .lu" },
{ 704565258, "afscall_volser: cloneop: diff volop vec for .lu and .lu" },
{ 704565259, "afscall_volser: no volume desc for swap second .lu: code .lu" },
{ 704565260, "vol_open: vid .lu,,.lu, accstat .lu, accerr .lu" },
{ 704565261, "vol_open: no such volume as .lu,,.lu: code .lu" },
{ 704565262, "vol_open: volume .lu,,.lu is busy (states .#lx, accerror .lu)" },
{ 704565263, "vol_open: volume .lu,,.lu: WAITING; concur .lu, ref .lu, vnops .lu" },
{ 704565264, "vol_open: volume .lu,,.lu: awake from waiting" },
{ 704565265, "vol_open: volume .lu,,.lu: err .lu from VOL_OPEN" },
{ 704565266, "vol_open: volume .lu,,.lu: err .lu from copyout()" },
{ 704565267, "vol_open: volume .lu,,.lu: vol_open SUCCEEDS" },
{ 704565268, "vol_RCZero: waking grabber for .lu" },
{ 704565269, "vol_RCZero: waking looker for .lu" },
{ 704565270, "vol_GCDesc: GCed .d structs" },
{ 704565271, "vol_GetDesc: ALL ENTRIES FULL" },
{ 704565272, "vol_GetDesc: returning entry .d" },
{ 704565273, "vol_FindDesc: slot .d out of bounds" },
{ 704565274, "vol_FindDesc: slot .d empty" },
{ 704565275, "vol_FindDesc: diff procs (cdp: .d vs. current: .d)" },
{ 704565276, "vol_FindDesc: diff descIds (cdp: .d vs. given: .d)" },
{ 704565277, "vol_FindDesc: cdp .#lx, descId .d Deleted" },
{ 704565278, "vol_FindDesc: returning cdp .#lx, slot .d" },
{ 704565279, "vol_Init called" },
{ 704565280, "vol_Attach: volId=.lu,,.lu, aggrid=.lu" },
{ 704565281, "vol_Detach: volp=.#x, id=.lu,,.lu, refCnt=.lu" },
{ 704565282, "vol_StartVnodeOp: volp .#lx, waiting on code .d" },
{ 704565283, "afscall_volser: VOLOP_OPEN" },
{ 704565284, "afscall_volser: VOLOP_AGOPEN" },
{ 704565285, "afscall_volser: VOLOP_FCLOSE" },
{ 704565286, "afscall_volser: VOLOP_FCLOSE: .lu,,.lu" },
{ 704565287, "afscall_volser: VOLOP_BULKSETSTATUS: .lu status blocks" },
{ 704565288, "afscall_volser: op .lu on volp .#lx, id .lu,,.lu" },
{ 704565289, "vol_Detach(.#lx): also freeing tpq .#lx" },
{ 704565290, "vol_SwapIdentities: swapping .#lx (.lu,,.lu) and .#lx (.lu,,.lu)" },
{ 704565291, "vol_doMoveTimeout(.#lx), id .lu,,.lu: states .#lx: timeout .lu expired" },
{ 704565292, "vol_doMoveTimeout: incomplete target fileset timed out" },
{ 704565293, "vol_doMoveTimeout: TARGET timeout: setting OOS and timeout to .lu" },
{ 704565294, "vol_doMoveTimeout: SOURCE timeout: setting OOS and timeout to .lu" },
{ 704565295, "vol_doMoveTimeout: SOURCE|OFFLINE timeout: setting OOS and timeout to .lu" },
{ 704565296, "vol_doMoveTimeout: TARGET|OOS timeout: returning to service" },
{ 704565297, "vol_doMoveTimeout: SOURCE|OOS timeout: returning to service" },
{ 704565298, "vol_doMoveTimeout: SOURCE|OFFLINE|OOS timeout: setting ZAPME" },
{ 704565299, "vol_doMoveTimeout: incomplete source fileset timed out" },
{ 704565300, "vol_doMoveTimeout(.#lx), id .lu,,.lu: unrecognized status .#lx!" },
{ 704565301, "vol_advanceMove(.#lx), id .lu,,.lu: timeout .lu, calling doMoveTimeout" },
{ 704565302, "vol_DriveMove(.#lx), id .lu,,.lu called" },
{ 704565303, "vol_DriveMove(.lu,,.lu) called: volreg_Lookup returns .ld" },
{ 704565304, "vol_DriveMove(.#lx): states .#lx, includes VOL_BUSY, so skipping" },
{ 704565305, "vol_DriveMove(.#lx): rescheduling for .ld seconds from now" },
{ 704565306, "vol_DriveMove(.#lx): states .#lx, timeout .lu, so no resched" },
{ 704565307, "vol_DriveMove(.#lx): clearing tpq .#lx and freeing argp .#lx" },
{ 704565308, "vol_SetMoveTimeoutTrigger(.#lx), id .lu,,.lu, states .#lx, timeout .lu:" },
{ 704565309, "      id arg at .#lx, reschedule is .ld, request ptr is .#lx" },
{ 704565310, "CheckAndLinkZLC(volp=.x, states=.#lx) called" },
{ 704565311, "LinkZLCList(volp=.x, exported=.d, replicated=.d) called" },
{ 704565312, "LinkZLCList at iter .d: getzlc got vp .x, code .d" },
{ 704565313, "LinkZLCList got fid .x..x..x..x, code .d" },
{ 704565314, "LinkZLCList returns .d" },
{ 704565315, "vol_StartInactiveVnodeOp: volp .x busy; vp .x; vol has concurr .d" },
{ 704565316, "vol_StartInactiveVnodeOp: holding vp .x in element .x" },
{ 704565317, "vol_ProcessDeferredReles: releasing vp .x from element .x" },
{ 704565318, "vol_fsHold: volp .x: ref count now .d" },
{ 704565319, "vol_fsRele: volp .x: ref count starts at .d" },
{ 704565320, "vol_fsLock: volp .x type .d: about to lock" },
{ 704565321, "vol_fsLock: locked, returning code .d" },
{ 704565322, "vol_fsUnlock: volp .x type .d: about to unlock" },
{ 704565323, "vol_fsUnlock: returning code .d" },
{ 704565324, "vol_fsDMWait: volp .x, blobp .x" },
{ 704565325, "vol_fsDMFree: volp .x, blobp .x" },
{ 704565326, "vol_FindDesc: cdp .#lx, descId .d: volp is NULL" },
{ 704565327, "volo_ClearOpener: volp .#x closed while thread .d still running" },
{ 704565328, "vol_open: id .lu,,.lu: code .lu" },
{ 704565329, "vol_GetDesc: returning slot .d, desc .d" },
{ 704851969, "zlc_TryRemove(.#lx, .x..x..x..x, .ld, .ld) entered" },
{ 704851970, "zlc_TryRemove: tokenID=.u,,.u, flags=.#lx, refCount=.ld, wait=.ld" },
{ 704851971, "zlc_TryRemove returning" },
{ 704851972, "zlc_GetDeleteToken(tokenID=.u,,.u, flags=.#lx, refCount=.ld, wait=.ld) entered" },
{ 704851973, "zlc_GetDeleteToken: volreg_Lookup failed, code=.ld" },
{ 704851974, "zlc_GetDeleteToken: volume being moved, volstates=.#lx" },
{ 704851975, "zlc_GetDeleteToken: volume being moved, volstates=.#lx, wait=.ld" },
{ 704851976, "zlc_GetDeleteToken: volume being moved locally, wait=.ld" },
{ 704851977, "zlc_GetDeleteToken: remove granted" },
{ 704851978, "zlc_GetDeleteToken: request queued" },
{ 704851979, "zlc_GetDeleteToken returning" },
{ 704851980, "zlc_CleanVolume(.u,,.u) entered" },
{ 704851981, "zlc_CleanVolume returning" },
{ 704851982, "zlc_Mgr: pruning remove queue" },
{ 704851983, "zlc_Mgr: waiting for .ld seconds" },
{ 704851984, "zlc_PruneQueue() entered" },
{ 704851985, "zlc_PruneQueue: .x..x..x..x: token granted--returning token" },
{ 704851986, "zlc_PruneQueue: .x..x..x..x: freeing clean trp" },
{ 704851987, "zlc_PruneQueue: .x..x..x..x: trying for delete token" },
{ 704851988, "zlc_PruneQueue: .x..x..x..x: waiting until .ld" },
{ 704851989, "zlc_PruneQueue: .x..x..x..x: waiting until .ld for tsr on replicated ft" },
{ 704851990, "zlc_PruneQueue: .x..x..x..x: waiting until .ld" },
{ 704851991, "zlc_PruneQueue: .x..x..x..x: trying for delete token" },
{ 704851992, "zlc_PruneQueue returning .ld" },
{ 704851993, "zlc_WakeupMgr() entered" },
{ 704851994, "[zlc]FreeDownToQuota() entered, list size=.ld" },
{ 704851995, "[zlc]FreeDownToQuota: .x..x..x..x: moribund" },
{ 704851996, "[zlc]FreeDownToQuota: adding entry to async list: tokenID=.u,,.u, flags=.#lx, refCount=.ld, wait=.ld" },
{ 704851997, "[zlc]FreeDownToQuota: adding entry to dally list: tokenID=.u,,.u, flags=.#lx, refCount=.ld, wait=.ld" },
{ 704851998, "[zlc]FreeDownToQuota: adding entry to wait list: tokenID=.u,,.u, flags=.#lx, refCount=.ld, wait=.ld" },
{ 704851999, "[zlc]FreeDownToQuota: skipping entry: tokenID=.u,,.u, flags=.#lx, refCount=.ld, wait=.ld" },
{ 704852000, "[zlc]FreeDownToQuota returning, vnodes held=.ld" },
{ 704852001, "zlc_SetRestartState(.ld) entered" },
{ 704852002, "zlc_SetRestartState returning" },
{ 704852003, "zlc_AsyncGrant(.#lx, .#lx, .#lx) entered" },
{ 704852004, "zlc_AsyncGrant: found entry: tokenID=.u,,.u, flags=.#lx, refCount=.ld, wait=.ld" },
{ 704852005, "zlc_AsyncGrant: volreg_Lookup failed, code=.ld" },
{ 704852006, "zlc_AsyncGrant: volume being moved, volstates=.#lx" },
{ 704852007, "zlc_AsyncGrant: volume being moved, volstates=.#lx, wait=.ld" },
{ 704852008, "zlc_AsyncGrant: .x..x..x..x: token granted" },
{ 704852009, "zlc_AsyncGrant: entry not found" },
{ 704852010, "zlc_RevokeToken(list-len=.ld, first-fid=.x..x..x..x) entered" },
{ 704852011, "zlc_AsyncGrant: found entry: fid=.x..x..x..x, state=.ld" },
{ 704852012, "zlc_AsyncGrant: fid=.x..x..x..x, from-state=.ld, to-state=.ld" },
{ 704852013, "zlc_AsyncGrant returning" },
{ 704852014, "zlc_CleanVolume: fid=.x..x..x..x, from-state=.ld, to-state=.ld" },
{ 704852015, "zlc_GetDeleteToken(fid=.x..x..x..x) entered" },
{ 704852016, "zlc_GetDeleteToken: fid=.x..x..x..x, OFD granted" },
{ 704852017, "zlc_GetDeleteToken: fid=.x..x..x..x, OFD queued" },
{ 704852018, "zlc_GetDeleteToken: fid=.x..x..x..x, tkm_GetToken error, code=.ld" },
{ 704852019, "zlc_GetDeleteToken: fid=.x..x..x..x, tkm_ReturnToken error, code=.ld" },
{ 704852020, "zlc_GetDeleteToken: fid=.x..x..x..x, from-state=.ld, to-state=.ld" },
{ 704852021, "zlc_TryRemove(.#lx, .x..x..x..x) entered" },
{ 704852022, "zlc_TryRemove: fid=.x..x..x..x, init-state=.ld" },
{ 704852023, "zlc_GotoNextState: fid=.x..x..x..x, volreg_Lookup failed, code=.ld" },
{ 704852024, "[zlc]FreeDownToTarget(vnodes-held=.ld) entered" },
{ 704852025, "[zlc]FreeDownToTarget: fid=.x..x..x..x, from-state=.ld, to-state=.ld" },
{ 704852026, "[zlc]FreeDownToTarget(vnodes-held=.ld) returning" },
{ 704852027, "[zlc]PruneQueue() entered" },
{ 704852028, "[zlc]PruneQueue: fid=.x..x..x..x, from-state=.ld, to-state=.ld" },
{ 704852029, "[zlc]PruneQueue() returning .lu" },
{ 704852030, "zlc_WakeupMgr(.lu) entered" },
{ 704852031, "[zlc]MgrThread: sleeping until time .lu" },
{ 704852032, "zlc_Init() returning .ld" },
{ 0, NULL }
};

#define array_length(x) (sizeof x / sizeof x[0])

value_string_ext dce_error_vals_ext = VALUE_STRING_EXT_INIT(dce_error_vals);
