/* packet-q708.c
 * Routine and tables for analyzing an ISPC according to Q.708
 * Copyright 2010, Gerasimos Dimitriadis <dimeg [AT] intracom.gr>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"

#include <glib.h>
#include <epan/packet.h>

#include "packet-q708.h"

void proto_register_q708(void);

static int proto_q708 = -1;
static int hf_q708_sanc = -1;
static int hf_q708_ispc_name = -1;
static int hf_q708_ispc_operator_name = -1;

/*
 * List of Signalling Area/Network Codes (SANC)
 * Annex to the ITU Operational Bulletin No. 940 - 15.IX.2009
 * including amendments up to ITU Operational Bulletin No. 960 - 15.VII.2010
 *
 * Mapping of SANC to Geographical Area or Signalling Network
 */
static const value_string q708_sanc_areas[] = {
	{  512, "Liechtenstein (Principality of)" },
	{  513, "Italy" },
	{  514, "Netherlands (Kingdom of the)" },
	{  515, "Italy" },
	{  516, "Greece" },
	{  517, "Greece" },
	{  518, "Netherlands (Kingdom of the)" },
	{  519, "Netherlands (Kingdom of the)" },
	{  520, "Netherlands (Kingdom of the)" },
	{  521, "Netherlands (Kingdom of the)" },
	{  522, "Netherlands (Kingdom of the)" },
	{  523, "Netherlands (Kingdom of the)" },
	{  524, "Belgium" },
	{  525, "Belgium" },
	{  526, "Belgium" },
	{  527, "Belgium" },
	{  528, "France" },
	{  529, "France" },
	{  530, "France" },
	{  531, "France" },
	{  532, "France" },
	{  533, "France" },
	{  534, "France" },
	{  535, "France" },
	{  536, "Monaco (Principality of)" },
	{  537, "Austria" },
	{  538, "Austria" },
	{  539, "Spain" },
	{  540, "Spain" },
	{  541, "Spain" },
	{  542, "Spain" },
	{  543, "Spain" },
	{  544, "Hungary (Republic of)" },
	{  545, "Germany (Federal Republic of)" },
	{  546, "Germany (Federal Republic of)" },
	{  547, "Germany (Federal Republic of)" },
	{  548, "Germany (Federal Republic of)" },
	{  549, "Germany (Federal Republic of)" },
	{  550, "Germany (Federal Republic of)" },
	{  551, "Germany (Federal Republic of)" },
	{  552, "Serbia (Republic of)" },
	{  553, "Italy" },
	{  554, "Italy" },
	{  555, "Italy" },
	{  556, "Italy" },
	{  557, "Italy" },
	{  558, "Italy" },
	{  559, "Italy" },
	{  560, "Italy" },
	{  561, "Italy" },
	{  562, "Italy" },
	{  563, "Italy" },
	{  564, "Romania" },
	{  565, "Switzerland (Confederation of)" },
	{  566, "Switzerland (Confederation of)" },
	{  567, "Switzerland (Confederation of)" },
	{  568, "Switzerland (Confederation of)" },
	{  569, "Switzerland (Confederation of)" },
	{  570, "Switzerland (Confederation of)" },
	{  571, "Switzerland (Confederation of)" },
	{  572, "Czech Republic" },
	{  573, "Switzerland (Confederation of)" },
	{  574, "Switzerland (Confederation of)" },
	{  575, "Switzerland (Confederation of)" },
	{  576, "Austria" },
	{  577, "Austria" },
	{  578, "Austria" },
	{  579, "Austria" },
	{  580, "United Kingdom of Great Britain and Northern Ireland" },
	{  581, "United Kingdom of Great Britain and Northern Ireland" },
	{  582, "United Kingdom of Great Britain and Northern Ireland" },
	{  583, "United Kingdom of Great Britain and Northern Ireland" },
	{  584, "United Kingdom of Great Britain and Northern Ireland" },
	{  585, "United Kingdom of Great Britain and Northern Ireland" },
	{  586, "United Kingdom of Great Britain and Northern Ireland" },
	{  587, "United Kingdom of Great Britain and Northern Ireland" },
	{  588, "Denmark" },
	{  589, "Denmark" },
	{  590, "Denmark" },
	{  591, "Denmark" },
	{  592, "Sweden" },
	{  593, "Sweden" },
	{  594, "Sweden" },
	{  595, "Sweden" },
	{  596, "Norway" },
	{  597, "Norway" },
	{  598, "Norway" },
	{  599, "Norway" },
	{  600, "Finland" },
	{  601, "Finland" },
	{  602, "Finland" },
	{  603, "Finland" },
	{  604, "Estonia (Republic of)" },
	{  605, "Italy" },
	{  606, "Italy" },
	{  607, "Italy" },
	{  608, "Latvia (Republic of)" },
	{  609, "Belgium" },
	{  610, "Belgium" },
	{  611, "Belgium" },
	{  612, "Russian Federation" },
	{  613, "Russian Federation" },
	{  614, "Russian Federation" },
	{  615, "Russian Federation" },
	{  616, "Russian Federation" },
	{  617, "Russian Federation" },
	{  618, "Russian Federation" },
	{  619, "Russian Federation" },
	{  620, "Russian Federation" },
	{  621, "Russian Federation" },
	{  622, "Russian Federation" },
	{  623, "Russian Federation" },
	{  624, "Russian Federation" },
	{  625, "Russian Federation" },
	{  626, "Russian Federation" },
	{  627, "Russian Federation" },
	{  628, "Russian Federation" },
	{  629, "Russian Federation" },
	{  630, "Russian Federation" },
	{  631, "Russian Federation" },
	{  632, "Poland (Republic of)" },
	{  633, "Germany (Federal Republic of)" },
	{  634, "Germany (Federal Republic of)" },
	{  635, "Germany (Federal Republic of)" },
	{  636, "Germany (Federal Republic of)" },
	{  637, "Germany (Federal Republic of)" },
	{  638, "Germany (Federal Republic of)" },
	{  639, "Germany (Federal Republic of)" },
	{  640, "Germany (Federal Republic of)" },
	{  641, "Germany (Federal Republic of)" },
	{  642, "Germany (Federal Republic of)" },
	{  643, "Germany (Federal Republic of)" },
	{  644, "Gibraltar" },
	{  645, "Austria" },
	{  646, "Poland (Republic of)" },
	{  647, "Luxembourg" },
	{  648, "Portugal" },
	{  649, "Portugal" },
	{  650, "Portugal" },
	{  651, "Portugal" },
	{  652, "Luxembourg" },
	{  653, "Luxembourg" },
	{  654, "Netherlands (Kingdom of the)" },
	{  655, "Netherlands (Kingdom of the)" },
	{  656, "Ireland" },
	{  657, "Ireland" },
	{  658, "Ireland" },
	{  659, "United Kingdom of Great Britain and Northern Ireland" },
	{  660, "Iceland" },
	{  661, "France" },
	{  662, "France" },
	{  663, "France" },
	{  664, "Albania (Republic of)" },
	{  665, "United Kingdom of Great Britain and Northern Ireland" },
	{  666, "United Kingdom of Great Britain and Northern Ireland" },
	{  667, "United Kingdom of Great Britain and Northern Ireland" },
	{  668, "Malta" },
	{  669, "Italy" },
	{  670, "Italy" },
	{  671, "Italy" },
	{  672, "Cyprus (Republic of)" },
	{  673, "United Kingdom of Great Britain and Northern Ireland" },
	{  674, "United Kingdom of Great Britain and Northern Ireland" },
	{  675, "United Kingdom of Great Britain and Northern Ireland" },
	{  676, "United Kingdom of Great Britain and Northern Ireland" },
	{  677, "United Kingdom of Great Britain and Northern Ireland" },
	{  678, "United Kingdom of Great Britain and Northern Ireland" },
	{  679, "United Kingdom of Great Britain and Northern Ireland" },
	{  680, "Bulgaria (Republic of)" },
	{  681, "United Kingdom of Great Britain and Northern Ireland" },
	{  682, "United Kingdom of Great Britain and Northern Ireland" },
	{  683, "Turkey" },
	{  684, "Turkey" },
	{  685, "Turkey" },
	{  686, "United Kingdom of Great Britain and Northern Ireland" },
	{  687, "United Kingdom of Great Britain and Northern Ireland" },
	{  688, "United Kingdom of Great Britain and Northern Ireland" },
	{  689, "United Kingdom of Great Britain and Northern Ireland" },
	{  690, "United Kingdom of Great Britain and Northern Ireland" },
	{  691, "United Kingdom of Great Britain and Northern Ireland" },
	{  692, "Croatia (Republic of)" },
	{  693, "Italy" },
	{  694, "Slovenia (Republic of)" },
	{  695, "Italy" },
	{  696, "San Marino (Republic of)" },
	{  697, "United Kingdom of Great Britain and Northern Ireland" },
	{  698, "United Kingdom of Great Britain and Northern Ireland" },
	{  699, "United Kingdom of Great Britain and Northern Ireland" },
	{  700, "United Kingdom of Great Britain and Northern Ireland" },
	{  701, "United Kingdom of Great Britain and Northern Ireland" },
	{  702, "United Kingdom of Great Britain and Northern Ireland" },
	{  703, "United Kingdom of Great Britain and Northern Ireland" },
	{  704, "Sweden" },
	{  705, "Sweden" },
	{  706, "Sweden" },
	{  707, "Sweden" },
	{  708, "Andorra (Principality of)" },
	{  709, "Andorra (Principality of)" },
	{  710, "Netherlands (Kingdom of the)" },
	{  711, "Estonia (Republic of)" },
	{  712, "Armenia (Republic of)" },
	{  713, "France" },
	{  714, "France" },
	{  715, "France" },
	{  716, "Belarus (Republic of)" },
	{  717, "Sweden" },
	{  718, "Greece" },
	{  719, "Italy" },
	{  720, "Georgia" },
	{  721, "United Kingdom of Great Britain and Northern Ireland" },
	{  722, "United Kingdom of Great Britain and Northern Ireland" },
	{  723, "United Kingdom of Great Britain and Northern Ireland" },
	{  724, "Hungary (Republic of)" },
	{  725, "Georgia" },
	{  726, "Ukraine" },
	{  727, "Italy" },
	{  728, "Italy" },
	{  729, "Denmark" },
	{  730, "Bosnia and Herzegovina" },
	{  731, "Bosnia and Herzegovina" },
	{  732, "The Former Yugoslav Republic of Macedonia" },
	{  733, "France" },
	{  734, "Germany (Federal Republic of)" },
	{  735, "Portugal" },
	{  736, "Moldova (Republic of)" },
	{  737, "Germany (Federal Republic of)" },
	{  738, "Germany (Federal Republic of)" },
	{  739, "Romania" },
	{  740, "Czech Republic" },
	{  741, "Czech Republic" },
	{  742, "Czech Republic" },
	{  743, "Czech Republic" },
	{  744, "Slovak Republic" },
	{  745, "Slovak Republic" },
	{  746, "Slovak Republic" },
	{  747, "Slovak Republic" },
	{  748, "Lithuania (Republic of)" },
	{  749, "Spain" },
	{  750, "Spain" },
	{  751, "Spain" },
	{  752, "Spain" },
	{  753, "Spain" },
	{  754, "Germany (Federal Republic of)" },
	{  755, "Germany (Federal Republic of)" },
	{  756, "Germany (Federal Republic of)" },
	{  757, "Germany (Federal Republic of)" },
	{  758, "Germany (Federal Republic of)" },
	{  759, "Germany (Federal Republic of)" },
	{  760, "Germany (Federal Republic of)" },
	{  761, "Germany (Federal Republic of)" },
	{  762, "Germany (Federal Republic of)" },
	{  763, "Germany (Federal Republic of)" },
	{  764, "Germany (Federal Republic of)" },
	{  765, "Netherlands (Kingdom of the)" },
	{  766, "Finland" },
	{  767, "Finland" },

	{  768, "Unassigned" },
	{  769, "Unassigned" },
	{  770, "Unassigned" },
	{  771, "Unassigned" },

	{  772, "Canada" },
	{  773, "Canada" },
	{  774, "Canada" },
	{  775, "Canada" },
	{  776, "Canada" },
	{  777, "Canada" },
	{  778, "Canada" },
	{  779, "Canada" },
	{  780, "Canada" },
	{  781, "Canada" },

	{  782, "Unassigned" },
	{  783, "Unassigned" },

	{  784, "Saint Pierre and Miquelon (Collectivite territoriale de la Republique francaise)" },

	{  785, "Unassigned" },

	{  786, "Greenland (Denmark)" },

	{  787, "Unassigned" },

	{  788, "United States of America" },
	{  789, "United States of America" },
	{  790, "United States of America" },
	{  791, "United States of America" },
	{  792, "United States of America" },
	{  793, "United States of America" },
	{  794, "United States of America" },
	{  795, "United States of America" },
	{  796, "United States of America" },
	{  797, "United States of America" },
	{  798, "United States of America" },
	{  799, "United States of America" },
	{  800, "United States of America" },
	{  801, "United States of America" },
	{  802, "United States of America" },
	{  803, "United States of America" },
	{  804, "United States of America" },
	{  805, "United States of America" },
	{  806, "United States of America" },
	{  807, "United States of America" },
	{  808, "United States of America" },
	{  809, "United States of America" },
	{  810, "United States of America" },
	{  811, "United States of America" },
	{  812, "United States of America" },
	{  813, "United States of America" },
	{  814, "United States of America" },
	{  815, "United States of America" },
	{  816, "United States of America" },
	{  817, "United States of America" },
	{  818, "United States of America" },
	{  819, "United States of America" },
	{  820, "United States of America" },
	{  821, "United States of America" },
	{  822, "United States of America" },
	{  823, "United States of America" },
	{  824, "United States of America" },
	{  825, "United States of America" },
	{  826, "United States of America" },
	{  827, "United States of America" },
	{  828, "Puerto Rico" },

	{  829, "Unassigned" },
	{  830, "Unassigned" },
	{  831, "Unassigned" },

	{  832, "United States Virgin Islands" },

	{  833, "Unassigned" },
	{  834, "Unassigned" },
	{  835, "Unassigned" },

	{  836, "Mexico" },
	{  837, "Mexico" },
	{  838, "Mexico" },
	{  839, "Mexico" },
	{  840, "Mexico" },
	{  841, "Mexico" },
	{  842, "Mexico" },
	{  843, "Mexico" },
	{  844, "Jamaica" },
	{  845, "Jamaica" },
	{  846, "Jamaica" },
	{  847, "Jamaica" },

	{  848, "Unassigned" },
	{  849, "Unassigned" },
	{  850, "Unassigned" },
	{  851, "Unassigned" },

	{  852, "Barbados" },
	{  853, "Barbados" },
	{  854, "Barbados" },
	{  855, "Unassigned" },
	{  856, "Antigua and Barbuda" },
	{  857, "Antigua and Barbuda" },
	{  858, "Unassigned" },
	{  859, "Unassigned" },
	{  860, "Cayman Islands" },
	{  861, "Cayman Islands" },
	{  862, "Unassigned" },
	{  863, "Unassigned" },
	{  864, "British Virgin Islands" },
	{  865, "British Virgin Islands" },
	{  866, "Unassigned" },
	{  867, "Unassigned" },
	{  868, "Bermuda" },
	{  869, "Unassigned" },
	{  870, "Unassigned" },
	{  871, "Unassigned" },
	{  872, "Grenada" },
	{  873, "Unassigned" },
	{  874, "Unassigned" },
	{  875, "Unassigned" },
	{  876, "Montserrat" },
	{  877, "Unassigned" },
	{  878, "Unassigned" },
	{  879, "Unassigned" },
	{  880, "Saint Kitts and Nevis" },
	{  881, "Unassigned" },
	{  882, "Unassigned" },
	{  883, "Unassigned" },
	{  884, "Saint Lucia" },
	{  885, "Unassigned" },
	{  886, "Unassigned" },
	{  887, "Unassigned" },
	{  888, "Saint Vincent and the Grenadines" },
	{  889, "Unassigned" },
	{  890, "Unassigned" },
	{  891, "Unassigned" },
	{  892, "Netherlands Antilles" },
	{  893, "Netherlands Antilles" },
	{  894, "Netherlands Antilles" },
	{  895, "Unassigned" },
	{  896, "Bahamas (Commonwealth of the)" },
	{  897, "Unassigned" },
	{  898, "Unassigned" },
	{  899, "Unassigned" },
	{  900, "Dominica (Commonwealth of)" },
	{  901, "Unassigned" },
	{  902, "Unassigned" },
	{  903, "Unassigned" },
	{  904, "Cuba" },
	{  905, "Cuba" },
	{  906, "Unassigned" },
	{  907, "Unassigned" },
	{  908, "Dominican Republic" },
	{  909, "Dominican Republic" },
	{  910, "Unassigned" },
	{  911, "Unassigned" },
	{  912, "Haiti (Republic of)" },
	{  913, "Unassigned" },
	{  914, "Unassigned" },
	{  915, "Unassigned" },
	{  916, "Trinidad and Tobago" },
	{  917, "Trinidad and Tobago" },
	{  918, "Trinidad and Tobago" },
	{  919, "Unassigned" },
	{  920, "Turks and Caicos Islands" },
	{  921, "Turks and Caicos Islands" },
	{  922, "Turks and Caicos Islands" },
	{  923, "Unassigned" },
	{  924, "Guadeloupe (French Department of)" },
	{  925, "Unassigned" },
	{  926, "Unassigned" },
	{  927, "Unassigned" },
	{  928, "Martinique (French Department of)" },
	{  929, "Unassigned" },
	{  930, "Unassigned" },
	{  931, "Unassigned" },
	{  932, "Aruba" },
	{  933, "Unassigned" },
	{  934, "Unassigned" },
	{  935, "Unassigned" },
	{  936, "Anguilla" },
	{  937, "Anguilla" },
	{  938, "Unassigned" },
	{  939, "Unassigned" },
	{  940, "Mexico" },
	{  941, "Mexico" },
	{  942, "Mexico" },
	{  943, "Mexico" },
	{  944, "Mexico" },
	{  945, "Mexico" },
	{  946, "Mexico" },
	{  947, "Faroe Islands" },
	{  948, "United States of America" },
	{  949, "United States of America" },
	{  950, "United States of America" },
	{  951, "United States of America" },
	{  952, "United States of America" },
	{  953, "United States of America" },
	{  954, "United States of America" },
	{  955, "United States of America" },
	{  956, "United States of America" },
	{  957, "United States of America" },
	{  958, "United States of America" },
	{  959, "United States of America" },
	{  960, "United States of America" },
	{  961, "United States of America" },
	{  962, "United States of America" },
	{  963, "United States of America" },
	{  964, "United States of America" },
	{  965, "United States of America" },
	{  966, "United States of America" },
	{  967, "United States of America" },
	{  968, "United States of America" },
	{  969, "United States of America" },
	{  970, "United States of America" },
	{  971, "United States of America" },
	{  972, "United States of America" },
	{  973, "Unassigned" },
	{  974, "Unassigned" },
	{  975, "Unassigned" },
	{  976, "Unassigned" },
	{  977, "Unassigned" },

	{  978, "Saint Helena" },
	{  979, "Unassigned" },
	{  980, "Unassigned" },
	{  981, "Unassigned" },
	{  982, "Unassigned" },
	{  983, "Mexico" },
	{  984, "Unassigned" },
	{  985, "Unassigned" },
	{  986, "Unassigned" },
	{  987, "Unassigned" },
	{  988, "Unassigned" },
	{  989, "Unassigned" },
	{  990, "Unassigned" },
	{  991, "Unassigned" },
	{  992, "Unassigned" },
	{  993, "Unassigned" },
	{  994, "Unassigned" },
	{  995, "Unassigned" },
	{  996, "Unassigned" },
	{  997, "Unassigned" },
	{  998, "Unassigned" },
	{  999, "Unassigned" },
	{  1000, "Unassigned" },
	{  1001, "Albania (Republic of)" },
	{  1002, "Latvia (Republic of)" },
	{  1003, "United Kingdom of Great Britain and Northern Ireland" },
	{  1004, "United Kingdom of Great Britain and Northern Ireland" },
	{  1005, "United Kingdom of Great Britain and Northern Ireland" },
	{  1006, "Romania" },
	{  1007, "Bosnia and Herzegovina" },
	{  1008, "Cambodia (Kingdom of)" },
	{  1009, "Montenegro (Republic of)" },
	{  1010, "Spain" },
	{  1011, "Germany (Federal Republic of)" },
	{  1012, "Estonia (Republic of)" },
	{  1013, "Croatia (Republic of)" },
	{  1014, "Georgia" },
	{  1015, "Turkey" },
	{  1016, "Cyprus (Republic of)" },
	{  1017, "Portugal" },
	{  1018, "Romania" },
	{  1019, "Poland (Republic of)" },
	{  1020, "Germany (Federal Republic of)" },
	{  1021, "Poland (Republic of)" },
	{  1022, "Germany (Federal Republic of)" },
	{  1023, "Germany (Federal Republic of)" },
	{  1024, "Unassigned" },
	{  1025, "Unassigned" },
	{  1026, "Unassigned" },
	{  1027, "Israel (State of)" },
	{  1028, "Israel (State of)" },
	{  1029, "India (Republic of)" },
	{  1030, "India (Republic of)" },
	{  1031, "India (Republic of)" },
	{  1032, "India (Republic of)" },
	{  1033, "India (Republic of)" },
	{  1034, "India (Republic of)" },
	{  1035, "India (Republic of)" },
	{  1036, "India (Republic of)" },
	{  1037, "India (Republic of)" },
	{  1038, "India (Republic of)" },
	{  1039, "India (Republic of)" },
	{  1040, "India (Republic of)" },
	{  1041, "India (Republic of)" },
	{  1042, "Unassigned" },
	{  1043, "Pakistan (Islamic Republic of)" },
	{  1044, "Pakistan (Islamic Republic of)" },
	{  1045, "Pakistan (Islamic Republic of)" },
	{  1046, "Pakistan (Islamic Republic of)" },
	{  1047, "Pakistan (Islamic Republic of)" },
	{  1048, "Afghanistan" },
	{  1049, "Afghanistan" },
	{  1050, "Sri Lanka (Democratic Socialist Republic of)" },
	{  1051, "Sri Lanka (Democratic Socialist Republic of)" },
	{  1052, "Myanmar (Union of)" },
	{  1053, "Unassigned" },
	{  1054, "Lebanon" },
	{  1055, "Jordan (Hashemite Kingdom of)" },
	{  1056, "Jordan (Hashemite Kingdom of)" },
	{  1057, "Jordan (Hashemite Kingdom of)" },
	{  1058, "Syrian Arab Republic" },
	{  1059, "Unassigned" },
	{  1060, "Iraq (Republic of)" },
	{  1061, "Unassigned" },
	{  1062, "Kuwait (State of)" },
	{  1063, "Saudi Arabia (Kingdom of)" },
	{  1064, "Saudi Arabia (Kingdom of)" },
	{  1065, "Saudi Arabia (Kingdom of)" },
	{  1066, "Yemen (Republic of)" },
	{  1067, "Saudi Arabia (Kingdom of)" },
	{  1068, "Oman (Sultanate of)" },
	{  1069, "Oman (Sultanate of)" },
	{  1070, "Yemen (Republic of)" },
	{  1071, "Unassigned" },
	{  1072, "United Arab Emirates" },
	{  1073, "United Arab Emirates" },
	{  1074, "Israel (State of)" },
	{  1075, "Israel (State of)" },
	{  1076, "Bahrain (Kingdom of)" },
	{  1077, "Bahrain (Kingdom of)" },
	{  1078, "Qatar (State of)" },
	{  1079, "Qatar (State of)" },
	{  1080, "Mongolia" },
	{  1081, "Unassigned" },
	{  1082, "Nepal (Federal Democratic Republic of)" },
	{  1083, "Nepal (Federal Democratic Republic of)" },
	{  1084, "United Arab Emirates" },
	{  1085, "United Arab Emirates" },
	{  1086, "United Arab Emirates" },
	{  1087, "Unassigned" },
	{  1088, "Iran (Islamic Republic of)" },
	{  1089, "Iran (Islamic Republic of)" },
	{  1090, "Unassigned" },
	{  1091, "Unassigned" },
	{  1092, "Unassigned" },
	{  1093, "Unassigned" },
	{  1094, "Azerbaijani Republic" },
	{  1095, "Azerbaijani Republic" },
	{  1096, "Bhutan (Kingdom of)" },
	{  1097, "Unassigned" },
	{  1098, "Kazakhstan (Republic of)" },
	{  1099, "Kazakhstan (Republic of)" },
	{  1100, "Kazakhstan (Republic of)" },
	{  1101, "Kazakhstan (Republic of)" },
	{  1102, "Kyrgyz Republic" },
	{  1103, "Kyrgyz Republic" },
	{  1104, "Japan" },
	{  1105, "Japan" },
	{  1106, "Japan" },
	{  1107, "Japan" },
	{  1108, "Japan" },
	{  1109, "Japan" },
	{  1110, "Japan" },
	{  1111, "Unassigned" },
	{  1112, "Bahrain (Kingdom of)" },
	{  1113, "Unassigned" },
	{  1114, "Unassigned" },
	{  1115, "Unassigned" },
	{  1116, "Unassigned" },
	{  1117, "Unassigned" },
	{  1118, "Unassigned" },
	{  1119, "Unassigned" },
	{  1120, "Unassigned" },
	{  1121, "Unassigned" },
	{  1122, "Unassigned" },
	{  1123, "Unassigned" },
	{  1124, "Korea (Republic of)" },
	{  1125, "Korea (Republic of)" },
	{  1126, "Korea (Republic of)" },
	{  1127, "Viet Nam (Socialist Republic of)" },
	{  1128, "Viet Nam (Socialist Republic of)" },
	{  1129, "Hong Kong, China" },
	{  1130, "Hong Kong, China" },
	{  1131, "Hong Kong, China" },
	{  1132, "Hong Kong, China" },
	{  1133, "Hong Kong, China" },
	{  1134, "Macao, China" },
	{  1135, "Hong Kong, China" },
	{  1136, "Cambodia (Kingdom of)" },
	{  1137, "Cambodia (Kingdom of)" },
	{  1138, "Lao People's Democratic Republic" },
	{  1139, "Unassigned" },
	{  1140, "Unassigned" },
	{  1141, "Unassigned" },
	{  1142, "Unassigned" },
	{  1143, "Macao, China" },
	{  1144, "China (People's Republic of)" },
	{  1145, "China (People's Republic of)" },
	{  1146, "China (People's Republic of)" },
	{  1147, "China (People's Republic of)" },
	{  1148, "China (People's Republic of)" },
	{  1149, "China (People's Republic of)" },
	{  1150, "China (People's Republic of)" },
	{  1151, "China (People's Republic of)" },
	{  1152, "China (People's Republic of)" },
	{  1153, "Unassigned" },
	{  1154, "Unassigned" },
	{  1155, "Unassigned" },
	{  1156, "Unassigned" },
	{  1157, "Unassigned" },
	{  1158, "Unassigned" },
	{  1159, "Democratic People's Republic of Korea" },
	{  1160, "Afghanistan" },
	{  1161, "Afghanistan" },
	{  1162, "Unassigned" },
	{  1163, "Unassigned" },
	{  1164, "Bangladesh (People's Republic of)" },
	{  1165, "Bangladesh (People's Republic of)" },
	{  1166, "Bangladesh (People's Republic of)" },
	{  1167, "Bangladesh (People's Republic of)" },
	{  1168, "Maldives (Republic of)" },
	{  1169, "Korea (Republic of)" },
	{  1170, "Unassigned" },
	{  1171, "Korea (Republic of)" },
	{  1172, "Korea (Republic of)" },
	{  1173, "Korea (Republic of)" },
	{  1174, "Korea (Republic of)" },
	{  1175, "Korea (Republic of)" },
	{  1176, "Korea (Republic of)" },
	{  1177, "Korea (Republic of)" },
	{  1178, "Korea (Republic of)" },
	{  1179, "Unassigned" },
	{  1180, "Unassigned" },
	{  1181, "Tajikistan (Republic of)" },
	{  1182, "Tajikistan (Republic of)" },
	{  1183, "Tajikistan (Republic of)" },
	{  1184, "Turkmenistan" },
	{  1185, "Unassigned" },
	{  1186, "Unassigned" },
	{  1187, "Unassigned" },
	{  1188, "Uzbekistan (Republic of)" },
	{  1189, "Uzbekistan (Republic of)" },
	{  1190, "Unassigned" },
	{  1191, "Kyrgyz Republic" },
	{  1192, "Unassigned" },
	{  1193, "Unassigned" },
	{  1194, "Taiwan, China" },
	{  1195, "Taiwan, China" },
	{  1196, "Taiwan, China" },
	{  1197, "Taiwan, China" },
	{  1198, "Taiwan, China" },
	{  1199, "Reserved" },
	{  1200, "Hong Kong, China" },
	{  1201, "Hong Kong, China" },
	{  1202, "Hong Kong, China" },
	{  1203, "Hong Kong, China" },
	{  1204, "Hong Kong, China" },
	{  1205, "Hong Kong, China" },
	{  1206, "Hong Kong, China" },
	{  1207, "Unassigned" },
	{  1208, "Unassigned" },
	{  1209, "Unassigned" },
	{  1210, "Unassigned" },
	{  1211, "Unassigned" },
	{  1212, "Unassigned" },
	{  1213, "Unassigned" },
	{  1214, "Sri Lanka (Democratic Socialist Republic of)" },
	{  1215, "Sri Lanka (Democratic Socialist Republic of)" },
	{  1216, "Unassigned" },
	{  1217, "Unassigned" },
	{  1218, "Unassigned" },
	{  1219, "Jordan (Hashemite Kingdom of)" },
	{  1220, "Unassigned" },
	{  1221, "Unassigned" },
	{  1222, "Unassigned" },
	{  1223, "Unassigned" },
	{  1224, "Kuwait (State of)" },
	{  1225, "Unassigned" },
	{  1226, "Unassigned" },
	{  1227, "Unassigned" },
	{  1228, "Unassigned" },
	{  1229, "Viet Nam (Socialist Republic of)" },
	{  1230, "Unassigned" },
	{  1231, "Unassigned" },
	{  1232, "Unassigned" },
	{  1233, "Unassigned" },
	{  1234, "Unassigned" },
	{  1235, "Maldives (Republic of)" },
	{  1236, "Unassigned" },
	{  1237, "Unassigned" },
	{  1238, "Unassigned" },
	{  1239, "Unassigned" },
	{  1240, "Unassigned" },
	{  1241, "Unassigned" },
	{  1242, "Unassigned" },
	{  1243, "Unassigned" },
	{  1244, "Unassigned" },
	{  1245, "Unassigned" },
	{  1246, "Unassigned" },
	{  1247, "Unassigned" },
	{  1248, "Unassigned" },
	{  1249, "Unassigned" },
	{  1250, "Unassigned" },
	{  1251, "Unassigned" },
	{  1252, "Unassigned" },
	{  1253, "Unassigned" },
	{  1254, "Unassigned" },
	{  1255, "Unassigned" },
	{  1256, "Unassigned" },
	{  1257, "Armenia (Republic of)" },
	{  1258, "Greece" },
	{  1259, "Spain" },
	{  1260, "Lithuania (Republic of)" },
	{  1261, "Latvia (Republic of)" },
	{  1262, "Netherlands (Kingdom of the)" },
	{  1263, "United Kingdom of Great Britain and Northern Ireland" },
	{  1264, "United Kingdom of Great Britain and Northern Ireland" },
	{  1265, "Ireland" },
	{  1266, "Ukraine" },
	{  1267, "Hungary (Republic of)" },
	{  1268, "Germany (Federal Republic of)" },
	{  1269, "Greece" },
	{  1270, "Germany (Federal Republic of)" },
	{  1271, "United Kingdom of Great Britain and Northern Ireland" },
	{  1272, "Serbia (Republic of)" },
	{  1273, "Croatia (Republic of)" },
	{  1274, "Poland (Republic of)" },
	{  1275, "Slovak Republic" },
	{  1276, "Romania" },
	{  1277, "United Kingdom of Great Britain and Northern Ireland" },
	{  1278, "United Kingdom of Great Britain and Northern Ireland" },
	{  1279, "United Kingdom of Great Britain and Northern Ireland" },
	{  1280, "Unassigned" },
	{  1281, "Malaysia" },
	{  1282, "Malaysia" },
	{  1283, "Malaysia" },
	{  1284, "Malaysia" },
	{  1285, "Malaysia" },
	{  1286, "Malaysia" },
	{  1287, "Malaysia" },
	{  1288, "Malaysia" },
	{  1289, "Malaysia" },
	{  1290, "Australia" },
	{  1291, "Australia" },
	{  1292, "Australia" },
	{  1293, "Australia" },
	{  1294, "Australia" },
	{  1295, "Australia" },
	{  1296, "Australia" },
	{  1297, "Australia" },
	{  1298, "Australia" },
	{  1299, "Australia" },
	{  1300, "Indonesia (Republic of)" },
	{  1301, "Indonesia (Republic of)" },
	{  1302, "Indonesia (Republic of)" },
	{  1303, "Indonesia (Republic of)" },
	{  1304, "Indonesia (Republic of)" },
	{  1305, "Indonesia (Republic of)" },
	{  1306, "Unassigned" },
	{  1307, "Unassigned" },
	{  1308, "Unassigned" },
	{  1309, "Unassigned" },
	{  1310, "Philippines (Republic of the)" },
	{  1311, "Philippines (Republic of the)" },
	{  1312, "Philippines (Republic of the)" },
	{  1313, "Philippines (Republic of the)" },
	{  1314, "Philippines (Republic of the)" },
	{  1315, "Philippines (Republic of the)" },
	{  1316, "Philippines (Republic of the)" },
	{  1317, "Philippines (Republic of the)" },
	{  1318, "Philippines (Republic of the)" },
	{  1319, "Unassigned" },
	{  1320, "Thailand" },
	{  1321, "Thailand" },
	{  1322, "Thailand" },
	{  1323, "Thailand" },
	{  1324, "Thailand" },
	{  1325, "Singapore (Republic of)" },
	{  1326, "Singapore (Republic of)" },
	{  1327, "Singapore (Republic of)" },
	{  1328, "Singapore (Republic of)" },
	{  1329, "Singapore (Republic of)" },
	{  1330, "Singapore (Republic of)" },
	{  1331, "Singapore (Republic of)" },
	{  1332, "Singapore (Republic of)" },
	{  1333, "Singapore (Republic of)" },
	{  1334, "Singapore (Republic of)" },
	{  1335, "Singapore (Republic of)" },
	{  1336, "Brunei Darussalam" },
	{  1337, "Brunei Darussalam" },
	{  1338, "Unassigned" },
	{  1339, "Unassigned" },
	{  1340, "New Zealand" },
	{  1341, "New Zealand" },
	{  1342, "New Zealand" },
	{  1343, "New Zealand" },
	{  1344, "Unassigned" },
	{  1345, "New Zealand" },
	{  1346, "Unassigned" },
	{  1347, "New Zealand" },
	{  1348, "Unassigned" },
	{  1349, "Unassigned" },
	{  1350, "Guam" },
	{  1351, "Unassigned" },
	{  1352, "Nauru (Republic of)" },
	{  1353, "Unassigned" },
	{  1354, "Papua New Guinea" },
	{  1355, "Papua New Guinea" },
	{  1356, "Unassigned" },
	{  1357, "Unassigned" },
	{  1358, "Tonga (Kingdom of)" },
	{  1359, "Unassigned" },
	{  1360, "Solomon Islands" },
	{  1361, "Unassigned" },
	{  1362, "Vanuatu (Republic of)" },
	{  1363, "Unassigned" },
	{  1364, "Fiji (Republic of)" },
	{  1365, "Fiji (Republic of)" },
	{  1366, "Wallis and Futuna (Territoire francais d'outre-mer)" },
	{  1367, "Unassigned" },
	{  1368, "American Samoa" },
	{  1369, "Unassigned" },
	{  1370, "Niue" },
	{  1371, "Unassigned" },
	{  1372, "New Caledonia (Territoire francais d'outre-mer)" },
	{  1373, "Unassigned" },
	{  1374, "French Polynesia (Territoire francais d'outre-mer)" },
	{  1375, "Unassigned" },
	{  1376, "Cook Islands" },
	{  1377, "Unassigned" },
	{  1378, "Samoa (Independent State of)" },
	{  1379, "Unassigned" },
	{  1380, "Kiribati (Republic of)" },
	{  1381, "Unassigned" },
	{  1382, "Tuvalu" },
	{  1383, "Unassigned" },
	{  1384, "Unassigned" },
	{  1385, "Marshall Islands (Republic of the)" },
	{  1386, "Unassigned" },
	{  1387, "Micronesia (Federated States of)" },
	{  1388, "Unassigned" },
	{  1389, "Unassigned" },
	{  1390, "Palau (Republic of)" },
	{  1391, "Unassigned" },
	{  1392, "Unassigned" },
	{  1393, "Northern Mariana Islands (Commonwealth of the)" },
	{  1394, "Unassigned" },
	{  1395, "Australia" },
	{  1396, "Australia" },
	{  1397, "Australia" },
	{  1398, "Australia" },
	{  1399, "Australia" },
	{  1400, "Australia" },
	{  1401, "Australia" },
	{  1402, "Unassigned" },
	{  1403, "Unassigned" },
	{  1404, "Unassigned" },
	{  1405, "Unassigned" },
	{  1406, "Unassigned" },
	{  1407, "Unassigned" },
	{  1408, "Unassigned" },
	{  1409, "Unassigned" },
	{  1410, "Democratic Republic of Timor-Leste" },
	{  1411, "Unassigned" },
	{  1412, "Unassigned" },
	{  1413, "Unassigned" },
	{  1414, "Unassigned" },
	{  1415, "Unassigned" },
	{  1416, "Unassigned" },
	{  1417, "Unassigned" },
	{  1418, "Unassigned" },
	{  1419, "Unassigned" },
	{  1420, "Singapore (Republic of)" },
	{  1421, "Singapore (Republic of)" },

	{  1422, "Unassigned" },
	{  1423, "Unassigned" },
	{  1424, "Unassigned" },
	{  1425, "Unassigned" },
	{  1426, "Unassigned" },
	{  1427, "Unassigned" },
	{  1428, "Unassigned" },
	{  1429, "Unassigned" },

	{  1430, "Unassigned" },
	{  1431, "Unassigned" },
	{  1432, "Unassigned" },
	{  1433, "Unassigned" },
	{  1434, "Unassigned" },
	{  1435, "Unassigned" },
	{  1436, "Unassigned" },
	{  1437, "Unassigned" },
	{  1438, "Unassigned" },
	{  1439, "Unassigned" },

	{  1440, "Unassigned" },
	{  1441, "Unassigned" },
	{  1442, "Unassigned" },
	{  1443, "Unassigned" },
	{  1444, "Unassigned" },
	{  1445, "Unassigned" },
	{  1446, "Unassigned" },
	{  1447, "Unassigned" },
	{  1448, "Unassigned" },
	{  1449, "Unassigned" },

	{  1450, "Unassigned" },
	{  1451, "Unassigned" },
	{  1452, "Unassigned" },
	{  1453, "Unassigned" },
	{  1454, "Unassigned" },
	{  1455, "Unassigned" },
	{  1456, "Unassigned" },
	{  1457, "Unassigned" },
	{  1458, "Unassigned" },
	{  1459, "Unassigned" },


	{  1460, "Unassigned" },
	{  1461, "Unassigned" },
	{  1462, "Unassigned" },
	{  1463, "Unassigned" },
	{  1464, "Unassigned" },
	{  1465, "Unassigned" },
	{  1466, "Unassigned" },
	{  1467, "Unassigned" },
	{  1468, "Unassigned" },
	{  1469, "Unassigned" },

	{  1470, "Unassigned" },
	{  1471, "Unassigned" },
	{  1472, "Unassigned" },
	{  1473, "Unassigned" },
	{  1474, "Unassigned" },
	{  1475, "Unassigned" },
	{  1476, "Unassigned" },
	{  1477, "Unassigned" },
	{  1478, "Unassigned" },
	{  1479, "Unassigned" },

	{  1480, "Unassigned" },
	{  1481, "Unassigned" },
	{  1482, "Unassigned" },
	{  1483, "Unassigned" },
	{  1484, "Unassigned" },
	{  1485, "Unassigned" },
	{  1486, "Unassigned" },
	{  1487, "Unassigned" },
	{  1488, "Unassigned" },
	{  1489, "Unassigned" },

	{  1490, "Unassigned" },
	{  1491, "Unassigned" },
	{  1492, "Unassigned" },
	{  1493, "Unassigned" },
	{  1494, "Unassigned" },
	{  1495, "Unassigned" },
	{  1496, "Unassigned" },
	{  1497, "Unassigned" },
	{  1498, "Unassigned" },
	{  1499, "Unassigned" },

	{  1500, "The Former Yugoslav Republic of Macedonia" },
	{  1501, "Unassigned" },
	{  1502, "Unassigned" },
	{  1503, "Unassigned" },
	{  1504, "Unassigned" },
	{  1505, "Unassigned" },
	{  1506, "Unassigned" },
	{  1507, "Unassigned" },
	{  1508, "Unassigned" },
	{  1509, "Unassigned" },
	{  1510, "Unassigned" },
	{  1511, "Unassigned" },
	{  1512, "Unassigned" },
	{  1513, "Georgia" },
	{  1514, "Armenia (Republic of)" },
	{  1515, "Malta" },
	{  1516, "Greece" },
	{  1517, "Cyprus (Republic of)" },
	{  1518, "Montenegro (Republic of)" },
	{  1519, "Netherlands (Kingdom of the)" },
	{  1520, "Germany (Federal Republic of)" },
	{  1521, "Turkey" },
	{  1522, "Romania" },
	{  1523, "United Kingdom of Great Britain and Northern Ireland" },
	{  1524, "Italy" },
	{  1525, "Germany (Federal Republic of)" },
	{  1526, "Switzerland (Confederation of)" },
	{  1527, "Slovenia (Republic of)" },
	{  1528, "United Kingdom of Great Britain and Northern Ireland" },
	{  1529, "Latvia (Republic of)" },
	{  1530, "Slovenia (Republic of)" },
	{  1531, "Germany (Federal Republic of)" },
	{  1532, "Latvia (Republic of)" },
	{  1533, "Poland (Republic of)" },
	{  1534, "Greece" },
	{  1535, "Italy" },
	{  1536, "Unassigned" },
	{  1537, "Unassigned" },
	{  1538, "Unassigned" },
	{  1539, "Egypt (Arab Republic of)" },
	{  1540, "Egypt (Arab Republic of)" },
	{  1541, "Egypt (Arab Republic of)" },
	{  1542, "Algeria (People's Democratic Republic of)" },
	{  1543, "Algeria (People's Democratic Republic of)" },
	{  1544, "Morocco (Kingdom of)" },
	{  1545, "Morocco (Kingdom of)" },
	{  1546, "Tunisia" },
	{  1547, "Unassigned" },
	{  1548, "Libya (Socialist People's Libyan Arab Jamahiriya)" },
	{  1549, "Libya (Socialist People's Libyan Arab Jamahiriya)" },
	{  1550, "Gambia (Republic of the)" },
	{  1551, "Unassigned" },
	{  1552, "Senegal (Republic of)" },
	{  1553, "Unassigned" },
	{  1554, "Mauritania (Islamic Republic of)" },
	{  1555, "Mauritania (Islamic Republic of)" },
	{  1556, "Mali (Republic of)" },
	{  1557, "Guinea (Republic of)" },
	{  1558, "Guinea (Republic of)" },
	{  1559, "Guinea (Republic of)" },
	{  1560, "Cote d'Ivoire (Republic of)" },
	{  1561, "Cote d'Ivoire (Republic of)" },
	{  1562, "Burkina Faso" },
	{  1563, "Unassigned" },
	{  1564, "Niger (Republic of the)" },
	{  1565, "Niger (Republic of the)" },
	{  1566, "Togolese Republic" },
	{  1567, "Unassigned" },
	{  1568, "Benin (Republic of)" },
	{  1569, "Unassigned" },
	{  1570, "Mauritius (Republic of)" },
	{  1571, "Mauritius (Republic of)" },
	{  1572, "Liberia (Republic of)" },
	{  1573, "Unassigned" },
	{  1574, "Sierra Leone" },
	{  1575, "Sierra Leone" },
	{  1576, "Ghana" },
	{  1577, "Nigeria (Federal Republic of)" },
	{  1578, "Nigeria (Federal Republic of)" },
	{  1579, "Nigeria (Federal Republic of)" },
	{  1580, "Chad (Republic of)" },
	{  1581, "Unassigned" },
	{  1582, "Central African Republic" },
	{  1583, "Central African Republic" },
	{  1584, "Cameroon (Republic of)" },
	{  1585, "Cameroon (Republic of)" },
	{  1586, "Cape Verde (Republic of)" },
	{  1587, "Unassigned" },
	{  1588, "Sao Tome and Principe (Democratic Republic of)" },
	{  1589, "Unassigned" },
	{  1590, "Equatorial Guinea (Republic of)" },
	{  1591, "Gabonese Republic" },
	{  1592, "Gabonese Republic" },
	{  1593, "Gabonese Republic" },
	{  1594, "Congo (Republic of the)" },
	{  1595, "Democratic Republic of the Congo" },
	{  1596, "Democratic Republic of the Congo" },
	{  1597, "Democratic Republic of the Congo" },
	{  1598, "Angola (Republic of)" },
	{  1599, "Angola (Republic of)" },
	{  1600, "Guinea-Bissau (Republic of)" },
	{  1601, "Unassigned" },
	{  1602, "Seychelles (Republic of)" },
	{  1603, "Seychelles (Republic of)" },
	{  1604, "Sudan (Republic of the)" },
	{  1605, "Sudan (Republic of the)" },
	{  1606, "Rwanda (Republic of)" },
	{  1607, "Rwanda (Republic of)" },
	{  1608, "Ethiopia (Federal Democratic Republic of)" },
	{  1609, "Unassigned" },
	{  1610, "Somali Democratic Republic" },
	{  1611, "Unassigned" },
	{  1612, "Djibouti (Republic of)" },
	{  1613, "Unassigned" },
	{  1614, "Kenya (Republic of)" },
	{  1615, "Kenya (Republic of)" },
	{  1616, "Tanzania (United Republic of)" },
	{  1617, "Tanzania (United Republic of)" },
	{  1618, "Uganda (Republic of)" },
	{  1619, "Uganda (Republic of)" },
	{  1620, "Burundi (Republic of)" },
	{  1621, "Burundi (Republic of)" },
	{  1622, "Mozambique (Republic of)" },
	{  1623, "Unassigned" },
	{  1624, "Unassigned" },
	{  1625, "Unassigned" },
	{  1626, "Zambia (Republic of)" },
	{  1627, "Unassigned" },
	{  1628, "Madagascar (Republic of)" },
	{  1629, "Madagascar (Republic of)" },
	{  1630, "French Departments and Territories in the Indian Ocean" },
	{  1631, "Unassigned" },
	{  1632, "Zimbabwe (Republic of)" },
	{  1633, "Zimbabwe (Republic of)" },
	{  1634, "Namibia (Republic of)" },
	{  1635, "Unassigned" },
	{  1636, "Malawi" },
	{  1637, "Unassigned" },
	{  1638, "Lesotho (Kingdom of)" },
	{  1639, "Unassigned" },
	{  1640, "Botswana (Republic of)" },
	{  1641, "Botswana (Republic of)" },
	{  1642, "Swaziland (Kingdom of)" },
	{  1643, "Unassigned" },
	{  1644, "Comoros (Union of the)" },
	{  1645, "South Africa (Republic of)" },
	{  1646, "South Africa (Republic of)" },
	{  1647, "South Africa (Republic of)" },
	{  1648, "South Africa (Republic of)" },
	{  1649, "South Africa (Republic of)" },
	{  1650, "Eritrea" },
	{  1651, "Unassigned" },
	{  1652, "Ascension" },
	{  1653, "Unassigned" },
	{  1654, "Unassigned" },
	{  1655, "Unassigned" },
	{  1656, "Diego Garcia" },

	{  1657, "Unassigned" },
	{  1658, "Unassigned" },
	{  1659, "Unassigned" },
	{  1660, "Unassigned" },
	{  1661, "Unassigned" },
	{  1662, "Unassigned" },
	{  1663, "Unassigned" },
	{  1664, "Unassigned" },
	{  1665, "Unassigned" },

	{  1666, "Uganda (Republic of)" },
	{  1667, "Uganda (Republic of)" },

	{  1668, "Unassigned" },
	{  1669, "Unassigned" },
	{  1670, "Unassigned" },
	{  1671, "Unassigned" },
	{  1672, "Unassigned" },
	{  1673, "Unassigned" },
	{  1674, "Unassigned" },
	{  1675, "Unassigned" },

	{  1676, "Angola (Republic of)" },
	{  1677, "Unassigned" },
	{  1678, "Unassigned" },
	{  1679, "Unassigned" },
	{  1680, "Unassigned" },
	{  1681, "Unassigned" },
	{  1682, "Unassigned" },
	{  1683, "Unassigned" },
	{  1684, "Unassigned" },
	{  1685, "Unassigned" },
	{  1686, "Morocco (Kingdom of)" },
	{  1687, "Unassigned" },
	{  1688, "Unassigned" },
	{  1689, "Unassigned" },
	{  1690, "Unassigned" },
	{  1691, "Unassigned" },
	{  1692, "Unassigned" },
	{  1693, "Unassigned" },
	{  1694, "Unassigned" },
	{  1695, "Unassigned" },
	{  1696, "Ghana" },
	{  1697, "Unassigned" },
	{  1698, "Unassigned" },
	{  1699, "Unassigned" },
	{  1700, "Unassigned" },
	{  1701, "Unassigned" },
	{  1702, "Unassigned" },
	{  1703, "Unassigned" },
	{  1704, "Unassigned" },
	{  1705, "Unassigned" },
	{  1706, "Sudan (Republic of the)" },

	{  1707, "Unassigned" },
	{  1708, "Unassigned" },
	{  1709, "Unassigned" },

	{  1710, "Unassigned" },
	{  1711, "Unassigned" },
	{  1712, "Unassigned" },
	{  1713, "Unassigned" },
	{  1714, "Unassigned" },
	{  1715, "Unassigned" },
	{  1716, "Unassigned" },
	{  1717, "Unassigned" },
	{  1718, "Unassigned" },
	{  1719, "Unassigned" },

	{  1720, "Unassigned" },
	{  1721, "Unassigned" },
	{  1722, "Unassigned" },
	{  1723, "Unassigned" },
	{  1724, "Unassigned" },
	{  1725, "Unassigned" },
	{  1726, "Unassigned" },
	{  1727, "Unassigned" },
	{  1728, "Unassigned" },
	{  1729, "Unassigned" },

	{  1730, "Unassigned" },
	{  1731, "Unassigned" },
	{  1732, "Unassigned" },
	{  1733, "Unassigned" },
	{  1734, "Unassigned" },
	{  1735, "Unassigned" },
	{  1736, "Unassigned" },
	{  1737, "Unassigned" },
	{  1738, "Unassigned" },
	{  1739, "Unassigned" },

	{  1740, "Unassigned" },
	{  1741, "Unassigned" },
	{  1742, "Unassigned" },
	{  1743, "Unassigned" },
	{  1744, "Unassigned" },
	{  1745, "Unassigned" },
	{  1746, "Unassigned" },
	{  1747, "Unassigned" },
	{  1748, "Unassigned" },
	{  1749, "Unassigned" },

	{  1750, "Unassigned" },
	{  1751, "Unassigned" },
	{  1752, "Unassigned" },
	{  1753, "Unassigned" },
	{  1754, "Unassigned" },
	{  1755, "Unassigned" },

	{  1756, "The Former Yugoslav Republic of Macedonia" },

	{  1757, "Unassigned" },
	{  1758, "Unassigned" },
	{  1759, "Unassigned" },

	{  1760, "Unassigned" },
	{  1761, "Unassigned" },
	{  1762, "Unassigned" },
	{  1763, "Unassigned" },
	{  1764, "Unassigned" },
	{  1765, "Unassigned" },
	{  1766, "Unassigned" },
	{  1767, "Unassigned" },

	{  1768, "Sweden" },
	{  1769, "France" },
	{  1770, "Czech Republic" },
	{  1771, "Slovenia (Republic of)" },
	{  1772, "Poland (Republic of)" },
	{  1773, "Germany (Federal Republic of)" },
	{  1774, "Sweden" },
	{  1775, "Bulgaria (Republic of)" },
	{  1776, "Monaco (Principality of)" },
	{  1777, "Ukraine" },
	{  1778, "United Kingdom of Great Britain and Northern Ireland" },
	{  1779, "Iceland" },
	{  1780, "Spain" },
	{  1781, "Italy" },
	{  1782, "Ireland" },
	{  1783, "Bulgaria (Republic of)" },
	{  1784, "Latvia (Republic of)" },
	{  1785, "Netherlands (Kingdom of the)" },
	{  1786, "Bulgaria (Republic of)" },
	{  1787, "Hungary (Republic of)" },
	{  1788, "United Kingdom of Great Britain and Northern Ireland" },
	{  1789, "Slovenia (Republic of)" },
	{  1790, "United Kingdom of Great Britain and Northern Ireland" },
	{  1791, "United Kingdom of Great Britain and Northern Ireland" },
	{  1792, "Unassigned" },
	{  1793, "Unassigned" },
	{  1794, "Unassigned" },
	{  1795, "Unassigned" },
	{  1796, "Belize" },
	{  1797, "Unassigned" },
	{  1798, "Unassigned" },
	{  1799, "Unassigned" },
	{  1800, "Guatemala (Republic of)" },
	{  1801, "Guatemala (Republic of)" },
	{  1802, "Guatemala (Republic of)" },
	{  1803, "Unassigned" },
	{  1804, "El Salvador (Republic of)" },
	{  1805, "El Salvador (Republic of)" },
	{  1806, "El Salvador (Republic of)" },
	{  1807, "El Salvador (Republic of)" },
	{  1808, "Honduras (Republic of)" },
	{  1809, "Honduras (Republic of)" },
	{  1810, "Honduras (Republic of)" },
	{  1812, "Nicaragua" },
	{  1813, "Nicaragua" },
	{  1814, "Unassigned" },
	{  1815, "Unassigned" },
	{  1816, "Costa Rica" },
	{  1817, "Unassigned" },
	{  1818, "Panama (Republic of)" },
	{  1819, "Panama (Republic of)" },
	{  1820, "Panama (Republic of)" },
	{  1821, "Panama (Republic of)" },
	{  1822, "Panama (Republic of)" },
	{  1823, "Panama (Republic of)" },
	{  1824, "Peru" },
	{  1825, "Peru" },
	{  1826, "Peru" },
	{  1827, "Peru" },
	{  1828, "Peru" },
	{  1829, "Peru" },
	{  1830, "Peru" },
	{  1831, "Peru" },
	{  1832, "Argentine Republic" },
	{  1833, "Argentine Republic" },
	{  1834, "Argentine Republic" },
	{  1835, "Argentine Republic" },
	{  1836, "Argentine Republic" },
	{  1837, "Argentine Republic" },
	{  1838, "Argentine Republic" },
	{  1839, "Argentine Republic" },
	{  1840, "Brazil (Federative Republic of)" },
	{  1841, "Brazil (Federative Republic of)" },
	{  1842, "Brazil (Federative Republic of)" },
	{  1843, "Brazil (Federative Republic of)" },
	{  1844, "Brazil (Federative Republic of)" },
	{  1845, "Brazil (Federative Republic of)" },
	{  1846, "Brazil (Federative Republic of)" },
	{  1847, "Brazil (Federative Republic of)" },
	{  1848, "Unassigned" },
	{  1849, "Unassigned" },
	{  1850, "Unassigned" },
	{  1851, "Chile" },
	{  1852, "Chile" },
	{  1853, "Chile" },
	{  1854, "Chile" },
	{  1855, "Chile" },
	{  1856, "Colombia (Republic of)" },
	{  1857, "Colombia (Republic of)" },
	{  1858, "Colombia (Republic of)" },
	{  1859, "Colombia (Republic of)" },
	{  1860, "Venezuela (Bolivarian Republic of)" },
	{  1861, "Venezuela (Bolivarian Republic of)" },
	{  1862, "Venezuela (Bolivarian Republic of)" },
	{  1863, "Venezuela (Bolivarian Republic of)" },
	{  1864, "Bolivia (Plurinational State of)" },
	{  1865, "Bolivia (Plurinational State of)" },
	{  1866, "Bolivia (Plurinational State of)" },
	{  1867, "Bolivia (Plurinational State of)" },
	{  1868, "Guyana" },
	{  1869, "Guyana" },
	{  1870, "Unassigned" },
	{  1871, "Unassigned" },
	{  1872, "Ecuador" },
	{  1873, "Ecuador" },
	{  1874, "Ecuador" },
	{  1876, "French Guiana (French Department of)" },
	{  1877, "Unassigned" },
	{  1878, "Unassigned" },
	{  1879, "Unassigned" },
	{  1880, "Paraguay (Republic of)" },
	{  1881, "Paraguay (Republic of)" },
	{  1882, "Unassigned" },
	{  1883, "Unassigned" },
	{  1884, "Suriname (Republic of)" },
	{  1885, "Suriname (Republic of)" },
	{  1886, "Unassigned" },
	{  1887, "Unassigned" },
	{  1888, "Uruguay (Eastern Republic of)" },
	{  1889, "Uruguay (Eastern Republic of)" },
	{  1890, "Unassigned" },
	{  1891, "Falkland Islands (Malvinas)" },

	{  1892, "Unassigned" },
	{  1893, "Unassigned" },
	{  1894, "Unassigned" },
	{  1895, "Unassigned" },
	{  1896, "Unassigned" },
	{  1897, "Unassigned" },
	{  1898, "Unassigned" },
	{  1899, "Unassigned" },

	{  1900, "Unassigned" },
	{  1901, "Unassigned" },
	{  1902, "Unassigned" },
	{  1903, "Unassigned" },
	{  1904, "Unassigned" },
	{  1905, "Unassigned" },
	{  1906, "Unassigned" },
	{  1907, "Unassigned" },
	{  1908, "Unassigned" },
	{  1909, "Unassigned" },

	{  1910, "Unassigned" },
	{  1911, "Unassigned" },
	{  1912, "Unassigned" },
	{  1913, "Unassigned" },
	{  1914, "Unassigned" },
	{  1915, "Unassigned" },
	{  1916, "Unassigned" },
	{  1917, "Unassigned" },
	{  1918, "Unassigned" },
	{  1919, "Unassigned" },

	{  1920, "Unassigned" },
	{  1921, "Unassigned" },
	{  1922, "Unassigned" },
	{  1923, "Unassigned" },
	{  1924, "Unassigned" },
	{  1925, "Unassigned" },
	{  1926, "Unassigned" },
	{  1927, "Unassigned" },
	{  1928, "Unassigned" },
	{  1929, "Unassigned" },

	{  1930, "Unassigned" },
	{  1931, "Unassigned" },
	{  1932, "Unassigned" },
	{  1933, "Unassigned" },
	{  1934, "Unassigned" },
	{  1935, "Unassigned" },
	{  1936, "Unassigned" },
	{  1937, "Unassigned" },
	{  1938, "Unassigned" },
	{  1939, "Unassigned" },

	{  1940, "Unassigned" },
	{  1941, "Unassigned" },
	{  1942, "Bolivia (Plurinational State of)" },
	{  1943, "Bolivia (Plurinational State of)" },
	{  1945, "Unassigned" },
	{  1946, "Unassigned" },
	{  1947, "Unassigned" },
	{  1948, "Unassigned" },
	{  1949, "Unassigned" },

	{  1950, "Unassigned" },
	{  1951, "Unassigned" },
	{  1952, "Unassigned" },
	{  1953, "Unassigned" },
	{  1954, "Unassigned" },
	{  1955, "Unassigned" },
	{  1956, "Unassigned" },
	{  1957, "Unassigned" },
	{  1958, "Unassigned" },
	{  1959, "Unassigned" },

	{  1960, "Unassigned" },
	{  1961, "Unassigned" },
	{  1962, "Unassigned" },
	{  1963, "Unassigned" },
	{  1964, "Unassigned" },
	{  1965, "Unassigned" },
	{  1966, "Unassigned" },
	{  1967, "Unassigned" },
	{  1968, "Unassigned" },
	{  1969, "Unassigned" },

	{  1970, "Unassigned" },
	{  1971, "Unassigned" },
	{  1972, "Unassigned" },
	{  1973, "Unassigned" },
	{  1974, "Unassigned" },
	{  1975, "Unassigned" },
	{  1976, "Unassigned" },
	{  1977, "Unassigned" },
	{  1978, "Unassigned" },
	{  1979, "Unassigned" },

	{  1980, "Unassigned" },
	{  1981, "Unassigned" },
	{  1982, "Unassigned" },
	{  1983, "Unassigned" },
	{  1984, "Unassigned" },
	{  1985, "Unassigned" },
	{  1986, "Unassigned" },
	{  1987, "Unassigned" },
	{  1988, "Unassigned" },
	{  1989, "Unassigned" },

	{  1990, "Unassigned" },
	{  1991, "Unassigned" },
	{  1992, "Unassigned" },
	{  1993, "Unassigned" },
	{  1994, "Unassigned" },
	{  1995, "Unassigned" },
	{  1996, "Unassigned" },
	{  1997, "Unassigned" },
	{  1998, "Unassigned" },
	{  1999, "Unassigned" },

	{  2000, "Unassigned" },
	{  2001, "Unassigned" },
	{  2002, "Unassigned" },
	{  2003, "Unassigned" },
	{  2004, "Unassigned" },
	{  2005, "Unassigned" },
	{  2006, "Unassigned" },
	{  2007, "Unassigned" },
	{  2008, "Unassigned" },
	{  2009, "Unassigned" },

	{  2010, "Unassigned" },
	{  2011, "Unassigned" },
	{  2012, "Unassigned" },
	{  2013, "Unassigned" },
	{  2014, "Unassigned" },
	{  2015, "Unassigned" },
	{  2016, "Unassigned" },
	{  2017, "Unassigned" },
	{  2018, "Unassigned" },
	{  2019, "Unassigned" },

	{  2020, "Unassigned" },
	{  2021, "Unassigned" },
	{  2022, "Unassigned" },
	{  2023, "Unassigned" },
	{  2024, "United Kingdom of Great Britain and Northern Ireland" },
	{  2025, "Bosnia and Herzegovina" },
	{  2026, "United Kingdom of Great Britain and Northern Ireland" },
	{  2027, "Croatia (Republic of)" },
	{  2028, "Spain" },
	{  2029, "United Kingdom of Great Britain and Northern Ireland" },
	{  2030, "France" },
	{  2031, "Slovak Republic" },
	{  2032, "Norway" },
	{  2033, "Spain" },
	{  2034, "Ukraine" },
	{  2035, "United Kingdom of Great Britain and Northern Ireland" },
	{  2036, "Poland (Republic of)" },
	{  2037, "Latvia (Republic of)" },
	{  2038, "Poland (Republic of)" },
	{  2039, "Switzerland (Confederation of)" },
	{  2040, "Romania" },
	{  2041, "Germany (Federal Republic of)" },
	{  2042, "Latvia (Republic of)" },
	{  2043, "United Kingdom of Great Britain and Northern Ireland" },
	{  2044, "Lithuania (Republic of)" },
	{  2045, "United Kingdom of Great Britain and Northern Ireland" },
	{  2046, "Spain" },
	{  2047, "Liechtenstein (Principality of)" },
	{  0, NULL }
};

/*
 * List of International Signalling Point Codes (ISPC)
 * Annex to ITU Operational Bulletin No. 956 - 15.V.2010
 * including amendments up to ITU Operational Bulletin No. 960 - 15.VII.2010
 *
 * Mapping of ISPC to Unique name of the signalling point
 */
static const value_string q708_ispc_point_name[] = {
	{  4096, "LTN ISC Vaduz" },
	{  4097, "LTN ISC Eschen" },
	{  4098, "Unassigned" },
	{  4099, "Mobilikom GMSC Mauren" },
	{  4100, "Mobilkom GMSC Mauren" },
	{  4101, "VIAG GMSC Balzers" },
	{  4102, "Unassigned" },
	{  4103, "Tele2  GMSC/ISC Vaduz" },
	{  4104, "Roma/Via T. Maestrelli" },
	{  4105, "Milano/Via A. De Gasperi S. Donato Milanese" },
	{  4106, "Trento/Via Gilli, 2" },
	{  4107, "Roma/Via Di Torre Spaccata, 172" },
	{  4108, "Milano/Via A. De Gasperi S. Donato Milanese" },
	{  4109, "Firenze/Via Italo Piccagli, 24" },
	{  4110, "Milano/Via Caldera, 21" },
	{  4111, "Roma/via G. Donizetti 7" },
	{  4112, "ROTSTP, Rotterdam" },
	{  4113, "RTDMAXE, Rotterdam" },
	{  4114, "Eric1, Schiphol-Rijk" },
	{  4115, "HIGHNL001, Rotterdam" },
	{  4116, "SitelD009601, Amsterdam" },
	{  4117, "MSCGSMR, Den Haag" },
	{  4118, "AMSD XPL01, Amsterdam" },
	{  4119, "ASDSTP5, Amsterdam" },
	{  4120, "Genova/Via De Marini, 1 - Torre WTC" },
	{  4121, "Milano/Via Caracciolo, 51" },
	{  4122, "Torino/via Cristoforo Colombo 24" },
	{  4123, "Venezia (VE) Via Breo, 2 Fosso" },
	{  4124, "Cagliari (CA) via Efisio Melis 26" },
	{  4125, "Via Tucidide 56 - Milano" },
	{  4126, "Via Alcide De Gasperi, 2 San Donato Milanese" },
	{  4127, "Bologna Via Silvani 2" },
	{  4128, "Athens, Athinai/KT ISC" },
	{  4129, "Thessaloniki, Thessaloniki/1 ISC" },
	{  4130, "Athens NMA" },
	{  4131, "Thessaloniki/ERM" },
	{  4132, "Athens MSC" },
	{  4133, "Athens Kifissos MSC" },
	{  4134, "Athens Koleti MSC" },
	{  4135, "Athens Peania MSC" },
	{  4136, "Cosmoline Athens ISC/1" },
	{  4137, "Athens/TL2" },
	{  4138, "Forthnet/Athens/1" },
	{  4139, "Athens. Athinon av. TAH1" },
	{  4140, "Athens, N. Philadelphia" },
	{  4141, "Athens Metamorfossi MSC" },
	{  4142, "Thessaloniki MSC" },
	{  4143, "Athens International Gateway 1" },
	{  4144, "Colt ASD MAD EX1, Amsterdam" },
	{  4145, "Audiocom, Rotterdam" },
	{  4146, "D-AMS-1, Amsterdam" },
	{  4147, "AMSTNLAL00T, Amsterdam" },
	{  4148, "amEagle, Schiphol-Rijk" },
	{  4149, "ROTMSC01, Rotterdam" },
	{  4150, "Unassigned" },
	{  4151, "bbned-asd1, Amsterdam" },
	{  4152, "AMSB, Amsterdam" },
	{  4153, "AMS-GS-GW1, Amsterdam" },
	{  4154, "IXT 1A, Amsterdam" },
	{  4155, "AMSTNLVE01L, Amsterdam" },
	{  4156, "Amsterdam" },
	{  4157, "AMS MSC01, Amsterdam" },
	{  4158, "EHVMSC1, Eindhoven" },
	{  4159, "dhEagle, Den Haag" },
	{  4160, "NLBZ01T, Schiphol-Rijk" },
	{  4161, "ASD 2H, Amsterdam" },
	{  4162, "RT 2D, Rotterdam" },
	{  4163, "RT 1D, Rotterdam" },
	{  4164, "TES, Amstelveen" },
	{  4165, "SGRMSC01, Den Haag" },
	{  4166, "ASDSSP3, Amsterdam" },
	{  4167, "ZI-CKLV-Box, Zwolle" },
	{  4168, "ASD STP2, Amsterdam" },
	{  4169, "RT STP2, Rotterdam" },
	{  4170, "RT 1P, Rotterdam" },
	{  4171, "Unassigned" },
	{  4172, "MSTPGV1, Den Haag" },
	{  4173, "MSTP EHv1, Eindhoven" },
	{  4174, "ASD 2 GW1, Amsterdam" },
	{  4175, "ASD-P3416MMSC1, Amsterdam" },
	{  4176, "Easyway, Amsterdam" },
	{  4177, "Hilf-ISPC1, Amsterdam" },
	{  4178, "RM STP1, Rotterdam" },
	{  4179, "EN STP1, Son" },
	{  4180, "COM4ASD, Hoofddorp" },
	{  4181, "VT-SSP, Schiphol-Rijk" },
	{  4182, "E1 ASD, Amsterdam" },
	{  4183, "E1 RT, Rotterdam" },
	{  4184, "ASDSCCP1, Amsterdam" },
	{  4185, "RTDSSP1, Rotterdam" },
	{  4186, "FRASSP1, Rotterdam" },
	{  4187, "EQUAMSTP, Amsterdam" },
	{  4188, "EQUAMGSP, Schiphol-Rijk" },
	{  4189, "ROT1, Rotterdam" },
	{  4190, "Amsterdam" },
	{  4191, "AMS4, Amsterdam" },
	{  4192, "BAU4" },
	{  4193, "Bruxelles/F" },
	{  4194, "Bruxelles/G" },
	{  4195, "Liege/C" },
	{  4196, "Bruxelles" },
	{  4197, "Brussels MGW" },
	{  4198, "Unassigned" },
	{  4199, "Antwerpen/E" },
	{  4200, "..." },
	{  4201, "Bruxelles, A/STP" },
	{  4202, "Telenet-Antwerpen" },
	{  4203, "Concert-Bruxelles-Ensor" },
	{  4204, "Unassigned" },
	{  4205, "Unassigned" },
	{  4206, "Bruxelles" },
	{  4207, "..." },
	{  4208, "Bruxelles L/STP" },
	{  4209, "Bruxelles, Evere" },
	{  4210, "Antwerpen" },
	{  4211, "Unassigned" },
	{  4212, "T2 Antwerpen 1" },
	{  4213, "Unassigned" },
	{  4214, "FCI Bruxelles" },
	{  4215, "Bruxelles, B/STP" },
	{  4216, "Bruxelles M/STP" },
	{  4217, "Zaventem" },
	{  4218, "AFRK/Gosselies" },
	{  4219, "Telenet - STP Hoboken" },
	{  4220, "Telenet - STP Gent" },
	{  4221, "WorldCom Brussels - Site II" },
	{  4222, "BMSCA/Bruxelles" },
	{  4223, "AMSCA/Antwerpen" },
	{  4224, "ITN France 1" },
	{  4225, "SFR - Paris 3" },
	{  4226, "Paris Pastourelle - NP Hub" },
	{  4227, "Paris Pastourelle - CTI Pastourelle" },
	{  4228, "Telecom Italia - POP Courbevoie 1" },
	{  4229, "SFR- Velizy 3" },
	{  4230, "Telecom Italia - POP Courbevoie 2" },
	{  4231, "Paris Archives - PTS No1" },
	{  4232, "SFR - Velizy 4" },
	{  4233, "DV-IPX - Paris" },
	{  4234, "Telemedia - Paris 1" },
	{  4235, "Wavecrest - Boulogne 1" },
	{  4236, "SFR - XA20 - Nanterre" },
	{  4237, "SFR - XA22 - Lyon" },
	{  4238, "SFR - Velizy 2" },
	{  4239, "SFR- Lyon 4" },
	{  4240, "Paris Archives - Cisco ITP 1" },
	{  4241, "Bouygues Telecom 3" },
	{  4242, "Bouygues Telecom 4" },
	{  4243, "Completel - Mundolsheim" },
	{  4244, "Paris Archives - Cisco  ITP 2" },
	{  4245, "SFR - XB95 - Puteaux" },
	{  4246, "Tradingcom Europe 1" },
	{  4247, "Reims - PTS No 2" },
	{  4248, "Free - XD54" },
	{  4249, "Paris Pastourelle - NGN PT 5" },
	{  4250, "Free - XD55" },
	{  4251, "Reims - NGN RS4" },
	{  4252, "Colt - XB03" },
	{  4253, "SFR - XD73 - Venissieux" },
	{  4254, "Colt - XB04" },
	{  4255, "SFR - XB96 - Puteaux" },
	{  4256, "Telecom Italia - POP Courbevoie 3" },
	{  4257, "SFR - Nanterre" },
	{  4258, "Cable & Wireless 1" },
	{  4259, "Viatel 1" },
	{  4260, "Telecom Italia - POP Marseille" },
	{  4261, "Paris Pastourelle - OTPTS" },
	{  4262, "Reims - International Gateway Point No 1" },
	{  4263, "Paris Archives - International Gateway Point No 2" },
	{  4264, "SFR Lyon" },
	{  4265, "SFR Int 1, interconnexion international" },
	{  4266, "SFR idf" },
	{  4267, "SFR Dijon 1, PTS/SSCS de Dijon" },
	{  4268, "Primus 1" },
	{  4269, "Global Transit 1" },
	{  4270, "BYT 1, BYT Plateforme roaming" },
	{  4271, "SFR - XC74 - Courbevoie" },
	{  4272, "Storm 1" },
	{  4273, "Colt Int 1, interconnexion international" },
	{  4274, "Equant France-Paris Neo POP" },
	{  4275, "SFR - XA30" },
	{  4276, "SFR - XA47" },
	{  4277, "SFR - XD00 - Paris" },
	{  4278, "SFR - XD19 - Palaiseau" },
	{  4279, "SFR - XA67 - Bordeaux" },
	{  4280, "Kast Telecom 1" },
	{  4281, "Colt - Malakoff" },
	{  4282, "Graphnet 1" },
	{  4283, "SFR - XA21 - Palaiseau" },
	{  4284, "Viatel 2" },
	{  4285, "Telecom Italia - POP Nice" },
	{  4286, "PSN 1" },
	{  4287, "Telecom Italia - POP Lille 1" },
	{  4288, "MT03" },
	{  4289, "MT01" },
	{  4290, "MT04" },
	{  4291, "PTS 1" },
	{  4292, "AXE Mednet" },
	{  4293, "Kosovo roaming" },
	{  4294, "PTS 2" },
	{  4295, "MC 5" },
	{  4296, "Wien" },
	{  4297, "Wien" },
	{  4298, "Unassigned" },
	{  4299, "Wien" },
	{  4300, "Wien" },
	{  4301, "Wien" },
	{  4302, "Wien" },
	{  4303, "Wien" },
	{  4304, "Wien" },
	{  4305, "Unassigned" },
	{  4306, "Unassigned" },
	{  4307, "Unassigned" },
	{  4308, "Wien" },
	{  4309, "Wien" },
	{  4310, "Unassigned" },
	{  4311, "Wien" },
	{  4312, "Madrid" },
	{  4313, "Barcelona" },
	{  4314, "Madrid" },
	{  4315, "Miramon-PTS" },
	{  4316, "Zamudio-PTS" },
	{  4317, "Madrid" },
	{  4318, "Madrid" },
	{  4319, "Madrid" },
	{  4320, "Jundiz-Central" },
	{  4321, "Madrid/Alcobendas-2 CADIL" },
	{  4322, "Madrid/Castellbisbal CADIL" },
	{  4323, "Valencia/Campanar CADIL" },
	{  4324, "Sevilla/Pineda CADIL" },
	{  4325, "Madrid/Alcobendas-3 CADIL" },
	{  4326, "Madrid" },
	{  4327, "Barcelona" },
	{  4328, "Sevilla" },
	{  4329, "Valencia" },
	{  4330, "Madrid/Bellasvistas CIL-D" },
	{  4331, "Barcelona/Sepulveda CIL-D" },
	{  4332, "Barcelona" },
	{  4333, "Madrid" },
	{  4334, "Madrid" },
	{  4335, "Barcelona" },
	{  4336, "Valencia" },
	{  4337, "Malaga" },
	{  4338, "Madrid-Delicias" },
	{  4339, "Madrid-Simancas" },
	{  4340, "Barcelona-Sta. Coloma" },
	{  4341, "Barcelona-Mercaders" },
	{  4342, "Madrid-Meneses" },
	{  4343, "Barcelona-Zona Franca" },
	{  4344, "Madrid" },
	{  4345, "Barcelona" },
	{  4346, "Madrid" },
	{  4347, "Madrid" },
	{  4348, "Madrid" },
	{  4349, "Barcelona" },
	{  4350, "Jundiz (Alava)" },
	{  4351, "Barcelona" },
	{  4352, "Unassigned" },
	{  4353, "Budapest BP1" },
	{  4354, "Budapest BP2" },
	{  4355, "BP MSTP1" },
	{  4356, "BP MSTP2" },
	{  4357, "VTH-DUN-TE" },
	{  4358, "BudapestPTL01" },
	{  4359, "BTH01" },
	{  4360, "Dusseldorf" },
	{  4361, "Frankfurt" },
	{  4362, "Frankfurt" },
	{  4363, "Dusseldorf" },
	{  4364, "Hamburg" },
	{  4365, "Haar" },
	{  4366, "Stuttgart" },
	{  4367, "Frankfurt" },
	{  4368, "Stuttgart" },
	{  4369, "Frankfurt am Main" },
	{  4370, "Dusseldorf" },
	{  4371, "Dusseldorf" },
	{  4372, "Dusseldorf" },
	{  4373, "Eschborn" },
	{  4374, "Dusseldorf" },
	{  4375, "Frankfurt am Main" },
	{  4376, "Offenbach" },
	{  4377, "Hamburg" },
	{  4378, "Berlin" },
	{  4379, "Hamburg" },
	{  4380, "Frankfurt am Main" },
	{  4381, "Dusseldorf" },
	{  4382, "Hamburg" },
	{  4383, "Frankfurt am Main" },
	{  4384, "Ratingen" },
	{  4385, "Suizbach" },
	{  4386, "Frankfurt am Main" },
	{  4387, "Stuttgart" },
	{  4388, "Dusseldorf" },
	{  4389, "Hamburg" },
	{  4390, "Dusseldorf" },
	{  4391, "Frankfurt am Main" },
	{  4392, "Frankfurt am Main" },
	{  4393, "Dusseldorf" },
	{  4394, "Frankfurt am Main" },
	{  4395, "Frankfurt am Main" },
	{  4396, "Dusseldorf" },
	{  4397, "Leer" },
	{  4398, "Frankfurt am Main" },
	{  4399, "Frankfurt am Main" },
	{  4400, "Frankfurt" },
	{  4401, "Dusseldorf" },
	{  4402, "Frankfurt am Main" },
	{  4403, "Frankfurt am Main" },
	{  4404, "Dusseldorf" },
	{  4405, "Frankfurt am Main" },
	{  4406, "Frankfurt am Main" },
	{  4407, "Dusseldorf" },
	{  4408, "Frankfurt am Main" },
	{  4409, "Dusseldorf" },
	{  4410, "Frankfurt" },
	{  4411, "reserved" },
	{  4412, "Frankfurt" },
	{  4413, "Frankfurt" },
	{  4414, "Frankfurt" },
	{  4415, "Frankfurt" },
	{  4416, "..." },
	{  4417, "..." },
	{  4418, "..." },
	{  4419, "..." },
	{  4420, "..." },
	{  4421, "..." },
	{  4422, "..." },
	{  4423, "..." },
	{  4424, "Milano/Via Montalbino 4" },
	{  4425, "Roma/Via Ercolano Salvi 12" },
	{  4426, "Milano/Via Caldera 21/F" },
	{  4427, "Firenze/Via Cironi, 32a" },
	{  4428, "Bologna/Via del Terrapieno, 46" },
	{  4429, "Massarosa (LU)/Via Montramito, 431a" },
	{  4430, "Milano/via Caldera 21" },
	{  4431, "Torino/Via Livorno, 60" },
	{  4432, "Torino/Via Issiglio 62" },
	{  4433, "Milano/Strada 5, Palazzo N, Fiori Rozzano" },
	{  4434, "Legnago (VR)/Via San Salvaro" },
	{  4435, "Milano/Via Alcide de Gasperi, 2" },
	{  4436, "Milano/Via Mecenate 90" },
	{  4437, "Padova/Via Savelli 88" },
	{  4438, "Torino/Corso Svizzera 185" },
	{  4439, "Bolzano/Via Lungo Isarco Sinistro" },
	{  4440, "Milano/Via Visconti di Modrone 12" },
	{  4441, "Lucca/Viale Puccini Trav.1 1 n.134" },
	{  4442, "Milano/via Caldera 21" },
	{  4443, "Milano/Viale Montenero 63" },
	{  4444, "Roma/Via Monserrato 25" },
	{  4445, "Torino/Corso Vittorio Emanuele II 90" },
	{  4446, "Napoli/CentroDirezionale Isola G1" },
	{  4447, "Brescia/Via della Volta" },
	{  4448, "Roma/1240 - TEST2" },
	{  4449, "Roma/A2I - UT100" },
	{  4450, "Milano/M2I - UT100" },
	{  4451, "Roma/A1T - AXE" },
	{  4452, "Roma/A1I - 1240" },
	{  4453, "Palermo/L1I - 1240" },
	{  4454, "Milano/M1I - 1240" },
	{  4455, "Milano/Via Caldera 21" },
	{  4456, "Roma/N1I - 1240" },
	{  4457, "MI1/Via Jenner 56" },
	{  4458, "Roma/IS - RM1" },
	{  4459, "Milano/M3I - UT100" },
	{  4460, "Roma/AEI - 5ESS" },
	{  4461, "Milano/MSC01" },
	{  4462, "Roma/MSC01" },
	{  4463, "Roma/UT100 - TEST3" },
	{  4464, "Milano/R1I - UT100" },
	{  4465, "Milano/IS - MI1" },
	{  4466, "Milano/UT100 - TEST1" },
	{  4467, "Trezzano sul Naviglio (MI)/v.L.Da Vinci J." },
	{  4468, "Roma/AUI - UT100" },
	{  4469, "Milano/DMS - 1" },
	{  4470, "Milano/MI01" },
	{  4471, "Roma/RM01" },
	{  4472, "WI MI1 Milano" },
	{  4473, "WI RM1 Roma" },
	{  4474, "Milano/IS - MI2" },
	{  4475, "Milano/MI - MSC" },
	{  4476, "Roma/RO - CTRL" },
	{  4477, "Milano S. Simpliciano ITZ" },
	{  4478, "Milano/Via G. Murat 23" },
	{  4479, "Roma/Via Bruxelles 79" },
	{  4480, "Trento/Via Brennero, 169/11" },
	{  4481, "Milano/Via Caldera 21" },
	{  4482, "Milano/Via Archimede 10" },
	{  4483, "Milano/Via Aporti 26" },
	{  4484, "Milano/Segrate" },
	{  4485, "Roma/Porta Ardeatina 129" },
	{  4486, "Milano/Via Bensi 1/6 Liberty B" },
	{  4487, "Milano/Via Bensi 12/9 Liberty A" },
	{  4488, "Roma/via Boccabeli 5" },
	{  4489, "L'Aquila/Fucino 1" },
	{  4490, "L'Aquila/Fucino 2" },
	{  4491, "Milano/Cormano/Via Prealpi 8" },
	{  4492, "Roma/Via Livenza 4" },
	{  4493, "Roma/v. del Fossa di Santa Maura (aug. Torrespacc.)" },
	{  4494, "Milano/Via Rombon 11" },
	{  4495, "Milano/Corso S. Gottardo 39" },
	{  4496, "Milano/Via Statuto, 4" },
	{  4497, "Milano/Via Viviani 8" },
	{  4498, "Milano/Cormano/Via Prealpi 8" },
	{  4499, "Roma/Vicolo C. della Strega 41" },
	{  4500, "Milano/Via E. Jenner 33" },
	{  4501, "Avezzano/Via G. Galilei" },
	{  4502, "Roma/Via le Kennedy (Palazzo Congressi)" },
	{  4503, "Udine/Via Marcello snc. Palmanova" },
	{  4504, "Verona/Piazzale Europa 12" },
	{  4505, "Padova/Via San Marco" },
	{  4506, "Milano/Via Rombon 11" },
	{  4507, "Via Leonardo da Vinci 1 - Trezzano sul Naviglio (Milano)" },
	{  4508, "Milano/Via Caldera 21" },
	{  4509, "Trieste/Via Lochi 19" },
	{  4510, "Firenze/Via Calzaiuoli 3" },
	{  4511, "Milano/Via Caldera 21" },
	{  4512, "..." },
	{  4513, "Bucuresti International" },
	{  4514, "Brasov International" },
	{  4515, "..." },
	{  4516, "..." },
	{  4517, "GSM 900" },
	{  4518, "GSM 900" },
	{  4519, "CDMA 450" },
	{  4520, "Zurich" },
	{  4521, "Renens VD" },
	{  4522, "..." },
	{  4523, "Cham" },
	{  4524, "Lausanne" },
	{  4525, "Carouge" },
	{  4526, "Zurich" },
	{  4527, "Renens VD" },
	{  4528, "Zurich" },
	{  4529, "Crissier" },
	{  4530, "Zurich" },
	{  4531, "Glattbrug/Zurich" },
	{  4532, "Zurich" },
	{  4533, "Zurich" },
	{  4534, "Bern" },
	{  4535, "Zurich" },
	{  4536, "Basel" },
	{  4537, "Zurich" },
	{  4538, "Basel" },
	{  4539, "Basel" },
	{  4540, "Bern" },
	{  4541, "Zurich" },
	{  4542, "..." },
	{  4543, "Renens VD" },
	{  4544, "Zurich" },
	{  4545, "Zurich" },
	{  4546, "Geneve" },
	{  4547, "Geneve" },
	{  4548, "Zurich" },
	{  4549, "Zurich" },
	{  4550, "Basel" },
	{  4551, "Basel" },
	{  4552, "Used for Swisscom internal purposes" },
	{  4553, "Swiss GSM Int'l Roaming Switch, MSC1 Lausanne (Swiss Natel D)" },
	{  4554, "Swiss GSM Int'l Roaming Switch, MSC5 Zurich (Swiss Natel D)" },
	{  4555, "Swiss NMT Int'l Roaming Switch, NC5/NMT (Swiss Natel C)" },
	{  4556, "Bern" },
	{  4557, "Basel" },
	{  4558, "Bern" },
	{  4559, "Zurich" },
	{  4560, "Zurich" },
	{  4561, "Zurich S01" },
	{  4562, "Alias ZHSTP02/GESTP01" },
	{  4563, "Zurich" },
	{  4564, "Lausanne S01" },
	{  4565, "Zurich" },
	{  4566, "Zurich" },
	{  4567, "Zurich" },
	{  4568, "Pully" },
	{  4569, "Biel/Bienne" },
	{  4570, "Geneve" },
	{  4571, "Bern" },
	{  4572, "Zurich" },
	{  4573, "Luzern" },
	{  4574, "Bern" },
	{  4575, "Bern" },
	{  4576, "MGW PRC 1-1" },
	{  4577, "Craph2  CZ" },
	{  4578, "MGW PRC 2" },
	{  4579, "Tiscali CZ" },
	{  4580, "Craphi1 CZ" },
	{  4581, "Ceznet Praha CZ" },
	{  4582, "SZDC CZ" },
	{  4583, "Unassigned" },
	{  4584, "Basel" },
	{  4585, "Renens VD" },
	{  4586, "..." },
	{  4587, "Zurich" },
	{  4588, "..." },
	{  4589, "Zurich" },
	{  4590, "Bern" },
	{  4591, "Bern" },
	{  4592, "Geneve" },
	{  4593, "Zurich" },
	{  4594, "ZHSTP02" },
	{  4595, "Zurich" },
	{  4596, "Zurich" },
	{  4597, "Zurich" },
	{  4598, "Wallisellen" },
	{  4599, "Zurich" },
	{  4600, "Chiasso" },
	{  4601, "GESTP01" },
	{  4602, "Unassigned" },
	{  4603, "Zurich" },
	{  4604, "Zurich" },
	{  4605, "Crissier" },
	{  4606, "Zurich" },
	{  4607, "Zug" },
	{  4608, "Wien" },
	{  4609, "Wien" },
	{  4610, "Wien" },
	{  4611, "Unassigned" },
	{  4612, "Unassigned" },
	{  4613, "Wien" },
	{  4614, "Unassigned" },
	{  4615, "Linz" },
	{  4616, "Wien" },
	{  4617, "Wien" },
	{  4618, "Wien" },
	{  4619, "Wien" },
	{  4620, "Wien" },
	{  4621, "Unassigned" },
	{  4622, "Wien" },
	{  4623, "Wien" },
	{  4624, "Wien" },
	{  4625, "Wien" },
	{  4626, "Unassigned" },
	{  4627, "Wien" },
	{  4628, "Unassigned" },
	{  4629, "Wien" },
	{  4630, "Wien" },
	{  4631, "Unassigned" },
	{  4632, "Wien" },
	{  4633, "Wien" },
	{  4634, "Wien" },
	{  4635, "Unassigned" },
	{  4636, "Unassigned" },
	{  4637, "Unassigned" },
	{  4638, "Unassigned" },
	{  4639, "Wien" },
	{  4640, "Kelvin 2" },
	{  4641, "Kelvin" },
	{  4642, "Manchester TeS" },
	{  4643, "Keybridge C" },
	{  4644, "Madley A" },
	{  4645, "Belfast Cromac DXA" },
	{  4646, "Auckland Land Earth Station" },
	{  4647, "Goonhilly Inmarsat 1" },
	{  4648, "JER-TPSTA" },
	{  4649, "Belfast City Unit B" },
	{  4650, "Portadown DCCE Unit 1" },
	{  4651, "YANNA UK1" },
	{  4652, "LON-TPSTB" },
	{  4653, "MGC1" },
	{  4654, "MGC2" },
	{  4655, "London H" },
	{  4656, "Turner SSP" },
	{  4657, "London GSX 9" },
	{  4658, "Frankfurt Durer SSP" },
	{  4659, "Sydny Bell SSP" },
	{  4660, "Monet SSP" },
	{  4661, "Blake SCP" },
	{  4662, "Reference model Martlesham" },
	{  4663, "Reference model Martlesham" },
	{  4664, "Hong KongHogarth SSP" },
	{  4665, "Tokyo Utamaro SSP" },
	{  4666, "Hawk" },
	{  4667, "Esher" },
	{  4668, "Qi London 7" },
	{  4669, "Glasgow TeS" },
	{  4670, "LONDON1" },
	{  4671, "Brentwood1" },
	{  4672, "Bracknell 2, ISC" },
	{  4673, "STP-1" },
	{  4674, "Vauxhall 2, ISC" },
	{  4675, "Bracknell 5, ISC" },
	{  4676, "Chart Street 3, ISC" },
	{  4677, "Bracknell Switchband, Transit A" },
	{  4678, "Thameside Switchband, Transit B" },
	{  4679, "STP-2" },
	{  4680, "L/PSX/1" },
	{  4681, "London D" },
	{  4682, "LDNux1" },
	{  4683, "Brentwood2" },
	{  4684, "Telsis" },
	{  4685, "London 1" },
	{  4686, "Telehouse 2" },
	{  4687, "..." },
	{  4688, "London 1" },
	{  4689, "LAD11" },
	{  4690, "L/PSX/5" },
	{  4691, "Nutel SG1" },
	{  4692, "London 1" },
	{  4693, "LDNI ISC" },
	{  4694, "TINC IN Platform" },
	{  4695, "TIND IN Platform" },
	{  4696, "London" },
	{  4697, "DA LON 1" },
	{  4698, "ECT 1" },
	{  4699, "UK2" },
	{  4700, "London 1" },
	{  4701, "Croydon GMSC 2" },
	{  4702, "JE/W/STP" },
	{  4703, "JE/MP/MSX" },
	{  4704, "Copenhagen - Copenhagen dnc" },
	{  4705, "Unassigned" },
	{  4706, "Copenhagen - Albertslund dnc" },
	{  4707, "Unassigned" },
	{  4708, "..." },
	{  4709, "Unassigned" },
	{  4710, "Copenhagen - Copenhagen dsa" },
	{  4711, "Unassigned" },
	{  4712, "Copenhagen - Albertslund ISG" },
	{  4713, "..." },
	{  4714, "Copenhagen" },
	{  4715, "Copenhagen" },
	{  4716, "Unassigned" },
	{  4717, "Unassigned" },
	{  4718, "Unassigned" },
	{  4719, "Unassigned" },
	{  4720, "Copenhagen" },
	{  4721, "Copenhagen - Ejby LS" },
	{  4722, "Unassigned" },
	{  4723, "Unassigned" },
	{  4724, "Unassigned" },
	{  4725, "..." },
	{  4726, "Unassigned" },
	{  4727, "Unassigned" },
	{  4728, "Unassigned" },
	{  4729, "Glostrup" },
	{  4730, "Unassigned" },
	{  4731, "Unassigned" },
	{  4732, "Copenhagen - Orestaden LS" },
	{  4733, "Telehouse Glostrup" },
	{  4734, "Unassigned" },
	{  4735, "Unassigned" },
	{  4736, "Stockholm (Stockholm UX1)" },
	{  4737, "Stockholm (VMS1)" },
	{  4738, "Stockholm (MSC1)" },
	{  4739, "Stockholm (MSC2)" },
	{  4740, "Stockholm (GTS-STO-S1)" },
	{  4741, "Malmo (MKR2 MSC)" },
	{  4742, "Stockholm (NMT STHLM MSC1)" },
	{  4743, "Stockholm (Stockholm UX2)" },
	{  4744, "Stockholm (Stockholm/UN STX)" },
	{  4745, "Stockholm (Stockholm/UR STX)" },
	{  4746, "Malmo (Malmo/UR STX)" },
	{  4747, "Malmo (MB1 MSC)" },
	{  4748, "Stockholm (MSC102)" },
	{  4749, "Stockholm (SNVH1-INT)" },
	{  4750, "Stockholm (SNKT1-INT)" },
	{  4751, "STO 001 GSXI 1 (Stockholm)" },
	{  4752, "Stockholm (RIX1)" },
	{  4753, "Stockholm (IQVM4)" },
	{  4754, "Goteborg (VRR2 MSC)" },
	{  4755, "Stockholm (MSC402)" },
	{  4756, "Stockholm (MSC401)" },
	{  4757, "Stockholm (Stockholm MSE)" },
	{  4758, "Stockholm (MGW102)" },
	{  4759, "STHTELINT-1 (Stockholm)" },
	{  4760, "Stockholm (Kista/TL2)" },
	{  4761, "Goteborg (Gothenburg/TL2)" },
	{  4762, "Stockholm (WCOMSTHLM2)" },
	{  4763, "Stockholm (WCOMSTHLM3)" },
	{  4764, "SU-HUV-MSS1 (Stockholm)" },
	{  4765, "KK-B-MSC09 (Karlskrona)" },
	{  4766, "Stockholm (RSL-SWE2)" },
	{  4767, "Stockholm (Equant Sweden)" },
	{  4768, "Eik GW1" },
	{  4769, "Eik GW2" },
	{  4770, "Oslo U1" },
	{  4771, "Oslo U2" },
	{  4772, "Aeromobile1" },
	{  4773, "Oslo U1" },
	{  4774, "Oslo U2" },
	{  4775, "OSLO_IP" },
	{  4776, "Oslo MSC1" },
	{  4777, "Oslo 1" },
	{  4778, "Oslo 2" },
	{  4779, "Oslo G MSC" },
	{  4780, "Oslo Network Norway" },
	{  4781, "Oslo 1" },
	{  4782, "Oslo" },
	{  4783, "Oslo 2" },
	{  4784, "Oslo Netc1 MSC" },
	{  4785, "Oslo Netc4 MSC" },
	{  4786, "T1E-Osl" },
	{  4787, "T1E-Bgo" },
	{  4788, "Oslo 1" },
	{  4789, "Oslo 2" },
	{  4790, "OSL-TL1" },
	{  4791, "Oslo_LX" },
	{  4792, "MSC JBV-nett" },
	{  4793, "Oslo PA1I" },
	{  4794, "STVR_LX" },
	{  4795, "Unassigned" },
	{  4796, "NIT-GW1" },
	{  4797, "Eik MSC 1" },
	{  4798, "NMT Oslo MSC1" },
	{  4799, "Gri CDMA MSC" },
	{  4800, "Helsinki (HEL1)" },
	{  4801, "Helsinki (HEL2)" },
	{  4802, "Helsinki (VLA92)" },
	{  4803, "Espoo (ESPOO3)" },
	{  4804, "Helsinki (OPS2)" },
	{  4805, "Helsinki (OPS 2 HP Server Fonecta Oy)" },
	{  4806, "Helsinki (MGTS)" },
	{  4807, "Unassigned" },
	{  4808, "Unassigned" },
	{  4809, "Helsinki (GIWU)" },
	{  4810, "Unassigned" },
	{  4811, "Hameenlinna (HML1 Surpass MGC)" },
	{  4812, "Helsinki (HMG02 TSIC)" },
	{  4813, "Unassigned" },
	{  4814, "Unassigned" },
	{  4815, "Hyvinkaa (KOE10 Surpass)" },
	{  4816, "Mariehamn (Mariehamn)" },
	{  4817, "Jomala (Jomala)" },
	{  4818, "Unassigned" },
	{  4819, "Unassigned" },
	{  4820, "Helsinki (FI1)" },
	{  4821, "Tampere (FI2)" },
	{  4822, "Unassigned" },
	{  4823, "Unassigned" },
	{  4824, "Unassigned" },
	{  4825, "Helsinki (FITEST)" },
	{  4826, "Vantaa (MY1)" },
	{  4827, "Vantaa (MY2)" },
	{  4828, "Vantaa (HKIGMSC01)" },
	{  4829, "Unassigned" },
	{  4830, "Unassigned" },
	{  4831, "Helsinki (Helsinki1)" },
	{  4832, "Tallinn" },
	{  4833, "Tallinn" },
	{  4834, "Tallinn" },
	{  4835, "Tallinn" },
	{  4836, "Tallinn" },
	{  4837, "Unassigned" },
	{  4838, "Tallinn" },
	{  4839, "Tallinn" },
	{  4840, "Parma Via Goito 14" },
	{  4841, "Nola (NA) Via Polveriera, 130" },
	{  4842, "Bari Via Traversa, 310 di Via Napoli, 49g" },
	{  4843, "Roma/Sedime Aeroportuale di fiumicino" },
	{  4844, "Milano via Ugo Bassi 2" },
	{  4845, "L'Aquila (Ortucchio)/Fucino" },
	{  4846, "Milano/Via Caldera, 21/F" },
	{  4847, "Milano/Via C. Gluk, 35" },
	{  4848, "Roma/Via S. Martini, 127/129" },
	{  4849, "Roma/Viale Lincoln, 18" },
	{  4850, "Roma/Via Bernardino Alimena, 105" },
	{  4851, "Palermo/Via Igo La Malfa, 28-30" },
	{  4852, "Sassari/via Nulvi 25" },
	{  4853, "Milano/via Caldera 21" },
	{  4854, "Firenze-D.G. Autostrade FI Nord A1" },
	{  4855, "L'Aquila (ortucchio)/fucino" },
	{  4856, "Milano/Via Bensi, 12/9 Liberty A" },
	{  4857, "Roma/Via del Fosso di S. Maura" },
	{  4858, "Milano/Via Caldera, 21" },
	{  4859, "Pozzuoli (NA)/Via Antiniana, 2/A" },
	{  4860, "Roma/ Via Maroso, 150" },
	{  4861, "Roma /Via Maroso, 150" },
	{  4862, "Treviolo (BG)/Viale Europa, 17B" },
	{  4863, "Verona/Via del Perlar, 24" },
	{  4864, "Riga ISC1 (S-12)" },
	{  4865, "Riga ISC 2" },
	{  4866, "Riga SN 2" },
	{  4867, "Riga LE Gateway" },
	{  4868, "GSM" },
	{  4869, "Riga TB1" },
	{  4870, "MSC-1" },
	{  4871, "GSM" },
	{  4872, "Mobistar STP TO2 BRU" },
	{  4873, "Mobistar STP TO3 ANT" },
	{  4874, "Bruxelles-1" },
	{  4875, "Unassigned" },
	{  4876, "ZMSC1" },
	{  4877, "GMSC3" },
	{  4878, "VILKPN1A" },
	{  4879, "Telenet-Asse" },
	{  4880, "Unassigned" },
	{  4881, "Unassigned" },
	{  4882, "Unassigned" },
	{  4883, "BSTP 1/Brussels STP" },
	{  4884, "ASTP1/Antwerp STP" },
	{  4885, "BXL A" },
	{  4886, "BRUSS701" },
	{  4887, "Dolphin Villende MSC 1" },
	{  4888, "Unassigned" },
	{  4889, "MLNKT/Nivelles" },
	{  4890, "Unassigned" },
	{  4891, "Unassigned" },
	{  4892, "..." },
	{  4893, "..." },
	{  4894, "Unassigned" },
	{  4895, "Unassigned" },
	{  4896, "Moscow International Switching Centre-3" },
	{  4897, "St Petersburg International Switching Centre" },
	{  4898, "Moscow International Switching Centre-4" },
	{  4899, "Khabarovsk International Switching Centre" },
	{  4900, "Samara International Switching Centre" },
	{  4901, "Novosibirsk International Switching Centre" },
	{  4902, "Ekaterinburg International Switching Centre" },
	{  4903, "Rostov International Switching Centre" },
	{  4904, "IGW1/MOS International gateway 1, Moscow" },
	{  4905, "IGW2/SPB International gateway 2, St Petersburg" },
	{  4906, "IGW3/NVS International gateway 3, Novosibirsk" },
	{  4907, "Unassigned" },
	{  4908, "Unassigned" },
	{  4910, "Unassigned" },
	{  4911, "IGW4/HAB International gateway 4, Khabarovsk" },
	{  4912, "Moscow International Gateway 1, GSM" },
	{  4913, "St. Petersburg International Gateway, GSM" },
	{  4917, "Moscow International Gateway 2" },
	{  4920, "Moscow Connection Station" },
	{  4928, "Moscow International Switching Center-1" },
	{  4929, "St. Petersburg International Switching Center-33" },
	{  4930, "Murmansk International Switching Center" },
	{  4931, "Moscow International Stand alone STP-1" },
	{  4932, "Moscow International Stand alone STP-2" },
	{  4933, "Kaliningrad International Switching Center" },
	{  4934, "Moscow International Switching Center-5" },
	{  4935, "Moscow International Switching Center-2" },
	{  5056, "Warszawa I" },
	{  5057, "Katowice I" },
	{  5058, "Poznaz I" },
	{  5059, "Katowice II" },
	{  5060, "Poznan II" },
	{  5061, "Warszawa (SCPP)" },
	{  5062, "Warszawa (SCPP)" },
	{  5063, "Warszawa" },
	{  5064, "Dusseldorf" },
	{  5065, "Frankfurt" },
	{  5066, "Frankfurt" },
	{  5067, "Stuttgart" },
	{  5068, "Eschborn" },
	{  5069, "Eschborn" },
	{  5070, "Berlin" },
	{  5071, "Frankfurt" },
	{  5072, "Kirchheim" },
	{  5073, "Frankfurt" },
	{  5074, "Frankfurt" },
	{  5075, "Niederrad" },
	{  5076, "Frankfurt am Main" },
	{  5077, "Dusseldorf" },
	{  5078, "Frankfurt" },
	{  5079, "Frankfurt" },
	{  5080, "Dusseldorf" },
	{  5081, "Frankfurt" },
	{  5082, "Dusseldorf" },
	{  5083, "Dusseldorf" },
	{  5084, "Frankfurt am Main" },
	{  5085, "Dusseldorf" },
	{  5086, "Wuppertal" },
	{  5087, "Frankfurt" },
	{  5088, "Frankfurt" },
	{  5089, "Dusseldorf, Group B" },
	{  5090, "Dusseldorf, Group C" },
	{  5091, "Dusseldorf, Group D" },
	{  5092, "Dusseldorf, Group E" },
	{  5093, "Dusseldorf Stand Alone STP/SPR" },
	{  5094, "ATM Dusseldorf" },
	{  5095, "Frankfurt" },
	{  5096, "Frankfurt" },
	{  5097, "Frankfurt" },
	{  5098, "ISC Berlin, Group C" },
	{  5099, "Frankfurt" },
	{  5100, "Frankfurt" },
	{  5101, "Frankfurt" },
	{  5102, "Frankfurt" },
	{  5103, "Frankfurt" },
	{  5104, "ISC Hamburg, Group A" },
	{  5105, "Frankfurt" },
	{  5106, "MSC Hamburg, Group A" },
	{  5107, "MSC Munchen, Group A" },
	{  5108, "MSC Koln, Group A" },
	{  5109, "MSC Stuttgart, Group A" },
	{  5110, "ATM Hamburg" },
	{  5111, "Frankfurt" },
	{  5112, "Frankfurt" },
	{  5113, "Frankfurt" },
	{  5114, "Frankfurt am Main" },
	{  5115, "Heusenstamm" },
	{  5116, "Frankfurt" },
	{  5117, "Dusseldorf" },
	{  5118, "Frankfurt" },
	{  5119, "Frankfurt" },
	{  5120, "ISC Frankfurt am Main, Group C" },
	{  5121, "ISC Frankfurt am Main, Group D" },
	{  5122, "ISC Frankfurt am Main, Group E" },
	{  5123, "ISC Frankfurt am Main, Group F" },
	{  5124, "Frankfurt Stand Alone STP/SPR" },
	{  5125, "Frankfurt Stand Alone STP/SPR" },
	{  5126, "ATM Frankfurt" },
	{  5127, "Frankfurt" },
	{  5128, "Dusseldorf" },
	{  5129, "Frankfurt" },
	{  5130, "ISC Stuttgart, Group B" },
	{  5131, "Wendlingen" },
	{  5132, "Stuttgart" },
	{  5133, "Frankfurt" },
	{  5134, "Frankfurt" },
	{  5135, "ATM Stuttgart" },
	{  5136, "ISC Munchen, Group E" },
	{  5137, "Frankfurt" },
	{  5138, "ISC Raisting LES" },
	{  5139, "ISC Usingan ICO/SAN" },
	{  5140, "Hamburg" },
	{  5141, "Frankfurt" },
	{  5142, "Frankfurt" },
	{  5143, "Frankfurt" },
	{  5144, "Dusseldorf" },
	{  5145, "40211 Dusseldorf" },
	{  5146, "Nurnberg ZSB Group Y" },
	{  5147, "Nurnberg ZSB ATM" },
	{  5148, "Nurnberg Group K (ATM)" },
	{  5149, "Nurnberg STA STP/SPR" },
	{  5150, "Nurnberg ZSB, Group U" },
	{  5151, "Nurnberg ZSB, Group T" },
	{  5152, "Gibtelecom" },
	{  5154, "Gibtelecom" },
	{  5155, "Sapphire Networks" },
	{  5156, "CTS Gibraltar" },
	{  5157, "Cloud9" },
	{  5158, "CTS Gibraltar (3G Mobile Service)" },
	{  5160, "Wien" },
	{  5161, "Wien" },
	{  5162, "Wien" },
	{  5163, "Wien" },
	{  5164, "Wien" },
	{  5165, "Wien" },
	{  5166, "Wien" },
	{  5167, "Wien" },
	{  5168, "Warszawa II" },
	{  5169, "Warszawa I" },
	{  5170, "Warszawa I" },
	{  5171, "Warszawa" },
	{  5172, "Katowice" },
	{  5173, "Warszawa" },
	{  5174, "Katowice" },
	{  5175, "Warszawa I" },
	{  5184, "PTC  (LDV/RM3) Linda-a-Velha" },
	{  5185, "PTC  (PCS/RM2) Lisboa" },
	{  5186, "PTC  (LDV/RM4) Linda-a-Velha" },
	{  5187, "PTC  (LIS/PT1)  Boa-Hora" },
	{  5188, "PTC  (LDV/RM5) Linda-a-Velha" },
	{  5189, "PTC  (PCS/RM3) Lisboa" },
	{  5190, "PTC  (LIS/PT2) Carnide2" },
	{  5192, "Lisboa" },
	{  5193, "PTC  (LDV/RM1)  Linda-a-Velha" },
	{  5194, "PTC  (LDV/RM2) Linda-a-Velha" },
	{  5195, "PTC  (PCS/RM1) Lisboa" },
	{  5196, "Lisboa (LI01)" },
	{  5197, "Porto (PT01)" },
	{  5198, "Lisboa (LSBNOTJZOIT)" },
	{  5199, "TTPLBA" },
	{  5201, "Lisboa - Matinha" },
	{  5202, "Lisboa (Loures)" },
	{  5203, "Lisboa (00INTL01)" },
	{  5204, "Porto (00INTP01)" },
	{  5205, "Republica" },
	{  5206, "TVCLIS04-Lisboa" },
	{  5207, "TVCLIS91-Lisboa" },
	{  5208, "Lisboa (GRA30)" },
	{  5209, "MAT1MS" },
	{  5210, "Casal de Alfragide (ALF1ME)" },
	{  5211, "BOA1MS" },
	{  5212, "Lisboa-ALF1TC" },
	{  5213, "Porto-BOA1TC" },
	{  5214, "Colt-Oeiras" },
	{  5215, "Lisboa - Gare do Oriente (RTINT1)" },
	{  5216, "Luxembourg - Gare" },
	{  5217, "Luxembourg - Belair" },
	{  5218, "Luxembourg - Gare (MSC)" },
	{  5219, "Bertrange (MSC)" },
	{  5220, "Bertrange (Mach)" },
	{  5221, "Luxembourg" },
	{  5222, "Howald" },
	{  5223, "Bertrange (Tele2)" },
	{  5224, "Luxembourg-CDN" },
	{  5225, "Cloche d'or - GTS" },
	{  5226, "Cloche d'or - FIM" },
	{  5227, "Cloche d'or - KPN" },
	{  5228, "Bertrange - HAP" },
	{  5229, "Munsbach - WOC" },
	{  5230, "..." },
	{  5232, "Telecity2, Amsterdam" },
	{  5233, "NL01INT, Amsterdam" },
	{  5234, "AMS-1, Amsterdam" },
	{  5235, "TU, Utrecht" },
	{  5236, "TR, Rotterdam" },
	{  5237, "TA, Amsterdam" },
	{  5238, "XANTIC, Burum" },
	{  5240, "PMGSSP, Amsterdam" },
	{  5241, "UT_MSC, Nieuwegein" },
	{  5242, "cooling down" },
	{  5243, "TVINT-GW1, Rotterdam" },
	{  5244, "AMDI, Amsterdam" },
	{  5245, "SGRSTP01, Den Haag" },
	{  5246, "ROT2, Rotterdam" },
	{  5247, "ASDVoiceXS, Amsterdam" },
	{  5248, "Dublin, Dame Court" },
	{  5249, "Dublin, Adelaide Road" },
	{  5250, "Dublin 1" },
	{  5251, "Dublin 2" },
	{  5252, "Dublin, Dolphin's Barn" },
	{  5253, "Blanchardstown (M10)" },
	{  5254, "Willsborough (W31)" },
	{  5255, "Dundrum" },
	{  5256, "Fenian Street" },
	{  5257, "Sir Rodgerson's Quay" },
	{  5258, "Harcourt St. 1" },
	{  5259, "Barrow St." },
	{  5260, "L. Pembroke St." },
	{  5261, "Esat Wall D3" },
	{  5262, "Erne Street D2" },
	{  5263, "Courtyard Business Pk., Blackrock" },
	{  5264, "Hogan Place" },
	{  5266, "MAGNETSPI-01" },
	{  5267, "Flemings Place" },
	{  5268, "Tallaght" },
	{  5269, "East Wall Dublin" },
	{  5270, "East Wall Dublin" },
	{  5271, "VoIP Ireland" },
	{  5272, "5272 ESS-INT2-SIG-LTH" },
	{  5273, "London 1" },
	{  5274, "5274 Medius" },
	{  5275, "5275 London 1" },
	{  5276, "5276 London STP 1" },
	{  5277, "5277 Lannet London 2" },
	{  5278, "5278 Lannet London 3" },
	{  5279, "5279 Lannet London 4" },
	{  5280, "Reykjavik/RIC" },
	{  5281, "Reykjavik/MIC" },
	{  5283, "IPF IC" },
	{  5284, "HalloReyk001" },
	{  5285, "Reykjavik/ISAXE" },
	{  5286, "Reykjavik/ISMID" },
	{  5288, "MCI Worldcom - Paris" },
	{  5289, "Azurtel Paris 1" },
	{  5290, "Intercall - Courbevoie" },
	{  5291, "Telia France 1" },
	{  5292, "Cable & Wireless 2" },
	{  5293, "Cable & Wireless 3" },
	{  5294, "Cable & Wireless 4" },
	{  5295, "Numericable - Champs sur Marne" },
	{  5296, "Interxion 1" },
	{  5297, "Completel 1" },
	{  5298, "Tradingcom Europe 2" },
	{  5299, "KPN Eurovoice - Nanterre" },
	{  5300, "Wavecrest - Boulogne 2" },
	{  5301, "Paris Archives - Cisco ITP 3" },
	{  5302, "Reims- Cisco ITP 4" },
	{  5303, "Prosodie 1" },
	{  5304, "3U Telecom 1" },
	{  5305, "Telecom Italia - POP Bordeaux 1" },
	{  5306, "Bouygues Telecom 2" },
	{  5308, "Equant 1" },
	{  5309, "SFR - XC97" },
	{  5310, "Global Crossing 1" },
	{  5311, "Multicoms 1" },
	{  5312, "ISC - Tirana" },
	{  5313, "GMSC - Tirana" },
	{  5314, "GMSC - Tirana 1" },
	{  5315, "GMSC - Tirana" },
	{  5316, "ISC - Durres" },
	{  5317, "GMSC - Tirana 2" },
	{  5318, "GMSC - Tirana" },
	{  5320, "5320 Amsterdam M" },
	{  5321, "5321 Nokia Dx220" },
	{  5322, "LMUK-iSTP3" },
	{  5323, "LMUK-iSTP4" },
	{  5324, "5324 Stratos Netherlands" },
	{  5325, "5325 London STP" },
	{  5326, "5326 Jersey Telenet Ltd 1" },
	{  5327, "5327 Collindale TeS" },
	{  5328, "5328 Birmingham 1" },
	{  5329, "5329 LONDON TH B" },
	{  5330, "5330 Webstar Switch1" },
	{  5331, "5331 Lannet LON" },
	{  5332, "STK2" },
	{  5333, "5333 Slough VoIP1" },
	{  5334, "5334 Docklands VOIP 1" },
	{  5335, "5335 ELARA01" },
	{  5336, "5336 Xgate 2" },
	{  5337, "5337 PG01-LON" },
	{  5338, "5338 Euro Star 1" },
	{  5339, "5339 KJCOPM01" },
	{  5340, "5340 GC Slough 1" },
	{  5341, "Ematel 1" },
	{  5342, "5342 Viafone Birkenhead 1" },
	{  5343, "5343 SMILE 1" },
	{  5344, "St. George's SGG" },
	{  5345, "B'Kara BKG" },
	{  5346, "go1" },
	{  5347, "VOD1-MT" },
	{  5348, "VOD2-MT" },
	{  5349, "Sliema Tandem (SLT)" },
	{  5350, "Zejtun Tandem (ZNT)" },
	{  5351, "3GT" },
	{  5352, "Verona/Via Lungadige Galtarossa, 8" },
	{  5353, "Rozzano 20089 Milanofiori, strada 4, edif. Q" },
	{  5354, "Prato (FL)/via di Grignano 11" },
	{  5355, "Milano/V. le Ortles, 70" },
	{  5356, "Roma, Via Idrovore della Magliana, 163" },
	{  5357, "Milano/V. le Ortles, 70" },
	{  5358, "Milano/ Via Idrovore della Magliana, 163" },
	{  5359, "Porcari (LU)/Via Puccini, 2" },
	{  5360, "Milano Via Farini, 79/81" },
	{  5361, "Roma Via del Tempio 1/A" },
	{  5362, "Pisa A. Bellatalla, 1" },
	{  5363, "Casalecchio del Reno Via Bertocchi, 97 (BO)" },
	{  5364, "Roma/Via Giovanni Vincenzo Bona, 67 Ed.B" },
	{  5365, "Roma Incrocio di via D. Modugmo e M. Mastroianni" },
	{  5366, "Torino Via Nizza, 262 int. 58 c/o Centro Lingotto" },
	{  5367, "Siena/viale Toselli 9/a" },
	{  5368, "Milano/Via E. Jenner 33" },
	{  5369, "Cagliari/SS 195 km 6 Loc. Sa Illetta" },
	{  5370, "Roma/Via Tor Pagnotta 68" },
	{  5371, "Milano/Via Giacosa 19" },
	{  5372, "Milano/Via Caldera, 21" },
	{  5373, "Torino/Corso Moncalieri, 21" },
	{  5374, "Padova/Via Longhin, 97" },
	{  5375, "Pescara/Via Aterno, 34" },
	{  5376, "ACR ITE Nicosia" },
	{  5377, "AMA ITE Limassol" },
	{  5378, "GSM, Nicosia" },
	{  5379, "Callsat NIC1, Nicosia" },
	{  5380, "GSM, Nicosia" },
	{  5381, "ONT-NIC 1, Nicosia" },
	{  5382, "TWX/LIM1, Limassol" },
	{  5383, "OMGTEL-FR, Paris-France" },
	{  5384, "San Jose Adams" },
	{  5385, "Cirpack-1 London" },
	{  5386, "D2C London" },
	{  5387, "Band-X London 1" },
	{  5388, "Teleglobe LHX" },
	{  5389, "London 7" },
	{  5390, "Eircom SQP1" },
	{  5391, "London STP" },
	{  5392, "Singtel London 1" },
	{  5393, "London 1" },
	{  5394, "Poplar Business Park Local" },
	{  5395, "L/TZX/4" },
	{  5396, "London EC2A" },
	{  5397, "Guernsey Castel" },
	{  5398, "Gloucester STP" },
	{  5399, "Mansfield M89" },
	{  5400, "Alias/Capacity point code for STK2 & STC2" },
	{  5401, "Lebara 2" },
	{  5402, "London 2" },
	{  5403, "STPI AIC" },
	{  5404, "CSCP Gateway 1" },
	{  5405, "CSCP Gateway 2" },
	{  5406, "London Poplar" },
	{  5407, "Spacetel UK1" },
	{  5408, "Brentford ISC" },
	{  5409, "London 1" },
	{  5410, "New STP/SSP" },
	{  5411, "New STP/SSP" },
	{  5412, "VOEX-UK-2" },
	{  5413, "LAD10" },
	{  5414, "Feltham 4" },
	{  5415, "UK1" },
	{  5416, "GC Birmingham" },
	{  5417, "VOEX-UK-3" },
	{  5418, "Warrington TeS" },
	{  5419, "London 2" },
	{  5420, "Euro Star 1" },
	{  5421, "LEBARA5" },
	{  5422, "icard1" },
	{  5423, "King John Carrier 1" },
	{  5424, "London 4" },
	{  5425, "Slough" },
	{  5426, "iBasis London 1" },
	{  5427, "Telsis" },
	{  5428, "East India" },
	{  5429, "L/TZX/6" },
	{  5430, "Leeds STP" },
	{  5431, "VOEX-UK-4" },
	{  5432, "BMSTP" },
	{  5433, "Ilford STP" },
	{  5434, "Manchester 1" },
	{  5435, "SU UK 1" },
	{  5436, "SU Uk 2" },
	{  5437, "Budapest 1" },
	{  5438, "Prague 1" },
	{  5439, "London-MSP" },
	{  5440, "TPN" },
	{  5441, "ITE" },
	{  5442, "ITE2" },
	{  5443, "ORBG" },
	{  5444, "SPNET" },
	{  5445, "CBMI" },
	{  5446, "MBEL" },
	{  5447, "MOBX" },
	{  5448, "Qi London 8" },
	{  5449, "GB04" },
	{  5450, "Telehouse 3" },
	{  5451, "HX RFE 1" },
	{  5452, "London 2" },
	{  5453, "MSC 39" },
	{  5454, "Lon-01" },
	{  5455, "Lon-02" },
	{  5456, "Lon-03" },
	{  5457, "Lon-04" },
	{  5458, "5458 RACS-1 London" },
	{  5459, "5459 Cowes 1" },
	{  5460, "5460 Egham 01" },
	{  5461, "5461 Reading STP" },
	{  5462, "5462 King Johns Local" },
	{  5463, "5463 Telehouse 1" },
	{  5464, "Ankara/Eser Telekom" },
	{  5465, "GISAD" },
	{  5466, "Istanbul/Borusan Telekom" },
	{  5468, "Istanbul/Vianet" },
	{  5469, "Istanbul/Superonline" },
	{  5470, "Istanbul/Televersal" },
	{  5472, "Ankara /Ulus/CS2k" },
	{  5473, "Ankara /Ulus/DMS-300" },
	{  5474, "Istanbul/Atakoy/ DMS-300" },
	{  5475, "Izmir/karsryaka DMS-300" },
	{  5476, "Telsim GSM" },
	{  5477, "Ankara/Sogutozu/SOG01" },
	{  5478, "Istanbul/Maltepe/MTG02" },
	{  5479, "Istanbul/Telsim GSM" },
	{  5481, "Istanbul/MISTS01 Avea GSM" },
	{  5482, "Ankara/MULUS01 Avea GSM" },
	{  5483, "Izmir/Avea GSM" },
	{  5484, "Istanbul/MACBS01 Avea GSM" },
	{  5485, "Istanbul/Telsim GSM" },
	{  5486, "Ankara/Telsim GSM" },
	{  5487, "Millenicom" },
	{  5488, "King John Carrier 2" },
	{  5489, "ANS-1 London" },
	{  5490, "Greenwich" },
	{  5491, "Keybridge L/Key/STP1" },
	{  5492, "Madley MDY/STP1" },
	{  5493, "TNXUK London 1" },
	{  5494, "BTL Lon 1" },
	{  5495, "RT8" },
	{  5496, "PROTEI-CAMEL GW" },
	{  5497, "Citrus-1" },
	{  5498, "Birmingham K-58" },
	{  5499, "L/TZX/2" },
	{  5500, "London TIVR 1" },
	{  5501, "SQ2" },
	{  5502, "Birmingham" },
	{  5503, "JM1" },
	{  5504, "Vtec Lon 1" },
	{  5505, "JM2 (1)" },
	{  5506, "Croydon TSC" },
	{  5507, "Park Royal TSC" },
	{  5508, "UK2" },
	{  5509, "London" },
	{  5510, "THN 1" },
	{  5511, "London 1" },
	{  5512, "PROTEI-SMSC" },
	{  5513, "London 5" },
	{  5514, "Plsukdms 1I" },
	{  5515, "Expo and Wavecrest" },
	{  5516, "LDN-1X-2" },
	{  5517, "CISCO 7204 (Main STP Gateway)" },
	{  5518, "Archway STPA" },
	{  5519, "London 1" },
	{  5520, "London 6" },
	{  5521, "STC2" },
	{  5522, "Guernsey Central" },
	{  5523, "LON_01" },
	{  5524, "London 3" },
	{  5525, "Paul Street DMS" },
	{  5526, "C&W Jersey" },
	{  5527, "IRT7" },
	{  5528, "Ans-Thm-1" },
	{  5529, "London 1" },
	{  5530, "..." },
	{  5531, "AIC 1" },
	{  5532, "Watford STP" },
	{  5533, "LONDON CG00T" },
	{  5534, "UNL Lon 1" },
	{  5535, "CISCO 7204 (Back up STP)" },
	{  5536, "..." },
	{  5537, "..." },
	{  5538, "..." },
	{  5539, "..." },
	{  5540, "..." },
	{  5541, ",,," },
	{  5542, "MSC Zagreb" },
	{  5543, "MSC Rijeka" },
	{  5544, "Settingiano (CZ)/Loc. Campo Zona Industriale" },
	{  5545, "Firenze/Via Slataper, 2" },
	{  5546, "Roma/via Tor Pagnotta 68" },
	{  5547, "Segrate (MI)/Via Cassanese, 210" },
	{  5548, "Ronciglione (VT)/Via del Crocefisso, 15" },
	{  5549, "Rimini/via Circonvallazione meridionale 54" },
	{  5550, "Roma/Via Tor Pagnotta 68" },
	{  5551, "Roma/Via Tor Pagnotta 68" },
	{  5552, "IX1 Ljubljana" },
	{  5553, "IX2 Maribor, Tezno" },
	{  5554, "GSM MSC1 Ljubljana" },
	{  5555, "SA-STP Ljubljana" },
	{  5556, "GSM MSC1 Ljubljana" },
	{  5558, "Inlife - LJ1" },
	{  5559, "TUS Telekom d.d. 1" },
	{  5560, "Torino/Via Bologna, 220" },
	{  5561, "Napoli/Centro Direzionale Napoli Isola B5" },
	{  5562, "Modena/Via Ganceto, 154" },
	{  5563, "Trezzano sul Naviglio/Via Benvenuto Cellini, 1" },
	{  5564, "Roma/Via G. Bona, 67" },
	{  5565, "Milano/Via Ugo Bassi, 2" },
	{  5566, "Calenzano (FI)/Via V. Emanuele, 14" },
	{  5567, "Milano/Via S. Giusto, 51" },
	{  5569, "San Marino" },
	{  5570, "RSM-SMT-0" },
	{  5571, "RSM-SMT-01" },
	{  5573, "NETSETRA 1" },
	{  5576, "Colt London Marylebone" },
	{  5577, "L/TZX/3" },
	{  5578, "PROTEI-SMS GW" },
	{  5579, "KDD-E LDN1" },
	{  5580, "..." },
	{  5581, "London Keybridge Intelligent Routing Platform" },
	{  5582, "TSC 90" },
	{  5583, "London 1" },
	{  5584, "JE/TXD" },
	{  5585, "JE/E" },
	{  5586, "JE/TRS/MSX" },
	{  5587, "Vital 2" },
	{  5588, "Ldnux 3" },
	{  5589, "NSOFT 1" },
	{  5590, "Leodis Court" },
	{  5591, "L/TZX/1" },
	{  5592, "Manchester ISC" },
	{  5593, "London Docklands" },
	{  5594, "MSC 21" },
	{  5595, "Ans-Hk-1" },
	{  5596, "London 1" },
	{  5597, "Citycom 1" },
	{  5598, "London 4" },
	{  5599, "LEBARA6" },
	{  5600, "New STP/SSP" },
	{  5601, "MSC 50" },
	{  5602, "London Global Switch TES" },
	{  5603, "Goonhilly Inmarsat 2" },
	{  5604, "LDNSTP1" },
	{  5605, "LDNSTP2" },
	{  5606, "LDNMSC1" },
	{  5607, "London 1" },
	{  5608, "DALON2" },
	{  5609, "MSC 53" },
	{  5610, "London 3" },
	{  5611, "MSC01" },
	{  5612, "Radlett TSC" },
	{  5613, "Sunbury TSC" },
	{  5614, "CW IOM No.1" },
	{  5615, "London 1" },
	{  5616, "Birmingham STP" },
	{  5617, "LONUK 1" },
	{  5618, "London 3" },
	{  5619, "Europe 2" },
	{  5620, "Squire 1" },
	{  5621, "Douglas 1" },
	{  5622, "London Bishopsgate" },
	{  5623, "London City" },
	{  5624, "LONDON 2" },
	{  5625, "Tufnell Park AXD" },
	{  5626, "Luton int" },
	{  5627, "Basingstoke" },
	{  5628, "London Leman Street" },
	{  5629, "London 1" },
	{  5630, "JE/N/STP" },
	{  5631, "L/TZX/5" },
	{  5632, "STH-TSC-1 (Stockholm)" },
	{  5633, "Stockholm (SWEST01)" },
	{  5634, "Stockholm (STE1)" },
	{  5635, "Stockholm (HY7M MSC)" },
	{  5636, "Stockholm (SK3M MSC)" },
	{  5637, "Stockholm (STE2)" },
	{  5638, "SNKT2-INT (Stockholm)" },
	{  5639, "Stockholm (VMS2)" },
	{  5640, "Stockholm (WCOMSTHLM1)" },
	{  5641, "Stockholm (STO/TN1)" },
	{  5642, "Goteborg (GTO/TN1)" },
	{  5643, "Stockholm (RSL-SWE)" },
	{  5644, "Stockholm (VTP)" },
	{  5645, "Goteborg (SAV)" },
	{  5646, "Stockholm (GOSTO)" },
	{  5647, "STO-B1-GMSC01 (Stockholm)" },
	{  5648, "SOLTELINT-1 (Solleftea)" },
	{  5649, "Stockholm (Stockholm COLT SWE1)" },
	{  5650, "SH-B-MSC08 (Stockholm)" },
	{  5651, "ML-BRO-MSC10 (Goteborg)" },
	{  5652, "KK-B-SRR1 (Karlskrona)" },
	{  5653, "GB-BA-SRR2 (Goteborg)" },
	{  5654, "KA-B1-GMSC01 (Karlskrona)" },
	{  5655, "MGW 161 (Stockholm)" },
	{  5656, "Stockholm (MSC101)" },
	{  5657, "Stockholm (MGW101)" },
	{  5658, "KK-GRA-MSS2 (Karlskrona)" },
	{  5659, "Hallsberg (MSC1)" },
	{  5660, "Stockholm (SWEST02)" },
	{  5661, "Karlskrona (STP1)" },
	{  5662, "Stockholm (STP2)" },
	{  5663, "Stockholm (MSC1)" },
	{  5665, "Andorra AXE" },
	{  5680, "AMSCA, Amsterdam" },
	{  5681, "GVCA01, Den Haag" },
	{  5682, "RMSGW1, Rotterdam" },
	{  5683, "AMS001GSX1 Amsterdam" },
	{  5684, "AMSTNLVE03L, Amsterdam" },
	{  5685, "RTRDNLVE02L, Rotterdam" },
	{  5686, "RTRDNLVE01L, Rotterdam" },
	{  5687, "EZP-AMS02, Amsterdam" },
	{  5688, "Tallinn" },
	{  5689, "Tallinn" },
	{  5690, "Tallinn" },
	{  5691, "Tallinn" },
	{  5692, "Tallinn" },
	{  5694, "Tallinn" },
	{  5695, "Tallinn" },
	{  5696, "Arminco" },
	{  5697, "Yerevan" },
	{  5698, "ARMGSM" },
	{  5699, "Orange" },
	{  5700, "PMPSI" },
	{  5701, "KTPSI" },
	{  5702, "KTPSI" },
	{  5703, "Cornet-AM" },
	{  5704, "Telecom Italia - POP Nantes 1" },
	{  5705, "SFR - XA08 - Aubervilliers" },
	{  5706, "Colt 2" },
	{  5707, "Colt 3" },
	{  5708, "IBasis 1" },
	{  5709, "SFR - XC64 - Velizy" },
	{  5710, "Dauphin Telecom 2" },
	{  5711, "Bagnolet - NGN BG6" },
	{  5712, "Telecom Italia - POP Strasbourg 1" },
	{  5713, "SFR - XB89 - Puteaux" },
	{  5714, "Completel 2" },
	{  5715, "Paris Archives - International Gateway Point No4" },
	{  5716, "Reims - International Gateway Point No 3" },
	{  5717, "Paris Archives" },
	{  5718, "Midi Telecom - Nanterre" },
	{  5719, "PTSI Paris" },
	{  5720, "Lyon - Call Server VoIP YK02" },
	{  5721, "Telehouse Paris" },
	{  5723, "XC27" },
	{  5724, "XD13" },
	{  5725, "Outremer Telecom - Paris" },
	{  5726, "Telemedia Paris 2" },
	{  5727, "SFR - Mitry-03" },
	{  5728, "Minsk, EWSD" },
	{  5729, "Borisov, AXE-10" },
	{  5737, "GN 1B (Trollhattan)" },
	{  5738, "Linkoping (SWE-LINK01)" },
	{  5739, "Stockholm (SWE-STHLM01)" },
	{  5740, "Stockholm (STH1)" },
	{  5741, "Linkoping (EuSWE1)" },
	{  5744, "Vivodi Athens ISC/1" },
	{  5745, "Telepassport Hellas ISCII-G1" },
	{  5746, "Athens-int01" },
	{  5747, "NetOne S.A. Athens Greece" },
	{  5748, "Voicenet/ATH1" },
	{  5749, "Athens/TL1" },
	{  5750, "Thessal/TL1" },
	{  5751, "RGATHXLI1" },
	{  5752, "Palermo/Via A. De Gasperi, 50" },
	{  5753, "Milano/Via Caldera, 21" },
	{  5754, "Cagliari/Via dei Grilli 1/3" },
	{  5755, "Bari/Via Nickman, 19" },
	{  5756, "Catania/Via Conte di Torino, 64" },
	{  5757, "Bolzano/Via Pacinotti, 12" },
	{  5758, "Cagliari/Via E. Mells, 26" },
	{  5759, "Pisa/via Malagoli 12" },
	{  5760, "Tbilisi, International Exchange" },
	{  5761, "Tbilisi, International Exchange" },
	{  5762, "Tbilisi, Mobile Switching Centre" },
	{  5763, "Tbilisi, Mobile Switching Centre" },
	{  5764, "..." },
	{  5765, "..." },
	{  5766, "Tbilisi" },
	{  5767, "..." },
	{  5768, "N2P Uk1" },
	{  5769, "Southern Transit" },
	{  5770, "Midlands Transit" },
	{  5771, "Northern Transit" },
	{  5772, "Yorkshire Transit" },
	{  5773, "LND 01 Docklands" },
	{  5774, "LND 02" },
	{  5775, "Switchports1" },
	{  5776, "LONDENCI01T" },
	{  5777, "GWT Ltd 1" },
	{  5778, "Lannet London 5" },
	{  5779, "LMUK-MSC1" },
	{  5780, "London 1" },
	{  5781, "London Poplar" },
	{  5782, "SLN001" },
	{  5783, "Beult" },
	{  5784, "BM1" },
	{  5785, "M64" },
	{  5786, "London" },
	{  5787, "Fulhum" },
	{  5788, "iCard 2" },
	{  5789, "Vital 1" },
	{  5790, "London 1" },
	{  5791, "Beckton GMSC1" },
	{  5792, "Budaors DN01" },
	{  5793, "Monor_INT1" },
	{  5794, "INV-DUN-LE" },
	{  5795, "W-INT-GW1" },
	{  5796, "W-INT-GW2" },
	{  5797, "Budapest PTL02" },
	{  5798, "Pannon INT 1" },
	{  5799, "Budapest -= CSINFO 2" },
	{  5800, "..." },
	{  5801, "..." },
	{  5802, "..." },
	{  5803, "Tbilisi" },
	{  5804, "..." },
	{  5806, "Tbilisi" },
	{  5807, "Tbilisi" },
	{  5808, "Kyiv" },
	{  5809, "Lviv" },
	{  5810, "..." },
	{  5811, "Odessa" },
	{  5812, "Kyiv" },
	{  5813, "Kyiv" },
	{  5814, "Kyiv" },
	{  5815, "Kyiv" },
	{  5816, "Roma/Via Casilina Vecchia, 4c/o Stazione Tuscolana" },
	{  5817, "Bologna/v. le C. Berti Pichat 2/4" },
	{  5818, "Verona/Via del Perlar, 26" },
	{  5819, "Roma/via Alessandro Severo 245" },
	{  5820, "Bergamo/via Stendhal 3" },
	{  5821, "Milano/via Giacosa 19" },
	{  5822, "Milano/via Giacosa 19" },
	{  5823, "Milano/via Giacosa 19" },
	{  5824, "Roma/Via F. Depero, 70" },
	{  5825, "Milano/Via U. Bassi, 2" },
	{  5826, "Milano/Via Tortona, 31" },
	{  5827, "Roma/Via G.V. Bona, 67" },
	{  5828, "Roma/Via G.V. Bona, 67" },
	{  5829, "Milano/Via Ugo Bassi, 2" },
	{  5830, "Kyiv" },
	{  5831, "Cerasolo(Rimini)/Via Ausa, 70" },
	{  5833, "Copenhagen" },
	{  5840, "IATC SA1/Sarajevo" },
	{  5841, "IATC SA2/Sarajevo" },
	{  5842, "SS MNC SA3" },
	{  5843, "Siroki Brijeg" },
	{  5844, "Banjaluka MN1" },
	{  5845, "Banjaluka MN2" },
	{  5846, "Sarajevo/STPSA" },
	{  5847, "Zenica/STPZE" },
	{  5848, "T3/SA1 Sarajevo" },
	{  5849, "AirABA/SA1 Sarajevo" },
	{  5850, "Logosoft/ SA1 Sarajevo" },
	{  5851, "CGBN1 Bijeljina" },
	{  5852, "Akt.Ol./Sa1 Sarajevo" },
	{  5853, "BAEPNSA1 Sarajevo" },
	{  5854, "Aneks/BL1 Banjaluka" },
	{  5855, "MH-INAt-33 Sarajevo" },
	{  5856, "STP Skopje" },
	{  5857, "SK2" },
	{  5858, "ST" },
	{  5859, "STP Skopje" },
	{  5860, "STP Stip" },
	{  5861, "MSC1INT" },
	{  5862, "STP Skopje" },
	{  5863, "STP Skopje" },
	{  5864, "Reims - Call Server VoIP YK01" },
	{  5865, "Paris Pastourelle - Call Server VoIP YK00" },
	{  5867, "SFR -Mitry-04" },
	{  5868, "SFR -Corbas-01" },
	{  5870, "Transatel - Paris 2" },
	{  5872, "60326 Frankfurt" },
	{  5873, "Frankfurt" },
	{  5874, "60326 Frankfurt" },
	{  5875, "60326 Frankfurt" },
	{  5876, "10707 Berlin" },
	{  5877, "60327 Frankfurt" },
	{  5878, "60326 Frankfurt" },
	{  5879, "10245 Berlin" },
	{  5880, "LSBNPTCB01V, Palmela" },
	{  5881, "ESTRPOCB02V, Estarreja" },
	{  5882, "G9S01" },
	{  5883, "G9S02" },
	{  5884, "Lisboa - LISBSC1" },
	{  5885, "Lisboa - LISBSC2" },
	{  5886, "Lisboa" },
	{  5888, "Chisinau" },
	{  5889, "Balti" },
	{  5890, "Chisinau" },
	{  5892, "Chisinau" },
	{  5894, "Chisinau" },
	{  5895, "Chisinau" },
	{  5896, "Frankfurt" },
	{  5897, "60326 Frankfurt" },
	{  5898, "Frankfurt" },
	{  5899, "Frankfurt" },
	{  5900, "Muchen" },
	{  5901, "Dusseldorf" },
	{  5902, "Muchen" },
	{  5903, "Frankfurt" },
	{  5904, "Frankfurt" },
	{  5905, "60437 Frankfurt" },
	{  5906, "40237 Dusseldorf" },
	{  5907, "Hamburg" },
	{  5908, "Frankfurt" },
	{  5909, "Dusseldorf" },
	{  5910, "Dusseldorf" },
	{  5911, "Frankfurt" },
	{  5912, "..." },
	{  5913, "..." },
	{  5914, "..." },
	{  5915, "..." },
	{  5916, "..." },
	{  5917, "..." },
	{  5918, "..." },
	{  5919, "..." },
	{  5920, "Common SPC for the first couple SA-SPT" },
	{  5921, "Praha, SA-STP" },
	{  5922, "Brno, SA STP" },
	{  5923, "SA 1 ET" },
	{  5924, "SA 2 ET" },
	{  5925, "802 MATTES AD" },
	{  5926, "CEZnet Praha CZ" },
	{  5927, "MGWPRK 1" },
	{  5928, "BT Czech Republic" },
	{  5929, "Praha, International exchange" },
	{  5930, "Brno, International exchange" },
	{  5932, "Praha CS" },
	{  5933, "Brno CS" },
	{  5934, "GTSDMS" },
	{  5935, "GTSCS2K" },
	{  5936, "Pragonet Praha CZ" },
	{  5937, "MSS HRK 1" },
	{  5938, "Brno A" },
	{  5939, "MSC Praha" },
	{  5940, "MSC Brno" },
	{  5941, "TMSC Praha Q01PG" },
	{  5942, "TMSC Praha Q02PG" },
	{  5943, "MSS BRN" },
	{  5944, "MSC Praha F" },
	{  5945, "MSC Praha G" },
	{  5946, "MGW PRK 1" },
	{  5947, "GIGA" },
	{  5948, "SRP1 Praha" },
	{  5949, "SRP2 Brno" },
	{  5950, "COL Praha CZ" },
	{  5951, "MGW PRC 1" },
	{  5952, "ISC Bratislava" },
	{  5953, "Bratislava, international gateway" },
	{  5954, "Banska Bystrica, international gateway" },
	{  5955, "ISC Bratislava" },
	{  5956, "SA STP" },
	{  5957, "SA STP" },
	{  5958, "LES12 Bratislava Test 3" },
	{  5959, "LES12 Bratislava Test 2" },
	{  5960, "STP GTS Nextra, Bratislava" },
	{  5961, "ISC Bratislava" },
	{  5962, "ISC Bratislava" },
	{  5963, "ISC Bratislava" },
	{  5964, "ISC Bratislava" },
	{  5965, "ISC/softswitch Bratislava" },
	{  5967, "ISC Bratislava" },
	{  5968, "ISC Bratislava" },
	{  5969, "MSC1 Banska Bystrica" },
	{  5970, "ISC Bratislava" },
	{  5971, "MSC7 Bratislava" },
	{  5972, "MSC5 Banska Bystrica" },
	{  5973, "MSC2 Bratislava" },
	{  5974, "ISC Bratislava" },
	{  5975, "ISC Bratislava" },
	{  5976, "Bratislava, NMT" },
	{  5977, "Banska Bystrica, GSM MSC1" },
	{  5978, "Bratislava, GSM MSC1" },
	{  5979, "Bratislava, GSM MSC2" },
	{  5980, "Banska Bystrica, GSM MSC2" },
	{  5981, "Bratislava, GSM MSC3" },
	{  5982, "MSC1 Bratislava" },
	{  5983, "Kosice, GSM MSC4" },
	{  5984, "..." },
	{  5985, "..." },
	{  5986, "..." },
	{  5987, "..." },
	{  5988, "..." },
	{  5989, "..." },
	{  5990, "..." },
	{  5991, "..." },
	{  5992, "Madrid-Atocha" },
	{  5993, "Madrid-Bellas Vistas" },
	{  5994, "Barcelona-Guipuzcoa" },
	{  5995, "Barcelona-Cerda" },
	{  5996, "Madrid" },
	{  5997, "Madrid STP1" },
	{  5998, "Madrid" },
	{  5999, "Madrid" },
	{  6000, "Barcelona" },
	{  6001, "Barcelona" },
	{  6002, "Madrid" },
	{  6003, "Madrid" },
	{  6004, "Madrid" },
	{  6005, "Barcelona" },
	{  6006, "Madrid" },
	{  6007, "Barcelona" },
	{  6008, "Madrid" },
	{  6009, "Madrid" },
	{  6010, "Barcelona" },
	{  6011, "Madrid" },
	{  6012, "Valencia" },
	{  6013, "Madrid" },
	{  6014, "Barcelona" },
	{  6015, "Madrid" },
	{  6016, "Madrid" },
	{  6017, "Madrid" },
	{  6018, "Madrid" },
	{  6019, "San Fernando de Henares" },
	{  6020, "Barcelona" },
	{  6021, "Madrid" },
	{  6022, "Barcelona" },
	{  6023, "Madrid" },
	{  6024, "Valladolid" },
	{  6025, "Madrid" },
	{  6026, "Barcelona" },
	{  6027, "Madrid" },
	{  6028, "Madrid" },
	{  6029, "Barcelona" },
	{  6030, "Madrid" },
	{  6031, "Madrid" },
	{  6032, "Munchen" },
	{  6033, "Frankfurt" },
	{  6034, "Hamburg" },
	{  6035, "Frankfurt" },
	{  6036, "..." },
	{  6037, "..." },
	{  6038, "Ratingen" },
	{  6039, "Frankfurt" },
	{  6040, "Dortmund" },
	{  6041, "Dusseldorf" },
	{  6042, "Frankfurt" },
	{  6043, "Frankfurt" },
	{  6044, "Dusseldorf" },
	{  6045, "Frankfurt" },
	{  6046, "Frankfurt" },
	{  6047, "Frankfurt" },
	{  6048, "Stutgart" },
	{  6049, "Dusseldorf" },
	{  6050, "Dusseldorf" },
	{  6051, "Frankfurt" },
	{  6052, "OSS Crowford" },
	{  6053, "Frankfurt" },
	{  6054, "Frankfurt" },
	{  6055, "Frankfurt" },
	{  6056, "Dusseldorf" },
	{  6057, "Munchen" },
	{  6058, "Hamburg" },
	{  6059, "Dusseldorf" },
	{  6060, "Frankfurt am Main" },
	{  6061, "Frankfurt am Main" },
	{  6062, "Frankfurt am Main" },
	{  6063, "Flensburg" },
	{  6064, "Frankfurt am Main" },
	{  6065, "Koln" },
	{  6066, "Frankfurt am Main" },
	{  6067, "Frankfurt am Main" },
	{  6068, "Hamburg" },
	{  6069, "Frankfurt am Main" },
	{  6070, "Frankfurt am Main" },
	{  6071, "Karlsruhe-Daxlanden" },
	{  6072, "Hamburg" },
	{  6073, "Hamburg" },
	{  6074, "Frankfurt am Main" },
	{  6075, "Frankfurt" },
	{  6076, "Berlin" },
	{  6077, "Frankfurt am Main" },
	{  6078, "Frankfurt am Main" },
	{  6079, "Mannheim" },
	{  6080, "Frankfurt" },
	{  6081, "Dusseldorf" },
	{  6082, "Frankfurt am Main" },
	{  6083, "Aachen" },
	{  6084, "Hamburg" },
	{  6085, "Dusseldorf" },
	{  6086, "Frankfurt" },
	{  6087, "13509 Berlin" },
	{  6088, "Hilden" },
	{  6089, "Frankfurt am Main" },
	{  6090, "Hamburg" },
	{  6091, "Frankfurt am Main" },
	{  6092, "Hilden" },
	{  6093, "Franfurt am Main" },
	{  6094, "Dusseldorf" },
	{  6095, "Frankfurt am Main" },
	{  6096, "Frankfurt am Main" },
	{  6097, "Frankfurt am Main" },
	{  6098, "Volklingen-Geislautern" },
	{  6099, "Frankfurt am Main" },
	{  6100, "Dusseldorf" },
	{  6101, "Berlin" },
	{  6102, "Frankfurt am Main" },
	{  6103, "Stuttgart" },
	{  6104, "Hamburg" },
	{  6105, "Frankfurt am Main" },
	{  6106, "Berlin" },
	{  6107, "Frankfurt" },
	{  6108, "Hannover" },
	{  6109, "Hamburg" },
	{  6110, "Frankfurt am Main" },
	{  6111, "Frankfurt am Main" },
	{  6112, "Frankfurt am Main" },
	{  6113, "Muchen" },
	{  6114, "Essen" },
	{  6115, "Hannover" },
	{  6116, "Leinfelden Echterdingen" },
	{  6117, "Frankfurt am Main" },
	{  6118, "Dusseldorf" },
	{  6119, "Dusseldorf" },
	{  6120, "QUNL01, Zoetermeer" },
	{  6121, "Node-Amsterdam, Amsterdam" },
	{  6122, "ION1, Amsterdam" },
	{  6123, "amlSSP, Schiphol-Rijk" },
	{  6124, "rolSSP, Rotterdam" },
	{  6125, "ASDSTP, Amsterdam" },
	{  6126, "NL-switch, Amsterdam" },
	{  6127, "C2C, Biddinghuizen" },
	{  6128, "Helsinki (HELSINKI2 STP)" },
	{  6129, "Helsinki (GOFIN1)" },
	{  6130, "Helsinki (Globetel1)" },
	{  6131, "Espoo (RSLCOM2)" },
	{  6132, "Helsinki (BCF1)" },
	{  6133, "Lappeenranta (Teldamatic 1)" },
	{  6134, "Helsinki (FCI2)" },
	{  6135, "Helsinki (HEL1)" },
	{  6136, "Helsinki (Nevatel-1)" },
	{  6137, "Helsinki (SET1)" },
	{  6138, "Espoo (ESPOO2)" },
	{  6139, "Lahti (LAHMSC1)" },
	{  6141, "Vaasa (VAAMSC2)" },
	{  6142, "Helsinki (TELE5)" },
	{  6143, "Vantaa (HKIGMSC01)" },
	{  6176, "VPA1" },
	{  6177, "VPD1" },
	{  6178, "reserve/reserved/reservado" },
	{  6179, "reserve/reserved/reservado" },
	{  6180, "VPC3" },
	{  6181, "reserve/reserved/reservado" },
	{  6182, "T6X1" },
	{  6183, "TCU" },
	{  6184, "TTP1" },
	{  6185, "..." },
	{  6186, "VPC1" },
	{  6187, "TTP1" },
	{  6188, "TOR2" },
	{  6189, "TOR2" },
	{  6190, "..." },
	{  6191, "reserve/reserved/reservado" },
	{  6192, "MTP1" },
	{  6193, "LBM1" },
	{  6194, "MTL2" },
	{  6195, "reserve/reserved/reservado" },
	{  6196, "MTL2" },
	{  6197, "..." },
	{  6198, "..." },
	{  6199, "..." },
	{  6200, "DMS-250-Toronto 13" },
	{  6201, "DMS-250-Toronto 14" },
	{  6202, "Toronto STP" },
	{  6203, "Montreal DMS - 250" },
	{  6204, "G_MSC-Creekbank" },
	{  6205, "SGSN-Creekbank" },
	{  6206, "Vancouver DMS-250" },
	{  6207, "Telus Communications Inc." },
	{  6208, "Rexdale" },
	{  6209, "Toronto" },
	{  6210, "Toronto - Mathew" },
	{  6211, "CLGRAB2116W" },
	{  6212, "EDTNAB0214W" },
	{  6213, "Ericsson Trans Local Axe-10, Toronto" },
	{  6214, "YVRLX20 (London, United Kingdom)" },
	{  6215, "Alcatel DSC 600E" },
	{  6216, "Siemens DCO" },
	{  6217, "VANCBC0802T" },
	{  6218, "VAN IPTC-1" },
	{  6219, "TOR IPTC-1" },
	{  6220, "TOR IPTC-2" },
	{  6221, "MTL IPTC-1" },
	{  6222, "MTL IPTC-2" },
	{  6224, "EYRKONAE01T" },
	{  6225, "Smiths Falls Gateway" },
	{  6226, "..." },
	{  6227, "A4C1" },
	{  6228, "A5C1" },
	{  6229, "FYV1" },
	{  6230, "reserved" },
	{  6231, "VPP1" },
	{  6232, "LDP1" },
	{  6233, "FVP1" },
	{  6234, "SGX SSP (Scarborough, Ontario)" },
	{  6235, "GSX1 SSP (Scarborough, Ontario)" },
	{  6236, "GSX2 SSP (Scarborough, Ontario)" },
	{  6237, "GSX3 SSP (Scarborough, Ontario)" },
	{  6238, "SGX SSP (Montreal, Quebec)" },
	{  6239, "GSX1 SSP (Montreal, Quebec)" },
	{  6240, "GSX2 SSP (Montreal, Quebec)" },
	{  6241, "GSX3 SSP (Montreal, Quebec)" },
	{  6242, "RMHLONBICA5 (Richmond Hill, Ontario)" },
	{  6243, "3000 (CLLI: TOROONXN18T), Toronto, Ontario" },
	{  6244, "MXQ95301JM, Calgary - Alberta" },
	{  6272, "St. Pierre-et-Miquelon E10" },
	{  6288, "NUK-MC_INT" },
	{  6289, "CTP-1_INT" },
	{  6290, "CTP-2_INT" },
	{  6304, "New York, NY" },
	{  6305, "White Plains, NY" },
	{  6306, "Pittsburg, PA" },
	{  6307, "White Plains, NY" },
	{  6308, "Sacramento, CA" },
	{  6309, "Sherman Oaks" },
	{  6310, "San Diego" },
	{  6311, "Warrenville, IL" },
	{  6312, "West Orange (2), NJ" },
	{  6313, "Sacramento, CA" },
	{  6314, "Pottstown, PA" },
	{  6315, "Reston, VA" },
	{  6316, "West Orange, NJ" },
	{  6317, "Dominguez Hills, CA" },
	{  6318, "San Antonio, TX" },
	{  6319, "Pottstown, PA" },
	{  6320, "Richardson, TX" },
	{  6321, "Pompano Beach, FL" },
	{  6322, "Pottstown, PA" },
	{  6323, "Pompano Beach, FL" },
	{  6324, "West Orange, NJ" },
	{  6325, "Dominguez Hills, CA" },
	{  6326, "San Antonio, TX" },
	{  6327, "Pottstown, PA" },
	{  6328, "Sacramento, CA" },
	{  6329, "Sherman Oaks" },
	{  6330, "Pittsburg, PA" },
	{  6331, "Atlanta" },
	{  6332, "New York, NY" },
	{  6333, "Honolulu, HI" },
	{  6334, "Stockton" },
	{  6335, "Dominguez Hills (1), CA" },
	{  6336, "Dominguez Hills (2), CA" },
	{  6337, "Irving (1), TX" },
	{  6338, "New York, NY" },
	{  6339, "Los Angeles, CA" },
	{  6340, "Fort Worth" },
	{  6341, "Stockton(2)" },
	{  6342, "Fort Worth(2)" },
	{  6343, "Pittsburg(3), PA" },
	{  6344, "Warrenville (2)" },
	{  6345, "Warrenville (3)" },
	{  6346, "Norway" },
	{  6347, "Albuquerque" },
	{  6348, "San Antonio" },
	{  6349, "Honolulu, HI" },
	{  6350, "Los Angeles (1), CA" },
	{  6351, "Los Angeles (2), CA" },
	{  6352, "New York City, NY" },
	{  6353, "Los Angeles, CA" },
	{  6354, "Houston, TX" },
	{  6355, "Reston, VA" },
	{  6356, "Los Angeles, CA" },
	{  6357, "Houston, TX" },
	{  6358, "Caparra, PR" },
	{  6359, "New York, NY" },
	{  6360, "Miami, FL" },
	{  6361, "Los Angeles, CA" },
	{  6362, "Garden City, NY" },
	{  6363, "Los Angeles (2),CA" },
	{  6364, "Los Angeles, CA" },
	{  6365, "Miami, FL" },
	{  6366, "Miami, FL" },
	{  6367, "New York, NY" },
	{  6368, "New York, NY" },
	{  6369, "Los Angeles, CA" },
	{  6370, "Piscataway, NJ" },
	{  6371, "Sawgrass, FL" },
	{  6372, "Hollywood, FL" },
	{  6373, "Miami, FL" },
	{  6374, "Garden City, NY" },
	{  6375, "Ft. Lauderdale, FL (STP)" },
	{  6376, "Ft. Lauderdale FL (Gateway)" },
	{  6377, "New York, NY (STP)" },
	{  6378, "New York, NY (Gateway)" },
	{  6379, "San Juan, Puerto Rico" },
	{  6380, "Miami, FL" },
	{  6381, "New York, NY" },
	{  6382, "Dallas, TX" },
	{  6383, "Olympia, WA" },
	{  6384, "Miami, FL" },
	{  6385, "Temple Terrace (1), FL" },
	{  6386, "Temple Terrace (2), FL" },
	{  6387, "Temple Terrace (3), FL" },
	{  6388, "Temple Terrace (4), FL" },
	{  6389, "Temple Terrace (5), FL" },
	{  6390, "Temple Terrace (6), FL" },
	{  6391, "Los Angeles, CA" },
	{  6392, "Temple Terrace, FL" },
	{  6393, "New York, NY" },
	{  6394, "San Francisco, CA" },
	{  6395, "Newark, NJ" },
	{  6396, "New York City, NY" },
	{  6397, "Washington DC" },
	{  6398, "Honolulu (2), HI" },
	{  6399, "Honolulu (3), HI" },
	{  6400, "Los Angeles, CA" },
	{  6401, "Jersey City, NJ" },
	{  6402, "West Orange (1), NJ" },
	{  6403, "Irving (2), TX" },
	{  6404, "Pompano Beach, FL" },
	{  6405, "Pompano Beach, FL" },
	{  6406, "Chandler (1), AZ" },
	{  6407, "Chandler (2), AZ" },
	{  6408, "Tempe, AZ" },
	{  6409, "New York, NY" },
	{  6410, "New York (2), NY" },
	{  6411, "Los Angeles,CA" },
	{  6412, "New York, NY" },
	{  6413, "Miami, FL" },
	{  6414, "Southbury, CT" },
	{  6415, "Santa Paula, CA" },
	{  6416, "Miami, FL" },
	{  6417, "New York, NY" },
	{  6418, "New York, NY" },
	{  6419, "New York, NY(2)" },
	{  6420, "Dallas, TX" },
	{  6421, "Los Angeles, CA" },
	{  6422, "McLean, VA" },
	{  6423, "Newark, NJ" },
	{  6424, "Piscataway, NJ" },
	{  6425, "New York, NY" },
	{  6426, "Dallas, TX" },
	{  6427, "Burlingame, CA" },
	{  6428, "Newark, NJ" },
	{  6429, "New York (1), NY" },
	{  6430, "New York (2), NY" },
	{  6431, "Wentzville, MO" },
	{  6432, "O'Fallon, MO" },
	{  6433, "New York (9), NY" },
	{  6434, "New York (3), NY" },
	{  6435, "Los Angeles (2), CA" },
	{  6436, "Miami (1), FL" },
	{  6437, "Miami (2), FL" },
	{  6438, "Miami (3), FL" },
	{  6439, "Miami, FL" },
	{  6440, "Pittsburgh, PA" },
	{  6441, "Pittsburg, PA" },
	{  6442, "White Plains, NY" },
	{  6443, "Sacramento, CA" },
	{  6444, "Sherman Oaks, CA" },
	{  6445, "Atlanta, GA" },
	{  6446, "White Plains, NY" },
	{  6447, "White Plains, NY" },
	{  6448, "Miami, FL" },
	{  6449, "New York, NY" },
	{  6450, "Miami (1), FL" },
	{  6451, "New York, NY" },
	{  6452, "San Francisco, CA" },
	{  6453, "Miami, FL" },
	{  6454, "New York, NY" },
	{  6455, "New York, NY" },
	{  6456, "Miami, FL" },
	{  6457, "Buffalo, NY" },
	{  6458, "New York, NY" },
	{  6459, "Jersey City, NJ" },
	{  6460, "Miami, FL" },
	{  6461, "Miami, FL" },
	{  6462, "New York, NY" },
	{  6463, "New York, NY" },
	{  6464, "Miami, FL" },
	{  6465, "New York, NY" },
	{  6466, "Miami, FL" },
	{  6467, "New York, NY" },
	{  6468, "Piscataway, NJ" },
	{  6469, "Washington, D.C." },
	{  6470, "Piscataway, NJ" },
	{  6471, "New York, NY" },
	{  6472, "New York, NY" },
	{  6473, "Los Angeles, CA" },
	{  6474, "Jersey City, NJ" },
	{  6475, "d/b/a GSI Telecom, Jersey City, NJ" },
	{  6476, "Jersey City, NJ" },
	{  6477, "New York City, NY" },
	{  6478, "New York, NY" },
	{  6479, "Quincy, MA" },
	{  6480, "Orlando, FL" },
	{  6481, "Los Angeles, CA" },
	{  6482, "Atlanta, GA" },
	{  6483, "Tucker, GA" },
	{  6484, "Los Angeles, CA" },
	{  6485, "Los Angeles, CA" },
	{  6486, "Denver, CO" },
	{  6487, "New York, NY" },
	{  6488, "Mc Lean, VA" },
	{  6489, "New York, NY" },
	{  6490, "Miami, FL" },
	{  6491, "New York, NY" },
	{  6492, "Los Angeles, CA" },
	{  6493, "Miami, FL" },
	{  6494, "Boston, MA" },
	{  6495, "New York, NY" },
	{  6496, "Miami, FL" },
	{  6497, "Los Angeles, CA" },
	{  6498, "Los Angeles, CA" },
	{  6499, "Los Angeles, CA" },
	{  6500, "Los Angeles, CA" },
	{  6501, "Los Angeles, CA" },
	{  6502, "New York, NY" },
	{  6503, "New York, NY" },
	{  6504, "Los Angeles, CA" },
	{  6505, "Richardson, TX" },
	{  6506, "Richardson , TX" },
	{  6507, "Pottstown, PA" },
	{  6508, "Pompano Beach (2), FL" },
	{  6509, "Hayward, CA" },
	{  6510, "Jersey City (1), NJ" },
	{  6511, "Jersey City (2), NJ" },
	{  6512, "Atlanta, GA" },
	{  6513, "Sunnyvale, CA" },
	{  6514, "Dublin, OH" },
	{  6515, "Houston, TX" },
	{  6516, "Dublin, OH" },
	{  6517, "Houston, TX" },
	{  6518, "New York, NY" },
	{  6519, "Los Angeles, CA" },
	{  6520, "Los Angeles, CA" },
	{  6521, "Los Angeles, CA" },
	{  6522, "Manhattan, NY" },
	{  6523, "Los Angeles, CA" },
	{  6524, "Piscataway, NJ" },
	{  6525, "New York (1), NY" },
	{  6526, "New York (2), NY" },
	{  6527, "College Park (1), GA" },
	{  6528, "Atlanta, GA" },
	{  6529, "College Park (2), GA" },
	{  6530, "Homestead, FL" },
	{  6531, "Piscataway, NJ" },
	{  6532, "Los Angeles, CA" },
	{  6533, "New York, NY" },
	{  6534, "San Francisco, CA" },
	{  6535, "New York, NY" },
	{  6536, "New York, NY" },
	{  6537, "Los Angeles (2), CA" },
	{  6538, "Los Angeles (3), CA" },
	{  6539, "Los Angeles (4), CA" },
	{  6540, "New York (1), NY" },
	{  6541, "Piscataway, NJ" },
	{  6542, "Irvine, CA" },
	{  6543, "Los Angeles, CA" },
	{  6544, "Manhattan, NY" },
	{  6545, "Los Angeles, CA" },
	{  6546, "Melbourne, FL" },
	{  6547, "Middletown, NJ" },
	{  6548, "Fort Lauderdale, FL" },
	{  6549, "New York, NY" },
	{  6550, "Fresno, CA" },
	{  6551, "Ft. Lauderdale, FL" },
	{  6552, "New York, NY" },
	{  6553, "New York, NY" },
	{  6554, "Los Angeles, CA" },
	{  6555, "New York, NY" },
	{  6556, "New York, NY" },
	{  6557, "Miami, FL" },
	{  6558, "Austin, TX" },
	{  6559, "Los Angeles, CA" },
	{  6560, "Miami, FL" },
	{  6561, "Miami, FL" },
	{  6562, "Los Angeles, CA" },
	{  6563, "New York, NY" },
	{  6564, "Los Angeles, CA" },
	{  6565, "Oakland, CA" },
	{  6566, "Laredo, TX" },
	{  6567, "Staten Island, NY" },
	{  6568, "New York, NY" },
	{  6569, "New York, NY" },
	{  6570, "Elmsford, NY" },
	{  6571, "New York, NY" },
	{  6572, "New York, NY" },
	{  6573, "Wilton Manors, FL" },
	{  6574, "New York, NY" },
	{  6575, "Staten Island, NY" },
	{  6576, "Clifton, TX" },
	{  6577, "Clifton, TX" },
	{  6578, "Clifton, TX" },
	{  6579, "Clifton, TX" },
	{  6580, "Clifton, TX" },
	{  6581, "Clifton, TX" },
	{  6582, "Leesburg, VA" },
	{  6583, "Reston, VA" },
	{  6584, "Reston, VA" },
	{  6585, "New York, NY" },
	{  6586, "Washington, D.C." },
	{  6587, "Dallas, TX" },
	{  6588, "New York, NY" },
	{  6589, "Los Angeles, CA" },
	{  6590, "New York, NY" },
	{  6591, "Jackson Heights, NY" },
	{  6592, "Rialto, CA" },
	{  6593, "Los Angeles, CA" },
	{  6594, "Los Angeles, CA" },
	{  6595, "Miami, FL" },
	{  6596, "Atlanta, GA" },
	{  6597, "Brewster, WA" },
	{  6598, "Brewster, WA" },
	{  6599, "Jersey City, NJ" },
	{  6600, "Miramar, FL" },
	{  6601, "Coconut Grove, FL" },
	{  6602, "Miami, FL" },
	{  6603, "Sacramento (3), CA" },
	{  6604, "Sacramento (4), CA" },
	{  6605, "Sacramento (5), CA" },
	{  6606, "Warrenville, IL" },
	{  6607, "Miami, FL" },
	{  6608, "Los Angeles, CA" },
	{  6609, "Miami, FL" },
	{  6610, "New York, NY" },
	{  6611, "New York, NY" },
	{  6612, "New York, NY" },
	{  6613, "Atlanta, GA" },
	{  6614, "White Plains, NY" },
	{  6615, "Miami, FL" },
	{  6616, "New York, NY" },
	{  6617, "New York, NY" },
	{  6618, "San Antonio, TX" },
	{  6619, "New York, NY" },
	{  6620, "Newark, NJ" },
	{  6621, "Dallas, TX" },
	{  6622, "New York (1), NY" },
	{  6623, "Los Angeles, CA" },
	{  6688, "Marcatel Com, S.A. de C.V.-MTY, Monterrey N.L." },
	{  6689, "Mexico CTSJ CIM, Mexico D.F." },
	{  6690, "Monterrey Revolucion A CTI, Mexico D.F." },
	{  6691, "Marcatel Com, S.A. de C.V.-MTY, Monterrey N.L." },
	{  6692, "Marcatel Com, S.A. de C.V.-MTY, Monterrey N.L." },
	{  6693, "Pio Pico CTI, Tijuana BCN" },
	{  6694, "Gonzalez Ortega CTI, Mexicali BCN" },
	{  6695, "Del Valle, Mexico D.F." },
	{  6696, "Reserved" },
	{  6697, "Tulancingo CM, Tulancingo, Hgo." },
	{  6698, "Guadalajara CTI-2 (Tlaquepaque)" },
	{  6699, "Guadalajara CTI-2 (CTG)" },
	{  6700, "Mexicali (Gonzalez. Ortega)" },
	{  6701, "Monterrey CTI-1 (Mayo)" },
	{  6702, "Mexico Nextengo CI, Mexico D.F." },
	{  6703, "Hidalgo MTY, Monterrey" },
	{  6704, "MSSCTulancingo Hgo" },
	{  6705, "Celaya CTI-1 (Aztecas)" },
	{  6706, "Celaya CTI-2 (Corregidora)" },
	{  6707, "Mexico PTS CTSJ INT.1" },
	{  6708, "Chihuahua CTI-2 (Centauro)" },
	{  6709, "Chihuahua CTI-1 (Catedral)" },
	{  6710, "Hermosillo CTI-2 (Yaqez)" },
	{  6711, "Hermosillo CTI-1 (Garmendia)" },
	{  6712, "Tijuana (Pio Pico)" },
	{  6713, "Cuernavaca CTI-1 (Borda)" },
	{  6714, "Cuernavaca CTI-2 (Mirador)" },
	{  6715, "Coatzacoalcos CTI-1 (Ignacio de la Llave)" },
	{  6716, "Coatzacoalcos CTI-2 (Hidalgo)" },
	{  6717, "Puebla CTI-1 (CTP)" },
	{  6718, "Puebla CTI-2 (Fuertes)" },
	{  6719, "Mexico Nextengo Int. 2" },
	{  6720, "MXOT Mexico DF STP" },
	{  6721, "GDJT Guadalajara JAL STP" },
	{  6722, "RADE Monterrey NL DMS 250" },
	{  6723, "MX01 Mexico DF DMS 250" },
	{  6724, "MTY1, Apodaca N.L." },
	{  6725, "GDJ1 Guadalajara JAL DMS 250" },
	{  6726, "RADG Monterrey NL STP" },
	{  6727, "MX02 Tlalnepantla Mex." },
	{  6728, "Reserved" },
	{  6729, "Pasteje DMS 300-250" },
	{  6730, "Reserved" },
	{  6731, "Reserved" },
	{  6732, "Pasteje STP" },
	{  6733, "Guadalajara STP" },
	{  6734, "Reserved" },
	{  6735, "Reserved" },
	{  6736, "MNTRXLAD Monterrey" },
	{  6737, "TLPNXMAA Mexico" },
	{  6738, "ZPPNJAAA Guadalajara" },
	{  6739, "TIJNXBAB Tijuana" },
	{  6740, "CDJRXHAD Ciudad Juarez, Chih." },
	{  6741, "Reserved" },
	{  6742, "Reserved" },
	{  6743, "Reserved" },
	{  6744, "Reserved" },
	{  6745, "Central Mexico D.F." },
	{  6746, "Guadalajara Jal." },
	{  6747, "Monterrey N.L." },
	{  6748, "Central Tijuana BCN" },
	{  6749, "Reserved" },
	{  6750, "Reserved" },
	{  6751, "Reserved" },
	{  6752, "..." },
	{  6753, "Kingston" },
	{  6754, "..." },
	{  6755, "..." },
	{  6756, "..." },
	{  6757, "..." },
	{  6758, "..." },
	{  6759, "..." },
	{  6760, "..." },
	{  6761, "..." },
	{  6762, "..." },
	{  6763, "..." },
	{  6764, "..." },
	{  6765, "Kingston" },
	{  6766, "Kingston" },
	{  6770, "Kingston" },
	{  6771, "Kingston" },
	{  6772, "Kingston" },
	{  6773, "Kingston" },
	{  6774, "Kingston" },
	{  6775, "Kingston" },
	{  6776, "Kingston" },
	{  6778, "..." },
	{  6779, "..." },
	{  6816, "DMS-300 International Gateway Switch 1995" },
	{  6817, "Roaming Replicator GSM Platform 2004" },
	{  6818, "GSM MSC: GSM cellular switch 2003" },
	{  6819, "GSM HLR: GSM subscriber database platform 2003" },
	{  6820, "BAR BB STP-C1 signalling platform 1998" },
	{  6821, "GSM VMS: GSM Voicemail Platform 2003" },
	{  6822, "BAR CS2K: International Packet Gateway Switch 2001" },
	{  6823, "Verisign 1-800call-USA, Phone/Credit card calling platform 2003" },
	{  6824, "Call completion and information transfer between global networks" },
	{  6825, "Call completion and information transfer between global networks" },
	{  6826, "International Gateway for MSC" },
	{  6827, "Comverie pre-paid system (PPS)" },
	{  6828, "Domestic termination on termination of inbound traffic" },
	{  6829, "Transit traffic through Barbados to other islands in the eastern Carib" },
	{  6830, "Transfer calls destined for Barbados via Cable & Wireless (Barbados)" },
	{  6831, "GSM MSC Cellular Switch 2009" },
	{  6832, "GSM HLR" },
	{  6833, "GSM Prepaid SCP" },
	{  6834, "GSM Voice Mail" },
	{  6835, "Interconnection with Cable & Wireless" },
	{  6836, "Interconnection with Cable & Wireless" },
	{  6848, "NEAX61E INTS" },
	{  6849, "Ericsson APG40 MSC" },
	{  6850, "SS8 Voicemail" },
	{  6851, "BCG prepaid" },
	{  6852, "Voicemail 1" },
	{  6853, "Voicemail 2" },
	{  6854, "ANMUBSC41 E3" },
	{  6855, "DMS MSC" },
	{  6880, "ISC Current Gateway" },
	{  6881, "1 Tech Sq Call Server" },
	{  6882, "1 Tech Sq USP" },
	{  6883, "1 Tech Sq STP" },
	{  6884, "High Rock Call Server" },
	{  6885, "MSC Switch" },
	{  6886, "MSC" },
	{  6889, "WES-BTS-INT-01" },
	{  6890, "One Int 01" },
	{  6912, "Chalwell ITP-1" },
	{  6913, "Road Town DMS-100" },
	{  6914, "Chalwell TDMA" },
	{  6916, "Road Town CS2K" },
	{  6917, "Road Town Broadband STP" },
	{  6918, "Chalwell Teeno SCP" },
	{  6919, "Road town Nokia MSC" },
	{  6920, "Chalwell ITP-2" },
	{  6921, "BVI-MSC1" },
	{  6976, "Mount Hartman Exchange" },
	{  6978, "Morne Jaloux Exchange" },
	{  6979, "Tempe St. Georges Exchange" },
	{  7040, "Ponds-Needsmust Exchange" },
	{  7041, "Needsmust Exchange" },
	{  7043, "La Guerite Exchange" },
	{  7073, "Sans Soucis Exchange" },
	{  7074, "Vieux Exchange" },
	{  7075, "Marisule Exchange" },
	{  7076, "Marisule Exchange" },
	{  7104, "Arnos Vale Exchange" },
	{  7105, "Arnos Vale Mobile Exchange" },
	{  7106, "Arnos Vale Prepaid Platform" },
	{  7136, "Curacao 1" },
	{  7137, "St. Maarten/Antelecom" },
	{  7138, "Curacao 1" },
	{  7139, "Curacao/ANM" },
	{  7140, "Curacao 2" },
	{  7141, "Bonaire/Telbo" },
	{  7142, "Curacao/GSN" },
	{  7143, "St. Maarten/Smitcoms" },
	{  7144, "Curacao/ANM0102" },
	{  7145, "Curacao/Setel GSM" },
	{  7146, "Curacao 1" },
	{  7147, "Curacao 2" },
	{  7148, "Curacao 2" },
	{  7149, "St. Maarten" },
	{  7168, "Central Four" },
	{  7169, "Eight Mile Rock" },
	{  7170, "Soldier Road" },
	{  7200, "Roseau Exchange" },
	{  7201, "Roseau DAX" },
	{  7203, "Roseau Exchange" },
	{  7233, "..." },
	{  7234, "Varadero" },
	{  7235, "La Habana" },
	{  7236, "La Habana" },
	{  7237, "Camaguey" },
	{  7238, "La Habana" },
	{  7264, "ISUP Gateway 0" },
	{  7265, "ISUP Gateway 1" },
	{  7266, "DMS 300 LDV-STP-VIR (Zona Norte)" },
	{  7267, "STP-LDV (Metro)" },
	{  7268, "ODOGW1" },
	{  7269, "STP-VIR (Zona Norte)" },
	{  7270, "GSM (SGU/SLU)" },
	{  7271, "Sistema EIR (SQUIERE)" },
	{  7297, "Port-au-Prince" },
	{  7328, "DMS 300 TSTT House" },
	{  7329, "DMS 300 Couva" },
	{  7330, "Broadband STP - Nelson" },
	{  7331, "Broadband STP - Couva" },
	{  7332, "VoIP Gateway Net2Phone" },
	{  7333, "Alias STP Functionality DMS 300" },
	{  7334, "VoIP Gateway Clarent TSTT House" },
	{  7335, "VoIP Gateway Clarent Couva" },
	{  7336, "CS2K - Nelson" },
	{  7337, "CS2K - Tompson" },
	{  7338, "Alias STP NGN" },
	{  7339, "DCCHAG" },
	{  7340, "DCSTP1" },
	{  7341, "DCSTP2" },
	{  7342, "DCPOS1" },
	{  7343, "Alias STP - Digicel" },
	{  7360, "MTX-PSTN-LS" },
	{  7361, "PSTN-MTX-LS7" },
	{  7362, "PSTN-PPD-LS7" },
	{  7363, "MTX-VM-LS" },
	{  7364, "..." },
	{  7365, "TCIBSC91LS" },
	{  7366, "..." },
	{  7367, "..." },
	{  7368, "..." },
	{  7369, "MGW" },
	{  7370, "MSS" },
	{  7371, "RNC" },
	{  7372, "HLR" },
	{  7393, "Dauphin Telecom - Saint Martin 1" },
	{  7394, "St. Martin et St. Barthelemy Tel Cell St Martin" },
	{  7395, "Dauphin Telecom - Saint Martin 2" },
	{  7396, "Mediaserv - Guadeloupe" },
	{  7424, "Dauphin Telecom - Martinique" },
	{  7425, "Outremer Telecom - Martinique" },
	{  7456, "OSTD" },
	{  7458, "DIGIARU" },
	{  7460, "AUADTH" },
	{  7488, "TDMA Mobile Switch" },
	{  7489, "PSTN Switch" },
	{  7490, "GSM Base Station Controller E3" },
	{  7491, "Voicemail" },
	{  7492, "Pre-Paid Platform" },
	{  7493, "International STP PSTN Switch to Call Server" },
	{  7494, "GSM Base Station Controller 2G" },
	{  7495, "International STP Mobile Switch to Call Server" },
	{  7520, "Reserved" },
	{  7521, "Monterrey Mayo B CTI, Monterrey N.L." },
	{  7522, "Monterrey Revolucion B CTI, Monterrey N.L." },
	{  7523, "Hermosillo Garmendia B CTI, Hermosillo Son." },
	{  7524, "Hermosillo Yaqez B CTI, Hermosillo, Son." },
	{  7525, "Santa Apolonia, Mexico D.F." },
	{  7526, "CISNE Guadalajara, Jal." },
	{  7527, "Mex9msco1" },
	{  7528, "POP Nuevo Laredo, Nuevo Laredo, Tamps." },
	{  7529, "Reserved" },
	{  7530, "Puerto Internacional Nuevo Tulancingo 2" },
	{  7531, "Laborotorio Axe Local 6 Mexico DF" },
	{  7532, "PCS Aztecas 1, Cetaya" },
	{  7533, "PCS Nextengo 1, Mexico" },
	{  7534, "PCS Tlaquepaque, Guadalajara" },
	{  7535, "Puerto SCPMS, Monterrey, NL" },
	{  7536, "Amazon, Apodaca, NL" },
	{  7537, "Radiomovil DIPSA, S.A. de C.V. Cuautitlan" },
	{  7538, "Radiomovil DIPSA, S.A. de C.V. Xochimilco" },
	{  7539, "Hermosillo, Son." },
	{  7540, "San Pedro, Garza Garcia, N.L." },
	{  7541, "Monterrey, NL" },
	{  7542, "Mexico, D.F." },
	{  7543, "Mexico" },
	{  7544, "Pts Zinc-Mty" },
	{  7545, "Ps Zinc Mty" },
	{  7546, "Pts Mier Mty" },
	{  7547, "Nextengo 2 Mexico 3" },
	{  7548, "Nextengo 1 Mexico 1" },
	{  7549, "MTY4MSC01" },
	{  7550, "Inversiones Nextel de Mexico, S.A. de C.V. - Mexico" },
	{  7551, "Inversiones Nextel de Mexico, Mexico, S.A. de C.V." },
	{  7552, "Reserved" },
	{  7553, "Reserved" },
	{  7554, "Reserved" },
	{  7555, "Reserved" },
	{  7556, "Reserved" },
	{  7557, "Reserved" },
	{  7558, "Mexico" },
	{  7559, "Mexico" },
	{  7560, "Mexico" },
	{  7561, "Mexico" },
	{  7562, "Mexico" },
	{  7563, "..." },
	{  7564, "..." },
	{  7565, "..." },
	{  7566, "..." },
	{  7567, "..." },
	{  7568, "..." },
	{  7569, "..." },
	{  7570, "..." },
	{  7571, "..." },
	{  7572, "..." },
	{  7573, "..." },
	{  7576, "FOIC1" },
	{  7577, "FOIC2" },
	{  7581, "ANIC1" },
	{  7582, "KGSM1" },
	{  7583, "TELEF" },
	{  7584, "New York (2), NY" },
	{  7585, "White Plains, NY" },
	{  7586, "White Plains, NY" },
	{  7587, "Jersey City, NJ" },
	{  7588, "Anaheim, CA" },
	{  7589, "Newark, NJ" },
	{  7590, "Dallas, TX" },
	{  7591, "New York, NY" },
	{  7592, "Houston, TX" },
	{  7593, "Los Angeles, CA" },
	{  7594, "Newark, NJ" },
	{  7595, "Los Angeles, CA" },
	{  7596, "Newark, NJ" },
	{  7597, "Miami, FL" },
	{  7598, "Los Angeles, CA" },
	{  7599, "Los Angeles, CA" },
	{  7600, "New York, NY" },
	{  7601, "Los Angeles, CA" },
	{  7602, "Sherman Oaks (3), CA" },
	{  7603, "Sherman Oaks (4), CA" },
	{  7604, "Pompano Beach (6), FL" },
	{  7605, "Elmswood, NY" },
	{  7606, "Los Angeles, CA" },
	{  7607, "Los Angeles (2), CA" },
	{  7608, "Los Angeles (3), CA" },
	{  7609, "Los Angeles, CA" },
	{  7610, "New York (2), NY" },
	{  7611, "New York (3), NY" },
	{  7612, "Atlanta (1), GA" },
	{  7613, "Atlanta (2), GA" },
	{  7614, "Jersey City, NJ" },
	{  7615, "San Antonio, TX" },
	{  7616, "New York, NY" },
	{  7617, "West Orange, NJ" },
	{  7618, "Honolulu, HI" },
	{  7619, "Piscataway, NJ" },
	{  7620, "New York, NY" },
	{  7621, "Newark, NJ" },
	{  7622, "Los Angeles, CA" },
	{  7623, "Laredo, TX" },
	{  7624, "Los Angeles, CA" },
	{  7625, "Stockton, CA" },
	{  7626, "Pottstown, PA" },
	{  7627, "New York, NY" },
	{  7628, "Miami, FL" },
	{  7629, "New York, NY" },
	{  7630, "New York, NY" },
	{  7631, "Richardson, TX" },
	{  7632, "New York, NY" },
	{  7633, "Brooklyn, NY" },
	{  7634, "Atlanta, GA" },
	{  7635, "New York, NY" },
	{  7636, "Los Angeles, CA" },
	{  7637, "New York, NY" },
	{  7638, "Los Angeles, CA" },
	{  7639, "New York, NY" },
	{  7640, "Oak Hill, VA" },
	{  7641, "Newark, NJ" },
	{  7642, "Jersey City, NJ" },
	{  7643, "Miami, FL" },
	{  7644, "Newark, NJ" },
	{  7645, "Holmdale, NJ" },
	{  7646, "Ft. Lauderdale, FL" },
	{  7647, "Jersey City, NJ" },
	{  7648, "New York, NY" },
	{  7649, "Newark, NJ" },
	{  7650, "Los Angeles, CA" },
	{  7651, "Rockledge, FL" },
	{  7652, "New York, NY" },
	{  7653, "Longview, TX" },
	{  7654, "New York, NY" },
	{  7655, "Los Angeles, CA" },
	{  7656, "New York, NY" },
	{  7657, "Newark, New Jersey" },
	{  7658, "Los Angeles, CA" },
	{  7659, "Los Angeles, CA" },
	{  7660, "Sherman Oaks, CA" },
	{  7661, "Atlanta, GA" },
	{  7662, "White Plains, NY" },
	{  7663, "Anaheim, CA" },
	{  7664, "Los Angeles, CA" },
	{  7665, "Chicago, IL" },
	{  7666, "Los Angeles, CA" },
	{  7667, "New York, NY" },
	{  7668, "Los Angeles, CA" },
	{  7669, "Jersey City, NJ" },
	{  7670, "Los Angeles, CA" },
	{  7671, "New York, NY" },
	{  7672, "Plainview, NY" },
	{  7673, "New York, NY" },
	{  7674, "Newark, NJ" },
	{  7675, "Atlanta, GA" },
	{  7676, "Charlotte, NC" },
	{  7677, "New York, NY" },
	{  7678, "Los Angeles, CA" },
	{  7679, "New York, NY" },
	{  7680, "San Antonio, TX" },
	{  7681, "Rialto, CA" },
	{  7682, "New York, NY" },
	{  7683, "Miami, FL" },
	{  7684, "Dallas, TX" },
	{  7685, "Los Angeles, CA" },
	{  7686, "New York, NY" },
	{  7687, "New York, NY" },
	{  7688, "Los Angeles, CA" },
	{  7689, "New York, NY" },
	{  7690, "Miami, FL" },
	{  7691, "New York, NY" },
	{  7692, "Los Angeles, CA" },
	{  7693, "New York, NY" },
	{  7694, "Dallas, TX" },
	{  7695, "San Antonio, TX" },
	{  7696, "Los Angeles, CA" },
	{  7697, "Los Angeles, CA" },
	{  7698, "Los Angeles, CA" },
	{  7699, "Temple Terrace (7), FL" },
	{  7700, "Miami, FL" },
	{  7701, "Anaheim, CA" },
	{  7702, "Tampa, FL" },
	{  7703, "New York, NY" },
	{  7704, "Los Angeles, CA" },
	{  7705, "New York, NY" },
	{  7706, "Hauppauge, NY" },
	{  7707, "Miami, FL" },
	{  7708, "Portland, OR" },
	{  7709, "Worcester, MA" },
	{  7710, "Miami, FL" },
	{  7711, "Miami, FL" },
	{  7712, "New York, NY" },
	{  7713, "Reston, VA" },
	{  7714, "Los Angeles, CA" },
	{  7715, "New York, NY" },
	{  7716, "New York, NY" },
	{  7717, "Miami, FL" },
	{  7718, "Dallas, TX" },
	{  7719, "Herndon, VA" },
	{  7720, "New York, NY" },
	{  7721, "Los Angeles, CA" },
	{  7722, "Los Angeles, CA" },
	{  7723, "Newark, NJ" },
	{  7724, "New York, NY" },
	{  7725, "Boston, MA" },
	{  7726, "Cedar Falls, IA" },
	{  7727, "Miami, FL" },
	{  7728, "Miami, FL" },
	{  7729, "San Jose, CA" },
	{  7730, "New York, NY" },
	{  7731, "Los Angeles, CA" },
	{  7732, "Mattoon, IL" },
	{  7733, "Los Angeles, CA" },
	{  7734, "San Jose, CA" },
	{  7735, "Ashburn, VA" },
	{  7736, "New York, NY" },
	{  7737, "Houston, TX" },
	{  7738, "Los Angeles, CA" },
	{  7739, "Pompano Beach, FL" },
	{  7740, "New York, NY" },
	{  7741, "New York, NY" },
	{  7742, "New York, NY" },
	{  7743, "Miami, FL" },
	{  7744, "Wentzville, MO" },
	{  7745, "Fort Lauderdale, FL" },
	{  7746, "Los Angeles, CS" },
	{  7747, "Dallas, TX" },
	{  7748, "Philadelphia, PA" },
	{  7749, "Miami, FL" },
	{  7750, "Los Angeles, CA" },
	{  7751, "Los Angeles,CA" },
	{  7752, "Oak Hill, VA" },
	{  7753, "Los Angeles, CA" },
	{  7754, "Tampa, FL" },
	{  7755, "Tampa, FL" },
	{  7756, "Newark, NJ" },
	{  7757, "New York, NY" },
	{  7758, "Los Angeles, CA" },
	{  7759, "New York, NY" },
	{  7760, "San Antonio, TX" },
	{  7761, "Overland Park, KS" },
	{  7762, "New York, NY" },
	{  7763, "Dallas, TX" },
	{  7764, "Dallas (2), TX" },
	{  7765, "Nashville, TN" },
	{  7766, "Boca Raton, FL" },
	{  7767, "Sunnyvale, CA" },
	{  7768, "Los Angeles, CA" },
	{  7769, "Houston, TX" },
	{  7770, "Los Angeles, CA" },
	{  7771, "Los Angeles (2), CA" },
	{  7772, "Los Angeles (3), CA" },
	{  7773, "Los Angeles (4), CA" },
	{  7774, "Miami, FL" },
	{  7775, "Palm Bay, FL" },
	{  7776, "Orlando, FL" },
	{  7777, "New York, NY" },
	{  7778, "New York, NY" },
	{  7779, "Dallas, TX" },
	{  7780, "Hauppauge, NY" },
	{  7781, "Miami, FL" },
	{  7782, "New York, NY" },
	{  8024, "Bristol AVN2042-M02" },
	{  8025, "Bristol AVN2042-M71" },
	{  8026, "Bristol AVN2042-M37" },
	{  8027, "Bristol AVN2042-K02" },
	{  8028, "Bristol AVN2042-K03" },
	{  8029, "Bristol AVN2042-K00" },
	{  8030, "Bristol AVN2042-K01" },
	{  8031, "SMiLOUS London" },
	{  8032, "London 2" },
	{  8033, "London 3" },
	{  8034, "GVSUKD" },
	{  8035, "Birmingham WMD0900-TS2" },
	{  8036, "Acton GLN1070-TS3" },
	{  8037, "Leicester LEC5090-T54" },
	{  8038, "Manchester GMN0901-T55" },
	{  8039, "Martlesham Heath" },
	{  8040, "London STP1" },
	{  8041, "TSC 93" },
	{  8042, "TSC 95" },
	{  8043, "TSC96" },
	{  8044, "HLR 63" },
	{  8045, "HLR 64" },
	{  8046, "HLR 65" },
	{  8047, "HLR66" },
	{  8048, "..." },
	{  8049, "..." },
	{  8050, "..." },
	{  8051, "..." },
	{  8052, "..." },
	{  8053, "..." },
	{  8056, "STA STP BLUKA1" },
	{  8057, "STA STP BLUKA2" },
	{  8058, "IE BLUKA1" },
	{  8059, "IE BLUKA2" },
	{  8072, "..." },
	{  8073, "..." },
	{  8074, "..." },
	{  8075, "..." },
	{  8076, "..." },
	{  8077, "..." },
	{  8078, "..." },
	{  8079, "..." },
	{  8080, "Madrid" },
	{  8081, "Madrid" },
	{  8082, "Barcelona" },
	{  8083, "Barcelona" },
	{  8084, "Lleida" },
	{  8085, "Madrid" },
	{  8086, "Madrid POP" },
	{  8087, "Las Rozas (Madrid)" },
	{  8088, "60326 Frankfurt" },
	{  8089, "60326 Frankfurt" },
	{  8090, "60314 Frankfurt" },
	{  8091, "60326 Frankfurt" },
	{  8092, "60326 Frankfurt" },
	{  8093, "20095 Hamburg" },
	{  8094, "60314 Frankfurt" },
	{  8096, "Tallinn" },
	{  8097, "Tallinn" },
	{  8098, "Tallinn" },
	{  8101, "Tallin" },
	{  8104, "..." },
	{  8105, "..." },
	{  8106, "..." },
	{  8107, "..." },
	{  8108, "..." },
	{  8109, "..." },
	{  8110, "..." },
	{  8112, "..." },
	{  8113, "..." },
	{  8114, "..." },
	{  8115, "..." },
	{  8116, "..." },
	{  8117, "..." },
	{  8118, "..." },
	{  8119, "..." },
	{  8120, "Tele2" },
	{  8121, "Tellcom" },
	{  8123, "Global" },
	{  8124, "Mega" },
	{  8125, "Ankara/Borusan" },
	{  8126, "Kocnet" },
	{  8127, "Dogan Iletisim" },
	{  8128, "TWX/LIM2, Limassol" },
	{  8129, "WLD-CY" },
	{  8130, "TWX/LIM1, Nicosia" },
	{  8131, "ISCLYK, Nicosia" },
	{  8132, "ISCMGI, Limassol" },
	{  8133, "CBNT_CY, Nicosia" },
	{  8134, "MTNCYMSS1" },
	{  8135, "MTNCYMSS2" },
	{  8136, "TPIC1" },
	{  8137, "TADC1" },
	{  8144, "..." },
	{  8145, "..." },
	{  8146, "..." },
	{  8147, "..." },
	{  8148, "..." },
	{  8149, "..." },
	{  8150, "..." },
	{  8151, "..." },
	{  8152, "Warszawa I" },
	{  8153, "Warszawa" },
	{  8154, "Warszawa II" },
	{  8157, "Warszawa II" },
	{  8158, "Warszawa III" },
	{  8159, "Warszawa IV" },
	{  8160, "60326 Frankfurt" },
	{  8161, "33311 Guetersich" },
	{  8162, "04425 Taucha" },
	{  8163, "60326 Frankfurt" },
	{  8164, "60326 Frankfurt" },
	{  8165, "60326 Frankfurt" },
	{  8166, "60326 Frankfurt" },
	{  8167, "60326 Frankfurt" },
	{  8168, "Warszawa" },
	{  8169, "Warszawa" },
	{  8170, "Warszawa" },
	{  8171, "Warszawa" },
	{  8172, "Warszawa" },
	{  8173, "Katowice III" },
	{  8174, "Warszawa" },
	{  8175, "Warszawa" },
	{  8176, "60623 Frankfurt" },
	{  8177, "40472 Dusseldorf" },
	{  8178, "80939 Munchen" },
	{  8179, "60326 Frankfurt" },
	{  8180, "60329 Frankfurt" },
	{  8181, "60326 Frankfurt" },
	{  8182, "60326 Frankfurt" },
	{  8183, "12103 Berlin" },
	{  8184, "60327 Frankfurt" },
	{  8185, "17033 Neubrandenburg" },
	{  8186, "18107 Rostock" },
	{  8187, "60314 Frankfurt" },
	{  8188, "60327 Frankfurt" },
	{  8189, "60326 Frankfurt" },
	{  8190, "60326 Frankfurt" },
	{  8191, "60326 Frankfurt" },
	{  8216, "..." },
	{  8217, "..." },
	{  8218, "..." },
	{  8219, "..." },
	{  8220, "..." },
	{  8221, "..." },
	{  8224, "Bezeq Int. 5" },
	{  8225, "Bezeq Int. 6" },
	{  8226, "Golden Lines 3" },
	{  8227, "Golden Lines 4" },
	{  8228, "..." },
	{  8229, "..." },
	{  8230, "..." },
	{  8231, "..." },
	{  8232, "ISC 12 Mumbai" },
	{  8233, "ISC Chennai" },
	{  8234, "ISC Mumbai" },
	{  8235, "ISC Delhi" },
	{  8236, "ISC Chennai" },
	{  8237, "ISC Ernakulam" },
	{  8238, "ISC Chennai" },
	{  8239, "ISC Chennai SSTP" },
	{  8240, "ISC 1 Hyderabad" },
	{  8241, "ISC 1 Ahmedabad" },
	{  8242, "ISC 3 Jalandhar" },
	{  8243, "ISC 1 Surat" },
	{  8244, "ISC Delhi" },
	{  8245, "ISC Mumbai" },
	{  8246, "ISC 11  New Delhi - VoIP" },
	{  8247, "ISC 4 Ernakulam VoIP" },
	{  8248, "ISC Kolkata - STP" },
	{  8249, "ISC Chennai - STP" },
	{  8250, "ISC 1 Lucknow" },
	{  8251, "ISC 9 New Delhi" },
	{  8252, "ISC 7 Chennai" },
	{  8253, "ISC 11 Mumbai" },
	{  8254, "ISC 10 New Delhi" },
	{  8255, "ISC 1 Gurgoan" },
	{  8256, "ISC Kolkata - SSTP" },
	{  8257, "ISC Delhi - STP" },
	{  8258, "ISC Mumbai - STP" },
	{  8259, "ISC Mumbai" },
	{  8260, "ISC Ernakulam - SSTP" },
	{  8261, "ISC Mumbai - STP" },
	{  8262, "ISC Delhi - STP" },
	{  8263, "ISC Jalandhar - SSTP" },
	{  8264, "ISC  3 New Delhi-ICO" },
	{  8265, "ISC Jalandhar" },
	{  8266, "ISC Ahmedabad" },
	{  8267, "ISC 1 Iridium Pune" },
	{  8268, "ISC 1 Ernakulam" },
	{  8269, "ISC Guwahati" },
	{  8270, "ISC 3 Mumbai ATM Node-1" },
	{  8271, "ISC 4 Mumbai ATM Node-2" },
	{  8272, "ISC 4 New Delhi" },
	{  8273, "ISC 3 Kolkata" },
	{  8274, "ISC 1 Patna" },
	{  8275, "ISC 5 Mumbai" },
	{  8276, "ISC 3 Chennai" },
	{  8277, "ISC 6 Mumbai" },
	{  8278, "ISC 4 Chennai" },
	{  8279, "ISC 5 New Drlhi" },
	{  8280, "ISC 6 New Delhi" },
	{  8281, "ISC 7 Mumbai" },
	{  8282, "ISC 2 Ernakulam" },
	{  8283, "ISC 7 New Delhi" },
	{  8284, "ISC 4 Kolkata" },
	{  8285, "ISC 5 Kolkata" },
	{  8286, "ISC 5 Chennai" },
	{  8287, "ISC 1 Bangalore" },
	{  8288, "ISC 8 Mumbai" },
	{  8289, "ISC 2 Bangalore" },
	{  8290, "ISC 6 Kolkata" },
	{  8291, "ISC 9  Mumbai VoIP" },
	{  8292, "ISC 2 Gandhinagar VoIP" },
	{  8293, "ISC 2 Jalandhar VoIP" },
	{  8294, "ISC Mohali, Chandigarh - STP" },
	{  8295, "ISC Gandhinagar - STP" },
	{  8296, "ISC Mumbai SSTP" },
	{  8297, "ISC Delhi SSTP" },
	{  8298, "ISC Delhi" },
	{  8299, "ISC Mumbai" },
	{  8300, "ISC Chennai" },
	{  8301, "ISC Kolkata" },
	{  8302, "ISC Lucknow - STP" },
	{  8303, "ISC Bangalore - STP" },
	{  8304, "ISC Chennai" },
	{  8305, "ISC Delhi" },
	{  8306, "ISC Hyderabad" },
	{  8307, "ISC Ernakulam" },
	{  8308, "ISC Mumbai - STP" },
	{  8309, "ISC Kolkata - STP" },
	{  8310, "ISC Mumbai" },
	{  8311, "ISC Delhi" },
	{  8312, "ISC-Thane Mumbai" },
	{  8313, "ISC Chennai" },
	{  8314, "ISC Ernakulam" },
	{  8315, "ISC Mumbai" },
	{  8316, "ISC New Delhi" },
	{  8317, "ISC Chennai" },
	{  8318, "ISC Mumbai" },
	{  8319, "ISC - New Delhi" },
	{  8320, "ISC - Chennai" },
	{  8321, "ISC - Mumbai" },
	{  8322, "ISC - Gurgoan" },
	{  8323, "ISC - Chennai" },
	{  8324, "ISC - Mumbai" },
	{  8325, "ISC - Mumbai" },
	{  8326, "ISC - Mumbai" },
	{  8352, "IGE-2 Karachi (KHI2)" },
	{  8353, "IGE-1 Karachi (KHI1)" },
	{  8354, "IGE-2 Islamabad (IBA2)" },
	{  8355, "IGE-3 Islamabad (IBA3)" },
	{  8356, "LDI (IGE1) Lahore" },
	{  8357, "ISC1 (IGE-ISB-1)" },
	{  8358, "TCL (IGE1) Karachi" },
	{  8359, "IGE-1 AJK" },
	{  8360, "B640 KHI" },
	{  8361, "WC INT LHR 01" },
	{  8362, "WTL INT LHR 01" },
	{  8363, "Telenor Pak LDI-KHI" },
	{  8364, "LDI (IGE-2) Karachi" },
	{  8365, "DVC IBA 1" },
	{  8366, "Telenor Pak LDI-2 IBA" },
	{  8367, "RP1" },
	{  8368, "LDI - IGE - LHR 1" },
	{  8369, "LDI - IGE - KHI 1" },
	{  8370, "WTL INT KHI 02" },
	{  8371, "CTTL 3" },
	{  8372, "Pakfon" },
	{  8373, "BTLINAT" },
	{  8374, "DVC IBA 2 (STP-A)" },
	{  8375, "WTL INT LHR 02" },
	{  8376, "RP2" },
	{  8377, "TCL (IGE-2) Karachi" },
	{  8378, "WTL INT KHI 01" },
	{  8379, "LDI-IGE-ISB2" },
	{  8380, "STP-B IBA 1-9" },
	{  8381, "reserved" },
	{  8382, "reserved" },
	{  8384, "AWCC" },
	{  8385, "AWCC" },
	{  8386, "AWCC" },
	{  8387, "Afghan Telecom" },
	{  8388, "Areeba Afghanistan" },
	{  8389, "Areeba Afghanistan" },
	{  8390, "Roshan" },
	{  8391, "Roshan" },
	{  8392, "Roshan" },
	{  8393, "Roshan" },
	{  8394, "Roshan" },
	{  8395, "AWCC" },
	{  8396, "AWCC" },
	{  8397, "Afghan Telecom" },
	{  8398, "Afghan Telecom" },
	{  8399, "Etisalat Afghanistan" },
	{  8400, "ISC1 - 5ESS Int'l Gateway" },
	{  8401, "ISC2 - NEAX Int'l Gateway" },
	{  8402, "ISC3 - NEAX Int'l Gateway" },
	{  8403, "ZE" },
	{  8404, "..." },
	{  8405, "Mobitel" },
	{  8406, "Celltel 1" },
	{  8407, "MTNLK 1" },
	{  8408, "UNIL Sri Lanka 1" },
	{  8409, "VLL Gateway, Colombo" },
	{  8410, "LBSW2" },
	{  8411, "MTNLK2" },
	{  8412, "LBSW1" },
	{  8413, "Celltel" },
	{  8414, "SUNTEL ISC" },
	{  8415, "MTT 01" },
	{  8433, "Beirut, Justice ISC AXE-10" },
	{  8434, "Beirut, Ras Beirut ISC AXE-10" },
	{  8435, "Beirut, Jdeideh, ISC AXE-10" },
	{  8440, "..." },
	{  8441, "..." },
	{  8442, "..." },
	{  8448, "..." },
	{  8449, "..." },
	{  8450, "..." },
	{  8451, "..." },
	{  8452, "..." },
	{  8453, "..." },
	{  8454, "..." },
	{  8455, "..." },
	{  8456, "..." },
	{  8457, "..." },
	{  8458, "..." },
	{  8459, "..." },
	{  8460, "..." },
	{  8461, "..." },
	{  8462, "..." },
	{  8463, "..." },
	{  8465, "STE Damascus" },
	{  8466, "STE Aleppo" },
	{  8467, "Damascus" },
	{  8468, "Damascus" },
	{  8480, "..." },
	{  8481, "..." },
	{  8482, "..." },
	{  8483, "..." },
	{  8496, "ISCX-1" },
	{  8497, "ISC-2" },
	{  8498, "ISC-3" },
	{  8499, "Mobile Operator" },
	{  8500, "Mobile Operator" },
	{  8501, "Mobile Operator" },
	{  8502, "Mobile Operator" },
	{  8503, "Mobile Operator" },
	{  8512, "DAMMAM INTL. VoIP" },
	{  8513, "JEDDAH INTL. VoIP" },
	{  8514, "HUTT" },
	{  8515, "RIYADH INTL. VoIP" },
	{  8516, "MUJA" },
	{  8517, "JIN1" },
	{  8518, "RIN1" },
	{  8519, "DIN1" },
	{  8520, "JED1" },
	{  8521, "RYD1" },
	{  8522, "JST1" },
	{  8523, "RST1" },
	{  8524, "M1I2" },
	{  8525, "M2I2" },
	{  8526, "M1S2" },
	{  8527, "M2S2" },
	{  8528, "Sana'a ISC2" },
	{  8529, "STY GSM Exchange" },
	{  8530, "SF GSM Exchange" },
	{  8531, "IGW4" },
	{  8532, "IGW4" },
	{  8544, "Inter Switch 1 at TCC (ISC1)" },
	{  8545, "Inter Switch 2 at MUS1 (ISC2)" },
	{  8546, "Nawras 1" },
	{  8547, "Nawras 2" },
	{  8548, "TCC (Soft Switch)" },
	{  8560, "ISC3" },
	{  8561, "IGW5" },
	{  8562, "IGW5" },
	{  8563, "YEM-Unitel-1" },
	{  8564, "YEM-Unitel-2" },
	{  8576, "IG Softswitch 1 (IS1)" },
	{  8577, "IG Softswitch 2 (IS2)" },
	{  8578, "IG Softswitch 3 (IS3)" },
	{  8579, "IG Softswitch 4 (IS4)" },
	{  8580, "IG Softswitch 5 (IS5)" },
	{  8582, "IG Softswitch 5 (SGW)" },
	{  8583, "IG Softswitch 6 (SGW)" },
	{  8584, "TC1CSW02" },
	{  8585, "ITP3" },
	{  8586, "ITP4" },
	{  8587, "DXB001GSX1" },
	{  8592, "..." },
	{  8593, "ISC Oron" },
	{  8594, "PTTK" },
	{  8595, "..." },
	{  8596, "ISC Barak1" },
	{  8597, "ISC Barak 2" },
	{  8598, "ISC PTTK" },
	{  8599, "ISC Kiron" },
	{  8600, "ISC SIV" },
	{  8601, "ISC EDEN" },
	{  8602, "Partner 1" },
	{  8603, "Y2K testing" },
	{  8604, "Tel Aviv" },
	{  8605, "Tel Haifa" },
	{  8606, "Xfone1" },
	{  8607, "Xfone2" },
	{  8608, "Salmanya (SAL)" },
	{  8609, "Sanad (SND)" },
	{  8610, "..." },
	{  8611, "VoIP" },
	{  8612, "..." },
	{  8613, "Diplomat" },
	{  8614, "MSC2 - Istiqlala" },
	{  8615, "MSC2 - Tubli" },
	{  8616, "..." },
	{  8617, "softswitch" },
	{  8618, "-" },
	{  8619, "..." },
	{  8620, "..." },
	{  8621, "IGWs - MSCs" },
	{  8622, "IGWs - MSCs" },
	{  8624, "spare" },
	{  8625, "Doha STP3" },
	{  8626, "ITSC-3-Doha" },
	{  8627, "spare" },
	{  8628, "Cisco-PGW" },
	{  8629, "Doha IGW1" },
	{  8630, "Doha IGW2" },
	{  8631, "Doha STP2" },
	{  8632, "VFQ-M1" },
	{  8633, "VFQ-M2" },
	{  8656, "Patan ISC (Kathmandu)" },
	{  8657, "Central ISC (Kathmandu)" },
	{  8658, "UTL ISC01 (Kathmandu)" },
	{  8659, "Kathmandu SNPL-1" },
	{  8660, "PATAN STP" },
	{  8661, "STM Sanchar Nepal (Kathmandu)" },
	{  8662, "Central STP" },
	{  8663, "STP_KTM" },
	{  8664, "UTL_SSP" },
	{  8665, "UTL_SCCP" },
	{  8667, "KTM-2 SNPL" },
	{  8672, "ACI" },
	{  8673, "2IS" },
	{  8674, "ASI" },
	{  8675, "WSI" },
	{  8676, "EDCH" },
	{  8677, "ITP1" },
	{  8678, "TC1CSW01" },
	{  8679, "ITP-2" },
	{  8688, "DCI" },
	{  8689, "4IS" },
	{  8690, "DSI" },
	{  8691, "WCI" },
	{  8692, "IG Softswitch 6 (IS6)" },
	{  8694, "EITCSW01 (IMSS)" },
	{  8704, "Tehran" },
	{  8705, "Tehran" },
	{  8706, "Shiraz" },
	{  8707, "..." },
	{  8708, "..." },
	{  8709, "..." },
	{  8710, "..." },
	{  8711, "Tehran - GMSC" },
	{  8752, "..." },
	{  8753, "..." },
	{  8754, "..." },
	{  8755, "..." },
	{  8756, "..." },
	{  8757, "..." },
	{  8758, "..." },
	{  8759, "..." },
	{  8768, "..." },
	{  8784, "Central Earth Station, Almaty" },
	{  8785, "Almaty International Switching Centre (ISC)" },
	{  8786, "Aktyubinsk ISC" },
	{  8787, "Astana ISC" },
	{  8788, "GSM Kazakhstan (roaming)" },
	{  8789, "..." },
	{  8790, "..." },
	{  8791, "..." },
	{  8792, "Almaty ISC" },
	{  8793, "Almaty ISC" },
	{  8794, "Almaty ISC" },
	{  8795, "Almaty ISC" },
	{  8796, "Almaty ISC" },
	{  8797, "Almaty ISC" },
	{  8798, "Astana ISC" },
	{  8799, "Astana ISC" },
	{  8800, "Almaty ISC" },
	{  8801, "Astana ISC" },
	{  8802, "Almaty ISC" },
	{  8803, "Almaty ISC" },
	{  8804, "Almaty ISC" },
	{  8805, "Astana ISC" },
	{  8806, "Almaty ISC" },
	{  8816, "Gateway-1, Bishkek" },
	{  8817, "..." },
	{  8818, "..." },
	{  8819, "..." },
	{  8820, "..." },
	{  8821, "..." },
	{  8822, "..." },
	{  8824, "Gateway-2, Bishkek" },
	{  8825, "..." },
	{  8826, "..." },
	{  8827, "..." },
	{  8828, "..." },
	{  8829, "..." },
	{  8830, "..." },
	{  8832, "Tokyo" },
	{  8833, "Osaka" },
	{  8834, "Yamaguchi" },
	{  8835, "Tokyo" },
	{  8836, "Tokyo" },
	{  8837, "Tokyo" },
	{  8838, "Osaka" },
	{  8839, "Tokyo" },
	{  8840, "Tokyo" },
	{  8841, "Tokyo" },
	{  8842, "Osaka" },
	{  8843, "Osaka" },
	{  8844, "Tokyo" },
	{  8845, "Tokyo" },
	{  8846, "Tokyo" },
	{  8847, "Osaka" },
	{  8848, "Tokyo" },
	{  8849, "Tokyo" },
	{  8850, "Tokyo" },
	{  8851, "Tokyo" },
	{  8852, "Tokyo" },
	{  8853, "Osaka" },
	{  8854, "Tokyo" },
	{  8855, "Tokyo" },
	{  8856, "Chiba" },
	{  8857, "Chiba" },
	{  8858, "Chiba" },
	{  8859, "Tokyo" },
	{  8860, "Tokyo" },
	{  8861, "Osaka" },
	{  8862, "Chiba" },
	{  8863, "Tokyo" },
	{  8864, "Tokyo" },
	{  8865, "Tokyo" },
	{  8866, "Osaka" },
	{  8867, "Tokyo" },
	{  8868, "Tokyo" },
	{  8869, "Tokyo" },
	{  8870, "Tokyo" },
	{  8871, "Tokyo" },
	{  8872, "Yokohama" },
	{  8873, "Kyoto" },
	{  8874, "Tokyo" },
	{  8875, "Tokyo" },
	{  8876, "Kyoto" },
	{  8877, "Osaka" },
	{  8878, "Tokyo" },
	{  8879, "Tokyo" },
	{  8992, "Seoul Gateway" },
	{  8993, "Seoul Gateway" },
	{  8994, "Pusan Gateway" },
	{  8995, "Seoul Gateway" },
	{  8996, "Daejeon Gateway" },
	{  8997, "Seoul Gateway" },
	{  8998, "Pusan Gateway" },
	{  8999, "Pusan Gateway" },
	{  9000, "Seoul Gateway" },
	{  9001, "Daejon Gateway" },
	{  9002, "Seoul Gateway" },
	{  9003, "Daejon Gateway" },
	{  9004, "Anyang Gateway" },
	{  9005, "..." },
	{  9006, "Seoul Gateway" },
	{  9007, "Seoul Gateway" },
	{  9016, "..." },
	{  9017, "..." },
	{  9018, "..." },
	{  9019, "..." },
	{  9020, "..." },
	{  9021, "..." },
	{  9022, "..." },
	{  9023, "..." },
	{  9024, "Gateway Hanoi" },
	{  9025, "Gateway Danang" },
	{  9026, "Gateway Ho Chi Minh" },
	{  9027, "SCCP Hanoi" },
	{  9028, "SCCP Ho Chi Minh" },
	{  9029, "SCCP Hanoi" },
	{  9030, "SCCP Ho Chi Minh" },
	{  9031, "Gateway Hanoi" },
	{  9032, "GlobalOne - HK1" },
	{  9033, "STHK" },
	{  9034, "Wharf  T&T - WCTU2" },
	{  9035, "HTHKIU1" },
	{  9036, "CITIC 1" },
	{  9037, "HTCL" },
	{  9038, "HK-1" },
	{  9039, "Wharf  T&T - KCTU2" },
	{  9040, "CTI/HKG1" },
	{  9041, "HTHKIU2" },
	{  9042, "KDDI HK" },
	{  9043, "Tung Chung/HKG1" },
	{  9044, "Kwai Chung/HKG2" },
	{  9045, "YTGIDD01" },
	{  9046, "HKG06" },
	{  9047, "S2T" },
	{  9048, "Arbinet Hong Kong A" },
	{  9049, "CNHK1" },
	{  9050, "CTI/HKG2" },
	{  9051, "HGKGCNGBGT1" },
	{  9052, "Smartgate" },
	{  9053, "Unicom 1" },
	{  9054, "Lucky Tone Communications Ltd" },
	{  9055, "HK1/CNC" },
	{  9056, "Electra" },
	{  9057, "Hermes" },
	{  9058, "Zodiac" },
	{  9059, "Mini-ISC" },
	{  9060, "HKG04-SW1" },
	{  9061, "HKG04-SW2" },
	{  9064, "Standard Network Ltd" },
	{  9065, "Unicom2" },
	{  9066, "HKG07" },
	{  9067, "Whart T&T - WCTU5" },
	{  9068, "HKG02" },
	{  9069, "PHA" },
	{  9070, "Centrex" },
	{  9072, "MMSS1" },
	{  9073, "ISC1" },
	{  9074, "ISC2" },
	{  9075, "MSC" },
	{  9076, "MACSMC" },
	{  9077, "MG1" },
	{  9078, "CTMO" },
	{  9079, "ISC3" },
	{  9080, "CCS1582" },
	{  9081, "GTI (HK) Ltd" },
	{  9082, "Unicom 3" },
	{  9083, "Voice Exchange Ltd" },
	{  9084, "KWHK" },
	{  9085, "TMHK-2" },
	{  9086, "HKCSW 1" },
	{  9087, "CMCC-HKISC" },
	{  9088, "Bayon G1" },
	{  9089, "Bayon G2" },
	{  9090, "RT11" },
	{  9091, "RT12" },
	{  9093, "RTI 3" },
	{  9094, "RTI 4" },
	{  9095, "TCT1" },
	{  9097, "VTC1" },
	{  9104, "ETL Saylom ISC" },
	{  9109, "LAT" },
	{  9110, "..." },
	{  9144, "MACSMC1" },
	{  9152, "BEIJING ISC1" },
	{  9153, "..." },
	{  9154, "BEIJING ISC2" },
	{  9155, "Shanghai ISC1" },
	{  9156, "Shanghai ISC2" },
	{  9157, "Guangzhou ISC1" },
	{  9158, "Guangzhou ISC2" },
	{  9159, "YI System Beijing ISC" },
	{  9160, "..." },
	{  9161, "BEIJING ISTP1" },
	{  9162, "Shanghai ISTP1" },
	{  9163, "Shanghai ISTP2" },
	{  9164, "Guangzhou ISTP1" },
	{  9165, "Guangzhou Gateway 1" },
	{  9166, "Qing Dao" },
	{  9167, "Shen Zhen" },
	{  9168, "Shanghai ISTP" },
	{  9169, "Beijing Gateway 1" },
	{  9170, "Beijing Gateway 2" },
	{  9171, "Shanghai Gateway 2" },
	{  9172, "Guangzhou Gateway 3" },
	{  9173, "Guangzhou Gateway 2" },
	{  9174, "Shanghai Gateway 1" },
	{  9175, "Shanghai NGN" },
	{  9176, "Beijing CDMA-ITP 1" },
	{  9177, "Guangzhou ISC" },
	{  9178, "Shanghai ISC" },
	{  9179, "Beijing ISC 1" },
	{  9180, "Guangzhou ISC 2" },
	{  9181, "Shanghai ISC 2" },
	{  9182, "Beijing ISC 2" },
	{  9183, "Beijing CDMA-ITP" },
	{  9184, "Shanghai CDMA-ITP" },
	{  9185, "Beijing ISTP 1" },
	{  9186, "Shanghai ISTP 1" },
	{  9187, "Beijing ISCP" },
	{  9188, "Beijing ISC" },
	{  9189, "Shanghai ISC" },
	{  9190, "Guangzhou ISC" },
	{  9191, "Guangzhou NGN" },
	{  9192, "Beijing Inmarsat" },
	{  9193, "Beijing Inmarsat-F" },
	{  9194, "Beijing ISC" },
	{  9195, "Shanghai ISC" },
	{  9196, "Guangzhou ISC" },
	{  9197, "Shanghai ISC" },
	{  9198, "Guangzhou ISC" },
	{  9199, "Guangzhou CDMA-ITP" },
	{  9200, "Beijing ISC 1" },
	{  9201, "Beijing ISC" },
	{  9202, "Beijing ISC 2" },
	{  9203, "Guangzhou ISC" },
	{  9204, "Beijing ISC" },
	{  9205, "Shanghai ISC" },
	{  9206, "Guangzhou ISC" },
	{  9207, "Guangzhou ISC 2" },
	{  9208, "Shuang CDMA-ITP1" },
	{  9209, "Guang CDMA-ITP1" },
	{  9210, "BEI CDMA-ITP" },
	{  9211, "BEI CDMA-ITP1" },
	{  9212, "BEI Gateway" },
	{  9213, "Shang Gateway" },
	{  9214, "Guang Gateway" },
	{  9280, "Roshan" },
	{  9281, "Roshan" },
	{  9282, "Roshan" },
	{  9283, "Roshan" },
	{  9284, "Roshan" },
	{  9285, "Roshan" },
	{  9286, "Roshan" },
	{  9287, "Roshan" },
	{  9288, "MSC-HRT" },
	{  9289, "MSC-M2R" },
	{  9290, "MSC-JLD" },
	{  9291, "MSC-KDR" },
	{  9313, "GMSC at Hosna Chamber, Gulshan Dhaka" },
	{  9314, "ITX-1/3 Magbazar, Dhaka" },
	{  9315, "ITX-2 Mohakhali, Dhaka" },
	{  9316, "ITX-4 Sylhet" },
	{  9317, "ITX-5 Mohakhali, Dhaka" },
	{  9318, "GMSC Mohakhali, Dhaka" },
	{  9319, "GMSC Mohakhali, Dhaka" },
	{  9321, "ITX-6, Moghbazar, Dhaka" },
	{  9322, "ITX-7, Moghbazar, Dhaka" },
	{  9323, "GMSC, Motijheel, Dhaka" },
	{  9324, "GMSC, Uttara, Dhaka" },
	{  9325, "GMSC, Facilities Tower, Badda Dhaka" },
	{  9326, "GMSC, 3rd Floor, Pacific Center, 14 Mohakhali C/A, Dhaka" },
	{  9327, "GMSC, Ramna, Dhaka" },
	{  9329, "International Gateway, Banani, Dhaka" },
	{  9330, "International Gateway, Gulshan, Dhaka" },
	{  9331, "International Gateway, Eskaton, Dhaka" },
	{  9345, "DHRS3" },
	{  9346, "DHRMSC01" },
	{  9347, "WTMMSC01" },
	{  9348, "DHRMSC02" },
	{  9349, "WTM001" },
	{  9350, "DHRSOFTSWITCH01" },
	{  9351, "DHIRAAGU WCS1" },
	{  9352, "..." },
	{  9353, "Seoul Gateway" },
	{  9354, "..." },
	{  9355, "..." },
	{  9356, "..." },
	{  9357, "..." },
	{  9358, "..." },
	{  9359, "..." },
	{  9368, "Gwacheon Gateway" },
	{  9369, "Seoul Gateway" },
	{  9370, "..." },
	{  9371, "Seoul Gateway" },
	{  9372, "..." },
	{  9373, "..." },
	{  9374, "Seoul Gateway" },
	{  9375, "Seoul Gateway" },
	{  9376, "..." },
	{  9377, "Seoul Gateway" },
	{  9378, "Seoul Gateway" },
	{  9379, "Seoul Gateway" },
	{  9380, "..." },
	{  9381, "..." },
	{  9382, "..." },
	{  9383, "Seoul Gateway" },
	{  9384, "..." },
	{  9385, "..." },
	{  9386, "..." },
	{  9387, "..." },
	{  9388, "..." },
	{  9389, "..." },
	{  9390, "Seoul Gateway" },
	{  9391, "..." },
	{  9392, "Seoul Gateway" },
	{  9393, "..." },
	{  9394, "..." },
	{  9395, "..." },
	{  9396, "..." },
	{  9397, "Seoul Gateway" },
	{  9398, "..." },
	{  9399, "Seoul Gateway" },
	{  9400, "..." },
	{  9401, "Seoul Gateway" },
	{  9402, "..." },
	{  9403, "..." },
	{  9404, "Pusan" },
	{  9405, "Seoul Gateway" },
	{  9406, "Seoul Gateway" },
	{  9407, "..." },
	{  9408, "Seoul Gateway" },
	{  9409, "..." },
	{  9410, "..." },
	{  9411, "..." },
	{  9412, "..." },
	{  9413, "..." },
	{  9414, "..." },
	{  9415, "..." },
	{  9416, "Seoul Gateway" },
	{  9417, "Seoul Gateway" },
	{  9418, "Pusan Gateway" },
	{  9419, "..." },
	{  9420, "..." },
	{  9421, "..." },
	{  9422, "..." },
	{  9423, "..." },
	{  9424, "reserved" },
	{  9425, "reserved" },
	{  9426, "reserved" },
	{  9427, "reserved" },
	{  9428, "reserved" },
	{  9429, "reserved" },
	{  9430, "reserved" },
	{  9431, "reserved" },
	{  9448, "Dushanbe" },
	{  9449, "Dushanbe" },
	{  9450, "Dushanbe" },
	{  9451, "Dushanbe" },
	{  9452, "Khujand" },
	{  9453, "Dushanbe" },
	{  9454, "Khujand" },
	{  9455, "Khujand" },
	{  9456, "Dushanbe" },
	{  9457, "Dushanbe" },
	{  9458, "Khujand" },
	{  9459, "Dushanbe" },
	{  9460, "Khujand" },
	{  9461, "Dushanbe" },
	{  9462, "Khujand" },
	{  9463, "reserved" },
	{  9473, "Ashgabat" },
	{  9505, "Tashkent EWSD" },
	{  9506, "Tashkent AXE-10" },
	{  9507, "Tashkent NEAX-61" },
	{  9600, "Expresstonehk" },
	{  9601, "H6" },
	{  9602, "China Virtual (HR) Ltd" },
	{  9603, "ISC-M800-01" },
	{  9604, "HKIFCTP5" },
	{  9605, "H10" },
	{  9606, "Mangotone International Ltd" },
	{  9607, "HNKNHKBX00T" },
	{  9608, "China Leader" },
	{  9609, "CITIC 3" },
	{  9610, "CTI/HKG3" },
	{  9611, "FNT-HK" },
	{  9612, "ChinaMotion Netcom (Asia) Ltd." },
	{  9614, "Digital Pacific" },
	{  9615, "IDD 1628" },
	{  9616, "ONE.TEL1" },
	{  9617, "CMTEL" },
	{  9618, "Topbest" },
	{  9619, "CITIC2" },
	{  9620, "HKCSL" },
	{  9621, "HKtele1" },
	{  9622, "HKEXCEL" },
	{  9623, "APT Telecom Services Ltd." },
	{  9624, "HKIFCTP6" },
	{  9625, "CITIC4" },
	{  9626, "PNET" },
	{  9627, "CNHKC1" },
	{  9628, "CRC-HK" },
	{  9629, "HKCNW-1" },
	{  9630, "CITIC5" },
	{  9631, "VMSHK1" },
	{  9632, "EC Telecom VS3000 Switch" },
	{  9633, "TMHK" },
	{  9634, "PIDD" },
	{  9635, "South China Telecommunications (HK) Ltd." },
	{  9636, "HTHKIU3" },
	{  9637, "Systech Telecom Ltd" },
	{  9638, "CNHK2" },
	{  9639, "Kwai Chung/HKG3" },
	{  9640, "SUN55" },
	{  9641, "CMCC-HKISC2" },
	{  9642, "C&C08#2" },
	{  9643, "HTHKIU4" },
	{  9644, "HKGW02" },
	{  9645, "ISC-M800-02" },
	{  9647, "SLT HK" },
	{  9712, "MTNLK 03" },
	{  9713, "MTNLK 04" },
	{  9714, "MOBI/WELI2" },
	{  9715, "ATLMSS01" },
	{  9716, "TOLLGATEWAY-2, Colombo" },
	{  9717, "HTLL-INT-PC" },
	{  9718, "Etisalat SL1" },
	{  9719, "Etisalat SL2" },
	{  10088, "SOTUS Fra" },
	{  10089, "SOTUS Riga" },
	{  10090, "IT Baltija" },
	{  10091, "SN Riga" },
	{  10092, "Riga IG 1" },
	{  10093, "..." },
	{  10094, "..." },
	{  10095, "..." },
	{  10104, "London 1" },
	{  10105, "London 2" },
	{  10106, "MIMIR 1" },
	{  10107, "London GSX" },
	{  10108, "Douglas 2" },
	{  10109, "L/FAR/HM1 AXD" },
	{  10110, "L/FAR/SM1 AXD" },
	{  10111, "Int SCCP Signalling connection with Belgacom" },
	{  10112, "Epilson2" },
	{  10113, "London 1" },
	{  10114, "London 1" },
	{  10115, "London 1" },
	{  10116, "London 1" },
	{  10117, "QiComm 1" },
	{  10118, "Leigh" },
	{  10119, "Hawaii 1" },
	{  10128, "Kyiv" },
	{  10129, "Kyiv" },
	{  10130, "Kyiv" },
	{  10131, "Kyiv" },
	{  10132, "Lviv" },
	{  10133, "Kyiv" },
	{  10134, "Kyiv" },
	{  10135, "Kyiv" },
	{  10136, "VFN-INT-ITP1" },
	{  10137, "VFN-INT-ITP4" },
	{  10144, "60326 Frankfurt" },
	{  10145, "60314 Frankfurt" },
	{  10146, "60326 Frankfurt" },
	{  10147, "60326 Frankfurt" },
	{  10148, "44139 Dortmund" },
	{  10149, "30131 Hannover" },
	{  10150, "60326 Frankfurt" },
	{  10151, "60326 Frankfurt" },
	{  10152, "ISN-A1" },
	{  10153, "OTE 1" },
	{  10154, "OTE 2" },
	{  10155, "ON-ATH" },
	{  10156, "TEMAE 3" },
	{  10157, "ON-ATHB" },
	{  10158, "Kvlonos Antigonis 4" },
	{  10159, "..." },
	{  10160, "60326 Frankfurt" },
	{  10161, "60327 Frankfurt" },
	{  10162, "60326 Frankfurt" },
	{  10163, "60427 Frankfurt" },
	{  10164, "60326 Frankfurt" },
	{  10165, "60326 Frankfurt" },
	{  10166, "60326 Frankfurt" },
	{  10167, "60528 Frankfurt" },
	{  10168, "Hawaii 2" },
	{  10169, "London 1" },
	{  10170, "London 1" },
	{  10171, "LMUK-MSC2" },
	{  10172, "London" },
	{  10173, "Xgate" },
	{  10174, "Irwell" },
	{  10175, "Tufnell Park AXD B" },
	{  10176, "..." },
	{  10177, "..." },
	{  10178, "..." },
	{  10179, "..." },
	{  10180, "..." },
	{  10184, "..." },
	{  10185, "..." },
	{  10186, "..." },
	{  10187, "..." },
	{  10188, "..." },
	{  10189, "..." },
	{  10190, "..." },
	{  10191, "..." },
	{  10192, "Ostrow Mazowiecka" },
	{  10193, "Warszawa" },
	{  10194, "Warszawa" },
	{  10195, "Warszawa" },
	{  10196, "Warszawa" },
	{  10197, "Warszawa" },
	{  10198, "Poznan I" },
	{  10200, "STP Bratislava" },
	{  10201, "STP Banska Bystrica" },
	{  10202, "MSC Svaty Jur" },
	{  10203, "MSC Kosice" },
	{  10204, "ISC Bratislava" },
	{  10205, "SonusTest" },
	{  10206, "SonusTest" },
	{  10207, "ISC Kosice" },
	{  10208, "..." },
	{  10209, "..." },
	{  10210, "..." },
	{  10211, "..." },
	{  10213, "..." },
	{  10214, "..." },
	{  10215, "..." },
	{  10216, "Fucino 1" },
	{  10217, "London 2" },
	{  10218, "Usk" },
	{  10219, "UK2" },
	{  10220, "London 1" },
	{  10221, "Fucino 2" },
	{  10222, "Telehouse" },
	{  10223, "UC London 1" },
	{  10224, "London" },
	{  10225, "ESS_Int_Sig" },
	{  10226, "Expo 1" },
	{  10227, "Expo 2" },
	{  10228, "M66" },
	{  10229, "M67" },
	{  10230, "1London 1" },
	{  10231, "Telehouse1" },
	{  10232, "King's Cross" },
	{  10233, "London Harbour Exchange" },
	{  10234, "London" },
	{  10235, "Belfast Switch 1" },
	{  10236, "Digitalk Euro" },
	{  10237, "Manchester DMS 100 1" },
	{  10238, "Tufnell Park" },
	{  10239, "London" },
	{  10264, "RSHSSHW01" },
	{  10265, "RSHSGHW01" },
	{  10266, "RCHSGHW01" },
	{  10267, "KLJSCHW01" },
	{  10268, "..." },
	{  10269, "..." },
	{  10272, "LBN" },
	{  10273, "KLJ" },
	{  10274, "KLR" },
	{  10275, "TM IGWKL1" },
	{  10276, "TM IGWKL2" },
	{  10277, "TM IGWKL3" },
	{  10278, "CEL IGWSHT" },
	{  10279, "CEL IGWKPG" },
	{  10280, "KT1" },
	{  10281, "FINLA" },
	{  10282, "IGWYSHT01" },
	{  10283, "IGWYKPG01" },
	{  10284, "XINTELISW" },
	{  10285, "TELSHINE IGW1" },
	{  10286, "DTI" },
	{  10287, "MTI" },
	{  10288, "STI" },
	{  10289, "DTI2" },
	{  10290, "Time ISC (Glenmarie)" },
	{  10291, "Time ISC (UPM)" },
	{  10292, "Time ISC (PJ)" },
	{  10293, "TM IGWKL4" },
	{  10294, "TM IGWKL5" },
	{  10295, "TM IGWKL6" },
	{  10296, "TM IGWKL7" },
	{  10297, "Skudai DTS" },
	{  10298, "Johor Bharu DTS" },
	{  10299, "Melaka DTS" },
	{  10300, "TM IGWKL8" },
	{  10301, "Kota Kinabatu DTS" },
	{  10302, "Stampin DTS" },
	{  10303, "Miri DTS" },
	{  10304, "Pasir Mas DTS" },
	{  10305, "Bandar Tun Razak DTS" },
	{  10306, "Raja Chulan DTS" },
	{  10307, "Teruntum DTS" },
	{  10308, "MSHTA" },
	{  10309, "Penampang DTS" },
	{  10310, "Penang DTS" },
	{  10311, "Alor Setar DTS" },
	{  10312, "CEL IGWSAL1" },
	{  10313, "CEL IGWKPG2" },
	{  10314, "MGHTA" },
	{  10315, "IGSTA" },
	{  10316, "IGWSTA" },
	{  10317, "UPSHB" },
	{  10318, "TTIG1" },
	{  10319, "SCSGHWO1" },
	{  10320, "Sydney" },
	{  10321, "Sydney" },
	{  10322, "S12 Model No. 1" },
	{  10323, "IN Test Platform" },
	{  10324, "Sydney" },
	{  10325, "Sydney" },
	{  10326, "Sydney" },
	{  10327, "Sydney" },
	{  10328, "Sydney, SYF6" },
	{  10329, "Sydney Test Switch" },
	{  10330, "Sydney" },
	{  10331, "Sydney" },
	{  10332, "Mobile Satellite - Geostationary" },
	{  10333, "Mobile Satellite - Geostationary" },
	{  10334, "Mobile Satellite - MEO (NGII)" },
	{  10335, "Mobile Satellite - MEO" },
	{  10336, "Sydney switch ID = S2SB" },
	{  10337, "Melbourne switch ID = S3MA" },
	{  10338, "Melbourne switch ID = S3MB" },
	{  10339, "REIN" },
	{  10340, "Melbourne - Australia-IPSYSTEMS-SLT-1" },
	{  10341, "Melbourne - Australia-IPSYSTEMS-SLT-2" },
	{  10342, "TNZAI" },
	{  10343, "Melbourne" },
	{  10344, "Sydney" },
	{  10345, "Sydney" },
	{  10346, "Sydney" },
	{  10347, "Melbourne" },
	{  10348, "Melbourne" },
	{  10349, "Sydney" },
	{  10350, "Sydney" },
	{  10351, "BT Global Office Sydney Can" },
	{  10352, "Sydney" },
	{  10353, "Sydney" },
	{  10354, "Sydney" },
	{  10355, "Norfolk Island - GSMC" },
	{  10356, "Norfolk Island - International Switch PSTN gateway" },
	{  10357, "IDT-Sydney" },
	{  10358, "Sydney" },
	{  10359, "Sydney" },
	{  10360, "Sydney" },
	{  10361, "Sydney" },
	{  10363, "Globalstar Sydney" },
	{  10364, "Sydney" },
	{  10365, "Melbourne" },
	{  10366, "Sydney" },
	{  10367, "Perth" },
	{  10368, "Sydney" },
	{  10369, "Sydney" },
	{  10370, "Melbourne" },
	{  10371, "Melbourne (1999)" },
	{  10372, "Melbourne (1999)" },
	{  10373, "Sydney (1999)" },
	{  10374, "Sydney (Siemens)" },
	{  10375, "Melbourne (Siemens)" },
	{  10376, "SYF6" },
	{  10377, "SYF7" },
	{  10378, "SYF8" },
	{  10379, "SYF9" },
	{  10380, "Cell Wireless Switch - Sydney" },
	{  10381, "Sydney" },
	{  10382, "Pivotel Sydney 1" },
	{  10383, "Pivotel Sydney 2" },
	{  10384, "I Syd" },
	{  10385, "SGX-Sydney" },
	{  10386, "NTMI - SYD01" },
	{  10387, "NTMI - SYD02" },
	{  10388, "NTMI - BRI01" },
	{  10389, "NTMI - BRI02" },
	{  10390, "NTMI - MEL01" },
	{  10391, "NTMI - MEL02" },
	{  10392, "Sydney, SYDT" },
	{  10393, "Sydney, SYD0" },
	{  10394, "Melbourne, MEZ0" },
	{  10395, "Sydney, SYF1" },
	{  10396, "SYF2" },
	{  10397, "Sydney, SYF3" },
	{  10398, "Sydney, SYF4" },
	{  10399, "Sydney, SYF5" },
	{  10400, "Jakarta-1b ISC" },
	{  10401, "Jakarta-1a ISC" },
	{  10402, "Medan-2a ISC" },
	{  10403, "Batam-3 ISC" },
	{  10404, "Surabaya-4 ISC" },
	{  10405, "Int'l SCCP-1" },
	{  10406, "Jakarta-1 ISC" },
	{  10407, "Jakarta-2 ISC" },
	{  10408, "Jakarta-1C ISC" },
	{  10409, "Int'l SCCP" },
	{  10410, "Medan-2b ISC" },
	{  10411, "ICO SP" },
	{  10412, "IN SP" },
	{  10413, "Medan ISC" },
	{  10414, "Int'l SCCP" },
	{  10415, "Denpasar ISC" },
	{  10416, "Int'l SCCP" },
	{  10417, "Int'l SCCP-1" },
	{  10418, "Int'l SCCP-2" },
	{  10419, "Int'l SCCP" },
	{  10420, "reserved" },
	{  10421, "Int'l ISC" },
	{  10422, "Int'l ISC" },
	{  10423, "Int'l ISC" },
	{  10424, "STP Jakarta" },
	{  10425, "STP Surabaya" },
	{  10426, "Int'l SCCP-1" },
	{  10427, "SCCP" },
	{  10428, "Batam ISC" },
	{  10429, "SCCP" },
	{  10430, "Jakarta ISC" },
	{  10431, "Surabaya ISC" },
	{  10432, "..." },
	{  10433, "..." },
	{  10434, "..." },
	{  10435, "..." },
	{  10436, "..." },
	{  10437, "..." },
	{  10480, "..." },
	{  10481, "Metro Manila 1" },
	{  10482, "Metro Manila 2" },
	{  10483, "Metro Manila 3" },
	{  10484, "..." },
	{  10485, "..." },
	{  10486, "..." },
	{  10487, "..." },
	{  10488, "..." },
	{  10489, "..." },
	{  10490, "..." },
	{  10491, "..." },
	{  10492, "..." },
	{  10493, "SCC, Makati City" },
	{  10494, "SCC, Makati City" },
	{  10495, "SCC, Makati City" },
	{  10496, "..." },
	{  10497, "..." },
	{  10498, "..." },
	{  10499, "..." },
	{  10500, "Manila GSM" },
	{  10501, "GSM" },
	{  10502, "GSM" },
	{  10503, "Cebu City GSM" },
	{  10504, "..." },
	{  10505, "..." },
	{  10506, "..." },
	{  10507, "..." },
	{  10508, "..." },
	{  10509, "..." },
	{  10510, "..." },
	{  10511, "..." },
	{  10512, "Makati City" },
	{  10513, "Makati City" },
	{  10514, "Makati City" },
	{  10515, "..." },
	{  10516, "..." },
	{  10517, "..." },
	{  10518, "..." },
	{  10519, "..." },
	{  10520, "..." },
	{  10521, "GSM" },
	{  10522, "GSM" },
	{  10523, "..." },
	{  10524, "..." },
	{  10525, "..." },
	{  10526, "..." },
	{  10527, "..." },
	{  10528, "..." },
	{  10529, "..." },
	{  10530, "..." },
	{  10531, "..." },
	{  10532, "..." },
	{  10533, "..." },
	{  10534, "..." },
	{  10535, "..." },
	{  10536, "..." },
	{  10537, "..." },
	{  10538, "..." },
	{  10539, "..." },
	{  10540, "..." },
	{  10541, "..." },
	{  10542, "..." },
	{  10560, "ITSC4B" },
	{  10561, "ITSC I/ISM1" },
	{  10562, "ITSC2/IMS2" },
	{  10563, "ITSC3/STP3" },
	{  10564, "ITSC4A" },
	{  10565, "STP1" },
	{  10566, "STP2" },
	{  10567, "STP4" },
	{  10568, "ST-RST" },
	{  10569, "TOT ISG1 - KKM" },
	{  10570, "TOT IGW1 - KKM" },
	{  10571, "TOT IGW2 - HYI" },
	{  10572, "TOT ISG2 - HYI" },
	{  10573, "NSC1-KKM" },
	{  10574, "NSC1-HYI" },
	{  10575, "..." },
	{  10576, "IG-RST" },
	{  10577, "BPL/POI (AIN-ISC1)" },
	{  10578, "RST/POI (AIN-ISC2)" },
	{  10579, "N&T STP-A" },
	{  10580, "N&T STP-B" },
	{  10581, "N&T SG" },
	{  10582, "ST-SNK" },
	{  10583, "IG-SNK" },
	{  10584, "..." },
	{  10585, "..." },
	{  10586, "..." },
	{  10587, "..." },
	{  10600, "SingTel OC - INGS-3" },
	{  10601, "SingTel OC - STP-1" },
	{  10602, "SingTel OC  - STP-2" },
	{  10603, "SingTel OC - STP-3" },
	{  10604, "Telekom Malaysia - Equinix 3" },
	{  10605, "Telekom Malaysia - Equinix 4" },
	{  10606, "Grand Pacific - Equinix" },
	{  10607, "Callforeign - Equinix" },
	{  10608, "StarHub - TSS-STP-3" },
	{  10609, "SingTel Globalstar - SSP-1" },
	{  10610, "SingTel Globalstar - STP-1" },
	{  10611, "SingTel Globalstar - STP-2" },
	{  10612, "SingTel AR - INGS-1" },
	{  10613, "SingTel AR - STP-1" },
	{  10614, "SingTel OC - INGS-1" },
	{  10615, "SingTel OC - INGS-2" },
	{  10616, "FM-STP1" },
	{  10617, "FM-STP2" },
	{  10618, "Touchtone-Equinix, Ayer Rajah" },
	{  10619, "Global Crossing - Tai Seng Drive" },
	{  10620, "StarHub - KJS-STP-2" },
	{  10621, "StarHub - TSS-STP-2" },
	{  10622, "Telecom NZ - Equinix" },
	{  10623, "StarHub - KBS-STP-3" },
	{  10624, "Macquarie Primary - Taiseng" },
	{  10625, "Ocean network - I-STT Data Centre" },
	{  10626, "Bludot-Pantech 21" },
	{  10627, "VSNL-SNG Cable Landind Station" },
	{  10628, "M1-MOC-STP" },
	{  10629, "M1-ROC-STP" },
	{  10630, "Asia Netcom - Tai Seng" },
	{  10631, "China Motion - I-STT" },
	{  10632, "StarHub-KBS-STP" },
	{  10633, "StarHub-TSS-STP" },
	{  10634, "VSNL-Tai Seng" },
	{  10636, "C&W Equinix, Ayer Rajah" },
	{  10637, "Singapore Smart Telecom - Equinix Ayer Rajah" },
	{  10638, "BT Singapore - Tai Seng Drive" },
	{  10639, "SingTel-ITP 1" },
	{  10640, "Enhanced Software Service Centre (SCII)" },
	{  10641, "Gateway (SNE)" },
	{  10642, "Gateway (SNC)" },
	{  10643, "GSM (MSC1) (CMRS3)" },
	{  10644, "GSM (MSC2) (CMRS3)" },
	{  10645, "Gateway (SNP)" },
	{  10646, "GATES (SSP)" },
	{  10647, "GT/GATES Software Service Centre" },
	{  10648, "Media Gateway Controller - MGC A" },
	{  10649, "Media Gateway Controller - MGC B" },
	{  10650, "City Interconnect Tandem (CYNX)" },
	{  10651, "Hougan Interconnect Tandem (HGNX)" },
	{  10652, "Pickering Gateway-Trunk (PGT)" },
	{  10653, "Comcentre Gateway-Trunk (CGT)" },
	{  10654, "PLDT - Ayer Rajah Crescent" },
	{  10655, "Inmarsat B (Planned)" },
	{  10656, "GATES (Planned)" },
	{  10657, "GATES (Planned)" },
	{  10658, "SESS Model 2000 Software Service Centre" },
	{  10659, "GNC (Global Network Comcentre)" },
	{  10660, "MCI - Singapore 1" },
	{  10661, "M1-MOC" },
	{  10662, "M1-ROC" },
	{  10664, "KPJI Switch" },
	{  10665, "TSGI Switch" },
	{  10666, "I2U - Singapore Technologies Building" },
	{  10667, "Redtone Technology - Equinix" },
	{  10668, "ETN Singapore - Ayer Rajah Crescent" },
	{  10669, "MCI - Singapore 2" },
	{  10670, "France Telecom - Chai Chee" },
	{  10671, "Tridor - Ayer Rajah Crescent" },
	{  10672, "Asiakomnet - Equinix" },
	{  10673, "Telekom Malaysia - Equinix" },
	{  10674, "Telekom Malaysia - Equinix 2" },
	{  10675, "Itopia-GNCC" },
	{  10677, "TelcomUnited - Kimly Bldg" },
	{  10678, "Phoenix-Comcentre III" },
	{  10679, "SunPage Communications - Ang Mo Kio" },
	{  10680, "ETNS - Changi" },
	{  10681, "Interconnect Technology - Kimly Bdlg" },
	{  10682, "PLDT - Tai Seng Drive" },
	{  10683, "Teleone Tai Seng Drive" },
	{  10684, "M1-SCCP1" },
	{  10685, "M1-SCCP2" },
	{  10686, "SingTel-ITP 2" },
	{  10687, "Macquarie Secondary - Taiseng" },
	{  10688, "DST International Gateway 2" },
	{  10689, "BR1" },
	{  10690, "BR2" },
	{  10691, "DST International Gateway" },
	{  10692, "DST International Gateway 2" },
	{  10693, "..." },
	{  10694, "..." },
	{  10695, "..." },
	{  10720, "MayoralDrive GTYS" },
	{  10721, "Takapuna GTY6" },
	{  10722, "..." },
	{  10723, "..." },
	{  10724, "..." },
	{  10725, "..." },
	{  10726, "Easycall" },
	{  10727, "Mayoral Drive GTY7" },
	{  10728, "..." },
	{  10729, "..." },
	{  10730, "..." },
	{  10731, "..." },
	{  10732, "..." },
	{  10733, "Mayoral Drive STP" },
	{  10734, "..." },
	{  10735, "Takapuna STP" },
	{  10744, "..." },
	{  10745, "..." },
	{  10746, "..." },
	{  10747, "..." },
	{  10748, "..." },
	{  10749, "Mayoral Drive STP" },
	{  10750, "Takapuna STP" },
	{  10751, "..." },
	{  10760, "..." },
	{  10761, "..." },
	{  10762, "..." },
	{  10763, "..." },
	{  10764, "..." },
	{  10765, "..." },
	{  10766, "WCS1" },
	{  10767, "WCS2" },
	{  10776, "..." },
	{  10777, "..." },
	{  10778, "..." },
	{  10779, "..." },
	{  10780, "..." },
	{  10781, "..." },
	{  10782, "..." },
	{  10783, "..." },
	{  10800, "Harmon (1), Guam" },
	{  10801, "Harmon, Guam" },
	{  10803, "Harmon (3), Guam" },
	{  10804, "Harmon, Guam" },
	{  10805, "Upper Tumon, Guam" },
	{  10818, "Digicel Nauru Ltd" },
	{  10819, "Digicel Nauru Ltd" },
	{  10832, "LAEMGW" },
	{  10833, "LAEMSC-S" },
	{  10834, "POM_MSC_1" },
	{  10835, "LAEG" },
	{  10836, "POMG" },
	{  10837, "POM_MSC" },
	{  10838, "POMMSC-S" },
	{  10839, "B-Mobile" },
	{  10842, "POMMGW" },
	{  10864, "Nuku'alofa switch" },
	{  10869, "..." },
	{  10896, "Port Vila" },
	{  10897, "Port Vila" },
	{  10899, "MGW Port-Vila" },
	{  10902, "Digical Pacific Ltd, Hong Kong" },
	{  10903, "Ellouk, Port Vila, Vanuatu" },
	{  10912, "FINTEL ISC-1" },
	{  10913, "FINTEL ISC-2" },
	{  10914, "VODAFONE MSC-1" },
	{  10915, "VODAFONE MGw-1 Suva" },
	{  10916, "Vodafone MGw Lautoka" },
	{  10917, "Vodafone MSC-2 Lautoka" },
	{  10918, "DIGICEL MSC" },
	{  10919, "DIGICEL" },
	{  10920, "FINTEL STP-1" },
	{  10921, "FINTEL STP-2" },
	{  10922, "FINTEL FW" },
	{  10923, "FINTEL-3" },
	{  10944, "Pago Pago, American Samoa" },
	{  10976, "Noumea Gallieni" },
	{  10977, "Noumea PK5" },
	{  10978, "Noumea PK5IGP1" },
	{  10992, "Commutateur Papeete" },
	{  10993, "Commutateur FAAA" },
	{  10994, "Centre de commutation, Papeete" },
	{  10995, "Papeete" },
	{  10996, "Commutateur Papeete" },
	{  10997, "STP Papeete" },
	{  11024, "Apia" },
	{  11096, "Kolonia, GSM" },
	{  11097, "Kolonia, PSTN" },
	{  11144, "Saipan, Northern Marianas" },
	{  11160, "SYF 10" },
	{  11161, "SYF 11" },
	{  11162, "SYF 12" },
	{  11163, "SYF 13" },
	{  11164, "PCM1" },
	{  11165, "Sydney PYR1" },
	{  11166, "Sydney GLB1" },
	{  11167, "Sydney CAS1" },
	{  11168, "Sydney PCM2" },
	{  11169, "...." },
	{  11170, "EPSI (Sydney1)" },
	{  11171, "EPS2 (Sydney2)" },
	{  11172, "EPM1 (Melbourne1)" },
	{  11173, "EPM2 (Melbourne2)" },
	{  11174, "Sydney" },
	{  11175, "Melbourne" },
	{  11176, "..." },
	{  11177, "..." },
	{  11178, "..." },
	{  11179, "..." },
	{  11180, "..." },
	{  11181, "TP1SYDNEY" },
	{  11182, "SYD-DIG01" },
	{  11183, "SYD-DIG02" },
	{  11184, "ANCSYD01" },
	{  11185, "GSX-Sydney" },
	{  11186, "Tel.Pacific-Sydney-01" },
	{  11187, "Tel.Pacific-Sydney-02" },
	{  11188, "TP2SYDNEY" },
	{  11189, "TP1MELBOURNE" },
	{  11190, "TP2MELBOURNE" },
	{  11191, "TP1BRISBANE" },
	{  11192, "TP1CANBERRA" },
	{  11193, "TP1PERTH" },
	{  11194, "TP1ADELAIDE" },
	{  11195, "TP1NEWCASTLE" },
	{  11196, "ATX-MELBOURNE Q767-1" },
	{  11197, "ATX-SYDNEY Q767-1" },
	{  11198, "Sydney - Australia-IPSYSTEMS-SLT-1" },
	{  11199, "Sydney - Australia-IPSYSTEMS-SLT-2" },
	{  11200, "MelbVzbIMG-1" },
	{  11201, "MelbVzbIMG-1" },
	{  11202, "CHIME-SSP-SYD" },
	{  11203, "CHIME-SSP-SYD" },
	{  11204, "BNE2 - MEDIAGW01" },
	{  11205, "SYM-IMG-WS-02-MAS-AV" },
	{  11206, "CHIME-STP-SYD2" },
	{  11207, "GG-SYDNEY-1" },
	{  11281, "Dili" },
	{  11282, "TT M-2 (NOVA)" },
	{  11360, "M1-NGN SG1" },
	{  11361, "M1-NGN SS1" },
	{  11362, "TELIN - ISS" },
	{  11363, "Epsilon - Smilous" },
	{  11365, "Belgacom Equinix" },
	{  11366, "Califoreign - Equinix" },
	{  11367, "HOIIO" },
	{  12000, "TMMK MGw2" },
	{  12001, "MGW Makedonija" },
	{  12105, "..." },
	{  12112, "iCON" },
	{  12113, "Orange" },
	{  12114, "Fastnet" },
	{  12115, "Corssnet" },
	{  12116, "Dzoraxbyur" },
	{  12117, "Netsys Armenia" },
	{  12118, "Calline" },
	{  12119, "Interactive" },
	{  12120, "3GT" },
	{  12121, "Go2" },
	{  12128, "..." },
	{  12129, "..." },
	{  12130, "..." },
	{  12131, "..." },
	{  12132, "..." },
	{  12133, "..." },
	{  12134, "..." },
	{  12136, "MTNCYSTP1" },
	{  12137, "MTNCYSTP2" },
	{  12138, "MTNCYMGW1" },
	{  12139, "MTNCYMGW2" },
	{  12144, "..." },
	{  12145, "..." },
	{  12152, "ARNSTP01, Arnhem" },
	{  12153, "MSC, Den Haag 2" },
	{  12154, "ASDSTP2A, Amsterdam" },
	{  12155, "RTSTP2A, Rotterdam" },
	{  12156, "Stratos_burum_02_telesis, Burum" },
	{  12157, "NLGMSC, Amsterdam" },
	{  12158, "NLSCCPGW, Amsterdam" },
	{  12160, "60326 Frankfurt" },
	{  12161, "60326 Frankfurt" },
	{  12162, "60326 Frankfurt" },
	{  12163, "50825 Koln" },
	{  12164, "60326 Frankfurt" },
	{  12165, "60326 Frankfurt" },
	{  12166, "60326 Frankfurt" },
	{  12167, "60326 Frankfurt" },
	{  12168, "..." },
	{  12169, "..." },
	{  12170, "..." },
	{  12176, "..." },
	{  12177, "..." },
	{  12178, "..." },
	{  12179, "..." },
	{  12180, "..." },
	{  12181, "..." },
	{  12182, "..." },
	{  12183, "..." },
	{  12184, "HH0MSC03" },
	{  12185, "BM1MSC03" },
	{  12186, "FREYA 1" },
	{  12187, "L/GLS/HM1 AXD" },
	{  12188, "L/GLS/SM1 AXD" },
	{  12189, "Switchware 1" },
	{  12190, "SQ1" },
	{  12191, "LND IC-SWC" },
	{  12200, "60326 Frankfurt" },
	{  12201, "60326 Frankfurt" },
	{  12202, "60326 Frankfurt" },
	{  12203, "60326 Frankfurt" },
	{  12204, "60314 Frankfurt" },
	{  12205, "60326 Frankfurt" },
	{  12206, "60322 Frankfurt" },
	{  12207, "20537 Hamburg" },
	{  12208, "Zurich" },
	{  12209, "Zurich" },
	{  12210, "Zurich" },
	{  12211, "Manno" },
	{  12212, "Renens VD" },
	{  12213, "Renens VD" },
	{  12214, "Zurich" },
	{  12215, "Zurich" },
	{  12216, "Softnet-Telekom-Trunk LJ" },
	{  12217, "Akton Ljubljana 1" },
	{  12218, "TUSMBW1" },
	{  12219, "TUSMSS1" },
	{  12220, "SA-STP Maribor" },
	{  12221, "TUSMGW2" },
	{  12222, "MGw12" },
	{  12223, "MGw22" },
	{  12224, "12224 London 2" },
	{  12225, "12225 London" },
	{  12226, "12226 London 1" },
	{  12227, "12227 UKSA1 UKSA2" },
	{  12228, "12228 London 1" },
	{  12229, "12229 Lebara 3" },
	{  12230, "12230 Greenwich T-49" },
	{  12231, "12231 InfLon1" },
	{  12232, "Unistars Latvia" },
	{  12233, "Riga TB CDMA" },
	{  12234, "IC1" },
	{  12235, "D-COM" },
	{  12236, "Tele 1 ip" },
	{  12237, "Riga TC1" },
	{  12238, "TELV" },
	{  12239, "Riga TP1" },
	{  12240, "Inlife-LJ2" },
	{  12241, "Inlife - LJ3" },
	{  12242, "Inlife - LJ4" },
	{  12243, "T-2 d.o.o. Gateway - Trunk T-2 d.o.o. Ljubljana 1" },
	{  12244, "GW1" },
	{  12245, "CS1" },
	{  12246, "IT-LJ2-SI" },
	{  12247, "SIOL International 1" },
	{  12248, "60326 Frankfurt" },
	{  12249, "33311 Guetersloh" },
	{  12250, "86153 Augsburg" },
	{  12251, "60326 Frankfurt" },
	{  12252, "80807 Munchen" },
	{  12253, "60326 Frankfurt" },
	{  12254, "60326 Frankfurt" },
	{  12255, "60326 Frankfurt" },
	{  12256, "Riga TKG 01" },
	{  12257, "DATA-LV" },
	{  12258, "ITGROU" },
	{  12259, "LDz Latvian Railway" },
	{  12260, "ANS2" },
	{  12261, "BTV 1" },
	{  12262, "BTV 2" },
	{  12263, "FINOR" },
	{  12264, "Warszawa" },
	{  12265, "Gdansk" },
	{  12266, "Poznan" },
	{  12267, "Warszawa II" },
	{  12268, "Warszawa" },
	{  12269, "Zielona Gora" },
	{  12270, "Warszawa" },
	{  12271, "Warszawa" },
	{  12272, "Athens Kronos" },
	{  12273, "Thessaloniki Dias" },
	{  12275, "HOL ISC1" },
	{  12276, "HOL ISC2" },
	{  12277, "TIM Hellas ISC" },
	{  12278, "TIM HELLAS ISC2" },
	{  12279, "Teledome_INTL_ATH01" },
	{  12280, "Milano/Via Breda, 8 c/o Stazione G. Pirelli" },
	{  12281, "Statale del Lario SS 340 - Loc. Plan di Spagna Gera Lario (CO)" },
	{  12282, "Via Caldera 21 - Milano" },
	{  12283, "Milano - Via Caldera 21" },
	{  12284, "Milano - Via delle Azzalee, 9 Buccinasco" },
	{  12285, "Roma/Via del Fosso di Santa Maura 26" },
	{  12286, "Milano/Via Bensi, 1/8 Liberty B" },
	{  12287, "Roma/Via del Fosso di Santa Maura 26" },
	{  12312, "SIT01, Cairo" },
	{  12313, "SIH01, Cairo" },
	{  12314, "XIT02, Alexandria" },
	{  12315, "SIS01, Cairo" },
	{  12316, "CIH02, Cairo" },
	{  12317, "CIS02, Cairo" },
	{  12320, "CAI 1 Ramsis/Cairo" },
	{  12321, "Alex.1, Mahatet MisrAlexandria" },
	{  12322, "Heliopolis" },
	{  12323, "Obour" },
	{  12325, "Haby 1" },
	{  12326, "Haby 2" },
	{  12330, "SST01, Cairo" },
	{  12331, "XST02, Alexandria" },
	{  12332, "CAI2, Ramsis/Cairo" },
	{  12333, "Alex 2, Mahatet MisrAlexandria" },
	{  12334, "Almaza, Cairo" },
	{  12337, "Alger ISC" },
	{  12339, "Oran ISC" },
	{  12340, "Constantine ISC" },
	{  12343, "Alger MSC (GSM, mobile)" },
	{  12352, "Rabat MSC" },
	{  12353, "Casa  CTI" },
	{  12354, "Rabat, CTI" },
	{  12355, "Casa MSC" },
	{  12356, "Casa MSC" },
	{  12357, "Rabat MSC" },
	{  12360, "Casa CTI" },
	{  12361, "Rabat CTI" },
	{  12362, "..." },
	{  12363, "..." },
	{  12364, "..." },
	{  12368, "Central Kasbash" },
	{  12369, "Central Nabeul" },
	{  12370, "..." },
	{  12371, "..." },
	{  12374, "..." },
	{  12375, "..." },
	{  12384, "International Switching Exchange - Sirt" },
	{  12385, "SMS monitoring system" },
	{  12386, "International Switching Exchange - Tripoli" },
	{  12387, "Telephone service via IP" },
	{  12388, "International Exchange" },
	{  12389, "Libyana Mobile Exchange" },
	{  12390, "Short Messaging System" },
	{  12391, "Al-Madar Mobile Exchange" },
	{  12417, "CTI Thiaroye" },
	{  12418, "CTI Mediria" },
	{  12421, "PTS Technopole" },
	{  12422, "PTS Dakar RP" },
	{  12432, "reserved" },
	{  12433, "CTI No 1" },
	{  12434, "GMSCNKC" },
	{  12435, "GMSC-1 NKC" },
	{  12436, "MSC-2" },
	{  12437, "CTI No2" },
	{  12438, "GMSC-NKC" },
	{  12439, "CTI/CTN-NKC" },
	{  12464, "GSM" },
	{  12465, "CONAKRY" },
	{  12466, "GSM" },
	{  12467, "..." },
	{  12468, "GSM" },
	{  12469, "GSM" },
	{  12470, "CONAKRY" },
	{  12471, "GSM" },
	{  12472, "GSM" },
	{  12473, "GSM" },
	{  12474, "GSM" },
	{  12475, "STP1" },
	{  12476, "STP2" },
	{  12477, "GSM" },
	{  12478, "GSM" },
	{  12479, "GSM" },
	{  12481, "NGP Gateway - Abidjan" },
	{  12482, "CTI - Abidjan" },
	{  12483, "MGW01 - Abidjan" },
	{  12484, "MSOFTS3000 - Abidjan" },
	{  12485, "SOFTX3000 - Abidjan" },
	{  12486, "MSC01 - Abidjan" },
	{  12487, "MSC-T-Abidjan" },
	{  12490, "CTI-Banco/Abidjan" },
	{  12493, "MSS6/Abidjan - Riviera 3" },
	{  12494, "STP1/Abidjan - 2 Plateaux" },
	{  12495, "STP2/Abidjan - Riviera 3" },
	{  12512, "OCB Niamey" },
	{  12513, "GMSC" },
	{  12514, "GMSC" },
	{  12515, "GMSC" },
	{  12516, "ZCXJ 10-MNiamey" },
	{  12518, "GMSC" },
	{  12519, "MGW SGW" },
	{  12528, "CTI Lome" },
	{  12529, "CTI Kara" },
	{  12530, "STP Lome" },
	{  12531, "STP Kara" },
	{  12560, "Port Louis 1" },
	{  12561, "Port Louis 2" },
	{  12562, "Bay Jacotet 1" },
	{  12563, "Bay Jacotet 2" },
	{  12564, "Rose Hill 1" },
	{  12565, "Rose Hill 2" },
	{  12567, "MTML 1" },
	{  12568, "MTML 2" },
	{  12592, "Sierratel Freetown" },
	{  12593, "Zain" },
	{  12594, "Tigo" },
	{  12595, "Sierratel Freetown" },
	{  12596, "Intergroup" },
	{  12597, "Comium" },
	{  12598, "Africell" },
	{  12599, "Ambitel" },
	{  12600, "Atlas Communication" },
	{  12608, "Accra North International Gateway (ITE1)" },
	{  12609, "Cantonments International Gateway (ITE2)" },
	{  12610, "AC1 MSS1" },
	{  12611, "DMS300 Gateway" },
	{  12612, "..." },
	{  12613, "..." },
	{  12614, "..." },
	{  12624, "LGITSC" },
	{  12625, "ENITSC" },
	{  12626, "KDITSC" },
	{  12627, "..." },
	{  12628, "LG1" },
	{  12629, "AS1" },
	{  12630, "AB1" },
	{  12631, "..." },
	{  12632, "LG2" },
	{  12633, "LGMSCO5" },
	{  12634, "LGTSCO1" },
	{  12635, "LGTEX1" },
	{  12636, "ABJTEX3" },
	{  12637, "LGMSC1" },
	{  12638, "..." },
	{  12639, "..." },
	{  12656, "..." },
	{  12657, "..." },
	{  12658, "..." },
	{  12659, "..." },
	{  12660, "..." },
	{  12661, "..." },
	{  12662, "..." },
	{  12663, "..." },
	{  12672, "reserved" },
	{  12673, "..." },
	{  12674, "..." },
	{  12675, "..." },
	{  12676, "..." },
	{  12677, "..." },
	{  12678, "..." },
	{  12679, "reserved" },
	{  12680, "Yaounde" },
	{  12681, "Douala" },
	{  12682, "Yaounde" },
	{  12688, "CVT INTGAT PRAIA" },
	{  12689, "T+INTGAT PRAIA1" },
	{  12690, "T+INTGAT PRAIA2" },
	{  12691, "CVTINTGATPRAIA2" },
	{  12720, "PS International Bata" },
	{  12721, "PS International Malabo" },
	{  12722, "Lien Roaming" },
	{  12723, "Lien SS7 VoIP" },
	{  12736, "Systeme de gestion des reseaux" },
	{  12737, "CTI Libreville" },
	{  12738, "CUI Franceville" },
	{  12739, "Reseau intelligent" },
	{  12740, "Libertis 1" },
	{  12741, "Alantique Telecom (Telecel) 1" },
	{  12742, "Celtel Gabon 1" },
	{  12743, "Libertis 2" },
	{  12744, "..." },
	{  12745, "SCP" },
	{  12746, "SCP-2" },
	{  12747, "..." },
	{  12748, "..." },
	{  12749, "SPC-2" },
	{  12750, "..." },
	{  12751, "..." },
	{  12768, "Kinshasa" },
	{  12769, "Kinshasa" },
	{  12770, "Inato" },
	{  12771, "ILUB" },
	{  12772, "IKNS" },
	{  12773, "IMBJ" },
	{  12774, "IMAT" },
	{  12775, "Kinshasa" },
	{  12776, "Kinshasa" },
	{  12777, "Vodacom Congo SSP01" },
	{  12778, "Vodacom Congo SSP01" },
	{  12779, "INAT01" },
	{  12780, "Kinshasa" },
	{  12781, "Vodacom Congo SSP01" },
	{  12782, "INAT02" },
	{  12784, "ISC1" },
	{  12785, "ISC2" },
	{  12786, "ISC3" },
	{  12787, "ISC4" },
	{  12788, "ISC5" },
	{  12789, "ISC6" },
	{  12790, "ISC7" },
	{  12791, "ISC8" },
	{  12792, "ISC1" },
	{  12816, "E10S1" },
	{  12817, "Seychelles MSC" },
	{  12818, "Media Gateway (MGW)" },
	{  12820, "INTV-MAHE-01" },
	{  12821, "Media Gateway - TSL" },
	{  12822, "Trans Local Switch (TLS)" },
	{  12823, "Mobile Switching Centre (MSC)" },
	{  12832, "ITC Khartoum" },
	{  12833, "ITC UM Haraz" },
	{  12834, "NGN" },
	{  12835, "Signalling Gateway" },
	{  12836, "Soft Switch" },
	{  12837, "UMTS Platform" },
	{  12838, "GMSC" },
	{  12839, "Roaming" },
	{  12840, "SMS" },
	{  12841, "Signalling Gateway" },
	{  12842, "Soft Switch" },
	{  12843, "..." },
	{  12844, "Signalling Gateway" },
	{  12845, "Signalling Gateway" },
	{  12846, "Signalling Gateway" },
	{  12847, "Signalling Gateway" },
	{  12850, "..." },
	{  12865, "Bole" },
	{  12880, "Mogadishu" },
	{  12881, "Hargeysa" },
	{  12882, "Mogadishu" },
	{  12883, "Hargeysa" },
	{  12884, "Bosaso" },
	{  12885, "ASGSM-01" },
	{  12886, "ASGSM-02" },
	{  12887, "Mogadishu/BW" },
	{  12912, "Nairobi" },
	{  12913, "Kericho" },
	{  12914, "Nairobi" },
	{  12915, "Nairobi" },
	{  12916, "Nairobi" },
	{  12917, "Nairobi" },
	{  12918, "Nairobi" },
	{  12919, "Nairobi" },
	{  12928, "ISC" },
	{  12929, "ISC" },
	{  12930, "GMSC" },
	{  12931, "GMSC" },
	{  12932, "GMSC" },
	{  12933, "GMSC" },
	{  12934, "ISC" },
	{  12935, "SCCP" },
	{  12944, "Kampala" },
	{  12945, "Kampala" },
	{  12946, "Kampala" },
	{  12947, "Kampala" },
	{  12948, "Kampala" },
	{  12949, "Kampala" },
	{  12950, "KAMSS3" },
	{  12951, "KAMSS4" },
	{  12952, "SOFTX" },
	{  12953, "MSCSLCRC1" },
	{  12954, "SGWLCRC1" },
	{  12955, "MSCSLBUG1" },
	{  12956, "SGWLBUG1" },
	{  12957, "Kampala/H1I" },
	{  12958, "Kampala/H2I" },
	{  12959, "Kampala/H3I" },
	{  12960, "..." },
	{  12961, "..." },
	{  12963, "..." },
	{  12964, "..." },
	{  12965, "..." },
	{  12966, "..." },
	{  12967, "..." },
	{  12976, "International Transit center" },
	{  12980, "Mobile Switching Center" },
	{  12981, "SSP04" },
	{  12982, "SSPO4" },
	{  12983, "Mobile Switching Center" },
	{  13008, "Lusaka Gateway" },
	{  13009, "..." },
	{  13010, "New Lamya ITSC" },
	{  13011, "MSC Server Room" },
	{  13024, "Antananarivo" },
	{  13025, "Antananarivo" },
	{  13026, "Antananarivo" },
	{  13028, "Antananarivo" },
	{  13029, "Antananarivo" },
	{  13030, "Antananarivo" },
	{  13031, "Antananarivo" },
	{  13032, "Antananarivo" },
	{  13040, "Guet@li- Haut Debit - Reunion" },
	{  13041, "SRR - Mayotte" },
	{  13056, "Harare TS(F150)" },
	{  13057, "Gweru ITSC(AXE10)" },
	{  13058, "NetOne" },
	{  13060, "Harare ISC(C&C08)" },
	{  13062, "Gweru ITSC (C&C08)" },
	{  13064, "Econet" },
	{  13067, "Telecel Zim" },
	{  13072, "Windhoek International Exchange" },
	{  13073, "MTCNAM" },
	{  13075, "IDI Industria International" },
	{  13104, "MSU" },
	{  13108, "GMAMSC2" },
	{  13109, "GMAMSC1" },
	{  13110, "MLT" },
	{  13120, "TOLLOPS (GISC)" },
	{  13121, "FTISC" },
	{  13122, "GMSC3" },
	{  13123, "OBO_IGW1" },
	{  13124, "OBO_IGW2" },
	{  13136, "ISC AXE" },
	{  13137, "IMG MBA" },
	{  13168, "Johannesburg JB ISC" },
	{  13169, "Johannesburg JS ISC" },
	{  13170, "JB STP1" },
	{  13171, "JB STP2" },
	{  13172, "RJB-01" },
	{  13173, "MTN Cellular Network" },
	{  13174, "Vodacom Cellular Network" },
	{  13175, "Brongberg Test Exchange" },
	{  13176, "Sentech LTH 1" },
	{  13177, "Cell C" },
	{  13178, "Cell C" },
	{  13179, "JBA GMSC" },
	{  13180, "SJD STP" },
	{  13181, "MTN STP 2" },
	{  13182, "RJSP 01" },
	{  13183, "Sentech LTH 2" },
	{  13184, "SPP STP" },
	{  13185, "NST01" },
	{  13186, "BLE01" },
	{  13187, "PSTSTP" },
	{  13188, "JSE STP" },
	{  13189, "JTGMSS-1" },
	{  13190, "STP-JGTST" },
	{  13191, "STP-MNEST" },
	{  13201, "Asmara" },
	{  13328, "SMUG-ISPC" },
	{  13329, "Kampala/i-TEL1" },
	{  13332, "SMUGSMS" },
	{  13333, "KAMGW 1" },
	{  13334, "KAMGW 3" },
	{  14048, "STP Skopje" },
	{  14049, "STP1 Skopje" },
	{  14050, "STP2 Skopje" },
	{  14051, "Matel SK-1" },
	{  14052, "ON1" },
	{  14053, "TMMK MSC1 SK" },
	{  14054, "TMMK MSC2 SK" },
	{  14055, "TMMK MGw1" },
	{  14160, "VF STP Praha" },
	{  14161, "VF STP Brno" },
	{  14168, "TELKO-1" },
	{  14169, "Akcentis LJ1" },
	{  14170, "GW2" },
	{  14171, "CS2" },
	{  14195, "Digitel Mobile Srl" },
	{  14196, "INFOBIP GE (SMSC1)" },
	{  14197, "INFOBIP GE (SMSC2)" },
	{  14198, "INFOBIP GE (SMSC3)" },
	{  14199, "INFOBIP GE (SMSC4)" },
	{  14216, "Kyiv" },
	{  14217, "Kyiv" },
	{  14218, "Kyiv" },
	{  14219, "Kyiv" },
	{  14223, "Kyiv" },
	{  14224, "MLOA, Belfast" },
	{  14225, "London 1" },
	{  14226, "LDN-THEO 01" },
	{  14227, "MN-TK1" },
	{  14228, "MN-TK2" },
	{  14229, "V1 UK" },
	{  14230, "London MT" },
	{  14231, "London" },
	{  14232, "IC-RIS-1" },
	{  14233, "IC-RIS-2" },
	{  14234, "NOVA ISL" },
	{  14235, "NOVA ISL2" },
	{  14236, "AMT-IC1" },
	{  14237, "AMT-IC2" },
	{  14240, "Madrid" },
	{  14241, "Madrid" },
	{  14242, "Madrid" },
	{  14243, "Madrid" },
	{  14244, "Barcelona" },
	{  14245, "Madrid" },
	{  14246, "Barcelona" },
	{  14247, "Barcelona" },
	{  14248, "Statale del Lario SS 340 - Loc. Plan di Spagna Gera Lario (CO)" },
	{  14249, "c/o Colt Telecom - Viale Jenner 56/Milano" },
	{  14250, "Via 24 Maggio, 16/Ghedi (BS)" },
	{  14251, "via Panella 10 20100 Milano" },
	{  14252, "via ex-aeroporto 80038 - Pomigliano d'Arco - Napoli" },
	{  14253, "via Caracciolo 51 - 20155 Milano" },
	{  14254, "via Caldera 21, Milano" },
	{  14255, "Genova Granarolo/via Mura al forte di Begato" },
	{  14256, "Clonshaugh Gateway" },
	{  14257, "MSC3" },
	{  14258, "SWIFDUB1" },
	{  14259, "M20" },
	{  14260, "W20" },
	{  14261, "M30" },
	{  14262, "W30" },
	{  14264, "ECCBL" },
	{  14265, "GSM3INT1" },
	{  14266, "GMSC2" },
	{  14267, "BTNET" },
	{  14268, "SKAT" },
	{  14269, "ITDNET" },
	{  14272, "GT" },
	{  14273, "..." },
	{  14274, "..." },
	{  14275, "..." },
	{  14276, "CDMA 1" },
	{  14277, "CDMA 2" },
	{  14278, "Riga TB" },
	{  14279, "Bite LV-1" },
	{  14280, "RTSTP5, Rotterdam" },
	{  14281, "ROTC, Rotterdam" },
	{  14282, "BPC IPNX1, Amsterdam" },
	{  14283, "BPC TCATS, Amsterdam" },
	{  14284, "MSTP GV2, Den Haag" },
	{  14285, "MSTPEHV2, Eindhoven" },
	{  14286, "ASD-P3416MMSC2, Amsterdam" },
	{  14287, "NL04, Amsterdam" },
	{  14288, "MBEL" },
	{  14289, "ETC" },
	{  14290, "NPL" },
	{  14291, "NXC" },
	{  14292, "GTH" },
	{  14293, "VEST" },
	{  14294, "TRTEL" },
	{  14296, "Budapest - EMKTV-01" },
	{  14297, "Budaors DN02" },
	{  14298, "VHF-INT-GW1" },
	{  14299, "VHF-INT-GW4" },
	{  14301, "Actel Budapest 1" },
	{  14302, "INV-SZM-TP" },
	{  14303, "TRIOTEL-I1" },
	{  14304, "14304 Paul Street" },
	{  14305, "14305 Brentford" },
	{  14306, "14306 Burum 2" },
	{  14307, "14307 London" },
	{  14308, "Global Switch" },
	{  14309, "14309 Jukej 1" },
	{  14310, "14310 LI1" },
	{  14311, "14311 London 1" },
	{  14312, "MGW-T-2 Mobile" },
	{  14313, "IT-LJ1-SL" },
	{  14314, "SVN-LJU-MOBIK-1" },
	{  14315, "Mobitel GMSC1" },
	{  14316, "Mobitel GMSC2" },
	{  14317, "AMIS-1" },
	{  14318, "T-2 Mobile Gateway Ljubjana 1" },
	{  14319, "GSM MSC3 Maribor" },
	{  14320, "MGEWSD" },
	{  14321, "MGPGW" },
	{  14322, "WH-UK1" },
	{  14323, "WH-UK2" },
	{  14324, "London" },
	{  14325, "London 1" },
	{  14326, "VOEX-UK-1" },
	{  14327, "CW-London 1" },
	{  14328, "Goonhilly Inmarsat 3" },
	{  14329, "MCOM XL1" },
	{  14330, "Greenwich M79" },
	{  14331, "Greenwich M82" },
	{  14332, "London" },
	{  14333, "MSC 23" },
	{  14334, "MSC 24" },
	{  14335, "UK STP 3" },
	{  14368, "Pay and prepaid phone services" },
	{  14369, "Mobile services" },
	{  14370, "PSTN" },
	{  14371, "Pay and prepaid phone services" },
	{  14372, "Mobile services" },
	{  14373, "PSTN" },
	{  14400, "Central Aristos/EWSD" },
	{  14401, "AXE810INT" },
	{  14402, "Internacional Guarda Viejo I, AXE-10" },
	{  14403, "Centro Transito" },
	{  14404, "AT&T Guatemala" },
	{  14405, "Americatel Guatemala" },
	{  14406, "Gateway Guatemala 1" },
	{  14407, "Transito Guatemala" },
	{  14408, "AXE810INT01" },
	{  14409, "Central GT-AXE" },
	{  14410, "ANS Internacional" },
	{  14411, "PCS GSM OPC 1" },
	{  14412, "PCS GSM OPC 2" },
	{  14413, "USP, Nortel, DMS-STP" },
	{  14414, "AXEINT" },
	{  14415, "STP MARISCAL" },
	{  14432, "LD1" },
	{  14433, "INT2" },
	{  14434, "INT1" },
	{  14435, "Roaming Personal 1" },
	{  14436, "Telefonica 1" },
	{  14437, "Salnet 1" },
	{  14438, "Telemovil 1" },
	{  14439, "Americatel 1" },
	{  14440, "Telefonica 2" },
	{  14441, "Digicel 1" },
	{  14442, "AESTEL 1" },
	{  14443, "SALTEL 1" },
	{  14444, "GCA 1" },
	{  14445, "Telecam 1" },
	{  14446, "Saltel 2" },
	{  14447, "Americana 1" },
	{  14448, "Telefonica 3" },
	{  14449, "Telemovil 2" },
	{  14450, "SKY 1" },
	{  14451, "Portal Virtual 1" },
	{  14452, "Portal Virtual 2" },
	{  14453, "Telefonica 4" },
	{  14454, "Telefonica 5" },
	{  14455, "Telemovil 3" },
	{  14456, "Telemovil 4" },
	{  14457, "Digicel 2" },
	{  14464, "TGA-MSSTGU" },
	{  14465, "INTL II" },
	{  14466, "STP-TGA" },
	{  14467, "STP-TGA" },
	{  14468, "INTL III (SPS-III)" },
	{  14469, "INTL-SPS" },
	{  14470, "INTL-SPS" },
	{  14471, "SPS-MGWSPS" },
	{  14472, "MGWTGA-DGCEL" },
	{  14473, "ITP1TGA-DGCEL" },
	{  14474, "ITP2TGA-DGCEL" },
	{  14475, "MGWSPS-DGCEL" },
	{  14476, "ITP1SPS-DGCEL" },
	{  14477, "ITP2SPS-DGCEL" },
	{  14496, "MT20" },
	{  14497, "1000E10" },
	{  14498, "AXE 810 PCS" },
	{  14499, "ENITEL_MOVIL" },
	{  14501, "Bellsouth" },
	{  14503, "GLOBALSTAR" },
	{  14545, "Digicel MG INT" },
	{  14546, "Digicel MG INT" },
	{  14547, "NetUno INT" },
	{  14548, "JFHLR1" },
	{  14549, "TELCOPA INT" },
	{  14552, "Digicel MG INT" },
	{  14553, "Telecarrier Internacional 2" },
	{  14554, "PAWS-PDI-Panama1" },
	{  14555, "Convergia 2" },
	{  14556, "Perfect Image 1" },
	{  14557, "Claro Panama 1" },
	{  14558, "Claro Panama 2" },
	{  14559, "Digicel Panama 1" },
	{  14560, "Gateway MSC Digicel" },
	{  14561, "ISC1 (La Exposicion)" },
	{  14562, "ISC2 (San Francisco)" },
	{  14563, "GSM LR Data Base" },
	{  14564, "BSC" },
	{  14565, "VoIP1, Panama" },
	{  14566, "NACT STX Panama" },
	{  14567, "Cable Onda" },
	{  14568, "ISC4" },
	{  14569, "CAN Tandem Plaza Obarrio" },
	{  14570, "SOWC1" },
	{  14571, "IDC Telecarrier" },
	{  14572, "MSS01PAN" },
	{  14573, "Nx Gentel Intl 1" },
	{  14574, "COTEDE Int'l 1" },
	{  14575, "OPTYNEX Int'l" },
	{  14576, "STP1 Intl Digicel" },
	{  14577, "STP2 Intl Digicel" },
	{  14578, "Clayton Telecarrier" },
	{  14579, "TNR Int'l 1" },
	{  14580, "Digicel MG Intl" },
	{  14581, "WWT" },
	{  14582, "IFX1" },
	{  14583, "ACAN Torre Banco Aliado" },
	{  14584, "Skycom 1" },
	{  14585, "Convergia 1" },
	{  14586, "Telemax 1" },
	{  14587, "PANSL 2M" },
	{  14588, "PANSL 1P" },
	{  14589, "ASN2P" },
	{  14590, "PANSL 3M" },
	{  14591, "ISC3" },
	{  14592, "Lima N1" },
	{  14593, "Washington Instal 1" },
	{  14594, "El Cercado Instal 2" },
	{  14595, "Lima" },
	{  14596, "La Victoria T2000-1" },
	{  14597, "Villa El Salvador FC-1" },
	{  14598, "San Isidro GV-1" },
	{  14599, "La Victoria OC-1" },
	{  14600, "San Isidro RCP-1" },
	{  14601, "San Isidro GC-1" },
	{  14602, "San Isidro TA-1" },
	{  14603, "Miraflores FL-1" },
	{  14605, "San Isidro BE-1" },
	{  14607, "San Isidro O-1" },
	{  14608, "Miraflores I-1" },
	{  14609, "Surco CG-1" },
	{  14610, "San Borja CO 1" },
	{  14611, "San Borja IIP-1" },
	{  14612, "Surco AII-1" },
	{  14613, "La Molina TE-1" },
	{  14614, "Ate JT-1" },
	{  14615, "San Isidro DW-1" },
	{  14616, "San Isidro HH-1" },
	{  14617, "San Borja BP-1" },
	{  14618, "La Victoria BP-2" },
	{  14619, "La Victoria BP-3" },
	{  14620, "San Isidro TE.AN-1" },
	{  14621, "Lima" },
	{  14622, "Lima" },
	{  14623, "Lima" },
	{  14624, "Lima" },
	{  14625, "Lima" },
	{  14626, "Lima" },
	{  14627, "Lima" },
	{  14628, "Lima" },
	{  14629, "Lima" },
	{  14630, "Lima" },
	{  14631, "Lima" },
	{  14632, "Lima" },
	{  14633, "Lima" },
	{  14635, "Lima" },
	{  14636, "Lima" },
	{  14637, "Lima" },
	{  14638, "Lima" },
	{  14639, "Lima" },
	{  14640, "Lima" },
	{  14641, "Lima" },
	{  14642, "Lima" },
	{  14643, "Lima" },
	{  14644, "Lima" },
	{  14645, "Lima" },
	{  14646, "Lima" },
	{  14664, "Artigas II" },
	{  14665, "Esmeralda II" },
	{  14666, "STP-1 Telefonica Unifon" },
	{  14667, "STP-2 Telefonica Unifon" },
	{  14668, "CIBA NGN" },
	{  14669, "CWAY SG BA1" },
	{  14670, "CCT1 Argentina" },
	{  14672, "Ciudad de Buenos Aires - Nodo 1" },
	{  14673, "RASA-01" },
	{  14674, "Buenos Aires/STP Clinicas" },
	{  14675, "Darwin" },
	{  14676, "Techtel Rosario" },
	{  14677, "Buenos Aires 1 AT&T" },
	{  14678, "Cordoba 1 AT&T" },
	{  14679, "Rosario 1 AT&T" },
	{  14680, "Buenos Aires" },
	{  14681, "DKA-1" },
	{  14682, "Ortega 5500 (B1874CRN) Wilde, Buenos Aires" },
	{  14683, "Rafaela/Wilson" },
	{  14684, "Buenos Aires" },
	{  14685, "Buenos Aires/Nodo Buenos Aires 1" },
	{  14686, "Buenos Aires/Colubris 1" },
	{  14687, "TS Buenos Aires 1" },
	{  14688, "Buenos Aires / STP Norte 2 (Coghlan)" },
	{  14689, "Buenos Aires / Ciba Sur 1" },
	{  14690, "Buenos Aires / Ciba Norte 1 (Golf)" },
	{  14691, "Buenos Aires / Ciba Sur 2" },
	{  14692, "Buenos Aires / STP Norte 1 (Golf)" },
	{  14693, "Buenos Aires / STP Sur 1" },
	{  14694, "Buenos Aires / Ciba Norte 2 (Coghlan)" },
	{  14695, "Buenos Aires / STP Sur 2" },
	{  14696, "Buenos Aires/C.L.D. Velez 1" },
	{  14697, "Buenos Aires/C.L.D. Viale 1" },
	{  14698, "Buenos Aires/C.L.D. Velez 2" },
	{  14699, "Buenos Aires/C.L.D. Viale 2" },
	{  14700, "Buenos Aires/Alvarez Jonte 1862" },
	{  14701, "Buenos Aires/Alvarez Jonte 1862" },
	{  14702, "Buenos Aires/Alvarez Jonte 1862" },
	{  14703, "Cordoba/Urvitel" },
	{  14704, "Buenos Aires 2 AT&T" },
	{  14705, "Buenos Aires 3 AT&T" },
	{  14706, "25 de Mayo 565 - Bs As/Superfone" },
	{  14707, "Espinosa 1045 - Buenos Aires - Argentina/SES BA GW No 1" },
	{  14708, "Bs As/Garay 34" },
	{  14709, "Buenos Aires, Argentina/Metroredar01" },
	{  14710, "Av. Del Campo 1301 - Bs As/Artigas" },
	{  14711, "Esmeralda 330 - Bs As/Esmeralda" },
	{  14712, "Balcarce 479 - Switch BA 1 Buenos Aires" },
	{  14713, "Balcarce 479 - Switch BA 2 Buenos Aires" },
	{  14714, "Buenos Aires - Wilde 1" },
	{  14715, "Buenos Aires - Wilde 2" },
	{  14716, "Buenos Aires/Iplan AR" },
	{  14717, "Cordoba/Trejo" },
	{  14718, "Buenos Aires/BAS/N1" },
	{  14719, "AMBA/CONVI" },
	{  14720, "Rio de Janeiro IS-41-MAP" },
	{  14721, "Sao Paulo - SPO/A1" },
	{  14722, "Sao Paulo TR Paraiso" },
	{  14723, "CT TR INT SPO" },
	{  14724, "Sao Paulo SPO/A2" },
	{  14725, "Rio de Janeiro PTS ATL" },
	{  14726, "Campinas PTS TESS" },
	{  14727, "Sao Paulo/SPO.PD.LTR1" },
	{  14728, "RJO ROC/IN1" },
	{  14729, "SPO LAP/IN1" },
	{  14730, "Brasilia ETCO GW2" },
	{  14731, "Belo Horizonte PTS SAG" },
	{  14732, "Belo Horizonte PTS LUE 1" },
	{  14733, "Presidente Prudente Gateway" },
	{  14734, "Rio de Janeiro TR INT 1" },
	{  14735, "Sao Paulo TGR INT 1" },
	{  14736, "Sao Paulo/SPO.IB.PT1" },
	{  14737, "Rio de Janeiro CIRJ-B" },
	{  14738, "Petrolina Gateway" },
	{  14739, "Rio de Janeiro CO" },
	{  14740, "BRB01-MSC-RJO" },
	{  14741, "Brasilia ETCE PTS" },
	{  14742, "Sao Paulo/SPO.LI.PT1" },
	{  14743, "Sao Paulo/SPO.JB.LTR1" },
	{  14744, "MSC MSPO 03" },
	{  14745, "RIO BRB INT RJO LDI" },
	{  14746, "RIO FLO INT RJO LDI" },
	{  14747, "MSC MRJO01 RJO" },
	{  14748, "CT. TR. INT EWSD SPO" },
	{  14749, "CURITIBA PTS" },
	{  14750, "CTA CTME SURPASS" },
	{  14751, "CTA PTS CURITIBA" },
	{  14752, "PORTO ALEGRE-PTS" },
	{  14753, "GW CONV IS41/MAP-RJ" },
	{  14754, "SPO.IB.PT2" },
	{  14755, "Belo Horizonte PTS LUE II" },
	{  14756, "Belo Horizonte PTS" },
	{  14757, "Belo Horizonte PTS1" },
	{  14758, "Belo Horizonte PTS2" },
	{  14759, "Sao Paulo  Paraiso Axe (PTS)" },
	{  14760, "Rio de Janeiro RJ" },
	{  14761, "Rio de Janeiro PTS-CC" },
	{  14762, "CIDADE DE DEUS RJ PTS-CC" },
	{  14763, "CENTRO RJ PS-CC" },
	{  14764, "SAO PAULO SP" },
	{  14765, "UBERLANDIA CTBC" },
	{  14766, "SALVADOR PTS" },
	{  14767, "RIO DE JANEIRO PTS" },
	{  14769, "Sao Cristovao - RJ CRJO 01" },
	{  14770, "Vila Andrade - SP CSPO 01" },
	{  14771, "SSW MSC ULA-B Uberlandia" },
	{  14772, "Sao Paulo" },
	{  14773, "Brasilia/ETCO - ITP BSA" },
	{  14774, "Curitiba/ETBV - ITP CTA" },
	{  14808, "Santiago" },
	{  14809, "Santiago" },
	{  14810, "Santiago" },
	{  14811, "Santiago" },
	{  14812, "Santiago" },
	{  14813, "Santiago" },
	{  14816, "..." },
	{  14817, "..." },
	{  14818, "..." },
	{  14819, "..." },
	{  14820, "..." },
	{  14821, "..." },
	{  14822, "..." },
	{  14823, "..." },
	{  14824, "..." },
	{  14825, "..." },
	{  14826, "Santiago" },
	{  14827, "Santiago" },
	{  14828, "Santiago" },
	{  14829, "Santiago" },
	{  14830, "Santiago" },
	{  14831, "Santiago" },
	{  14832, "Santiago" },
	{  14833, "Santiago" },
	{  14834, "Santiago" },
	{  14835, "Santiago" },
	{  14836, "Santiago" },
	{  14837, "Santiago" },
	{  14838, "Santiago" },
	{  14839, "Santiago" },
	{  14848, "Telecom" },
	{  14849, "Telecom" },
	{  14850, "Telecom" },
	{  14851, "Telecom" },
	{  14852, "Medellin" },
	{  14853, "Santafe de Bogota" },
	{  14854, "Santafe de Bogota" },
	{  14855, "Medellin" },
	{  14856, "..." },
	{  14857, "..." },
	{  14858, "..." },
	{  14859, "..." },
	{  14860, "..." },
	{  14861, "..." },
	{  14862, "..." },
	{  14863, "..." },
	{  14864, "..." },
	{  14865, "..." },
	{  14866, "..." },
	{  14870, "..." },
	{  14871, "..." },
	{  14880, "Caracas, Los Palos Grandes ID#5" },
	{  14881, "Caracas - El Rosal (CR4)" },
	{  14882, "Caracas - CNT (CR3)" },
	{  14883, "Maracaibo (MB0)" },
	{  14884, "Caracas, Los Palos Grandes, ID #10" },
	{  14885, "Los Velazquez, Municipio Eulalia Buroz, Edo. Miranda" },
	{  14886, "Parque Tecnologico Sartenejas" },
	{  14887, "Estado Zulia - Mara 1" },
	{  14888, "Anzoategui, AMZMC001" },
	{  14889, "Caracas, ID#5" },
	{  14890, "Torre Mariara, El Rosal, Caracas" },
	{  14891, "ANS_CCS (Vitcom), C.A." },
	{  14892, "Cracas - CNT - NDC00" },
	{  14893, "Avenida de Libertador, Caracas" },
	{  14894, "Miranda, Caracas" },
	{  14895, "Miranda, Caracas" },
	{  14896, "Av. Francisco de Miranda, Caracas" },
	{  14897, "Av. Libertador, Caracas" },
	{  14898, "Av. Francisco de Miranda, Caracas" },
	{  14899, "ANS_CCS, Caracas" },
	{  14900, "Av. Los Leones y Carona Barquisimeto Estado Lara" },
	{  14901, "Central AXE - CCS, ID39" },
	{  14902, "Caracas" },
	{  14903, "Barquisimeto - BTO - NDC00" },
	{  14904, "Caracas-LUR-NDC00" },
	{  14905, "Valencia-VAL-NDC00" },
	{  14906, "STP_Caracas" },
	{  14907, "STP_Valencia" },
	{  14908, "Gateway Cantata" },
	{  14912, "LPZ 0" },
	{  14913, "SCZ 0" },
	{  14914, "14914" },
	{  14915, "LPZ 1" },
	{  14916, "14916" },
	{  14917, "STC 1" },
	{  14918, "14918" },
	{  14919, "14919" },
	{  14920, "BOLLP 1, La Paz" },
	{  14921, "BOLCBA 1, Cochabamba" },
	{  14922, "BOLSC 1, Santa Cruz" },
	{  14923, "14923" },
	{  14924, "14924" },
	{  14925, "14925" },
	{  14926, "14926" },
	{  14927, "14927" },
	{  14928, "GRAN CENTRO 13, La Paz" },
	{  14929, "UTI 01, La Paz" },
	{  14930, "MSC GSM, Santa Cruz" },
	{  14931, "UNTLPZ, La Paz" },
	{  14932, "COTAS COCHABAMBA, Cochabamba" },
	{  14933, "14933" },
	{  14934, "14934" },
	{  14935, "14935" },
	{  14936, "14936" },
	{  14937, "14937" },
	{  14938, "14938" },
	{  14939, "14939" },
	{  14940, "14940" },
	{  14941, "14941" },
	{  14942, "SGW FIJO 01 LPZ, STP La Paz" },
	{  14943, "SGW FIJO 01 CBB, STP Cochabamba" },
	{  14944, "Telquest Northcom Home Country Direct Service" },
	{  14945, "..." },
	{  14946, "..." },
	{  14947, "..." },
	{  14948, "..." },
	{  14949, "..." },
	{  14950, "..." },
	{  14951, "..." },
	{  14976, "Quito, Central Internacional" },
	{  14977, "Guayaquil, Central Internacional 2" },
	{  14978, "Guayaquil, Central Internacional 1" },
	{  14979, "Guayaquil, Switch" },
	{  14980, "Quito, Switch" },
	{  14981, "Guayaquil, Switch" },
	{  14982, "Guayaquil, MSC TDMA" },
	{  14983, "Quito, MSC TDMA" },
	{  14984, "Telecsa UIO-CDMA" },
	{  14985, "Etapa Cuenca Novatelefonia" },
	{  14986, "Central Quito SETEL" },
	{  14987, "Central Internacional (Quito 2)" },
	{  14988, "MG_UIO_001" },
	{  14990, "MSSS 1" },
	{  14991, "MSS GSM UIO" },
	{  14992, "MSS GSM GYE" },
	{  14993, "Ecutel" },
	{  14994, "TELECSA GSM" },
	{  14995, "TELECSA GSM SP Node" },
	{  15009, "Dauphin Telecom - Guyane" },
	{  15040, "..." },
	{  15041, "..." },
	{  15042, "..." },
	{  15043, "..." },
	{  15044, "..." },
	{  15045, "..." },
	{  15072, "Paramaribo 1" },
	{  15073, "Paramaribo 2" },
	{  15074, "Paramaribo 3" },
	{  15075, "Paramaribo 4" },
	{  15076, "reserved" },
	{  15077, "reserved" },
	{  15078, "reserved" },
	{  15079, "reserved" },
	{  15104, "MSCURU01" },
	{  15105, "CTI1, Montevideo Aguada (AXE10)" },
	{  15106, "CTI2, Montevideo Union (AXE10)" },
	{  15107, "MSC-GSM/Montevideo 1" },
	{  15108, "MSC-GSM/Montevideo 2" },
	{  15109, "AXE MSC" },
	{  15129, "ISCFalklands" },
	{  15130, "TOUCH" },
	{  15536, "INTERNACIONAL ROAMING MSS SCZ, SP Santa Cruz" },
	{  15537, "COTAS BOL 4, Santa Cruz" },
	{  15538, "INTERNACIONAL ROAMING MGw LPZ, STP La Paz" },
	{  15539, "INTERNACIONAL ROAMING MGw SCZ, STP Santa Cruz" },
	{  15540, "SERVER FIJO 01 STC, STP Santa Cruz" },
	{  15541, "SGW FIJO 01 STC, STP Santa Cruz" },
	{  15542, "INTERNACIONAL ROAMING MSS 02 LPZ, STO La Paz" },
	{  15543, "INTERNACIONAL ROAMING MGw 02 LPZ, STP La Paz" },
	{  16208, "London 1" },
	{  16209, "LON001GSX3" },
	{  16210, "Hextel London 1" },
	{  16211, "LONDON" },
	{  16212, "London ISC" },
	{  16213, "London eSTP" },
	{  16226, "Barcelona MSC" },
	{  16227, "Barcelona PTS" },
	{  16228, "Madrid MSS" },
	{  16229, "Madrid MGW" },
	{  16230, "Madrid" },
	{  16232, "London SCP02" },
	{  16233, "London STP2" },
	{  16234, "London Poplar" },
	{  16235, "London 3" },
	{  16236, "London 4" },
	{  16237, "London 5" },
	{  16238, "London 6" },
	{  16239, "Bristol AVN2042-M99" },
	{  16240, "Transatel-Paris" },
	{  16241, "SFR - Paris 2" },
	{  16243, "PTS03 - Nanterre" },
	{  16244, "PTS04 - Bobigny" },
	{  16245, "MT008 - Bobigny" },
	{  16246, "MG001 - Crosne" },
	{  16247, "MG002 - Bobigny" },
	{  16248, "Sonus-GSX2 Kosice" },
	{  16249, "MSS MO2SK" },
	{  16250, "MGW MG2SK" },
	{  16257, "Oslo3" },
	{  16258, "MTU Oslo 1" },
	{  16259, "OSLO" },
	{  16262, "OXIA (MSS)" },
	{  16263, "OXIB (MGW)" },
	{  16264, "Madrid GMSC" },
	{  16265, "Leganes MSS101" },
	{  16266, "Hospitalet MSS201" },
	{  16267, "Alicante MSS301" },
	{  16268, "Malaga MSS501" },
	{  16269, "Jundiz (Alava)" },
	{  16270, "Zamudio (Vizcaya)" },
	{  16271, "Madrid STP2" },
	{  16273, "Kyiv" },
	{  16274, "Kyiv" },
	{  16275, "Kyiv" },
	{  16276, "Odessa" },
	{  16277, "Kyiv" },
	{  16278, "Kharkov" },
	{  16279, "Kyiv" },
	{  16280, "16280 THN1/MSC" },
	{  16281, "16281 THN2/MSC" },
	{  16282, "16282 Swanley" },
	{  16283, "16283 Oldham" },
	{  16284, "16284 Gloucester" },
	{  16285, "16285 Regent" },
	{  16286, "16286 30EAST 1" },
	{  16287, "16287 Douglas 1" },
	{  16288, "Warszawa" },
	{  16289, "Warszawa" },
	{  16290, "Warszawa" },
	{  16291, "Warszawa I" },
	{  16292, "Warszawa II" },
	{  16293, "Katowice I" },
	{  16294, "Katowice II" },
	{  16296, "ECOSOL" },
	{  16297, "GST" },
	{  16298, "MSC-3" },
	{  16299, "MSC-2" },
	{  16300, "Riga MWTV 1" },
	{  16301, "..." },
	{  16302, "..." },
	{  16303, "AEO 1" },
	{  16304, "Warszawa" },
	{  16305, "Poznan II" },
	{  16306, "Warszawa" },
	{  16307, "Warszawa" },
	{  16309, "Warszawa" },
	{  16310, "Warszawa" },
	{  16311, "Warszawa" },
	{  16312, "Chiasso" },
	{  16313, "Zurich" },
	{  16314, "Zurich" },
	{  16315, "Zurich" },
	{  16316, "Wollerau" },
	{  16317, "Zurich" },
	{  16318, "Zurich" },
	{  16319, "Zurich" },
	{  16320, "..." },
	{  16321, "..." },
	{  16322, "..." },
	{  16325, "..." },
	{  16326, "..." },
	{  16328, "60326 Frankfurt" },
	{  16329, "60326 Frankfurt" },
	{  16330, "60326 Frankfurt" },
	{  16331, "60314 Frankfurt" },
	{  16332, "60326 Frankfurt" },
	{  16333, "60326 Frankfurt" },
	{  16334, "60326 Frankfurt" },
	{  16336, "Riga Gateway" },
	{  16337, "Riga Tglobal" },
	{  16338, "..." },
	{  16339, "Riga" },
	{  16340, "MPE RIGA" },
	{  16341, "Riga" },
	{  16342, "Riga Gateway 1" },
	{  16343, "Adamasto 01" },
	{  16344, "16344 LDN01" },
	{  16345, "16345 Discovery" },
	{  16346, "16346 Birmingham MOS" },
	{  16347, "16347 Leapfield Gateway" },
	{  16348, "16348 UK Sonus" },
	{  16349, "16349 Lupus" },
	{  16350, "16350 Hawley" },
	{  16351, "16351 London 2" },
	{  16352, "..." },
	{  16353, "..." },
	{  16354, "..." },
	{  16355, "..." },
	{  16356, "..." },
	{  16357, "..." },
	{  16358, "..." },
	{  16359, "..." },
	{  16360, "16360 Manchester" },
	{  16361, "16361 Keybridge VoIP" },
	{  16362, "16362 VIRGO" },
	{  16363, "16363 Burum 1" },
	{  16364, "16364 MSC 25" },
	{  16365, "16365 London" },
	{  16366, "16366 MSC 26" },
	{  16367, "16367 URSA" },
	{  16368, "Madrid" },
	{  16369, "Barcelona-STP22" },
	{  16370, "Vigo" },
	{  16371, "Madrid" },
	{  16372, "Madrid" },
	{  16373, "Madrid" },
	{  16374, "Madrid" },
	{  16375, "Madrid" },
	{  0, NULL }
};

/*
 * List of International Signalling Point Codes (ISPC)
 * Annex to ITU Operational Bulletin No. 956 - 15.V.2010
 * including amendments up to ITU Operational Bulletin No. 960 - 15.VII.2010
 *
 * Mapping of ISPC to Name of the signalling point operator
 */
static const value_string q708_ispc_operator_name[] = {
	{  4096, "LTN Liechtenstein TeleNet AG" },
	{  4097, "LTN Liechtenstein TeleNet AG" },
	{  4098, "Unassigned" },
	{  4099, "Mobilkom (Liechtenstein) AG" },
	{  4100, "Mobilkom (Liechtenstein) AG" },
	{  4101, "VIAG Europlatform AG" },
	{  4102, "Unassigned" },
	{  4103, "Tele2 AG" },
	{  4104, "Albacom S.p.A." },
	{  4105, "Albacom S.p.A." },
	{  4106, "Alpikom S.p.A." },
	{  4107, "Wind Telecomunicazioni S.p.A." },
	{  4108, "Wind Telecomunicazioni S.p.A." },
	{  4109, "Eutelia S.p.A." },
	{  4110, "KPN Telecom BV" },
	{  4111, "Intermatica srl" },
	{  4112, "Telfort B.V." },
	{  4113, "Wavecrest Netherlands B.V." },
	{  4114, "Orange Nederland N.V." },
	{  4115, "Highside Telecom B.V." },
	{  4116, "GC Pan European Crossing Nederland B.V." },
	{  4117, "Prorail B.V." },
	{  4118, "Xplorium France Sarl" },
	{  4119, "KPN Telecom B.V." },
	{  4120, "Eutelia S.p.A." },
	{  4121, "Fastweb S.p.A." },
	{  4122, "Tele2 Italia S.p.A." },
	{  4123, "Openline S.p.A." },
	{  4124, "Energ.it S.p.A." },
	{  4125, "Parla.it S.p.A." },
	{  4126, "Parla.it S.p.A." },
	{  4127, "Elinet S.p.A." },
	{  4128, "OTE" },
	{  4129, "OTE" },
	{  4130, "OTE" },
	{  4131, "OTE" },
	{  4132, "WIND" },
	{  4133, "Vodafone" },
	{  4134, "Cosmote" },
	{  4135, "Vodafone" },
	{  4136, "Cosmoline" },
	{  4137, "Telias" },
	{  4138, "Forthnet" },
	{  4139, "WIND" },
	{  4140, "WIND" },
	{  4141, "Info Quest" },
	{  4142, "Cosmote" },
	{  4143, "Lannet" },
	{  4144, "Colt Telecom B.V." },
	{  4145, "Audiocom B.V." },
	{  4146, "Dialost Ltd." },
	{  4147, "Coolwave Communications B.V." },
	{  4148, "Orange Nederland N.V." },
	{  4149, "T-Mobile Netherlands B.V." },
	{  4150, "Unassigned" },
	{  4151, "bbned N.V." },
	{  4152, "Tele2 (Netherlands) B.V." },
	{  4153, "Alphacomm Solutions B.V." },
	{  4154, "InterXion Holding N.V." },
	{  4155, "Versatel Nederland B.V." },
	{  4156, "Mapatel LLC" },
	{  4157, "T-Mobile Netherlands B.V." },
	{  4158, "Telfort B.V." },
	{  4159, "Orange Nederland N.V." },
	{  4160, "AT&T Communications Services Nederland B.V." },
	{  4161, "KPN Telecom B.V." },
	{  4162, "KPN Telecom B.V." },
	{  4163, "KPN Telecom B.V." },
	{  4164, "Infonet Broadband Services Corporation" },
	{  4165, "T-Mobile Netherlands B.V." },
	{  4166, "BT Nederland B.V." },
	{  4167, "KPN Telecom B.V." },
	{  4168, "KPN Telecom B.V." },
	{  4169, "KPN Telecom B.V." },
	{  4170, "KPN Telecom B.V." },
	{  4171, "Unassigned" },
	{  4172, "KPN Mobile The Netherlands B.V." },
	{  4173, "KPN Mobile The Netherlands B.V." },
	{  4174, "KPN Telecom B.V." },
	{  4175, "KPN Telecom B.V." },
	{  4176, "Easyway" },
	{  4177, "Hilf Telecom B.V." },
	{  4178, "Vodafone Libertel N.V." },
	{  4179, "Vodafone Libertel N.V." },
	{  4180, "Comfour Telecom B.V." },
	{  4181, "Visiontel V.O.F." },
	{  4182, "Enertel NV" },
	{  4183, "Enertel NV" },
	{  4184, "BT Nederland N.V." },
	{  4185, "BT Nederland N.V." },
	{  4186, "BT Nederland N.V." },
	{  4187, "Equant Netherlands B.V." },
	{  4188, "Equant Netherlands B.V." },
	{  4189, "Verizon Nederland B.V." },
	{  4190, "Elephant Talk Comm Premium Rate Serv Neth B.V." },
	{  4191, "Ventelo Nederland B.V." },
	{  4192, "GTS" },
	{  4193, "Belgacom" },
	{  4194, "Belgacom" },
	{  4195, "Belgacom" },
	{  4196, "WorldCom" },
	{  4197, "Tele2 Belgium" },
	{  4198, "Unassigned" },
	{  4199, "Belgacom" },
	{  4200, "Combellga" },
	{  4201, "Belgacom" },
	{  4202, "Telenet N.V." },
	{  4203, "Concert Communications Company" },
	{  4204, "Unassigned" },
	{  4205, "Unassigned" },
	{  4206, "Global One" },
	{  4207, "Combellga" },
	{  4208, "Belgacom International Carrier Services" },
	{  4209, "Colt Telecom" },
	{  4210, "Unisource Belgium" },
	{  4211, "Unassigned" },
	{  4212, "T2 Belgium NV" },
	{  4213, "Unassigned" },
	{  4214, "FCI Carrier Services" },
	{  4215, "Belgacom" },
	{  4216, "Belgacom International Carrier Services" },
	{  4217, "BT (Worldwide) Ltd." },
	{  4218, "Afrilink" },
	{  4219, "Telenet" },
	{  4220, "Telenet" },
	{  4221, "WorldCom" },
	{  4222, "KPN Orange Belgium" },
	{  4223, "KPN Orange Belgium" },
	{  4224, "ITN France" },
	{  4225, "SFR" },
	{  4226, "France Telecom" },
	{  4227, "France Telecom" },
	{  4228, "Telecom Italia" },
	{  4229, "SFR" },
	{  4230, "Telecom Italia" },
	{  4231, "France Telecom" },
	{  4232, "SFR" },
	{  4233, "DV-IPX" },
	{  4234, "Telemedia" },
	{  4235, "Wavecrest Communications France" },
	{  4236, "SFR" },
	{  4237, "SFR" },
	{  4238, "SFR" },
	{  4239, "SFR" },
	{  4240, "France Telecom" },
	{  4241, "Bouygues Telecom" },
	{  4242, "Bouygues Telecom" },
	{  4243, "Completel" },
	{  4244, "France Telecom" },
	{  4245, "SFR" },
	{  4246, "Tradingcom Europe" },
	{  4247, "France Telecom" },
	{  4248, "Free Telecom" },
	{  4249, "France Telecom" },
	{  4250, "Free Telecom" },
	{  4251, "France Telecom" },
	{  4252, "Colt Telecommunications France" },
	{  4253, "SFR" },
	{  4254, "Colt Telecommunications France" },
	{  4255, "SFR" },
	{  4256, "Telecom Italia" },
	{  4257, "SFR" },
	{  4258, "Cable & Wireless" },
	{  4259, "Viatel Operations SA" },
	{  4260, "Telecom Italia" },
	{  4261, "France Telecom" },
	{  4262, "France Telecom" },
	{  4263, "France Telecom" },
	{  4264, "Societe Francaise du Radiotelephone" },
	{  4265, "Societe Francaise du Radiotelephone" },
	{  4266, "Societe Francaise du Radiotelephone" },
	{  4267, "Societe Francaise du Radiotelephone" },
	{  4268, "Primus Telecommunications SA" },
	{  4269, "Global Transit France" },
	{  4270, "Bouygues Telecom" },
	{  4271, "SFR" },
	{  4272, "Storm Telecommunications" },
	{  4273, "Colt Telecommunications" },
	{  4274, "Equant" },
	{  4275, "SFR" },
	{  4276, "SFR" },
	{  4277, "SFR" },
	{  4278, "SFR" },
	{  4279, "SFR" },
	{  4280, "Kast Telecom" },
	{  4281, "Colt Telecommunications France" },
	{  4282, "Graphnet" },
	{  4283, "SFR" },
	{  4284, "Viatel Operations SA" },
	{  4285, "Telecom Italia" },
	{  4286, "Phone Systems & Networks" },
	{  4287, "Telecom Italia" },
	{  4288, "Monaco Telecom" },
	{  4289, "Monaco Telecom" },
	{  4290, "Monaco Telecom" },
	{  4291, "Monaco Telecom" },
	{  4292, "Mednet" },
	{  4293, "PTK" },
	{  4294, "Monaco Telecom" },
	{  4295, "Monaco Telecom" },
	{  4296, "T-Mobile Austria" },
	{  4297, "MITACS Telekomservice" },
	{  4298, "Unassigned" },
	{  4299, "Orange Austria Telecommunication" },
	{  4300, "Barablu Mobile Austria" },
	{  4301, "Hutchison 3G Austria" },
	{  4302, "Hutchison 3G Austria" },
	{  4303, "Schrego Communications Ltd." },
	{  4304, "Colt Telekom Austria" },
	{  4305, "Unassigned" },
	{  4306, "Unassigned" },
	{  4307, "Unassigned" },
	{  4308, "Verizon Austria" },
	{  4309, "Telekom Austria TA" },
	{  4310, "Unassigned" },
	{  4311, "Telekom Austria TA" },
	{  4312, "Grupalia Internet S.A." },
	{  4313, "Interchat S.L." },
	{  4314, "Withdraw S.L." },
	{  4315, "Euskaltel, S.A." },
	{  4316, "Euskaltel, S.A." },
	{  4317, "Interactive Communications, Europe, S.L." },
	{  4318, "Timanfaya Telecom, S.L." },
	{  4319, "Neo Sky 2002, S.A." },
	{  4320, "Euskaltel, S.A." },
	{  4321, "Telefonica de Espana, S.A.U." },
	{  4322, "Telefonica de Espana, S.A.U." },
	{  4323, "Telefonica de Espana, S.A.U." },
	{  4324, "Telefonica de Espana, S.A.U." },
	{  4325, "Telefonica de Espana, S.A.U." },
	{  4326, "Orbitel Comunicaciones Latino, S.A." },
	{  4327, "Adamo Europe, S.L." },
	{  4328, "Vodafone Espana, S.L." },
	{  4329, "Vodafone Espana, S.L." },
	{  4330, "Telefonica de Espana, S.A.U." },
	{  4331, "Telefonica de Espana, S.A.U." },
	{  4332, "Auna Telecomunicaciones, S.A." },
	{  4333, "Auna Telecomunicaciones, S.A." },
	{  4334, "Vodafone Espana" },
	{  4335, "Vodafone Espana" },
	{  4336, "Vodafone Espana" },
	{  4337, "Vodafone Espana" },
	{  4338, "Telefonica Moviles Espana, S.A.U." },
	{  4339, "Telefonica Moviles Espana, S.A.U." },
	{  4340, "Telefonica Moviles Espana, S.A.U." },
	{  4341, "Telefonica Moviles Espana, S.A.U." },
	{  4342, "Uni2 Telecomunicaciones, S.A." },
	{  4343, "Uni2 Telecomunicaciones, S.A." },
	{  4344, "Retevision Movil, S.A.U." },
	{  4345, "Retevision Movil, S.A.U." },
	{  4346, "Tecnomatix Telecomunicaciones, S.L." },
	{  4347, "Colt Telecom Espana, S.A." },
	{  4348, "Redes y Servicios Liberalizados, S.A." },
	{  4349, "Redes y Servicios Liberalizados, S.A." },
	{  4350, "Euskaltel, S.A." },
	{  4351, "BT Espana, S.A.U." },
	{  4352, "Unassigned" },
	{  4353, "Magyar Telekom Plc" },
	{  4354, "Magyar Telekom Plc" },
	{  4355, "Magyar Telekom Plc" },
	{  4356, "Magyar Telekom Plc" },
	{  4357, "Invitel Ltd" },
	{  4358, "Invitel Ltd" },
	{  4359, "BT Limited Hungarian Branch Office" },
	{  4360, "Viaphone GmbH" },
	{  4361, "Viaphone GmbH" },
	{  4362, "Vodafone D2 GmbH" },
	{  4363, "Vodafone D2 GmbH" },
	{  4364, "Talkline GmbH" },
	{  4365, "CompleTel GmbH" },
	{  4366, "tesion Communikationsnetze Sudwest GmbH & Co. KG" },
	{  4367, "KPN Telecom BV" },
	{  4368, "Star Telecommunications Deutschland GmbH" },
	{  4369, "ICS Interactive Communications Services GmbH" },
	{  4370, "Storm Telecommunications Ltd." },
	{  4371, "KDD Telecomet Deutschland GmbH" },
	{  4372, "Interurbana Net GmbH" },
	{  4373, "EGN B.V." },
	{  4374, "Pacific Gateway Exchange Inc." },
	{  4375, "Pacific Gateway Exchange Inc." },
	{  4376, "Brain Trust International Telecommunications Services GmbH" },
	{  4377, "Carrier1 AG" },
	{  4378, "Carrier1 AG" },
	{  4379, "Telia Telekommunikation GmbH" },
	{  4380, "Pacific Gateway Exchange Inc." },
	{  4381, "Pacific Gateway Exchange Inc." },
	{  4382, "RSLCom Deutschland GmbH" },
	{  4383, "Unisource Carrier Services AG" },
	{  4384, "Arcor AG & Co." },
	{  4385, "Arcor AG & Co." },
	{  4386, "Televersa Netnet GmbH" },
	{  4387, "Communikationsnetze Sud-West GmbH & Co. KG" },
	{  4388, "Talkline International GmbH" },
	{  4389, "Talkline International GmbH" },
	{  4390, "European Telecommunication Holding AG (E.T.H.)" },
	{  4391, "Teleglobe GmbH & Co" },
	{  4392, "Unisource Carrier Services AG" },
	{  4393, "Unisource Carrier Services AG" },
	{  4394, "Colt Telecom GmbH" },
	{  4395, "Viaphone GmbH" },
	{  4396, "Esprit Telekom Deutschland GmbH" },
	{  4397, "EWE TEL GmbH" },
	{  4398, "Star Telecommunications Deutschland GmbH" },
	{  4399, "Interoute Telecom Deutschland GmbH" },
	{  4400, "Vodafone D2 GmbH" },
	{  4401, "Vodafone D2 GmbH" },
	{  4402, "MFS Deutschland GmbH" },
	{  4403, "MFS Deutschland GmbH" },
	{  4404, "Ventelo GmbH" },
	{  4405, "O2 (Germany) GmbH & Co." },
	{  4406, "E-Plus Mobilfunk GmbH" },
	{  4407, "E-Plus Mobilfunk GmbH" },
	{  4408, "E-Plus Mobilfunk GmbH" },
	{  4409, "E-Plus Mobilfunk GmbH" },
	{  4410, "Express Teleservice Corp." },
	{  4411, "Connex.com" },
	{  4412, "Select One GmbH" },
	{  4413, "GDS Gesellschaft fur Dienstleistungen und Service mbH" },
	{  4414, "Colt Telecom GmbH" },
	{  4415, "Hallotel Deutschland GmbH" },
	{  4416, "Telekom Srbija a.d." },
	{  4417, "Telekom Srbija a.d." },
	{  4418, "M" },
	{  4419, "Telekom Srbija a.d." },
	{  4420, "M" },
	{  4421, "M" },
	{  4422, "Telenor d.o.o." },
	{  4423, "M" },
	{  4424, "Policom S.p.A." },
	{  4425, "Tiscali S.p.A." },
	{  4426, "Tiscali S.p.A." },
	{  4427, "Wind Telecomunicazioni S.p.A." },
	{  4428, "Wind Telecomunicazioni S.p.A." },
	{  4429, "Welcome Italia S.p.A." },
	{  4430, "Metropol Access Italia" },
	{  4431, "Colt Telecom S.p.A." },
	{  4432, "Atlanet S.p.A." },
	{  4433, "Atlanet S.p.A." },
	{  4434, "Net Business S.p.A." },
	{  4435, "Primus Telecommunications srl" },
	{  4436, "Elinet S.p.A." },
	{  4437, "Elinet S.p.A." },
	{  4438, "Eutelia S.p.A." },
	{  4439, "Brennercom AG/SpA" },
	{  4440, "Attiway" },
	{  4441, "Nodalis S.p.A." },
	{  4442, "Teleunit S.p.A." },
	{  4443, "Aexis Telecom S.p.A." },
	{  4444, "Aexis Telecom S.p.A." },
	{  4445, "Aexis Telecom S.p.A." },
	{  4446, "Aexis Telecom S.p.A." },
	{  4447, "Infracom Italia S.p.A." },
	{  4448, "Telecom Italia Sparkle" },
	{  4449, "Telecom Italia Sparkle" },
	{  4450, "Telecom Italia Sparkle" },
	{  4451, "Telecom Italia Sparkle" },
	{  4452, "Telecom Italia Sparkle" },
	{  4453, "Telecom Italia Sparkle" },
	{  4454, "Telecom Italia Sparkle" },
	{  4455, "Grapes Network Services S.p.A." },
	{  4456, "Telecom Italia Sparkle" },
	{  4457, "Colt Telecom S.p.A." },
	{  4458, "Wind Telecomunicazioni S.p.A." },
	{  4459, "Telecom Italia Sparkle" },
	{  4460, "Telecom Italia Sparkle" },
	{  4461, "Vodafone S.p.A." },
	{  4462, "Vodafone S.p.A." },
	{  4463, "Telecom Italia Sparkle" },
	{  4464, "Telecom Italia Sparkle" },
	{  4465, "Wind Telecomunicazioni S.p.A." },
	{  4466, "Telecom Italia Sparkle" },
	{  4467, "H3G S.p.A." },
	{  4468, "Telecom Italia Sparkle" },
	{  4469, "Equant Italy S.p.A." },
	{  4470, "Albacom S.p.A." },
	{  4471, "Albacom S.p.A." },
	{  4472, "Wind Telecomunicazioni S.p.A." },
	{  4473, "Wind Telecomunicazioni S.p.A." },
	{  4474, "Wind Telecomunicazioni S.p.A." },
	{  4475, "TIM Italia S.p.A." },
	{  4476, "TIM Italia S.p.A." },
	{  4477, "MCI Italia S.p.A." },
	{  4478, "Teleque Communications S.p.A." },
	{  4479, "Teleque Communications S.p.A." },
	{  4480, "Brennercom S.p.A." },
	{  4481, "Tele2 Italia S.p.A." },
	{  4482, "Metropol Access Italia" },
	{  4483, "Cable & Wireless S.p.A." },
	{  4484, "Tele2 Italia S.p.A." },
	{  4485, "Atlanet S.p.A." },
	{  4486, "Vodafone S.p.A." },
	{  4487, "Vodafone S.p.A." },
	{  4488, "Vodafone S.p.A." },
	{  4489, "Telecom Italia S.p.A." },
	{  4490, "Telecom Italia S.p.A." },
	{  4491, "Wavecrest Italia S.p.A." },
	{  4492, "Elinet S.p.A." },
	{  4493, "Vodafone S.p.A." },
	{  4494, "Eutelia S.p.A." },
	{  4495, "Trans World Telecommunications srl" },
	{  4496, "Grapes Network Services S.p.A." },
	{  4497, "Wavecrest Italia S.p.A." },
	{  4498, "Wavecrest Italia S.p.A." },
	{  4499, "Tele2 Italia S.p.A." },
	{  4500, "Carrier 1 Italia Network srl" },
	{  4501, "Elsacom S.p.A." },
	{  4502, "H3G S.p.A." },
	{  4503, "Elinet S.p.A." },
	{  4504, "Infracom Italia S.p.A." },
	{  4505, "Infracom Italia S.p.A." },
	{  4506, "GTN Italia S.p.A." },
	{  4507, "H3G S.p.A." },
	{  4508, "Grapes Network Services S.p.A." },
	{  4509, "Elinet S.p.A." },
	{  4510, "GSC Global System Communications S.p.A." },
	{  4511, "Metropol Access Italia" },
	{  4512, "Romtelecom S.A." },
	{  4513, "Romtelecom S.A." },
	{  4514, "Romtelecom S.A." },
	{  4515, "Cosmote Romanian Mobile" },
	{  4516, "Romtelecom S.A." },
	{  4517, "Vodafone Romania" },
	{  4518, "Orange Romania" },
	{  4519, "Telemobil" },
	{  4520, "Interoute Managed Services" },
	{  4521, "Orange Communications SA" },
	{  4522, "Belgacom International SA" },
	{  4523, "Abaion Telecom IT AG" },
	{  4524, "Solesys S.A." },
	{  4525, "VOX Telecom SA" },
	{  4526, "Belgacom International SA" },
	{  4527, "Orange Communications SA" },
	{  4528, "TNE AG" },
	{  4529, "Orange Communication SA" },
	{  4530, "Orange Communication SA" },
	{  4531, "United Pan-Europe Communications AG" },
	{  4532, "Global Crossing PEC Switzerland" },
	{  4533, "VOX Telecom SA" },
	{  4534, "Belgacom International SA" },
	{  4535, "Cablecom GmbH" },
	{  4536, "Bebbicel AG" },
	{  4537, "Calltrade Carrier Services AG" },
	{  4538, "Bebbicel AG" },
	{  4539, "Bebbicel AG" },
	{  4540, "Swisscom (Schweiz) AG" },
	{  4541, "IN & Phone S.A." },
	{  4542, "Colt Telecom AG" },
	{  4543, "Orange Communications SA" },
	{  4544, "Belgacom International SA" },
	{  4545, "Belgacom International Carrier" },
	{  4546, "Belgacom International Carrier" },
	{  4547, "Swisscom (Schweiz) AG" },
	{  4548, "Colt Telecom AG" },
	{  4549, "Swisscom (Schweiz) AG" },
	{  4550, "Belgacom International Carrier" },
	{  4551, "Belgacom International Carrier" },
	{  4552, "Swisscom (Schweiz) AG" },
	{  4553, "Swisscom (Schweiz) AG" },
	{  4554, "Swisscom (Schweiz) AG" },
	{  4555, "Swisscom (Schweiz) AG" },
	{  4556, "Comfone AG" },
	{  4557, "Bebbicel AG" },
	{  4558, "Comfone AG" },
	{  4559, "Calltrade Carrier Services AG" },
	{  4560, "Verizon Switzerland" },
	{  4561, "Sunrise Communications AG" },
	{  4562, "Sunrise Communications AG" },
	{  4563, "Calltrade Carrier Services AG" },
	{  4564, "Sunrise Communications AG" },
	{  4565, "LTN Liechtenstein Telenet AG" },
	{  4566, "Colt Telecom AG" },
	{  4567, "Orange Business Switzerland AG" },
	{  4568, "Cable & Wireless (Schweiz) AG" },
	{  4569, "Conduit Europe SA" },
	{  4570, "Belgacom International SA" },
	{  4571, "SBB AG Telecom SBB" },
	{  4572, "TelCommunication Services AG" },
	{  4573, "Swisscom (Schweiz) AG" },
	{  4574, "Swisscom (Schweiz) AG" },
	{  4575, "Swisscom (Schweiz) AG" },
	{  4576, "T-Mobile Czech Republic a.s." },
	{  4577, "Ceska Radiokomunikace a.s." },
	{  4578, "T-Mobile Czech Republic a.s." },
	{  4579, "Tiscali Telekomunikace Ceska republika s.r.o." },
	{  4580, "Radiokomunikace a.s." },
	{  4581, "CEZ ITC Services a.s." },
	{  4582, "Sprava zeleznicni cesty, st org." },
	{  4583, "Unassigned" },
	{  4584, "Elephant Talk Communication GmbH" },
	{  4585, "Orange Communications SA" },
	{  4586, "IVY Telecom SA" },
	{  4587, "Cablecom GmbH" },
	{  4588, "IVY Telecom SA" },
	{  4589, "Catel Carrier-und Telekommunikationsborse Frankfurt AG" },
	{  4590, "Comfone AG" },
	{  4591, "Comfone AG" },
	{  4592, "Telesonique SA, Geneve" },
	{  4593, "Telesonique SA" },
	{  4594, "Sunrise Communications AG" },
	{  4595, "Calltrade Carrier Services AG" },
	{  4596, "Sapphire AG" },
	{  4597, "TelCommunication Services AG" },
	{  4598, "MGI Media GmbH" },
	{  4599, "Cablecom GmbH" },
	{  4600, "C.I.T. SA" },
	{  4601, "Sunrise Communications AG" },
	{  4602, "Unassigned" },
	{  4603, "Calltrade Carrier Services AG" },
	{  4604, "TNE AG" },
	{  4605, "Orange Communication SA" },
	{  4606, "Orange Communication SA" },
	{  4607, "MyTel GmbH" },
	{  4608, "Telekom Austria TA" },
	{  4609, "Telekom Austria TA" },
	{  4610, "Telekom Austria TA" },
	{  4611, "Unassigned" },
	{  4612, "Unassigned" },
	{  4613, "WNT Telecommunication" },
	{  4614, "Unassigned" },
	{  4615, "Telekom Austria TA" },
	{  4616, "Telekom Austria TA" },
	{  4617, "Mobilkom Austria" },
	{  4618, "Telekom Austria TA" },
	{  4619, "Mobilkom Austria" },
	{  4620, "Mobilkom Austria" },
	{  4621, "Unassigned" },
	{  4622, "Mobilkom Austria" },
	{  4623, "Tele2 Telecommunication" },
	{  4624, "T-Mobile Austria" },
	{  4625, "T-Mobile Austria" },
	{  4626, "Unassigned" },
	{  4627, "Orange Austria Telecommunication" },
	{  4628, "Unassigned" },
	{  4629, "Tele2 Telecommunication" },
	{  4630, "1012-Festnetz-Service" },
	{  4631, "Unassigned" },
	{  4632, "Orange Business Austria" },
	{  4633, "Orange Business Austria" },
	{  4634, "T-Systems Austria" },
	{  4635, "Unassigned" },
	{  4636, "Unassigned" },
	{  4637, "Unassigned" },
	{  4638, "Unassigned" },
	{  4639, "UPC Telekabel Wien" },
	{  4640, "Communications Networking Services (UK)" },
	{  4641, "Communications Networking Services (UK)" },
	{  4642, "Communications Networking Services (UK)" },
	{  4643, "Communications Networking Services (UK)" },
	{  4644, "Communications Networking Services (UK)" },
	{  4645, "British Telecom" },
	{  4646, "Stratos Global Ltd" },
	{  4647, "Stratos Global Ltd" },
	{  4648, "Software Cellular Network Limited" },
	{  4649, "British Telecom" },
	{  4650, "British Telecom" },
	{  4651, "Yanna Technologies LLC" },
	{  4652, "Software Cellular Network Limited" },
	{  4653, "Switchware Ltd" },
	{  4654, "Switchware Ltd" },
	{  4655, "Invomo Ltd" },
	{  4656, "Communications Networking Services (UK)" },
	{  4657, "Opal Telecom Ltd" },
	{  4658, "Communications Networking Services (UK)" },
	{  4659, "Communications Networking Services (UK)" },
	{  4660, "Communications Networking Services (UK)" },
	{  4661, "Communications Networking Services (UK)" },
	{  4662, "Communications Networking Services (UK)" },
	{  4663, "Communications Networking Services (UK)" },
	{  4664, "Communications Networking Services (UK)" },
	{  4665, "Communications Networking Services (UK)" },
	{  4666, "Vodafone Ltd" },
	{  4667, "Vodafone Ltd" },
	{  4668, "QiComm Ltd" },
	{  4669, "Communications Networking Services (UK)" },
	{  4670, "Invicta Group FZE" },
	{  4671, "Greystone Telecom Limited" },
	{  4672, "Cable and Wireless Communications plc" },
	{  4673, "Cable and Wireless Communications plc" },
	{  4674, "Cable and Wireless Communications plc" },
	{  4675, "Cable and Wireless Communications plc" },
	{  4676, "Cable and Wireless Communications plc" },
	{  4677, "Cable and Wireless Communications plc" },
	{  4678, "Cable and Wireless Communications plc" },
	{  4679, "Cable and Wireless Communications plc" },
	{  4680, "Global One Communications Holding Ltd" },
	{  4681, "Invomo Ltd" },
	{  4682, "TeliaSonera International Carrier UK Ltd" },
	{  4683, "Greystone Telecom Limited" },
	{  4684, "Atlas Interactive Group Ltd" },
	{  4685, "QXTEL Ltd" },
	{  4686, "Global Electroteks Ltd" },
	{  4687, "(aq) Networks Ltd" },
	{  4688, "Rhema Telecom" },
	{  4689, "Sound Advertising Ltd" },
	{  4690, "Global One Communications Holding Ltd" },
	{  4691, "Nutel Communications Ltd" },
	{  4692, "Telefonica UK Ltd" },
	{  4693, "Reach Europe Ltd" },
	{  4694, "Reach Europe Ltd" },
	{  4695, "Reach Europe Ltd" },
	{  4696, "Xtec Communications Ltd" },
	{  4697, "Data Access Telecom Ltd" },
	{  4698, "C2C Ltd" },
	{  4699, "IDT Global Ltd" },
	{  4700, "I-21 Ltd" },
	{  4701, "T-Mobile (UK) Ltd" },
	{  4702, "Jersey Telecom" },
	{  4703, "Jersey Telecom" },
	{  4704, "TDC A/S" },
	{  4705, "Unassigned" },
	{  4706, "TDC A/S" },
	{  4707, "Unassigned" },
	{  4708, "TDC A/S" },
	{  4709, "Unassigned" },
	{  4710, "TDC A/S" },
	{  4711, "Unassigned" },
	{  4712, "Sonofon A/S" },
	{  4713, "Sonofon A/S" },
	{  4714, "Global One Communication A/S" },
	{  4715, "Sonofon A/S" },
	{  4716, "Unassigned" },
	{  4717, "Unassigned" },
	{  4718, "Unassigned" },
	{  4719, "Unassigned" },
	{  4720, "Telia Mobile" },
	{  4721, "TeliaSonera AB" },
	{  4722, "Unassigned" },
	{  4723, "Unassigned" },
	{  4724, "Unassigned" },
	{  4725, "Barablu Mobile Ltd" },
	{  4726, "Unassigned" },
	{  4727, "Unassigned" },
	{  4728, "Unassigned" },
	{  4729, "Telcomnet" },
	{  4730, "Unassigned" },
	{  4731, "Unassigned" },
	{  4732, "TeliaSonera AB" },
	{  4733, "Digital Network" },
	{  4734, "Unassigned" },
	{  4735, "Unassigned" },
	{  4736, "TeliaSonera Sverige AB" },
	{  4737, "Ventelo Sverige AB" },
	{  4738, "Tele2 Sverige AB" },
	{  4739, "Tele2 Sverige AB" },
	{  4740, "Ventelo Sverige AB" },
	{  4741, "TeliaSonera Sverige AB" },
	{  4742, "AINMT Sverige AB" },
	{  4743, "TeliaSonera Sverige AB" },
	{  4744, "TeliaSonera Sverige AB" },
	{  4745, "TeliaSonera Sverige AB" },
	{  4746, "TeliaSonera Sverige AB" },
	{  4747, "TeliaSonera Sverige AB" },
	{  4748, "Hi3G Access AB" },
	{  4749, "TDC Song  AB" },
	{  4750, "TDC Song  AB" },
	{  4751, "Interoute Communications Ltd." },
	{  4752, "Rix Telecom AB" },
	{  4753, "Tele2 Sverige AB" },
	{  4754, "TeliaSonera Sverige AB" },
	{  4755, "Hi3G Access AB" },
	{  4756, "Hi3G Access AB" },
	{  4757, "Infonet Broadband Service Corporation" },
	{  4758, "Hi3G Access AB" },
	{  4759, "Dataphone Scandinavia AB" },
	{  4760, "Tele2 Sverige AB" },
	{  4761, "Tele2 Sverige AB" },
	{  4762, "Verizon Sweden AB" },
	{  4763, "Verizon Sweden AB" },
	{  4764, "Telenor Sverige AB" },
	{  4765, "Telenor Sverige AB" },
	{  4766, "Ventelo Sverige AB" },
	{  4767, "Orange Business Sweden AB" },
	{  4768, "Telenor Telecom Solutions AS" },
	{  4769, "Telenor Telecom Solutions AS" },
	{  4770, "Telenor Telecom Solutions AS" },
	{  4771, "Telenor Telecom Solutions AS" },
	{  4772, "Telenor Mobile Aviation AS" },
	{  4773, "Telenor Nett AS" },
	{  4774, "Telenor Nett AS" },
	{  4775, "Equant Norway AS" },
	{  4776, "Telenor Mobil AS" },
	{  4777, "Teletopia Gruppen AS" },
	{  4778, "Teletopia Gruppen AS" },
	{  4779, "Telenor Mobil AS" },
	{  4780, "Network Norway AS" },
	{  4781, "TDC Song AS" },
	{  4782, "Ventelo Bedrift AS" },
	{  4783, "Tele2 Norge AS" },
	{  4784, "NetCom GSM AS" },
	{  4785, "NetCom GSM AS" },
	{  4786, "TDC Song AS" },
	{  4787, "TDC Song AS" },
	{  4788, "Priority Telecom Norway AS" },
	{  4789, "MCI Worldcom AS" },
	{  4790, "TDC Song AS" },
	{  4791, "TDC Song AS" },
	{  4792, "Jernbaneverket" },
	{  4793, "Port IT AS" },
	{  4794, "TDC Norge AS" },
	{  4795, "Unassigned" },
	{  4796, "Taide Network AS" },
	{  4797, "Maritime Communications Partner AS" },
	{  4798, "Nordisk Mobiltelefon AS" },
	{  4799, "Maritime Communications Partner AS" },
	{  4800, "TeliaSonera Finland Oyj" },
	{  4801, "TeliaSonera Finland Oyj" },
	{  4802, "AinaCom Oy" },
	{  4803, "Saunalahti Group Oyj" },
	{  4804, "Fonecta Oy" },
	{  4805, "TeliaSonera Finland Oyj" },
	{  4806, "TeliaSonera Finland Oyj" },
	{  4807, "Unassigned" },
	{  4808, "Unassigned" },
	{  4809, "TeliaSonera Finland Oyj" },
	{  4810, "Unassigned" },
	{  4811, "TeliaSonera Finland Oyj" },
	{  4812, "TeliaSonera Finland Oyj" },
	{  4813, "Unassigned" },
	{  4814, "Unassigned" },
	{  4815, "TeliaSonera Finland Oyj" },
	{  4816, "Alands Mobiltelefon Ab" },
	{  4817, "Alands Mobiltelefon Ab" },
	{  4818, "Unassigned" },
	{  4819, "Unassigned" },
	{  4820, "Elisa Oyj" },
	{  4821, "Elisa Oyj" },
	{  4822, "Unassigned" },
	{  4823, "Unassigned" },
	{  4824, "Unassigned" },
	{  4825, "Elisa Oyj" },
	{  4826, "TDC Song Oy" },
	{  4827, "TDC Song Oy" },
	{  4828, "TDC Song Oy" },
	{  4829, "Unassigned" },
	{  4830, "Unassigned" },
	{  4831, "X-Phone-Com Oy" },
	{  4832, "Elion Ettevotted AS" },
	{  4833, "Elion Ettevotted AS" },
	{  4834, "Tele2 Eesti AS" },
	{  4835, "Tele2 Eesti AS" },
	{  4836, "Elisa Andmesidesttnused AS" },
	{  4837, "Unassigned" },
	{  4838, "Oy Top Connect" },
	{  4839, "Oy Top Connect" },
	{  4840, "Elinet S.p.A." },
	{  4841, "King.com S.p.A." },
	{  4842, "King.com S.p.A." },
	{  4843, "ADR Tel S.p.A." },
	{  4844, "Eutelia S.p.A." },
	{  4845, "Telespazio S.p.A." },
	{  4846, "Tiscali S.p.A." },
	{  4847, "Kast Telecom S.r.l." },
	{  4848, "Colt Telecom S.p.A." },
	{  4849, "Atlanet S.p.A." },
	{  4850, "LTS Le Telecomunicazioni Siciliane S.p.A." },
	{  4851, "LTS Le Telecomunicazioni Siciliane S.p.A." },
	{  4852, "Fonia.com" },
	{  4853, "T-Systems S.p.A." },
	{  4854, "Infracom Italia S.p.A." },
	{  4855, "Telespazio S.p.A." },
	{  4856, "Vodafone S.p.A." },
	{  4857, "Vodafone S.p.A." },
	{  4858, "Syfin S.r.l." },
	{  4859, "Syfin S.r.l." },
	{  4860, "Elinet S.p.A." },
	{  4861, "Elinet S.p.A." },
	{  4862, "Orobiacom S.p.A." },
	{  4863, "Teleque Communications S.p.A." },
	{  4864, "Lattelekom" },
	{  4865, "Lattelekom" },
	{  4866, "Lattelekom" },
	{  4867, "Latvenergo" },
	{  4868, "Latvian Mobile Telephone, LMT" },
	{  4869, "Telecom Baltija" },
	{  4870, "SIA Tele2" },
	{  4871, "Latvian Mobile Telephone, LMT" },
	{  4872, "Mobistar" },
	{  4873, "Mobistar" },
	{  4874, "Versatel Telecom Belgium" },
	{  4875, "Unassigned" },
	{  4876, "BASE sa/nv" },
	{  4877, "BASE sa/nv" },
	{  4878, "KPN Belgium NV" },
	{  4879, "Telenet" },
	{  4880, "Unassigned" },
	{  4881, "Unassigned" },
	{  4882, "Unassigned" },
	{  4883, "KPN Orange Belgium" },
	{  4884, "KPN Orange Belgium" },
	{  4885, "Tele2 Belgium" },
	{  4886, "GC Pan European Crossing Belgie" },
	{  4887, "Dolphin Telecom N.V." },
	{  4888, "Unassigned" },
	{  4889, "M-Link Teleport S.A." },
	{  4890, "Unassigned" },
	{  4891, "Unassigned" },
	{  4892, "MOBISTAR s.a." },
	{  4893, "MOBISTAR s.a." },
	{  4894, "Unassigned" },
	{  4895, "Unassigned" },
	{  4896, "OJSC Rostelecom" },
	{  4897, "OJSC Rostelecom" },
	{  4898, "OJSC Rostelecom" },
	{  4899, "OJSC Rostelecom" },
	{  4900, "OJSC Rostelecom" },
	{  4901, "OJSC Rostelecom" },
	{  4902, "OJSC Rostelecom" },
	{  4903, "OJSC Rostelecom" },
	{  4904, "OJSC Multiregional TransitTelecom" },
	{  4905, "OJSC Multiregional TransitTelecom" },
	{  4906, "OJSC Multiregional TransitTelecom" },
	{  4907, "Unassigned" },
	{  4908, "Unassigned" },
	{  4910, "Unassigned" },
	{  4911, "OJSC Multiregional TransitTelecom" },
	{  4912, "Mobile TeleSystems" },
	{  4913, "North-West Branch of OJSC Megafon" },
	{  4917, "Mobile TeleSystems" },
	{  4920, "CSC Iridium Technologies" },
	{  4928, "OJSC Rostelecom" },
	{  4929, "OJSC Rostelecom" },
	{  4930, "OJSC Rostelecom" },
	{  4931, "OJSC Rostelecom" },
	{  4932, "OJSC Rostelecom" },
	{  4933, "OJSC Rostelecom" },
	{  4934, "OJSC Rostelecom" },
	{  4935, "OJSC Rostelecom" },
	{  5056, "Telekomunikacja Polska S.A." },
	{  5057, "Telekomunikacja Polska S.A." },
	{  5058, "Telekomunikacja Polska S.A." },
	{  5059, "Telekomunikacja Polska S.A." },
	{  5060, "Telekomunikacja Polska S.A." },
	{  5061, "Polkomtel S.A." },
	{  5062, "Polska Telefonia Cyfrowa Sp. Z.o.o." },
	{  5063, "Nordisk Polska Sp. Z.o.o." },
	{  5064, "Carrier1 International GmbH" },
	{  5065, "Carrier1 International GmbH" },
	{  5066, "IMC Telecom AG" },
	{  5067, "SEC Service AG" },
	{  5068, "Vodafone D2 GmbH" },
	{  5069, "Vodafone D2 GmbH" },
	{  5070, "Viatel Communications GmbH" },
	{  5071, "Basis" },
	{  5072, "Cybernet Internet-Dienstleistungen AG" },
	{  5073, "P.T.I. GmbH" },
	{  5074, "Mobilcom City Line GmbH" },
	{  5075, "AT&T-Unisource Communication Services v.o.f." },
	{  5076, "Aermatis AG" },
	{  5077, "Interoute Telecom Deutschland GmbH" },
	{  5078, "Talkline GmbH" },
	{  5079, "e-Tel GmbH" },
	{  5080, "TelePassport AG" },
	{  5081, "European Telecommunication Holding E.T.H. AG" },
	{  5082, "RSLCom Deutschland GmbH" },
	{  5083, "Cable & Wireless Deutschland GmbH" },
	{  5084, "Cable & Wireless Deutschland GmbH" },
	{  5085, "Ventelo GmbH" },
	{  5086, "TeleBel GmbH" },
	{  5087, "Cybernet Internet-Dienstleistungen AG" },
	{  5088, "Cignal Global Communications Germany GmbH" },
	{  5089, "Deutsche Telekom AG" },
	{  5090, "Deutsche Telekom AG" },
	{  5091, "Deutsche Telekom AG" },
	{  5092, "Deutsche Telekom AG" },
	{  5093, "Deutsche Telekom AG" },
	{  5094, "Deutsche Telekom AG" },
	{  5095, "Cignal Global Communications Germany GmbH" },
	{  5096, "Mega-Satellitenfernsehen GmbH" },
	{  5097, "Colt Telecom GmbH" },
	{  5098, "Deutsche Telekom AG" },
	{  5099, "Telecontact GmbH" },
	{  5100, "Phoenix Communication GmbH" },
	{  5101, "Merkur Telecom services GmbH" },
	{  5102, "Coast Media GmbH" },
	{  5103, "GC Pan European Crossing Deutschland GmbH" },
	{  5104, "Deutsche Telekom AG" },
	{  5105, "PM2 Telecommunication GmbH" },
	{  5106, "DeTeMobil Deutsche Telekom MobilNet GmbH" },
	{  5107, "DeTeMobil Deutsche Telekom MobilNet GmbH" },
	{  5108, "DeTeMobil Deutsche Telekom MobilNet GmbH" },
	{  5109, "DeTeMobil Deutsche Telekom MobilNet GmbH" },
	{  5110, "Deutsche Telekom AG" },
	{  5111, "Hanse-X GmbH" },
	{  5112, "FirstMark Communications GmbH" },
	{  5113, "Global One Telekommunikationsdienste GmbH" },
	{  5114, "Interoute Telecom Deutschland GmbH" },
	{  5115, "Intercross Deutschland GmbH" },
	{  5116, "European Telco Exchange (EUTEX) AG" },
	{  5117, "Mobilcom City Line GmbH" },
	{  5118, "Deutsche Telekom AG" },
	{  5119, "01058 Telecom GmbH" },
	{  5120, "Deutsche Telekom AG" },
	{  5121, "Deutsche Telekom AG" },
	{  5122, "Deutsche Telekom AG" },
	{  5123, "Deutsche Telekom AG" },
	{  5124, "Deutsche Telekom AG" },
	{  5125, "Deutsche Telekom AG" },
	{  5126, "Deutsche Telekom AG" },
	{  5127, "Jippi GmbH" },
	{  5128, "Viatel GmbH" },
	{  5129, "Viatel GmbH" },
	{  5130, "Deutsche Telekom AG" },
	{  5131, "tesion Communikationsnetze Sudwest GmbH & Co. KG" },
	{  5132, "tesion Communikationsnetze Sudwest GmbH & Co. KG" },
	{  5133, "Zephyr Telecommunications GmbH" },
	{  5134, "nikotel Deutschland AG" },
	{  5135, "Deutsche Telekom AG" },
	{  5136, "Deutsche Telekom AG" },
	{  5137, "nikotel Deutschland AG" },
	{  5138, "Deutsche Telekom AG" },
	{  5139, "Deutsche Telekom AG" },
	{  5140, "DeTeMobil Deutsche Telekom MobilNet GmbH" },
	{  5141, "DeTeMobil Deutsche Telekom MobilNet GmbH" },
	{  5142, "DeTeMobil Deutsche Telekom MobilNet GmbH" },
	{  5143, "DeTeMobil Deutsche Telekom MobilNet GmbH" },
	{  5144, "Marabu Ermogensverwaltung GmbH" },
	{  5145, "01058 Telecom GmbH" },
	{  5146, "Deutsche Telekom AG" },
	{  5147, "Deutsche Telekom AG" },
	{  5148, "Deutsche Telekom AG" },
	{  5149, "Deutsche Telekom AG" },
	{  5150, "Deutsche Telekom AG" },
	{  5151, "Deutsche Telekom AG" },
	{  5152, "Gibtelecom (mobile service)" },
	{  5154, "Gibtelecom (fixed service)" },
	{  5155, "Sapphire Networks (fixed service)" },
	{  5156, "CTS Gibraltar (mobile service)" },
	{  5157, "Cloud9 (mobile service)" },
	{  5158, "CTS Gibraltar" },
	{  5160, "Orange Austria Telecommunication" },
	{  5161, "Orange Austria Telecommunication" },
	{  5162, "T-Mobile Austria" },
	{  5163, "T-Mobile Austria" },
	{  5164, "T-Mobile Austria" },
	{  5165, "T-Mobile Austria" },
	{  5166, "T-Mobile Austria" },
	{  5167, "OBB - Infrastruktur Bau" },
	{  5168, "Telekomunikacja Polska S.A." },
	{  5169, "MediaTel S.A." },
	{  5170, "GTS Energis Sp. Z.o.o" },
	{  5171, "Netia S.A." },
	{  5172, "Netia S.A." },
	{  5173, "NOM Sp. Z.o.o" },
	{  5174, "NOM Sp. Z.o.o" },
	{  5175, "Premium Internet S.A." },
	{  5184, "PT Comunicacoes S.A." },
	{  5185, "PT Comunicacoes S.A." },
	{  5186, "PT Comunicacoes S.A." },
	{  5187, "PT Comunicacoes S.A." },
	{  5188, "PT Comunicacoes S.A." },
	{  5189, "PT Comunicacoes S.A." },
	{  5190, "PT Comunicacoes S.A." },
	{  5192, "Sonaecom - Servicios de Comunicacoes, S.A." },
	{  5193, "PT Comunicacoes S.A." },
	{  5194, "PT Comunicacoes S.A." },
	{  5195, "PT Comunicacoes S.A." },
	{  5196, "Sonaecom - Servicios de Comunicacoes, S.A." },
	{  5197, "Sonaecom - Servicios de Comunicacoes, S.A." },
	{  5198, "AR Telecom - Access os e Redes de Telecomunicacoes, S.A." },
	{  5199, "Transit Telecom, Sociedade Unipessoal Ltda" },
	{  5201, "Vodafone Portugal, Comunicacoes Pessoais, S.A." },
	{  5202, "Sonaecom - Servicios de Comunicacoes, S.A." },
	{  5203, "Onitelecom - Infocomunicacoes S.A." },
	{  5204, "Onitelecom - Infocomunicacoes S.A." },
	{  5205, "Onitelecom - Infocomunicacoes S.A." },
	{  5206, "ZON TV CABO Portugal, S.A." },
	{  5207, "ZON TV CABO Portugal, S.A." },
	{  5208, "Sonaecom - Servicios de Comunicacoes, S.A." },
	{  5209, "Vodafone Portugal, Comunicacoes Pessoais, S.A." },
	{  5210, "Vodafone Portugal, Comunicacoes Pessoais, S.A." },
	{  5211, "Vodafone Portugal, Comunicacoes Pessoais, S.A." },
	{  5212, "Vodafone Telecel, Comunicacoes Pessoais, S.A." },
	{  5213, "Vodafone Telecel, Comunicacoes Pessoais, S.A." },
	{  5214, "Colt Technology Services - UNIPESSOAL, LDA" },
	{  5215, "Refer Telecom - Servicos de Telecomunicacoes, S.A." },
	{  5216, "Entreprise des Postes et Telecommunications" },
	{  5217, "Entreprise des Postes et Telecommunications" },
	{  5218, "Entreprise des Postes et Telecommunications" },
	{  5219, "Millicom Luxembourg S.A." },
	{  5220, "Multinational Automated Clearing House S.A. (MACH)" },
	{  5221, "Level 3 Communications S.A." },
	{  5222, "Global One Communications S.A." },
	{  5223, "Tele2 Luxembourg S.A." },
	{  5224, "Codenet S.A." },
	{  5225, "Global TeleSystems Luxembourg Sarl" },
	{  5226, "Firstmark Luxembourg S.A." },
	{  5227, "KPN Luxembourg Sarl" },
	{  5228, "HappyCom Sarl" },
	{  5229, "WorldCom S.A." },
	{  5230, "Voxmobile S.A," },
	{  5232, "Sound & Motion bvba" },
	{  5233, "Verizon Nederland B.V." },
	{  5234, "World Teleconnect Telecom B.V." },
	{  5235, "Vodafone Libertel N.V." },
	{  5236, "Vodafone Libertel N.V." },
	{  5237, "Vodafone Libertel N.V." },
	{  5238, "Xantic B.V." },
	{  5240, "BT Nederland N.V." },
	{  5241, "Telfort B.V." },
	{  5242, "21/12/2007" },
	{  5243, "TVI Connect B.V." },
	{  5244, "Tele2 (Netherlands) B.V." },
	{  5245, "T-Mobile Netherlands B.V." },
	{  5246, "Verizon Nederland B.V." },
	{  5247, "KPN Telecom B.V." },
	{  5248, "Eircom plc" },
	{  5249, "Eircom plc" },
	{  5250, "Eircell Ltd" },
	{  5251, "Eircell Ltd" },
	{  5252, "Eircom plc" },
	{  5253, "Telefonica O2 Ireland Ltd" },
	{  5254, "Telefonica O2 Ireland Ltd" },
	{  5255, "Esat Telecom" },
	{  5256, "Esat Telecom" },
	{  5257, "WorldCom" },
	{  5258, "Ocean" },
	{  5259, "ITL" },
	{  5260, "Interoute Irl" },
	{  5261, "Ocean" },
	{  5262, "WorldCom" },
	{  5263, "Budget Telecom" },
	{  5264, "Stentor" },
	{  5266, "Magnet Networks" },
	{  5267, "Interoute" },
	{  5268, "Cable & Wireless" },
	{  5269, "Colt Telecommunications" },
	{  5270, "Colt Telecommunications" },
	{  5271, "ESL Consulting (trading as VoIP Ireland)" },
	{  5272, "Econet Satellite Services Ltd" },
	{  5273, "City Communications (SE) Ltd" },
	{  5274, "Medius Networks Ltd" },
	{  5275, "Arbinet-thexchange (UK) Ltd" },
	{  5276, "Arbinet-thexchange (UK) Ltd" },
	{  5277, "Lan-Net Telecommunications Ltd" },
	{  5278, "Lan-Net Telecommunications Ltd" },
	{  5279, "Lan-Net Telecommunications Ltd" },
	{  5280, "Iceland Telecom Ltd" },
	{  5281, "Iceland Telecom Ltd" },
	{  5283, "IP Fjarskipti Ltd" },
	{  5284, "Hallo Frjals Fjarskipti Ltd" },
	{  5285, "Islandssimi Ltd" },
	{  5286, "Islandssimi Ltd" },
	{  5288, "MCI Worldcom" },
	{  5289, "Azurtel" },
	{  5290, "Intercall" },
	{  5291, "Telia France" },
	{  5292, "Cable & Wireless" },
	{  5293, "Cable & Wireless" },
	{  5294, "Cable & Wireless" },
	{  5295, "Numericable" },
	{  5296, "Interxion" },
	{  5297, "Completel" },
	{  5298, "Tradingcom Europe" },
	{  5299, "KPN Eurovoice BV" },
	{  5300, "Wavecrest Communications France" },
	{  5301, "France Telecom" },
	{  5302, "France Telecom" },
	{  5303, "Prosodie" },
	{  5304, "3U Telecom" },
	{  5305, "Telecom Italia" },
	{  5306, "Bouygues Telecom" },
	{  5308, "Equant Telecommunications SA" },
	{  5309, "SFR" },
	{  5310, "GC Pan European Crossing France" },
	{  5311, "Multicoms" },
	{  5312, "ALBTelecom" },
	{  5313, "AMC (Albanian Mobile Communications)" },
	{  5314, "Vodafone Albania" },
	{  5315, "Eagle Mobile" },
	{  5316, "ALBTelecom" },
	{  5317, "Vodafone Albania" },
	{  5318, "Mobile 4 AL" },
	{  5320, "Communications Networking Services (UK)" },
	{  5321, "Inclarity plc" },
	{  5322, "Lycamobile UK Limited" },
	{  5323, "Lycamobile UK Limited" },
	{  5324, "Stratos Global Ltd" },
	{  5325, "Teleglobe International Ltd" },
	{  5326, "Jersey Airtel Ltd" },
	{  5327, "Communications Networking Services (UK)" },
	{  5328, "Opera Telecom" },
	{  5329, "Magrathea Telecommunications Ltd" },
	{  5330, "Webstar Ltd" },
	{  5331, "Lan-Net Telecommunications Ltd" },
	{  5332, "T-Mobile (UK) Ltd" },
	{  5333, "Global Crossing (UK) Ltd" },
	{  5334, "Global Crossing (UK) Ltd" },
	{  5335, "Elaracom Ltd" },
	{  5336, "Switchware Ltd" },
	{  5337, "Infiniroute Networks Inc" },
	{  5338, "Startec Global Communications Corp." },
	{  5339, "COLT Telecommunications" },
	{  5340, "Global Crossing (UK) Ltd" },
	{  5341, "Ematel Communications Inc" },
	{  5342, "Via-Fon Ltd" },
	{  5343, "Smile Telecommunications Ltd" },
	{  5344, "Maltacom/GO plc" },
	{  5345, "Maltacom/GO plc" },
	{  5346, "Mobisle Communications Ltd" },
	{  5347, "Vodafone Malta Ltd." },
	{  5348, "Vodafone Malta Ltd." },
	{  5349, "Maltacom/GO plc" },
	{  5350, "Maltacom/GO plc" },
	{  5351, "3G Telecommunications Ltd" },
	{  5352, "AGSM Telecomunicazioni srl" },
	{  5353, "Eutelia S.p.A." },
	{  5354, "Consiagnet S.p.A." },
	{  5355, "Wind Telecomunicazioni S.p.A." },
	{  5356, "Wind Telecomunicazioni S.p.A." },
	{  5357, "Wind Telecomunicazioni S.p.A." },
	{  5358, "Wind Telecomunicazioni S.p.A." },
	{  5359, "Vanguard S.r.L." },
	{  5360, "Publitel S.p.A." },
	{  5361, "Publitel S.p.A." },
	{  5362, "Nodalis S.p.A." },
	{  5363, "Nodalis S.p.A." },
	{  5364, "Eutelia S.p.A." },
	{  5365, "Calcatel Rete S.p.A." },
	{  5366, "Telegate Italia" },
	{  5367, "Consorzio Terrecablate" },
	{  5368, "Trans World Telecommunications srl" },
	{  5369, "Tiscali S.p.A." },
	{  5370, "TIM Italia S.p.A." },
	{  5371, "TIM Italia S.p.A." },
	{  5372, "GSC Global System Communications S.p.A." },
	{  5373, "Tex 97 S.p.A." },
	{  5374, "Tele2 Italia S.p.A." },
	{  5375, "Elinet S.p.A." },
	{  5376, "Cyprus Telecommunications Authority (CYTA)" },
	{  5377, "Cyprus Telecommunications Authority (CYTA)" },
	{  5378, "Areeba Ltd (MTN)" },
	{  5379, "Callsat Telecom Cyprus" },
	{  5380, "Areeba Ltd (MTN)" },
	{  5381, "OTENet Telecommunications Ltd." },
	{  5382, "Primetel Ltd" },
	{  5383, "D.S.T. Omega Telecom" },
	{  5384, "Communications Networking Services (UK)" },
	{  5385, "n-Tel Communications Ltd" },
	{  5386, "D2C Telecom Ltd" },
	{  5387, "Invomo Ltd" },
	{  5388, "Teleglobe International Ltd" },
	{  5389, "Verizon UK Ltd" },
	{  5390, "Eircom UK Ltd" },
	{  5391, "Teleglobe International Ltd" },
	{  5392, "SingTel (Europe) Ltd" },
	{  5393, "Routo Telecommunications Ltd" },
	{  5394, "COLT Telecommunications" },
	{  5395, "Telco Global Network Services Ltd" },
	{  5396, "Dumerton International Inc" },
	{  5397, "Cable and Wireless Guernsey Ltd" },
	{  5398, "Communications Networking Services (UK)" },
	{  5399, "Orange" },
	{  5400, "T-Mobile (UK) Ltd" },
	{  5401, "Lebara Ltd" },
	{  5402, "Vectone Network Ltd" },
	{  5403, "AIC Telecom UK Ltd" },
	{  5404, "Communications Networking Services (UK)" },
	{  5405, "Communications Networking Services (UK)" },
	{  5406, "Primus Telecommunications" },
	{  5407, "Spacetel" },
	{  5408, "NTL" },
	{  5409, "Route365 Ltd" },
	{  5410, "Nexus Telecommunications plc" },
	{  5411, "Nexus Telecommunications plc" },
	{  5412, "Network Brokers Ltd" },
	{  5413, "Sound Advertising Ltd" },
	{  5414, "MCI Worldcom Ltd" },
	{  5415, "IDT Global Ltd" },
	{  5416, "Global Crossing (UK) Ltd" },
	{  5417, "Network Brokers Ltd" },
	{  5418, "Your Communications Ltd" },
	{  5419, "Gateway Communications (UK) Ltd" },
	{  5420, "Startec Global Communications Corp." },
	{  5421, "Lebara Ltd" },
	{  5422, "iCard European Telecommunications (Ireland) Ltd" },
	{  5423, "COLT Telecommunications" },
	{  5424, "Teleglobe International Ltd" },
	{  5425, "Global Crossing (UK) Ltd" },
	{  5426, "iBasis" },
	{  5427, "Atlas Interactive Group Ltd" },
	{  5428, "Tele2 UK Services Ltd" },
	{  5429, "Telco Global Network Services Ltd" },
	{  5430, "Communications Networking Services (UK)" },
	{  5431, "Network Brokers Ltd" },
	{  5432, "Telstra Europe Ltd" },
	{  5433, "Communications Networking Services (UK)" },
	{  5434, "Centrica Telecommunications" },
	{  5435, "SuperLine Telecommunications Ltd" },
	{  5436, "SuperLine Telecommunications Ltd" },
	{  5437, "Communications Networking Services (UK)" },
	{  5438, "Communications Networking Services (UK)" },
	{  5439, "T-Systems Ltd" },
	{  5440, "Telecom Partners Network" },
	{  5441, "Bulgarian Telecommunication Company" },
	{  5442, "Bulgarian Telecommunication Company" },
	{  5443, "Orbitel" },
	{  5444, "Spectrum Net" },
	{  5445, "Cosmo Bulgaria Mobile" },
	{  5446, "Mobiltel" },
	{  5447, "Radiotelecommunication Company" },
	{  5448, "QiComm Ltd" },
	{  5449, "MCI Worldcom Ltd" },
	{  5450, "Global Electroteks Ltd" },
	{  5451, "RFE Technologies UK Ltd" },
	{  5452, "Arbinet-thexchange (UK) Ltd" },
	{  5453, "O2 (UK) Ltd" },
	{  5454, "IDT Global Ltd" },
	{  5455, "IDT Global Ltd" },
	{  5456, "IDT Global Ltd" },
	{  5457, "IDT Global Ltd" },
	{  5458, "n-Tel Communications Ltd" },
	{  5459, "Wight Cable 2005 Ltd" },
	{  5460, "VTL (UK) Ltd" },
	{  5461, "Communications Networking Services (UK)" },
	{  5462, "COLT Telecommunications" },
	{  5463, "Global Electroteks Ltd" },
	{  5464, "Eser Telekom" },
	{  5465, "Gisad" },
	{  5466, "Borusan" },
	{  5468, "Vianet" },
	{  5469, "Superonline" },
	{  5470, "Netone" },
	{  5472, "Turk Telekom" },
	{  5473, "Turk Telekom" },
	{  5474, "Turk Telekom" },
	{  5475, "Turk Telekom" },
	{  5476, "Vodafone" },
	{  5477, "Turkcell" },
	{  5478, "Turkcell" },
	{  5479, "Vodafone" },
	{  5481, "Avea" },
	{  5482, "Avea" },
	{  5483, "Avea" },
	{  5484, "Avea" },
	{  5485, "Vodafone" },
	{  5486, "Vodafone" },
	{  5487, "Millenicom" },
	{  5488, "COLT Telecommunications" },
	{  5489, "n-Tel Communications Ltd" },
	{  5490, "Orange" },
	{  5491, "Communications Networking Services (UK)" },
	{  5492, "Communications Networking Services (UK)" },
	{  5493, "Telecom New Zealand UK Ltd" },
	{  5494, "Bethlehem Technologies London" },
	{  5495, "Wavecrest (UK) Ltd" },
	{  5496, "n-Tel Communications Ltd" },
	{  5497, "Citrus Telecommunications Ltd" },
	{  5498, "Orange" },
	{  5499, "Telco Global Network Services Ltd" },
	{  5500, "Communications Networking Services (UK)" },
	{  5501, "Symmetric Quorum Ltd" },
	{  5502, "Global Crossing (UK) Ltd" },
	{  5503, "Jetmode Communications Ltd" },
	{  5504, "Voicetec Systems Ltd" },
	{  5505, "Jetmode Communications Ltd" },
	{  5506, "Orange" },
	{  5507, "Orange" },
	{  5508, "Telstra Europe Ltd" },
	{  5509, "Clemcom" },
	{  5510, "Wire9 Telecom plc" },
	{  5511, "Nowtel UK Ltd" },
	{  5512, "n-Tel Communications Ltd" },
	{  5513, "QiComm Ltd" },
	{  5514, "IDT Global Ltd" },
	{  5515, "Airflow Global Ltd" },
	{  5516, "n-Tel Communications Ltd" },
	{  5517, "n-Tel Communications Ltd" },
	{  5518, "Global One Communications Holding Ltd" },
	{  5519, "Centrica Telecommunications" },
	{  5520, "QiComm Ltd" },
	{  5521, "T-Mobile (UK) Ltd" },
	{  5522, "Cable and Wireless Guernsey Ltd" },
	{  5523, "Murex Telecom Ltd" },
	{  5524, "Teleglobe International Ltd" },
	{  5525, "Global Crossing (UK) Ltd" },
	{  5526, "Cable & Wireless Jersey Ltd" },
	{  5527, "Wavecrest (UK) Ltd" },
	{  5528, "C2C Ltd" },
	{  5529, "Level 3 Communications Ltd" },
	{  5530, "Tele2 UK Services Ltd" },
	{  5531, "AIC Telecom" },
	{  5532, "Cable and Wireless (Energis)" },
	{  5533, "Rogers Communications Inc." },
	{  5534, "QiComm Ltd" },
	{  5535, "n-Tel Communications Ltd" },
	{  5536, "HT-Hrvatske telekomunikacije d.d." },
	{  5537, "VIPnet d.o.o." },
	{  5538, "Tele 2 d.o.o." },
	{  5539, "HT-mobilne telekomunikacije d.o.o." },
	{  5540, "HT-Hrvatske telekomunikacije d.d." },
	{  5541, "HT-mobilne telekomunikacije d.o.o." },
	{  5542, "VIPnet d.o.o." },
	{  5543, "VIPnet d.o.o." },
	{  5544, "System House S.r.l." },
	{  5545, "Tele2 Italia S.p.A." },
	{  5546, "TIM Italia S.p.A." },
	{  5547, "Tele2 Italia S.p.A." },
	{  5548, "Thunder S.p.A." },
	{  5549, "Karupa S.r.l." },
	{  5550, "TIM Italia S.p.A." },
	{  5551, "TIM Italia S.p.A." },
	{  5552, "Telekom Slovenija p.o." },
	{  5553, "Telekom Slovenija p.o." },
	{  5554, "Si.Mobil d.d." },
	{  5555, "Telekom Slovenije d.d." },
	{  5556, "Tusmobil d.o.o." },
	{  5558, "IN.LIFE druzba za internet storitve, d.d." },
	{  5559, "Tus Telekom d.d." },
	{  5560, "Eutelia S.p.A." },
	{  5561, "Tele2 Italia S.p.A." },
	{  5562, "Digitel Italia S.r.l." },
	{  5563, "Rete Italiana Assicurativa di TLC. S.r.l." },
	{  5564, "Progetel Distribuzione Italia S.p.A." },
	{  5565, "Progetel Distribuzione Italia S.p.A." },
	{  5566, "Openline S.p.A." },
	{  5567, "GC Pan European Crossing Italia S.r.l." },
	{  5569, "Intelcom" },
	{  5570, "SMT-San Marino Telecom" },
	{  5571, "SMT-San Marino Telecom" },
	{  5573, "Mega M, d.o.o." },
	{  5576, "COLT Telecommunications" },
	{  5577, "Telco Global Network Services Ltd" },
	{  5578, "n-Tel Communications Ltd" },
	{  5579, "KDDI Europe" },
	{  5580, "Wavecrest (UK) Ltd" },
	{  5581, "Communications Networking Services (UK)" },
	{  5582, "O2 (UK) Ltd" },
	{  5583, "Scala Telecom Ltd" },
	{  5584, "Jersey Telecom" },
	{  5585, "Jersey Telecom" },
	{  5586, "Jersey Telecom" },
	{  5587, "Vital Phone Ltd" },
	{  5588, "TeliaSonera International Carrier UK Ltd" },
	{  5589, "Switchware Ltd" },
	{  5590, "Affiniti Integrated Solutions Ltd" },
	{  5591, "Telco Global Network Services Ltd" },
	{  5592, "Global One" },
	{  5593, "Global One" },
	{  5594, "O2 (UK) Ltd" },
	{  5595, "C2C Ltd" },
	{  5596, "Arbinet-thexchange (UK) Ltd" },
	{  5597, "City Communications (SE) Ltd" },
	{  5598, "QiComm Ltd" },
	{  5599, "Lebara Ltd" },
	{  5600, "Nexus Telecommunications plc" },
	{  5601, "O2 (UK) Ltd" },
	{  5602, "British Telecom" },
	{  5603, "Stratos Global Ltd" },
	{  5604, "Global Networks Switzerland Inc." },
	{  5605, "Global Networks Switzerland Inc." },
	{  5606, "Global Networks Switzerland Inc." },
	{  5607, "GMK Telecom Ltd" },
	{  5608, "Data Access Telecom Ltd" },
	{  5609, "O2 (UK) Ltd" },
	{  5610, "Gamma Telecom Holdings Ltd" },
	{  5611, "O2 (UK) Ltd" },
	{  5612, "T-Mobile (UK) Ltd" },
	{  5613, "T-Mobile (UK) Ltd" },
	{  5614, "Cable and Wireless Isle of Man Ltd" },
	{  5615, "Instafone plc" },
	{  5616, "Cable and Wireless (Energis)" },
	{  5617, "Lleida.net Serveis Telematics Limited" },
	{  5618, "QiComm Ltd" },
	{  5619, "Cable and Wireless Communications plc" },
	{  5620, "m2m Wholesale Ltd" },
	{  5621, "Wireless Solutions International" },
	{  5622, "Colt" },
	{  5623, "Colt" },
	{  5624, "PLDT (UK) Ltd" },
	{  5625, "Communications Networking Services (UK)" },
	{  5626, "ntl Group Ltd" },
	{  5627, "Global Crossing (UK) Ltd" },
	{  5628, "Fibernet (UK) Ltd" },
	{  5629, "Gamma Telecom Holdings Ltd" },
	{  5630, "Jersey Telecom" },
	{  5631, "Telco Global Network Services Ltd" },
	{  5632, "Djuice Mobile Sweden, filial till Telenor Mobile Sweden AS" },
	{  5633, "Gtelecom Ltd. (British Virgin Islands) filial" },
	{  5634, "TeliaSonera Sverige AB" },
	{  5635, "TeliaSonera Sverige AB" },
	{  5636, "TeliaSonera Sverige AB" },
	{  5637, "TeliaSonera Sverige AB" },
	{  5638, "TDC Sverige AB" },
	{  5639, "Ventelo Sverige AB" },
	{  5640, "Verizon Sweden AB" },
	{  5641, "Telenor Sverige AB" },
	{  5642, "Telenor Sverige AB" },
	{  5643, "Ventelo Sverige AB" },
	{  5644, "Tele2 Sverige AB" },
	{  5645, "Tele2 Sverige AB" },
	{  5646, "Orange Business Sweden AB" },
	{  5647, "Lycamobile Sweden Ltd" },
	{  5648, "Dataphone Scandinavia AB" },
	{  5649, "Colt Telecom AB" },
	{  5650, "Telenor Sverige AB" },
	{  5651, "Telenor Sverige AB" },
	{  5652, "Telenor Sverige AB" },
	{  5653, "Telenor Sverige AB" },
	{  5654, "Lycamobile Sweden Ltd" },
	{  5655, "AINMT Sverige AB" },
	{  5656, "Hi3G Access AB" },
	{  5657, "Hi3G Access AB" },
	{  5658, "Telenor Sverige AB" },
	{  5659, "Banverket" },
	{  5660, "Gtelecom Ltd. (British Virgin Islands) filial" },
	{  5661, "Telenor Connexion AB" },
	{  5662, "Telenor Connexion AB" },
	{  5663, "Spring Mobil AB" },
	{  5665, "Servei de Telecomunicacions d'Andorra" },
	{  5680, "N.V. Casema" },
	{  5681, "N.V. Casema" },
	{  5682, "Vodafone Libertel N.V." },
	{  5683, "I-21 Netherlands B.V." },
	{  5684, "Versatel Nederland B.V." },
	{  5685, "Versatel Nederland B.V." },
	{  5686, "Versatel Nederland B.V." },
	{  5687, "EZ Phone B.V." },
	{  5688, "AS STV" },
	{  5689, "AS EMT" },
	{  5690, "AS EMT" },
	{  5691, "ProGroup Holding OY" },
	{  5692, "AS EVR Infra" },
	{  5694, "AS Telefant" },
	{  5695, "OY Teqli Telecom" },
	{  5696, "Arminco" },
	{  5697, "Armentel JV CJSC" },
	{  5698, "Armentel JV CJSC" },
	{  5699, "Orange Armenia" },
	{  5700, "PMF-SAL" },
	{  5701, "K Telecom" },
	{  5702, "K Telecom" },
	{  5703, "Cornet-AM" },
	{  5704, "Telecom Italia" },
	{  5705, "SFR" },
	{  5706, "Colt Telecommunications" },
	{  5707, "Colt Telecommunications" },
	{  5708, "Ibasis" },
	{  5709, "SFR" },
	{  5710, "Dauphin Telecom" },
	{  5711, "France Telecom" },
	{  5712, "Telecom Italia" },
	{  5713, "SFR" },
	{  5714, "Completel" },
	{  5715, "France Telecom" },
	{  5716, "France Telecom" },
	{  5717, "France Telecom" },
	{  5718, "Midi Telecom" },
	{  5719, "KDD France" },
	{  5720, "France Telecom" },
	{  5721, "Central Telecom" },
	{  5723, "Free Telecom" },
	{  5724, "Free Telecom" },
	{  5725, "Outremer Telecom" },
	{  5726, "Telemedia" },
	{  5727, "SFR" },
	{  5728, "Beltelecom" },
	{  5729, "Beltelecom" },
	{  5737, "Gotalandsnatet" },
	{  5738, "42IT AB" },
	{  5739, "42IT AB" },
	{  5740, "Beepsend AB" },
	{  5741, "EuTel AB" },
	{  5744, "Vivodi" },
	{  5745, "Telepassport" },
	{  5746, "Intraconnect" },
	{  5747, "NetOne" },
	{  5748, "Voicenet" },
	{  5749, "WIND" },
	{  5750, "WIND" },
	{  5751, "RG Communications" },
	{  5752, "Degatel S.r.l." },
	{  5753, "GTN Italia S.p.A." },
	{  5754, "Qtel S.p.A." },
	{  5755, "Tele2 Italia S.p.A." },
	{  5756, "Tele2 Italia S.p.A." },
	{  5757, "Brennercom S.p.A." },
	{  5758, "Energ.it S.p.A." },
	{  5759, "CS Info S.p.A." },
	{  5760, "Telecom Georgia Ltd" },
	{  5761, "JSC Egrisi" },
	{  5762, "MagtiCom Ltd" },
	{  5763, "Geocell Ltd" },
	{  5764, "GT Mobile" },
	{  5765, "Ultra Communications Ltd" },
	{  5766, "Saktelcom Plus Ltd" },
	{  5767, "Tesaco Ltd" },
	{  5768, "Net2Phone Inc" },
	{  5769, "Telewest Communications Group Limited" },
	{  5770, "Telewest Communications plc" },
	{  5771, "Telewest Communications plc" },
	{  5772, "Telewest Communications Group Limited" },
	{  5773, "X-Xchange Telecommunications Signalling Services GmbH" },
	{  5774, "X-Xchange Telecommunications Signalling Services GmbH" },
	{  5775, "Epsilon Telecommunications Ltd" },
	{  5776, "Verizon Global Soluitions" },
	{  5777, "Global World Telecom" },
	{  5778, "Lan-Net Telecommunications Ltd" },
	{  5779, "Lycamobile UK Limited" },
	{  5780, "Synterra UK Ltd" },
	{  5781, "Fibernet (UK) Ltd" },
	{  5782, "Surelink Ltd." },
	{  5783, "Vodafone Ltd" },
	{  5784, "Colt" },
	{  5785, "Orange" },
	{  5786, "Starcomm Ltd" },
	{  5787, "Vodafone Ltd" },
	{  5788, "iCard European Telecommunications (Ireland) Ltd" },
	{  5789, "Vital Phone Ltd" },
	{  5790, "Willaf Ltd." },
	{  5791, "T-Mobile (UK) Ltd" },
	{  5792, "GTS Datanet Telecommunications Ltd." },
	{  5793, "UPC Hungary Ltd" },
	{  5794, "Invitel Ltd" },
	{  5795, "Magyar Telekom Plc" },
	{  5796, "Magyar Telekom Plc" },
	{  5797, "Invitel Ltd" },
	{  5798, "Pannon GSM" },
	{  5799, "CSINFO Ltd." },
	{  5800, "Macrocom Ltd" },
	{  5801, "Rustavi2 Online Ltd" },
	{  5802, "Central Georgian Communications Co. Ltd." },
	{  5803, "Georgian Electrical Communications JSC" },
	{  5804, "Infotel Ltd" },
	{  5806, "Telenet" },
	{  5807, "Caucasus Digital Ntework Ltd" },
	{  5808, "Ukrtelecom JSC" },
	{  5809, "Ukrtelecom JSC" },
	{  5810, "reserved" },
	{  5811, "Ukrtelecom JSC" },
	{  5812, "Golden Telecom" },
	{  5813, "Ukrainian Telecommunication" },
	{  5814, "SS-7 Network Management Centre" },
	{  5815, "SS-7 Network Monitoring and Measurement Centre" },
	{  5816, "Rete Ferroviaria Italiana S.p.A." },
	{  5817, "Acantho S.p.A." },
	{  5818, "Multilink S.p.A." },
	{  5819, "H3G S.p.A." },
	{  5820, "Sinergie srl" },
	{  5821, "TIM Italia S.p.A." },
	{  5822, "TIM Italia S.p.A." },
	{  5823, "TIM Italia S.p.A." },
	{  5824, "Ipse 2000 S.p.A." },
	{  5825, "Ipse 2000 S.p.A." },
	{  5826, "Cable & Wireless S.p.A." },
	{  5827, "Eutelia S.p.A." },
	{  5828, "Eutelia S.p.A." },
	{  5829, "Eutelia S.p.A." },
	{  5830, "Closed Joint Stock Company Ukranian Mobile Communications" },
	{  5831, "Trans World Communications Italia S.p.A." },
	{  5833, "COLT Telecom" },
	{  5840, "BH Telecom d.d. Sarajevo" },
	{  5841, "BH Telecom d.d. Sarajevo" },
	{  5842, "BH Telecom d.d. Sarajevo" },
	{  5843, "HT d.o.o. Mostar" },
	{  5844, "Telekomunikacije RS, a.d. Banja Luka" },
	{  5845, "Telekomunikacije RS, a.d. Banja Luka" },
	{  5846, "BH Telecom d.d. Sarajevo" },
	{  5847, "BH Telecom d.d. Sarajevo" },
	{  5848, "T3 d.o.o. Sarajevo" },
	{  5849, "AirABA d.o.o. Sarajevo" },
	{  5850, "Logosoft d.o.o. Sarajevo" },
	{  5851, "Crumb Group d.o.o. Bijeljina" },
	{  5852, "AKT.ONLINE d.o.o. Sarajevo" },
	{  5853, "Europronet Bosnia d.o.o. Sarajevo" },
	{  5854, "Aneks d.o.o. Banja Luka" },
	{  5855, "\"M&H\" Company d.o.o. Sarajevo" },
	{  5856, "Neotel" },
	{  5857, "AD Makedonski Telekomunikaci" },
	{  5858, "AD Makedonski Telekomunikaci" },
	{  5859, "AD Makedonski Telekomunikaci" },
	{  5860, "AD Makedonski Telekomunikaci" },
	{  5861, "Cosmofon A.D. Skopje" },
	{  5862, "Akton" },
	{  5863, "Nexcom Makedonija" },
	{  5864, "France Telecom" },
	{  5865, "France Telecom" },
	{  5867, "SFR" },
	{  5868, "SFR" },
	{  5870, "Transatel" },
	{  5872, "Teleworld International Ltd." },
	{  5873, "Telefonwelt GmbH" },
	{  5874, "Rapidlink Telecommunications GmbH" },
	{  5875, "Acris Telecom GmbH" },
	{  5876, "01051 Telecom GmbH" },
	{  5877, "OneTel Telecommunication GmbH" },
	{  5878, "Infotel BV" },
	{  5879, "DB Netz AG" },
	{  5880, "Cabovisao - Televisao por Cabo, S.A." },
	{  5881, "Cabovisao - Televisao por Cabo, S.A." },
	{  5882, "G9SA - Telecomunicacoes S.A." },
	{  5883, "G9SA - Telecomunicacoes S.A." },
	{  5884, "RadioMovel - Telecomunicacoes, S.A." },
	{  5885, "RadioMovel - Telecomunicacoes, S.A." },
	{  5886, "Telsocomm - Telecomunicacoes, Marketing e Informatica Ltda" },
	{  5888, "Moldtelecom" },
	{  5889, "Moldtelecom" },
	{  5890, "Moldtelecom CDMA" },
	{  5892, "Eventis Mobile GSM" },
	{  5894, "Moldcell GSM" },
	{  5895, "Orange Moldova GSM" },
	{  5896, "Kabel Hessen GmbH & Co, KG" },
	{  5897, "Acris Telecom GmbH" },
	{  5898, "Global Telecommunication Services GmbH" },
	{  5899, "Xtec Communication Ltd." },
	{  5900, "Marabu Vermogensverwaltung GmbH" },
	{  5901, "extr@com AG" },
	{  5902, "extr@com AG" },
	{  5903, "01051 Telecom GmbH" },
	{  5904, "Dentel Netzwerk Telefonie GmbH" },
	{  5905, "BT Ignite GmbH & Co." },
	{  5906, "BT Ignite GmbH & Co." },
	{  5907, "HanseNet Telekommunikation GmbH" },
	{  5908, "Mobilcom City Line GmbH" },
	{  5909, "Mobilcom City Line GmbH" },
	{  5910, "MobilCom Multimedia GmbH" },
	{  5911, "MobilCom Multimedia GmbH" },
	{  5912, "Datek Telecom" },
	{  5913, "Vodafone Romania" },
	{  5914, "Vodafone Romania" },
	{  5915, "Vodafone Romania" },
	{  5916, "Orange Romania" },
	{  5917, "Vodafone Romania" },
	{  5918, "Orange Romania" },
	{  5919, "SNRadiocomunicatii" },
	{  5920, "Telefonica O2 Czech Republic a.s." },
	{  5921, "Telefonica O2 Czech Republic a.s." },
	{  5922, "Telefonica O2 Czech Republic a.s." },
	{  5923, "Telefonica O2 Czech Republic a.s." },
	{  5924, "Telefonica O2 Czech Republic a.s." },
	{  5925, "MATTES AD, spol s.r.o." },
	{  5926, "CEZ ITC Services a.s." },
	{  5927, "T-Mobile Czech Republic a.s." },
	{  5928, "BT (Worldwide) Ltd., organizacni slozka" },
	{  5929, "Telefonica O2 Czech Republic a.s." },
	{  5930, "Telefonica O2 Czech Republic a.s." },
	{  5932, "GTS Novera s.r.o." },
	{  5933, "GTS Novera s.r.o." },
	{  5934, "GTS Novera s.r.o." },
	{  5935, "GTS Novera s.r.o." },
	{  5936, "T-Systems Pragonet, a.s." },
	{  5937, "T-Mobile Czech Republic a.s." },
	{  5938, "T-Mobile Czech Republic a.s." },
	{  5939, "Vodafone Czech Republic a.s." },
	{  5940, "Vodafone Czech Republic a.s." },
	{  5941, "Telefonica O2 Czech Republic a.s." },
	{  5942, "Telefonica O2 Czech Republic a.s." },
	{  5943, "T-Mobile Czech Republic a.s." },
	{  5944, "T-Mobile Czech Republic a.s." },
	{  5945, "T-Mobile Czech Republic a.s." },
	{  5946, "T-Mobile Czech Republic a.s." },
	{  5947, "GTS Novera s.r.o." },
	{  5948, "T-Mobile Czech Republic a.s." },
	{  5949, "T-Mobile Czech Republic a.s." },
	{  5950, "Telekom Austria Czech Republic a.s." },
	{  5951, "T-Mobile Czech Republic a.s." },
	{  5952, "Zeleznice Slovenskej republiky" },
	{  5953, "Slovak Telekom, a.s." },
	{  5954, "Slovak Telekom, a.s." },
	{  5955, "4Call, s.r.o." },
	{  5956, "Slovak Telekom, a.s." },
	{  5957, "Slovak Telekom, a.s." },
	{  5958, "Slovak Telekom, a.s." },
	{  5959, "Slovak Telekom, a.s." },
	{  5960, "GTS Nextra s.r.o." },
	{  5961, "Telefonica O2 Slovakia, s.r.o." },
	{  5962, "eTel Slovensko, s.r.o." },
	{  5963, "Dial Telecom, a.s." },
	{  5964, "GTS Slovakia s.r.o." },
	{  5965, "Amtel Slovensko, s.r.o." },
	{  5967, "Slovanet, a.s." },
	{  5968, "UPC Slovensko, s.r.o." },
	{  5969, "Orange Slovensko, a.s." },
	{  5970, "Swan, s.r.o." },
	{  5971, "Orange Slovensko, a.s." },
	{  5972, "Orange Slovensko, a.s." },
	{  5973, "Orange Slovensko, a.s." },
	{  5974, "BT Slovakia, s.r.o." },
	{  5975, "Energotel, a.s." },
	{  5976, "T-Mobile Slovensko, a.s." },
	{  5977, "Orange Slovensko, a.s." },
	{  5978, "T-Mobile Slovensko, a.s." },
	{  5979, "Orange Slovensko, a.s." },
	{  5980, "T-Mobile Slovensko, a.s." },
	{  5981, "Orange Slovensko, a.s." },
	{  5982, "T-Mobile Slovensko, a.s." },
	{  5983, "Orange Slovensko, a.s." },
	{  5984, "TEO LT, AB (former Lietuvos Telekomas)" },
	{  5985, "Mediafon" },
	{  5986, "Tele2" },
	{  5987, "Bite Lietuva (former Bite GSM)" },
	{  5988, "Omnitel" },
	{  5989, "Tele2" },
	{  5990, "TEO LT, AB (former Lietuvos Telekomas)" },
	{  5991, "Bite Lietuva (former Bite GSM)" },
	{  5992, "Telefonica Moviles Espana, S.A.U." },
	{  5993, "Telefonica Moviles Espana, S.A.U." },
	{  5994, "Telefonica Moviles Espana, S.A.U." },
	{  5995, "Telefonica Moviles Espana, S.A.U." },
	{  5996, "Equant Spain, S.A." },
	{  5997, "Best Spain Telecom, S.L." },
	{  5998, "Quantum Sistemas, S.A." },
	{  5999, "Orange Web Services, S.L." },
	{  6000, "Tiscali Telecomunicaciones, S.A." },
	{  6001, "Comunitel Global, S.A." },
	{  6002, "Tiscali Telecomunicaciones, S.A." },
	{  6003, "Vic Telehome, S.L." },
	{  6004, "Cableuropa, S.A." },
	{  6005, "Xfera Moviles S.A." },
	{  6006, "Xfera Moviles S.A." },
	{  6007, "BT Espana, S.A." },
	{  6008, "Primus Telecommunicationes Spain, S.A." },
	{  6009, "Uni2 Telecomunicaciones, S.A.U." },
	{  6010, "Uni2 Telecomunicaciones, S.A.U." },
	{  6011, "Convergia Espana, S.L." },
	{  6012, "Metrored, S.A." },
	{  6013, "Teleconnect Comunicaciones, S.A." },
	{  6014, "Auna Telecomunicaciones, S.A." },
	{  6015, "Tele2 Telecommunication Services, S.L." },
	{  6016, "BT Espana, S.A.U." },
	{  6017, "BT Espana, S.A.U." },
	{  6018, "Jazz Telecom, S.A." },
	{  6019, "Facilicom International, S.L." },
	{  6020, "Jazz Telecom, S.A." },
	{  6021, "Cable & Wireless, S.L.U." },
	{  6022, "Cable & Wireless, S.L.U." },
	{  6023, "Comunitel Global, S.A." },
	{  6024, "Retecal, S.A." },
	{  6025, "Telestrella Spain, S.L." },
	{  6026, "Colt Telecom Espana, S.A." },
	{  6027, "System One World Communication Iberia" },
	{  6028, "Teleglobe Spain Communications, S.L.U." },
	{  6029, "Globalcom Telecomunicaciones, S.A." },
	{  6030, "MCI WorldCom Spain, S.A." },
	{  6031, "Capcom International, S.L." },
	{  6032, "DeTeMobil Deutsche Telekom MobilNet GmbH" },
	{  6033, "Intercross Deutschland GmbH" },
	{  6034, "Mobilcom City Line GmbH" },
	{  6035, "VarTec Telecom Europe Ltd." },
	{  6036, "Ventelo GmbH" },
	{  6037, "Ventelo GmbH" },
	{  6038, "Mundophone Telekommunikations GmbH" },
	{  6039, "gecco.net AG" },
	{  6040, "Versatel Deutschland GmbH & Co. KG" },
	{  6041, "Cable & Wireless Deutschland GmbH" },
	{  6042, "Cable & Wireless Deutschland GmbH" },
	{  6043, "Colt Telecom GmbH" },
	{  6044, "Colt Telecom GmbH" },
	{  6045, "TelDaFax AG" },
	{  6046, "gecco.net AG" },
	{  6047, "SevenL Communications GmbH" },
	{  6048, "tesion Communikationsnetze Sudwest GmbH & Co. KG" },
	{  6049, "Vodafone D2 GmbH" },
	{  6050, "Vodafone D2 GmbH" },
	{  6051, "Tropolys Service GmbH" },
	{  6052, "I-21 Germany GmbH" },
	{  6053, "Einsteinet AG" },
	{  6054, "I-21 Germany GmbH" },
	{  6055, "01066 GmbH" },
	{  6056, "BT Ignite GmbH & Co." },
	{  6057, "O2 (Germany) GmbH & Co." },
	{  6058, "O2 (Germany) GmbH & Co." },
	{  6059, "Kinnevik Telecommunications International S.A." },
	{  6060, "RSLCom Deutschland GmbH" },
	{  6061, "Ventelo GmbH" },
	{  6062, "EconoPhone GmbH" },
	{  6063, "Komtel Gesellschaft fur Kommunikations -und Informationsdlenste mbH" },
	{  6064, "O2 (Germany) GmbH & Co." },
	{  6065, "O2 (Germany) GmbH & Co." },
	{  6066, "Metropol Access Deutschland GmbH" },
	{  6067, "Metropol Access Deutschland GmbH" },
	{  6068, "HanseNet Telekommunikation GmbH" },
	{  6069, "Primus Telecommunications Deutschland GmbH" },
	{  6070, "ETS Verwaltung fur Sprach -und Datennetze GmbH" },
	{  6071, "Communikationsnetze Sud-West GmbH & Co. KG" },
	{  6072, "Ventelo GmbH" },
	{  6073, "Long Distance International Ltd." },
	{  6074, "Interoute Telecom Deutschland GmbH" },
	{  6075, "netLAUNCH Communication Services & Consulting GmbH" },
	{  6076, "Talkline GmbH" },
	{  6077, "Storm Telecommunications GmbH" },
	{  6078, "Net Communications Ventures Ltd." },
	{  6079, "Ventelo GmbH" },
	{  6080, "BT Ignite GmbH & Co." },
	{  6081, "Star Telecommunications Deutschland GmbH" },
	{  6082, "Carrier1 AG" },
	{  6083, "Accom GmbH" },
	{  6084, "Telia Telekommunikation GmbH" },
	{  6085, "Global Communications GmbH" },
	{  6086, "Softel Communications GmbH" },
	{  6087, "T-Systems International GmbH" },
	{  6088, "Worldcom Telecommunications Services GmbH" },
	{  6089, "Kinnevik Telecommunications International S.A." },
	{  6090, "Kinnevik Telecommunications International S.A." },
	{  6091, "Teleglobe GmbH & Co" },
	{  6092, "Worldcom GmbH" },
	{  6093, "KDD Telecomet Deutschland GmbH" },
	{  6094, "Viaphone GmbH" },
	{  6095, "TelePassport Service GmbH" },
	{  6096, "Global Network Telephone GmbH" },
	{  6097, "WORLDxCHANGE GmbH" },
	{  6098, "VSE Net GmbH" },
	{  6099, "InterXion Telecom BV" },
	{  6100, "Carrier1 AG" },
	{  6101, "EconoPhone GmbH" },
	{  6102, "EconoPhone GmbH" },
	{  6103, "TelePassport Service GmbH" },
	{  6104, "TelePassport Service GmbH" },
	{  6105, "KPN Telecom BV" },
	{  6106, "EconoPhone GmbH" },
	{  6107, "Arcor AG & Co." },
	{  6108, "Arcor AG & Co." },
	{  6109, "Star Telecommunications Deutschland GmbH" },
	{  6110, "Telia Telekommunikation GmbH" },
	{  6111, "Ventelo GmbH" },
	{  6112, "01039 Call by Call GmbH" },
	{  6113, "Star Telecommunications Deutschland GmbH" },
	{  6114, "Ventelo GmbH" },
	{  6115, "Ventelo GmbH" },
	{  6116, "Ventelo GmbH" },
	{  6117, "Star Telecommunications Deutschland GmbH" },
	{  6118, "Star Telecommunications Deutschland GmbH" },
	{  6119, "O2 (Germany) GmbH & Co." },
	{  6120, "Quinsy B.V." },
	{  6121, "Vigra Telecommunications V.O.F." },
	{  6122, "ion-ip B.V." },
	{  6123, "Orange Nederland N.V." },
	{  6124, "Orange Nederland N.V." },
	{  6125, "Telfort B.V." },
	{  6126, "Teknodelta Telekomunikasyon Hizmetleri Ltd" },
	{  6127, "Carrier to Carrier Telecom N.V." },
	{  6128, "Global Networks Switzerland AG" },
	{  6129, "Equant Finland Oy" },
	{  6130, "Globetel Oy" },
	{  6131, "AinaCom Oy" },
	{  6132, "Supertel Oy" },
	{  6133, "Teldamatic Oy" },
	{  6134, "Oy Cubio Communications Ltd." },
	{  6135, "TDC Song Oy" },
	{  6136, "Oy Cubio Communications Ltd." },
	{  6137, "Setera Oy" },
	{  6138, "Saunalahti Group Oyj" },
	{  6139, "DNA Verkot Oy" },
	{  6141, "DNA Verkot Oy" },
	{  6142, "Tele 5 Worldwide Oy" },
	{  6143, "DNA Verkot Oy" },
	{  6176, "Tata Communications (Canada) ULC" },
	{  6177, "Tata Communications (Canada) ULC" },
	{  6178, "Tata Communications (Canada) ULC" },
	{  6179, "Tata Communications (Canada) ULC" },
	{  6180, "Tata Communications (Canada) ULC" },
	{  6181, "Tata Communications (Canada) ULC" },
	{  6182, "Tata Communications (Canada) ULC" },
	{  6183, "Tata Communications (Canada) ULC" },
	{  6184, "Tata Communications (Canada) ULC" },
	{  6185, "Tata Communications (Canada) ULC" },
	{  6186, "Tata Communications (Canada) ULC" },
	{  6187, "Tata Communications (Canada) ULC" },
	{  6188, "Tata Communications (Canada) ULC" },
	{  6189, "Tata Communications (Canada) ULC" },
	{  6190, "Tata Communications (Canada) ULC" },
	{  6191, "Tata Communications (Canada) ULC" },
	{  6192, "Tata Communications (Canada) ULC" },
	{  6193, "Tata Communications (Canada) ULC" },
	{  6194, "Tata Communications (Canada) ULC" },
	{  6195, "Tata Communications (Canada) ULC" },
	{  6196, "Tata Communications (Canada) ULC" },
	{  6197, "Tata Communications (Canada) ULC" },
	{  6198, "Tata Communications (Canada) ULC" },
	{  6199, "Tata Communications (Canada) ULC" },
	{  6200, "Bell Canada" },
	{  6201, "Bell Canada" },
	{  6202, "Bell Canada" },
	{  6203, "Bell Canada" },
	{  6204, "Bell Canada" },
	{  6205, "Bell Canada" },
	{  6206, "BC Tel" },
	{  6207, "Telus Communications Inc." },
	{  6208, "Alphanet Telecom Inc." },
	{  6209, "Fonorola" },
	{  6210, "North American Gateway Inc." },
	{  6211, "Telus DMS" },
	{  6212, "Telus DMS" },
	{  6213, "Global One Communications" },
	{  6214, "AIC Asia International Service Corp." },
	{  6215, "Hongkong Telecom Pacific Ltd." },
	{  6216, "Hongkong Telecom Pacific Ltd." },
	{  6217, "Telus DMS" },
	{  6218, "Cescom" },
	{  6219, "Cescom" },
	{  6220, "Cescom" },
	{  6221, "Cescom" },
	{  6222, "Cescom" },
	{  6224, "Telus Communications Inc., London UK" },
	{  6225, "Globalstar Canada Satellite Co." },
	{  6226, "Tata Communications (Canada) ULC" },
	{  6227, "Tata Communications (Canada) ULC" },
	{  6228, "Tata Communications (Canada) ULC" },
	{  6229, "Tata Communications (Canada) ULC" },
	{  6230, "Tata Communications (Canada) ULC" },
	{  6231, "Tata Communications (Canada) ULC" },
	{  6232, "Tata Communications (Canada) ULC" },
	{  6233, "Tata Communications (Canada) ULC" },
	{  6234, "Tata Communications (Canada) ULC" },
	{  6235, "Tata Communications (Canada) ULC" },
	{  6236, "Tata Communications (Canada) ULC" },
	{  6237, "Tata Communications (Canada) ULC" },
	{  6238, "Tata Communications (Canada) ULC" },
	{  6239, "Tata Communications (Canada) ULC" },
	{  6240, "Tata Communications (Canada) ULC" },
	{  6241, "Tata Communications (Canada) ULC" },
	{  6242, "Rogers Cable Communications Incorporated" },
	{  6243, "Phonetime International Inc." },
	{  6244, "Telecode Communications Inc." },
	{  6272, "France Telecom" },
	{  6288, "Tele Greenland" },
	{  6289, "Tele Greenland" },
	{  6290, "Tele Greenland" },
	{  6304, "AT&T" },
	{  6305, "AT&T" },
	{  6306, "AT&T" },
	{  6307, "AT&T" },
	{  6308, "AT&T" },
	{  6309, "AT&T" },
	{  6310, "AT&T" },
	{  6311, "AT&T" },
	{  6312, "BT North America" },
	{  6313, "WorldCom, Inc" },
	{  6314, "WorldCom, Inc" },
	{  6315, "WorldCom, Inc" },
	{  6316, "WorldCom, Inc" },
	{  6317, "WorldCom, Inc" },
	{  6318, "WorldCom, Inc" },
	{  6319, "WorldCom, Inc" },
	{  6320, "WorldCom, Inc" },
	{  6321, "WorldCom, Inc" },
	{  6322, "WorldCom, Inc" },
	{  6323, "WorldCom, Inc" },
	{  6324, "WorldCom, Inc" },
	{  6325, "WorldCom, Inc" },
	{  6326, "WorldCom, Inc" },
	{  6327, "WorldCom, Inc" },
	{  6328, "AT&T" },
	{  6329, "AT&T" },
	{  6330, "AT&T" },
	{  6331, "AT&T" },
	{  6332, "US Sprint" },
	{  6333, "US Sprint" },
	{  6334, "US Sprint" },
	{  6335, "BT North America" },
	{  6336, "BT North America" },
	{  6337, "BT North America" },
	{  6338, "WorldCom, Inc" },
	{  6339, "WorldCom, Inc" },
	{  6340, "US Sprint" },
	{  6341, "US Sprint" },
	{  6342, "US Sprint" },
	{  6343, "AT&T" },
	{  6344, "AT&T" },
	{  6345, "AT&T" },
	{  6346, "AT&T" },
	{  6347, "AT&T" },
	{  6348, "AT&T" },
	{  6349, "Verizon Hawaii International Inc" },
	{  6350, "Arbinet-thexchange, Inc" },
	{  6351, "Arbinet-thexchange, Inc" },
	{  6352, "Cable & Wireless, Inc (CWI)" },
	{  6353, "Asia Communications International, Inc" },
	{  6354, "WorldCom, Inc" },
	{  6355, "WorldCom, Inc" },
	{  6356, "WorldCom, Inc" },
	{  6357, "WorldCom, Inc" },
	{  6358, "TLDI" },
	{  6359, "ITC, Inc" },
	{  6360, "ITC, Inc" },
	{  6361, "Sirius Telecommunications, Inc" },
	{  6362, "WDT World Discount Telecommunications Co" },
	{  6363, "China Telecom (Americas) Corporation" },
	{  6364, "Star Telecommunications Inc" },
	{  6365, "Star Telecommunications Inc" },
	{  6366, "Latin America Telecom, Inc" },
	{  6367, "Teleglobe America, Inc" },
	{  6368, "IWL Communications Inc" },
	{  6369, "IWL Communications Inc" },
	{  6370, "BellSouth International" },
	{  6371, "BellSouth International" },
	{  6372, "BellSouth International" },
	{  6373, "UniPlex Telecom Technologies, Inc" },
	{  6374, "USTelenet, LLC" },
	{  6375, "TresCom International, Inc" },
	{  6376, "TresCom International, Inc" },
	{  6377, "TresCom International, Inc" },
	{  6378, "TresCom International, Inc" },
	{  6379, "TresCom International, Inc" },
	{  6380, "TresCom International, Inc" },
	{  6381, "Maycan Horizons Inc" },
	{  6382, "American Telesource International Inc" },
	{  6383, "Verisign Inc" },
	{  6384, "NP Telephony" },
	{  6385, "Telecommunications Services, Inc" },
	{  6386, "Telecommunications Services, Inc" },
	{  6387, "Telecommunications Services, Inc" },
	{  6388, "Telecommunications Services, Inc" },
	{  6389, "Telecommunications Services, Inc" },
	{  6390, "Telecommunications Services, Inc" },
	{  6391, "CTC Communications Corp" },
	{  6392, "Telecommunications Services, Inc" },
	{  6393, "PLD Telekom, Inc" },
	{  6394, "New Global Telecom, Inc" },
	{  6395, "Ameritech Global Gateway Services (AGGS)" },
	{  6396, "New Global Telecom, Inc" },
	{  6397, "Startec Global Communications Corporation" },
	{  6398, "Verizon Hawaii International Inc" },
	{  6399, "Verizon Hawaii International Inc" },
	{  6400, "Primus Telecommunications, Inc" },
	{  6401, "Primus Telecommunications, Inc" },
	{  6402, "BT North America" },
	{  6403, "BT North America" },
	{  6404, "WorldCom, Inc" },
	{  6405, "WorldCom, Inc" },
	{  6406, "U.S. Leo Services, Inc" },
	{  6407, "U.S. Leo Services, Inc" },
	{  6408, "U.S. Leo Services, Inc" },
	{  6409, "Bellsouth Carrier Professional Services, Inc (BCPS)" },
	{  6410, "Fusion Telecommunications International, Inc" },
	{  6411, "China Telecom (Americas) Corporation" },
	{  6412, "Mundetel Communications. Inc" },
	{  6413, "SunGlobe Telecom, Inc" },
	{  6414, "Comsat Mobile Communications" },
	{  6415, "Comsat Mobile Communications" },
	{  6416, "Convergia Inc" },
	{  6417, "Globespan Telecommunication LLC" },
	{  6418, "Communication Telesystems International" },
	{  6419, "Communication Telesystems International" },
	{  6420, "Communication Telesystems International" },
	{  6421, "Communication Telesystems International" },
	{  6422, "Switch Tel, Inc" },
	{  6423, "IDT Corporation" },
	{  6424, "IDT Corporation" },
	{  6425, "Intra Global Communications, Inc" },
	{  6426, "Sprint" },
	{  6427, "Sprint" },
	{  6428, "TotalTel" },
	{  6429, "WorldPoint Communications, Inc" },
	{  6430, "WorldPoint Communications, Inc" },
	{  6431, "Telecommunications Services, Inc" },
	{  6432, "Telecommunications Services, Inc" },
	{  6433, "WorldCom, Inc" },
	{  6434, "WorldCom, Inc" },
	{  6435, "WorldCom, Inc" },
	{  6436, "Communication Technology, Inc" },
	{  6437, "Communication Technology, Inc" },
	{  6438, "Communication Technology, Inc" },
	{  6439, "Team Telecom Holdings, Inc" },
	{  6440, "AT&T" },
	{  6441, "AT&T" },
	{  6442, "AT&T" },
	{  6443, "AT&T" },
	{  6444, "AT&T" },
	{  6445, "AT&T" },
	{  6446, "AT&T" },
	{  6447, "AT&T" },
	{  6448, "Phone1 Inc" },
	{  6449, "Globaltron Communications Corporation" },
	{  6450, "Go2Tel.com, Inc" },
	{  6451, "Graphnet Inc" },
	{  6452, "Graphnet Inc" },
	{  6453, "Go2Tel.com, Inc" },
	{  6454, "Alpha Telecom, Inc" },
	{  6455, "MD Telecom, Inc" },
	{  6456, "Worldwide Telecom Services, LLC" },
	{  6457, "Fonorola Corp." },
	{  6458, "Fonorola Corp." },
	{  6459, "Telemedia International USA Inc" },
	{  6460, "Go2Tel.com, Inc" },
	{  6461, "Go2Tel.com, Inc" },
	{  6462, "Americatel Corporation" },
	{  6463, "Telia North America Inc" },
	{  6464, "Verizon Select Services Inc" },
	{  6465, "Global Telecommunications Services, Inc (d/b/a Global Voicecom Inc.)" },
	{  6466, "Star Telecommunications Inc" },
	{  6467, "Startec Global Communications Corporation" },
	{  6468, "IDT Corporation" },
	{  6469, "E-Z Connections, Inc" },
	{  6470, "PT-1 Communications, Inc" },
	{  6471, "ACC TeleCom" },
	{  6472, "IXC Communications, Inc" },
	{  6473, "Telegroup Inc" },
	{  6474, "Telegroup Inc" },
	{  6475, "GlobalStar International, Inc" },
	{  6476, "Telemedia International USA Inc" },
	{  6477, "KDD America, Inc" },
	{  6478, "Global Quest Communications Ltd" },
	{  6479, "Network Plus Inc" },
	{  6480, "Network Plus Inc" },
	{  6481, "Network Plus Inc" },
	{  6482, "Bellsouth Cellular Corp." },
	{  6483, "Bellsouth Cellular Corp." },
	{  6484, "Five Star Telecom" },
	{  6485, "Athena International LLC" },
	{  6486, "Athena International LLC" },
	{  6487, "Athena International LLC" },
	{  6488, "Switch Tel, Inc" },
	{  6489, "Meorat Natan LLC d/b/a Universal 400" },
	{  6490, "Global Transmedia Communications Corporation" },
	{  6491, "General Telecom, Inc" },
	{  6492, "General Telecom, Inc" },
	{  6493, "General Telecom, Inc" },
	{  6494, "Elephant Talk Inc" },
	{  6495, "New Millennium Communications Corporation" },
	{  6496, "New Millennium Communications Corporation" },
	{  6497, "New Millennium Communications Corporation" },
	{  6498, "RSLCom USA, Inc" },
	{  6499, "Justice Technology Corporation" },
	{  6500, "VarTec Telecom, Inc" },
	{  6501, "Verizon Select Services Inc" },
	{  6502, "North Atlantic Gateway, Inc" },
	{  6503, "Swisscom North America, Inc" },
	{  6504, "Swisscom North America, Inc" },
	{  6505, "WorldCom, Inc" },
	{  6506, "WorldCom, Inc" },
	{  6507, "WorldCom, Inc" },
	{  6508, "WorldCom, Inc" },
	{  6509, "IXC Communications, Inc" },
	{  6510, "Qwest Communications International Corp" },
	{  6511, "Qwest Communications International Corp" },
	{  6512, "Qwest Communications International Corp" },
	{  6513, "Qwest Communications International Corp" },
	{  6514, "Qwest Communications International Corp" },
	{  6515, "Qwest Communications International Corp" },
	{  6516, "Qwest Communications International Corp" },
	{  6517, "Qwest Communications International Corp" },
	{  6518, "Verizon Global Solutions, Inc" },
	{  6519, "Verizon Global Solutions, Inc" },
	{  6520, "Asia Access Telecom, Inc" },
	{  6521, "Dacom America, Inc" },
	{  6522, "Telenor Global Services A.S." },
	{  6523, "Japan Telecom Co., Ltd" },
	{  6524, "International Discount Telecommunication (IDT)" },
	{  6525, "Allied Communication Holdings, LLC" },
	{  6526, "Allied Communication Holdings, LLC" },
	{  6527, "Sita" },
	{  6528, "Sita" },
	{  6529, "Sita" },
	{  6530, "PanAmSat Corporation" },
	{  6531, "BellSouth Long Distance, Inc" },
	{  6532, "Telecom New Zealand USA Ltd" },
	{  6533, "Carrier One Inc" },
	{  6534, "ABS-CBN Telecom, North America Inc" },
	{  6535, "PCCW Pacific Ltd" },
	{  6536, "Compass Global, Inc" },
	{  6537, "PLDT (US), Ltd" },
	{  6538, "PLDT (US), Ltd" },
	{  6539, "PLDT (US), Ltd" },
	{  6540, "PLDT (US), Ltd" },
	{  6541, "IDT Telecom, Inc" },
	{  6542, "Diamond Link, Inc" },
	{  6543, "Teledirect Telecommunications Group, LLC" },
	{  6544, "Interoute Telecommunications, Inc" },
	{  6545, "KDD America, Inc" },
	{  6546, "Telco 214, Inc" },
	{  6547, "AT&T" },
	{  6548, "First Point Telecom" },
	{  6549, "Long Distance International, Inc" },
	{  6550, "Long Distance International, Inc" },
	{  6551, "Long Distance International, Inc" },
	{  6552, "Arktel LLC" },
	{  6553, "Sirius Telecommunications, Inc" },
	{  6554, "Singapore Telecom USA Inc" },
	{  6555, "VarTec Telecom, Inc" },
	{  6556, "WorldPort Communications, Inc" },
	{  6557, "WorldPort Communications, Inc" },
	{  6558, "IXC Communications, Inc" },
	{  6559, "Startec Global Communications Corporation" },
	{  6560, "Startec Global Communications Corporation" },
	{  6561, "Telecom Argentina USA, Inc" },
	{  6562, "TECNet, Inc" },
	{  6563, "TECNet, Inc" },
	{  6564, "ASEAN Telecom, LLC" },
	{  6565, "ASEAN Telecom, LLC" },
	{  6566, "Iusatel USA, Inc" },
	{  6567, "T-Systems North America, Inc" },
	{  6568, "T-Systems North America, Inc" },
	{  6569, "T-Systems North America, Inc" },
	{  6570, "MCI International, Inc" },
	{  6571, "Dial-Around Telecom, Inc" },
	{  6572, "NuLink, Inc" },
	{  6573, "Impsat USA, Inc" },
	{  6574, "Arbinet-thexchange, Inc" },
	{  6575, "Stratos Mobile Networks" },
	{  6576, "AirTouch Satellite Services, Inc" },
	{  6577, "AirTouch Satellite Services, Inc" },
	{  6578, "AirTouch Satellite Services, Inc" },
	{  6579, "AirTouch Satellite Services, Inc" },
	{  6580, "AirTouch Satellite Services, Inc" },
	{  6581, "AirTouch Satellite Services, Inc" },
	{  6582, "Iridium LLC" },
	{  6583, "Iridium LLC" },
	{  6584, "Iridium LLC" },
	{  6585, "VGM International" },
	{  6586, "Transaction Network Services, Inc" },
	{  6587, "VarTec Telecom, Inc" },
	{  6588, "International Telecom, Ltd." },
	{  6589, "WorldPort Communications, Inc" },
	{  6590, "Antel Telecom, Inc" },
	{  6591, "Savontel Communications" },
	{  6592, "WorldCom, Inc" },
	{  6593, "Innosys Communications, Inc." },
	{  6594, "Galaxy Telesyst Inc" },
	{  6595, "Simple Communications Technologies, Inc" },
	{  6596, "AT&T" },
	{  6597, "ATC Teleports, Inc" },
	{  6598, "ATC Teleports, Inc" },
	{  6599, "Tele Danmark USA, Inc" },
	{  6600, "MediaTel Corporation" },
	{  6601, "International Satellite Telecommunications Inc (INSATEL)" },
	{  6602, "Azultel Inc" },
	{  6603, "AT&T" },
	{  6604, "AT&T" },
	{  6605, "AT&T" },
	{  6606, "AT&T" },
	{  6607, "Digicel USA, Inc" },
	{  6608, "WorldHub Inc" },
	{  6609, "WorldHub Inc" },
	{  6610, "Justice Technology Corporation" },
	{  6611, "I-21 USA Inc" },
	{  6612, "Arbinet, Inc" },
	{  6613, "AT&T" },
	{  6614, "AT&T" },
	{  6615, "Telecom Argentina USA, Inc" },
	{  6616, "Data Access America Inc" },
	{  6617, "WorldCom, Inc" },
	{  6618, "WorldCom, Inc" },
	{  6619, "ITC, Inc" },
	{  6620, "The Voice Box Corp." },
	{  6621, "RSLCom USA, Inc" },
	{  6622, "RSLCom USA, Inc" },
	{  6623, "RSLCom USA, Inc" },
	{  6688, "Marcatel Com, S.A. de C.V." },
	{  6689, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6690, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6691, "Marcatel Com, S.A. de C.V." },
	{  6692, "Marcatel Com, S.A. de C.V." },
	{  6693, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6694, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6695, "Maxcom Telecomunicaciones, S.A.B. de C.V." },
	{  6696, "Maxcom Telecomunicaciones, S.A.B. de C.V." },
	{  6697, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6698, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6699, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6700, "Telefonos del Noroeste, S.A. de C.V." },
	{  6701, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6702, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6703, "Operbes, S.A. de C.V." },
	{  6704, "Telecomunicaciones de Mexico" },
	{  6705, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6706, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6707, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6708, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6709, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6710, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6711, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6712, "Telefonos del Noroeste, S.A. de C.V." },
	{  6713, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6714, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6715, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6716, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6717, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6718, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6719, "Telefonos de Mexico, S.A.B. de C.V." },
	{  6720, "Avantel, S. de R.L. de C.V." },
	{  6721, "Avantel, S. de R.L. de C.V." },
	{  6722, "Avantel, S. de R.L. de C.V." },
	{  6723, "Avantel, S. de R.L. de C.V." },
	{  6724, "Avantel, S. de R.L. de C.V." },
	{  6725, "Avantel, S. de R.L. de C.V." },
	{  6726, "Avantel, S. de R.L. de C.V." },
	{  6727, "Avantel, S. de R.L. de C.V." },
	{  6728, "Iusatel, S.A. de C.V." },
	{  6729, "Iusatel, S.A. de C.V." },
	{  6730, "Iusatel, S.A. de C.V." },
	{  6731, "Iusatel, S.A. de C.V." },
	{  6732, "Iusatel, S.A. de C.V." },
	{  6733, "Iusatel, S.A. de C.V." },
	{  6734, "Iusatel, S.A. de C.V." },
	{  6735, "Iusatel, S.A. de C.V." },
	{  6736, "Alestra, S. de R.L. de C.V." },
	{  6737, "Alestra, S. de R.L. de C.V." },
	{  6738, "Alestra, S. de R.L. de C.V." },
	{  6739, "Alestra, S. de R.L. de C.V." },
	{  6740, "Alestra, S. de R.L. de C.V." },
	{  6741, "Alestra, S. de R.L. de C.V." },
	{  6742, "Alestra, S. de R.L. de C.V." },
	{  6743, "Alestra, S. de R.L. de C.V." },
	{  6744, "Operadora Protel, S.A. de C.V." },
	{  6745, "Operadora Protel, S.A. de C.V." },
	{  6746, "Operadora Protel, S.A. de C.V." },
	{  6747, "Operadora Protel, S.A. de C.V." },
	{  6748, "Operadora Protel, S.A. de C.V." },
	{  6749, "Operadora Protel, S.A. de C.V." },
	{  6750, "Operadora Protel, S.A. de C.V." },
	{  6751, "Operadora Protel, S.A. de C.V." },
	{  6752, "Cable and Wireless Jamaica Ltd" },
	{  6753, "Cable and Wireless Jamaica Ltd" },
	{  6754, "Cable and Wireless Jamaica Ltd" },
	{  6755, "Cable and Wireless Jamaica Ltd" },
	{  6756, "Cable and Wireless Jamaica Ltd" },
	{  6757, "Cable and Wireless Jamaica Ltd" },
	{  6758, "Mossel Jamaica Ltd" },
	{  6759, "Mossel Jamaica Ltd" },
	{  6760, "Cable and Wireless Jamaica Ltd" },
	{  6761, "Cable and Wireless Jamaica Ltd" },
	{  6762, "Cable and Wireless Jamaica Ltd" },
	{  6763, "Cable and Wireless Jamaica Ltd" },
	{  6764, "Cable and Wireless Jamaica Ltd" },
	{  6765, "Cable and Wireless Jamaica Ltd" },
	{  6766, "Cable and Wireless Jamaica Ltd" },
	{  6770, "Cable and Wireless Jamaica Ltd" },
	{  6771, "Cable and Wireless Jamaica Ltd" },
	{  6772, "Cable and Wireless Jamaica Ltd" },
	{  6773, "Cable and Wireless Jamaica Ltd" },
	{  6774, "Cable and Wireless Jamaica Ltd" },
	{  6775, "Cable and Wireless Jamaica Ltd" },
	{  6776, "Columbus Communications Ltd" },
	{  6778, "Digicel (Jamaica) Ltd" },
	{  6779, "Digicel (Jamaica) Ltd" },
	{  6816, "Cable and Wireless (Barbados) Ltd" },
	{  6817, "Cable and Wireless (Barbados) Ltd" },
	{  6818, "Cable and Wireless (Barbados) Ltd" },
	{  6819, "Cable and Wireless (Barbados) Ltd" },
	{  6820, "Cable and Wireless (Barbados) Ltd" },
	{  6821, "Cable and Wireless (Barbados) Ltd" },
	{  6822, "Cable and Wireless (Barbados) Ltd" },
	{  6823, "Cable and Wireless (Barbados) Ltd" },
	{  6824, "Cable and Wireless (Barbados) Ltd" },
	{  6825, "Cable and Wireless (Barbados) Ltd" },
	{  6826, "Digicel (Barbados)" },
	{  6827, "Cable and Wireless (Barbados) Ltd" },
	{  6828, "TeleBarbados Inc" },
	{  6829, "Antilles Crossing Ltd" },
	{  6830, "Blus Communications Ltd" },
	{  6831, "Sunbeach Inc." },
	{  6832, "Sunbeach Inc." },
	{  6833, "Sunbeach Inc." },
	{  6834, "Sunbeach Inc." },
	{  6835, "Access One" },
	{  6836, "Access One" },
	{  6848, "Cable & Wireless" },
	{  6849, "Digicel" },
	{  6850, "Cable & Wireless" },
	{  6851, "Cable & Wireless" },
	{  6852, "APUA/PCS" },
	{  6853, "APUA/PCS" },
	{  6854, "Cable & Wireless" },
	{  6855, "APUA/PCS" },
	{  6880, "Cable & Wireless" },
	{  6881, "Cable & Wireless" },
	{  6882, "Cable & Wireless" },
	{  6883, "Cable & Wireless" },
	{  6884, "Cable & Wireless" },
	{  6885, "Digicel (Cayman Isl.) Ltd" },
	{  6886, "Wireless Ventures (Cayman Islands) Ltd." },
	{  6889, "Westel Ltd" },
	{  6890, "E-Technologies Cayman Islands Ltd" },
	{  6912, "Caribbean Cellular Tel. Ltd" },
	{  6913, "Cable & Wireless (BVI) Ltd" },
	{  6914, "Caribbean Cellular Tel. Ltd" },
	{  6916, "Cable & Wireless (BVI) Ltd" },
	{  6917, "Cable & Wireless (BVI) Ltd" },
	{  6918, "Caribbean Cellular Tel. Ltd" },
	{  6919, "Cable & Wireless (BVI) Ltd" },
	{  6920, "Caribbean Cellular Tel. Ltd" },
	{  6921, "Digicel (BVI) Ltd" },
	{  6976, "Cable & Wireless Grenada" },
	{  6978, "Global Network Providers Grenada" },
	{  6979, "TransWorld Telecommunications Grenada" },
	{  7040, "Cable & Wireless St. Kitts-Nevis" },
	{  7041, "Cariglobe Telecommunications" },
	{  7043, "St. Kitts Cable Communications" },
	{  7073, "Cable & Wireless St. Lucia" },
	{  7074, "Cable & Wireless St. Lucia" },
	{  7075, "Digicel St. Lucia" },
	{  7076, "AT&T Wireless Services St. Lucia" },
	{  7104, "Cable & Wireless St. Vincent" },
	{  7105, "Cable & Wireless St. Vincent" },
	{  7106, "Cable & Wireless St. Vincent" },
	{  7136, "Polycom" },
	{  7137, "Antelecom" },
	{  7138, "Antelecom" },
	{  7139, "Antillean Network Management" },
	{  7140, "Antelecom" },
	{  7141, "Telbo" },
	{  7142, "GSN International Telecom" },
	{  7143, "Smitcoms" },
	{  7144, "Antillean Network Management" },
	{  7145, "Setel" },
	{  7146, "Third Wave Int." },
	{  7147, "Third Wave Int." },
	{  7148, "Polycom" },
	{  7149, "Radcomm" },
	{  7168, "Bahamas Telecommunications Company Ltd" },
	{  7169, "Bahamas Telecommunications Company Ltd" },
	{  7170, "Bahamas Telecommunications Company Ltd" },
	{  7200, "Cable & Wireless Dominica" },
	{  7201, "Cable & Wireless Dominica" },
	{  7203, "Marpin Telecoms & Broadcasting Co. Ltd." },
	{  7233, "ETECSA" },
	{  7234, "ETECSA" },
	{  7235, "ETECSA" },
	{  7236, "ETECSA" },
	{  7237, "ETECSA" },
	{  7238, "ETECSA" },
	{  7264, "Compania Dominicana de Telefonos, C. por A." },
	{  7265, "Compania Dominicana de Telefonos, C. por A." },
	{  7266, "Tricom S.A." },
	{  7267, "Tricom S.A." },
	{  7268, "Orange Dominicana, S.A." },
	{  7269, "Tricom S.A." },
	{  7270, "All America Cables & Radio Dominican Republic Inc." },
	{  7271, "All America Cables & Radio Dominican Republic Inc." },
	{  7297, "Communication Cellulaire d'Haiti S.A. (COMCEL)" },
	{  7328, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7329, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7330, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7331, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7332, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7333, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7334, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7335, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7336, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7337, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7338, "Telecommunication Services of Trinidad & Tobago Ltd. (TSTT)" },
	{  7339, "Digicel Trinidad and Tobago Ltd" },
	{  7340, "Digicel Trinidad and Tobago Ltd" },
	{  7341, "Digicel Trinidad and Tobago Ltd" },
	{  7342, "Digicel Trinidad and Tobago Ltd" },
	{  7343, "Digicel Trinidad and Tobago Ltd" },
	{  7360, "Cable & Wireless Ltd" },
	{  7361, "Cable & Wireless Ltd" },
	{  7362, "Cable & Wireless Ltd" },
	{  7363, "Cable & Wireless Ltd" },
	{  7364, "Digicel (TCI) Ltd" },
	{  7365, "Cable & Wireless Ltd" },
	{  7366, "Andrew's Communications Ltd" },
	{  7367, "IslandCom Communications Ltd" },
	{  7368, "IslandCom Communications Ltd" },
	{  7369, "IslandCom Communications Ltd" },
	{  7370, "IslandCom Communications Ltd" },
	{  7371, "IslandCom Communications Ltd" },
	{  7372, "IslandCom Communications Ltd" },
	{  7393, "Dauphin Telecom" },
	{  7394, "St. Martin et St. Barthelemy Tel Cell" },
	{  7395, "Dauphin Telecom" },
	{  7396, "Mediaserv" },
	{  7424, "Dauphin Telecom" },
	{  7425, "Outremer Telecom" },
	{  7456, "Setar N.V." },
	{  7458, "New Millennium Telecom Services N.V./Digicel Aruba" },
	{  7460, "DTH Television & Telecommunications N.V./MIO Aruba" },
	{  7488, "Cable and Wireless" },
	{  7489, "Cable and Wireless" },
	{  7490, "Cable and Wireless" },
	{  7491, "Cable and Wireless" },
	{  7492, "Cable and Wireless" },
	{  7493, "Cable and Wireless" },
	{  7494, "Cable and Wireless" },
	{  7495, "Cable and Wireless" },
	{  7520, "Miditel, S.A. de C.V." },
	{  7521, "Telefonos de Mexico, S.A.B. de C.V." },
	{  7522, "Telefonos de Mexico, S.A.B. de C.V." },
	{  7523, "Telefonos de Mexico, S.A.B. de C.V." },
	{  7524, "Telefonos de Mexico, S.A.B. de C.V." },
	{  7525, "Operbes, S.A. de C.V." },
	{  7526, "Operbes, S.A. de C.V." },
	{  7527, "Grupo de Telecomunicaciones Mexicanas, S.A. de C.V" },
	{  7528, "RSL Com Net de Mexico, S.A. de C.V." },
	{  7529, "RSL Com Net de Mexico, S.A. de C.V." },
	{  7530, "Telefonos de Mexico, S.A.B. de C.V." },
	{  7531, "Telefonos de Mexico, S.A.B. de C.V." },
	{  7532, "Telefonos de Mexico, S.A.B. de C.V." },
	{  7533, "Telefonos de Mexico, S.A.B. de C.V." },
	{  7534, "Telefonos de Mexico, S.A.B. de C.V." },
	{  7535, "Iridium de Mexico, S.A. de C.V." },
	{  7536, "Qualtel, S.A. de C.V." },
	{  7537, "Radiomovil DIPSA, S.A. de C.V." },
	{  7538, "Radiomovil DIPSA, S.A. de C.V." },
	{  7539, "Radiomovil DIPSA, S.A. de C.V." },
	{  7540, "Radiomovil DIPSA, S.A. de C.V." },
	{  7541, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7542, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7543, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7544, "AXTEL, S.A.B. de C.V." },
	{  7545, "AXTEL, S.A.B. de C.V." },
	{  7546, "AXTEL, S.A.B. de C.V." },
	{  7547, "AXTEL, S.A.B. de C.V." },
	{  7548, "AXTEL, S.A.B. de C.V." },
	{  7549, "Grupo de Telecomunicaciones Mexicanas, S.A. de C.V" },
	{  7550, "Inversiones Nextel de Mexico, S.A. de C.V." },
	{  7551, "Tlalnepantia Inversiones Nextel de S.A. de C.V." },
	{  7552, "B.Tel, S.A. de C.V." },
	{  7553, "B.Tel, S.A. de C.V." },
	{  7554, "B.Tel, S.A. de C.V." },
	{  7555, "Grupo de Telecomunicaciones Mexicanas, S.A. de C.V" },
	{  7556, "Grupo de Telecomunicaciones Mexicanas, S.A. de C.V" },
	{  7557, "Convergia de Mexico, S.A. de C.V." },
	{  7558, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7559, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7560, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7561, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7562, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7563, "Radiomovil DIPSA, S.A. de C.V." },
	{  7564, "Radiomovil DIPSA, S.A. de C.V." },
	{  7565, "Radiomovil DIPSA, S.A. de C.V." },
	{  7566, "Radiomovil DIPSA, S.A. de C.V." },
	{  7567, "Radiomovil DIPSA, S.A. de C.V." },
	{  7568, "Alestra, S. de R.L. de C.V." },
	{  7569, "Alestra, S. de R.L. de C.V." },
	{  7570, "Pegaso Comunicaciones y Sistemas, S.A. de C.V." },
	{  7571, "Radiomovil DIPSA, S.A. de C.V." },
	{  7572, "Radiomovil DIPSA, S.A. de C.V." },
	{  7573, "Radiomovil DIPSA, S.A. de C.V." },
	{  7576, "Faroese Telecom P/F" },
	{  7577, "Faroese Telecom P/F" },
	{  7581, "Kall P/F" },
	{  7582, "Kall P/F" },
	{  7583, "Kall P/F" },
	{  7584, "RSLCom USA, Inc" },
	{  7585, "AT&T" },
	{  7586, "AT&T" },
	{  7587, "Axistel International, Inc" },
	{  7588, "Telmex International Ventures USA, Inc (DBA Telmex USA)" },
	{  7589, "Telstra Inc" },
	{  7590, "InternationalTalk.com, Inc" },
	{  7591, "InternationalTalk.com, Inc" },
	{  7592, "Telscape International, Inc (DBA TSCP International, Inc.)" },
	{  7593, "Teleglobe America, Inc" },
	{  7594, "Teleglobe America, Inc" },
	{  7595, "Pacific Telekey Network, Inc" },
	{  7596, "Atlas Communications, Ltd" },
	{  7597, "Atlas Communications, Ltd" },
	{  7598, "Atlas Communications, Ltd" },
	{  7599, "Unified Worldwide Transport, LLC" },
	{  7600, "NextCarrier Telecom, Inc" },
	{  7601, "International Access, Inc (d/b/a Access international)" },
	{  7602, "AT&T" },
	{  7603, "AT&T" },
	{  7604, "WorldCom, Inc" },
	{  7605, "WorldCom, Inc" },
	{  7606, "Global Connect Partners L.L.C." },
	{  7607, "Telecom New Zealand USA Ltd" },
	{  7608, "Telecom New Zealand USA Ltd" },
	{  7609, "Far East Gateway, Inc" },
	{  7610, "Startec Global Communications Corporation" },
	{  7611, "Startec Global Communications Corporation" },
	{  7612, "Selex Communications, L.L.C." },
	{  7613, "Selex Communications, L.L.C." },
	{  7614, "SK Telink America, Inc" },
	{  7615, "iLine, LLC" },
	{  7616, "Tricom USA, Inc" },
	{  7617, "WorldCom, Inc" },
	{  7618, "Orchard Telecom/dba UTS" },
	{  7619, "Global Communication Services, Inc" },
	{  7620, "GTS (UK) Ltd" },
	{  7621, "The Global TeleExchange Inc" },
	{  7622, "A&N Telecom" },
	{  7623, "TMEX USA Inc" },
	{  7624, "InternationalTalk.com, Inc" },
	{  7625, "InternationalTalk.com, Inc" },
	{  7626, "WorldCom, Inc" },
	{  7627, "KPN International Network Services Inc" },
	{  7628, "IDS Telcom" },
	{  7629, "BridgePoint International (USA) Inc" },
	{  7630, "Arbinet Communication, Inc" },
	{  7631, "WorldCom, Inc" },
	{  7632, "New Global Telecom, Inc" },
	{  7633, "World-Link, Inc" },
	{  7634, "Selex Communications, L.L.C." },
	{  7635, "World Discount Telecommunications, Inc (WDT)" },
	{  7636, "PhoneXchange, Inc" },
	{  7637, "iBasis, Inc" },
	{  7638, "iBasis, Inc" },
	{  7639, "Vivavoip, Inc" },
	{  7640, "Global One Communications" },
	{  7641, "Global Connect Partners L.L.C." },
	{  7642, "ITXC Data Transport Services, LLC" },
	{  7643, "Tricom USA, Inc" },
	{  7644, "Integration Services International (ISI)" },
	{  7645, "Sakon, LLC" },
	{  7646, "Wholesale Telecom Corporation" },
	{  7647, "LC Communications" },
	{  7648, "ITC, Inc" },
	{  7649, "IDT Corporation" },
	{  7650, "Telstra Inc" },
	{  7651, "SuperTel Network, Inc" },
	{  7652, "Worldwide Communications Network LLC" },
	{  7653, "Network Communication International Corp" },
	{  7654, "Total Telecom International Inc" },
	{  7655, "BridgePoint International (USA) Inc" },
	{  7656, "Fusion Telecommunications International, Inc" },
	{  7657, "IDT Corporation" },
	{  7658, "Net Telephone Marketing, Inc" },
	{  7659, "Net Telephone Marketing, Inc" },
	{  7660, "AT&T" },
	{  7661, "AT&T" },
	{  7662, "AT&T" },
	{  7663, "Ameritech Global Gateway Services (AGGS)" },
	{  7664, "Vertex Group, Inc" },
	{  7665, "Vertex Group, Inc" },
	{  7666, "OneSuite Corporation" },
	{  7667, "OneSuite Corporation" },
	{  7668, "Telecom New Zealand USA Ltd" },
	{  7669, "InterSviaz, Inc" },
	{  7670, "New Global Telecom, Inc" },
	{  7671, "Storm Telecommunications, Inc" },
	{  7672, "American Carrier Services, Inc" },
	{  7673, "T-Systems North America, Inc" },
	{  7674, "Global Crossing Telecommunications, Inc" },
	{  7675, "BellSouth International" },
	{  7676, "BellSouth International" },
	{  7677, "Barr Tell USA, Inc" },
	{  7678, "CM TEL (USA) LLC" },
	{  7679, "Passport Telecom" },
	{  7680, "WorldCom, Inc" },
	{  7681, "WorldCom, Inc" },
	{  7682, "Level 3 Communications, LLC" },
	{  7683, "LD Telecommunications, Inc" },
	{  7684, "IP Deliver" },
	{  7685, "China Telecom (USA) Corporation" },
	{  7686, "Community Global Network LLC" },
	{  7687, "Reliance Communications, Inc" },
	{  7688, "Reliance Communications, Inc" },
	{  7689, "Sirius Telecommunications, Inc" },
	{  7690, "Orbitel S.A. E.S.P." },
	{  7691, "Orbitel S.A. E.S.P." },
	{  7692, "CM TEL (USA) LLC" },
	{  7693, "Novolink Communications Inc" },
	{  7694, "Verisign Inc" },
	{  7695, "Verisign Inc" },
	{  7696, "Bright Fibre Network Corp" },
	{  7697, "New World Telecom International Inc" },
	{  7698, "China Netcom (USA) Operations Ltd" },
	{  7699, "TSI Telecommunication Services, Inc" },
	{  7700, "Latin Node, Inc" },
	{  7701, "Global Crossing Telecommunications, Inc" },
	{  7702, "Global Crossing Telecommunications, Inc" },
	{  7703, "ComoreTel Holdings Ltd" },
	{  7704, "China Unicom USA Corporation" },
	{  7705, "Telco Group, Inc" },
	{  7706, "NetSat Express Inc" },
	{  7707, "Cinergy Telecommunications, Inc" },
	{  7708, "Ontus Telecommunications Corp" },
	{  7709, "CTC Communications Corp" },
	{  7710, "Telecom Argentina USA, Inc" },
	{  7711, "Telmex USA, LLC" },
	{  7712, "QuaesTel, Inc" },
	{  7713, "Discovery Telecommunications LLC" },
	{  7714, "Reliance Communications, Inc" },
	{  7715, "Reliance Communications, Inc" },
	{  7716, "Telekom Malaysia (USA) Inc" },
	{  7717, "Corisat America Inc" },
	{  7718, "StarVox Communications, Inc" },
	{  7719, "Equant Inc" },
	{  7720, "Reliance Communications, Inc" },
	{  7721, "Reliance Communications, Inc" },
	{  7722, "Teleglobe America, Inc" },
	{  7723, "Teleglobe America, Inc" },
	{  7724, "Jaina Systems Network, Inc" },
	{  7725, "Bridgeport Networks Inc" },
	{  7726, "Carrier PB Telco Inc" },
	{  7727, "IPIP Corp." },
	{  7728, "Telmex USA, LLC" },
	{  7729, "Datek Systems, Inc" },
	{  7730, "3U Telecom Inc" },
	{  7731, "Arbinet-thexchange, Inc" },
	{  7732, "Verisign Inc" },
	{  7733, "Los Angeles InternetExchange" },
	{  7734, "Aicent, Inc" },
	{  7735, "Aicent, Inc" },
	{  7736, "Worldstar Telecom Inc" },
	{  7737, "Touch-Tel USA, L.P." },
	{  7738, "China Unicom USA Corporation" },
	{  7739, "Verizon Business Group" },
	{  7740, "France Telecom Long Distance USA, LLC" },
	{  7741, "Local Fiber, LLC" },
	{  7742, "MD Telecom, Inc" },
	{  7743, "Digicel USA, Inc" },
	{  7744, "Syniverse Technologies, Inc" },
	{  7745, "Trilogy International Enterprises, LLC" },
	{  7746, "Secure IP Telecom, Inc" },
	{  7747, "Syniverse Technologies, Inc" },
	{  7748, "Syniverse Technologies, Inc" },
	{  7749, "Digicel USA, Inc" },
	{  7750, "Secure IP Telecom, Inc" },
	{  7751, "Telecom New Zealand USA Ltd" },
	{  7752, "France Telecom Long Distance USA, LLC" },
	{  7753, "Bharti Airtel Ltd" },
	{  7754, "Syniverse Technologies, Inc" },
	{  7755, "Syniverse Technologies, Inc" },
	{  7756, "Teleglobe America, Inc" },
	{  7757, "Teleglobe America, Inc" },
	{  7758, "Teleglobe America, Inc" },
	{  7759, "Digicel USA, Inc" },
	{  7760, "Verisign Inc" },
	{  7761, "Verisign Inc" },
	{  7762, "Dollar Phone Corp" },
	{  7763, "Iris Wireless, LLC" },
	{  7764, "Iris Wireless, LLC" },
	{  7765, "Iris Wireless, LLC" },
	{  7766, "Telefonica International Wholesales Services United States, Inc" },
	{  7767, "Qwest Communications Corporation" },
	{  7768, "Qwest Communications Corporation" },
	{  7769, "Qwest Communications Corporation" },
	{  7770, "MiNO Wireless USA, Inc" },
	{  7771, "MiNO Wireless USA, Inc" },
	{  7772, "MiNO Wireless USA, Inc" },
	{  7773, "MiNO Wireless USA, Inc" },
	{  7774, "TransPacific Telecom" },
	{  7775, "Telco 214, Inc" },
	{  7776, "Telco 214, Inc" },
	{  7777, "United Hubbing Inc." },
	{  7778, "United Hubbing Inc." },
	{  7779, "BT Americas Inc" },
	{  7780, "Globecomm Network Services Corp." },
	{  7781, "Dba Next Telecommunication Inc" },
	{  7782, "Telecom North America Mobile, Inc." },
	{  8024, "Orange" },
	{  8025, "Orange" },
	{  8026, "Orange" },
	{  8027, "Orange" },
	{  8028, "Orange" },
	{  8029, "Orange" },
	{  8030, "Orange" },
	{  8031, "SMiLOUS GmbH" },
	{  8032, "City Communications (SE) Ltd" },
	{  8033, "City Communications (SE) Ltd" },
	{  8034, "Telekom Malaysia (UK) Ltd" },
	{  8035, "Orange" },
	{  8036, "Orange" },
	{  8037, "Orange" },
	{  8038, "Orange" },
	{  8039, "British Telecom" },
	{  8040, "Telecom New Zealand UK Ltd" },
	{  8041, "O2 (UK) Ltd" },
	{  8042, "O2 (UK) Ltd" },
	{  8043, "O2 (UK) Ltd" },
	{  8044, "O2 (UK) Ltd" },
	{  8045, "O2 (UK) Ltd" },
	{  8046, "O2 (UK) Ltd" },
	{  8047, "O2 (UK) Ltd" },
	{  8048, "Combridge" },
	{  8049, "Telemobil" },
	{  8050, "Plus Telecom" },
	{  8051, "Cosmote Romanian Mobile" },
	{  8052, "S.C. Romtelecom S.A." },
	{  8053, "S.C. Romtelecom S.A." },
	{  8056, "Telekomunikacije RS, a.d. Banja Luka" },
	{  8057, "Telekomunikacije RS, a.d. Banja Luka" },
	{  8058, "Telekomunikacije RS, a.d. Banja Luka" },
	{  8059, "Telekomunikacije RS, a.d. Banja Luka" },
	{  8072, "S" },
	{  8073, "S" },
	{  8074, "S" },
	{  8075, "S" },
	{  8076, "T-Mobile Crna Gora Ltd" },
	{  8077, "MTEL d.o.o. Podgorica" },
	{  8078, "MTEL d.o.o. Podgorica" },
	{  8079, "GSM ProMonte Montenegro" },
	{  8080, "Retevision Movil, S.A.U." },
	{  8081, "Retevision Movil, S.A.U." },
	{  8082, "Retevision Movil, S.A.U." },
	{  8083, "Retevision Movil, S.A.U." },
	{  8084, "Lleida Networks Serveis Tel, S.L." },
	{  8085, "Sabal Telec Integra, S.L." },
	{  8086, "Equant Spain, S.A." },
	{  8087, "11811 Nueva Informacion Tel, S.A.U." },
	{  8088, "Net44 Communication GmbH" },
	{  8089, "BerMos Com GmbH" },
	{  8090, "Sky Telecom AG" },
	{  8091, "Apelby GmbH" },
	{  8092, "Animatele Inc." },
	{  8093, "HanseNet Telekommunikation GmbH" },
	{  8094, "Obicom Swiss AG" },
	{  8096, "AS Telefant" },
	{  8097, "AS Telefant" },
	{  8098, "OY Teqli Telecom" },
	{  8101, "Tele2 Eesti AS" },
	{  8104, "Iskon Internet d.d." },
	{  8105, "Iskon Internet d.d." },
	{  8106, "Vodatel" },
	{  8107, "Voljatel telekommunikacije d.o.o." },
	{  8108, "Akton d.o.o." },
	{  8109, "T-mobile Hrvatska d.o.o." },
	{  8110, "T-mobile Hrvatska d.o.o." },
	{  8112, "Georgian Communication Company Ltd." },
	{  8113, "GoodWillComm Ltd" },
	{  8114, "Service Ltd" },
	{  8115, "Black Sea Telecom Ltd" },
	{  8116, "Mobitel Ltd" },
	{  8117, "Warid Telecom Georgia Ltd" },
	{  8118, "United Telecom" },
	{  8119, "Alex Development Georgia Ltd" },
	{  8120, "Tele2" },
	{  8121, "Tellcom" },
	{  8123, "Global" },
	{  8124, "Mega" },
	{  8125, "Borusan" },
	{  8126, "Kocnet" },
	{  8127, "Dogan" },
	{  8128, "Primetel Ltd" },
	{  8129, "D.Y. Wordnet Ltd." },
	{  8130, "Cyprus Telecommunications Authority (CYTA)" },
	{  8131, "Cyprus Telecommunications Authority (CYTA)" },
	{  8132, "Cyprus Telecommunications Authority (CYTA)" },
	{  8133, "Cablenet Communication Systems Ltd" },
	{  8134, "MTN Cyprus Limited" },
	{  8135, "MTN Cyprus Limited" },
	{  8136, "TMN - Telecomunicacoes Moveis Nacionais, S.A." },
	{  8137, "TMN - Telecomunicacoes Moveis Nacionais, S.A." },
	{  8144, "Telemobil" },
	{  8145, "Telemobil" },
	{  8146, "Vodafone Romania" },
	{  8147, "World Telecom Network" },
	{  8148, "Plug IT International" },
	{  8149, "RCS & RDS" },
	{  8150, "Ines Group" },
	{  8151, "Nevi Cons (Nevi Telecom)" },
	{  8152, "Dlugie Rozmowy S.A." },
	{  8153, "PT Novum Sp. Z.o.o." },
	{  8154, "GTS Energis Sp. Z.o.o" },
	{  8157, "Premium Internet S.A." },
	{  8158, "Premium Internet S.A." },
	{  8159, "Premium Internet S.A." },
	{  8160, "World Network Telecoms Ltd." },
	{  8161, "Telefonica Deutschland GmbH" },
	{  8162, "envia.tel GmbH" },
	{  8163, "ITXC Corp." },
	{  8164, "Max Tecom AG" },
	{  8165, "DiDaCom GmbH" },
	{  8166, "Televeiling International BV" },
	{  8167, "One.Tel Telekommunikation GmbH" },
	{  8168, "Multimedia Polska SA" },
	{  8169, "MNI Telecom S.A." },
	{  8170, "Sferia S.A." },
	{  8171, "E-Telko Sp. Z.o.o." },
	{  8172, "PTR Centertel Sp. Z.o.o." },
	{  8173, "Telekomunikacja Polska S.A." },
	{  8174, "P4 Sp. Z.o.o." },
	{  8175, "Telekomunikacja Kolejowa Sp. Z.o.o." },
	{  8176, "CK Telco Services GBR" },
	{  8177, "Group 3G UMTS GmbH" },
	{  8178, "Group 3G UMTS GmbH" },
	{  8179, "International Network Telecom Services GmbH" },
	{  8180, "WTN GmbH" },
	{  8181, "ISP Communication GmbH" },
	{  8182, "GTL GmbH" },
	{  8183, "Avantis Telecom GmbH" },
	{  8184, "iiseven GmbH" },
	{  8185, "Telegate AG" },
	{  8186, "Telegate AG" },
	{  8187, "DiDaCom GmbH" },
	{  8188, "Teleworld International Ltd." },
	{  8189, "3U Telecom AG" },
	{  8190, "Televeiling International BV" },
	{  8191, "Vinus Telecom GmbH" },
	{  8216, "Barak Ltd" },
	{  8217, "Barak Ltd" },
	{  8218, "Barak Ltd" },
	{  8219, "Barak Ltd" },
	{  8220, "012 Smile" },
	{  8221, "012 Smile" },
	{  8224, "Bezeq International Ltd" },
	{  8225, "Bezeq International Ltd" },
	{  8226, "Golden Lines Ltd" },
	{  8227, "Golden Lines Ltd" },
	{  8228, "Barak Ltd" },
	{  8229, "Barak Ltd" },
	{  8230, "Barak Ltd" },
	{  8231, "Barak Ltd" },
	{  8232, "M/s Reliance Infocomm Ltd" },
	{  8233, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8234, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8235, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8236, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8237, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8238, "M/s Reliance Infocomm Ltd" },
	{  8239, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8240, "M/s Data Access India Ltd" },
	{  8241, "M/s Data Access India Ltd" },
	{  8242, "M/s Data Access India Ltd" },
	{  8243, "M/s Data Access India Ltd" },
	{  8244, "M/s Hutchison Essar South Ltd" },
	{  8245, "M/s Hutchison Essar South Ltd" },
	{  8246, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8247, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8248, "M/s Hutchison Essar South Ltd" },
	{  8249, "M/s Hutchison Essar South Ltd" },
	{  8250, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8251, "M/s Bharti Telesonic Ltd" },
	{  8252, "M/s Bharti Telesonic Ltd" },
	{  8253, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8254, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8255, "M/s Data Access India Ltd" },
	{  8256, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8257, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8258, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8259, "M/s Vodafone Essar South Ltd" },
	{  8260, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8261, "M/s Vodafone Essar South Ltd" },
	{  8262, "M/s Vodafone Essar South Ltd" },
	{  8263, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8264, "ICO" },
	{  8265, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8266, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8267, "Iridium" },
	{  8268, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8269, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8270, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8271, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8272, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8273, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8274, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8275, "M/s Reliance Infocomm Ltd" },
	{  8276, "M/s Reliance Infocomm Ltd" },
	{  8277, "M/s Bharti Telesonic Ltd" },
	{  8278, "M/s Bharti Telesonic Ltd" },
	{  8279, "M/s Reliance Infocomm Ltd" },
	{  8280, "M/s Data Access Ltd" },
	{  8281, "M/s Data Access Ltd" },
	{  8282, "M/s Reliance Infocomm Ltd" },
	{  8283, "M/s Bharti Telesonic Ltd" },
	{  8284, "M/s Bharti Telesonic Ltd" },
	{  8285, "M/s Data Access Ltd" },
	{  8286, "M/s Data Access Ltd" },
	{  8287, "M/s Data Access Ltd" },
	{  8288, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8289, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8290, "M/s Reliance Infocomm Ltd" },
	{  8291, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8292, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8293, "Videsh Sanchar Nigam Ltd (VSNL)" },
	{  8294, "M/s Hutchison Essar South Ltd" },
	{  8295, "M/s Hutchison Essar South Ltd" },
	{  8296, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8297, "Bharat Sanchar Nigam Ltd (BSNL)" },
	{  8298, "M/s Reliance Infocomm Ltd" },
	{  8299, "M/s Reliance Infocomm Ltd" },
	{  8300, "M/s Reliance Infocomm Ltd" },
	{  8301, "M/s Reliance Infocomm Ltd" },
	{  8302, "M/s Hutchison Essar South Ltd" },
	{  8303, "M/s Hutchison Essar South Ltd" },
	{  8304, "M/s Dishnet Wireless Ltd" },
	{  8305, "M/s Spice Communications Ltd" },
	{  8306, "M/s P3 Technologies Pvt Ltd" },
	{  8307, "M/s Reliance Communications Ltd" },
	{  8308, "M/s Bharti Airtel Ltd" },
	{  8309, "M/s Bharti Airtel Ltd" },
	{  8310, "M/s Tata Communications Ltd" },
	{  8311, "M/s Tata Communications Ltd" },
	{  8312, "M/s Bharti Airtel Ltd" },
	{  8313, "M/s Tata Communications Ltd" },
	{  8314, "M/s Tata Communications Ltd" },
	{  8315, "M/s Tata Communications Ltd" },
	{  8316, "M/s Vodafone Essar South Ltd" },
	{  8317, "M/s Vodafone Essar South Ltd" },
	{  8318, "M/s Vodafone Essar South Ltd" },
	{  8319, "M/s Tata Communications Ltd" },
	{  8320, "M/s Tata Communications Ltd" },
	{  8321, "M/s Dishnet Wireless Ltd" },
	{  8322, "M/s Etisalat DB Telecom Ltd" },
	{  8323, "M/s Etisalat DB Telecom Ltd" },
	{  8324, "M/s Etisalat DB Telecom Ltd" },
	{  8325, "M/s Tata Communications Ltd" },
	{  8326, "M/s Etisalat DB Telecom Ltd" },
	{  8352, "M/s Pakistan Telecom Company Ltd" },
	{  8353, "M/s Pakistan Telecom Company Ltd" },
	{  8354, "M/s Pakistan Telecom Company Ltd" },
	{  8355, "M/s Pakistan Telecom Company Ltd" },
	{  8356, "M/s Worldcall Telecom Ltd" },
	{  8357, "M/s Link Direct International (Pvt) Ltd" },
	{  8358, "M/s Telecard Ltd" },
	{  8359, "M/s Special Communications Organization (SCO)" },
	{  8360, "M/s Dancom Pak Pvt Ltd" },
	{  8361, "M/s Wisecom System Pvt Ltd" },
	{  8362, "M/s Warid Telecom Pvt Ltd" },
	{  8363, "M/s Telenor Pak Ltd" },
	{  8364, "M/s Worldcall Telecom Ltd" },
	{  8365, "M/s DV Com Ltd" },
	{  8366, "M/s Telenor Pak Ltd" },
	{  8367, "M/s Redtone Pakistan Pvt Ltd" },
	{  8368, "M/s Link Direct International (Pvt) Ltd" },
	{  8369, "M/s Link Direct International (Pvt) Ltd" },
	{  8370, "M/s Warid Telecom Pvt Ltd" },
	{  8371, "M/s Callmate Telips Telecom Ltd" },
	{  8372, "M/s Circle Nett Communications Pvt Ltd." },
	{  8373, "M/s Burraq Telecom Ltd" },
	{  8374, "M/s DV Com Ltd" },
	{  8375, "M/s Warid Telecom Pvt Ltd" },
	{  8376, "M/s Redtone Pakistan Pvt Ltd" },
	{  8377, "M/s Telecard Ltd" },
	{  8378, "M/s Warid Telecom Pvt Ltd" },
	{  8379, "M/s LinkDirect" },
	{  8380, "M/s DV Com Ltd" },
	{  8381, "M/s CircleNet Comm" },
	{  8382, "M/s 4B Gentel" },
	{  8384, "AWCC" },
	{  8385, "AWCC" },
	{  8386, "AWCC" },
	{  8387, "Afghan Telecom" },
	{  8388, "Investcom (dba Areeba)" },
	{  8389, "Investcom (dba Areeba)" },
	{  8390, "TDCA (dba Roshan)" },
	{  8391, "TDCA (dba Roshan)" },
	{  8392, "TDCA (dba Roshan)" },
	{  8393, "TDCA (dba Roshan)" },
	{  8394, "TDCA (dba Roshan)" },
	{  8395, "AWCC" },
	{  8396, "AWCC" },
	{  8397, "Afghan Telecom" },
	{  8398, "Afghan Telecom" },
	{  8399, "Etisalat International" },
	{  8400, "Sri Lanka Telecom Ltd" },
	{  8401, "Sri Lanka Telecom Ltd" },
	{  8402, "Sri Lanka Telecom Ltd" },
	{  8403, "Sri Lanka Telecom Ltd" },
	{  8404, "Sri Lanka Telecom Ltd" },
	{  8405, "Mobitel (Pvt) Ltd" },
	{  8406, "Tigo Lanka (Pvt) Ltd" },
	{  8407, "Dialog Telecom Plc" },
	{  8408, "United Networks International" },
	{  8409, "VSNL Lanka Ltd" },
	{  8410, "Lanka Bell (Pvt) Ltd" },
	{  8411, "Dialog Telecom Plc" },
	{  8412, "Lanka Bell (Pvt) Ltd" },
	{  8413, "Tigo Lanka (Pvt) Ltd" },
	{  8414, "Suntel Ltd." },
	{  8415, "Dialog Broadband Networks" },
	{  8433, "Ministry of Posts and Telecommunications" },
	{  8434, "Ministry of Posts and Telecommunications" },
	{  8435, "Ministry of Posts and Telecommunications" },
	{  8440, "Umniah" },
	{  8441, "MobileCom" },
	{  8442, "Al-Moakhah for Telecom" },
	{  8448, "Fastlink" },
	{  8449, "Jordan Telecommunications Company" },
	{  8450, "Jordan Telecommunications Company" },
	{  8451, "Fastlink" },
	{  8452, "Fastlink" },
	{  8453, "Fastlink" },
	{  8454, "MobileCom" },
	{  8455, "MobileCom" },
	{  8456, "Pella" },
	{  8457, "Jordan Telecommunications Company" },
	{  8458, "MobileCom" },
	{  8459, "Pella" },
	{  8460, "Batelco Jordan" },
	{  8461, "Umniah" },
	{  8462, "Lasilkee" },
	{  8463, "Xpress" },
	{  8465, "Syrian Telecommunications Establishment" },
	{  8466, "Syrian Telecommunications Establishment" },
	{  8467, "Investcom" },
	{  8468, "Syriatel" },
	{  8480, "ITPC" },
	{  8481, "Asia Cell" },
	{  8482, "Iraquna" },
	{  8483, "Atheer" },
	{  8496, "Ministry of Communications" },
	{  8497, "Ministry of Communications" },
	{  8498, "Ministry of Communications" },
	{  8499, "STC" },
	{  8500, "STC" },
	{  8501, "Zain" },
	{  8502, "Zain" },
	{  8503, "Wataniya" },
	{  8512, "Saudi Telecom Company (STC)" },
	{  8513, "Saudi Telecom Company (STC)" },
	{  8514, "Saudi Telecom Company (STC)" },
	{  8515, "Saudi Telecom Company (STC)" },
	{  8516, "Saudi Telecom Company (STC)" },
	{  8517, "Saudi Telecom Company (STC)" },
	{  8518, "Saudi Telecom Company (STC)" },
	{  8519, "Saudi Telecom Company (STC)" },
	{  8520, "Mobily" },
	{  8521, "Mobily" },
	{  8522, "Mobily" },
	{  8523, "Mobily" },
	{  8524, "Mobily" },
	{  8525, "Mobily" },
	{  8526, "Mobily" },
	{  8527, "Mobily" },
	{  8528, "Yemen International Telecommunications Company" },
	{  8529, "Spacetel Yemen" },
	{  8530, "SABA FON" },
	{  8531, "TeleYemen" },
	{  8532, "TeleYemen" },
	{  8544, "Omantel" },
	{  8545, "Omantel" },
	{  8546, "Nawras" },
	{  8547, "Nawras" },
	{  8548, "Omantel" },
	{  8560, "TeleYemen" },
	{  8561, "TeleYemen" },
	{  8562, "TeleYemen" },
	{  8563, "Hits-Unitel-Y" },
	{  8564, "Hits-Unitel-Y" },
	{  8576, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8577, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8578, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8579, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8580, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8582, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8583, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8584, "Emirates Integrated Telecommunications Company (du)" },
	{  8585, "Emirates Integrated Telecommunications Company (du)" },
	{  8586, "Emirates Integrated Telecommunications Company (du)" },
	{  8587, "Emirates Integrated Telecommunications Company (du)" },
	{  8592, "Internet Zahav" },
	{  8593, "Bezeq International Ltd" },
	{  8594, "Internet Gold - Golden Lines Ltd" },
	{  8595, "Bezeq International Ltd" },
	{  8596, "Barak Ltd" },
	{  8597, "Barak Ltd" },
	{  8598, "Golden Lines Ltd" },
	{  8599, "Golden Lines Ltd" },
	{  8600, "Bezeq International Ltd" },
	{  8601, "Bezeq International Ltd" },
	{  8602, "Partner" },
	{  8603, "Barak Ltd" },
	{  8604, "Netvision Ltd" },
	{  8605, "Netvision Ltd" },
	{  8606, "Xfone Communications Ltd" },
	{  8607, "Xfone Communications Ltd" },
	{  8608, "Bahrain Telecommunications Company (Batelco)" },
	{  8609, "Bahrain Telecommunications Company (Batelco)" },
	{  8610, "2Connect WLL" },
	{  8611, "Bahrain Telecommunications Company (Batelco)" },
	{  8612, "AMWAJ Telecom" },
	{  8613, "Bahrain Telecommunications Company (Batelco)" },
	{  8614, "MTC Vodafone (Bahrain)" },
	{  8615, "MTC Vodafone (Bahrain)" },
	{  8616, "Light Speed Communications" },
	{  8617, "MTC Vodafone (Bahrain)" },
	{  8618, "STC Bahrain B.S.C. (Closed)" },
	{  8619, "Etisalcom WLL" },
	{  8620, "STC Bahrain B.S.C. (Closed)" },
	{  8621, "STC Bahrain B.S.C. (Closed)" },
	{  8622, "STC Bahrain B.S.C. (Closed)" },
	{  8624, "Qatar  Telecom (QTEL)" },
	{  8625, "Qatar  Telecom (QTEL)" },
	{  8626, "Qatar  Telecom (QTEL)" },
	{  8627, "Qatar  Telecom (QTEL)" },
	{  8628, "Qatar  Telecom (QTEL)" },
	{  8629, "Qatar  Telecom (QTEL)" },
	{  8630, "Qatar  Telecom (QTEL)" },
	{  8631, "Qatar  Telecom (QTEL)" },
	{  8632, "Vodafone Qatar" },
	{  8633, "Vodafone Qatar" },
	{  8656, "Nepal Doorsanchar Co. Ltd" },
	{  8657, "Nepal Doorsanchar Co. Ltd" },
	{  8658, "United Telecom Ltd" },
	{  8659, "Spice Nepal Pvt Ltd" },
	{  8660, "Nepal Doorsanchar Co. Ltd" },
	{  8661, "STM Telecom Sanchar Pvt. Ltd" },
	{  8662, "Nepal Doorsanchar Co. Ltd" },
	{  8663, "United Telecom Ltd" },
	{  8664, "United Telecom Ltd" },
	{  8665, "United Telecom Ltd" },
	{  8667, "Spice Nepal Pvt Ltd" },
	{  8672, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8673, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8674, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8675, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8676, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8677, "Emirates Integrated Telecommunications Company (du)" },
	{  8678, "Emirates Integrated Telecommunications Company (du)" },
	{  8679, "Emirates Integrated Telecommunications Company (du)" },
	{  8688, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8689, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8690, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8691, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8692, "Emirates Telecommunications Corporation (ETISALAT)" },
	{  8694, "Thuraya Satellite Network" },
	{  8704, "Telecommunication Company of Iran (TCI)" },
	{  8705, "Telecommunication Company of Iran (TCI)" },
	{  8706, "Telecommunication Company of Iran (TCI)" },
	{  8707, "-" },
	{  8708, "-" },
	{  8709, "-" },
	{  8710, "-" },
	{  8711, "Telecommunication Company of Iran (TCI)" },
	{  8752, "Aztelekom PU" },
	{  8753, "Aztelekom PU" },
	{  8754, "Ministry of Communications and Information Technologies of Nakhchivan Autonomous Republic of the Republic of Azerbaijan" },
	{  8755, "Azertelekom LLC" },
	{  8756, "Azertelekom LLC" },
	{  8757, "Azertelekom LLC" },
	{  8758, "Azercell Telekom LLC" },
	{  8759, "Azercell Telekom LLC" },
	{  8768, "Bhutan Telecom Ltd." },
	{  8784, "National Signalling Network Administration, Monitoring and Measurement" },
	{  8785, "JSC Kazakhtelecom" },
	{  8786, "JSC Kazakhtelecom" },
	{  8787, "JSC Kazakhtelecom" },
	{  8788, "GSM Kazakhstan (roaming)" },
	{  8789, "KaR-Tel LLP (roaming)" },
	{  8790, "JSC Altel (roaming)" },
	{  8791, "Mobile Telecom Service LLP network (roaming)" },
	{  8792, "JSC KazTransCom" },
	{  8793, "JSC TransTelecom" },
	{  8794, "Mobile Telecom Service LLP" },
	{  8795, "JSC Arna" },
	{  8796, "Mobile Telecom Service LLP" },
	{  8797, "JSC Astel" },
	{  8798, "JSC Astel" },
	{  8799, "Technical Information Centre LLP" },
	{  8800, "LLP TNS-Plus" },
	{  8801, "Joint Stock Company TransTelecom" },
	{  8802, "Joint Stock Company Arna" },
	{  8803, "LLP TNS-Plus" },
	{  8804, "LLP KazinterCom" },
	{  8805, "LLP TNS-Plus" },
	{  8806, "LLP Technical Information Centre" },
	{  8816, "JSC Kyrgyztelecom" },
	{  8817, "Nur Telecom Ltd" },
	{  8818, "Nur Telecom Ltd" },
	{  8819, "JS Saima Telecom" },
	{  8820, "MeGaCom Ltd" },
	{  8821, "Sky Mobile Ltd" },
	{  8822, "AkTen Ltd" },
	{  8824, "Kyrghyztelecom" },
	{  8825, "JSC Kyrgyztelecom" },
	{  8826, "reserved" },
	{  8827, "reserved" },
	{  8828, "MeGaCom Ltd" },
	{  8829, "reserved" },
	{  8830, "reserved" },
	{  8832, "KDDI Corporation" },
	{  8833, "KDDI Corporation" },
	{  8834, "KDDI Corporation" },
	{  8835, "KVH Co. Ltd." },
	{  8836, "China Motion Japan Ltd." },
	{  8837, "Primus Telecommunications K.K." },
	{  8838, "KDDI Corporation" },
	{  8839, "KDDI Corporation" },
	{  8840, "KDDI Corporation" },
	{  8841, "KDDI Corporation" },
	{  8842, "KDDI Corporation" },
	{  8843, "KDDI Corporation" },
	{  8844, "T-Systems Japan K.K." },
	{  8845, "T-Systems Japan K.K." },
	{  8846, "NTT Communications Corporation" },
	{  8847, "NTT Communications Corporation" },
	{  8848, "Saiki-Tech Communication Japan Co. Ltd." },
	{  8849, "Saiki-Tech Communication Japan Co. Ltd." },
	{  8850, "Pacific Telecom Co. Ltd." },
	{  8851, "Telstra Singapore PTE Ltd." },
	{  8852, "IPS Inc." },
	{  8853, "Verizon Japan Ltd." },
	{  8854, "Nebular Telecom Japan K.K." },
	{  8855, "SingTel Japan Co. Ltd." },
	{  8856, "Softbank Telecom Corp." },
	{  8857, "Softbank Telecom Corp." },
	{  8858, "Softbank Telecom Corp." },
	{  8859, "NTT Communications Corporation" },
	{  8860, "RSLCom Japan K.K." },
	{  8861, "RSLCom Japan K.K." },
	{  8862, "Softbank Telecom Corp." },
	{  8863, "Verizon Japan Ltd." },
	{  8864, "VeriSign Japan K.K." },
	{  8865, "VeriSign Japan K.K." },
	{  8866, "VeriSign Japan K.K." },
	{  8867, "Brastel Company Ltd." },
	{  8868, "Brastel Company Ltd." },
	{  8869, "Emobile Ltd" },
	{  8870, "Emobile Ltd" },
	{  8871, "KVH Co. Ltd." },
	{  8872, "Softbank Telecom Corp." },
	{  8873, "Softbank Telecom Corp." },
	{  8874, "Softbank Telecom Corp." },
	{  8875, "IPS Inc." },
	{  8876, "Softbank Telecom Corp." },
	{  8877, "NTT Communications Corporation" },
	{  8878, "Primus Telecommunications K.K." },
	{  8879, "Cignal Telecommunications Japan K.K." },
	{  8992, "Korea Telecom" },
	{  8993, "Korea Telecom" },
	{  8994, "Korea Telecom" },
	{  8995, "Korea Telecom" },
	{  8996, "Korea Telecom" },
	{  8997, "Korea Telecom" },
	{  8998, "Korea Telecom" },
	{  8999, "Korea Telecom" },
	{  9000, "Dacom" },
	{  9001, "Dacom" },
	{  9002, "Dacom" },
	{  9003, "Dacom" },
	{  9004, "Dacom" },
	{  9005, "Dacom" },
	{  9006, "Dacom" },
	{  9007, "Dacom" },
	{  9016, "Vietel Corporation (Vietel)" },
	{  9017, "EVN Telecom (EVNT)" },
	{  9018, "EVN Telecom (EVNT)" },
	{  9019, "Saigon Postel Corporation (SPT)" },
	{  9020, "Vietel Corporation (Vietel)" },
	{  9021, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9022, "Vietel Corporation (Vietel)" },
	{  9023, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9024, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9025, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9026, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9027, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9028, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9029, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9030, "Vietnam Posts and Telecommunications Corporation (VNPT)" },
	{  9031, "Vietel Corporation (Vietel)" },
	{  9032, "Equant Hong Kong Ltd" },
	{  9033, "Singapore Telecom Hong Kong Ltd" },
	{  9034, "Wharf T&T Ltd" },
	{  9035, "Hutchison Global Communications Ltd" },
	{  9036, "CITIC Telecom 1616 Ltd" },
	{  9037, "Hutchison Telephone Company Ltd" },
	{  9038, "Verizon Hong Kong Ltd" },
	{  9039, "Wharf T&T Ltd" },
	{  9040, "City Telecom (HK) Ltd" },
	{  9041, "Hutchison Global Communications Ltd" },
	{  9042, "KDDI Hong Kong Ltd" },
	{  9043, "New World Telecommunications Ltd" },
	{  9044, "New World Telecommunications Ltd" },
	{  9045, "Hong Kong Telecommunications (HK) Ltd" },
	{  9046, "PCCW Global (HK) Ltd" },
	{  9047, "SIM2Tranvel (HK) Ltd" },
	{  9048, "Arbinet-thexchange HK Ltd" },
	{  9049, "CarrierNet Corporation Ltd" },
	{  9050, "City Telecom (HK) Ltd" },
	{  9051, "Global Crossing Hong Kong Ltd" },
	{  9052, "SmarTone Mobile Communications Ltd" },
	{  9053, "China Unicom International Ltd" },
	{  9054, "Lucky Tone Communications Ltd" },
	{  9055, "China Netcom (HK) Operations Co. Ltd" },
	{  9056, "Reach Networks HongKong Ltd" },
	{  9057, "Reach Networks HongKong Ltd" },
	{  9058, "Reach Networks HongKong Ltd" },
	{  9059, "Reach Networks HongKong Ltd" },
	{  9060, "PCCW Global (HK) Ltd" },
	{  9061, "PCCW Global (HK) Ltd" },
	{  9064, "Standard Network Ltd" },
	{  9065, "China Unicom International Ltd" },
	{  9066, "PCCW Global (HK) Ltd" },
	{  9067, "Wharf T&T Ltd" },
	{  9068, "PCCW Global (HK) Ltd" },
	{  9069, "Donghwa Telecom Co. Ltd" },
	{  9070, "Centrex Telecom Co. Ltd" },
	{  9072, "Hutchison Telephone (Macau) Limitada" },
	{  9073, "Companhia de Telecomunicacoes de Macau sarl (CTM)" },
	{  9074, "Companhia de Telecomunicacoes de Macau sarl (CTM)" },
	{  9075, "Companhia de Telecomunicacoes de Macau sarl (CTM)" },
	{  9076, "SmarTone - Comunicacoes Moveis, S.A." },
	{  9077, "Hutchison Telephone (Macau) Limitada" },
	{  9078, "China Telecom (Macau) Company Ltd" },
	{  9079, "Companhia de Telecomunicacoes de Macau sarl (CTM)" },
	{  9080, "1582HK Ltd" },
	{  9081, "GTI (HK) Ltd" },
	{  9082, "China Unicom International Ltd" },
	{  9083, "Voice Exchange Ltd" },
	{  9084, "KeyWest Communications (HK) Ltd" },
	{  9085, "Telekom Malaysia (Hong Kong) Ltd" },
	{  9086, "Cable & Wireless Global Network (HK) Ltd" },
	{  9087, "China Mobile People's Telephone Co. Ltd" },
	{  9088, "Telecom Cambodia" },
	{  9089, "Telecom Cambodia" },
	{  9090, "Royal Telecom International (RTI1)" },
	{  9091, "Royal Telecom International (RTI2)" },
	{  9093, "Royal Telecom International (RTI)" },
	{  9094, "Royal Telecom International (RTI)" },
	{  9095, "Telcotech Gateway" },
	{  9097, "Viettel Company (VTC)" },
	{  9104, "Enterprise of Telecommunications Lao" },
	{  9109, "Lao Asia Telecom State Enterprise (LAT)" },
	{  9110, "Sky Telecom Co., Ltd" },
	{  9144, "SmarTone - Comunicacoes Moveis, S.A." },
	{  9152, "China Netcom" },
	{  9153, "China Netcom" },
	{  9154, "China Netcom" },
	{  9155, "China Telecom" },
	{  9156, "China Telecom" },
	{  9157, "China Telecom" },
	{  9158, "China Telecom" },
	{  9159, "China Satcom" },
	{  9160, "China Telecom" },
	{  9161, "China Netcom" },
	{  9162, "China Telecom" },
	{  9163, "China Telecom" },
	{  9164, "China Telecom" },
	{  9165, "China Telecom" },
	{  9166, "China Netcom" },
	{  9167, "China Telecom" },
	{  9168, "China Netcom" },
	{  9169, "China Netcom" },
	{  9170, "China Netcom" },
	{  9171, "China Telecom" },
	{  9172, "China Telecom" },
	{  9173, "China Telecom" },
	{  9174, "China Telecom" },
	{  9175, "China Netcom" },
	{  9176, "China Unicom" },
	{  9177, "China Unicom" },
	{  9178, "China Unicom" },
	{  9179, "China Unicom" },
	{  9180, "China Unicom" },
	{  9181, "China Unicom" },
	{  9182, "China Unicom" },
	{  9183, "China Unicom" },
	{  9184, "China Telecom" },
	{  9185, "China Unicom" },
	{  9186, "China Unicom" },
	{  9187, "China Unicom" },
	{  9188, "China Netcom" },
	{  9189, "China Netcom" },
	{  9190, "China Netcom" },
	{  9191, "China Netcom" },
	{  9192, "Beijing Boat Communication Corporation" },
	{  9193, "Beijing Boat Communication Corporation" },
	{  9194, "China Mobile" },
	{  9195, "China Mobile" },
	{  9196, "China Mobile" },
	{  9197, "China Mobile" },
	{  9198, "China Mobile" },
	{  9199, "China Telecom" },
	{  9200, "China Satcom" },
	{  9201, "China Tietong" },
	{  9202, "China Tietong" },
	{  9203, "China Tietong" },
	{  9204, "China Tietong" },
	{  9205, "China Tietong" },
	{  9206, "China Tietong" },
	{  9207, "China Satcom" },
	{  9208, "China Telecom" },
	{  9209, "China Telecom" },
	{  9210, "China Telecom" },
	{  9211, "China Telecom" },
	{  9212, "China Telecom" },
	{  9213, "China Telecom" },
	{  9214, "China Telecom" },
	{  9280, "TDCA (dba Roshan)" },
	{  9281, "TDCA (dba Roshan)" },
	{  9282, "TDCA (dba Roshan)" },
	{  9283, "TDCA (dba Roshan)" },
	{  9284, "TDCA (dba Roshan)" },
	{  9285, "TDCA (dba Roshan)" },
	{  9286, "TDCA (dba Roshan)" },
	{  9287, "TDCA (dba Roshan)" },
	{  9288, "Etisalat" },
	{  9289, "Etisalat" },
	{  9290, "Etisalat" },
	{  9291, "Etisalat" },
	{  9313, "Sheba Telecom (pvt) Ltd." },
	{  9314, "Bangladesh Telegraph and Telephone Board" },
	{  9315, "Bangladesh Telegraph and Telephone Board" },
	{  9316, "Bangladesh Telegraph and Telephone Board" },
	{  9317, "Bangladesh Telegraph and Telephone Board" },
	{  9318, "Grameenphone Ltd." },
	{  9319, "TM International (Bangladesh) Ltd." },
	{  9321, "Bangladesh Telegraph and Telephone Board" },
	{  9322, "Bangladesh Telegraph and Telephone Board" },
	{  9323, "Warid Telecom International L.I.C" },
	{  9324, "Warid Telecom International L.I.C" },
	{  9325, "Grameenphone Ltd." },
	{  9326, "Pacific Bangladesh Telecom Ltd. (PBTL)" },
	{  9327, "Teletalk Bangladesh Ltd" },
	{  9329, "Banglatrac Communication Ltd" },
	{  9330, "Novotel Ltd" },
	{  9331, "Mir Telecom" },
	{  9345, "Dhiraagu" },
	{  9346, "Dhiraagu" },
	{  9347, "Wataniya Telecom Maldives" },
	{  9348, "Dhiraagu" },
	{  9349, "Wataniya Telecom Maldives" },
	{  9350, "Dhiraagu" },
	{  9351, "Dhiraagu" },
	{  9352, "SK Telecom" },
	{  9353, "KT Powertel" },
	{  9354, "KT Powertel" },
	{  9355, "KT Powertel" },
	{  9356, "KT Powertel" },
	{  9357, "KT Powertel" },
	{  9358, "KT Powertel" },
	{  9359, "KT Powertel" },
	{  9368, "Unitel" },
	{  9369, "HK Telecom" },
	{  9370, "Serome" },
	{  9371, "SK Tellink" },
	{  9372, "HIT" },
	{  9373, "Daewoo Information Systems" },
	{  9374, "HK Telecom" },
	{  9375, "HK Telecom" },
	{  9376, "Hyundai Telecom" },
	{  9377, "Onetel" },
	{  9378, "Onetel" },
	{  9379, "Naray Telecom" },
	{  9380, "Asia Telecom" },
	{  9381, "Korea International Telephone" },
	{  9382, "ICN Telecom" },
	{  9383, "Hanhwa" },
	{  9384, "Unitel" },
	{  9385, "InfoTel" },
	{  9386, "KT Networks" },
	{  9387, "HappyTelecom" },
	{  9388, "Inet Telecom" },
	{  9389, "Dizzocom" },
	{  9390, "Prism Communications" },
	{  9391, "Songa Telecom" },
	{  9392, "SK Tellink" },
	{  9393, "CPS Technology" },
	{  9394, "Dizzocom" },
	{  9395, "KTT" },
	{  9396, "GS Retail" },
	{  9397, "GNG Telecom" },
	{  9398, "M-Touch" },
	{  9399, "KT freetel" },
	{  9400, "ENTel" },
	{  9401, "Serome" },
	{  9402, "MCI Worldcom Korea" },
	{  9403, "Telinker" },
	{  9404, "SK Tellink" },
	{  9405, "Enterprise Networks" },
	{  9406, "Enterprise Networks" },
	{  9407, "Enterprise Networks" },
	{  9408, "CPS Telecom" },
	{  9409, "CPS Telecom" },
	{  9410, "CPS Telecom" },
	{  9411, "CPS Telecom" },
	{  9412, "CPS Telecom" },
	{  9413, "CPS Telecom" },
	{  9414, "CPS Telecom" },
	{  9415, "CPS Telecom" },
	{  9416, "Hanaro Telecom" },
	{  9417, "Hanaro Telecom" },
	{  9418, "Hanaro Telecom" },
	{  9419, "Hanaro Telecom" },
	{  9420, "Hanaro Telecom" },
	{  9421, "Hanaro Telecom" },
	{  9422, "Hanaro Telecom" },
	{  9423, "Hanaro Telecom" },
	{  9424, "SK Networks" },
	{  9425, "SK Networks" },
	{  9426, "SK Networks" },
	{  9427, "SK Networks" },
	{  9428, "Dreamline" },
	{  9429, "Dreamline" },
	{  9430, "Dreamline" },
	{  9431, "Dreamline" },
	{  9448, "Tajiktelecom" },
	{  9449, "Tajiktelecom" },
	{  9450, "Telecom Technology" },
	{  9451, "Babillon-T" },
	{  9452, "Babillon-T" },
	{  9453, "Servis Svyaz Komplect" },
	{  9454, "Servis Svyaz Komplect" },
	{  9455, "Somoncom" },
	{  9456, "Somoncom" },
	{  9457, "Tacom" },
	{  9458, "Tacom" },
	{  9459, "Indigo Tajikistan" },
	{  9460, "Indigo Tajikistan" },
	{  9461, "TT-mobile" },
	{  9462, "TT-mobile" },
	{  9463, "Telecom Technology" },
	{  9473, "Turkmentelecom" },
	{  9505, "UzInter Telecom (JSC Uzintel)" },
	{  9506, "UzInter Telecom (JSC Uzintel)" },
	{  9507, "UzInter Telecom (JSC Uzintel)" },
	{  9600, "Express Tone (HK) Ltd" },
	{  9601, "CITIC Telecom 1616 Ltd" },
	{  9602, "China Virtual (Hong Kong) Ltd" },
	{  9603, "M800 Ltd" },
	{  9604, "CITIC Telecom 1616 Ltd" },
	{  9605, "CITIC Telecom 1616 Ltd" },
	{  9606, "Mangotone International Ltd" },
	{  9607, "Qwest Hong Kong Telecommunications Ltd" },
	{  9608, "China Leader International Ltd" },
	{  9609, "CITIC Telecom 1616 Ltd" },
	{  9610, "City Telecom (HK) Ltd" },
	{  9611, "Frontier Network Technology Ltd" },
	{  9612, "ComNet Telecom International Limited" },
	{  9614, "Digital Pacific Ltd" },
	{  9615, "IDD 1628 Ltd" },
	{  9616, "One.Tel Ltd." },
	{  9617, "CMTEL (HK) Ltd" },
	{  9618, "Topbest Technology Holdings Ltd" },
	{  9619, "CITIC Telecom 1616 Ltd" },
	{  9620, "Hongkong CSL Ltd" },
	{  9621, "Teleone (HK) Ltd" },
	{  9622, "Pacnet Services Asia Pacific Commercial (HK) Ltd" },
	{  9623, "APT Telecom Services Ltd" },
	{  9624, "CITIC Telecom 1616 Ltd" },
	{  9625, "CITIC Telecom 1616 Ltd" },
	{  9626, "Powernet Telecom Ltd" },
	{  9627, "IDT Telecom Asia Pacific Ltd" },
	{  9628, "China Tietong HongKong Telecom Co. Ltd." },
	{  9629, "HKC Network Ltd" },
	{  9630, "CITIC Telecom 1616 Ltd" },
	{  9631, "VMS Technology Ltd" },
	{  9632, "EC Telecom Ltd" },
	{  9633, "Telekom Malaysia (Hong Kong) Ltd" },
	{  9634, "Pacific IDD Ltd" },
	{  9635, "South China Telecommunications (HK) Ltd." },
	{  9636, "Hutchison Global Communications Ltd" },
	{  9637, "Systech Telecom Ltd" },
	{  9638, "CarrierNet Corporation Ltd" },
	{  9639, "New World Telecommunications Ltd" },
	{  9640, "Syniverse Technologies Asia Pacific Ltd" },
	{  9641, "China Mobile Hong Kong Ltd" },
	{  9642, "New World Telecommunications Ltd" },
	{  9643, "Hutchison Global Communications Ltd" },
	{  9644, "China Virtual (Hong Kong) Ltd" },
	{  9645, "M800 Ltd" },
	{  9647, "SLT Hong Kong Ltd" },
	{  9712, "Dialog Telecom Plc" },
	{  9713, "Dialog Telecom Plc" },
	{  9714, "Mobitel (Pvt) Ltd" },
	{  9715, "Airtel Lanka Ltd" },
	{  9716, "TATA Communication Lanka Ltd" },
	{  9717, "Hutchison Telecommunication Ltd" },
	{  9718, "Etisalat Lanka (vt) Ltd" },
	{  9719, "Etisalat Lanka (vt) Ltd" },
	{  10088, "SIA Sotus Communications" },
	{  10089, "SIA Sotus Communications" },
	{  10090, "SIA IT Baltija" },
	{  10091, "SIA Stream Networks" },
	{  10092, "SIA Telia Latvija" },
	{  10093, "Telegrupa Baltija" },
	{  10094, "Telegrupa Baltija" },
	{  10095, "TG Transit" },
	{  10104, "Barablu Mobile Ltd" },
	{  10105, "Barablu Mobile Ltd" },
	{  10106, "Telephony Services Ltd" },
	{  10107, "Opal Telecom Ltd" },
	{  10108, "Wireless Solutions International" },
	{  10109, "Communications Networking Services (UK)" },
	{  10110, "Communications Networking Services (UK)" },
	{  10111, "Vectone Network Ltd" },
	{  10112, "Epsilon Telecommunications Ltd" },
	{  10113, "ELCom Management Ltd" },
	{  10114, "iHub Ltd" },
	{  10115, "iHub Ltd" },
	{  10116, "China Telecom (Europe) Ltd" },
	{  10117, "QiComm Ltd" },
	{  10118, "Global Crossing (UK) Ltd" },
	{  10119, "Inmarsat Ltd" },
	{  10128, "TRCommunication" },
	{  10129, "Telesystems of Ukraine" },
	{  10130, "Ukrtelecom UMTS" },
	{  10131, "Ukrtelecom" },
	{  10132, "Ukrtelecom" },
	{  10133, "Closed joint stock company Kyivstar GSM" },
	{  10134, "Atlantis Telecom Ltd" },
	{  10135, "Eurotranstelecom Ltd" },
	{  10136, "Vodafone Hungary Ltd" },
	{  10137, "Vodafone Hungary Ltd" },
	{  10144, "Camelot Telecom Ltd." },
	{  10145, "Dialost GmbH" },
	{  10146, "MTBC Telecom Ltd." },
	{  10147, "GlobalCarrier Telecom GmbH" },
	{  10148, "TYNTEC GmbH" },
	{  10149, "Vistream GmbH" },
	{  10150, "Synterra UK Ltd." },
	{  10151, "Digital Alliance Consortium" },
	{  10152, "Algonet" },
	{  10153, "OTE" },
	{  10154, "OTE" },
	{  10155, "ON" },
	{  10156, "Tellas" },
	{  10157, "ON" },
	{  10158, "Forthnet" },
	{  10159, "Oteglobe" },
	{  10160, "TVI Connect BV" },
	{  10161, "01029 Telecom GmbH" },
	{  10162, "Quidex GmbH" },
	{  10163, "TVI milleni.com GmbH" },
	{  10164, "TVI Connect BV" },
	{  10165, "Protel GmbH" },
	{  10166, "01059 GmbH" },
	{  10167, "Voice2Voice Carrier Services Ltd." },
	{  10168, "Inmarsat Ltd" },
	{  10169, "Touchtone Carrier Services" },
	{  10170, "Callax Ltd." },
	{  10171, "Lycamobile UK Limited" },
	{  10172, "Gold Telecom Ltd" },
	{  10173, "Switchware Ltd" },
	{  10174, "Vodafone Ltd" },
	{  10175, "Communications Networking Services (UK)" },
	{  10176, "Telekom Srbija a.d." },
	{  10177, "Telekom Srbija a.d." },
	{  10178, "Vip Mobile d.o.o." },
	{  10179, "Vip Mobile d.o.o." },
	{  10180, "Telenor d.o.o." },
	{  10184, "OT-Optima Telekom d.d." },
	{  10185, "OT-Optima Telekom d.d." },
	{  10186, "AmisTelekom d.o.o." },
	{  10187, "VM Telekom d.o.o." },
	{  10188, "H1 Telekom d.d." },
	{  10189, "Incotel d.o.o." },
	{  10190, "Metronet telekomunikacije d.d." },
	{  10191, "Primatel d.o.o." },
	{  10192, "Multimedia Polska - Mielec Sp. Z.o.o." },
	{  10193, "PTK Centertel Sp. Z.o.o." },
	{  10194, "Inter Promo XXI Sp. Z.o.o." },
	{  10195, "MNI Telecom S.A." },
	{  10196, "BT Poland Sp. Z.o.o" },
	{  10197, "Neo Telecom Sp. Z.o.o" },
	{  10198, "Poltomtel S.A." },
	{  10200, "T-Mobile Slovensko, a.s." },
	{  10201, "T-Mobile Slovensko, a.s." },
	{  10202, "T-Mobile Slovensko, a.s." },
	{  10203, "T-Mobile Slovensko, a.s." },
	{  10204, "4Consult, s.r.o." },
	{  10205, "Slovak Telekom, a.s." },
	{  10206, "Slovak Telekom, a.s." },
	{  10207, "Antik Computers and Communications, s.r.o." },
	{  10208, "RCS & RDS" },
	{  10209, "RCS & RDS" },
	{  10210, "Transtel Services" },
	{  10211, "New Com Telecomunicatii" },
	{  10213, "Euroweb Romania" },
	{  10214, "Atlas Telecom Network" },
	{  10215, "Dial Telecom" },
	{  10216, "Inmarsat Ltd" },
	{  10217, "UIS Telecom Ltd" },
	{  10218, "Vodafone Ltd" },
	{  10219, "Telstra Europe Ltd" },
	{  10220, "PLDT (UK) Ltd" },
	{  10221, "Inmarsat Ltd" },
	{  10222, "Digitech Solutions Global Ltd" },
	{  10223, "United Connect Ltd" },
	{  10224, "Africa.com Ltd" },
	{  10225, "Econet Satellite Services Ltd" },
	{  10226, "Expo Communications Ltd" },
	{  10227, "SpiriTel Technologies Ltd" },
	{  10228, "Orange" },
	{  10229, "Orange" },
	{  10230, "TS Connect Ltd" },
	{  10231, "Esse Solutions Ltd" },
	{  10232, "Vodafone Ltd" },
	{  10233, "T-Systems Ltd" },
	{  10234, "Nexcom Telecommunications" },
	{  10235, "Cable and Wireless (Energis)" },
	{  10236, "Tele2 UK Services Ltd" },
	{  10237, "Gamma Telecommunications Ltd" },
	{  10238, "British Telecom" },
	{  10239, "Bon.net Systems Limited" },
	{  10264, "Telekom Malaysia Berhad" },
	{  10265, "Telekom Malaysia Berhad" },
	{  10266, "Telekom Malaysia Berhad" },
	{  10267, "Telekom Malaysia Berhad" },
	{  10268, "YTL Communication Sdn Bhd" },
	{  10269, "Baraka Telecom Sdn Bhd" },
	{  10272, "Telekom Malaysia Berhad" },
	{  10273, "Telekom Malaysia Berhad" },
	{  10274, "Telekom Malaysia Berhad" },
	{  10275, "Telekom Malaysia Berhad" },
	{  10276, "Telekom Malaysia Berhad" },
	{  10277, "Telekom Malaysia Berhad" },
	{  10278, "Celcom (Malaysia) Berhad" },
	{  10279, "Celcom (Malaysia) Berhad" },
	{  10280, "Digi Telecommunications" },
	{  10281, "Malaysian Mobile Services Sdn Bhd" },
	{  10282, "Malaysian Mobile Services Sdn Bhd" },
	{  10283, "Malaysian Mobile Services Sdn Bhd" },
	{  10284, "Xintel Sdn Bhd" },
	{  10285, "Telshine Sdn Bhd" },
	{  10286, "Digi Telecommunications" },
	{  10287, "Digi Telecommunications" },
	{  10288, "Digi Telecommunications" },
	{  10289, "Digi Telecommunications" },
	{  10290, "TT dotcom Sdn Bhd" },
	{  10291, "TT dotcom Sdn Bhd" },
	{  10292, "TT dotcom Sdn Bhd" },
	{  10293, "Telekom Malaysia Berhad" },
	{  10294, "Telekom Malaysia Berhad" },
	{  10295, "Telekom Malaysia Berhad" },
	{  10296, "Telekom Malaysia Berhad" },
	{  10297, "Telekom Malaysia Berhad" },
	{  10298, "Telekom Malaysia Berhad" },
	{  10299, "Telekom Malaysia Berhad" },
	{  10300, "Telekom Malaysia Berhad" },
	{  10301, "Telekom Malaysia Berhad" },
	{  10302, "Telekom Malaysia Berhad" },
	{  10303, "Telekom Malaysia Berhad" },
	{  10304, "Telekom Malaysia Berhad" },
	{  10305, "Telekom Malaysia Berhad" },
	{  10306, "Telekom Malaysia Berhad" },
	{  10307, "Telekom Malaysia Berhad" },
	{  10308, "U Mobile Sdn Bhd" },
	{  10309, "Telekom Malaysia Berhad" },
	{  10310, "Telekom Malaysia Berhad" },
	{  10311, "Telekom Malaysia Berhad" },
	{  10312, "Celcom (Malaysia) Berhad" },
	{  10313, "Celcom (Malaysia) Berhad" },
	{  10314, "U Mobile Sdn Bhd" },
	{  10315, "U Mobile Sdn Bhd" },
	{  10316, "U Mobile Sdn Bhd" },
	{  10317, "TT dotcom Sdn Bhd" },
	{  10318, "Tune Talk Sdn Bhd" },
	{  10319, "Telekom Malaysia Berhad" },
	{  10320, "Telstra Corporation Ltd" },
	{  10321, "Telstra Corporation Ltd" },
	{  10322, "Telstra Corporation Ltd" },
	{  10323, "Telstra Corporation Ltd" },
	{  10324, "Telstra Corporation Ltd" },
	{  10325, "Telstra Corporation Ltd" },
	{  10326, "Telstra Corporation Ltd" },
	{  10327, "Telstra Corporation Ltd" },
	{  10328, "Optus Ltd" },
	{  10329, "AAPT Ltd" },
	{  10330, "Telstra Corporation Ltd" },
	{  10331, "Telstra Corporation Ltd" },
	{  10332, "Telstra Corporation Ltd" },
	{  10333, "Telstra Corporation Ltd" },
	{  10334, "Telstra Corporation Ltd" },
	{  10335, "Telstra Corporation Ltd" },
	{  10336, "PowerTel Ltd" },
	{  10337, "PowerTel Ltd" },
	{  10338, "PowerTel Ltd" },
	{  10339, "RSLCom Australia Pty. Ltd" },
	{  10340, "IP Systems Pty Ltd" },
	{  10341, "IP Systems Pty Ltd" },
	{  10342, "Telecom New Zealand Australia Pty Ltd" },
	{  10343, "Vodafone Network Pty Ltd" },
	{  10344, "KDD Australia Pty Ltd" },
	{  10345, "WorldCom Australia Pty Ltd" },
	{  10346, "WorldCom Australia Pty Ltd" },
	{  10347, "WorldCom Australia Pty Ltd" },
	{  10348, "WorldCom Australia Pty Ltd" },
	{  10349, "Primus Telecommunications Pty Ltd" },
	{  10350, "Societe Internationale de Telecommunications Aeronautiques (SITA)" },
	{  10351, "BT Australasia PM-F2" },
	{  10352, "PowerTel Ltd" },
	{  10353, "Global One Communications Pty Ltd" },
	{  10354, "BT Australasia Pty Ltd" },
	{  10355, "Norfolk Island Administration (Norfolk Telecom)" },
	{  10356, "Norfolk Island Administration (Norfolk Telecom)" },
	{  10357, "IDT Telecom Asia Pcific (Australia) Pty Ltd" },
	{  10358, "Pacific Gateway Exchange" },
	{  10359, "WorldCom Asia Pacific Limited" },
	{  10360, "AAPT Ltd" },
	{  10361, "Primus Telecommunications Pty Ltd" },
	{  10363, "Globalstar Australia Pty Ltd" },
	{  10364, "AAPT Ltd" },
	{  10365, "AAPT Ltd" },
	{  10366, "AAPT Ltd" },
	{  10367, "AAPT Ltd" },
	{  10368, "Vodafone Pty Ltd" },
	{  10369, "Vodafone Pty Ltd" },
	{  10370, "Vodafone Pty Ltd" },
	{  10371, "Vodafone Pty Ltd" },
	{  10372, "Vodafone Pty Ltd" },
	{  10373, "Vodafone Pty Ltd" },
	{  10374, "AAPT Ltd" },
	{  10375, "AAPT Ltd" },
	{  10376, "Optus Ltd" },
	{  10377, "Optus Ltd" },
	{  10378, "Optus Ltd" },
	{  10379, "Optus Ltd" },
	{  10380, "Cell Wireless Corporation" },
	{  10381, "Vodafone Network Pty Ltd" },
	{  10382, "Globalstar Australia Pty Ltd" },
	{  10383, "Globalstar Australia Pty Ltd" },
	{  10384, "Telstra Corporation Ltd" },
	{  10385, "TaTa  Communications (Australia) Pty Ltd" },
	{  10386, "Net Telephone Marketing Pty Ltd" },
	{  10387, "Net Telephone Marketing Pty Ltd" },
	{  10388, "Net Telephone Marketing Pty Ltd" },
	{  10389, "Net Telephone Marketing Pty Ltd" },
	{  10390, "Net Telephone Marketing Pty Ltd" },
	{  10391, "Net Telephone Marketing Pty Ltd" },
	{  10392, "Optus Ltd" },
	{  10393, "Optus Ltd" },
	{  10394, "Optus Ltd" },
	{  10395, "Optus Ltd" },
	{  10396, "Optus Ltd" },
	{  10397, "Optus Ltd" },
	{  10398, "Optus Ltd" },
	{  10399, "Optus Ltd" },
	{  10400, "PT Indosat (Persero) Tbk." },
	{  10401, "PT Indosat (Persero) Tbk." },
	{  10402, "PT Indosat (Persero) Tbk." },
	{  10403, "PT Indosat (Persero) Tbk." },
	{  10404, "PT Indosat (Persero) Tbk." },
	{  10405, "PT Telkomsel" },
	{  10406, "PT Satelindo" },
	{  10407, "PT Satelindo" },
	{  10408, "PT Indosat (Persero) Tbk." },
	{  10409, "PT Excelkomindo" },
	{  10410, "PT Indosat (Persero) Tbk." },
	{  10411, "PT Indosat (Persero) Tbk." },
	{  10412, "PT Indosat (Persero) Tbk." },
	{  10413, "PT Satelindo" },
	{  10414, "PT Satelindo" },
	{  10415, "PT Satelindo" },
	{  10416, "PT Indosat" },
	{  10417, "PT Indosat - M3" },
	{  10418, "PT Indosat - M3" },
	{  10419, "PT Pasifik Satelit Nusantara" },
	{  10420, "PT Satelindo" },
	{  10421, "PT Satelindo" },
	{  10422, "PT Satelindo" },
	{  10423, "PT Satelindo" },
	{  10424, "PT Telkom" },
	{  10425, "PT Telkom" },
	{  10426, "PT Natrindo Telepon Seluler" },
	{  10427, "PT Indosat" },
	{  10428, "PT Telkom" },
	{  10429, "PT Indosat" },
	{  10430, "PT Telkom" },
	{  10431, "PT Telkom" },
	{  10432, "PT Telekomunikasi Indonesi TBK" },
	{  10433, "PT Telekomunikasi Indonesi TBK" },
	{  10434, "PT Telekomunikasi Indonesi TBK" },
	{  10435, "PT Telekomunikasi Indonesi TBK" },
	{  10436, "PT Telekomunikasi Indonesi TBK" },
	{  10437, "PT Telekomunikasi Indonesi TBK" },
	{  10480, "Isla Communications (ISLACOM)" },
	{  10481, "Philippine Long Distance Telephone Company (PLDT)" },
	{  10482, "Philippine Long Distance Telephone Company (PLDT)" },
	{  10483, "Philippine Long Distance Telephone Company (PLDT)" },
	{  10484, "Philippine Long Distance Telephone Company (PLDT)" },
	{  10485, "Philippine Long Distance Telephone Company (PLDT)" },
	{  10486, "Philippine Global Communications Inc. (PHILCOM)" },
	{  10487, "Philippine Global Communications Inc. (PHILCOM)" },
	{  10488, "Bayantel" },
	{  10489, "Bayantel" },
	{  10490, "Globe Telecom Inc. (GMCR)" },
	{  10491, "Globe Telecom Inc. (GMCR)" },
	{  10492, "Isla Communications (ISLACOM)" },
	{  10493, "CAPWIRE" },
	{  10494, "CAPWIRE" },
	{  10495, "CAPWIRE" },
	{  10496, "SMART" },
	{  10497, "SMART" },
	{  10498, "SMART" },
	{  10499, "SBMA" },
	{  10500, "Isla Communications (ISLACOM)" },
	{  10501, "Isla Communications (ISLACOM)" },
	{  10502, "Globe Telecom Inc. (GMCR)" },
	{  10503, "Isla Communications (ISLACOM)" },
	{  10504, "Philippine Global Communications Inc. (PhilComsat)" },
	{  10505, "Philippine Global Communications Inc. (PhilComsat)" },
	{  10506, "Philippine Global Communications Inc. (PhilComsat)" },
	{  10507, "Nextel" },
	{  10508, "Aces" },
	{  10509, "Aces" },
	{  10510, "Capwire" },
	{  10511, "BellTelecom" },
	{  10512, "ETPI" },
	{  10513, "ETPI" },
	{  10514, "ETPI" },
	{  10515, "Capwire" },
	{  10516, "Digitel" },
	{  10517, "Digitel" },
	{  10518, "Digitel" },
	{  10519, "Capwire" },
	{  10520, "Capwire" },
	{  10521, "Globe Telecom Inc. (GMCR)" },
	{  10522, "Digitel" },
	{  10523, "Globe Telecom Inc. (GMCR)" },
	{  10524, "SMART" },
	{  10525, "Digitel IGF" },
	{  10526, "Digitel IGF" },
	{  10527, "Philippine Global Communications Inc. (PHILCOM)" },
	{  10528, "Philippine Global Communications Inc. (PHILCOM)" },
	{  10529, "Digitel IGF" },
	{  10530, "CURE CMTS" },
	{  10531, "CURE CMTS" },
	{  10532, "SMART" },
	{  10533, "SMART" },
	{  10534, "SMART" },
	{  10535, "SMART" },
	{  10536, "Bayantel" },
	{  10537, "Bayantel" },
	{  10538, "SMART" },
	{  10539, "Digitel" },
	{  10540, "Digitel" },
	{  10541, "Digitel" },
	{  10542, "FIBERTEL/Fiber Telecommunications, Inc." },
	{  10560, "CAT Telecom Public Company Ltd" },
	{  10561, "CAT Telecom Public Company Ltd" },
	{  10562, "CAT Telecom Public Company Ltd" },
	{  10563, "CAT Telecom Public Company Ltd" },
	{  10564, "CAT Telecom Public Company Ltd" },
	{  10565, "CAT Telecom Public Company Ltd" },
	{  10566, "CAT Telecom Public Company Ltd" },
	{  10567, "CAT Telecom Public Company Ltd" },
	{  10568, "DTAC Network Company Ltd" },
	{  10569, "TOT Public Company Ltd" },
	{  10570, "TOT Public Company Ltd" },
	{  10571, "TOT Public Company Ltd" },
	{  10572, "TOT Public Company Ltd" },
	{  10573, "TOT Public Company Ltd" },
	{  10574, "TOT Public Company Ltd" },
	{  10575, "Triple T Global Net Company Ltd" },
	{  10576, "DTAC Network Company Ltd" },
	{  10577, "AIN Globalcom Company Ltd" },
	{  10578, "AIN Globalcom Company Ltd" },
	{  10579, "True International Company Ltd" },
	{  10580, "True International Company Ltd" },
	{  10581, "True International Company Ltd" },
	{  10582, "DTAC Network Company Ltd" },
	{  10583, "DTAC Network Company Ltd" },
	{  10584, "Triple T Global Net Company Ltd" },
	{  10585, "Triple T Global Net Company Ltd" },
	{  10586, "True International Communication Company Ltd" },
	{  10587, "True International Communication Company Ltd" },
	{  10600, "Singapore Telecommunications Ltd" },
	{  10601, "Singapore Telecommunications Ltd" },
	{  10602, "Singapore Telecommunications Ltd" },
	{  10603, "Singapore Telecommunications Ltd" },
	{  10604, "Telekom Malaysia (S) Pte Ltd" },
	{  10605, "Telekom Malaysia (S) Pte Ltd" },
	{  10606, "Grand Pacific Networks Private Ltd" },
	{  10607, "Callforeign Inc Pte Ltd" },
	{  10608, "StarHub Ltd" },
	{  10609, "Singapore Telecommunications Ltd" },
	{  10610, "Singapore Telecommunications Ltd" },
	{  10611, "Singapore Telecommunications Ltd" },
	{  10612, "Singapore Telecommunications Ltd" },
	{  10613, "Singapore Telecommunications Ltd" },
	{  10614, "Singapore Telecommunications Ltd" },
	{  10615, "Singapore Telecommunications Ltd" },
	{  10616, "Fixed & Mobile Pte Ltd" },
	{  10617, "Fixed & Mobile Pte Ltd" },
	{  10618, "Touchtone Pte Ltd" },
	{  10619, "Global Crossing Singapore Pte Ltd" },
	{  10620, "StarHub Ltd" },
	{  10621, "StarHub Ltd" },
	{  10622, "Telecom New Zealand Singapore Pte Ltd" },
	{  10623, "StarHub Ltd" },
	{  10624, "Macquarie Corporate Telecommunications Pte Ltd." },
	{  10625, "Ocean Network Pte Ltd" },
	{  10626, "Bludot Communications Pte Ltd" },
	{  10627, "VSNL International Pte Ltd" },
	{  10628, "MobileOne Ltd" },
	{  10629, "MobileOne Ltd" },
	{  10630, "Asia Netcom Singapore Pte Ltd" },
	{  10631, "China Motion (Singapore) Pte Ltd" },
	{  10632, "StarHub Ltd" },
	{  10633, "StarHub Ltd" },
	{  10634, "VSNL Singapore Ltd" },
	{  10636, "Cable & Wireless Global Pte Ltd" },
	{  10637, "Singapore Smart Telecommunications Pte Ltd." },
	{  10638, "BT Singapore Pte Ltd" },
	{  10639, "Singapore Telecommunications Ltd" },
	{  10640, "Singapore Telecommunications Ltd" },
	{  10641, "Singapore Telecommunications Ltd" },
	{  10642, "Singapore Telecommunications Ltd" },
	{  10643, "Singapore Telecommunications Ltd" },
	{  10644, "Singapore Telecommunications Ltd" },
	{  10645, "Singapore Telecommunications Ltd" },
	{  10646, "Singapore Telecommunications Ltd" },
	{  10647, "Singapore Telecommunications Ltd" },
	{  10648, "Singapore Telecommunications Ltd" },
	{  10649, "Singapore Telecommunications Ltd" },
	{  10650, "Singapore Telecommunications Ltd" },
	{  10651, "Singapore Telecommunications Ltd" },
	{  10652, "Singapore Telecommunications Ltd" },
	{  10653, "Singapore Telecommunications Ltd" },
	{  10654, "PLDT (SG) Pte Ltd" },
	{  10655, "Singapore Telecommunications Ltd" },
	{  10656, "Singapore Telecommunications Ltd" },
	{  10657, "Singapore Telecommunications Ltd" },
	{  10658, "Singapore Telecommunications Ltd" },
	{  10659, "Singapore Telecommunications Ltd" },
	{  10660, "MCI WorldCom" },
	{  10661, "MobileOne (Asia) Pte Ltd" },
	{  10662, "MobileOne (Asia) Pte Ltd" },
	{  10664, "StarHub Ltd" },
	{  10665, "StarHub Ltd" },
	{  10666, "I2U Pte Ltd" },
	{  10667, "Redtone Technology Pte Ltd" },
	{  10668, "ETN Singapore Pte Ltd" },
	{  10669, "MCI WorldCom" },
	{  10670, "France Telecom Long Distance (Singapore)" },
	{  10671, "Tridor Pte Ltd" },
	{  10672, "Asiakomnet Multimedia Pte Ltd" },
	{  10673, "Telekom Malaysia (S) Pte Ltd" },
	{  10674, "Telekom Malaysia (S) Pte Ltd" },
	{  10675, "Itopia.Com Pte Ltd" },
	{  10677, "TelcomUnited (S) Pte Ltd" },
	{  10678, "Phoenix Communications Pte Ltd" },
	{  10679, "SunPage Communications Pte Ltd" },
	{  10680, "ETNS Singapore Pte Ltd" },
	{  10681, "Interconnect Technology Pte Ltd" },
	{  10682, "PLDT (SG) Pte Ltd" },
	{  10683, "Teleone (Singapore)" },
	{  10684, "MobileOne (Asia) Pte Ltd" },
	{  10685, "MobileOne (Asia) Pte Ltd" },
	{  10686, "Singapore Telecommunications Ltd" },
	{  10687, "Macquarie Corporate Telecommunications Pte Ltd." },
	{  10688, "DST Communications Sdn Bhd" },
	{  10689, "Telekom Brunei Berhad" },
	{  10690, "Telekom Brunei Berhad" },
	{  10691, "DST Communications Sdn Bhd" },
	{  10692, "DST Communications Sdn Bhd" },
	{  10693, "Telekom Brunei Berhad" },
	{  10694, "Telekom Brunei Berhad" },
	{  10695, "Telekom Brunei Berhad" },
	{  10720, "Telecom New Zealand" },
	{  10721, "Telecom New Zealand" },
	{  10722, "RSLCom Australia" },
	{  10723, "NZ Communications" },
	{  10724, "Newcall International" },
	{  10725, "Newcall International" },
	{  10726, "Telecom New Zealand" },
	{  10727, "Telecom New Zealand" },
	{  10728, "Compass Communications" },
	{  10729, "TelstraClear" },
	{  10730, "NZ Communications" },
	{  10731, "NZ Communications" },
	{  10732, "Airnet NZ" },
	{  10733, "Telecom New Zealand" },
	{  10734, "CallPlus" },
	{  10735, "Telecom New Zealand" },
	{  10744, "TelstraClear" },
	{  10745, "Vodafone NZ" },
	{  10746, "Vodafone NZ" },
	{  10747, "TelstraClear" },
	{  10748, "TelstraClear" },
	{  10749, "Telecom New Zealand" },
	{  10750, "Telecom New Zealand" },
	{  10751, "Compass Communications" },
	{  10760, "TelstraClear" },
	{  10761, "TelstraClear" },
	{  10762, "TelstraClear" },
	{  10763, "TelstraClear" },
	{  10764, "Global One" },
	{  10765, "Global One" },
	{  10766, "Telecom New Zealand Mobile" },
	{  10767, "Telecom New Zealand Mobile" },
	{  10776, "Vodafone NZ" },
	{  10777, "Vodafone NZ" },
	{  10778, "Worldxchange" },
	{  10779, "Quest Communications" },
	{  10780, "TelstraClear" },
	{  10781, "TelstraClear" },
	{  10782, "Telecom New Zealand" },
	{  10783, "Telecom New Zealand" },
	{  10800, "IT&E Overseas, Inc." },
	{  10801, "Access Telecom" },
	{  10803, "IT&E Overseas, Inc." },
	{  10804, "IT&E Overseas, Inc." },
	{  10805, "TelePacific Networks Inc." },
	{  10818, "Digicel Nauru Ltd" },
	{  10819, "Digicel Nauru Backup" },
	{  10832, "Digicel PNG Ltd" },
	{  10833, "Digicel PNG Ltd" },
	{  10834, "B-Mobile Ltd" },
	{  10835, "Telikom PNG" },
	{  10836, "Telikom PNG" },
	{  10837, "Digicel PNG Ltd" },
	{  10838, "Digicel PNG Ltd" },
	{  10839, "B-Mobile Ltd" },
	{  10842, "Digicel PNG Ltd" },
	{  10864, "Tonga Communications Corporation" },
	{  10869, "Digicel (Tonga) Ltd" },
	{  10896, "Telecom Vanuatu Limited" },
	{  10897, "Telecom Vanuatu Limited" },
	{  10899, "Telecom Vanuatu Limited" },
	{  10902, "Digicel Vanuatu Ltd" },
	{  10903, "Digicel Vanuatu Ltd" },
	{  10912, "Fintel" },
	{  10913, "Fintel" },
	{  10914, "Vodafone Fiji Ltd" },
	{  10915, "Vodafone Fiji Ltd" },
	{  10916, "Vodafone Fiji Ltd" },
	{  10917, "Vodafone Fiji Ltd" },
	{  10918, "Digicel Fiji Ltd" },
	{  10919, "Digicel Fiji Ltd" },
	{  10920, "Fintel" },
	{  10921, "Fintel" },
	{  10922, "Fintel" },
	{  10923, "Fintel" },
	{  10944, "American Samoa Telecommunications Authority (ASTCA)" },
	{  10976, "Office des postes et telecommunications" },
	{  10977, "Office des postes et telecommunications" },
	{  10978, "Office des postes et telecommunications" },
	{  10992, "O.P.T." },
	{  10993, "O.P.T." },
	{  10994, "Tikiphone" },
	{  10995, "Mara Telecom" },
	{  10996, "Digicel Tahiti" },
	{  10997, "Digicel Tahiti" },
	{  11024, "Samoa Communications Ltd." },
	{  11096, "FSM Telecoms (FSMTC)" },
	{  11097, "FSM Telecoms (FSMTC)" },
	{  11144, "Verizon Pacifica" },
	{  11160, "Optus Ltd" },
	{  11161, "Optus Ltd" },
	{  11162, "Optus Ltd" },
	{  11163, "Optus Ltd" },
	{  11164, "Telecorp Ltd" },
	{  11165, "Telecorp Ltd" },
	{  11166, "Telecorp Ltd" },
	{  11167, "Telecorp Ltd" },
	{  11168, "Telecorp Ltd" },
	{  11169, "Transact Communications Pty. Ltd" },
	{  11170, "MiBroadband" },
	{  11171, "MiBroadband" },
	{  11172, "MiBroadband" },
	{  11173, "MiBroadband" },
	{  11174, "Hutchinson 3G Sydney" },
	{  11175, "Hutchinson 3G Melbourne" },
	{  11176, "Primus Telecommunications Pty Ltd" },
	{  11177, "Prodigy Telecom Pty Ltd" },
	{  11178, "Prodigy Telecom Pty Ltd" },
	{  11179, "Alpha Telecom pty" },
	{  11180, "HiTech Telecom Pty Ltd" },
	{  11181, "Tel.Pacific Pty Ltd" },
	{  11182, "Digiplus Pty Ltd" },
	{  11183, "Digiplus Pty Ltd" },
	{  11184, "Asia Netcom Australia Pty Ltd" },
	{  11185, "TaTa  Communications (Australia) Pty Ltd" },
	{  11186, "Tel.Pacific Ltd" },
	{  11187, "Tel.Pacific Ltd" },
	{  11188, "Tel.Pacific Pty Ltd" },
	{  11189, "Tel.Pacific Pty Ltd" },
	{  11190, "Tel.Pacific Pty Ltd" },
	{  11191, "Tel.Pacific Pty Ltd" },
	{  11192, "Tel.Pacific Pty Ltd" },
	{  11193, "Tel.Pacific Pty Ltd" },
	{  11194, "Tel.Pacific Pty Ltd" },
	{  11195, "Tel.Pacific Pty Ltd" },
	{  11196, "Australian Telecoms Exchange Pty. Ltd" },
	{  11197, "Australian Telecoms Exchange Pty. Ltd" },
	{  11198, "IP Systems Pty Ltd" },
	{  11199, "IP Systems Pty Ltd" },
	{  11200, "Tel.Pacific Pty Ltd" },
	{  11201, "Tel.Pacific Pty Ltd" },
	{  11202, "Chime Communications" },
	{  11203, "Chime Communications" },
	{  11204, "IntraPower Terrestrial Pty Ltd" },
	{  11205, "Symbio Networks P/L" },
	{  11206, "Chime Communications" },
	{  11207, "Global Gossip Communications" },
	{  11281, "Timor Telecom, S.A." },
	{  11282, "Timor Telecom, S.A." },
	{  11360, "MobileOne Ltd" },
	{  11361, "MobileOne Ltd" },
	{  11362, "Telekomunikasi Indonesia International Pte Ltd" },
	{  11363, "Epsilon Telecommunications Pte Ltd" },
	{  11365, "Absolute Telecom P/L" },
	{  11366, "Callforeign Inc Pte Ltd" },
	{  11367, "HOIIO Pte LTD" },
	{  12000, "AD T-Mobile" },
	{  12001, "DynacomSouth Dooel" },
	{  12105, "Silknet JSC" },
	{  12112, "iCON Communications" },
	{  12113, "Orange Armenia" },
	{  12114, "Bionet" },
	{  12115, "Crossnet" },
	{  12116, "Dzoraxbyur Hamalir" },
	{  12117, "Netsys" },
	{  12118, "Global Callline" },
	{  12119, "Interactive TV" },
	{  12120, "3G Telecommunications Ltd" },
	{  12121, "Mobisle Communications Ltd" },
	{  12128, "Oteglobe" },
	{  12129, "Oteglobe" },
	{  12130, "Oteglobe" },
	{  12131, "Vodafone" },
	{  12132, "Vodafone" },
	{  12133, "Cosmote" },
	{  12134, "Forthnet" },
	{  12136, "MTN Cyprus Limited" },
	{  12137, "MTN Cyprus Limited" },
	{  12138, "MTN Cyprus Limited" },
	{  12139, "MTN Cyprus Limited" },
	{  12144, "T-Mobile Crna Gora Ltd" },
	{  12145, "T-Mobile Crna Gora Ltd" },
	{  12152, "T-Mobile Netherlands B.V." },
	{  12153, "Orange Nederland N.V." },
	{  12154, "KPN B.V." },
	{  12155, "KPN B.V." },
	{  12156, "Xantic B.V." },
	{  12157, "Barablu Mobile Benelux Ltd." },
	{  12158, "Barablu Mobile Benelux Ltd." },
	{  12160, "Ectel Ltd" },
	{  12161, "Optel Technology Ltd" },
	{  12162, "RCC Com Inc." },
	{  12163, "NetCologne Gesellschaft fur Telekommunikation mbH" },
	{  12164, "Prioritel LLC" },
	{  12165, "Sekom Telecom OY" },
	{  12166, "Telstar Capital Corp." },
	{  12167, "JSC KazTransCom" },
	{  12168, "Bosphocom" },
	{  12169, "Tellcom" },
	{  12170, "Avea" },
	{  12176, "Cosmote Romanian Mobile" },
	{  12177, "Cosmote Romanian Mobile" },
	{  12178, "Fast Corporation" },
	{  12179, "RCS & RDS" },
	{  12180, "RCS & RDS" },
	{  12181, "RCS & RDS" },
	{  12182, "RCS & RDS" },
	{  12183, "RCS & RDS" },
	{  12184, "Hutchison 3G UK Ltd" },
	{  12185, "Hutchison 3G UK Ltd" },
	{  12186, "Telephony Services Ltd" },
	{  12187, "Communications Networking Services (UK)" },
	{  12188, "Communications Networking Services (UK)" },
	{  12189, "Switchware Ltd" },
	{  12190, "Symmetric Quorum Ltd" },
	{  12191, "Linx Telecom" },
	{  12200, "Triangle Communications AG" },
	{  12201, "Ecotel Communication AG" },
	{  12202, "PTT Minex GmbH" },
	{  12203, "Ecoway GmbH" },
	{  12204, "Telco Partners GmbH" },
	{  12205, "reserved for First Telecom GmbH" },
	{  12206, "Pentatel GmbH" },
	{  12207, "Econo Deutschland GmbH" },
	{  12208, "Orange Business Switzerland AG" },
	{  12209, "Orange Business Switzerland AG" },
	{  12210, "TelCommunication Services AG" },
	{  12211, "Swiss Telecom Carrier" },
	{  12212, "Orange Communications SA" },
	{  12213, "Orange Communications SA" },
	{  12214, "Mttel AG" },
	{  12215, "MediaLincc GmbH" },
	{  12216, "Softnet d.o.o." },
	{  12217, "Akton d.o.o." },
	{  12218, "Tusmobil d.o.o." },
	{  12219, "Tusmobil d.o.o." },
	{  12220, "Telekom Slovenije d.d." },
	{  12221, "Tus Telekom d.d." },
	{  12222, "Mobitel d.d." },
	{  12223, "Mobitel d.d." },
	{  12224, "I-21 Ltd" },
	{  12225, "TRA (UK) Ltd" },
	{  12226, "Datapro (proprietary) Ltd" },
	{  12227, "Sabanci Telekomuniasyon Hizmetieri A.S." },
	{  12228, "Vivodi Telecom S.A." },
	{  12229, "Lebara Ltd" },
	{  12230, "Orange" },
	{  12231, "InfoComm Consultancy Ltd" },
	{  12232, "Unistars" },
	{  12233, "Telecom Baltija" },
	{  12234, "Telenet" },
	{  12235, "D-COM" },
	{  12236, "SIA 10 1/2" },
	{  12237, "Telecentrs" },
	{  12238, "Tele2Telecom" },
	{  12239, "Talk Point" },
	{  12240, "IN.LIFE druzba za internet storitve, d.d." },
	{  12241, "IN.LIFE druzba za internet storitve, d.d." },
	{  12242, "IN.LIFE druzba za internet storitve, d.d." },
	{  12243, "T-2 d.o.o." },
	{  12244, "Si.Mobil d.d." },
	{  12245, "Si.Mobil d.d." },
	{  12246, "IT TEL d.o.o." },
	{  12247, "Telekom Slovenije d.d." },
	{  12248, "Bluecom Internet GmbH" },
	{  12249, "Telefonica Deutschland GmbH" },
	{  12250, "Augustakom Telekommunikation GmbH & Co. KG." },
	{  12251, "Infotel BV" },
	{  12252, "Akkay Haustechnik und Handels GmbH" },
	{  12253, "European Telecommunication Holding E.T.H. AG" },
	{  12254, "Tele2 Telecommunication Services GmbH" },
	{  12255, "Tele2 Telecommunication Services GmbH" },
	{  12256, "Telekomunikaciju grupa" },
	{  12257, "Datagrupa 777" },
	{  12258, "IT Group" },
	{  12259, "Latvijas dzelzcels" },
	{  12260, "CSC Telecom" },
	{  12261, "SIA Baltkom TV SIA" },
	{  12262, "SIA Baltkom TV SIA" },
	{  12263, "Finors Telekom" },
	{  12264, "Nordisk Polska Sp. Z.o.o." },
	{  12265, "Exatel S.A." },
	{  12266, "Exatel S.A." },
	{  12267, "Polkomtel S.A." },
	{  12268, "Tele2 Polska Sp. Z.o.o." },
	{  12269, "Telefonia Dialog S.A." },
	{  12270, "Polska Telefonia Cyfrowa Sp. Z.o.o." },
	{  12271, "eTel Polska Sp. Z.o.o." },
	{  12272, "Info Quest" },
	{  12273, "Info Quest" },
	{  12275, "HOL" },
	{  12276, "HOL" },
	{  12277, "WIND" },
	{  12278, "WIND" },
	{  12279, "Teledome" },
	{  12280, "Rete Ferroviaria Italiana S.p.A." },
	{  12281, "Telespazio S.p.A." },
	{  12282, "Elinet S.p.A." },
	{  12283, "Netscalibur S.r.l." },
	{  12284, "Vodafone S.p.A." },
	{  12285, "Vodafone S.p.A." },
	{  12286, "Vodafone S.p.A." },
	{  12287, "Vodafone S.p.A." },
	{  12312, "Etisalat" },
	{  12313, "Etisalat" },
	{  12314, "Etisalat" },
	{  12315, "Etisalat" },
	{  12316, "Etisalat" },
	{  12317, "Etisalat" },
	{  12320, "Telecom Egypt" },
	{  12321, "Telecom Egypt" },
	{  12322, "Mobinil" },
	{  12323, "Mobinil" },
	{  12325, "Vodafone" },
	{  12326, "Vodafone" },
	{  12330, "Etisalat" },
	{  12331, "Etisalat" },
	{  12332, "Telecom Egypt" },
	{  12333, "Telecom Egypt" },
	{  12334, "Telecom Egypt" },
	{  12337, "Algerie Telecom" },
	{  12339, "Algerie Telecom" },
	{  12340, "Algerie Telecom" },
	{  12343, "Algerie Telecom" },
	{  12352, "Itassalat Al-Maghrib" },
	{  12353, "Itassalat Al-Maghrib" },
	{  12354, "Itassalat Al-Maghrib" },
	{  12355, "Itassalat Al-Maghrib" },
	{  12356, "Medi Telecom" },
	{  12357, "Medi Telecom" },
	{  12360, "Itassalat Al-Maghrib" },
	{  12361, "Itassalat Al-Maghrib" },
	{  12362, "Medi Telecom" },
	{  12363, "Medi Telecom" },
	{  12364, "Medi Telecom" },
	{  12368, "Tunisie Telecom" },
	{  12369, "Tunisie Telecom" },
	{  12370, "Tunisie Telecom" },
	{  12371, "Tunisie Telecom" },
	{  12374, "Orascom Telecom Tunisie" },
	{  12375, "Orascom Telecom Tunisie" },
	{  12384, "Libyan International Telecommunication Company (LITC)" },
	{  12385, "Libyan International Telecommunication Company (LITC)" },
	{  12386, "Libyan International Telecommunication Company (LITC)" },
	{  12387, "Libyan International Telecommunication Company (LITC)" },
	{  12388, "Libyan International Telecommunication Company (LITC)" },
	{  12389, "Libyan International Telecommunication Company (LITC)" },
	{  12390, "Libyan International Telecommunication Company (LITC)" },
	{  12391, "Libyan International Telecommunication Company (LITC)" },
	{  12417, "Societe Nationale des Telecommunications du Senegal (SONATEL)" },
	{  12418, "Societe Nationale des Telecommunications du Senegal (SONATEL)" },
	{  12421, "Societe Nationale des Telecommunications du Senegal (SONATEL)" },
	{  12422, "Societe Nationale des Telecommunications du Senegal (SONATEL)" },
	{  12432, "-" },
	{  12433, "Mauritel SA" },
	{  12434, "Mattel SA" },
	{  12435, "Mauritel Mobiles" },
	{  12436, "Mauritel Mobiles" },
	{  12437, "Mauritel SA" },
	{  12438, "Chinguitel SA" },
	{  12439, "Chinguitel SA" },
	{  12464, "Sotelgui" },
	{  12465, "Sotelgui" },
	{  12466, "Intercell Guinee" },
	{  12467, "Sotelgui" },
	{  12468, "Orange Guinee" },
	{  12469, "Orange Guinee" },
	{  12470, "Areeba Guinee" },
	{  12471, "Orange Guinee" },
	{  12472, "Orange Guinee" },
	{  12473, "Orange Guinee" },
	{  12474, "Cellcom Guinee" },
	{  12475, "ARPT" },
	{  12476, "ARPT" },
	{  12477, "Areeba Guinee" },
	{  12478, "Areeba Guinee" },
	{  12479, "Cellcom Guinee" },
	{  12481, "Orange - Cote d'Ivoire" },
	{  12482, "Cote d'Ivoire Telecom" },
	{  12483, "Oricel - Cote d'Ivoire" },
	{  12484, "Comium - Cote d'Ivoire" },
	{  12485, "Arobase Telecom" },
	{  12486, "Atlantique Telecom - Cote d'Ivoire" },
	{  12487, "MTN - Cote d'Ivoire" },
	{  12490, "Cote d'Ivoire Telecom" },
	{  12493, "MTN - Cote d'Ivoire" },
	{  12494, "MTN - Cote d'Ivoire" },
	{  12495, "MTN - Cote d'Ivoire" },
	{  12512, "SONITEL S.A." },
	{  12513, "SAHELCOM" },
	{  12514, "CELTEL NIGER S.A." },
	{  12515, "ATLANTIC TELECOM" },
	{  12516, "SONITEL S.A." },
	{  12518, "Orange Niger S.A." },
	{  12519, "Orange Niger S.A." },
	{  12528, "Togo Telecom" },
	{  12529, "Togo Telecom" },
	{  12530, "Togo Telecom" },
	{  12531, "Togo Telecom" },
	{  12560, "Mauritius Telecom" },
	{  12561, "Mauritius Telecom" },
	{  12562, "Mauritius Telecom" },
	{  12563, "Mauritius Telecom" },
	{  12564, "Emtel Ltd." },
	{  12565, "Emtel Ltd." },
	{  12567, "Mahanagar Telephone (Mauritius)" },
	{  12568, "Mahanagar Telephone (Mauritius)" },
	{  12592, "Sierratel" },
	{  12593, "Zain" },
	{  12594, "Millicom/Tigo" },
	{  12595, "Sierratel" },
	{  12596, "Intergroup" },
	{  12597, "Comium" },
	{  12598, "Africell" },
	{  12599, "Ambitel" },
	{  12600, "Atlas Communication" },
	{  12608, "Ghana Telecommunications Company Ltd" },
	{  12609, "Ghana Telecommunications Company Ltd" },
	{  12610, "Zain Communications Ghana Ltd" },
	{  12611, "Zain Communications Ghana Ltd" },
	{  12612, "MTN Ghana Ltd" },
	{  12613, "Globacom Ghana Ltd" },
	{  12614, "Millicom Ghana Ltd" },
	{  12624, "Nigerian Telecommunications Limited (NITEL)" },
	{  12625, "Nigerian Telecommunications Limited (NITEL)" },
	{  12626, "Nigerian Telecommunications Limited (NITEL)" },
	{  12627, "Starcomms" },
	{  12628, "MTN" },
	{  12629, "MTN" },
	{  12630, "MTN" },
	{  12631, "Prestel" },
	{  12632, "MTN" },
	{  12633, "VEE Networks" },
	{  12634, "VEE Networks" },
	{  12635, "Globacom" },
	{  12636, "Globacom" },
	{  12637, "Globacom" },
	{  12638, "Multi-Links" },
	{  12639, "Intercellular" },
	{  12656, "Reserved" },
	{  12657, "Telecel" },
	{  12658, "Socatel" },
	{  12659, "Orange" },
	{  12660, "Socatel" },
	{  12661, "Moov" },
	{  12662, "Telsoft" },
	{  12663, "Nationlink" },
	{  12672, "Camtel" },
	{  12673, "Camtel" },
	{  12674, "Camtel" },
	{  12675, "MTN Cameroon" },
	{  12676, "MTN Cameroon" },
	{  12677, "Orange Cameroun" },
	{  12678, "Orange Cameroun" },
	{  12679, "Camtel" },
	{  12680, "MTN Cameroon" },
	{  12681, "Orange Cameroun" },
	{  12682, "Orange Cameroun" },
	{  12688, "CV Telecom" },
	{  12689, "T+Telecomunicacoes" },
	{  12690, "T+Telecomunicacoes" },
	{  12691, "CV Telecom" },
	{  12720, "Orange (GETESA)" },
	{  12721, "Orange (GETESA)" },
	{  12722, "Orange (GETESA)" },
	{  12723, "Orange (GETESA)" },
	{  12736, "-" },
	{  12737, "Gabon Telecom" },
	{  12738, "Gabon Telecom" },
	{  12739, "Gabon Telecom" },
	{  12740, "Libertis" },
	{  12741, "Atlantique Telecom" },
	{  12742, "Celtel Gabon" },
	{  12743, "Libertis" },
	{  12744, "Systeme ARTEL" },
	{  12745, "USAN Gabon" },
	{  12746, "USAN Gabon" },
	{  12747, "Systeme ARTEL" },
	{  12748, "Systeme ARTEL" },
	{  12749, "Atlantique Telecom 2" },
	{  12750, "Systeme ARTEL" },
	{  12751, "Systeme ARTEL" },
	{  12768, "Vodacom Congo RDC sprl" },
	{  12769, "Celtel Congo sprl (RDC)" },
	{  12770, "SAIT Telecom" },
	{  12771, "Intercel Congo" },
	{  12772, "Intercel Congo" },
	{  12773, "Intercel Congo" },
	{  12774, "Intercel Congo" },
	{  12775, "Cellco GSM Cellulaire du Congo" },
	{  12776, "Africanus.net Limited/RDC" },
	{  12777, "Vodacom Congo RDC sprl" },
	{  12778, "Vodacom Congo RDC sprl" },
	{  12779, "SAIT Telecom" },
	{  12780, "Office Congolais des Postes et Telecommunications (OCPT)" },
	{  12781, "Vodacom Congo RDC sprl" },
	{  12782, "SAIT Telecom" },
	{  12784, "Angola Telecom" },
	{  12785, "Angola Telecom" },
	{  12786, "Unitel" },
	{  12787, "Unitel" },
	{  12788, "Nexus" },
	{  12789, "spare" },
	{  12790, "Mundo Startel" },
	{  12791, "Mundo Startel" },
	{  12792, "Unitel" },
	{  12816, "Cable and Wireless (Seychelles) Ltd." },
	{  12817, "Cable and Wireless (Seychelles) Ltd." },
	{  12818, "Cable and Wireless (Seychelles) Ltd." },
	{  12820, "Intelvision" },
	{  12821, "Telecom Seychelles Ltd" },
	{  12822, "Telecom Seychelles Ltd" },
	{  12823, "Telecom Seychelles Ltd" },
	{  12832, "Sudanese Telephone Company Ltd. (Sudatel)" },
	{  12833, "Sudanese Telephone Company Ltd. (Sudatel)" },
	{  12834, "Sudanese Telephone Company Ltd. (Sudatel)" },
	{  12835, "Kanartel Co." },
	{  12836, "Kanartel Co." },
	{  12837, "Bashair Telecom Co." },
	{  12838, "Zain (ex Mobitel)" },
	{  12839, "Bashair Telecom Co." },
	{  12840, "Kanartel Co." },
	{  12841, "Kanartel Co." },
	{  12842, "Kanartel Co." },
	{  12843, "Zain (ex Mobitel)" },
	{  12844, "Government of Southern Sudan (GOSS)" },
	{  12845, "Network of World Co (NOW)" },
	{  12846, "Gemtel Co Ltd (GT)" },
	{  12847, "Privet Network NEC" },
	{  12850, "MTN Rwandacell" },
	{  12865, "Ethiopian Telecommunications Corporation" },
	{  12880, "Aerolite" },
	{  12881, "Aerolite" },
	{  12882, "Hormuud Telecom" },
	{  12883, "Telesom Telecom" },
	{  12884, "Golis Telecom" },
	{  12885, "ASGSM MOBI" },
	{  12886, "ASGSM MOBI" },
	{  12887, "Nationlink" },
	{  12912, "Telkom Kenya Ltd" },
	{  12913, "Telkom Kenya Ltd" },
	{  12914, "Safaricom Ltd" },
	{  12915, "Celtel (Kenya) Ltd" },
	{  12916, "Safaricom Ltd" },
	{  12917, "Telkom Kenya Ltd" },
	{  12918, "Celtel (Kenya) Ltd" },
	{  12919, "Econet Wireless Kenya Ltd" },
	{  12928, "Tanzania Telecommunications Company Ltd." },
	{  12929, "Benson Informatics Ltd" },
	{  12930, "MIC (T) Ltd" },
	{  12931, "Zanzibar Telecom Ltd" },
	{  12932, "Vodacom (T) Ltd" },
	{  12933, "Celtel (T) Ltd" },
	{  12934, "Six Telecoms Company Ltd" },
	{  12935, "Zanzibar Telecom Ltd" },
	{  12944, "Uganda Telecom Ltd" },
	{  12945, "Uganda Telecom Ltd" },
	{  12946, "Celtel Uganda Ltd (Zain)" },
	{  12947, "MTN Uganda Ltd" },
	{  12948, "MTN Uganda Ltd" },
	{  12949, "MTN Uganda Ltd" },
	{  12950, "Celtel Uganda Ltd (Zain)" },
	{  12951, "Celtel Uganda Ltd (Zain)" },
	{  12952, "Uganda Telecom Ltd" },
	{  12953, "Warid Telecom Uganda Ltd" },
	{  12954, "Warid Telecom Uganda Ltd" },
	{  12955, "Warid Telecom Uganda Ltd" },
	{  12956, "Warid Telecom Uganda Ltd" },
	{  12957, "House of Integrated Technology & Systems (U) Ltd" },
	{  12958, "House of Integrated Technology & Systems (U) Ltd" },
	{  12959, "House of Integrated Technology & Systems (U) Ltd" },
	{  12960, "ONATEL" },
	{  12961, "UCOM" },
	{  12963, "LACELL" },
	{  12964, "ONAMOB" },
	{  12965, "HITS Telecom" },
	{  12966, "AFRICELL" },
	{  12967, "ECONET" },
	{  12976, "Telecomunicacoes de Mocambique" },
	{  12980, "VM sarl" },
	{  12981, "VM sarl" },
	{  12982, "Mozambique Celular- mCel" },
	{  12983, "Telecomunicacoes de Mocambique" },
	{  13008, "Zamtel" },
	{  13009, "Zamcell" },
	{  13010, "Zamtel" },
	{  13011, "MTN Zambia" },
	{  13024, "Celtel Madagascar GSM" },
	{  13025, "Telecom Malagasy (fixe)" },
	{  13026, "Orange Madagascar GSM" },
	{  13028, "Gulfsat Madagascar VSAT" },
	{  13029, "Intercel Madagascar AMPS" },
	{  13030, "Celtel Madagascar GSM" },
	{  13031, "Celtel Madagascar GSM" },
	{  13032, "Telecom Malagasy Mobile GSM" },
	{  13040, "Guet@li Haut-Debit" },
	{  13041, "SRR" },
	{  13056, "TelOne (Pvt) Ltd" },
	{  13057, "TelOne (Pvt) Ltd" },
	{  13058, "NetOne (Pvt) Ltd" },
	{  13060, "TelOne (Pvt) Ltd" },
	{  13062, "TelOne (Pvt) Ltd" },
	{  13064, "Econet Wireless" },
	{  13067, "Telecel Zimbabwe" },
	{  13072, "Telecom Namibia Ltd." },
	{  13073, "Mobile Telecommunications Ltd." },
	{  13075, "Telecom Namibia Ltd." },
	{  13104, "Telecom Lesotho pty Ltd." },
	{  13108, "Econet EZI - CEL Lesotho" },
	{  13109, "Econet EZI - CEL Lesotho" },
	{  13110, "Vodacom Lesotho (pty) ltd." },
	{  13120, "Botswana Telecommunications Corporation" },
	{  13121, "Botswana Telecommunications Corporation" },
	{  13122, "Mascom Wireless" },
	{  13123, "Orange Botswana" },
	{  13124, "Orange Botswana" },
	{  13136, "Swaziland Posts & Telecommunications Co. (SPTC)" },
	{  13137, "Swaziland Posts & Telecommunications Co. (SPTC)" },
	{  13168, "Telkom S.A. Ltd" },
	{  13169, "Telkom S.A. Ltd" },
	{  13170, "Telkom S.A. Ltd" },
	{  13171, "Telkom S.A. Ltd" },
	{  13172, "Telkom S.A. Ltd" },
	{  13173, "Mobile Telephone Networks" },
	{  13174, "Vodacom Pty Ltd" },
	{  13175, "ICO" },
	{  13176, "Sentech (Pty) Ltd" },
	{  13177, "Cell C (Pty) Ltd" },
	{  13178, "Cell C (Pty) Ltd" },
	{  13179, "Vodacom Pty Ltd" },
	{  13180, "Vodacom Pty Ltd" },
	{  13181, "Mobile Telephone Networks" },
	{  13182, "Telkom S.A. Ltd" },
	{  13183, "Sentech (Pty) Ltd" },
	{  13184, "Vodacom Pty Ltd" },
	{  13185, "SNO Telecommunications" },
	{  13186, "SNO Telecommunications" },
	{  13187, "Cell C (Pty) Ltd" },
	{  13188, "Cell C (Pty) Ltd" },
	{  13189, "Cell C (Pty) Ltd" },
	{  13190, "Cell C (Pty) Ltd" },
	{  13191, "Cell C (Pty) Ltd" },
	{  13201, "Eritel Corporation" },
	{  13328, "Smile Communications (U) Ltd" },
	{  13329, "i-TEL Ltd" },
	{  13332, "Smile Communications (U) Ltd" },
	{  13333, "Celtel Uganda Ltd (Zain)" },
	{  13334, "Celtel Uganda Ltd (Zain)" },
	{  14048, "NOV Operator" },
	{  14049, "Cosmofon" },
	{  14050, "Cosmofon" },
	{  14051, "Matel MK" },
	{  14052, "On-net Skopje" },
	{  14053, "AD T-Mobile" },
	{  14054, "AD T-Mobile" },
	{  14055, "AD T-Mobile" },
	{  14160, "Vodafone Czech Republic a.s." },
	{  14161, "Vodafone Czech Republic a.s." },
	{  14168, "TELKO d.o.o." },
	{  14169, "Akcentis d.o.o." },
	{  14170, "Si.Mobil d.d." },
	{  14171, "Si.Mobil d.d." },
	{  14195, "Digitel Mobile Srl" },
	{  14196, "Infobip Ltd" },
	{  14197, "Infobip Ltd" },
	{  14198, "Infobip Ltd" },
	{  14199, "Infobip Ltd" },
	{  14216, "Telesystems of Ukraine" },
	{  14217, "LLC Global Message Services Ukraine" },
	{  14218, "Closed joint stock company Technological Systems" },
	{  14219, "LLC Global Message Services Ukraine" },
	{  14223, "Ukrvincom Private Enterprise (VNCM)" },
	{  14224, "Eircom UK Ltd" },
	{  14225, "Inclarity plc" },
	{  14226, "SG Networks Ltd" },
	{  14227, "Spacetel UK Ltd" },
	{  14228, "Spacetel UK Ltd" },
	{  14229, "V1 Telecom Ltd" },
	{  14230, "Mtelecom Ltd" },
	{  14231, "Whitebarn Ltd" },
	{  14232, "IceCell ehf" },
	{  14233, "IceCell ehf" },
	{  14234, "Nova ehf" },
	{  14235, "Nova ehf" },
	{  14236, "Amitelo AG" },
	{  14237, "Amitelo AG" },
	{  14240, "BT Espana, S.A.U." },
	{  14241, "BT Espana, S.A.U." },
	{  14242, "Least Cost Routing S.L." },
	{  14243, "Retevision Movil, S.A.U." },
	{  14244, "Retevision Movil, S.A.U." },
	{  14245, "Xtra Telecom, S.A." },
	{  14246, "Catalana de Telecomunicaciones, S.A." },
	{  14247, "Xtra Telecom, S.A." },
	{  14248, "Telespazio S.p.A." },
	{  14249, "Rawal Telecom s.r.l." },
	{  14250, "Rawal Telecom s.r.l." },
	{  14251, "Fastweb S.p.A." },
	{  14252, "Alcotek S.p.A." },
	{  14253, "Fastweb S.p.A." },
	{  14254, "Interoute S.p.A." },
	{  14255, "Uno Communications S.p.A." },
	{  14256, "ntl Communications (Ireland) Ltd." },
	{  14257, "Meteor Communications Ltd." },
	{  14258, "Swiftcall" },
	{  14259, "O2 Ireland" },
	{  14260, "O2 Ireland" },
	{  14261, "O2 Ireland" },
	{  14262, "O2 Ireland" },
	{  14264, "Eurocom Cable" },
	{  14265, "BTC Mobile" },
	{  14266, "Cosmo Bulgaria Mobile" },
	{  14267, "Bulgaria Telecom Net" },
	{  14268, "SKAT TV" },
	{  14269, "ITD Network" },
	{  14272, "Globals Telekoms" },
	{  14273, "TG Transit" },
	{  14274, "LEXICOM" },
	{  14275, "Master Telecom" },
	{  14276, "Telecom Baltija" },
	{  14277, "Telecom Baltija" },
	{  14278, "Telecom Baltija" },
	{  14279, "Bite Mobile" },
	{  14280, "KPN Telecom B.V." },
	{  14281, "Tele2 (Netherlands) B.V." },
	{  14282, "Budget Phone Company B.V." },
	{  14283, "Budget Phone Company B.V." },
	{  14284, "KPN Mobile The Netherlands B.V." },
	{  14285, "KPN Mobile The Netherlands B.V." },
	{  14286, "KPN Telecom B.V." },
	{  14287, "Priority Telecom Netherlands B.V." },
	{  14288, "Mobiltel" },
	{  14289, "East Telecommunication Company" },
	{  14290, "Netplus" },
	{  14291, "Nexcom Bulgaria" },
	{  14292, "Globaltech Bulgaria" },
	{  14293, "Vestitel" },
	{  14294, "Trans Telecom" },
	{  14296, "DIGI Telecommunication Ltd" },
	{  14297, "GTS Datanet Telecommunications Ltd." },
	{  14298, "Vodafone Hungary Ltd" },
	{  14299, "Vodafone Hungary Ltd" },
	{  14301, "Actel Telecommunication Ltd" },
	{  14302, "Invitel Ltd" },
	{  14303, "Triotel Telecommunications Ltd" },
	{  14304, "Opal Telecom Ltd." },
	{  14305, "Opal Telecom Ltd" },
	{  14306, "Inmarsat Ltd" },
	{  14307, "Samitel Ltd" },
	{  14308, "Cheers International Sales Ltd" },
	{  14309, "Vox Mundi d.o.o." },
	{  14310, "Bestway Communications Ltd" },
	{  14311, "Gateway Communications (UK) Ltd" },
	{  14312, "T-2 d.o.o." },
	{  14313, "IT TEL d.o.o." },
	{  14314, "Mobik d.o.o." },
	{  14315, "Mobitel Telekomunikacijske storitve d.d." },
	{  14316, "Mobitel Telekomunikacijske storitve d.d." },
	{  14317, "Amis d.o.o." },
	{  14318, "T-2 d.o.o." },
	{  14319, "SI.Mobil telekomunikacijske storitve, d.d." },
	{  14320, "Monogram Telecom Ltd" },
	{  14321, "Monogram Telecom Ltd" },
	{  14322, "WorldHub Ltd" },
	{  14323, "WorldHub Ltd" },
	{  14324, "NEO Telecom Ltd" },
	{  14325, "Business Service Provision Company Ltd." },
	{  14326, "Ntework Brokers Ltd" },
	{  14327, "Callworld UK Ltd" },
	{  14328, "Stratos Global Ltd" },
	{  14329, "Mapesbury Communications Ltd" },
	{  14330, "Orange" },
	{  14331, "Orange" },
	{  14332, "Global Quest Communications Ltd" },
	{  14333, "O2 (UK) Ltd" },
	{  14334, "O2 (UK) Ltd" },
	{  14335, "IDT Global Ltd" },
	{  14368, "Belize Telecommunication Ltd." },
	{  14369, "Belize Telecommunication Ltd." },
	{  14370, "Belize Telecommunication Ltd." },
	{  14371, "International Telecommunications Ltd. (INTELCO)" },
	{  14372, "International Telecommunications Ltd. (INTELCO)" },
	{  14373, "International Telecommunications Ltd. (INTELCO)" },
	{  14400, "Cablenet S.A." },
	{  14401, "Comunicaciones Celulares S.A." },
	{  14402, "Telecomunicaciones de Guatemala S.A." },
	{  14403, "Telecomunicaciones de Guatemala S.A." },
	{  14404, "AT&T Servicios de Comunicaciones Guatemala S.A." },
	{  14405, "Americatel Guatemala, S.A." },
	{  14406, "Telefonica Moviles Guatemala S.A." },
	{  14407, "Telefonica Moviles Guatemala S.A." },
	{  14408, "Comunicaciones Celulares S.A." },
	{  14409, "AT&T Servicios de Comunicaciones Guatemala S.A." },
	{  14410, "Comunicaciones Celulares S.A." },
	{  14411, "Servicios de Comunicaciones Personales Inalambricas S.A." },
	{  14412, "Servicios de Comunicaciones Personales Inalambricas S.A." },
	{  14413, "Servicios de Comunicaciones Personales Inalambricas S.A." },
	{  14414, "Comunicaciones Celulares S.A." },
	{  14415, "Telefonica Moviles Guatemala S.A." },
	{  14432, "CTE, S.A. de C.V." },
	{  14433, "CTE, S.A. de C.V." },
	{  14434, "CTE, S.A. de C.V." },
	{  14435, "CTE Telecom Personal, S.A. de C.V." },
	{  14436, "Telefonica El Salvador, S.A. de C.V." },
	{  14437, "El Salvador Network S.A." },
	{  14438, "Telemovil El Salvador, S.A." },
	{  14439, "Americatel El Salvador" },
	{  14440, "Telefonica El Salvador, S.A. de C.V." },
	{  14441, "Digicel, S.A. de C.V." },
	{  14442, "AESTEL Salvadorena y Cia, S. en C. de C.V." },
	{  14443, "El Salvador Telecom, S.A. de C.V." },
	{  14444, "GCA Telecom, S.A. de C.V." },
	{  14445, "Telecomunicaciones de America S.A. de C.V." },
	{  14446, "El Salvador Telecom, S.A. de C.V." },
	{  14447, "Americana de Telecomunicaciones S.A. de C.V." },
	{  14448, "Telefonica Moviles El Salvador, S.A. de C.V." },
	{  14449, "Telemovil El Salvador, S.A." },
	{  14450, "Sky Technologies de El Salvador, S.A. de C.V." },
	{  14451, "CTE, S.A. de C.V." },
	{  14452, "CTE, S.A. de C.V." },
	{  14453, "Telefonica Moviles El Salvador, S.A. de C.V." },
	{  14454, "Telefonica Moviles El Salvador, S.A. de C.V." },
	{  14455, "Telemovil El Salvador, S.A." },
	{  14456, "Telemovil El Salvador, S.A." },
	{  14457, "Digicel, S.A. de C.V." },
	{  14464, "Sercom" },
	{  14465, "Empresa Hondurena de Telecomunicaciones (HONDUTEL)" },
	{  14466, "Celtel" },
	{  14467, "Sercom" },
	{  14468, "Empresa Hondurena de Telecomunicaciones (HONDUTEL)" },
	{  14469, "Celtel" },
	{  14470, "Sercom" },
	{  14471, "Sercom" },
	{  14472, "Digicel" },
	{  14473, "Digicel" },
	{  14474, "Digicel" },
	{  14475, "Digicel" },
	{  14476, "Digicel" },
	{  14477, "Digicel" },
	{  14496, "ENITEL, S.A." },
	{  14497, "ENITEL, S.A." },
	{  14498, "SERCOM, S.A." },
	{  14499, "ENITEL, S.A." },
	{  14501, "Telefonia Celular de Nicaragua - (Bellsouth)" },
	{  14503, "Globalstar Nicaragua, S.A." },
	{  14545, "Digicel Panama S.A." },
	{  14546, "Digicel Panama S.A." },
	{  14547, "Telecomunicaciones NetUno de Panama SA" },
	{  14548, "Cable and Wireless Panama S.A." },
	{  14549, "Telecomunicaciones Corporativas Panamenas S.A." },
	{  14552, "Digicel Panama S.A." },
	{  14553, "Telecarrier Inc." },
	{  14554, "Panamerican Wireless S.A." },
	{  14555, "Convergia Panama SA" },
	{  14556, "Perfect Image Inc" },
	{  14557, "Claro Panama S.A." },
	{  14558, "Claro Panama S.A." },
	{  14559, "Digicel Panama S.A." },
	{  14560, "Digicel MG INT" },
	{  14561, "Cable and Wireless Panama S.A." },
	{  14562, "Cable and Wireless Panama S.A." },
	{  14563, "Cable and Wireless Panama S.A." },
	{  14564, "BSC de Panama" },
	{  14565, "VoIP Comunicaciones de Panama" },
	{  14566, "Galaxy Communications Network S.A." },
	{  14567, "Cable Onda S.A." },
	{  14568, "Cable and Wireless Panama S.A." },
	{  14569, "Advanced Communication Network, S.A." },
	{  14570, "System One World Communication Network, S.A." },
	{  14571, "Telecarrier Inc." },
	{  14572, "Claro Panama S.A." },
	{  14573, "NxGentel de Panama S.A." },
	{  14574, "Corporacion Continental de Desarrollo S.A." },
	{  14575, "Optynex Telecom, S.A." },
	{  14576, "Digicel MG INT" },
	{  14577, "Digicel MG INT" },
	{  14578, "Telecarrier Inc." },
	{  14579, "TNR Holdings, Inc." },
	{  14580, "Digicel MG INT" },
	{  14581, "Worldwide Telecom, S.A." },
	{  14582, "IFX Networks Panama" },
	{  14583, "Advanced Communication Network, S.A." },
	{  14584, "Skycom Communications, SA" },
	{  14585, "Convergia Panama SA" },
	{  14586, "Telemax Enterprises Inc." },
	{  14587, "Telefonica Moviles de Panama" },
	{  14588, "Telefonica Moviles de Panama" },
	{  14589, "ASN2P, S.A." },
	{  14590, "Telefonica Moviles de Panama" },
	{  14591, "Cable and Wireless Panama S.A." },
	{  14592, "Telefonica Moviles S.A." },
	{  14593, "Telefonica del Peru S.A.A." },
	{  14594, "Telefonica del Peru S.A.A." },
	{  14595, "Telefonica del Peru S.A.A." },
	{  14596, "Telefonica Moviles S.A." },
	{  14597, "Telmex Peru S.A." },
	{  14598, "Gilat To Home S.A." },
	{  14599, "Ormeno Comunicaciones S.A." },
	{  14600, "Infoductos y Telecomunicaciones del Peru S.A." },
	{  14601, "Gamacom S.R.L." },
	{  14602, "Compania Telefonica Andina S.A." },
	{  14603, "Full Line S.A." },
	{  14605, "Biper Express S.A.C." },
	{  14607, "Americatel Peru S.A." },
	{  14608, "Impsat Peru S.A." },
	{  14609, "Telefonica Moviles S.A." },
	{  14610, "Telefonica Moviles S.A." },
	{  14611, "Telefonica Moviles S.A." },
	{  14612, "Telefonica Moviles S.A." },
	{  14613, "Convergia S.A." },
	{  14614, "Telefonica Moviles S.A." },
	{  14615, "1910 S.A." },
	{  14616, "Vitcom Peru  S.A." },
	{  14617, "Telefonica Moviles S.A." },
	{  14618, "Telefonica Moviles S.A." },
	{  14619, "Telefonica Moviles S.A." },
	{  14620, "System One World Communication Peru S.A." },
	{  14621, "Perusat S.A." },
	{  14622, "Elnath S.A." },
	{  14623, "Impsat Peru S.A." },
	{  14624, "Impsat Peru S.A." },
	{  14625, "Ditel Corporation S.A.C." },
	{  14626, "America Movil Peru S.A.C." },
	{  14627, "Orbita Peru S.A.C." },
	{  14628, "Telmex Peru S.A." },
	{  14629, "Secostelecomunicaciones S.A.C." },
	{  14630, "TE.S.A.M. Peru S.A." },
	{  14631, "Americatel Peru S.A." },
	{  14632, "CIFSA Telecom S.A.C." },
	{  14633, "IDT Peru srl" },
	{  14635, "American Telecom Services S.A.C." },
	{  14636, "DD Conexion Peru S.A." },
	{  14637, "Comsat Peru" },
	{  14638, "Impsat Peru S.A." },
	{  14639, "TE.S.A.M. Peru srl" },
	{  14640, "LA & C Sistemas S.A." },
	{  14641, "Telefonica del Peru S.A.A." },
	{  14642, "IDT Peru srl" },
	{  14643, "Americatel Peru S.A." },
	{  14644, "America Movil Peru srl" },
	{  14645, "America Movil Peru srl" },
	{  14646, "Miguel Percy Montalvo Moreno" },
	{  14664, "Impsat S.A." },
	{  14665, "Impsat S.A." },
	{  14666, "Telefonica Comunicaciones Personales S.A." },
	{  14667, "Telefonica Comunicaciones Personales S.A." },
	{  14668, "Telecom Argentina S.A." },
	{  14669, "Cableway S.A." },
	{  14670, "Comte Communications Technology S.A." },
	{  14672, "Tecoar S.A." },
	{  14673, "Red Alternativa S.A." },
	{  14674, "Telecom Personal S.A." },
	{  14675, "Telecom Personal S.A." },
	{  14676, "Techtel LMDS Comunicaciones Interactivas S.A." },
	{  14677, "AT&T Argentina S.A." },
	{  14678, "AT&T Argentina S.A." },
	{  14679, "AT&T Argentina S.A." },
	{  14680, "Nodalis s.p.a." },
	{  14681, "DKA S.A." },
	{  14682, "IDT Corporation de Argentina S.A." },
	{  14683, "Wilson Construcciones S.A." },
	{  14684, "GC SAC Argentina s.r.l." },
	{  14685, "Infonexion Argentina S.A." },
	{  14686, "Colubris S.A." },
	{  14687, "Telesmart S.A." },
	{  14688, "Telecom Argentina STET France Telecom S.A." },
	{  14689, "Telefonica Larga Distancia de Argentina S.A. (TLDA)" },
	{  14690, "Telecom Argentina STET France Telecom S.A." },
	{  14691, "Telefonica Larga Distancia de Argentina S.A. (TLDA)" },
	{  14692, "Telecom Argentina STET France Telecom S.A." },
	{  14693, "Telefonica Larga Distancia de Argentina S.A. (TLDA)" },
	{  14694, "Telecom Argentina STET France Telecom S.A." },
	{  14695, "Telefonica Larga Distancia de Argentina S.A. (TLDA)" },
	{  14696, "Compania de Telefonos Del Plata S.A." },
	{  14697, "Compania de Telefonos Del Plata S.A." },
	{  14698, "Compania de Telefonos Del Plata S.A." },
	{  14699, "Compania de Telecomunicaciones Integrales S.A." },
	{  14700, "Compania de Telecomunicaciones Integrales S.A." },
	{  14701, "Compania de Telecomunicaciones Integrales S.A." },
	{  14702, "Compania de Telecomunicaciones Integrales S.A." },
	{  14703, "Orbistel S.A." },
	{  14704, "AT&T Argentina S.A." },
	{  14705, "AT&T Argentina S.A." },
	{  14706, "Superfone S.A." },
	{  14707, "SES Sistemas Electronicos S.A." },
	{  14708, "Techtel S.A." },
	{  14709, "Metrored Telecomunicaciones S.A." },
	{  14710, "Impsat S.A." },
	{  14711, "Impsat S.A." },
	{  14712, "Diveo Argentina S.A." },
	{  14713, "Diveo Argentina S.A." },
	{  14714, "Comsat Argentina S.A." },
	{  14715, "Comsat Argentina S.A." },
	{  14716, "NSS S.A." },
	{  14717, "TTN S.A." },
	{  14718, "Embratel Internacional S.A." },
	{  14719, "Convergia Argentina S.A." },
	{  14720, "Vivo" },
	{  14721, "Empresa Brasileira de Telecomunicacoes" },
	{  14722, "Transit" },
	{  14723, "Primeira Escolha" },
	{  14724, "Empresa Brasileira de Telecomunicacoes" },
	{  14725, "Claro" },
	{  14726, "Claro" },
	{  14727, "Telefonica" },
	{  14728, "Intelig" },
	{  14729, "Intelig" },
	{  14730, "Brasil Telecom" },
	{  14731, "Telemig Celular" },
	{  14732, "Telemig Celular" },
	{  14733, "Globalstar Brasil" },
	{  14734, "Intelig" },
	{  14735, "Intelig" },
	{  14736, "Telefonica" },
	{  14737, "Empresa Brasileira de Telecomunicacoes" },
	{  14738, "Globalstar Brasil" },
	{  14739, "Empresa Brasileira de Telecomunicacoes" },
	{  14740, "TNL PCS - Oi" },
	{  14741, "Brasil Telecom" },
	{  14742, "Telefonica" },
	{  14743, "Telefonica" },
	{  14744, "TIM" },
	{  14745, "TNL PCS - Oi" },
	{  14746, "TNL PCS - Oi" },
	{  14747, "TIM" },
	{  14748, "AT&T" },
	{  14749, "Brasil Telecom" },
	{  14750, "Brasil Telecom" },
	{  14751, "Brasil Telecom" },
	{  14752, "Brasil Telecom" },
	{  14753, "Vivo" },
	{  14754, "Telefonica" },
	{  14755, "Telemig Celular" },
	{  14756, "TNL PCS - Oi" },
	{  14757, "Telemig Celular" },
	{  14758, "Telemig Celular" },
	{  14759, "Transit" },
	{  14760, "Vivo" },
	{  14761, "TNL PCS - Oi" },
	{  14762, "TNL PCS - Oi" },
	{  14763, "TNL PCS - Oi" },
	{  14764, "Vivo" },
	{  14765, "CTBC Celular" },
	{  14766, "TIM" },
	{  14767, "TIM" },
	{  14769, "TIM" },
	{  14770, "TIM" },
	{  14771, "CTBC Celular" },
	{  14772, "TNL PCS - Oi" },
	{  14773, "Brasil Telecom" },
	{  14774, "Brasil Telecom" },
	{  14808, "Compania de Telecomunicaciones de Chile Transmisiones Regionales S.A." },
	{  14809, "Compania de Telecomunicaciones de Chile Transmisiones Regionales S.A." },
	{  14810, "IFX Larga Distancia Chile S.A." },
	{  14811, "Telecomunicaciones Las Perdices S.A." },
	{  14812, "Telephone2 S.A." },
	{  14813, "TransAm S.A." },
	{  14816, "CTC Transmisiones Regionales, S.A." },
	{  14817, "Chilesat S.A." },
	{  14818, "Empresa Nacional de Telecomunicaciones S.A. (ENTEL-CHILE)" },
	{  14819, "Empresa Nacional de Telecomunicaciones S.A. (ENTEL-CHILE)" },
	{  14820, "V.T.R. Telecomunicaciones S.A." },
	{  14821, "Bellsouth Chile S.A." },
	{  14822, "Compania de Telefonos de Chile - Mundo S.A." },
	{  14823, "IUSATEL Chile S.A." },
	{  14824, "CTC Transmisiones Regionales, S.A." },
	{  14825, "Manquehue Telecomunicaciones Larga Distancia" },
	{  14826, "AT&T Chile S.A." },
	{  14827, "PTT Chile S.A." },
	{  14828, "Bellsouth Chile S.A." },
	{  14829, "Bellsouth Chile S.A." },
	{  14830, "Entel S.A." },
	{  14831, "Entel S.A." },
	{  14832, "Inversiones y Comunicaciones S.A." },
	{  14833, "World Change Communications S.A." },
	{  14834, "Inversiones y Comunicaciones S.A." },
	{  14835, "The Telephone Company S.A." },
	{  14836, "Entel S.A." },
	{  14837, "Global One Communications S.A." },
	{  14838, "Sur Comunicaciones S.A." },
	{  14839, "Conexion Chile S.A." },
	{  14848, "Empresa Nacional de Telecomunicaciones" },
	{  14849, "Empresa Nacional de Telecomunicaciones" },
	{  14850, "Empresa Nacional de Telecomunicaciones" },
	{  14851, "Empresa Nacional de Telecomunicaciones" },
	{  14852, "Orbitel" },
	{  14853, "Orbitel" },
	{  14854, "E.T.B. (Empresa de telecomunicaciones de Santafe de Bogota)" },
	{  14855, "E.T.B. (Empresa de telecomunicaciones de Santafe de Bogota)" },
	{  14856, "Colombia Telecomunicaciones S.A. ESP" },
	{  14857, "Colombia Telecomunicaciones S.A. ESP" },
	{  14858, "Orbitel S.A. ESP" },
	{  14859, "Telefonica Moviles Colombia S.A." },
	{  14860, "Telefonica Moviles Colombia S.A." },
	{  14861, "Avantel S.A." },
	{  14862, "Avantel S.A." },
	{  14863, "Avantel S.A." },
	{  14864, "Infracel S.A. ESP" },
	{  14865, "Infracel S.A. ESP" },
	{  14866, "Telmex Colombia S.A." },
	{  14870, "Colombia Movil S.A. ESP" },
	{  14871, "Colombia Movil S.A. ESP" },
	{  14880, "Telcel Celular, C.A." },
	{  14881, "Compania Anonima Nacional Telefonos de Venezuela (CANTV)" },
	{  14882, "Compania Anonima Nacional Telefonos de Venezuela (CANTV)" },
	{  14883, "Compania Anonima Nacional Telefonos de Venezuela (CANTV)" },
	{  14884, "Telcel Celular, C.A." },
	{  14885, "TESAM de Venezuela, C.A." },
	{  14886, "Corporacion Digitel, C.A." },
	{  14887, "Infonet Redes de Informacion, C.A." },
	{  14888, "Digicel, C.A." },
	{  14889, "Telcel Celular, C.A." },
	{  14890, "Telecomunicaciones NGTV, S.A. (new Global Telecom)" },
	{  14891, "Veninfotel Comunicaciones Vitcom, C.A." },
	{  14892, "Compania Anonima Nacional Telefonos de Venezuela (CANTV)" },
	{  14893, "Compania Anonima Nacional Telefonos de Venezuela (CANTV)" },
	{  14894, "Entel Venezuela, C.A." },
	{  14895, "Entel Venezuela, C.A." },
	{  14896, "LDTeleCom Comunicaciones, C.A." },
	{  14897, "Convergia Venezuela, SA" },
	{  14898, "Convergia Venezuela, SA" },
	{  14899, "Veninfotel Comunicaciones Vitcom, C.A." },
	{  14900, "Corporacion Telemig CA (INTERCABLE)" },
	{  14901, "Telcel Celular, C.A." },
	{  14902, "Multiphone Venezuela C.A." },
	{  14903, "Compania Anonima Nacional Telefonos de Venezuela (CANTV)" },
	{  14904, "Telecomunicaciones Movilnet, CA" },
	{  14905, "Telecomunicaciones Movilnet, CA" },
	{  14906, "Corporacion Digitel, C.A." },
	{  14907, "Corporacion Digitel, C.A." },
	{  14908, "Veninfotel Comunicaciones Vitcom, C.A." },
	{  14912, "ENTEL S.A." },
	{  14913, "ENTEL S.A." },
	{  14914, "Teledata S.A." },
	{  14915, "ENTEL S.A." },
	{  14916, "AES Communications Bolivia S.A." },
	{  14917, "ENTEL S.A." },
	{  14918, "Teledata S.A." },
	{  14919, "AES Communications Bolivia S.A." },
	{  14920, "BOLIVIATEL SA" },
	{  14921, "BOLIVIATEL SA" },
	{  14922, "BOLIVIATEL SA" },
	{  14923, "Nuevatel" },
	{  14924, "Nuevatel" },
	{  14925, "Nuevatel" },
	{  14926, "COTEL LTDA" },
	{  14927, "COTEL LTDA" },
	{  14928, "COTEL LTDA" },
	{  14929, "UTECOM SA" },
	{  14930, "TELECEL SA" },
	{  14931, "UNETE LTDA" },
	{  14932, "COTAS LTDA" },
	{  14933, "Transmedes S.A." },
	{  14934, "Transmedes S.A." },
	{  14935, "Transmedes S.A." },
	{  14936, "Hablando Todos s.r.l." },
	{  14937, "Hablando Todos s.r.l." },
	{  14938, "Hablando Todos s.r.l." },
	{  14939, "Bolitel s.r.l." },
	{  14940, "Bolitel s.r.l." },
	{  14941, "Bolitel s.r.l." },
	{  14942, "ENTEL S.A." },
	{  14943, "ENTEL S.A." },
	{  14944, "Guyana Telephone and Telegraph Co. Ltd." },
	{  14945, "Guyana Telephone and Telegraph Co. Ltd." },
	{  14946, "Guyana Telephone and Telegraph Co. Ltd." },
	{  14947, "Guyana Telephone and Telegraph Co. Ltd." },
	{  14948, "Guyana Telephone and Telegraph Co. Ltd." },
	{  14949, "Guyana Telephone and Telegraph Co. Ltd." },
	{  14950, "Guyana Telephone and Telegraph Co. Ltd." },
	{  14951, "Guyana Telephone and Telegraph Co. Ltd." },
	{  14976, "Andinatel S.A." },
	{  14977, "Pacifictel S.A." },
	{  14978, "Pacifictel S.A." },
	{  14979, "Conecel S.A." },
	{  14980, "Conecel S.A." },
	{  14981, "Conecel S.A." },
	{  14982, "Otecel S.A." },
	{  14983, "Otecel S.A." },
	{  14984, "Telecsa S.A." },
	{  14985, "Etapa Telecom S.A." },
	{  14986, "Setel S.A." },
	{  14987, "Andinatel S.A." },
	{  14988, "Etapa Telecom S.A." },
	{  14990, "Conecel S.A." },
	{  14991, "Otecel S.A." },
	{  14992, "Otecel S.A." },
	{  14993, "Ecuador Telecom S.A." },
	{  14994, "Telecsa S.A." },
	{  14995, "Telecsa S.A." },
	{  15009, "Dauphin Telecom" },
	{  15040, "Copaco S.A." },
	{  15041, "Hola Paraguay S.A." },
	{  15042, "Hutchison Telecom Paraguay S.A." },
	{  15043, "Telecel S.A." },
	{  15044, "Nucleo S.A." },
	{  15045, "Copaco S.A." },
	{  15072, "Telesur" },
	{  15073, "Telesur" },
	{  15074, "Telesur" },
	{  15075, "Telesur" },
	{  15076, "Intelsur" },
	{  15077, "Intelsur" },
	{  15078, "Digicel" },
	{  15079, "Digicel" },
	{  15104, "AM Wireless Uruguay SA" },
	{  15105, "Administracion nacional de Telecomunicaciones (ANTEL)" },
	{  15106, "Administracion nacional de Telecomunicaciones (ANTEL)" },
	{  15107, "Administracion nacional de Telecomunicaciones (ANTEL)" },
	{  15108, "Administracion nacional de Telecomunicaciones (ANTEL)" },
	{  15109, "Abiatar SA" },
	{  15129, "Cable & Wireless" },
	{  15130, "Cable & Wireless" },
	{  15536, "ENTEL S.A." },
	{  15537, "COTAS LTDA" },
	{  15538, "ENTEL S.A." },
	{  15539, "ENTEL S.A." },
	{  15540, "ENTEL S.A." },
	{  15541, "ENTEL S.A." },
	{  15542, "ENTEL S.A." },
	{  15543, "ENTEL S.A." },
	{  16208, "Mars Communications Limited" },
	{  16209, "I-21 Ltd" },
	{  16210, "Hextel Communications Limited" },
	{  16211, "Samitel Ltd" },
	{  16212, "Bangla Trac Communication Ltd" },
	{  16213, "Bangla Trac Communication Ltd" },
	{  16226, "Xfera Moviles S.A." },
	{  16227, "Xfera Moviles S.A." },
	{  16228, "Best Spain Telecom, S.L." },
	{  16229, "Best Spain Telecom, S.L." },
	{  16230, "Liberty Voz S.L." },
	{  16232, "Arbinet-thexchange (UK) Ltd" },
	{  16233, "Arbinet-thexchange (UK) Ltd" },
	{  16234, "Primus Telecommunications" },
	{  16235, "Teleglobe International Ltd" },
	{  16236, "Teleglobe International Ltd" },
	{  16237, "Teleglobe International Ltd" },
	{  16238, "Teleglobe International Ltd" },
	{  16239, "Orange" },
	{  16240, "Transatel" },
	{  16241, "SFR" },
	{  16243, "Bouygues Telecom" },
	{  16244, "Bouygues Telecom" },
	{  16245, "Bouygues Telecom" },
	{  16246, "Bouygues Telecom" },
	{  16247, "Bouygues Telecom" },
	{  16248, "Slovak Telekom, a.s." },
	{  16249, "Telefonica O2 Slovakia, s.r.o." },
	{  16250, "Telefonica O2 Slovakia, s.r.o." },
	{  16257, "Verizon Norway AS" },
	{  16258, "MTU Nett AS" },
	{  16259, "Mobile Norway AS" },
	{  16262, "Tele2 Norge AS" },
	{  16263, "Tele2 Norge AS" },
	{  16264, "E-Plus Moviles Virtuales Espana S.L.U." },
	{  16265, "Vodafone Espana S.A." },
	{  16266, "Vodafone Espana S.A." },
	{  16267, "Vodafone Espana S.A." },
	{  16268, "Vodafone Espana S.A." },
	{  16269, "Euskaltel, S.A." },
	{  16270, "Euskaltel, S.A." },
	{  16271, "Best Spain Telecom, S.L." },
	{  16273, "Kyivstar GSM" },
	{  16274, "URS MSC" },
	{  16275, "Ucomline JSC" },
	{  16276, "Intertelekom" },
	{  16277, "Astelit" },
	{  16278, "Ukrtelecom JSC" },
	{  16279, "Limited Liability Company Astelit" },
	{  16280, "Wire9 Telecom plc" },
	{  16281, "Wire9 Telecom plc" },
	{  16282, "Vodafone Ltd" },
	{  16283, "Vodafone Ltd" },
	{  16284, "Vodafone Ltd" },
	{  16285, "Vodafone Ltd" },
	{  16286, "30 Degrees East Telecoms (PTY) Ltd" },
	{  16287, "Wireless Solutions International" },
	{  16288, "PKT Centertel Sp. Z.o.o." },
	{  16289, "Computel Sp. Z.o.o." },
	{  16290, "MultiCorp XIV Sp. Z.o.o." },
	{  16291, "P4 Sp. Z.o.o." },
	{  16292, "P4 Sp. Z.o.o." },
	{  16293, "P4 Sp. Z.o.o." },
	{  16294, "P4 Sp. Z.o.o." },
	{  16296, "SIA ECO Solutions" },
	{  16297, "Bell Baltia" },
	{  16298, "SIA Tele2" },
	{  16299, "SIA Tele2" },
	{  16300, "SIA MWTV" },
	{  16301, "TG Transit" },
	{  16302, "Dentel" },
	{  16303, "SIA Advem" },
	{  16304, "PTC Sp. Z.o.o." },
	{  16305, "Polkomtel S.A." },
	{  16306, "PTC Sp. Z.o.o." },
	{  16307, "Galena Sp. Z.o.o." },
	{  16309, "Concept-T Sp. Z.o.o." },
	{  16310, "P4 Sp. Z.o.o." },
	{  16311, "TSPP Sp. Z.o.o." },
	{  16312, "Switchward Ltd" },
	{  16313, "IVY Telecom SA" },
	{  16314, "IVY Telecom SA" },
	{  16315, "Switchward Ltd" },
	{  16316, "Global Vision AG" },
	{  16317, "Netstream AG" },
	{  16318, "Cablecom GmbH" },
	{  16319, "Cablecom GmbH" },
	{  16320, "Atlas Telecom Interactive" },
	{  16321, "UPC Romania" },
	{  16322, "GTS Romania" },
	{  16325, "Orange Romania" },
	{  16326, "NetConnect Internet" },
	{  16328, "Telefonwelt GmbH" },
	{  16329, "DiDaCom GmbH" },
	{  16330, "Phone24 AG" },
	{  16331, "Dentel Netzwerk Telefonie GmbH" },
	{  16332, "A.S.H. Communication GmbH" },
	{  16333, "TGI GmbH" },
	{  16334, "Teleplus Communications Ltd." },
	{  16336, "Datu Tikli" },
	{  16337, "Telegrupa Globala" },
	{  16338, "TG Transit" },
	{  16339, "Sigis" },
	{  16340, "SIA MPE NETS" },
	{  16341, "Interneta pasaule" },
	{  16342, "SIA Rigatta" },
	{  16343, "Adamasto" },
	{  16344, "Azurtel Ltd" },
	{  16345, "Protel UK Ltd" },
	{  16346, "Orange" },
	{  16347, "TeliaSonera International Carrier UK Ltd" },
	{  16348, "IDT Global Ltd" },
	{  16349, "Vodafone Ltd" },
	{  16350, "Vodafone Ltd" },
	{  16351, "QiComm Ltd" },
	{  16352, "Tele2 fiksuotas rysys" },
	{  16353, "Omnitel" },
	{  16354, "CSC Telecom" },
	{  16355, "Telekomunikaciju grupa" },
	{  16356, "Tele2" },
	{  16357, "Nacionalinis telekomunikaciju tinklas" },
	{  16358, "Lietuvos gelezinkeliai" },
	{  16359, "Omnitel" },
	{  16360, "Centrica Telecommunications" },
	{  16361, "Communications Networking Services (UK)" },
	{  16362, "Vodafone Ltd" },
	{  16363, "Inmarsat Ltd" },
	{  16364, "O2 (UK) Ltd" },
	{  16365, "Modus Telecom Ltd" },
	{  16366, "O2 (UK) Ltd" },
	{  16367, "Vodafone Ltd" },
	{  16368, "Vodafone Espana, S.L." },
	{  16369, "Vodafone Espana, S.L." },
	{  16370, "Hostbin, S.L." },
	{  16371, "Marin Telecom, S.L.U." },
	{  16372, "Nova Telefonia, S.L." },
	{  16373, "Duocom Europe, S.L." },
	{  16374, "Nearly, S.L." },
	{  16375, "Space Telecomm. Systems, S.L." },
	{  0, NULL }
};

static value_string_ext q708_ispc_point_name_ext = VALUE_STRING_EXT_INIT(q708_ispc_point_name);
static value_string_ext q708_ispc_operator_name_ext = VALUE_STRING_EXT_INIT(q708_ispc_operator_name);
static value_string_ext q708_sanc_areas_ext = VALUE_STRING_EXT_INIT(q708_sanc_areas);

/*
 * International signalling point codes (i.e. PCs with ni = 0) are allocated by the ITU,
 * according to the processes described in Q.708. ITU keeps a database of all registered
 * ISPCs which is publically available, with updates being provided in the operational
 * bulletins. This function takes an ISPC and analyzes it according to these tables.
 */
void
analyze_q708_ispc(tvbuff_t *tvb, proto_tree *tree, int offset, int length, guint16 ispc)
{
	guint16 sanc;

	sanc = ispc >> 3;

	proto_tree_add_uint_format_value(tree, hf_q708_sanc, tvb, offset, length, sanc,
		"%s (%u-%03u)",
		val_to_str_ext_const(sanc, &q708_sanc_areas_ext, "Unknown"),
		sanc >> 8, sanc & 0xff);
	proto_tree_add_string(tree, hf_q708_ispc_name, tvb, offset, length,
		val_to_str_ext_const(ispc, &q708_ispc_point_name_ext, "Unknown"));
	proto_tree_add_string(tree, hf_q708_ispc_operator_name, tvb, offset, length,
		val_to_str_ext_const(ispc, &q708_ispc_operator_name_ext, "Unknown"));
}

void
proto_register_q708(void)
{
	static hf_register_info hf[] = {
	{ &hf_q708_sanc,
		{ "Signalling Area Network Code (SANC)","q708.sanc",
		FT_UINT16, BASE_DEC | BASE_EXT_STRING, &q708_sanc_areas_ext, 0x0,
		NULL, HFILL }
	},
	{ &hf_q708_ispc_name,
		{ "Unique Signalling Point Name","q708.ispc_name",
		FT_STRING, BASE_NONE, NULL, 0x0,
		NULL, HFILL }
	},
	{ &hf_q708_ispc_operator_name,
		{ "Signalling Point Operator Name", "q708.ispc_operator_name",
		FT_STRING, BASE_NONE, NULL, 0,
		NULL, HFILL }},
	};

	/*
	 * Register the protocol name and description
	 */
	proto_q708 = proto_register_protocol(
			"ITU-T Q.708 ISPC Analysis",
			"Q.708",
			"q708");

	/*
	 * Required function calls to register
	 * the header fields and subtrees used.
	 */
	proto_register_field_array(proto_q708, hf, array_length(hf));

}
