/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.service.autofill;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.widget.RemoteViews;

import com.android.internal.util.DataClass;

/**
 * Holds presentations used to visualize autofill suggestions for each available UI type.
 *
 * @see Field
 */
@DataClass(genBuilder = true)
public final class Presentations {

    /**
     * The presentation used to visualize this field in fill UI.
     *
     * <p>Note: Before Android 13, this was referred to simply as "presentation" in the SDK.
     *
     * <p>Theme does not work with RemoteViews layout. Avoid hardcoded text color
     * or background color: Autofill on different platforms may have different themes.
     */
    private @Nullable RemoteViews mMenuPresentation;

    /**
     * The {@link InlinePresentation} used to visualize this dataset as inline suggestions.
     * If the dataset supports inline suggestions, this should not be null.
     */
    private @Nullable InlinePresentation mInlinePresentation;

    /**
     * The presentation used to visualize this field in the
     * <a href="Dataset.html#FillDialogUI">fill dialog UI</a>
     *
     * <p>Theme does not work with RemoteViews layout. Avoid hardcoded text color
     * or background color: Autofill on different platforms may have different themes.
     */
    private @Nullable RemoteViews mDialogPresentation;

    /**
     * The {@link InlinePresentation} used to show the tooltip for the
     * {@code mInlinePresentation}. If the set this field, the
     * {@code mInlinePresentation} should not be null.
     */
    private @Nullable InlinePresentation mInlineTooltipPresentation;

    private static RemoteViews defaultMenuPresentation() {
        return null;
    }

    private static InlinePresentation defaultInlinePresentation() {
        return null;
    }

    private static RemoteViews defaultDialogPresentation() {
        return null;
    }

    private static InlinePresentation defaultInlineTooltipPresentation() {
        return null;
    }

    private void onConstructed() {
        if (mMenuPresentation == null
                && mInlinePresentation == null
                && mDialogPresentation == null) {
            throw new IllegalStateException("All presentations are null.");
        }
        if (mInlineTooltipPresentation != null && mInlinePresentation == null) {
            throw new IllegalStateException(
                    "The inline presentation is required for mInlineTooltipPresentation.");
        }
    }



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/./frameworks/base/core/java/android/service/autofill/Presentations.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ Presentations(
            @Nullable RemoteViews menuPresentation,
            @Nullable InlinePresentation inlinePresentation,
            @Nullable RemoteViews dialogPresentation,
            @Nullable InlinePresentation inlineTooltipPresentation) {
        this.mMenuPresentation = menuPresentation;
        this.mInlinePresentation = inlinePresentation;
        this.mDialogPresentation = dialogPresentation;
        this.mInlineTooltipPresentation = inlineTooltipPresentation;

        onConstructed();
    }

    /**
     * The presentation used to visualize this field in fill UI.
     *
     * <p>Theme does not work with RemoteViews layout. Avoid hardcoded text color
     * or background color: Autofill on different platforms may have different themes.
     */
    @DataClass.Generated.Member
    public @Nullable RemoteViews getMenuPresentation() {
        return mMenuPresentation;
    }

    /**
     * The {@link InlinePresentation} used to visualize this dataset as inline suggestions.
     * If the dataset supports inline suggestions, this should not be null.
     */
    @DataClass.Generated.Member
    public @Nullable InlinePresentation getInlinePresentation() {
        return mInlinePresentation;
    }

    /**
     * The presentation used to visualize this field in the fill dialog UI.
     *
     * <p>Theme does not work with RemoteViews layout. Avoid hardcoded text color
     * or background color: Autofill on different platforms may have different themes.
     */
    @DataClass.Generated.Member
    public @Nullable RemoteViews getDialogPresentation() {
        return mDialogPresentation;
    }

    /**
     * The {@link InlinePresentation} used to show the tooltip for the
     * {@code mInlinePresentation}. If the set this field, the
     * {@code mInlinePresentation} should not be null.
     */
    @DataClass.Generated.Member
    public @Nullable InlinePresentation getInlineTooltipPresentation() {
        return mInlineTooltipPresentation;
    }

    /**
     * A builder for {@link Presentations}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @Nullable RemoteViews mMenuPresentation;
        private @Nullable InlinePresentation mInlinePresentation;
        private @Nullable RemoteViews mDialogPresentation;
        private @Nullable InlinePresentation mInlineTooltipPresentation;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * The presentation used to visualize this field in fill UI.
         *
         * <p>Theme does not work with RemoteViews layout. Avoid hardcoded text color
         * or background color: Autofill on different platforms may have different themes.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setMenuPresentation(@NonNull RemoteViews value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mMenuPresentation = value;
            return this;
        }

        /**
         * The {@link InlinePresentation} used to visualize this dataset as inline suggestions.
         * If the dataset supports inline suggestions, this should not be null.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setInlinePresentation(@NonNull InlinePresentation value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mInlinePresentation = value;
            return this;
        }

        /**
         * The presentation used to visualize this field in the fill dialog UI.
         *
         * <p>Theme does not work with RemoteViews layout. Avoid hardcoded text color
         * or background color: Autofill on different platforms may have different themes.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setDialogPresentation(@NonNull RemoteViews value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mDialogPresentation = value;
            return this;
        }

        /**
         * The {@link InlinePresentation} used to show the tooltip for the
         * {@code mInlinePresentation}. If the set this field, the
         * {@code mInlinePresentation} should not be null.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setInlineTooltipPresentation(@NonNull InlinePresentation value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8;
            mInlineTooltipPresentation = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull Presentations build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x10; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mMenuPresentation = defaultMenuPresentation();
            }
            if ((mBuilderFieldsSet & 0x2) == 0) {
                mInlinePresentation = defaultInlinePresentation();
            }
            if ((mBuilderFieldsSet & 0x4) == 0) {
                mDialogPresentation = defaultDialogPresentation();
            }
            if ((mBuilderFieldsSet & 0x8) == 0) {
                mInlineTooltipPresentation = defaultInlineTooltipPresentation();
            }
            Presentations o = new Presentations(
                    mMenuPresentation,
                    mInlinePresentation,
                    mDialogPresentation,
                    mInlineTooltipPresentation);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x10) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1643083242164L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/service/autofill/Presentations.java",
            inputSignatures = "private @android.annotation.Nullable android.widget.RemoteViews mMenuPresentation\nprivate @android.annotation.Nullable android.service.autofill.InlinePresentation mInlinePresentation\nprivate @android.annotation.Nullable android.widget.RemoteViews mDialogPresentation\nprivate @android.annotation.Nullable android.service.autofill.InlinePresentation mInlineTooltipPresentation\nprivate static  android.widget.RemoteViews defaultMenuPresentation()\nprivate static  android.service.autofill.InlinePresentation defaultInlinePresentation()\nprivate static  android.widget.RemoteViews defaultDialogPresentation()\nprivate static  android.service.autofill.InlinePresentation defaultInlineTooltipPresentation()\nprivate  void onConstructed()\nclass Presentations extends java.lang.Object implements []\n@com.android.internal.util.DataClass(genBuilder=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
