/* $Id$ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LABEL_HPP_INCLUDED
#define __LABEL_HPP_INCLUDED

#include "intermediate/Node.hpp"
#include <string>

namespace intermediate {

//! a label, which marks the destination of a jump
class Label : public Node {
public:
	//! c'tor
	/** @param id name of the label */
	Label(std::string id) : name(id) {}

	//! virtual dummy d'tor
	virtual ~Label() {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! name of the label.
	std::string name;

};

}; /* namespace intermediate */

#endif /* __LABEL_HPP_INCLUDED */
