// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package logger

import (
	"context"
)

type key int

const (
	loggerKey key = iota + 1
)

func ContextSetLogger(ctx context.Context, value Interface) context.Context {
	return context.WithValue(ctx, loggerKey, value)
}

func ContextGetLogger(ctx context.Context) Interface {
	value, _ := ctx.Value(loggerKey).(Interface)
	return value
}
