// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all task runs for a particular account.
func (c *Client) ListColumnStatisticsTaskRuns(ctx context.Context, params *ListColumnStatisticsTaskRunsInput, optFns ...func(*Options)) (*ListColumnStatisticsTaskRunsOutput, error) {
	if params == nil {
		params = &ListColumnStatisticsTaskRunsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListColumnStatisticsTaskRuns", params, optFns, c.addOperationListColumnStatisticsTaskRunsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListColumnStatisticsTaskRunsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListColumnStatisticsTaskRunsInput struct {

	// The maximum size of the response.
	MaxResults *int32

	// A continuation token, if this is a continuation call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListColumnStatisticsTaskRunsOutput struct {

	// A list of column statistics task run IDs.
	ColumnStatisticsTaskRunIds []string

	// A continuation token, if not all task run IDs have yet been returned.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListColumnStatisticsTaskRunsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListColumnStatisticsTaskRuns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListColumnStatisticsTaskRuns{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListColumnStatisticsTaskRuns"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListColumnStatisticsTaskRuns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListColumnStatisticsTaskRunsPaginatorOptions is the paginator options for
// ListColumnStatisticsTaskRuns
type ListColumnStatisticsTaskRunsPaginatorOptions struct {
	// The maximum size of the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListColumnStatisticsTaskRunsPaginator is a paginator for
// ListColumnStatisticsTaskRuns
type ListColumnStatisticsTaskRunsPaginator struct {
	options   ListColumnStatisticsTaskRunsPaginatorOptions
	client    ListColumnStatisticsTaskRunsAPIClient
	params    *ListColumnStatisticsTaskRunsInput
	nextToken *string
	firstPage bool
}

// NewListColumnStatisticsTaskRunsPaginator returns a new
// ListColumnStatisticsTaskRunsPaginator
func NewListColumnStatisticsTaskRunsPaginator(client ListColumnStatisticsTaskRunsAPIClient, params *ListColumnStatisticsTaskRunsInput, optFns ...func(*ListColumnStatisticsTaskRunsPaginatorOptions)) *ListColumnStatisticsTaskRunsPaginator {
	if params == nil {
		params = &ListColumnStatisticsTaskRunsInput{}
	}

	options := ListColumnStatisticsTaskRunsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListColumnStatisticsTaskRunsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListColumnStatisticsTaskRunsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListColumnStatisticsTaskRuns page.
func (p *ListColumnStatisticsTaskRunsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListColumnStatisticsTaskRunsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListColumnStatisticsTaskRuns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListColumnStatisticsTaskRunsAPIClient is a client that implements the
// ListColumnStatisticsTaskRuns operation.
type ListColumnStatisticsTaskRunsAPIClient interface {
	ListColumnStatisticsTaskRuns(context.Context, *ListColumnStatisticsTaskRunsInput, ...func(*Options)) (*ListColumnStatisticsTaskRunsOutput, error)
}

var _ ListColumnStatisticsTaskRunsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListColumnStatisticsTaskRuns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListColumnStatisticsTaskRuns",
	}
}
