// generated by ../../../../tools/tube_transfer.py
// tube: 6V6
// plate current function: pentode2
// mu: 12.67
// kx: 1.198
// kg1: 915
// kg2: 4500
// kp: 38.07
// kvb: 30.2
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_6V6[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	246.2362537277177,246.2241737057493,246.21202623309082,246.19981092052473,246.18752737667538,
	246.17517520799854,246.1627540187699,246.15026341107466,246.13770298479608,246.12507233760485,
	246.1123710649476,246.09959876003614,246.08675501383607,246.07383941505563,246.06085155013443,
	246.0477910032323,246.03465735621776,246.02145018865673,246.00816907780117,245.99481359857765,
	245.98138332357556,245.96787782303602,245.95429666484003,245.94063941449684,245.9269056351325,
	245.9130948874778,245.89920672985696,245.88524071817557,245.87119640590873,245.85707334408946,
	245.84287108129652,245.82858916364265,245.8142271347625,245.7997845358005,245.78526090539924,
	245.7706557796867,245.75596869226467,245.7411991741963,245.726346753994,245.71141095760694,
	245.6963913084092,245.6812873271869,245.66609853212628,245.65082443880098,245.6354645601597,
	245.62001840651382,245.60448548552458,245.58886530219075,245.57315735883597,245.55736115509615,
	245.54147618790657,245.52550195148947,245.509437937341,245.4932836342187,245.47703852812845,
	245.46070210231167,245.4442738372325,245.42775321056476,245.41113969717898,245.39443276912948,
	245.37763189564114,245.36073654309655,245.3437461750227,245.32666025207794,245.3094782320388,
	245.2921995697866,245.2748237172944,245.2573501236137,245.2397782348609,245.2221074942042,
	245.20433734185005,245.1864672150299,245.16849654798648,245.1504247719605,245.13225131517723,
	245.11397560283277,245.09559705708043,245.0771150970173,245.05852913867062,245.03983859498385,
	245.0210428758033,245.00214138786413,244.98313353477687,244.96401871701335,244.94479633189303,
	244.9254657735693,244.90602643301526,244.8864776980102,244.86681895312543,244.84704957971044,
	244.82716895587905,244.80717645649506,244.78707145315855,244.7668533141918,244.74652140462513,
	244.72607508618282,244.705513717269,244.6848366529536,244.66404324495818,244.6431328416416,
	244.62210478798602,244.60095842558258,244.5796930926172,244.55830812385634,244.53680285063257,
	244.51517660083059,244.49342869887275,244.47155846570462,244.44956521878075,244.42744827205047,
	244.40520693594323,244.38284051735454,244.36034831963127,244.33772964255743,244.3149837823397,
	244.29211003159315,244.26910767932637,244.24597601092756,244.2227143081497,244.1993218490962,
	244.1757979082066,244.1521417562416,244.12835266026926,244.10442988364989,244.08037268602197,
	244.05618032328732,244.03185204759694,244.00738710733626,243.98278474711063,243.95804420773106,
	243.93316472619944,243.9081455356941,243.88298586555553,243.85768494127154,243.83224198446302,
	243.80665621286934,243.7809268403339,243.75505307678966,243.72903412824462,243.70286919676747,
	243.67655748047304,243.65009817350784,243.62349046603583,243.59673354422378,243.569826590227,
	243.54276878217485,243.51555929415656,243.48819729620666,243.4606819542908,243.43301243029146,
	243.40518788199347,243.37720746306988,243.34907032306782,243.32077560739404,243.29232245730086,
	243.26371000987191,243.23493739800827,243.2060037504139,243.17690819158187,243.14764984178026,
	243.1182278170381,243.08864122913147,243.05888918556934,243.02897078957994,242.99888514009663,
	242.9686313317444,242.93820845482568,242.9076155953068,242.8768518348044,242.84591625057143,
	242.81480791548393,242.78352589802714,242.75206926228228,242.7204370679128,242.68862837015112,
	242.65664221978525,242.62447766314554,242.59213374209142,242.55960949399804,242.5269039517435,
	242.49401614369535,242.46094509369803,242.42768982105974,242.39424934053935,242.3606226623341,
	242.32680879206646,242.2928067307717,242.2586154748852,242.22423401623004,242.18966134200457,
	242.15489643477,242.1199382724381,242.08478582825927,242.0494380708102,242.01389396398193,
	241.9781524669681,241.94221253425283,241.90607311559936,241.86973315603794,241.8331915958549,
	241.79644737058067,241.75949941097883,241.7223466430346,241.68498798794386,241.64742236210225,
	241.60964867709396,241.5716658396813,241.53347275179368,241.49506831051733,241.45645140808475,
	241.4176209318642,241.37857576434988,241.33931478315168,241.2998368609851,241.26014086566167,
	241.22022566007908,241.18009010221186,241.13973304510176,241.09915333684856,241.05834982060102,
	241.0173213345478,240.97606671190877,240.9345847809262,240.89287436485625,240.85093428196066,
	240.80876334549856,240.76636036371832,240.72372413984982,240.68085347209654,240.6377471536282,
	240.59440397257316,240.5508227120115,240.50700214996778,240.46294105940427,240.41863820821425,
	240.3740923592157,240.32930227014458,240.28426669364936,240.2389843772846,240.19345406350553,
	240.1476744896624,240.1016443879952,240.05536248562873,240.00882750456745,239.96203816169108,
	239.91499316874996,239.8676912323608,239.82013105400296,239.77231133001422,239.72423075158753,
	239.67588800476764,239.62728177044792,239.57841072436764,239.5292735371092,239.47986887409584,
	239.4301953955896,239.38025175668938,239.33003660732928,239.27954859227737,239.2287863511345,
	239.17774851833346,239.12643372313863,239.07484058964548,239.02296773678063,238.97081377830213,
	238.91837732280013,238.86565697369747,238.8126513292511,238.7593589825534,238.70577852153386,
	238.6519085289611,238.5977475824454,238.54329425444118,238.4885471122499,238.43350471802358,
	238.3781656287683,238.32252839634793,238.2665915674887,238.2103536837835,238.15381328169718,
	238.0969688925714,238.03981904263048,237.98236225298737,237.92459703964985,237.86652191352735,
	237.80813538043776,237.7494359411151,237.69042209121721,237.63109232133363,237.5714451169945,
	237.51147895867928,237.45119232182603,237.39058367684112,237.3296514891093,237.26839421900422,
	237.2068103218992,237.1448982481787,237.08265644324973,237.02008334755433,236.95717739658176,
	236.89393702088174,236.83036064607762,236.76644669288035,236.7021935771027,236.63759970967396,
	236.57266349665517,236.50738333925455,236.4417576338438,236.3757847719744,236.30946314039477,
	236.24279112106768,236.17576709118822,236.1083894232021,236.04065648482472,235.97256663906043,
	235.9041182442225,235.83530965395346,235.76613921724604,235.6966052784645,235.62670617736654,
	235.55644024912587,235.48580582435497,235.41480122912867,235.3434247850081,235.27167480906533,
	235.19954961390832,235.12704750770672,235.05416679421788,234.9809057728137,234.9072627385079,
	234.8332359819839,234.75882378962316,234.6840244435344,234.6088362215829,234.5332573974209,
	234.45728624051827,234.38092101619395,234.30415998564774,234.22700140599304,234.14944353028986,
	234.07148460757878,233.9931228829152,233.9143565974044,233.83518398823722,233.75560328872635,
	233.6756127283432,233.59521053275554,233.51439492386567,233.43316411984927,233.35151633519487,
	233.26944978074425,233.18696266373306,233.10405318783236,233.02071955319104,232.9369599564784,
	232.85277259092788,232.76815564638136,232.6831073093339,232.59762576297973,232.5117091872582,
	232.4253557589011,232.33856365148037,232.25133103545667,232.16365607822846,232.07553694418198,
	231.98697179474206,231.8979587884233,231.80849608088243,231.71858182497115,231.62821417078968,
	231.5373912657413,231.44611125458738,231.35437227950356,231.26217248013603,231.16950999365935,
	231.07638295483457,230.98278949606822,230.88872774747205,230.7941958369239,230.69919189012873,
	230.60371403068103,230.50776038012773,230.411329058032,230.31441818203794,230.2170258679356,
	230.1191502297279,230.0207893796969,229.92194142847222,229.82260448509965,229.72277665711027,
	229.62245605059144,229.5216407702575,229.42032891952203,229.31851860057074,229.21620791443507,
	229.113394961067,229.01007783941427,228.90625464749672,228.80192348248372,228.69708244077174,
	228.5917296180636,228.4858631094481,228.37948100948066,228.27258141226486,228.16516241153474,
	228.05722210073833,227.94875857312132,227.83976992181263,227.7302542399101,227.6202096205672,
	227.50963415708088,227.3985259429802,227.2868830721158,227.1747036387502,227.06198573764917,
	226.9487274641741,226.83492691437488,226.7205821850839,226.60569137401126,226.49025257984022,
	226.37426390232417,226.25772344238433,226.14062930220805,226.02297958534854,225.90477239682517,
	225.78600584322464,225.66667803280345,225.54678707559083,225.42633108349276,225.3053081703972,
	225.18371645227967,225.0615540473101,224.93881907596068,224.8155096611143,224.69162392817432,
	224.5671600051748,224.4421160228919,224.31649011495625,224.19028041796614,224.06348507160155,
	223.93610221873905,223.80813000556824,223.67956658170775,223.55041010032372,223.42065871824798,
	223.29031059609787,223.15936389839652,223.02781679369417,222.89566745469057,222.76291405835784,
	222.6295547860647,222.49558782370138,222.36101136180525,222.22582359568767,222.09002272556125,
	221.95360695666858,221.81657449941144,221.67892356948082,221.54065238798816,221.4017591815969,
	221.26224218265565,221.12209962933133,220.98132976574405,220.83993084210186,220.69790111483744,
	220.55523884674443,220.41194230711585,220.2680097718821,220.1234395237505,219.9782298523459,
	219.832379054351,219.68588543364885,219.53874730146484,219.39096297651048,219.24253078512737,
	219.09344906143212,218.9437161474621,218.7933303933218,218.64229015733008,218.49059380616785,
	218.33823971502713,218.18522626776007,218.03155185702914,217.87721488445794,217.7222137607826,
	217.56654690600402,217.41021274954076,217.2532097303824,217.09553629724377,216.93719090871983,
	216.77817203344105,216.61847815022963,216.4581077482558,216.29705932719577,216.13533139738902,
	215.97292247999715,215.80983110716272,215.6460558221691,215.48159517960036,215.31644774550222,
	215.15061209754325,214.98408682517626,214.81687052980118,214.64896182492706,214.4803593363359,
	214.31106170224595,214.14106757347585,213.9703756136093,213.79898449915993,213.62689291973672,
	213.45409957820954,213.28060319087555,213.10640248762567,212.9314962121112,212.755883121911,
	212.57956198869928,212.402531598413,212.22479075142022,212.04633826268807,211.86717296195172,
	211.6872936938829,211.50669931825905,211.32538871013247,211.14336075999978,210.96061437397145,
	210.77714847394148,210.5929619977574,210.40805389938996,210.22242314910335,210.03606873362534,
	209.8489896563173,209.6611849373445,209.47265361384643,209.28339474010684,209.09340738772394,
	208.9026906457808,208.7112436210152,208.51906543798975,208.32615523926174,208.132512185553,
	207.9381354559194,207.74302424792072,207.5471777777894,207.35059528060006,207.1532760104382,
	206.9552192405687,206.75642426360457,206.55689039167433,206.35661695659053,206.1556033100165,
	205.9538488236338,205.7513528893087,205.54811491925835,205.344134346217,205.13941062360092,
	204.93394322567352,204.7277316477098,204.52077540616014,204.3130740388138,204.10462710496148,
	203.89543418555758,203.68549488338212,203.4748088232012,203.26337565192745,203.05119503877978,
	202.83826667544207,202.6245902762215,202.4101655782059,202.19499234142012,201.97907034898225,
	201.76239940725827,201.5449793460163,201.32681001857998,201.10789130198054,200.88822309710838,
	200.66780532886347,200.44663794630483,200.22472092279904,200.0020542561676,199.77863796883358,
	199.5544721079664,199.3295567456267,199.10389197890885,198.87747793008342,198.6503147467373,
	198.42240260191392,198.1937416942511,197.96433224811844,197.73417451375283,197.50326876739317,
	197.2716153114135,197.03921447445506,196.8060666115562,196.57217210428203,196.33753136085167,
	196.10214481626483,195.86601293242603,195.6291361982686,195.39151512987573,195.15315027060103,
	194.91404219118704,194.67419148988245,194.43359879255735,194.1922647528174,193.95019005211557,
	193.7073753998632,193.4638215335382,193.21952921879284,192.97449924955853,192.72873244815003,
	192.48222966536665,192.23499178059302,191.98701970189686,191.73831436612548,191.48887673900046,
	191.23870781521043,190.9878086185014,190.73618020176644,190.48382364713203,190.23074006604315,
	189.97693059934682,189.72239641737278,189.46713872001266,189.21115873679727,188.95445772697173,
	188.69703697956828,188.43889781347752,188.18004157751744,187.9204696505,187.6601834412965,
	187.3991843888997,187.13747396248505,186.87505366146877,186.61192501556448,186.34808958483745,
	186.0835489597567,185.8183047612452,185.55235864072748,185.2857122801755,185.01836739215224,
	184.75032571985327,184.48158903714565,184.21215914860522,183.94203788955178,183.67122712608153,
	183.3997287550979,183.12754470434018,182.85467693240957,182.58112742879368,182.30689821388853,
	182.03199133901842,181.75640888645393,181.4801529694277,181.20322573214796,180.92562934981035,
	180.64736602860714,180.36843800573496,180.0888475494004,179.8085969588233,179.52768856423805,
	179.24612472689358,178.96390783905068,178.68104032397787,178.39752463594493,178.1133632602153,
	177.8285587130359,177.54311354162593,177.25703032416305,176.97031166976865,176.68296021849125,
	176.39497864128788,176.10636964000457,175.8171359473546,175.52728032689606,175.23680557300725,
	174.9457145108613,174.65400999639922,174.3616949163018,174.06877218796006,173.7752447594454,
	173.48111560947783,173.18638774739347,172.891064213112,172.59514807710198,172.2986424403466,
	172.00155043430823,171.7038752208927,171.4056199924131,171.10678797155322,170.80738241133085,
	170.5074065950611,170.2068638363197,169.905757478906,169.60409089680712,169.30186749416163,
	168.9990907052247,168.6957639943325,168.3918908558695,168.0874748142346,167.78251942381002,
	167.47702826893067,167.1710049638552,166.8644531527389,166.55737650960813,166.24977873833717,
	165.94166357262688,165.63303477598618,165.323896141716,165.01425149289656,164.70410468237662,
	164.39345959276767,164.0823201364406,163.77069025552655,163.45857392192218,163.14597513729893,
	162.83289793311735,162.51934637064628,162.2053245409872,161.8908365651048,161.5758865938626,
	161.26047880806604,160.94461741851111,160.6283066660408,160.3115508216088,159.99435418635088,
	159.67672109166472,159.3586558992981,159.04016300144673,158.7212468208611,158.40191181096367,
	158.08216245597652,157.76200327106,157.44143880246332,157.1204736276861,156.79911235565427,
	156.47735962690766,156.15522011380244,155.83269852072738,155.50979958433572,155.18652807379226,
	154.86288879103736,154.53888657106776,154.21452628223543,153.88981282656496,153.5647511400903,
	153.23934619321193,152.9136029910747,152.58752657396786,152.26112201774754,151.9343944342834,
	151.60734897192916,151.27999081601925,150.95232518939198,150.62435735294005,150.29609260618972,
	149.9675362879101,149.63869377675258,149.30957049192332,148.98017189388776,148.65050348511008,
	148.3205708108289,147.99037945986868,147.6599350654904,147.32924330628148,146.9983099070868,
	146.66714063998214,146.3357413252915,146.00411783265005,145.6722760821135,145.34022204531695,
	145.00796174668278,144.67550126468117,144.34284673314355,144.0100043426316,143.67698034186293,
	143.34378103919542,143.01041280417226,142.67688206912925,142.34319533086628,142.00935915238475,
	141.67538016469334,141.34126506868344,141.00702063707683,140.67265371644663,140.3381712293148,
	140.00358017632692,139.66888763850756,139.33410077959633,138.99922684847036,138.66427318164537,
	138.32924720587712,137.9941564408406,137.65900850190698,137.3238111030118,136.98857205962017,
	136.65329929178736,136.3180008273192,135.98268480503222,135.64735947811587,135.31203321759833,
	134.97671451591586,134.6414119905889,134.30613438800412,133.9708905873045,133.63568960438676,
	133.30054059600852,132.96545286400269,132.63043585960193,132.29549918787058,131.96065261224464,
	131.62590605917842,131.29126962289652,130.95675357024936,130.62236834567068,130.28812457623346,
	129.95403307680178,129.6201048552751,129.28635111792036,128.95278327478755,128.61941294520247,
	128.28625196333206,127.9533123838138,127.62060648744266,127.28814678690644,126.95594603256077,
	126.62401721823296,126.29237358704417,125.96102863723638,125.6299961279926,125.29929008523426,
	124.9689248073814,124.63891487105796,124.30927513672476,123.98002075422053,123.65116716819058,
	123.32273012338042,122.99472566977205,122.66717016753653,122.34008029177846,122.01347303704243,
	121.68736572155419,121.36177599116445,121.03672182296427,120.71222152853764,120.38829375681676,
	120.06495749650414,119.74223207802261,119.42013717495703,119.09869280494465,118.77791932997626,
	118.457837456065,118.13846823224029,117.81983304882527,117.5019536349528,117.1848520552786,
	116.86855070584669,116.55307230906485,116.23843990774861,115.92467685819105,115.61180682222012,
	115.29985375820361,114.98884191096646,114.67879580058629,114.36974021003542,114.061700171642,
	113.75470095234526,113.44876803772561,113.1439271147921,112.84020405351762,112.53762488711544,
	112.23621579105739,111.93600306084015,111.63701308851138,111.33927233797651,111.04280731911204,
	110.74764456071972,110.45381058236333,110.16133186513795,109.8702348214286,109.58054576372446,
	109.29229087256195,109.00549616367715,108.7201874544574,108.43639032978854,108.15413010740004,
	107.87343180281918,107.59432009404976,107.31681928609721,107.04095327546707,106.76674551476567,
	106.49421897753992,106.22339612348942,105.95429886419107,105.68694852947286,105.42136583457574,
	105.15757084823954,104.89558296184667,104.63542085975322,104.37710249093452,104.1206450420631,
	103.86606491213394,103.61337768874215,103.3625981261106,103.11374012495632,102.86681671427388,
	102.62184003510478,102.37882132634942,102.13777091266886,101.8986981945107,101.66161164028232,
	101.42651878068324,101.19342620519599,100.9623395607246,100.73326355235753,100.50620194622172,
	100.28115757438394,100.05813234174632,99.83712723487271,99.61814233267587,99.40117681888545,
	99.1862289962125,98.9732963021185,98.7623753260911,98.55346182832746,98.34655075971848,
	98.1416362830282,97.93871179515845,97.73776995038914,97.53880268448378,97.34180123955065,
	97.14675618955103,96.95365746634775,96.76249438618987,96.57325567653241,96.38592950309291,
	96.20050349705112,96.01696478230156,95.83530000267456,95.65549534904385,95.47753658624595,
	95.30140907974062,95.12709782194648,94.95458745819181,94.78386231222517,94.61490641123584,
	94.44770351033934,94.2822371164877,94.11849051176904,93.95644677606687,93.79608880905175,
	93.63739935148458,93.48036100581302,93.32495625604778,93.17116748690817,93.01897700222995,
	92.86836704263281,92.7193198024449,92.57181744588877,92.4258421225309,92.28137598200337,
	92.13840118800545,91.99689993159596,91.85685444378876,91.71824700746511,91.5810599686177,
	91.44527574694247,91.3108768457954,91.17784586153165,91.04616549224589,90.91581854593225,
	90.78678794808368,90.65905674874986,90.53260812907342,90.40742540732448,90.28349204445306,
	90.16079164917902,90.03930798263926,89.91902496261099,89.79992666733084,89.68199733892756,
	89.5652213864874,89.4495833887697,89.33506809659018,89.22166043488906,89.10934550450067,
	88.9981085836401,88.88793512912315,88.77881077733417,88.67072134495619,88.56365282947773,
	88.45759140948957,88.35252344478417,88.2484354762708,88.14531422571756,88.04314659533213,
	87.94191966719224,87.84162070253595,87.7422371409219,87.64375659926897,87.5461668707846,
	87.44945592378973,87.35361190044947,87.25862311541631,87.16447805439401,87.07116537262849,
	86.97867389333281,86.88699260603043,86.79611066495696,86.70601738718149,86.61670225092435,
	86.52815489371291,86.44036511052923,86.35332285192887,86.26701822213444,86.18144147710797,
	86.09658302260573,86.01243341221895,85.92898334540328,85.84622366550039,85.76414535775417,
	85.68273954732427,85.60199749729912,85.521910606711,85.44247040855511,85.36366856781422,
	85.28549687949125,85.207947266651,85.13101177847248,85.05468258831374,84.97895199178981,
	84.90381240486543,84.82925636196317,84.75527651408852,84.68186562697198,84.60901657923002,
	84.5367223605445,84.46497606986196,84.39377091361297,84.32310020395235,84.25295735702035,
	84.18333589122534,84.11422942554842,84.04563167787005,83.97753646331918,83.90993769264465,
	83.84282937060946,83.77620559440793,83.71006055210526,83.64438852110051,83.57918386661223,
	83.51444104018705,83.45015457823094,83.38631910056355,83.32292930899509,83.25997998592563,
	83.19746599296718,83.13538226958792,83.07372383177835,83.01248577073991,82.95166325159492,
	82.89125151211833,82.8312458614908,82.77164167907299,82.71243441320058,82.65361958000022,
	82.59519276222586,82.53714960811512,82.47948583026567,82.42219720453159,82.36527956893865,
	82.30872882261916,82.25254092476548,82.19671189360218,82.14123780537675,82.08611479336794,
	82.03133904691254,81.97690681044897,81.9228143825788,81.86905811514474,81.81563441232551,
	81.76253972974739,81.70977057361146,81.6573234998372,81.6051951132214,81.55338206661254,
	81.50188106010049,81.45068884022052,81.39980219917256,81.34921797405421,81.29893304610829,
	81.24894433998375,81.1992488230106,81.14984350448789,81.10072543498495,81.05189170565538,
	81.00333944756356,80.95506583102393,80.90706806495199,80.85934339622742,80.81188910906901,
	80.76470252439714,80.71778099932938,80.67112192643765,80.62472273327204,80.57858088176401,
	80.53269386766702,80.48705922000745,80.44167450054546,80.3965373032459,80.35164525375875,
	80.30699600890904,80.26258725619624,80.2184167133026,80.17448212761052,80.13078127572875,
	80.08731196302705,80.04407202317955,80.00105931771608,79.95827173558192,79.91570719270527,
	79.8733636315727,79.83123902081215,79.78933135478363,79.7476386531769,79.7061589606169,
	79.66489034627575,79.62383090349203,79.58297874939674,79.54233202454603,79.5018888925603,
	79.4616475397699,79.42160617486707,79.38176302856397,79.342116353257,79.30266442269661,
	79.2634055316636,79.2243379956503,79.18546015054831,79.14677035234072,79.1082669768005,
	79.06994841919389,79.03181309398877,78.99385943456855,78.95608589295054,78.91849093950962,
	78.88107306270652,78.84383076882068,78.80676258168816,78.76986704244337,78.73314270926589,
	78.69658815713132,78.66020197756644,78.62398277840857,78.58792918356905,78.55203983280066,
	78.51631338146912,78.48074850032845,78.44534387529995,78.41009820725515,78.37501021180225,
	78.34007861907627,78.30530217353258,78.27067963374408,78.23620977220146,78.20189137511737,
	78.16772324223288,78.1337041866283,78.09983303453627,78.06610862515826,78.0325298104842,
	77.99909545511476,77.96580443608691,77.93265564270216,77.8996479763575,77.86678035037929,
	77.83405168985979,77.80146093149628,77.76900702343299,77.7366889251052,77.70450560708629,
	77.67245605093693,77.640539249057,77.60875420453941,77.57709993102684,77.54557545257033,
	77.51417980349022,77.48291202823948,77.45177118126895,77.42075632689497,77.3898665391688,
	77.35910090174835,77.32845850777183,77.29793845973337,77.26753986936058,77.23726185749398,
	77.2071035539686,77.17706409749687,77.14714263555379,77.11733832426378,77.08765032828913,
	77.0580778207202,77.02861998296756,76.99927600465534,76.97004508351667,76.9409264252903,
	76.91191924361915,76.88302275995018,76.85423620343582,76.82555881083691,76.79698982642712,
	76.76852850189884,76.74017409627034,76.7119258757944,76.68378311386846,76.65574509094574,
	76.62781109444823,76.59998041868029,76.57225236474413,76.54462624043106,76.51710136024239,
	76.48967704514959,76.46235262262313,76.43512742652581,76.40800079703513,76.380972080567,
	76.35404062970028,76.32720580310266,76.30046696545746,76.2738234873916,76.24727474540434,
	76.22082012179754,76.1944590046064,76.16819078753151,76.1420148698718,76.11593065645832,
	76.08993755758917,76.06403498896516,76.03822237162667,76.0124991318909,75.98686470129056,
	75.96131851651293,75.9358600193403,75.9104886565907,75.8852038800598,75.86000514646358,
	75.83489191738168,75.8098636592017,75.78491984306397,75.76005994480758,75.7352834449165,
	75.71058982846723,75.68597858507634,75.66144920884938,75.63700119833005,75.61263405645059,
	75.58834729048196,75.56414041198575,75.54001293676586,75.51596438482147,75.4919942803002,
	75.4681021514522,75.44428753058452,75.42054995401655,75.39688896203569,75.37330409885374,
	75.3497949125637,75.32636095509766,75.30300178218452,75.27971695330886,75.25650603167,
	75.23336858414184,75.21030418123301,75.18731239704765,75.1643928092468,75.14154499901008,
	75.11876855099801,75.09606305331488,75.07342809747178,75.0508632783506,75.02836819416805,
	75.00594244644049,74.98358563994873,74.96129738270407,74.93907728591384,74.9169249639481,
	74.89484003430645,74.87282211758539,74.85087083744574,74.82898582058115,74.80716669668632,
	74.78541309842598,74.76372466140431,74.74210102413434,74.72054182800845,74.69904671726835,
	74.67761533897614,74.6562473429855,74.63494238191308,74.61370011111049,74.59252018863646,
	74.57140227522942,74.55034603428054,74.52935113180669,74.50841723642424,74.4875440193229,
	74.46673115423994,74.44597831743462,74.42528518766315,74.40465144615371,74.38407677658203,
	74.36356086504695,74.34310340004663,74.32270407245475,74.30236257549718,74.28207860472875,
	74.26185185801053,74.24168203548727,74.22156883956491,74.20151197488889,74.18151114832187,
	74.16156606892285,74.14167644792526,74.12184199871645,74.10206243681664,74.08233747985858,
	74.062666847567,74.04305026173895,74.02348744622361,74.00397812690302,73.98452203167251,
	73.96511889042165,73.94576843501541,73.92647039927535,73.90722451896123,73.88803053175269,
	73.8688881772313,73.84979719686261,73.83075733397853,73.81176833375997,73.79282994321954,
	73.77394191118442,73.75510398825806,73.73631592689243,73.71757748123402,73.69888840720206,
	73.68024846244825,73.66165740634047,73.64311499994723,73.62462100602224,73.60617518898869,
	73.58777731492438,73.56942715154632,73.55112446819618,73.53286903582527,73.51466062698022,
	73.49649901578843,73.4783839779439,73.46031529069319,73.44229273282127,73.42431608463812,
	73.40638512796473,73.38849964611987,73.37065942390664,73.35286424759936,73.33511390493045,
	73.31740818507764,73.29974687865106,73.28212977768072,73.26455667560401,73.24702736725337,
	73.22954164884398,73.21209931796172,73.19470017355128,73.17734401590418,73.1600306466472,
	73.1427598687307,73.12553148641722,73.10834530527009,73.09120113214229,73.07409877516523,
	73.05703804373788,73.0400187485158,73.02304070140055,73.00610371552875,72.98920760526194,
	72.9723521861758,72.95553727505003,72.93876268985811,72.9220282497572,72.90533377507813,
	72.88867908731545,72.87206400911778,72.855488364278,72.83895197772374,72.82245467550771,
	72.80599628479865,72.7895766338717,72.77319555209927,72.75685286994211,72.74054841894001,
	72.72428203170313,72.70805354190303,72.69186278426395,72.67570959455406,72.65959380957717,
	72.64351526716388,72.62747380616335,72.6114692664351,72.59550148884055,72.57957031523512,
	72.56367558845976,72.54781715233354,72.5319948516452,72.5162085321456,72.50045804053988,
	72.48474322447986,72.4690639325563,72.45342001429152,72.43781132013187,72.42223770144034,
	72.40669901048922,72.39119510045298,72.37572582540103,72.36029104025941,72.34489060093526,
	72.32952436410135,72.31419218733681,72.29889392908086,72.28362944862606,72.26839860611166,
	72.25320126251688,72.2380372796545,72.22290652016424,72.2078088475063,72.19274412595506,
	72.17771222059277,72.1627129973032,72.14774632276553,72.13281206444816,72.11791009060259,
	72.10304027025765,72.08820247321306,72.07339657003396,72.05862243204484,72.04387993132376,
	72.02916894069665,72.0144893337316,71.99984098473317,71.98522376873686,71.97063756150354,
	71.956082239514,71.94155767996352,71.92706376075644,71.91260036050076,71.8981673584932,
	71.88376463476114,71.86939206996867,71.85504954549083,71.84073694364072,71.82645414635047,
	71.81220103779917,71.79797750177833,71.78378342298471,71.76961868679567,71.75548317921702,
	71.74137678690319,71.72729939714725,71.71325089787632,71.69923117764685,71.68524012564002,
	71.67127763165722,71.65734358611557,71.64343788004321,71.62956040507511,71.61571105344858,
	71.60188971799882,71.58809629215467,71.5743306699344,71.56059274594125,71.5468824153594,
	71.53319957394976,71.51954411804581,71.5059159445494,71.49231495092685,71.47874103520486,
	71.46519409596645,71.45167403234707,71.43818074403065,71.42471413124574,71.41127409476151,
	71.39786053588419,71.38447335645303,71.37111245883668,71.35777774592933,71.34446912114721,
	71.33118648846363,71.31792975225888,71.30469881752475,71.29149358972914,71.27831397484383,
	71.26515987934117,71.25203121019038,71.23892787485428,71.22584978128577,71.21279683792453,
	71.19976895369352,71.18676603799584,71.17378800071121,71.16083475219288,71.14790620326434,
	71.135002265216,71.1221228498021,71.10926786923751,71.09643723619459,71.08363086380011,
	71.07084866563213,71.05809055571689,71.04535644852582,71.03264625897262,71.01995990241016,
	71.0072972946275,70.9946583518471,70.98204299072167,70.96945112833157,70.9568826821817,
	70.94433757019881,70.93181571072864,70.91931702253306,70.90684142478742,70.89438883707771,
	70.88195917939794,70.86955237214714,70.8571683361272,70.84480699253966,70.83246826298347,
	70.82015206945218,70.80785833433137,70.79558698039612,70.7833379308084,70.77111110911463,
	70.758906439243,70.74672384550122,70.73456325257379,70.72242458551972,70.71030776977004,
	70.69821273112538,70.68613939575363,70.67408769018745,70.66205754132201,70.65004887641268,
	70.6380616230726,70.62609570927042,70.61415106332811,70.60222761391854,70.5903252900634,
	70.57844402113082,70.56658373683322,70.55474436722515,70.54292584270105,70.5311280939932,
	70.5193510521694,70.507594648631,70.49585881511071,70.48414348367056,70.47244858669978,
	70.46077405691274,70.4491198273469,70.43748583136087,70.42587200263232,70.41427827515585,
	70.40270458324133,70.3911508615116,70.37961704490084,70.36810306865225,70.35660886831648,
	70.34513437974958,70.33367953911103,70.322244282862,70.31082854776339,70.29943227087408,
	70.28805538954889,70.27669784143704,70.26535956448019,70.25404049691055,70.24274057724928,
	70.23145974430462,70.22019793717025,70.20895509522329,70.19773115812289,70.18652606580832,
	70.1753397584973,70.16417217668436,70.15302326113911,70.14189295290458,70.13078119327274,
	70.11968792387223,70.1086130865356,70.09755662338326,70.08651847680083,70.0754985894378,
	70.06449690420563,70.0535133642764,70.04254791308124,70.03160049430865,70.02067105190311,
	70.00975953006348,69.99886587324156,69.9879900261405,69.97713193371327,69.96629154116144,
	69.95546879393342,69.94466363772311,69.93387601846854,69.92310588235028,69.91235317579012,
	69.90161784544962,69.89089983822878,69.88019910126438,69.86951558192908,69.85884922782951,
	69.84819998680527,69.83756780692744,69.82695263649724,69.81635442404473,69.80577311832742,
	69.79520866832901,69.78466102325807,69.77413013254677,69.76361594584952,69.75311841304172,
	69.74263748421852,69.73217310969359,69.72172523999772,69.71129382587775,69.70087881829514,
	69.69048016842504,69.68009782765478,69.66973174758276,69.65938188001729,69.6490481769754,
	69.63873059068166,69.62842907356685,69.61814357826698,69.60787405762211,69.5976204646751,
	69.58738275267056,69.5771608750536,69.56695478546887,69.55676443775934,69.54658978596511,
	69.53643078432252,69.52628738726285,69.51615954941128,69.50604722558593,69.49595037079665,
	69.48586894024395,69.47580288931809,69.46575217359785,69.45571674884957,69.44569657102613,
	69.43569159626585,69.42570178089161,69.41572708140954,69.40576745450849,69.39582285705845,
	69.38589324611,69.37597857889313,69.3660788128164,69.35619390546564,69.34632381460334,
	69.33646849816756,69.32662791427093,69.31680202119966,69.30699077741276,69.297194141541,
	69.28741207238593,69.27764452891904,69.2678914702808,69.25815285577983,69.24842864489185,
	69.23871879725884,69.22902327268825,69.21934203115195,69.20967503278548,69.200022237887,
	69.19038360691667,69.18075910049556,69.17114867940488,69.16155230458519,69.1519699371354,
	69.14240153831209,69.13284706952852,69.12330649235392,69.11377976851263,69.10426685988324,
	69.0947677284978,69.08528233654103,69.07581064634954,69.06635262041087,69.0569082213629,
	69.04747741199297,69.0380601552371,69.02865641417917,69.01926615205025,69.0098893322277,
	69.0005259182345,68.99117587373853,68.98183916255165,68.9725157486291,68.96320559606873,
	68.9539086691102,68.94462493213429,68.93535434966218,68.92609688635464,68.91685250701153,
	68.90762117657071,68.89840286010777,68.88919752283493,68.8800051301006,68.87082564738857,
	68.86165904031726,68.85250527463928,68.84336431624037,68.83423613113904,68.82512068548571,
	68.8160179455622,68.80692787778081,68.79785044868399,68.78878562494329,68.77973337335908,
	68.77069366085969,68.76166645450076,68.75265172146466,68.7436494290598,68.73465954472015,
	68.72568203600434,68.7167168705952,68.70776401629925,68.69882344104573,68.68989511288636,
	68.6809789999945,68.67207507066459,68.66318329331159,68.6543036364704,68.6454360687951,
	68.63658055905857,68.62773707615175,68.61890558908316,68.61008606697811,68.60127847907849,
	68.59248279474183,68.58369898344088,68.57492701476312,68.56616685841003,68.55741848419666,
	68.54868186205101,68.53995696201345,68.53124375423626,68.52254220898304,68.51385229662802,
	68.5051739876558,68.4965072526606,68.48785206234584,68.47920838752346,68.47057619911358,
	68.46195546814378,68.45334616574881,68.44474826316983,68.43616173175411,68.42758654295427,
	68.4190226683281,68.41047007953762,68.40192874834904,68.39339864663195,68.38487974635895,
	68.37637201960501,68.36787543854726,68.35938997546421,68.35091560273537,68.34245229284085,
	68.33400001836075,68.3255587519748,68.31712846646175,68.30870913469901,68.30030072966218,
	68.29190322442446,68.2835165921564,68.27514080612518,68.26677583969438,68.25842166632339,
	68.25007825956699,68.24174559307494,68.23342364059147,68.22511237595485,68.21681177306934,
	68.20852180601388,68.20024244888003,68.19197367587786,68.18371546130939,68.17546777956801,
	68.16723060513814,68.15900391259481,68.15078767660317,68.14258187191814,68.134386473384,
	68.12620145593385,68.11802679458937,68.10986246446028,68.10170844074402,68.0935646987253,
	68.08543121377562,68.07730796135309,68.06919491700177,68.06109205635144,68.05299935511718,
	68.04491678909895,68.03684433418114,68.0287819663324,68.02072966160495,68.01268739613441,
	68.00465514613941,67.99663288792112,67.9886205978629,67.98061825242995,67.97262582816899,
	67.96464330170772,67.95667064975466,67.94870784909861,67.94075487660842,67.93281170923257,
	67.92487832399873,67.91695469801353,67.90904080846217,67.90113663260807,67.89324214779239,
	67.88535733143394,67.87748216102854,67.8696166141489,67.86176066844413,67.85391430163948,
	67.84607749153601,67.8382502160102,67.83043245301359,67.82262418057255,67.81482537678781,
	67.80703601983424,67.79925608796049,67.79148555948862,67.78372441281385,67.77597262640417,
	67.76823017880005,67.76049704861408,67.75277321453075,67.74505865530598,67.73735334976699,
	67.72965727681175,67.72197041540893,67.71429274459743,67.70662424348606,67.69896489125335,
	67.69131466714714,67.68367355048424,67.67604152065036,67.66841855709949,67.66080463935386,
	67.65319974700347,67.64560385970594,67.6380169571861,67.63043901923575,67.62287002571335,
	67.61530995654378,67.60775879171797,67.60021651129269,67.5926830953902,67.58515852419801,
	67.57764277796862,67.5701358370192,67.56263768173127,67.55514829255054,67.54766764998656,
	67.54019573461241,67.53273252706451,67.52527800804229,67.517832158308,67.51039495868625,
	67.50296639006403,67.49554643339019,67.48813506967534,67.48073227999144,67.47333804547168,
	67.46595234731024,67.45857516676178,67.45120648514148,67.44384628382463,67.43649454424644,
	67.42915124790164,67.42181637634451,67.41448991118834,67.40717183410534,67.39986212682632,
	67.39256077114057,67.38526774889539,67.37798304199613,67.37070663240567,67.36343850214432,
	67.35617863328966,67.34892700797612,67.34168360839482,67.33444841679334,67.3272214154756,
	67.32000258680135,67.31279191318619,67.30558937710123,67.29839496107289,67.29120864768261,
	67.28403041956668,67.27686025941605,67.26969814997607,67.26254407404609,67.25539801447961,
	67.24825995418371,67.241129876119,67.23400776329937,67.22689359879173,67.21978736571589,
	67.21268904724425,67.20559862660159,67.19851608706489,67.19144141196311,67.184374584677,
	67.17731558863885,67.17026440733224,67.16322102429194,67.15618542310365,67.14915758740375,
	67.1421375008791,67.13512514726703,67.12812051035473,67.12112357397952,67.11413432202822,
	67.1071527384373,67.10017880719245,67.09321251232845,67.08625383792902,67.07930276812657,
	67.07235928710202,67.06542337908455,67.05849502835153,67.05157421922821,67.04466093608761,
	67.03775516335024,67.03085688548396,67.0239660870039,67.017082752472,67.01020686649711,
	67.00333841373464,66.99647737888638,66.9896237467004,66.98277750197082,66.97593862953754,
	66.96910711428625,66.96228294114802,66.9554660950994,66.94865656116187,66.9418543244021,
	66.93505936993135,66.92827168290562,66.92149124852527,66.91471805203491,66.90795207872331,
	66.90119331392305,66.89444174301053,66.88769735140568,66.88096012457179,66.87423004801543,
	66.86750710728624,66.86079128797665,66.8540825757219,66.84738095619979,66.8406864151304,
	66.83399893827617,66.82731851144152,66.82064512047272,66.8139787512579,66.80731938972666,
	66.80066702185005,66.79402163364036,66.78738321115095,66.78075174047613,66.774127207751,
	66.76750959915121,66.76089890089297,66.75429509923266,66.74769818046697,66.74110813093242,
	66.7345249370055,66.72794858510227,66.7213790616785,66.71481635322914,66.70826044628845,
	66.70171132742983
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	246.2362537277177,246.2241737057493,246.21202623309082,246.19981092052473,246.18752737667538,
	246.17517520799854,246.1627540187699,246.15026341107466,246.13770298479608,246.12507233760485,
	246.1123710649476,246.09959876003614,246.08675501383607,246.07383941505563,246.06085155013443,
	246.0477910032323,246.03465735621776,246.02145018865673,246.00816907780117,245.99481359857765,
	245.98138332357556,245.96787782303602,245.95429666484003,245.94063941449687,245.9269056351325,
	245.91309488747783,245.89920672985696,245.88524071817557,245.87119640590873,245.85707334408946,
	245.8428710812965,245.82858916364265,245.8142271347625,245.7997845358005,245.7852609053992,
	245.7706557796867,245.75596869226467,245.7411991741963,245.726346753994,245.71141095760694,
	245.6963913084092,245.6812873271869,245.66609853212628,245.65082443880098,245.6354645601597,
	245.62001840651382,245.60448548552458,245.58886530219075,245.57315735883597,245.55736115509615,
	245.54147618790657,245.52550195148947,245.509437937341,245.4932836342187,245.47703852812845,
	245.46070210231167,245.44427383723252,245.42775321056476,245.41113969717898,245.39443276912948,
	245.37763189564114,245.36073654309655,245.34374617502272,245.32666025207794,245.30947823203877,
	245.2921995697866,245.2748237172944,245.25735012361372,245.2397782348609,245.22210749420418,
	245.20433734185008,245.1864672150299,245.16849654798645,245.1504247719605,245.13225131517726,
	245.11397560283277,245.09559705708043,245.07711509701733,245.05852913867062,245.03983859498388,
	245.0210428758033,245.00214138786416,244.9831335347769,244.96401871701335,244.94479633189303,
	244.9254657735693,244.90602643301526,244.8864776980102,244.86681895312543,244.8470495797105,
	244.82716895587907,244.80717645649509,244.7870714531586,244.76685331419185,244.74652140462518,
	244.72607508618285,244.705513717269,244.68483665295363,244.6640432449582,244.6431328416416,
	244.62210478798602,244.6009584255826,244.5796930926172,244.5583081238563,244.53680285063257,
	244.5151766008306,244.49342869887278,244.47155846570462,244.44956521878075,244.4274482720505,
	244.40520693594326,244.38284051735457,244.3603483196313,244.33772964255746,244.3149837823398,
	244.29211003159318,244.26910767932642,244.2459760109276,244.22271430814973,244.19932184909624,
	244.1757979082066,244.15214175624163,244.1283526602693,244.10442988364997,244.080372686022,
	244.05618032328738,244.03185204759703,244.0073871073363,243.98278474711068,243.95804420773115,
	243.9331647261995,243.9081455356942,243.8829858655556,243.85768494127163,243.8322419844631,
	243.80665621286946,243.78092684033396,243.75505307678972,243.7290341282447,243.70286919676758,
	243.67655748047312,243.65009817350796,243.62349046603595,243.59673354422392,243.56982659022714,
	243.542768782175,243.5155592941567,243.48819729620683,243.460681954291,243.4330124302916,
	243.4051878819936,243.37720746307008,243.349070323068,243.3207756073942,243.292322457301,
	243.2637100098721,243.23493739800847,243.2060037504141,243.1769081915821,243.14764984178052,
	243.11822781703836,243.08864122913172,243.0588891855696,243.0289707895802,242.99888514009697,
	242.96863133174477,242.93820845482603,242.90761559530716,242.87685183480477,242.8459162505718,
	242.81480791548432,242.78352589802756,242.75206926228276,242.72043706791325,242.68862837015158,
	242.65664221978577,242.62447766314608,242.59213374209196,242.5596094939986,242.52690395174406,
	242.49401614369597,242.46094509369868,242.4276898210604,242.39424934054009,242.36062266233486,
	242.32680879206725,242.29280673077253,242.2586154748861,242.22423401623098,242.18966134200554,
	242.154896434771,242.11993827243916,242.08478582826038,242.0494380708113,242.01389396398312,
	241.97815246696933,241.94221253425414,241.90607311560066,241.86973315603936,241.83319159585636,
	241.79644737058226,241.75949941098045,241.72234664303627,241.68498798794568,241.6474223621041,
	241.60964867709592,241.5716658396833,241.5334727517958,241.49506831051954,241.45645140808702,
	241.41762093186662,241.37857576435243,241.33931478315432,241.29983686098788,241.26014086566454,
	241.22022566008212,241.18009010221505,241.13973304510503,241.099153336852,241.0583498206046,
	241.01732133455155,240.97606671191272,240.93458478093032,240.89287436486052,240.85093428196518,
	240.80876334550325,240.76636036372327,240.72372413985497,240.68085347210194,240.63774715363377,
	240.59440397257902,240.55082271201763,240.5070021499742,240.46294105941098,240.4186382082213,
	240.374092359223,240.3293022701522,240.28426669365734,240.23898437729298,240.19345406351425,
	240.1476744896715,240.10164438800473,240.05536248563865,240.00882750457785,239.96203816170197,
	239.91499316876133,239.8676912323727,239.82013105401538,239.7723113300272,239.72423075160108,
	239.6758880047818,239.62728177046276,239.57841072438313,239.52927353712536,239.47986887411275,
	239.43019539560729,239.38025175670788,239.3300366073486,239.27954859229754,239.22878635115555,
	239.17774851835551,239.12643372316168,239.07484058966958,239.0229677368058,238.97081377832848,
	238.9183773228276,238.8656569737262,238.81265132928112,238.7593589825848,238.70577852156666,
	238.6519085289954,238.59774758248122,238.54329425447864,238.48854711228907,238.43350471806454,
	238.37816562881108,238.32252839639267,238.26659156753541,238.21035368383232,238.15381328174823,
	238.09696889262472,238.03981904268622,237.9823622530456,237.92459703971073,237.86652191359096,
	237.80813538050424,237.74943594118463,237.6904220912898,237.6310923214095,237.5714451170738,
	237.51147895876215,237.4511923219126,237.3905836769316,237.32965148920388,237.26839421910302,
	237.20681032200253,237.1448982482866,237.08265644336257,237.02008334767226,236.957177396705,
	236.89393702101052,236.83036064621217,236.76644669302095,236.70219357724963,236.63759970982755,
	236.57266349681566,236.50738333942226,236.44175763401904,236.37578477215752,236.30946314058613,
	236.24279112126766,236.1757670913972,236.10838942342053,236.04065648505295,235.97256663929892,
	235.9041182444717,235.8353096542139,235.76613921751817,235.69660527874885,235.6267061776637,
	235.5564402494364,235.48580582467943,235.41480122946777,235.3434247853624,235.27167480943555,
	235.1995496142952,235.127047508111,235.0541667946403,234.9809057732551,234.90726273896914,
	234.83323598246585,234.75882379012677,234.68402444406067,234.60883622213277,234.53325739799544,
	234.45728624111862,234.38092101682128,234.30415998630323,234.22700140667794,234.14944353100552,
	234.07148460832653,233.99312288369654,233.91435659822076,233.83518398909027,233.75560328961765,
	233.67561272927452,233.59521053372862,233.5143949248824,233.43316412091156,233.35151633630483,
	233.26944978190397,233.18696266494476,233.1040531890984,233.02071955451385,232.93695995786047,
	232.8527725923719,232.7681556478901,232.68310731091026,232.59762576462668,232.51170918897895,
	232.4253557606989,232.3385636533587,232.25133103741913,232.1636560802788,232.07553694632412,
	231.9869717969801,231.89795879076152,231.80849608332534,231.71858182752334,231.62821417345606,
	231.53739126852702,231.44611125749776,231.35437228254415,231.26217248331258,231.16950999697798,
	231.07638295830162,230.98278949969026,230.88872775125606,230.79419584087705,230.6991918942586,
	230.60371403499542,230.50776038463496,230.4113290627407,230.3144181869569,230.2170258730744,
	230.11915023509619,230.020789385305,229.92194143433073,229.82260449121966,229.7227766635036,
	229.62245605727014,229.52164077723427,229.42032892681019,229.3185186081841,229.21620792238812,
	229.1133949693748,229.0100778480926,228.9062546565622,228.80192349195343,228.69708245066366,
	228.59172962839654,228.48586312024165,228.37948102075526,228.2725814240419,228.16516242383653,
	228.0572221135882,227.94875858654365,227.8397699358328,227.7302542545546,227.62020963586383,
	227.50963417305857,227.39852595966914,227.28688308954753,227.17470365695766,227.06198575666684,
	226.94872748403793,226.83492693512233,226.72058220675416,226.60569139664523,226.4902526034806,
	226.37426392701562,226.25772346817328,226.14062932914325,226.02297961348071,225.9047724262073,
	225.78600587391216,225.6666780648541,225.54678710906492,225.4263311184534,225.30530820691007,
	225.18371649041345,225.06155408713647,224.93881911755446,224.81550970455376,224.69162397354103,
	224.5671600525539,224.4421160723723,224.31649016663087,224.19028047193189,224.0634851279596,
	223.9361022775952,223.80813006703258,223.67956664589556,223.5504101673552,223.42065878824866,
	223.29031066919867,223.15936397473428,223.02781687341167,222.8956675379368,222.76291414528842,
	222.6295548768421,222.4955879184951,222.36101146079233,222.22582369905274,222.09002283349727,
	221.95360706937686,221.81657461710208,221.67892369237325,221.54065251631124,221.40175931558974,
	221.26224232256763,221.12209977542295,220.9813299182869,220.83993100137985,220.69790128114653,
	220.55523902039386,220.4119424884281,220.2680099611939,220.1234397214133,219.97823005872644,
	219.83237926983213,219.68588565863013,219.53874753636325,219.3909632217613,219.24253104118483,
	219.09344932877028,218.94371642657566,218.79333068472718,218.64229046156612,218.490594123797,
	218.33824004663626,218.1852266139617,218.0315522184625,217.87721526179004,217.72221415470958,
	217.5665473172524,217.41021317886856,217.25321017858073,217.09553676513818,216.93719139717183,
	216.77817254334948,216.61847868253255,216.45810830393216,216.29705990726686,216.13533200292065,
	215.97292311210137,215.80983176700005,215.64605651095027,215.4815958985888,215.31644849601628,
	215.15061288095822,214.9840876429274,214.81687138338575,214.6489627159075,214.4803602663423,
	214.31106267297898,214.14106858670993,213.97037667119582,213.79898560303036,213.62689407190612,
	213.4541007807803,213.28060444604108,213.10640379767426,212.93149757943002,212.7558845489906,
	212.57956347813777,212.40253315292088,212.22479237382498,212.04633995593952,211.86717472912693,
	211.68729553819185,211.5067012430503,211.32539071889903,211.14336285638538,210.9606165617769,
	210.77715075713166,210.5929643804679,210.40805638593466,210.222425743982,210.03607144153142,
	209.84899248214649,209.66118788620315,209.47265669106068,209.28339795123185,209.093410738554,
	208.90269414235917,208.71124726964493,208.51906924524485,208.32615921199852,208.13251633092227,
	207.93813978137908,207.74302876124878,207.5471824870976,207.3506001943481,207.15328113744857,
	206.9552245900422,206.75642984513627,206.5568962152706,206.3566230326861,206.15560964949324,
	205.95385543783925,205.751359790076,205.5481221189272,205.34414185765462,205.13941846022476,
	204.9339514014746,204.72774017727707,204.52078430470573,204.3130833221995,204.1046367897263,
	203.89544428894652,203.68550542337582,203.47481981854736,203.26338712217316,203.0512070043054,
	202.83827915749652,202.62460329695887,202.41017916072374,202.19500650979944,201.97908512832896,
	201.7624148237465,201.5449954269335,201.32682679237385,201.107908798308,200.88824134688662,
	200.66782436432308,200.44665780104512,200.2247416318456,200.00207585603275,199.7786604975784,
	199.5544956052664,199.32958125283938,199.10391753914485,198.8775045882797,198.6503425497344,
	198.42243159853564,198.1937719353879,197.96436378681415,197.73420740529505,197.50330306940745,
	197.27165108396136,197.03925178013597,196.8061055156141,196.57221267471616,196.33757366853186,
	196.10218893505163,195.86605893929607,195.6291841734446,195.3915651569625,195.15320243672681,
	194.91409658715082,194.67424821030696,194.43365793604914,194.1923264221328,193.9502543543341,
	193.7074424465676,193.46389144100246,193.21960210817758,192.97457524711467,192.72881168543057,
	192.4823122794477,192.23507791430347,191.9871095040577,191.73840799179908,191.4889743497498,
	191.23880957936944,190.98791471145626,190.73629080624795,190.48393895352095,190.23086027268732,
	189.97705591289167,189.72252705310515,189.46727490221915,189.21130069913696,188.95460571286412,
	188.69719124259746,188.43905861781283,188.18020919835087,187.92064437450247,187.66036556709165,
	187.3993742275583,187.13767183803833,186.8752599114438,186.612139991541,186.3483136530273,
	186.0837825016072,185.81854817406688,185.5526123383478,185.2859766936188,185.01864297034757,
	184.75061293037103,184.48188836696443,184.2124711049096,183.9423630005625,183.67156594191968,
	183.40008184868438,183.12791267233104,182.85506039616993,182.58152703541097,182.30731463722688,
	182.0324252808158,181.75686107746367,181.48062417060632,181.20371673589113,180.92614098123877,
	180.64789914690465,180.36899350554054,180.08942636225643,179.80920005468232,179.52831695303064,
	179.24677946015916,178.9645900116343,178.68175107579512,178.39826515381833,178.11413477978442,
	177.82936252074438,177.54395097678852,177.25790278111566,176.9712206001049,176.6839071333887,
	176.39596511392796,176.1073973080891,175.81820651572377,175.5283955702508,175.23796733874124,
	174.9469247220057,174.65527065468555,174.36300810534743,174.0701400765808,173.77666960510015,
	173.48259976185122,173.18793365212116,172.89267441565426,172.59682522677195,172.30038929449884,
	172.00336986269343,171.70577021018647,171.40759365092387,171.1088435341174,170.80952324440227,
	170.50963620200216,170.20918586290236,169.90817571902983,169.60660929844462,169.30449016553817,
	169.0018219212422,168.6986082032476,168.39485268623392,168.0905590821101,167.78573114026693,
	167.4803726478414,167.17448742999449,166.8680793502018,166.5611523105587,166.2537102520999,
	165.94575715513426,165.63729703959598,165.32833396541267,165.01887203289002,164.70891538311602,
	164.39846819838306,164.0875347026308,163.7761191619089,163.46422588486232,163.15185922323812,
	162.8390235724163,162.52572337196466,162.21196310621954,161.89774730489202,161.58308054370258,
	161.26796744504384,160.95241267867237,160.6364209624327,160.31999706301198,160.00314579672843,
	159.6858720303547,159.36818068197604,159.05007672188685,158.73156517352453,158.41265111444437,
	158.0933396773349,157.77363605107698,157.4535454818468,157.13307327426512,156.81222479259404,
	156.4910054619833,156.16942076976724,155.84747626681505,155.52517756893482,155.20253035833463,
	154.87954038514158,154.5562134689807,154.23255550061623,153.908572443657,153.5842703363272,
	153.2596552933061,152.93473350763725,152.60951125271004,152.28399488431552,151.95819084277935,
	151.63210565517232,151.3057459376028,150.97911839759132,150.65222983653112,150.3250871522357,
	149.9976973415763,149.67006750321087,149.34220484040762,149.01411666396407,148.68581039522542,
	148.35729356920197,148.02857383779045,147.69965897309848,147.37055687087647,147.0412755540569,
	146.7118231764039,146.38220802627404,146.05243853049075,145.72252325833225,145.39247092563568,
	145.06229039901783,144.7319907002127,144.40158101052754,144.0710706754171,143.74046920917633,
	143.40978629975103,143.07903181366666,142.74821580107323,142.4173485009065,142.0864403461623,
	141.7555019692829,141.42454420765208,141.09357810919676,140.7626149380898,140.4316661805543,
	140.1007435507466,139.76985899675304,139.43902470664182,139.1082531146008,138.77755690713855,
	138.4469490293416,138.11644269117852,137.78605137383985,137.4557888361018,137.12566912070065,
	136.79570656070413,136.46591578586344,136.13631172893088,135.80690963192302,135.47772505231222,
	135.14877386912414,134.82007228892004,134.49163685164024,134.1634844362829,133.83563226639214,
	133.50809791532723,133.18089931128216,132.85405474202562,132.52758285932717,132.20150268303567,
	131.8758336047738,131.55059539121095,131.22580818687558,130.90149251646682,130.57766928662312,
	130.2543597871057,129.9315856913522,129.60936905635657,129.2877323218286,128.96669830858772,
	128.64629021614388,128.32653161941946,128.00744646456533,127.68905906382487,127.37139408940071,
	127.05447656627999,126.73833186397476,126.42298568713669,126.10846406500676,125.79479333966385,
	125.48200015303871,125.17011143266234,124.85915437612479,124.54915643422032,124.24014529276359,
	123.93214885306462,123.62519521105656,123.31931263507681,123.01452954230858,122.7108744738953,
	122.40837606875145,122.10706303609628,121.80696412674885,121.50810810322858,121.21052370871459,
	120.91423963492606,120.61928448899303,120.32568675939734,120.03347478106933,119.7426766997364,
	119.45332043562581,119.16543364663201,118.87904369106528,118.59417759010624,118.3108619900946,
	118.0291231247867,117.74898677772072,117.47047824483094,117.1936222974559,116.91844314588538,
	116.64496440359285,116.37320905229858,116.1031994080067,115.83495708815722,115.5685029800294,
	115.30385721052825,115.04103911747981,114.78006722255338,114.52095920592137,114.2637318827584,
	114.00840118167096,113.75498212514042,113.5034888120484,113.25393440234497,113.0063311039063,
	112.76069016161742,112.51702184870324,112.2753354603182,112.03563930939421,111.79794072473307,
	111.56224605131885,111.32856065281455,111.09688891619622,110.86723425846834,110.6395991353942,
	110.41398505216644,110.19039257593616,109.96882135010996,109.74927011032074,109.5317367019692,
	109.31621809923337,109.10271042543543,108.89120897465492,108.68170823447616,108.47420190975441,
	108.26868294728783,108.06514356128085,107.86357525948746,107.66396886992355,107.46631456804147,
	107.27060190426141,107.0768198317592,106.88495673441375,106.69500045482106,106.50693832228677,
	106.32075718071577,106.13644341631793,105.95398298506069,105.77336143979831,105.59456395701687,
	105.41757536313847,105.24238016033168,105.06896255178373,104.89730646639136,104.72739558283527,
	104.55921335300565,104.3927430247524,104.22796766393688,104.06487017576687,103.90343332540066,
	103.74363975780825,103.58547201688404,103.4289125638046,103.27394379463314,103.12054805716987,
	102.96870766705392,102.81840492312264,102.66962212203765,102.52234157218678,102.37654560687548,
	102.23221659682065,102.08933696196165,101.94788918260475,101.80785580991872,101.6692194757978,
	101.53196290211203,101.3960689093633,101.26152042476633,101.12830048977472,100.99639226707164,
	100.86577904704508,100.73644425376757,100.60837145050084,100.481544344744,100.35594679284569,
	100.23156280419917,100.10837654503896,99.98637234185784,99.8655346844625,99.7458482286852,
	99.62729779876918,99.50986838944382,99.39354516770699,99.27831347432947,99.16415882509706,
	99.05106691180514,98.93902360302017,98.82801494462124,98.71802716013538,98.60904665087948,
	98.50105999592024,98.39405395184018,98.28801545246957,98.18293160821433,98.07878970550917,
	97.97557720600724,97.873281745679,97.7718911338008,97.6713933518419,97.57177655225804,
	97.47302905719857,97.375139357135,97.27809610941722,97.18188813676427,97.0865044256955,
	96.99193412490774,96.89816654360436,96.80519114978112,96.7129975684733,96.6215755799694,
	96.5309151179951,96.44100626787151,96.35183926465211,96.26340449124099,96.1756924764965,
	96.08869389332303,96.002399556754,95.91680042202832,95.83188758266377,95.74765226852864,
	95.6640858439143,95.58117980561104,95.49892578098837,95.41731552608206,95.3363409236892,
	95.25599398147338,95.17626683008012,95.09715172126558,95.01864102603761,94.94072723281262,
	94.86340294558666,94.78666088212367,94.71049387216064,94.63489485563053,94.55985688090396,
	94.48537310304958,94.41143678211444,94.33804128142413,94.26518006590344,94.19284670041789,
	94.12103484813622,94.04973826891393,93.97895081769916,93.90866644295909,93.83887918512923,
	93.76958317508384,93.70077263262861,93.63244186501548,93.56458526547907,93.49719731179528,
	93.43027256486181,93.36380566730045,93.29779134208117,93.23222439116778,93.16709969418511,
	93.10241220710756,93.03815696096908,92.97432906059367,92.91092368334725,92.84793607791002,
	92.7853615630692,92.72319552653208,92.66143342375922,92.60007077681718,92.53910317325122,
	92.47852626497688,92.41833576719118,92.35852745730222,92.29909717387754,92.24004081561102,
	92.18135434030754,92.12303376388577,92.06507515939838,92.0074746560696,91.95022843834997,
	91.89333274498763,91.83678386811651,91.7805781523605,91.72471199395373,91.6691818398768,
	91.6139841870082,91.55911558129132,91.50457261691635,91.45035193551662,91.39645022538016,
	91.34286422067467,91.28959070068724,91.23662648907731,91.18396845314356,91.13161350310367,
	91.0795585913876,91.02780071194331,90.97633689955539,90.92516422917575,90.8742798152668,
	90.82368081115617,90.77336440840335,90.72332783617819,90.67356836064978,90.62408328438728,
	90.57486994574654,90.52592571839317,90.47724801057971,90.42883426469464,90.38068195668791,
	90.33278859553388,90.28515172270355,90.23776891164674,90.19063776728338,90.14375592550395,
	90.09712105267916,90.05073084517801,90.0045830288951,89.95867535878583,89.91300561841045,
	89.86757161948589,89.8223712014458,89.77740223100841,89.73266260175228,89.68815023369909,
	89.6438630729046,89.59979909105624,89.55595628507814,89.51233267674327,89.46892631229206,
	89.42573526205821,89.38275762010078,89.33999150384288,89.29743505371677,89.25508643281508,
	89.21294382654825,89.17100544230792,89.12926950913602,89.08773427740026,89.04639801847436,
	89.00525902442459,88.96431560770141,88.92356610083648,88.88300885614505,88.84264224543327,
	88.80246465971081,88.7624745089081,88.72267022159878,88.68305024472662,88.64361304333734,
	88.60435710031472,88.56528091612158,88.52638300854483,88.48766191244498,88.44911617951009,
	88.41074437801342,88.37254509257562,88.33451692393075,88.29665848869615,88.25896841914617,
	88.22144536299015,88.18408798315319,88.14689495756151,88.10986497893091,88.07299675455864,
	88.0362890061191,87.99974046946261,87.96334989441768,87.92711604459625,87.89103769720273,
	87.8551136428454,87.81934268535143,87.78372364158486,87.74825534126724,87.71293662680159,
	87.67776635309896,87.64274338740778,87.60786660914614,87.57313490973678,87.53854719244437,
	87.50410237221585,87.46979937552315,87.43563714020833,87.4016146153313,87.36773076102003,
	87.33398454832289,87.30037495906357,87.26690098569824,87.23356163117484,87.20035590879473,
	87.16728284207646,87.13434146462156,87.10153081998274,87.06884996153376,87.03629795234153,
	87.00387386504025,86.97157678170741,86.93940579374156,86.90736000174235,86.87543851539205,
	86.84364045333899,86.81196494308304,86.78041112086221,86.74897813154195,86.71766512850496,
	86.68647127354386,86.65539573675446,86.6244376964314,86.5935963389649,86.56287085873922,
	86.5322604580328,86.50176434691947,86.4713817431718,86.44111187216504,86.41095396678328,
	86.38090726732666,86.35097102141974,86.3211444839216,86.29142691683714,86.2618175892297,
	86.23231577713466,86.20292076347482,86.17363183797679,86.14444829708837,86.11536944389738,
	86.08639458805183,86.05752304568078,86.02875413931679,86.00008719781903,85.97152155629819,
	85.94305655604157,85.91469154444015,85.88642587491591,85.85825890685076,85.83019000551616,
	85.80221854200389,85.77434389315779,85.74656544150625,85.71888257519606,85.69129468792681,
	85.6638011788864,85.63640145268737,85.6090949193043,85.58188099401168,85.55475909732323,
	85.52772865493148,85.50078909764854,85.47393986134765,85.44718038690539,85.42051012014483,
	85.39392851177934,85.36743501735731,85.34102909720755,85.31471021638534,85.28847784461938,
	85.26233145625943,85.23627053022444,85.21029454995181,85.18440300334693,85.15859538273348,
	85.1328711848046,85.10722991057457,85.08167106533107,85.05619415858828,85.0307987040403,
	85.00548421951547,84.9802502269313,84.9550962522496,84.9300218254328,84.90502648040034,
	84.88010975498582,84.85527119089491,84.83051033366343,84.80582673258847,84.78121994080028,
	84.7566895150509,84.73223501579045,84.70785600709858,84.68355205664604,84.65932273565623,
	84.63516761886815,84.61108628449878,84.58707831420674,84.56314329305587,84.53928080947985,
	84.51549045524666,84.4917718254239,84.46812451834433,84.44454813557205,84.42104228186898,
	84.39760656516162,84.3742405965086,84.35094399006822,84.32771636306673,84.30455733576683,
	84.28146653143655,84.2584435763187,84.23548809960032,84.21259973338309,84.18977811265347,
	84.16702287525365,84.14433366185277,84.12171011591822,84.0991518836878,84.07665861414166,
	84.05422995897509,84.03186557257109,84.00956511197397,83.9873282368626,83.96515460952438,
	83.9430438948294,83.92099576020486,83.89900987560998,83.87708591351094,83.85522354885647,
	83.83342245905341,83.81168232394253,83.79000282577518,83.76838364918949,83.74682448118725,
	83.72532501111118,83.70388493062207,83.68250393367659,83.66118171650507,83.63991797758962,
	83.6187124176427,83.59756473958564,83.57647464852754,83.55544185174462,83.5344660586593,
	83.51354698082008,83.49268433188129,83.47187782758333,83.45112718573274,83.43043212618309,
	83.40979237081544,83.3892076435196,83.36867767017512,83.34820217863302,83.327780898697,
	83.30741356210572,83.28709990251463,83.2668396554782,83.24663255843255,83.22647835067791,
	83.20637677336161,83.18632756946114,83.16633048376718,83.14638526286733,83.12649165512943,
	83.10664941068552,83.0868582814157,83.06711802093244,83.04742838456471,83.02778912934258,
	83.0082000139819,82.988660798869,82.96917124604597,82.94973111919543,82.9303401836262,
	82.91099820625871,82.89170495561045,82.87246020178206,82.85326371644304,82.83411527281805,
	82.81501464567303,82.79596161130166,82.77695594751195,82.75799743361283,82.73908585040115,
	82.7202209801485,82.70140260658843,82.68263051490372,82.66390449171365,82.64522432506168,
	82.62658980440301,82.60800072059241,82.58945686587221,82.5709580338601,82.5525040195376,
	82.5340946192382,82.51572963063585,82.49740885273337,82.47913208585128,82.46089913161647,
	82.44270979295115,82.42456387406185,82.4064611804285,82.38840151879369,82.37038469715213,
	82.35241052473985,82.33447881202414,82.31658937069282,82.29874201364437,82.28093655497759,
	82.26317280998161,82.24545059512614,82.22776972805151,82.210130027559,82.19253131360132,
	82.17497340727283,82.1574561308005,82.13997930753432,82.12254276193813,82.10514631958054,
	82.08778980712586,82.07047305232514,82.05319588400734,82.03595813207042,82.0187596274729,
	82.00160020222503,81.9844796893804,81.9673979230274,81.95035473828113,81.93334997127475,
	81.91638345915166,81.89945504005713,81.88256455313042,81.86571183849685,81.84889673725979,
	81.83211909149307,81.8153787442331,81.79867553947126,81.78200932214652,81.76537993813761,
	81.74878723425597,81.73223105823804,81.71571125873837,81.69922768532204,81.68278018845778,
	81.66636861951083,81.64999283073594,81.63365267527038,81.61734800712713,81.60107868118814,
	81.58484455319743,81.56864547975458,81.55248131830803,81.53635192714854,81.52025716540278,
	81.50419689302679,81.48817097079971,81.47217926031746,81.45622162398641,81.44029792501735,
	81.42440802741926,81.40855179599322,81.39272909632645,81.37693979478637,81.36118375851463,
	81.3454608554213,81.32977095417912,81.31411392421766,81.29848963571774,81.2828979596057,
	81.2673387675479,81.25181193194511,81.23631732592715,81.22085482334728,81.20542429877703,
	81.19002562750066,81.17465868551007,81.15932334949939,81.1440194968599,81.12874700567498,
	81.1135057547147,81.09829562343116,81.08311649195315,81.06796824108145,81.0528507522838,
	81.03776390769005,81.02270759008722,81.007681682915,80.99268607026076,80.97772063685488,
	80.96278526806626,80.9478798498975,80.93300426898047,80.91815841257171,80.90334216854798,
	80.88855542540179,80.87379807223697,80.85906999876434,80.84437109529722,80.82970125274744,
	80.81506036262083,80.800448317013,80.78586500860524,80.7713103306604,80.7567841770187,
	80.74228644209366,80.7278170208681,80.71337580889013,80.6989627022691,80.68457759767176,
	80.67022039231824,80.65589098397841,80.64158927096771,80.62731515214364,80.61306852690186,
	80.59884929517231,80.58465735741592,80.57049261462045,80.55635496829713,80.54224432047704,
	80.52816057370731,80.51410363104789,80.50007339606776,80.48606977284159,80.47209266594618,
	80.4581419804571,80.44421762194524,80.43031949647344,80.41644751059319,80.40260157134122,
	80.38878158623622,80.37498746327579,80.36121911093274,80.34747643815241,80.33375935434914,
	80.3200677694032,80.3064015936577,80.29276073791534,80.27914511343562,80.26555463193147,
	80.2519892055664,80.23844874695145,80.2249331691422,80.21144238563585,80.19797631036826,
	80.18453485771094,80.17111794246844,80.15772547987523,80.14435738559291,80.13101357570756,
	80.11769396672668,80.10439847557666,80.09112701959997,80.07787951655229,80.06465588460001,
	80.05145604231748,80.03827990865824,80.02512740305764,80.01199844527085,79.9988929554776,
	79.98581085425242,79.97275206256224,79.95971650176362,79.94670409360057,79.93371476020167,
	79.9207484240779,79.90780500812002,79.89488443559627,79.88198663014973,79.86911151579622,
	79.85625901692163,79.84342905827982,79.83062156499007,79.81783646253481,79.80507367675754,
	79.79233313386013,79.77961476040085,79.76691848329209,79.754244229798,79.74159192753248,
	79.72896150445669,79.71635288887717,79.70376600944343,79.691200795146,79.67865717531409,
	79.66613507961378,79.65363443804551,79.64115518094243,79.62869723896793,79.61626054311391,
	79.60384502469859,79.59145061536444,79.5790772470764,79.56672485211955,79.55439336309756,
	79.54208271293027,79.52979283485212,79.51752366240997,79.50527512946142,79.49304717017267,
	79.48083971901683,79.46865271077183,79.4564860805188,79.44433976364013,79.43221369581752,
	79.4201078130304,79.40802205155391,79.39595634795724,79.38391063910179,79.3718848621394,
	79.35987895451073,79.34789285394338,79.33592649845012,79.3239798263274,79.31205277615344,
	79.30014528678663,79.2882572973639,79.27638874729892,79.26453957628061,79.25270972427144,
	79.24089913150573,79.22910773848818,79.21733548599217,79.20558231505814,79.19384816699211,
	79.18213298336411,79.17043670600654,79.1587592770126,79.14710063873495,79.13546073378404,
	79.12383950502655,79.11223689558405,79.10065284883137,79.08908730839524,79.07754021815266,
	79.06601152222964,79.05450116499969,79.04300909108218,79.03153524534125,79.02007957288417,
	79.00864201905996,78.99722252945814,78.98582104990714,78.97443752647301,78.96307190545811,
	78.9517241333997,78.94039415706857,78.92908192346776,78.91778737983118,78.90651047362235,
	78.89525115253304,78.88400936448197,78.87278505761351,78.86157818029658,78.85038868112298,
	78.83921650890653,78.8280616126817,78.81692394170209,78.80580344543965,78.79470007358313,
	78.78361377603694,78.77254450291993,78.76149220456425,78.75045683151416,78.73943833452458,
	78.72843666456042,78.71745177279483,78.70648361060853,78.69553212958832,78.68459728152611,
	78.67367901841779,78.66277729246185,78.65189205605866,78.64102326180904,78.63017086251318,
	78.61933481116982,78.6085150609747,78.5977115653199,78.58692427779252,78.57615315217369,
	78.56539814243746,78.55465920274985,78.54393628746759,78.53322935113736,78.52253834849454,
	78.51186323446221,78.50120396415028,78.49056049285426,78.47993277605437,78.46932076941457,
	78.45872442878154,78.44814371018356,78.43757856982974,78.42702896410898,78.41649484958886,
	78.40597618301489,78.39547292130935,78.38498502157056,78.37451244107176,78.36405513726022,
	78.3536130677564,78.34318619035282,78.33277446301345,78.32237784387249,78.31199629123364,
	78.30162976356915,78.29127821951896,78.28094161788978,78.27061991765417,78.26031307794973,
	78.25002105807819,78.23974381750466,78.2294813158565,78.2192335129228,78.20900036865321,
	78.19878184315745,78.18857789670409,78.17838848972,78.16821358278942,78.15805313665315,
	78.14790711220772,78.13777547050458,78.12765817274935,78.1175551803009,78.10746645467071,
	78.09739195752194,78.08733165066874,78.07728549607548,78.06725345585575,78.057235492272,
	78.04723156773436,78.03724164480019,78.0272656861731,78.01730365470239,78.00735551338212,
	77.99742122535054,77.98750075388921,77.97759406242236,77.96770111451615,77.95782187387788,
	77.94795630435536,77.93810436993616,77.92826603474688,77.91844126305244,77.90863001925553,
	77.89883226789563,77.88904797364854,77.87927710132564,77.86951961587322,77.8597754823717,
	77.85004466603509,77.84032713221026,77.83062284637624,77.82093177414366,77.81125388125396,
	77.8015891335788,77.79193749711948,77.78229893800616,77.7726734224973,77.76306091697903,
	77.75346138796446,77.74387480209312,77.73430112613022,77.72474032696621,77.71519237161596,
	77.70565722721827,77.69613486103526,77.68662524045168,77.6771283329744,77.6676441062317,
	77.65817252797287,77.64871356606734,77.63926718850432,77.62983336339211,77.62041205895753,
	77.61100324354537,77.60160688561784,77.59222295375383,77.58285141664861,77.57349224311304,
	77.56414540207307,77.55481086256928,77.54548859375619,77.53617856490179,77.52688074538695,
	77.51759510470491,77.5083216124607,77.49906023837066,77.48981095226189,77.48057372407158,
	77.4713485238467,77.46213532174335,77.45293408802624,77.44374479306825,77.43456740734975,
	77.42540190145827,77.41624824608793,77.40710641203879,77.39797637021663,77.38885809163214,
	77.37975154740067,77.37065670874159,77.3615735469779,77.35250203353553,77.34344213994319,
	77.33439383783156,77.32535709893304,77.3163318950811,77.30731819821001,77.29831598035409,
	77.28932521364746,77.28034587032354,77.27137792271452,77.26242134325085,77.25347610446103,
	77.24454217897087,77.23561953950308,77.22670815887706,77.2178080100082,77.20891906590738,
	77.20004129968089,77.19117468452963,77.18231919374875,77.1734748007274,77.16464147894804,
	77.15581920198619,77.1470079435099,77.13820767727938,77.1294183771466,77.12064001705475,
	77.1118725710379,77.10311601322077,77.0943703178178,77.08563545913334,77.07691141156084,
	77.06819814958259,77.05949564776935,77.05080388077978,77.04212282336027,77.03345245034433,
	77.02479273665229,77.01614365729105,77.00750518735332,76.99887730201762,76.99025997654763,
	76.98165318629195,76.97305690668368,76.96447111323998,76.95589578156175,76.94733088733328,
	76.93877640632176,76.93023231437708,76.9216985874313,76.9131752014984,76.90466213267376,
	76.89615935713402,76.88766685113653,76.87918459101907,76.87071255319944,76.86225071417519,
	76.85379905052318,76.84535753889932,76.83692615603812,76.82850487875233,76.82009368393277,
	76.8116925485478,76.80330144964302,76.79492036434095,76.7865492698408,76.77818814341788,
	76.7698369624235,76.76149570428451,76.75316434650301,76.74484286665601,76.73653124239516,
	76.72822945144628,76.71993747160917,76.71165528075728,76.70338285683728,76.69512017786889,
	76.68686722194441,76.67862396722853,76.67039039195794,76.66216647444108,76.65395219305775,
	76.64574752625883,76.63755245256607,76.62936695057157,76.62119099893776,76.61302457639685,
	76.60486766175059,76.59672023387006,76.58858227169534,76.58045375423511,76.57233466056651,
	76.56422496983473,76.55612466125274,76.54803371410108,76.53995210772747,76.53187982154655,
	76.5238168350397,76.51576312775451,76.50771867930482,76.49968346937014,76.4916574776956,
	76.48364068409147,76.47563306843317,76.46763461066055,76.45964529077811,76.4516650888544,
	76.44369398502185,76.43573195947651,76.42777899247776,76.41983506434804,76.41190015547268,
	76.40397424629944,76.39605731733845,76.3881493491618,76.38025032240336,76.37236021775853,
	76.36447901598396,76.35660669789719,76.34874324437669,76.34088863636114,76.33304285484977,
	76.32520588090156,76.31737769563526,76.30955828022918,76.30174761589299,76.2939456839797,
	76.28615246581583,76.27836794281511,76.27059209644958,76.26282490824926,76.25506635980202,
	76.24731643275315,76.23957510880538,76.23184236971845,76.22411819730901,76.21640257345013,
	76.20869548007148,76.20099689915878,76.19330681275362,76.18562520295335,76.17795205191076,
	76.17028734183383,76.16263105498561,76.1549831736839,76.14734368030105,76.13971255726378,
	76.13208978705295,76.1244753522032,76.11686923530306,76.10927141899434,76.10168188597217,
	76.09410061898468,76.08652760083291,76.0789628143704,76.07140624250314,76.06385786818933,
	76.0563176744391,76.04878564431432,76.04126176092852,76.03374600744644,76.0262383670841,
	76.01873882310842,76.01124735883702,76.0037639576381,75.99628860293016,75.98882127818187,
	75.9813619669118,75.9739106526883,75.96646731912924,75.95903194990181,75.95160452872231,
	75.94418503935613,75.93677346561732,75.92936979136844,75.92197400052054,75.91458607703282,
	75.90720600491242,75.89983376821435,75.89246935104114,75.8851127375429,75.87776391191686,
	75.87042285840734,75.86308956130553,75.85576400494932,75.84844617372313,75.8411360520576,
	75.8338336244297,75.82653887536215,75.81925178942362,75.81197235122828,75.8047005454358,
	75.79743635675106,75.79017976992402,75.78293076974958,75.77568934106732,75.76845546876135,
	75.7612291377603,75.7540103330368,75.74679903960772,75.73959524253367,75.73239892691905,
	75.72521007791165,75.71802868070279,75.7108547205269,75.70368818266147,75.69652905242681,
	75.68937731518602,75.68223295634468,75.6750959613507,75.66796631569427,75.66084400490767,
	75.653729014565,75.64662133028207,75.63952093771637,75.6324278225667,75.62534197057316,
	75.61826336751702,75.61119199922035,75.60412785154614,75.59707091039789,75.59002116171975,
	75.58297859149604,75.57594318575136,75.56891493055025,75.56189381199722,75.55487981623642,
	75.5478729294516,75.54087313786596,75.53388042774196,75.52689478538113,75.51991619712413,
	75.5129446493503,75.50598012847777,75.4990226209632,75.4920721133016,75.48512859202626,
	75.47819204370863,75.47126245495808,75.46433981242188,75.45742410278491,75.4505153127697,
	75.44361342913606,75.43671843868118,75.42983032823935,75.42294908468186,75.41607469491687,
	75.40920714588924
	}}
};
table1d_imp<2001> tubetable2_6V6[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	4635992.402307132,4623630.920878677,4611263.194911325,4598889.424112773,4586509.808691225,
	4574124.549342928,4561733.847242487,4549337.904028853,4536936.921789848,4524531.103047258,
	4512120.650747813,4499705.768248997,4487286.659301642,4474863.5280377455,4462436.578957116,
	4450006.016913829,4437572.047108263,4425134.87505605,4412694.706592667,4400251.747849222,
	4387806.205240082,4375358.285451651,4362908.195425325,4350456.142341103,4338002.333610879,
	4325546.97685631,4313090.279896041,4300632.450736422,4288173.697551605,4275714.228672401,
	4263254.252566141,4250793.977832139,4238333.613175435,4225873.367404676,4213413.449408252,
	4200954.068139686,4188495.432609457,4176037.751868214,4163581.2349883844,4151126.0910513527,
	4138672.5291358773,4126220.7582999654,4113770.9875673256,4101323.425914303,4088878.2822526623,
	4076435.7654163702,4063996.084146986,4051559.4470809214,4039126.062728547,4026696.1394650196,
	4014269.8855200545,4001847.5089520505,3989429.217640493,3977015.2192738447,3964605.721327777,
	3952200.9310585214,3939801.055481354,3927406.3013618086,3915016.875197993,3902632.983209256,
	3890254.831317366,3877882.6251370935,3865516.569959847,3853156.870739569,3840803.732077344,
	3828457.3582131816,3816117.9530005828,3803785.719905553,3791460.8619872867,3779143.581879863,
	3766834.081784172,3754532.563452126,3742239.2281763754,3729954.276771595,3717677.9095623046,
	3705410.326373729,3693151.7265106593,3680902.308750795,3668662.271331734,3656431.8119305787,
	3644211.12765994,3632000.4150487715,3619799.870030232,3607609.6879318096,3595430.063462303,
	3583261.190692685,3571103.263053712,3558956.4733147305,3546821.0135765565,3534697.0752555933,
	3522584.8490777384,3510484.5250564944,3498396.2924890546,3486320.339942152,3474256.8552398942,
	3462206.025451198,3450168.036879863,3438143.0750511526,3426131.3247020347,3414132.9697710555,
	3402148.193381668,3390177.177839122,3378220.1046133675,3366277.1543296287,3354348.506760266,
	3342434.3408097997,3330534.8345090128,3318650.1649999064,3306780.5085301897,3294926.040440909,
	3283086.935154199,3271263.366167764,3259455.50604229,3247663.526391369,3235887.5978732673,
	3224127.8901849296,3212384.572043486,3200657.8111869777,3188947.7743589072,3177254.6273025046,
	3165578.5347504695,3153919.6604186357,3142278.1669933107,3130654.216127838,3119047.968429447,
	3107459.583456205,3095889.219705234,3084337.034607334,3072803.184516391,3061287.824705374,
	3049791.109355938,3038313.191553879,3026854.2232793276,3015414.3554037064,3003993.7376763155,
	2992592.5187233295,2981210.8460416794,2969848.8659864953,2958506.723772063,2947184.563461117,
	2935882.527958953,2924600.759011131,2913339.397193768,2902098.581910985,2890878.4513854976,
	2879679.142658834,2868500.791581028,2857343.532809576,2846207.499802324,2835092.8248128267,
	2823999.638886168,2812928.0718558747,2801878.252336745,2790850.3077231986,2779844.3641851484,
	2768860.5466618054,2757898.9788592304,2746959.783250097,2736043.081063631,2725148.9922880405,
	2714277.635664527,2703429.1286849105,2692603.5875892467,2681801.127362084,2671021.8617306207,
	2660265.9031623495,2649533.362861581,2638824.350769402,2628138.9755593883,2617477.3446362354,
	2606839.5641360353,2596225.738920678,2585635.9725811416,2575070.3674316937,2564529.0245121005,
	2554012.0435831747,2543519.5231301906,2533051.560356741,2522608.25118925,2512189.6902727415,
	2501795.970971935,2491427.185369547,2481083.4242690867,2470764.7771917954,2460471.3323770855,
	2450203.176785323,2439960.3960946845,2429743.074704335,2419551.295732373,2409385.1410202645,
	2399244.6911282656,2389130.025342938,2379041.2216717936,2368978.3568490315,2358941.506335107,
	2348930.744318386,2338946.1437147413,2328987.77617407,2319055.712075517,2309150.020535736,
	2299270.7694060137,2289418.0252771247,2279591.8534798664,2269792.3180891257,2260019.48192438,
	2250273.4065530878,2240554.1522945883,2230861.778219968,2221196.3421583497,2211557.900695994,
	2201946.5091827097,2192362.221732815,2182805.0912297852,2173275.1693285406,2163772.5064592627,
	2154297.151831075,2144849.1534357215,2135428.5580501542,2126035.41124269,2116669.7573739314,
	2107331.6396036786,2098021.099892078,2088738.179006414,2079482.9165235253,2070255.3508352125,
	2061055.519152123,2051883.457507842,2042739.2007646991,2033622.7826168262,2024534.2355963734,
	2015473.5910770409,2006440.8792803553,1997436.1292786638,1988459.3690023243,1979510.6252432012,
	1970589.9236603335,1961697.2887854045,1952832.744027852,1943996.311679805,1935188.0129228595,
	1926407.8678312688,1917655.8953797147,1908932.113448581,1900236.538827722,1891569.1872246028,
	1882930.0732686883,1874319.2105178984,1865736.611464002,1857182.2875393599,1848656.2491216063,
	1840158.5055414392,1831689.065087201,1823247.9350119005,1814835.1215392235,1806450.6298696066,
	1798094.4641867646,1789766.62766402,1781467.122470745,1773195.949778145,1764953.1097666577,
	1756738.6016322405,1748552.42359226,1740394.5728925616,1732265.0458147337,1724163.8376810844,
	1716090.9428633526,1708046.3547876053,1700030.0659423515,1692042.0678843956,1684082.3512461092,
	1676150.9057426446,1668247.720177461,1660372.7824508466,1652526.0795655423,1644707.5976347153,
	1636917.321887898,1629155.236678985,1621421.325492055,1613715.570949995,1606037.9548196348,
	1598388.4580205968,1590767.0606308058,1583173.7418946803,1575608.4802300734,1568071.2532346987,
	1560562.037694174,1553080.8095882956,1545627.5440989516,1538202.215616448,1530804.7977479014,
	1523435.2633226498,1516093.58440122,1508779.7322814402,1501493.6775058394,1494235.389868787,
	1487004.8384238435,1479801.991491231,1472626.8166641726,1465479.2808167543,1458359.350111004,
	1451266.9900038976,1444202.1652549347,1437164.8399326853,1430154.9774225438,1423172.5404336469,
	1416217.491006022,1409289.7905179113,1402389.3996927193,1395516.2786062465,1388670.3866936676,
	1381851.6827571546,1375060.1249724403,1368295.6708960896,1361558.2774724155,1354847.901041068,
	1348164.4973438603,1341508.0215313868,1334878.4281704333,1328275.671251403,1321699.704194223,
	1315150.4798565889,1308627.9505397116,1302132.0679965464,1295662.7834375247,1289220.047538106,
	1282803.8104457036,1276414.0217862877,1270050.6306713158,1263713.5857046053,1257402.8349893864,
	1251118.326134149,1244860.0062607813,1238627.8220102978,1232421.7195497223,1226241.6445790709,
	1220087.5423377354,1213959.3576113048,1207857.0347380803,1201780.517615446,1195729.7497068988,
	1189704.6740482484,1183705.233254107,1177731.3695244014,1171783.0246508948,1165860.1400236578,
	1159962.656637167,1154090.5150968505,1148243.6556255468,1142422.0180693262,1136625.5419043205,
	1130854.1662427238,1125107.8298387423,1119386.4710949967,1113690.028068775,1108018.4384779169,
	1102371.6397069546,1096749.5688129952,1091152.1625320422,1085579.3572847368,1080031.0891822737,
	1074507.2940323248,1069007.9073450745,1063532.8643387065,1058082.0999455547,1052655.5488176527,
	1047253.1453323658,1041874.8235983383,1036520.5174609774,1031190.1605081462,1025883.6860754811,
	1020601.0272523179,1015342.1168870778,1010106.8875924519,1004895.2717512295,999707.2015214434,
	994542.6088417205,989401.4254367651,984283.5828224337,979189.0123111892,974117.6450171581,
	969069.4118612552,964044.2435765307,959042.0707129879,954062.8236428784,949106.4325653643,
	944172.8275121077,939261.9383514147,934373.6947938929,929508.0263966959,924664.8625687812,
	919844.1325754882,915045.7655432274,910269.6904643696,905515.8362017764,900784.1314933678,
	896074.5049569836,891386.8850946827,886721.2002972858,882077.3788488847,877455.3489312541,
	872855.0386284518,868276.375930808,863719.2887394183,859183.7048705334,854669.55205971,
	850176.7579658565,845705.2501756508,841254.9562075537,836825.8035158564,832417.7194947766,
	828030.631482428,823664.4667648465,819319.1525798884,814994.6161211502,810690.7845417866,
	806407.5849583284,802144.9444545248,797902.7900850527,793681.0488791529,789479.6478444284,
	785298.5139703766,781137.574231983,776996.7555933996,772875.9850112498,768775.1894383167,
	764694.2958268727,760633.2311321335,756591.9223156105,752570.2963484173,748568.2802145971,
	744585.8009144821,740622.7854676394,736679.1609164848,732754.8543290073,728849.792802148,
	724963.9034648302,721097.1134809314,717249.3500523657,713420.5404221065,709610.6118770522,
	705819.491750926,702047.1074271413,698293.3863417527,694558.2559861406,690841.6439098428,
	687143.4777231863,683463.6851002226,679802.1937810683,676158.9315748181,672533.8263621186,
	668926.8060974763,665337.7988121446,661766.7326163307,658213.5357019127,654678.1363446949,
	651160.4629068952,647660.4438394892,644178.0076846281,640713.0830777872,637265.5987502665,
	633835.4835311763,630422.6663499181,627027.076238172,623648.6423321725,620287.2938747264,
	616942.9602174509,613615.5708226663,610305.0552655775,607011.343236206,603734.3645413297,
	600474.0491065705,597230.3269781143,594003.1283247923,590792.383439772,587598.0227425146,
	584419.976780495,581258.1762310293,578112.5519029937,574983.0347385365,571869.555814801,
	568772.046345552,565690.4376828411,562624.6613186079,559574.6488862393,556540.3321621941,
	553521.6430674304,550518.5136689902,547530.8761814813,544558.6629684563,541601.8065439147,
	538660.2395737077,535733.8948767851,532822.7054267727,529926.6043530804,527045.5249423431,
	524179.4006396581,521328.16504982935,518491.75193862594,515670.09523392544,512863.12902698497,
	510070.7875735759,507293.0052950901,504529.7167796449,501780.85678326886,499046.36023084866,
	496326.1622172626,493620.19800839684,490928.4030421108,488250.7129292478,485587.0634546068,
	482937.39057784394,480301.6304344645,477679.71933657466,475071.59377397643,472477.19041485,
	469896.4461066227,467329.2978768585,464775.682933983,462235.5386680982,459708.8026517188,
	457195.4126405265,454695.30657407833,452208.4225765271,449734.69895728916,447274.0742117013,
	444826.4870216856,442391.8762563574,439970.1809726662,437561.3404159386,435165.29402052396,
	432781.981410256,430411.342399063,428053.31699150795,425707.8453832092,423374.86796142615,
	421054.3253054459,418746.15818709735,416450.3075711934,414166.7146159062,411895.32067323074,
	409636.0672893369,407388.8962049761,405153.74935585173,402930.5688728922,400719.2970826934,
	398519.87650778156,396332.24986687786,394156.3600752649,391992.1502450126,389839.5636852318,
	387698.54390238127,385569.03460044344,383450.9796811433,381344.3232441879,379249.00958744163,
	377164.98320711724,375092.1887979284,373030.5712532362,370980.0756652337,368940.6473250174,
	366912.2317227589,364894.7745477694,362888.22168860823,360892.519233171,358907.6134687526,
	356933.4508820803,354969.9781594363,353017.1421865723,351074.8900488636,349143.16903122346,
	347221.9266181617,345311.1104937518,343410.6685416297,341520.54884493566,339640.6996863093,
	337771.0695478128,335911.60711090505,334062.26125631935,332222.9810640537,330393.7158132159,
	328574.41498197406,326765.02824741986,324965.50548547535,323175.79677075834,321395.8523764301,
	319625.6227740956,317865.05863359896,316114.11082292796,314372.7304079839,312640.86865243944,
	310918.47701754415,309205.5071619405,307501.9109414584,305807.6404089128,304122.64781386894,
	302446.8856024516,300780.3064170728,299122.86309625226,297474.508674313,295835.1963811769,
	294204.879642063,292583.5120772673,290971.047501855,289367.43992539827,287772.64355169865,
	286186.6127784668,284609.30219708034,283040.6665922013,281480.6609415409,279929.24041550275,
	278386.3603768837,276851.9763805158,275326.04417297576,273808.519692215,272299.3590672352,
	270798.518617718,269305.95485371,267821.624475222,266345.484371884,264877.4916225898,
	263417.6034951109,261965.77744570636,260521.97111876766,259086.14234641168,257658.24914809893,
	256238.2497302471,254826.1024857989,253421.76599387065,252025.1990192936,250636.36051223785,
	249255.20960778027,247881.70562549744,246515.80806903186,245157.47662568404,243806.67116596497,
	242463.35174316601,241127.4785929491,239799.0121328796,238477.9129619937,237164.14186036275,
	235857.65978862793,234558.4278875872,233266.4074776978,231981.5600586593,230703.84730892692,
	229433.23108527815,228169.67342233367,226913.13653210338,225663.58280351473,224420.97480195112,
	223185.27526877954,221956.44712087233,220734.45345014753,219519.25752308246,218310.82278025482,
	217109.11283584172,215914.09147715932,214725.72266417433,213543.97052902848,212368.79937555228,
	211200.17367878518,210038.0580844859,208882.4174086673,207733.21663706854,206590.4209247322,
	205453.99559546183,204323.90614136084,203200.1182223446,202082.59766565688,200971.31046536993,
	199866.22278191705,198767.30094158143,197674.51143603722,196587.8209218444,195507.19621996733,
	194432.60431529596,193364.01235615948,192301.3876538421,191244.69768209758,190193.9100766746,
	189148.99263482873,188109.91331485912,187076.64023560937,186049.14167601048,185027.3860745992,
	184011.34202904423,183000.97829568098,181996.2637890367,180997.1675813683,180003.6589022066,
	179015.70713787194,178033.28183104622,177056.35268028747,176084.8895396012,175118.8624179711,
	174158.24147892647,173202.99704008593,172253.09957273016,171308.51970135391,170369.22820324244,
	169435.19600803766,168506.394197316,167582.79400416987,166664.36681278728,165751.0841580364,
	164842.9177250811,163939.83934895607,163041.82101418293,162148.83485438226,161260.85315187898,
	160377.8483373361,159499.7929893704,158626.6598342039,157758.42174527998,156895.0517429398,
	156036.5229940488,155182.80881167963,154333.8826547769,153489.71812782393,152650.28898054585,
	151815.56910758873,150985.532548232,150160.15348609642,149339.40624886652,148523.26530802366,
	147711.70527858147,146904.70091883623,146102.22713014166,145304.25895666808,144510.77158518575,
	143721.74034487474,142937.140707116,142156.9482853254,141381.1388347783,140609.6882524557,
	139842.57257691174,139079.7679881426,138321.2508074725,137566.99749746476,136816.9846618363,
	136071.1890453921,135329.58753397988,134592.1571544599,133858.87507468445,133129.71860350727,
	132404.66519080673,131683.692427526,130966.77804573355,130253.89991870543,129545.03606103038,
	128840.1646287314,128139.26391941213,127442.31237243053,126749.28856908025,126060.17123282007,
	125374.93922951298,124693.57156768441,124016.04739882484,123342.34601770676,122672.44686273369,
	122006.32951632029,121343.97370528977,120685.35930131692,120030.46632139648,119379.27492833896,
	118731.76543130343,118087.91828636467,117447.71409710989,116811.13361527826,116178.15774142797,
	115548.7675256475,114922.94416830754,114300.66902083022,113681.92358653914,113066.6895215061,
	112454.9486354692,111846.68289278276,111241.87441341417,110640.50547398267,110042.55850884641,
	109448.01611123474,108856.86103443331,108269.07619300907,107684.64466408972,107103.54968869805,
	106525.77467313039,105951.30319039283,105380.11898168374,104812.20595794391,104247.54820144258,
	103686.1299674389,103127.93568588833,102572.9499632041,102021.15758408404,101472.54351339638,
	100927.09289810865,100384.79106930293,99845.62354422064,99309.57602838492,98776.63441778763,
	98246.78480111045,97720.01346203443,97196.30688159191,96675.65174057867,96158.03492202648,
	95643.44351373364,95131.86481084616,94623.28631849933,94117.69575450869,93615.08105210823,
	93115.43036275302,92618.7320589431,92124.97473711448,91634.14722055975,91146.23856238552,
	90661.23804850625,90179.13520066363,89699.91977947661,89223.58178750257,88750.11147231163,
	88279.49932957921,87811.73610616325,87346.81280318098,86884.72067907362,86425.45125263552,
	85968.99630602458,85515.3478877098,85064.49831537549,84616.440178761,84171.16634240566,
	83728.66994831311,83288.94441850393,82851.98345743754,82417.78105430868,81986.33148516825,
	81557.62931488706,81131.66939890868,80708.44688479866,80287.95721354727,79870.19612062411,
	79455.1596367403,79042.84408830947,78633.24609757817,78226.36258239335,77822.19075558761,
	77420.72812395543,77021.97248677666,76625.92193388609,76232.57484322705,75841.92987788598,
	75453.98598256055,75068.74237943527,74686.19856344603,74306.35429687695,73929.20960328956,
	73554.7647607334,73183.02029421937,72813.97696743089,72447.63577363567,72083.99792579189,
	71723.06484580135,71364.83815292816,71009.31965131685,70656.51131664679,70306.41528186937,
	69959.03382205588,69614.36933831677,69272.42434083526,68933.20143098982,68596.7032825839,
	68262.9326222135,67931.89220877134,67603.58481214009,67278.01319108512,66955.18007041194,
	66635.08811740502,66317.73991762783,66003.13795012911,65691.28456212253,65382.18194320808,
	65075.832099225125,64772.23682580549,64471.39768171988,64173.31596212211,63877.99267176353,
	63585.42849831604,63295.62378587358,63008.57850876741,62724.29224578408,62442.76415491831,
	62163.99294876087,61887.976870628714,61614.71367156326,61344.20058829582,61076.434322280715,
	60811.411019911866,60549.126254003495,60289.575006644496,60032.75165348955,59778.64994958472,
	59527.26301678938,59278.58333284677,59032.60272218027,58789.31234842549,58548.702708764766,
	58310.76363006026,58075.48426682245,57842.85310099109,57612.85794354954,57385.48593793337,
	57160.7235652177,56938.55665103874,56718.9703742186,56501.949277017884,56287.47727697502,
	56075.53768024858,55866.11319639098,55659.18595447757,55454.73752049181,55252.74891588551,
	55053.20063721224,54856.0726767422,54661.34454395073,54468.995287782906,54279.00351959999,
	54091.34743668536,53906.00484623657,53722.95318972332,53542.169567520185,53363.63076372384,
	53187.313271063045,53013.19331580822,52841.24688260196,52671.44973913022,52503.77746056282,
	52338.205453682596,52174.708980655785,52013.263182367984,51853.84310127691,51696.42370373846,
	51540.97990174828,51387.48657407645,51235.91858674139,51086.250812811064,50938.45815149638,
	50792.515546517316,50648.39800372993,50506.08060799421,50365.53853928618,50226.747088034645,
	50089.68166969556,49954.31783855188,49820.6313007525,49688.59792660583,49558.193762105926,
	49429.395039742856,49302.17818858117,49176.51984363741,49052.39685456591,48929.786293671226,
	48808.66546327465,48689.01190244387,48570.803393110895,48454.017965604195,48338.63390360913,
	48224.6297485875,48111.984303664554,48000.67663702479,47890.68608482444,47781.99225364774,
	47674.57502252885,47568.41454456556,47463.49124813175,47359.78583773402,47257.279294503176,
	47155.952876373616,47055.78811793175,46956.76682999642,46858.8710989098,46762.08328557834,
	46666.38602428267,46571.762221252444,46478.19505305114,46385.667964761575,46294.164667994875,
	46203.66913874599,46114.16561509516,46025.63859476964,45938.07283259614,45851.4533378271,
	45765.765371372116,45680.99444293925,45597.12630809511,45514.14696525118,45432.04265259062,
	45350.799844937166,45270.405250583724,45190.84580806881,45112.1086829371,45034.18126445869,
	44957.05116233897,44880.706203405905,44805.134428293495,44730.324088118905,44656.26364115989,
	44582.941749536665,44510.347275877415,44438.46928010369,44367.29701602671,44296.819928156925,
	44227.027648447576,44157.90999306948,44089.45695921244,44021.658721927,43954.5056309806,
	43887.988207751376,43822.09714216043,43756.82328963457,43692.15766810021,43628.09145502475,
	43564.61598448742,43501.72274429197,43439.40337311833,43377.649657719194,43316.45353014918,
	43255.807065043904,43195.70247692951,43136.13211758628,43077.088473449614,43018.564163047224,
	42960.55193448561,42903.04466297665,42846.03534840635,42789.51711294069,42733.48319868401,
	42677.92696536792,42622.841888084324,42568.22155506455,42514.05966549035,42460.350027355365,
	42407.08655535612,42354.26326882402,42301.874289716005,42249.913840597925,42198.37624272566,
	42147.25591411013,42096.54736765407,42046.24520931075,41996.34413627617,41946.83893523015,
	41897.7244805971,41848.99573285323,41800.647736854735,41752.67562021284,41705.074591701275,
	41657.839939670965,41610.96703053689,41564.451307257106,41518.28828787801,41472.473564067266,
	41427.002799723785,41381.871729577426,41337.07615784014,41292.61195686967,41248.47506587851,
	41204.66148964799,41161.16729728992,41117.98862101651,41075.121654941606,41032.56265391497,
	40990.30793236882,40948.353863188604,40906.69687662109,40865.33345918562,40824.260152626004,
	40783.473552862655,40742.970308995464,40702.74712229997,40662.8007452524,40623.127980589554,
	40583.725680367585,40544.59074505095,40505.72012261478,40467.11080767604,40428.75984063102,
	40390.66430681121,40352.821335667766,40315.228099967244,40277.88181498397,40240.77973775417,
	40203.91916629208,40167.297438867725,40130.91193326957,40094.76006609305,40058.839292051474,
	40023.14710327621,39987.68102866929,39952.438633225276,39917.41751740915,39882.61531650904,
	39848.02970001513,39813.65837108299,39779.499065820164,39745.54955280821,39711.8076324832,
	39678.27113660446,39644.937927691004,39611.80589849592,39578.872971479956,39546.13709829702,
	39513.59625928932,39481.24846299909,39449.09174567669,39417.124170811505,39385.34382866526,
	39353.74883582211,39322.33733472984,39291.10749327162,39260.057504334254,39229.185585385625,
	39198.48997806292,39167.9689477709,39137.62078327604,39107.44379632426,39077.436321263,
	39047.596714657826,39017.92335492988,38988.414641992735,38959.068996910144,38929.88486153174,
	38900.86069817202,38871.99498925947,38843.28623702436,38814.732963164526,38786.33370854947,
	38758.087032892174,38729.99151445187,38702.045749747354,38674.24835325215,38646.59795711272,
	38619.093210870284,38591.73278117687,38564.51535154537,38537.43962205651,38510.50430911718,
	38483.70814519454,38457.049878580336,38430.52827312129,38404.14210799819,38377.8901774754,
	38351.77129067519,38325.78427134205,38299.92795762751,38274.201201857504,38248.60287033058,
	38223.1318430857,38197.78701371189,38172.56728913525,38147.47158940982,38122.49884753596,
	38097.6480092524,38072.91803285368,38048.30788899531,38023.81656051384,37999.44304225121,
	37975.18634086096,37951.045474651706,37927.01947340332,37903.107378204986,37879.308241281535,
	37855.62112584244,37832.045105918085,37808.57926618444,37785.22270184285,37761.97451843137,
	37738.83383170734,37715.799767482524,37692.87146147957,37670.048059198154,37647.32871576859,
	37624.71259581661,37602.198873333065,37579.786731539614,37557.47536274907,37535.26396825209,
	37513.15175818594,37491.13795140432,37469.221775362,37447.4024659997,37425.67926761311,
	37404.05143275209,37382.518222092454,37361.07890434578,37339.7327561063,37318.47906180628,
	37297.317113551035,37276.24621104406,37255.26566147961,37234.37477943667,37213.5728867813,
	37192.8593125722,37172.233392954986,37151.69447108006,37131.24189699929,37110.87502757346,
	37090.59322639028,37070.39586366393,37050.28231616408,37030.251967107826,37010.30420609074,
	36990.438428998954,36970.654037927685,36950.95044109473,36931.32705276989,36911.78329318557,
	36892.31858847345,36872.93237057477,36853.62407717232,36834.39315159935,36815.23904283922,
	36796.16120533918,36777.15909901329,36758.232189170536,36739.37994642674,36720.60184664359,
	36701.89737086822,36683.266005267666,36664.70724104863,36646.22057441989,36627.805506507495,
	36609.461543311365,36591.18819562422,36572.98497899707,36554.85141365645,36536.78702446543,
	36518.7913408501,36500.86389676727,36483.00423062026,36465.211885221324,36447.48640774162,
	36429.8273496474,36412.23426665187,36394.706718665926,36377.244269744464,36359.846488041105,
	36342.51294575795,36325.243219084885,36308.03688817771,36290.89353708377,36273.81275371601,
	36256.79412978786,36239.837260798464,36222.941745949676,36206.10718812856,36189.333193863444,
	36172.61937326526,36155.96534000984,36139.37071126962,36122.8351076879,36106.358153342575,
	36089.93947569512,36073.57870556163,36057.27547706658,36041.0294276058,36024.84019781262,
	36008.7074315273,35992.63077573955,35976.609880578915,35960.6443992482,35944.73398802998,
	35928.87830620746,35913.0770160664,35897.32978283396,35881.636274671924,35865.99616262349,
	35850.40912058375,35834.87482528087,35819.39295623279,35803.96319571887,35788.585228752214,
	35773.25874304634,35757.98342898314,35742.7589795974,35727.58509052881,35712.46145999945,
	35697.38778879764,35682.36378023921,35667.389140136234,35652.46357678144,35637.58680091262,
	35622.75852569345,35607.97846667174,35593.24634178415,35578.56187129247,35563.924777791246,
	35549.334786167696,35534.79162357778,35520.295019425816,35505.84470533383,35491.44041512666,
	35477.08188481184,35462.76885254133,35448.501058603724,35434.27824539367,35420.10015738649,
	35405.96654113744,35391.87714522515,35377.83172027433,35363.8300188948,35349.87179567352,
	35335.95680717304,35322.08481188949,35308.255570233036,35294.468844523435,35280.724398958904,
	35267.02199959684,35253.36141434393,35239.74241292239,35226.16476687566,35212.628249518806,
	35199.132635944225,35185.67770300272,35172.263229267206,35158.88899503494,35145.554782307816,
	35132.260374759644,35119.00555773852,35105.7901182407,35092.61384490034,35079.47652795921,
	35066.3779592766,35053.31793227423,35040.29624197355,35027.312684914934,35014.36705922016,
	35001.45916450209,34988.58880190146,34975.75577404018,34962.959885042656,34950.200940478404,
	34937.47874737549,34924.79311419458,34912.14385085737,34899.53076865366,34886.953680278995,
	34874.41239982134,34861.90674274533,34849.43652585571,34837.00156731152,34824.60168661783,
	34812.23670457405,34799.90644329738,34787.61072621267,34775.349378007166,34763.122224656196,
	34750.92909338073,34738.76981265436,34726.644212191146,34714.55212292047,34702.49337699037,
	34690.46780774846,34678.47524972927,34666.515538658176,34654.5885114125,34642.694006041056,
	34630.831861738385,34619.001918831666,34607.204018770484,34595.43800412895,34583.70371858555,
	34572.00100691384,34560.32971497267,34548.689689694314,34537.08077908341,34525.502832198916,
	34513.95569914594,34502.43923107333,34490.95328014838,34479.49769957072,34468.072343541324,
	34456.67706726977,34445.31172694695,34433.97617975773,34422.670283865125,34411.39389838393,
	34400.14688340661,34388.92909995191,34377.74041000421,34366.580676468766,34355.449763172735,
	34344.34753486492,34333.273857205466,34322.22859675095,34311.21162095488,34300.22279815217,
	34289.26199755661,34278.32908925525,34267.42394419961,34256.54643418812,34245.69643187517,
	34234.87381075106,34224.07844514459,34213.310210205724,34202.56898191266,34191.85463704345,
	34181.1670531883,34170.50610874395,34159.871682885176,34149.26365558131,34138.681907575046,
	34128.12632039203,34117.596776309256,34107.09315837416,34096.61535038367,34086.16323687861,
	34075.73670314541,34065.335635201336,34054.959919794775,34044.60944438978,34034.284097182484,
	34023.98376706202,34013.70834362494,34003.45771718362,33993.231778698195,33983.03041990509,
	33972.8535331343,33962.70101142754,33952.57274849317,33942.468638706814,33932.388577104466,
	33922.332459374564,33912.30018186017,33902.291641534786,33892.30673603185,33882.34536360064,
	33872.40742312916,33862.49281412133,33852.60143671023,33842.73319161866,33832.88798023907,
	33823.06570448442,33813.266266920815,33803.48957069646,33793.7355195561,33784.00401780525,
	33774.29497036127,33764.60828269847,33754.943860873056,33745.30161149825,33735.68144175468,
	33726.08325937973,33716.506972671465,33706.95249046335,33697.419722146326,33687.90857764865,
	33678.4189674485,33668.95080252564,33659.5039944153,33650.078455344184,33640.6740973417,
	33631.29083404799,33621.92857887359,33612.587245926334,33603.26674982861,33593.967005689,
	33584.68792911776,33575.42943622855,33566.19144361381,33556.9738683496,33547.77662799914,
	33538.59964061001,33529.442824692684,33520.306099242975,33511.189383706755,33502.09259801549,
	33493.015662535036,33483.95849812027,33474.92102605429,33465.903168086305,33456.90484640007,
	33447.925983634384,33438.96650286458,33430.026327604384,33421.10538179484,33412.203589819284,
	33403.3208764925,33394.4571670262,33385.612387086265,33376.786462738135,33367.97932047069,
	33359.19088717756,33350.421090172444,33341.66985716805,33332.93711628531,33324.222796035676,
	33315.526825379384,33306.8491335585,33298.18965029923,33289.548305713986,33280.925030266735,
	33272.319754819444,33263.73241062038,33255.162929287944,33246.611242820465,33238.07728359136,
	33229.56098432894,33221.06227814894,33212.581098529015,33204.11737929045,33195.67105463192,
	33187.24205911096,33178.83032762289,33170.43579542811,33162.05839814057,33153.698071710394,
	33145.35475243696,33137.02837696398,33128.71888227531,33120.42620568081,33112.1502848482,
	33103.89105775626,33095.6484627346,33087.422438418624,33079.21292378679,33071.0198581317,
	33062.84318107596,33054.68283255699,33046.5387528247,33038.41088245834,33030.2991623322,
	33022.20353364558,33014.12393789501,33006.060316895026,32998.012612755934,32989.98076789667,
	32981.96472502285,32973.964427159146,32965.979817615145,32958.01083998921,32950.05743818076,
	32942.1195563744,32934.197139052914,32926.290130971174,32918.39847717289,32910.52212299451,
	32902.66101404453,32894.815096208935,32886.98431565092,32879.16861880919,32871.36795239937,
	32863.582263413075,32855.81149909522,32848.05560697651,32840.31453484259,32832.58823073742,
	32824.87664299793,32817.179720180306,32809.49741112733,32801.82966493042,32794.17643094875,
	32786.53765877395,32778.91329826811,32771.303299534164,32763.70761292963,32756.126189051804,
	32748.5589787533,32741.005933136163,32733.467003527658,32725.942141508607,32718.43129889699,
	32710.934427745735,32703.451480346353,32695.98240922245,32688.52716714746,32681.085707112976,
	32673.65798232095,32666.24394625356,32658.84355256445,32651.456755182713,32644.08350822627,
	32636.72376604585,32629.37748323096,32622.04461456908,32614.725115084373,32607.418940004005,
	32600.126044774912,32592.84638507555,32585.579916772258,32578.326595963,32571.08637895348,
	32563.85922224523,32556.645082567004,32549.443916848057,32542.25568221258,32535.08033599072,
	32527.91783574651,32520.7681392155,32513.631204339697,32506.506989260983,32499.395452320292,
	32492.29655205855,32485.21024721572,32478.136496705305,32471.07525966385,32464.026495397542,
	32456.990163418242,32449.966223422725,32442.954635287748,32435.955359094107,32428.96835509635,
	32421.99358373233,32415.031005636338,32408.08058161825,32401.14227267506,32394.216039974028,
	32387.301844873724,32380.39964890309,32373.50941377668,32366.631101368315,32359.764673766964,
	32352.91009317365,32346.06732202697,32339.236322890138,32332.417058531802,32325.60949187102,
	32318.813585994023,32312.02930416542,32305.256609818614,32298.495466545293,32291.745838099523,
	32285.00768841473,32278.280981574917,32271.5656818325,32264.861753600915,32258.169161444308,
	32251.48787009904,32244.817844463174,32238.159049569018,32231.511450635477,32224.87501301677,
	32218.249702226694,32211.63548394277,32205.03232397749,32198.440188311757,32191.85904307014,
	32185.28885454289,32178.729589128452,32172.18121341955,32165.64369414049,32159.11699815482,
	32152.60109248554,32146.095944290304,32139.601520873195,32133.117789693093,32126.644718336356,
	32120.182274535753,32113.73042616578,32107.289141250523,32100.858387937802,32094.4381345313,
	32088.0283494546,32081.62900128604,32075.240058731615,32068.861490625728,32062.49326595474,
	32056.135353822116,32049.787723477675,32043.450344307443,32037.123185803106,32030.806217618057,
	32024.499409520256,32018.20273141817,32011.916153318096,32005.63964540308,31999.37317794966,
	31993.116721372324,31986.870246206207,31980.63372311823,31974.407122895846,31968.19041645312,
	31961.98357483384,31955.786569181666,31949.59937078254,31943.421951052773,31937.25428149933,
	31931.096333768855,31924.94807962762,31918.809490962085,31912.680539751636,31906.561198137395,
	31900.451438333646,31894.35123269974,31888.260553705888,31882.179373913248,31876.10766602755,
	31870.04540286011,31863.992557326103,31857.949102459814,31851.91501140601,31845.89025741754,
	31839.874813870814,31833.868654226753,31827.871752083447,31821.88408113165,31815.905615176678,
	31809.93632812268,31803.976193996532,31798.025186909505,31792.083281106512,31786.15045091583,
	31780.226670771935,31774.311915231177,31768.406158930957,31762.50937662666,31756.62154316762,
	31750.74263351628,31744.87262273057,31739.01148596449,31733.159198468897,31727.315735623324,
	31721.481072858936,31715.655185757078,31709.838049953953,31704.029641215748,31698.229935378262,
	31692.438908403306,31686.656536329196,31680.882795292553,31675.117661526,31669.361111362072,
	31663.61312122374,31657.87366762234,31652.1427271736,31646.420276577835,31640.70629264115,
	31635.00075223746,31629.3036323497,31623.614910044984,31617.93456249316,31612.2625669343,
	31606.59890071257,31600.94354125506,31595.296466082797,31589.657652788235,31584.027079084408,
	31578.40472273711,31572.790561620288,31567.18457369005,31561.58673697649,31555.99702961222,
	31550.415429801953,31544.84191584366,31539.276466113333,31533.719059081664,31528.16967328433,
	31522.62828735678,31517.09488001066,31511.569430033363,31506.051916306722,31500.5423177802,
	31495.040613500598,31489.54678258593,31484.060804224668,31478.58265769881,31473.11232236269,
	31467.649777650317,31462.195003086603,31456.74797825418,31451.308682823295,31445.877096546905,
	31440.453199244184,31435.036970810736,31429.628391235976,31424.227440560888,31418.834098929077,
	31413.448346519206,31408.07016363387,31402.699530612095,31397.33642786814,31391.98083592601,
	31386.63273534666,31381.29210676577,31375.958930919136,31370.633188586875,31365.314860626615,
	31360.00392798333,31354.700371657294,31349.404172718623,31344.115312316448,31338.83377166397,
	31333.559532051586,31328.292574829393,31323.032881424544,31317.780433318603,31312.53521206831,
	31307.297199334054,31302.06637679651,31296.842726203882,31291.62622940135,31286.416868295462,
	31281.214624831453,31276.0194810554,31270.831419045222,31265.650420980757,31260.476469074823,
	31255.309545629298,31250.149632982913,31244.996713577486,31239.850769887682,31234.711784468273,
	31229.579739918994,31224.45461892054,31219.336404206508,31214.225078578034,31209.12062489832,
	31204.023026094255,31198.93226512833,31193.848325071445,31188.771189029987,31183.700840160287,
	31178.637261689775,31173.58043691884,31168.530349186567,31163.486981896935,31158.45031852717,
	31153.42034259732,31148.397037700674,31143.380387453763,31138.370375597126,31133.366985856745,
	31128.370202068854,31123.38000809629,31118.396387867422,31113.41932539809,31108.448804704214,
	31103.48480989279,31098.527325128525,31093.576334617435,31088.63182262464,31083.69377348874,
	31078.762171578008,31073.837001321655,31068.918247220623,31064.005893806458,31059.099925679893,
	31054.20032749066,31049.307083938354,31044.42017978737,31039.539599847085,31034.665328975243,
	31029.797352095164,31024.935654168552,31020.080220208416,31015.231035294604,31010.388084562845,
	31005.55135316357,31000.720826340854,30995.896489364473,30991.07832755867,30986.266326313602,
	30981.460471041653,30976.66074723754,30971.86714040966,30967.079636161845,30962.29822008902,
	30957.522877904004,30952.75359530738,30947.990358073203,30943.233152028188,30938.481963053295,
	30933.736777046604,30928.99757999679,30924.26435789885,30919.537096825712,30914.815782873702,
	30910.100402218213,30905.390941048692,30900.687385619294,30895.989722212435,30891.297937192354,
	30886.61201692114,30881.931947844667,30877.257716453743,30872.589309255476,30867.926712820044,
	30863.269913774093,30858.618898757704,30853.973654495454,30849.33416771552,30844.700425233503,
	30840.072413855636,30835.45012048923,30830.83353204805,30826.222635487196,30821.61741783923,
	30817.017866140784,30812.4239674981,30807.835709041534,30803.25307795336,30798.67606147052,
	30794.104646839427,30789.538821375005,30784.97857242864,30780.423887397286,30775.874753698306,
	30771.331158817993,30766.793090267965,30762.260535598565,30757.733482413758,30753.21191835028,
	30748.69583107328,30744.185208305065,30739.68003782142,30735.180307398918,30730.686004865882,
	30726.197118127166,30721.71363507695,30717.235543687264,30712.76283193096,30708.295487845015,
	30703.833499520828,30699.37685504343,30694.925542573943,30690.479550299417,30686.038866443345,
	30681.603479259757,30677.17337704669,30672.748548157342,30668.328980957398,30663.914663853775,
	30659.505585312927,30655.101733804462,30650.70309784462,30646.30966601717,30641.921426899484,
	30637.53836912941,30633.1604813739,30628.787752336597,30624.420170765447,30620.057725425395,
	30615.70040512205,30611.348198721138,30607.00109510039,30602.65908316376,30598.322151875655,
	30593.990290218124,30589.663487210688,30585.34173192069,30581.02501342313,30576.71332085645,
	30572.406643372397,30568.104970160937,30563.808290452787,30559.51659350238,30555.229868621595,
	30550.948105116182,30546.671292371757,30542.39941974633,30538.132476710274,30533.870452678617,
	30529.6133371768,30525.36111972238,30521.113789860436,30516.871337195957,30512.633751336278,
	30508.401021960046,30504.173138721293,30499.95009136241,30495.731869632524,30491.51846328646,
	30487.309862172267,30483.106056107463,30478.907034985798,30474.712788699017,30470.523307193605,
	30466.338580440843,30462.158598430044,30457.983351185685,30453.81282877861,30449.64702131076,
	30445.48591887523,30441.32951162974,30437.17778977323,30433.030743490166,30428.888363048693,
	30424.750638687077,30420.617560724593,30416.48911948998,30412.365305334315,30408.246108648673,
	30404.131519839702,30400.021529363657,30395.916127687302,30391.815305314347,30387.71905277405,
	30383.627360641185,30379.540219481427,30375.45761991008,30371.379552589224,30367.30600818318,
	30363.236977395976
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	4635992.402307132,4623630.920878677,4611263.194911377,4598889.424113326,4586509.808691773,
	4574124.549343514,4561733.847243557,4549337.904028853,4536936.921789325,4524531.103047258,
	4512120.650747813,4499705.768248997,4487286.659301141,4474863.5280377455,4462436.578957576,
	4450006.016914798,4437572.047108263,4425134.87505605,4412694.706593159,4400251.74784737,
	4387806.205240082,4375358.285451651,4362908.195425325,4350456.142341972,4338002.333610442,
	4325546.976855864,4313090.279896896,4300632.450736422,4288173.697551605,4275714.228672401,
	4263254.252566148,4250793.977832139,4238333.613175435,4225873.367404676,4213413.449407863,
	4200954.068139686,4188495.4326098384,4176037.7518678354,4163581.2349883844,4151126.0910513527,
	4138672.5291358773,4126220.7582992455,4113770.9875669633,4101323.4259139514,4088878.28225301,
	4076435.7654163702,4063996.0841473253,4051559.4470809097,4039126.062728547,4026696.139465361,
	4014269.8855203637,4001847.5089520505,3989429.217640493,3977015.2192735323,3964605.721328395,
	3952200.9310585214,3939801.055481675,3927406.3013617885,3915016.875197993,3902632.9832089436,
	3890254.831317366,3877882.625136218,3865516.5699601276,3853156.870738737,3840803.7320773182,
	3828457.35821264,3816117.9530005828,3803785.719906109,3791460.861987548,3779143.5818793187,
	3766834.081783662,3754532.563452852,3742239.228176783,3729954.276772025,3717677.9095630017,
	3705410.3263734574,3693151.7265102174,3680902.308751062,3668662.2713314365,3656431.8119305787,
	3644211.127660166,3632000.415048549,3619799.8700298266,3607609.6879320624,3595430.0634620884,
	3583261.1906926488,3571103.263053712,3558956.4733147305,3546821.0135765565,3534697.0752560347,
	3522584.849077539,3510484.5250562974,3498396.2924888986,3486320.3399429587,3474256.855239744,
	3462206.0254513854,3450168.0368795986,3438143.0750507875,3426131.324702395,3414132.9697708366,
	3402148.193382019,3390177.1778394277,3378220.1046134145,3366277.1543298424,3354348.5067600575,
	3342434.3408099227,3330534.83450844,3318650.164999661,3306780.508530422,3294926.0404414507,
	3283086.93515462,3271263.3661681362,3259455.5060419017,3247663.526390984,3235887.597874296,
	3224127.8901850884,3212384.5720439153,3200657.8111869874,3188947.774358636,3177254.6273026923,
	3165578.534750473,3153919.660418369,3142278.16699331,3130654.216127618,3119047.9684292693,
	3107459.583455944,3095889.2197061954,3084337.034607528,3072803.1845162897,3061287.8247050424,
	3049791.1093560425,3038313.191553935,3026854.2232802394,3015414.3554034573,3003993.7376764524,
	2992592.5187239773,2981210.8460411895,2969848.865986815,2958506.723772376,2947184.563460575,
	2935882.527959521,2924600.759011423,2913339.397194111,2902098.5819108062,2890878.451385482,
	2879679.14265837,2868500.791580812,2857343.532809359,2846207.499802245,2835092.8248126563,
	2823999.6388860433,2812928.071856016,2801878.2523369268,2790850.307723855,2779844.3641853128,
	2768860.5466614063,2757898.978859547,2746959.783250237,2736043.0810635984,2725148.992287965,
	2714277.635664716,2703429.128685248,2692603.5875897286,2681801.127362653,2671021.8617306543,
	2660265.903162376,2649533.3628619565,2638824.350769503,2628138.9755593943,2617477.3446363737,
	2606839.5641360497,2596225.738920847,2585635.9725812986,2575070.367431998,2564529.0245120656,
	2554012.0435833666,2543519.5231302627,2533051.560357098,2522608.2511897366,2512189.690273126,
	2501795.970972239,2491427.1853697123,2481083.4242693908,2470764.777191416,2460471.332377501,
	2450203.176785653,2439960.3960951213,2429743.0747043225,2419551.2957329163,2409385.1410200456,
	2399244.6911286144,2389130.025342975,2379041.2216717317,2368978.3568495153,2358941.5063355733,
	2348930.7443186576,2338946.1437152103,2328987.7761740573,2319055.712076263,2309150.020536005,
	2299270.769406536,2289418.0252776584,2279591.8534803027,2269792.318089261,2260019.481924535,
	2250273.4065533904,2240554.1522952244,2230861.7782208305,2221196.3421591097,2211557.9006965607,
	2201946.5091830897,2192362.221733639,2182805.0912305783,2173275.1693292926,2163772.5064597526,
	2154297.151831889,2144849.1534364154,2135428.558050875,2126035.4112431435,2116669.7573749614,
	2107331.6396043645,2098021.099892902,2088738.1790071658,2079482.9165245967,2070255.3508362637,
	2061055.519153146,2051883.457509024,2042739.2007658996,2033622.7826179157,2024534.235597463,
	2015473.591078307,2006440.8792816647,1997436.1292800074,1988459.36900369,1979510.6252445802,
	1970589.9236618702,1961697.2887869773,1952832.7440295587,1943996.3116815295,1935188.0129243685,
	1926407.8678326993,1917655.8953814239,1908932.113450384,1900236.5388293657,1891569.187226461,
	1882930.0732706403,1874319.2105198228,1865736.6114661663,1857182.2875416337,1848656.249124062,
	1840158.5055439482,1831689.065089632,1823247.9350145066,1814835.1215417176,1806450.6298724324,
	1798094.4641897762,1789766.627667084,1781467.1224737924,1773195.9497814863,1764953.10977017,
	1756738.6016357949,1748552.4235958725,1740394.5728964247,1732265.0458187487,1724163.8376853308,
	1716090.942867571,1708046.3547921781,1700030.0659468912,1692042.0678890487,1684082.351251047,
	1676150.9057475107,1668247.7201826198,1660372.7824560606,1652526.0795711097,1644707.5976403991,
	1636917.3218937614,1629155.2366851675,1621421.3254985628,1613715.5709566283,1606037.9548265375,
	1598388.4580275286,1590767.0606381295,1583173.7419023304,1575608.480237882,1568071.2532428543,
	1560562.0377027113,1553080.8095970955,1545627.5441079007,1538202.2156258477,1530804.797757621,
	1523435.2633327106,1516093.5844117296,1508779.7322922621,1501493.6775171382,1494235.3898803184,
	1487004.8384359628,1479801.9915036357,1472626.8166770437,1465479.2808300154,1458359.3501247985,
	1451266.9900181303,1444202.1652695867,1437164.8399479731,1430154.97743836,1423172.540449973,
	1416217.4910229938,1409289.7905354635,1402389.3997108983,1395516.278625059,1388670.3867132151,
	1381851.6827774232,1375060.1249933543,1368295.6709176374,1361558.2774946806,1354847.9010643286,
	1348164.4973678493,1341508.0215562405,1334878.428196231,1328275.671277976,1321699.7042218475,
	1315150.4798851623,1308627.9505694227,1302132.0680271452,1295662.783469186,1289220.0475709476,
	1282803.8104797346,1276414.0218214667,1270050.6307077508,1263713.5857423362,1257402.8350283015,
	1251118.3261744813,1244860.0063025306,1238627.8220535628,1232421.719594538,1226241.644625323,
	1220087.5423857858,1213959.357660962,1207857.034789518,1201780.517668666,1195729.7497620308,
	1189704.6741052452,1183705.2333130762,1177731.369585468,1171783.0247141805,1165860.1400891256,
	1159962.656704851,1154090.5151669888,1148243.655698021,1142422.0181444334,1136625.5419820277,
	1130854.1663231433,1125107.8299219452,1119386.4711810371,1113690.028157888,1108018.438570161,
	1102371.6398023472,1096749.5689117904,1091152.162634283,1085579.3573905646,1080031.0892917798,
	1074507.2941456563,1069007.907462337,1063532.864460122,1058082.1000711499,1052655.5489476263,
	1047253.1454668652,1041874.8237375234,1036520.517605031,1031190.1606571774,1025883.6862296596,
	1020601.0274119568,1015342.1170522268,1010106.8877633929,1004895.2719281091,999707.2017044679,
	994542.6090311205,989401.4256326538,984283.5830251388,979189.0125209606,974117.6452341959,
	969069.4120858704,964044.2438089525,959042.0709534583,954062.8238916865,949106.4328228334,
	944172.8277784087,939261.9386269897,934373.6950789759,929508.0266917128,924664.8628740804,
	919844.1328912763,915045.7658699573,910269.6908024095,905515.8365514636,900784.131855232,
	896074.5053313709,891386.8854820458,886721.2006979823,882077.379263446,877455.3493602225,
	872855.0390722265,868276.3763898773,863719.2892143783,859183.7053619226,854669.5525680459,
	850176.7584917535,845705.2507197319,841254.9567704385,836825.8040981317,832417.7200971332,
	828030.6321055626,823664.4674094557,819319.153246743,814994.6168110332,810690.785255408,
	806407.5856965599,802144.945218169,797902.79087506,793681.0496963224,789479.6486897501,
	785298.5148447885,781137.5751365189,776996.7565290545,772875.9859791105,768775.1904394691,
	764694.296862466,760633.2322033452,756591.9234236717,752570.2974945456,748568.2814001641,
	744585.8021407585,740622.7867361119,736679.1622285255,732754.8556861222,728849.7942058956,
	724963.9049167457,721097.1149826649,717249.3516056617,713420.5420287816,709610.6135388275,
	705819.4934696812,702047.1092048693,698293.3881804552,694558.2578879121,690841.6458767985,
	687143.4797576044,683463.687204354,679802.1959572755,676158.9338256537,672533.8286900283,
	668926.8085051383,665337.801302239,661766.7351917125,658213.5383654613,654678.1390993939,
	651160.4657558766,647660.4467860063,644178.0107319418,640713.0862293419,637265.6020096118,
	633835.4869020059,630422.6698359955,627027.0798434329,623648.646060661,620287.2977306603,
	616942.9642051478,613615.574946604,610305.059530411,607011.3476467145,603734.3691024681,
	600474.0538234526,597230.3318560586,594003.1333692329,590792.3886564121,587598.0281371719,
	584419.9823592361,581258.182000094,578112.5578688497,574983.040907885,571869.5621945377,
	568772.052942807,565690.4445050218,562624.6683733546,559574.6561814429,556540.3397060203,
	553521.6508682845,550518.5217356364,547530.8845229095,544558.6715939882,541601.8154632265,
	538660.2487966944,535733.9044137923,532822.7152884508,529926.6145504096,527045.5354867431,
	524179.41154286556,521328.1763240078,518491.76359635306,515670.1072882035,512863.14149125095,
	510070.80046173575,507293.01862146804,504529.7305591076,501780.87103113777,499046.3749630143,
	496326.1774501253,493620.21375888406,490928.4193277757,488250.72976818687,485587.08086554863,
	482937.40858016664,480301.64904814976,477679.738582345,475071.6136732161,472477.2109896393,
	469896.4673798309,467329.319872123,464775.7056757077,462235.5621815233,459708.826962962,
	457195.4377765324,454695.3325627475,452208.44944668456,449734.72673873627,447274.1029352332,
	444826.5167191314,442391.9069606548,439970.2127178153,437561.37323713105,435165.3279540852,
	432782.01649377536,430411.3786713939,428053.35449278983,425707.88415495475,423374.9080465191,
	421054.3667482536,418746.2010334561,416450.3518684827,414166.7604131133,411895.36802097043,
	409636.1162399624,407388.9468125747,405153.80167633016,402930.62296407734,400719.3530043062,
	398519.93432158727,396332.30963670375,394156.421867105,391992.21412705525,389839.62972799636,
	387698.6121787292,385569.10518568015,383451.0526531336,381344.39868340985,379249.08757708804,
	377165.06383314746,375092.27214922506,373030.65742165357,370980.1647457316,368940.7394157467,
	366912.3269251459,364894.87296667905,362888.32343240955,360892.6244139036,358907.7222021902,
	356933.5632879286,354970.09436138376,353017.2623124878,351075.0142308963,349143.2974060018,
	347222.0593268712,345311.2476823431,343410.81036092906,341520.69545086764,339640.8512400272,
	337771.22621589026,335911.76906549576,334062.42867538304,332223.1541315089,330393.89471916866,
	328574.59992292646,326765.21942645614,324965.70311252004,323176.0010627628,321396.0635576567,
	319625.8410763206,317865.2842963944,316114.3440939097,314372.97154306923,312641.1179161475,
	310918.73468329076,309205.7735123042,307502.1862685138,305807.9250145249,304122.9420100515,
	302447.1897116809,300780.62077268376,299123.18804272776,297474.8445677118,295835.54358951224,
	294205.23854570655,292583.8830693409,290971.43098868907,289367.8363269479,287773.0533020243,
	286187.0363261939,284609.74000586185,283041.1191412818,281481.1287262365,279929.72394774045,
	278386.8601857605,276852.4930128978,275326.5781940609,273809.0716861776,272299.9296378294,
	270799.1083889665,269306.5644705458,267822.25460423087,266346.13570200966,264878.1648658768,
	263418.29938748287,261966.4967477753,260522.71461664833,259086.91085259046,257659.04350230232,
	256239.0708003579,254826.95116881843,253422.64321686447,252026.10574041112,250637.2977217651,
	249256.17832920066,247882.70691661406,246516.84302310817,245158.54637263124,243807.77687358527,
	242464.49461840838,241128.6598832198,239800.23312739813,238479.17499319353,237165.44630534668,
	235859.0080706644,234559.82147763303,233267.8478960223,231983.04887647432,230705.38615011275,
	229434.82162813348,228171.31740140112,226914.83574005327,225665.33909308762,224422.79008797748,
	223187.15153024538,221958.38640308168,220736.45786692965,219521.32925909763,218312.96409334315,
	217111.32605950176,215916.3790230625,214728.08702477728,213546.41428029738,212371.32517972836,
	211202.78428730034,210040.75634092532,208885.20625185533,207736.09910428277,206593.40015494838,
	205457.07483279408,204327.0887385679,203203.40764446626,202085.9974937578,200974.82440042766,
	199869.8546488304,198771.05469332275,197678.3911579187,196591.8308359542,195511.34068974078,
	194436.8878502347,193368.439616717,192305.9634564662,191249.42700444147,190198.7980629943,
	189154.04460153915,188115.1347562807,187082.0368299234,186054.7192913909,185033.15077555782,
	184017.3000829893,183007.13617968227,182002.62819683732,181003.74543060668,180010.45734188106,
	179022.73355608113,178040.54386293856,177063.85821632567,176092.64673405685,175126.87969772462,
	174166.52755255942,173211.56090726546,172261.95053390748,171317.66736778704,170378.68250733844,
	169444.96721405874,168516.49291241137,167593.23118979397,166675.15379648714,165762.23264563095,
	164854.4398132286,163951.7475381584,163054.12822219435,162161.55443007412,161273.99888955726,
	160391.4344915238,159513.8342900857,158641.1715027133,157773.41951041066,156910.5518578824,
	156052.5422537393,155199.36457073176,154350.99284600082,153507.40128136557,152668.5642436244,
	151834.45626489085,151005.052042968,150180.32644173127,149360.25449156162,148544.8113898014,
	147733.97250123238,146927.71335861736,146126.00966323365,145328.83728548404,144536.17226551447,
	143747.99081387522,142964.2693122375,142184.9843141203,141410.1125456805,140639.63090653458,
	139873.51647062422,139111.74648712977,138354.29838142125,137601.14975605733,136852.27839183446,
	136107.66224888337,135367.2794678074,134631.10837088473,133899.12746331142,133171.31543449897,
	132447.6511594296,131728.1137000653,131012.6823068064,130301.33642001831,129594.05567161327,
	128890.81988668542,128191.6090852116,127496.40348382194,126805.18349760561,126117.92974202914,
	125434.62303485713,124755.24439820112,124079.77506058547,123408.19645910701,122740.49024166202,
	122076.63826922645,121416.62261822361,120760.42558294692,120108.02967806387,119459.41764118067,
	118814.57243548562,118173.47725245457,117536.1155146361,116902.47087849838,116272.52723734196,
	115646.26872429565,115023.67971536567,114404.74483255263,113789.44894704074,113177.7771824373,
	112569.71491808709,111965.24779243128,111364.36170642375,110767.04282701144,110173.27759064261,
	109583.05270683914,108996.35516178892,108413.17222198889,107833.49143790973,107257.30064768523,
	106684.58798079626,106115.34186180889,105549.55101407341,104987.20446341868,104428.29154184942,
	103872.80189119095,103320.72546670726,102772.05254066549,102226.77370582784,101684.879878871,
	101146.36230371486,100611.2125547269,100079.42253981224,99550.98450335754,99025.89102900057,
	98504.1350422231,97985.70981273793,97470.60895663677,96958.82643829702,96450.35657200107,
	95945.19402325549,95443.33380977427,94944.7713021073,94449.50222386679,93957.52265154319,
	93468.82901386768,92983.41809067213,92501.28701124863,92022.43325214418,91546.85463436945,
	91074.54931997482,90605.51580797102,90139.75292955454,89677.25984259178,89218.03602533726,
	88762.08126934177,88309.3956715302,87859.97962539294,87413.83381127827,86970.95918574081,
	86531.35696992892,86095.02863697958,85661.97589838301,85232.20068932658,84805.70515296643,
	84382.49162364673,83962.56260901924,83545.92077109743,83132.56890621792,82722.50992392562,
	82315.74682479678,81912.28267721194,81512.12059310397,81115.26370271982,80721.71512842021,
	80331.47795758412,79944.55521464441,79560.94983234054,79180.66462224319,78803.70224461946,
	78430.06517774989,78059.75568674829,77692.77579202033,77329.12723743168,76968.81145832583,
	76611.82954947639,76258.18223312491,75907.86982720892,75560.89221391056,75217.24880866999,
	74876.9385297865,74539.9597687266,74206.31036132219,73875.98755992665,73548.98800671157,
	73225.3077081998,72904.94201118329,72587.88558011295,72274.1323761062,71963.6756376467,
	71656.50786309048,71352.62079505736,71052.00540678634,70754.65189052926,70460.54964801158,
	70169.68728305107,69882.05259631231,69597.6325822587,69316.413428288,69038.38051605463,
	68763.51842496215,68491.81093778995,68223.24104842803,67957.79097165029,67695.44215488441,
	67436.17529189194,67179.9703382876,66926.8065288011,66676.66239619702,66429.51579172876,
	66185.34390705347,65944.12329745687,65705.82990628845,65470.43909050189,65237.92564715059,
	65008.26384073748,64781.427431291006,64557.38970303968,64336.12349358236,64117.60122341052,
	63901.79492570329,63688.67627623659,63478.21662336466,63270.38701790075,63065.15824285792,
	62862.500842928785,62662.38515362049,62464.781329979145,62269.65937481284,62076.98916635817,
	61886.74048532743,61698.88304126577,61513.38649819617,61330.22049948313,61149.354691896515,
	60970.75874882137,60794.40239262217,60620.255416103384,60448.28770307018,60278.469247977446,
	60110.770174650825,59945.160754089,59781.61142133268,59620.09279141718,59460.575674419335,
	59303.031089587064,59147.430278588115,58993.74471789038,58841.946130276825,58692.00649552658,
	58543.89806028883,58397.593347149734,58253.0651629461,58110.28660632738,57969.23107459957,
	57829.872269877866,57692.18420457736,57556.141206262415,57421.71792188533,57288.88932143384,
	57157.63070103876,57027.91768553009,56899.72623049917,56773.03262388841,56647.81348711002,
	56524.04577575279,56401.70677988329,56280.774123947405,56161.225766350944,56043.03999867284,
	55926.195444575824,55810.67105843465,55696.44612368065,55583.50025089095,55471.81337566426,
	55361.36575625307,55252.13797101047,55144.11091566527,55037.26580040176,54931.5841468135,
	54827.047784705275,54723.638848767885,54621.33977515259,54520.133297934764,54420.002445486265,
	54320.93053678213,54222.90117760568,54125.89825681501,54029.90594231502,53934.90867724846,
	53840.891176006975,53747.83842026032,53655.735654958284,53564.568384310434,53474.32236778516,
	53384.98361607509,53296.538387095265,53208.97318196705,53122.274741035595,53036.43003988877,
	52951.4262853999,52867.250911814095,52783.891576825496,52701.336157724094,52619.572747546124,
	52538.58965128355,52458.375382108774,52378.91865765907,52300.2083963514,52222.233713747795,
	52144.98391894601,52068.44851105362,51992.61717566847,51917.479781432565,51843.026376619484,
	51769.24718579366,51696.13260648389,51623.67320594361,51551.85971793481,51480.68303957672,
	51410.13422824657,51340.204498515275,51270.88521915577,51202.16791018616,51134.044239971525,
	51066.506022366506,50999.545213926845,50933.15391115422,50867.324347784794,50802.04889215565,
	50737.320044594075,50673.13043485637,50609.472819633076,50546.34008007276,50483.72521939469,
	50421.621360492085,50360.02174363184,50298.91972416849,50238.30877031643,50178.182460958415,
	50118.53448349724,50059.35863176099,50000.64880393353,49942.39900053328,49884.60332244416,
	49827.255968961486,49770.35123589461,49713.883513708955,49657.84728570069,49602.23712619345,
	49547.04769880695,49492.27375472764,49437.91013103193,49383.95174903604,49330.393612690066,
	49277.23080698562,49224.458496422165,49172.071923482355,49120.066407146645,49068.437341445446,
	49017.18019403407,48966.29050479119,48915.76388446469,48865.59601332144,48815.78263984506,
	48766.31957945479,48717.20271324017,48668.42798674138,48619.991408740905,48571.889050076934,
	48524.117042494145,48476.6715775145,48429.548905323,48382.74533368022,48336.25722687558,
	48290.08100465992,48244.21314124539,48198.65016430532,48153.388653989736,48108.42524196657,
	48063.75661048908,48019.3794914733,47975.290665602035,47931.486961431576,47887.965254542694,
	47844.72246668148,47801.755564943065,47759.061560945294,47716.6375100493,47674.48051056206,
	47632.58770298695,47590.95626927392,47549.58343207538,47508.46645404415,47467.602637117714,
	47426.989321806344,47386.62388662304,47346.503747262046,47306.62635605522,47266.989201314624,
	47227.58980670043,47188.42573062536,47149.49456563041,47110.793937827635,47072.321506302214,
	47034.07496255952,46996.05202997235,46958.25046323692,46920.66804783617,46883.30259953082,
	46846.151963843375,46809.214015551275,46772.48665820776,46735.967823648614,46699.655471534315,
	46663.54758887077,46627.642189570426,46591.9373140001,46556.431028539315,46521.12142516805,
	46486.006621029985,46451.084758028854,46416.354002423504,46381.81254443468,46347.45859785222,
	46313.29039964669,46279.30620961765,46245.504309993215,46211.88300510319,46178.440621008915,
	46145.175505155734,46112.08602603414,46079.17057284748,46046.42755519128,46013.85540270973,
	45981.45256480769,45949.21751032182,45917.14872722532,45885.24472231675,45853.50402095112,
	45821.92516672784,45790.506721218175,45759.24726368881,45728.14539083104,45697.1997164881,
	45666.40887139418,45635.77150291756,45605.28627481657,45574.95186697075,45544.76697515441,
	45514.730310784944,45484.84060070117,45455.09658691922,45425.49702641234,45396.04069088369,
	45366.72636654918,45337.55285392108,45308.51896759922,45279.62353605765,45250.865401449,
	45222.243419397906,45193.7564587959,45165.40340163074,45137.183142770475,45109.09458979184,
	45081.13666279325,45053.30829421093,45025.608428641215,44998.03602267118,44970.59004470205,
	44943.26947478602,44916.07330445456,44889.00053655181,44862.05018508837,44835.22127507352,
	44808.51284236067,44781.92393349283,44755.453605567745,44729.10092606818,44702.86497273348,
	44676.744833413904,44650.73960592055,44624.848397905545,44599.070326713445,44573.404519249816,
	44547.8501118553,44522.40625016584,44497.07208900247,44471.846792231205,44446.7295326493,
	44421.71949186179,44396.81586015811,44372.01783640687,44347.32462792769,44322.73545038638,
	44298.24952768336,44273.866091840115,44249.584382891364,44225.40364878187,44201.323145263355,
	44177.34213578951,44153.459891413506,44129.67569068711,44105.98881957354,44082.39857133022,
	44058.9042464372,44035.50515249073,44012.200604106605,43988.98992284835,43965.87243711575,
	43942.84748206857,43919.914399546,43897.07253796852,43874.32125226084,43851.65990376181,
	43829.08786016595,43806.60449541714,43784.20918963581,43761.90132904785,43739.68030591607,
	43717.54551844444,43695.496370711466,43673.532272604374,43651.65263974298,43629.856893404074,
	43608.14446046118,43586.51477330405,43564.9672697803,43543.50139312515,43522.11659189347,
	43500.81231989964,43479.588036150155,43458.443204784846,43437.37729499733,43416.38978100773,
	43395.480141973625,43374.64786193874,43353.892429777836,43333.21333913567,43312.61008837163,
	43292.082180500234,43271.62912314688,43251.250428477186,43230.94561315667,43210.71419828882,
	43190.555709367145,43170.469676233726,43150.45563300354,43130.51311803396,43110.64167388029,
	43090.84084722649,43071.110188853825,43051.4492535771,43031.85760023483,43012.33479159379,
	42992.88039433288,42973.49397899868,42954.17511995716,42934.923395343074,42915.73838702758,
	42896.61968056576,42877.56686516874,42858.57953364843,42839.65728236382,42820.79971126901,
	42802.00642373434,42783.277026598014,42764.611130122146,42746.00834792122,42727.4682969533,
	42708.990597482276,42690.57487301164,42672.220750299246,42653.9278592633,42635.69583299942,
	42617.52430771278,42599.41292270005,42581.361320302625,42563.36914589694,42545.43604781996,
	42527.56167739696,42509.74568885278,42491.987739309545,42474.28748874919,42456.644599993226,
	42439.05873864843,42421.52957309834,42404.05677446818,42386.64001658832,42369.278975983165,
	42351.97333182224,42334.72276589853,42317.52696261551,42300.38560893595,42283.298394377365,
	42266.26501096951,42249.28515323332,42232.35851816056,42215.484805175154,42198.66371612497,
	42181.894955249576,42165.17822913818,42148.51324674121,42131.89971931254,42115.33736040177,
	42098.825885837294,42082.365013684284,42065.95446423257,42049.593959982274,42033.28322560788,
	42017.021987936605,42000.80997594012,41984.64692069544,41968.532555375416,41952.46661522703,
	41936.44883755235,41920.47896167507,41904.55672892846,41888.68188264815,41872.85416813134,
	41857.07333262852,41841.33912533313,41825.65129732556,41810.009601606835,41794.413793042266,
	41778.86362835897,41763.35886611925,41747.899266700864,41732.48459230379,41717.11460689793,
	41701.78907623187,41686.5077677966,41671.27045082764,41656.07689627674,41640.926876791105,
	41625.82016670437,41610.75654203295,41595.7357804371,41580.7576612098,41565.8219652708,
	41550.92847514994,41536.07697497041,41521.26725043139,41506.49908877523,41491.772278824916,
	41477.08661090794,41462.44187688593,41447.83787011183,41433.27438545118,41418.75121921688,
	41404.26816920789,41389.82503466083,41375.42161624656,41361.05771607088,41346.73313763364,
	41332.44768583509,41318.20116696708,41303.993388684794,41289.82416001143,41275.69329129575,
	41261.600594247044,41247.545881873804,41233.52896850542,41219.54966976653,41205.60780257666,
	41191.70318511033,41177.83563682568,41164.00497841756,41150.21103182909,41136.45362023443,
	41122.7325680157,41109.04770078088,41095.39884531848,41081.78582960796,41068.20848281278,
	41054.66663524591,41041.160118397616,41027.68876487779,41014.25240845393,41000.8508840043,
	40987.4840275225,40974.151676119276,40960.853667991796,40947.5898424322,40934.3600397854,
	40921.16410150526,40908.00187006702,40894.873189012025,40881.777902918424,40868.71585739076,
	40855.686899070955,40842.69087560376,40829.72763562916,40816.797028808825,40803.89890577654,
	40791.03311813631,40778.1995184864,40765.39796036927,40752.628298289856,40739.89038770066,
	40727.1840849927,40714.509247486516,40701.86573343328,40689.25340198359,40676.67211320389,
	40664.121728076585,40651.60210844151,40639.11311706797,40626.65461756654,40614.2264744299,
	40601.82855302915,40589.46071956647,40577.12284111709,40564.81478558504,40552.53642170085,
	40540.287619051785,40528.06824802539,40515.87817983321,40503.71728648718,40491.58544080375,
	40479.482516405864,40467.40838769571,40455.36292985465,40443.34601884734,40431.35753140306,
	40419.397345023826,40407.465337962036,40395.56138922086,40383.68537855794,40371.83718646194,
	40360.0166941615,40348.22378359916,40336.45833746645,40324.720239144764,40313.00937274004,
	40301.325623063334,40289.66887561822,40278.039016607385,40266.43593292378,40254.8595121467,
	40243.30964251822,40231.786212974985,40220.2891131023,40208.81823314946,40197.37346403952,
	40185.95469733187,40174.56182523722,40163.194740608364,40151.853336936736,40140.53750833877,
	40129.24714957054,40117.98215600329,40106.74242362098,40095.52784903307,40084.338329441,
	40073.1737626641,40062.0340471143,40050.91908180235,40039.828766318176,40028.76300085305,
	40017.72168616425,40006.704723600466,39995.712015062796,39984.74346303776,39973.79897057211,
	39962.87844127193,39951.98177929114,39941.10888934673,39930.25967669002,39919.43404712502,
	39908.63190699641,39897.85316316201,39887.09772305137,39876.36549458424,39865.656386212904,
	39854.97030692122,39844.30716619139,39833.66687403852,39823.04934095738,39812.4544779783,
	39801.88219661168,39791.33240886442,39780.80502724412,39770.299964752594,39759.817134866214,
	39749.35645154596,39738.91782924383,39728.50118286767,39718.1064278154,39707.73347994985,
	39697.382255590346,39687.05267152766,39676.744645007544,39666.4580937289,39656.192935850166,
	39645.949089968206,39635.7264751449,39625.525010854995,39615.34461704488,39605.18521408006,
	39595.04672274348,39584.92906429219,39574.83216036938,39564.75593306131,39554.70030487202,
	39544.66519871938,39534.65053794793,39524.65624630498,39514.68224794866,39504.72846745345,
	39494.794829775085,39484.88126029427,39474.98768477779,39465.11402939617,39455.2602207002,
	39445.42618563992,39435.61185154775,39425.81714614952,39416.04199754882,39406.28633421518,
	39396.55008501805,39386.83317919677,39377.13554633258,39367.4571164203,39357.79781978874,
	39348.157587141104,39338.53634955512,39328.93403844535,39319.35058559848,39309.785923153606,
	39300.239983590545,39290.71269973315,39281.204004802814,39271.713832324494,39262.242116150665,
	39252.78879050101,39243.353789933986,39233.937049333836,39224.538503913005,39215.158089238255,
	39205.79574117408,39196.45139593702,39187.12499006162,39177.81646040039,39168.52574413067,
	39159.25277875226,39149.997502058315,39140.75985219264,39131.539767580274,39122.33718697561,
	39113.15204943442,39103.984294309186,39094.83386127331,39085.70069029209,39076.584721625666,
	39067.485895852275,39058.40415382489,39049.33943670453,39040.29168594221,39031.26084326051,
	39022.24685070568,39013.249650585916,39004.269185497156,38995.30539832419,38986.35823223687,
	38977.427630666374,38968.51353734765,38959.61589626486,38950.734651692095,38941.86974818016,
	38933.02113053509,38924.18874383807,38915.3725334497,38906.572444972095,38897.78842430116,
	38889.02041756762,38880.26837118288,38871.532231798636,38862.811946326874,38854.10746196348,
	38845.418726125296,38836.74568649141,38828.088290996464,38819.4464878199,38810.82022539524,
	38802.20945240182,38793.614117743906,38785.03417059889,38776.469560365564,38767.92023668518,
	38759.38614945582,38750.867248782335,38742.363485033704,38733.87480879835,38725.40117089875,
	38716.94252238516,38708.49881454924,38700.06999890936,38691.65602720446,38683.25685139365,
	38674.87242366973,38666.50269646423,38658.14762239626,38649.80715433592,38641.48124534539,
	38633.16984873258,38624.87291799636,38616.59040688072,38608.32226929625,38600.068459412905,
	38591.82893160408,38583.60364041773,38575.392540659734,38567.19558730316,38559.01273555296,
	38550.84394080798,38542.68915866129,38534.54834494157,38526.421455638934,38518.308446977906,
	38510.20927535845,38502.12389737127,38494.052269843225,38485.99434976357,38477.950094326916,
	38469.91946090963,38461.902407086636,38453.89889064446,38445.90886952579,38437.93230189029,
	38429.96914606266,38422.0193605629,38414.08290409727,38406.15973557205,38398.24981403917,
	38390.35309876914,38382.4695491886,38374.59912493565,38366.74178578506,38358.89749172212,
	38351.06620289392,38343.247879631024,38335.44248243622,38327.64997198992,38319.87030913352,
	38312.10345489187,38304.34937045732,38296.608017192884,38288.8793566306,38281.16335047004,
	38273.45996057947,38265.76914897808,38258.09087789462,38250.42510966005,38242.771806821365,
	38235.13093205799,38227.502448217216,38219.88631830888,38212.28250551177,38204.69097314112,
	38197.11168470341,38189.544603826136,38181.98969431832,38174.44692012916,38166.916245380366,
	38159.39763431141,38151.89105135946,38144.39646108233,38136.913828205776,38129.44311759432,
	38121.98429426509,38114.53732338314,38107.10217027318,38099.67880038462,38092.26717932519,
	38084.86727285899,38077.479046868706,38070.10246740451,38062.737500652715,38055.38411292925,
	38048.04227070254,38040.71194058485,38033.393089320925,38026.08568379109,38018.789691031576,
	38011.50507820142,38004.231812590915,37996.969861635895,37989.71919291372,37982.47977411924,
	37975.251573102105,37968.034557824394,37960.82869639643,37953.633957054735,37946.45030814422,
	37939.27771819417,37932.116155805365,37924.96558974606,37917.82598888618,37910.69732225239,
	37903.57955897141,37896.47266831371,37889.37661965121,37882.291382510135,37875.216926531924,
	37868.153221471475,37861.10023721412,37854.05794376275,37847.02631124975,37840.005309914355,
	37832.99491014303,37825.995082398484,37819.005797312726,37812.02702558784,37805.05873809594,
	37798.100905767606,37791.153499689,37784.216491063984,37777.28985119045,37770.37355149121,
	37763.46756349875,37756.57185886761,37749.68640936699,37742.811186857994,37735.94616333732,
	37729.09131089106,37722.24660174864,37715.41200821516,37708.58750271412,37701.773057801074,
	37694.96864609902,37688.17424036219,37681.38981346506,37674.61533837186,37667.85078813814,
	37661.096135962616,37654.35135511429,37647.616418986676,37640.89130107468,37634.17597495968,
	37627.47041435522,37620.77459305414,37614.08848496057,37607.412064074335,37600.74530450163,
	37594.08818045097,37587.44066621141,37580.80273620709,37574.17436491862,37567.555526972596,
	37560.94619704774,37554.34634994043,37547.755960540744,37541.175003858996,37534.603454952856,
	37528.04128901327,37521.48848132512,37514.94500723891,37508.41084223018,37501.885961853084,
	37495.37034175322,37488.86395767928,37482.36678545508,37475.87880101656,37469.39998038092,
	37462.930299647196,37456.46973501622,37450.01826278503,37443.5758593161,37437.14250109073,
	37430.71816466062,37424.30282665426,37417.89646381652,37411.499052961364,37405.11057098737,
	37398.73099489134,37392.360301750596,37385.99846872348,37379.64547306994,37373.30129210338,
	37366.965903254444,37360.639284015095,37354.321411970246,37348.01226478712,37341.71182022221,
	37335.420056091076,37329.1369503284,37322.86248090289,37316.59662591727,37310.3393635129,
	37304.0906719328,37297.85052948846,37291.61891459115,37285.39580569545,37279.18118136894,
	37272.97502024395,37266.77730102389,37260.58800250633,37254.40710354898,37248.23458310418,
	37242.07042018037,37235.91459387451,37229.76708337359,37223.627867900126,37217.49692679291,
	37211.374239449804,37205.25978532498,37199.15354398247,37193.05549502703,37186.96561815995,
	37180.88389313891,37174.81029981134,37168.7448180783,37162.687427928024,37156.6381094052,
	37150.596842642335,37144.56360784438,37138.53838525037,37132.52115521791,37126.511898161516,
	37120.510594542735,37114.51722490689,37108.53176988029,37102.55421013613,37096.58452642565,
	37090.6226995798,37084.668710474616,37078.72254007509,37072.784169399456,37066.853579539,
	37060.93075164449,37055.01566694782,37049.108306722395,37043.208652334455,37037.316685188365,
	37031.432386784276,37025.55573865924,37019.686722436665,37013.82531978674,37007.97151245378,
	37002.12528223316,36996.28661099722,36990.455480689176,36984.63187328156,36978.8157708379,
	36973.00715548181,36967.206009393885,36961.412314805144,36955.62605401017,36949.847209399086,
	36944.075763378576,36938.31169843455,36932.55499712008,36926.80564202807,36921.0636158361,
	36915.328901248555,36909.60148106418,36903.8813381135,36898.168455313185,36892.46281560208,
	36886.76440200166,36881.07319760008,36875.38918551226,36869.71234894382,36864.04267112639,
	36858.3801353598,36852.72472502292,36847.0764235084,36841.43521431125,36835.80108094087,
	36830.17400698085,36824.55397608377,36818.9409719275,36813.3349782634,36807.735978906036,
	36802.14395770115,36796.55889856025,36790.98078544777,36785.40960238365,36779.84533345056,
	36774.2879627582,36768.73747448843,36763.19385288212,36757.65708221098,36752.12714680634,
	36746.60403106924,36741.087719430725,36735.57819637065,36730.075446454095,36724.579454262406,
	36719.09020444621,36713.60768168682,36708.131870731726,36702.66275639115,36697.200323487545,
	36691.7445569399,36686.29544167428,36680.85296269437,36675.417105042674,36669.9878538109,
	36664.56519412961,36659.14911120109,36653.73959026162,36648.33661656832,36642.94017549722,
	36637.5502524312,36632.166832765324,36626.78990200087,36621.41944564891,36616.05544928179,
	36610.69789851014,36605.34677901183,36600.0020764845,36594.663776698995,36589.33186544369,
	36584.00632856027,36578.6871519506,36573.37432155604,36568.06782336228,36562.76764339577,
	36557.47376772036,36552.18618245259,36546.9048737619,36541.6298278607,36536.361030989596,
	36531.09846945402,36525.84212958083,36520.59199774924,36515.3480604017,36510.11030398154,
	36504.878715021405,36499.6532800531,36494.43398570263,36489.22081858004,36484.01376537751,
	36478.812812816905,36473.61794766505,36468.42915672131,36463.24642684881,36458.06974491621,
	36452.89909786998,36447.734472678225,36442.57585634544,36437.423235936265,36432.27659853118,
	36427.13593127288,36422.00122133746,36416.87245594105,36411.74962232183,36406.63270778227,
	36401.52169966993,36396.416585338375,36391.31735219872,36386.223987718135,36381.13647937668,
	36376.05481470169,36370.978981260356,36365.90896667101,36360.84475853978,36355.78634460173,
	36350.733712537796,36345.686850123886,36340.645745150825,36335.61038543962,36330.5807588809,
	36325.55685337463,36320.53865686009,36315.52615732413,36310.51934277676,36305.51820128671,
	36300.52272093815,36295.532889860915,36290.548696211874,36285.57012819287,36280.59717404466,
	36275.62982203726,36270.66806046635,36265.71187770163,36260.76126208939,36255.81620206863,
	36250.876686071264,36245.94270258161,36241.01424012774,36236.091287260286,36231.1738325471,
	36226.261864634864,36221.35537216313,36216.454343828445,36211.558768355244,36206.66863450238,
	36201.78393104369,36196.9046468373,36192.03077069541,36187.16229154664,36182.29919830616,
	36177.44147991642,36172.58912539962,36167.7421237528,36162.90046403799,36158.06413533808,
	36153.23312679055,36148.40742753067,36143.58702675087,36138.771913673285,36133.96207753778,
	36129.157507634816,36124.3581932662,36119.56412378662,36114.775288567376,36109.991677017635,
	36105.21327857317,36100.44008269035,36095.672078889016,36090.90925668286,36086.15160566068,
	36081.399115382315,36076.65177548425,36071.90957561491,36067.17250547482,36062.44055474823,
	36057.71371320598,36052.991970611445,36048.275316750914,36043.563741477665,36038.857234634066,
	36034.155786141106
	}}
};
