/*
 *		Copyright (C) 2013-2015, 2019 by the Konclude Developer Team.
 *
 *		This file is part of the reasoning system Konclude.
 *		For details and support, see <http://konclude.com/>.
 *
 *		Konclude is free software: you can redistribute it and/or modify
 *		it under the terms of version 3 of the GNU Lesser General Public
 *		License (LGPLv3) as published by the Free Software Foundation.
 *
 *		Konclude is distributed in the hope that it will be useful,
 *		but WITHOUT ANY WARRANTY; without even the implied warranty of
 *		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *		GNU (Lesser) General Public License for more details.
 *
 *		You should have received a copy of the GNU (Lesser) General Public
 *		License along with Konclude. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef KONCLUDE_CONFIG_CDOUBLECONFIGTYPE_H
#define KONCLUDE_CONFIG_CDOUBLECONFIGTYPE_H

// Libraries includes
#include <QString>
#include <QVariant>

// Namespace includes
#include "CConfigType.h"
#include "CConvertStringConfigType.h"
#include "CConvertDoubleConfigType.h"

// Other includes


// Logger includes
#include "Logger/CLogger.h"


namespace Konclude {

	namespace Config {

		/*! 
		 *
		 *		\class		CDoubleConfigType
		 *		\author		Andreas Steigmiller
		 *		\version	0.1
		 *		\brief		TODO
		 *
		 */
		class CDoubleConfigType : virtual public CConvertDoubleConfigType, virtual public CConvertStringConfigType, virtual public CConfigType {
			// public methods
			public:
				//! Constructor
				CDoubleConfigType(double value = 0);

				//! Destructor
				virtual ~CDoubleConfigType();

				
				virtual CDoubleConfigType *getTypeCopy();

				virtual bool supportsVariant();

				virtual CDoubleConfigType *setValue(double value);
				virtual double getValue();

				virtual CDoubleConfigType *readFrom(const QVariant &var);
				virtual QVariant getVariant();


				virtual bool readFromString(const QString &string);
				virtual QString getString();

				virtual bool readFromDouble(double doubleValue);
				virtual double getDouble();



				virtual bool equals(CConfigType *dataType);

			// protected methods
			protected:

			// protected variables
			protected:
				double mDoubleValue;
				
			// private methods
			private:

			// private variables
			private:

		};

	}; // end namespace Config

}; // end namespace Konclude

#endif // KONCLUDE_CONFIG_CDOUBLECONFIGTYPE_H
