
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileCapeBoxAttributes.h
    \brief Definition of CapeBox Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef CapeBoxAttributes_H
#define CapeBoxAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class CapeBoxAttributes 
{
public:
//  --  constructor
    CapeBoxAttributes();
    
//  --  destructor
    virtual ~CapeBoxAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const CapeBoxAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	double box_border_thickness_;
	int marker_index_;
	double marker_height_;
	double box_thickness_;
	double box_width_;
	double text_font_size_;
	unique_ptr<Colour> control_colour_;
	unique_ptr<Colour> hres_colour_;
	unique_ptr<Colour> box_colour_;
	unique_ptr<Colour> box_border_colour_;
	unique_ptr<Colour> marker_colour_;
	LineStyle box_style_;
	unique_ptr<Colour> text_font_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const CapeBoxAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

