
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileMetaDataAttributes.h
    \brief Definition of MetaData Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef MetaDataAttributes_H
#define MetaDataAttributes_H

#include "magics.h"
namespace magics {

class XmlNode;
class MetaDataAttributes 
{
public:
//  --  constructor
    MetaDataAttributes();
    
//  --  destructor
    virtual ~MetaDataAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const MetaDataAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string path_;
	string javascript_;
	string profile_;
	string world_file_;
	string wms_file_;
	string efi_;
	string efi_template_;
	 

private:
	friend ostream& operator<<(ostream& s,const MetaDataAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

