"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Danmarkshavn"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Danmarkshavn", { offset: true, expect: "Africa/Abidjan" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Danmarkshavn", { abbr: true, expect: "Africa/Abidjan" }),

	"1916" : helpers.makeTestYear("America/Danmarkshavn", [
		["1916-07-28T01:14:39+00:00", "23:59:59", "LMT", 4480 / 60],
		["1916-07-28T01:14:40+00:00", "22:14:40", "-03", 180]
	]),

	"1980" : helpers.makeTestYear("America/Danmarkshavn", [
		["1980-04-06T04:59:59+00:00", "01:59:59", "-03", 180],
		["1980-04-06T05:00:00+00:00", "03:00:00", "-02", 120],
		["1980-09-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["1980-09-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1981" : helpers.makeTestYear("America/Danmarkshavn", [
		["1981-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["1981-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["1981-09-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["1981-09-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1982" : helpers.makeTestYear("America/Danmarkshavn", [
		["1982-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["1982-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["1982-09-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["1982-09-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1983" : helpers.makeTestYear("America/Danmarkshavn", [
		["1983-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["1983-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["1983-09-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["1983-09-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1984" : helpers.makeTestYear("America/Danmarkshavn", [
		["1984-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["1984-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["1984-09-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["1984-09-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1985" : helpers.makeTestYear("America/Danmarkshavn", [
		["1985-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["1985-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["1985-09-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["1985-09-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1986" : helpers.makeTestYear("America/Danmarkshavn", [
		["1986-03-30T00:59:59+00:00", "21:59:59", "-03", 180],
		["1986-03-30T01:00:00+00:00", "23:00:00", "-02", 120],
		["1986-09-28T00:59:59+00:00", "22:59:59", "-02", 120],
		["1986-09-28T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1987" : helpers.makeTestYear("America/Danmarkshavn", [
		["1987-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["1987-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["1987-09-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["1987-09-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1988" : helpers.makeTestYear("America/Danmarkshavn", [
		["1988-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["1988-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["1988-09-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["1988-09-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1989" : helpers.makeTestYear("America/Danmarkshavn", [
		["1989-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["1989-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["1989-09-24T00:59:59+00:00", "22:59:59", "-02", 120],
		["1989-09-24T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1990" : helpers.makeTestYear("America/Danmarkshavn", [
		["1990-03-25T00:59:59+00:00", "21:59:59", "-03", 180],
		["1990-03-25T01:00:00+00:00", "23:00:00", "-02", 120],
		["1990-09-30T00:59:59+00:00", "22:59:59", "-02", 120],
		["1990-09-30T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1991" : helpers.makeTestYear("America/Danmarkshavn", [
		["1991-03-31T00:59:59+00:00", "21:59:59", "-03", 180],
		["1991-03-31T01:00:00+00:00", "23:00:00", "-02", 120],
		["1991-09-29T00:59:59+00:00", "22:59:59", "-02", 120],
		["1991-09-29T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1992" : helpers.makeTestYear("America/Danmarkshavn", [
		["1992-03-29T00:59:59+00:00", "21:59:59", "-03", 180],
		["1992-03-29T01:00:00+00:00", "23:00:00", "-02", 120],
		["1992-09-27T00:59:59+00:00", "22:59:59", "-02", 120],
		["1992-09-27T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1993" : helpers.makeTestYear("America/Danmarkshavn", [
		["1993-03-28T00:59:59+00:00", "21:59:59", "-03", 180],
		["1993-03-28T01:00:00+00:00", "23:00:00", "-02", 120],
		["1993-09-26T00:59:59+00:00", "22:59:59", "-02", 120],
		["1993-09-26T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1994" : helpers.makeTestYear("America/Danmarkshavn", [
		["1994-03-27T00:59:59+00:00", "21:59:59", "-03", 180],
		["1994-03-27T01:00:00+00:00", "23:00:00", "-02", 120],
		["1994-09-25T00:59:59+00:00", "22:59:59", "-02", 120],
		["1994-09-25T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1995" : helpers.makeTestYear("America/Danmarkshavn", [
		["1995-03-26T00:59:59+00:00", "21:59:59", "-03", 180],
		["1995-03-26T01:00:00+00:00", "23:00:00", "-02", 120],
		["1995-09-24T00:59:59+00:00", "22:59:59", "-02", 120],
		["1995-09-24T01:00:00+00:00", "22:00:00", "-03", 180]
	]),

	"1996" : helpers.makeTestYear("America/Danmarkshavn", [
		["1996-01-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1996-01-01T03:00:00+00:00", "03:00:00", "GMT", 0]
	])
};