// SPDX-FileCopyrightText: 2022 Nicolas Fella <nicolas.fella@gmx.de>
// SPDX-License-Identifier: GPL-2.0-or-later

#include "windowcontroller.h"

#include <KConfig>
#include <KWindowConfig>

#ifdef HAVE_WINDOWSYSTEM
#include <KStartupInfo>
#include <KWindowSystem>
#endif

#include <QStandardPaths>

WindowController &WindowController::instance()
{
    static WindowController instance;
    return instance;
}

void WindowController::setWindow(QWindow *window)
{
    m_window = window;
}

void WindowController::restoreGeometry()
{
    KConfig dataResource("data", KConfig::SimpleConfig, QStandardPaths::AppDataLocation);
    KConfigGroup windowGroup(&dataResource, "Window");
    KWindowConfig::restoreWindowSize(m_window, windowGroup);
    KWindowConfig::restoreWindowPosition(m_window, windowGroup);
}

void WindowController::saveGeometry()
{
    KConfig dataResource("data", KConfig::SimpleConfig, QStandardPaths::AppDataLocation);
    KConfigGroup windowGroup(&dataResource, "Window");
    KWindowConfig::saveWindowPosition(m_window, windowGroup);
    KWindowConfig::saveWindowSize(m_window, windowGroup);
}

void WindowController::showAndRaiseWindow(const QString &startupId)
{
    if (!m_window->isVisible()) {
        m_window->show();
    }

#ifdef HAVE_WINDOWSYSTEM
    if (!startupId.isEmpty()) {
        if (KWindowSystem::isPlatformX11()) {
            KStartupInfo::setNewStartupId(m_window, startupId.toUtf8());
        } else if (KWindowSystem::isPlatformWayland()) {
            KWindowSystem::setCurrentXdgActivationToken(startupId);
        }
    }

    KWindowSystem::activateWindow(m_window);
#endif
}
