{-------------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for
the specific language governing rights and limitations under the License.

Code template generated with SynGen.
The original code is: SynHighlighterNyquist.pas, released 2002-10-25.
Description: Nyquist Syntax Parser/Highlighter
The initial author of this file is Ning Hu.
Copyright (c) 2002, all rights reserved.

Contributors to the SynEdit and mwEdit projects are listed in the
Contributors.txt file.

Alternatively, the contents of this file may be used under the terms of the
GNU General Public License Version 2 or later (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.
If you wish to allow use of your version of this file only under the terms
of the GPL and not to allow others to use your version of this file
under the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the GPL.
If you do not delete the provisions above, a recipient may use your version
of this file under either the MPL or the GPL.

$Id: $

You may retrieve the latest version of this file at the SynEdit home page,
located at http://SynEdit.SourceForge.net

-------------------------------------------------------------------------------}

unit SynHighlighterNyquist;

{$I SynEdit.inc}

interface

uses
  SysUtils,
  Classes,
{$IFDEF SYN_CLX}
  QControls,
  QGraphics,
{$ELSE}
  Windows,
  Controls,
  Graphics,
{$ENDIF}
  SynEditTypes,
  SynEditHighlighter;

type
  TtkTokenKind = (
    tkComment,
    tkIdentifier,
    tkInvalidSymbol,
    tkKey,
    tkMacro,
    tkNull,
    tkNumber,
    tkParameter,
    tkSpace,
    tkString,
    tkSymbol,
    tkUnknown);

  TRangeState = (rsUnKnown, rsXLispComment, rsString);

  TProcTableProc = procedure of object;

  PIdentFuncTableFunc = ^TIdentFuncTableFunc;
  TIdentFuncTableFunc = function: TtkTokenKind of object;

const
  MaxKey = 308;

type
  TSynNyquistSyn = class(TSynCustomHighlighter)
  private
    fLine: PChar;
    fLineNumber: Integer;
    fProcTable: array[#0..#255] of TProcTableProc;
    fRange: TRangeState;
    Run: LongInt;
    fStringLen: Integer;
    fToIdent: PChar;
    fTokenPos: Integer;
    fTokenID: TtkTokenKind;
    fIdentFuncTable: array[0 .. MaxKey] of TIdentFuncTableFunc;
    fCommentAttri: TSynHighlighterAttributes;
    fIdentifierAttri: TSynHighlighterAttributes;
    fInvalidSymbolAttri: TSynHighlighterAttributes;
    fKeyAttri: TSynHighlighterAttributes;
    fMacroAttri: TSynHighlighterAttributes;
    fNumberAttri: TSynHighlighterAttributes;
    fParameterAttri: TSynHighlighterAttributes;
    fSpaceAttri: TSynHighlighterAttributes;
    fStringAttri: TSynHighlighterAttributes;
    fSymbolAttri: TSynHighlighterAttributes;
    function KeyHash(ToHash: PChar): Integer;
    function KeyComp(const aKey: string): Boolean;
    function Func0: TtkTokenKind;
    function Func10: TtkTokenKind;
    function Func14: TtkTokenKind;
    function Func15: TtkTokenKind;
    function Func19: TtkTokenKind;
    function Func21: TtkTokenKind;
    function Func22: TtkTokenKind;
    function Func23: TtkTokenKind;
    function Func24: TtkTokenKind;
    function Func25: TtkTokenKind;
    function Func26: TtkTokenKind;
    function Func27: TtkTokenKind;
    function Func28: TtkTokenKind;
    function Func29: TtkTokenKind;
    function Func30: TtkTokenKind;
    function Func31: TtkTokenKind;
    function Func32: TtkTokenKind;
    function Func33: TtkTokenKind;
    function Func34: TtkTokenKind;
    function Func35: TtkTokenKind;
    function Func36: TtkTokenKind;
    function Func37: TtkTokenKind;
    function Func38: TtkTokenKind;
    function Func39: TtkTokenKind;
    function Func40: TtkTokenKind;
    function Func41: TtkTokenKind;
    function Func42: TtkTokenKind;
    function Func43: TtkTokenKind;
    function Func44: TtkTokenKind;
    function Func45: TtkTokenKind;
    function Func46: TtkTokenKind;
    function Func47: TtkTokenKind;
    function Func48: TtkTokenKind;
    function Func49: TtkTokenKind;
    function Func50: TtkTokenKind;
    function Func51: TtkTokenKind;
    function Func52: TtkTokenKind;
    function Func53: TtkTokenKind;
    function Func54: TtkTokenKind;
    function Func55: TtkTokenKind;
    function Func56: TtkTokenKind;
    function Func57: TtkTokenKind;
    function Func58: TtkTokenKind;
    function Func59: TtkTokenKind;
    function Func60: TtkTokenKind;
    function Func61: TtkTokenKind;
    function Func62: TtkTokenKind;
    function Func63: TtkTokenKind;
    function Func64: TtkTokenKind;
    function Func65: TtkTokenKind;
    function Func66: TtkTokenKind;
    function Func67: TtkTokenKind;
    function Func68: TtkTokenKind;
    function Func69: TtkTokenKind;
    function Func70: TtkTokenKind;
    function Func71: TtkTokenKind;
    function Func72: TtkTokenKind;
    function Func73: TtkTokenKind;
    function Func74: TtkTokenKind;
    function Func75: TtkTokenKind;
    function Func76: TtkTokenKind;
    function Func77: TtkTokenKind;
    function Func78: TtkTokenKind;
    function Func79: TtkTokenKind;
    function Func80: TtkTokenKind;
    function Func81: TtkTokenKind;
    function Func82: TtkTokenKind;
    function Func83: TtkTokenKind;
    function Func84: TtkTokenKind;
    function Func85: TtkTokenKind;
    function Func86: TtkTokenKind;
    function Func87: TtkTokenKind;
    function Func88: TtkTokenKind;
    function Func89: TtkTokenKind;
    function Func90: TtkTokenKind;
    function Func91: TtkTokenKind;
    function Func92: TtkTokenKind;
    function Func93: TtkTokenKind;
    function Func94: TtkTokenKind;
    function Func95: TtkTokenKind;
    function Func96: TtkTokenKind;
    function Func97: TtkTokenKind;
    function Func98: TtkTokenKind;
    function Func99: TtkTokenKind;
    function Func100: TtkTokenKind;
    function Func101: TtkTokenKind;
    function Func102: TtkTokenKind;
    function Func103: TtkTokenKind;
    function Func104: TtkTokenKind;
    function Func105: TtkTokenKind;
    function Func107: TtkTokenKind;
    function Func108: TtkTokenKind;
    function Func109: TtkTokenKind;
    function Func110: TtkTokenKind;
    function Func111: TtkTokenKind;
    function Func113: TtkTokenKind;
    function Func114: TtkTokenKind;
    function Func115: TtkTokenKind;
    function Func116: TtkTokenKind;
    function Func117: TtkTokenKind;
    function Func118: TtkTokenKind;
    function Func119: TtkTokenKind;
    function Func120: TtkTokenKind;
    function Func122: TtkTokenKind;
    function Func123: TtkTokenKind;
    function Func124: TtkTokenKind;
    function Func125: TtkTokenKind;
    function Func126: TtkTokenKind;
    function Func127: TtkTokenKind;
    function Func129: TtkTokenKind;
    function Func130: TtkTokenKind;
    function Func131: TtkTokenKind;
    function Func133: TtkTokenKind;
    function Func134: TtkTokenKind;
    function Func135: TtkTokenKind;
    function Func138: TtkTokenKind;
    function Func140: TtkTokenKind;
    function Func141: TtkTokenKind;
    function Func142: TtkTokenKind;
    function Func144: TtkTokenKind;
    function Func145: TtkTokenKind;
    function Func146: TtkTokenKind;
    function Func147: TtkTokenKind;
    function Func148: TtkTokenKind;
    function Func149: TtkTokenKind;
    function Func150: TtkTokenKind;
    function Func151: TtkTokenKind;
    function Func152: TtkTokenKind;
    function Func153: TtkTokenKind;
    function Func154: TtkTokenKind;
    function Func155: TtkTokenKind;
    function Func158: TtkTokenKind;
    function Func159: TtkTokenKind;
    function Func162: TtkTokenKind;
    function Func164: TtkTokenKind;
    function Func166: TtkTokenKind;
    function Func169: TtkTokenKind;
    function Func171: TtkTokenKind;
    function Func172: TtkTokenKind;
    function Func173: TtkTokenKind;
    function Func177: TtkTokenKind;
    function Func180: TtkTokenKind;
    function Func182: TtkTokenKind;
    function Func185: TtkTokenKind;
    function Func188: TtkTokenKind;
    function Func190: TtkTokenKind;
    function Func204: TtkTokenKind;
    function Func207: TtkTokenKind;
    function Func208: TtkTokenKind;
    function Func209: TtkTokenKind;
    function Func210: TtkTokenKind;
    function Func226: TtkTokenKind;
    function Func228: TtkTokenKind;
    function Func247: TtkTokenKind;
    function Func273: TtkTokenKind;
    function Func281: TtkTokenKind;
    function Func282: TtkTokenKind;
    function Func306: TtkTokenKind;
    function Func308: TtkTokenKind;
    procedure Add_MinusProc;
    procedure CommaProc;
    procedure DotProc;
    procedure IdentProc;
    procedure NumberProc;
    procedure OneProc;
    procedure ParameterProc;
    procedure PoundProc;
    procedure QuoteProc;
    procedure RoundCloseProc;
    procedure RoundOpenProc;
    procedure SemiColonProc;
    procedure UnknownProc;
    function AltFunc: TtkTokenKind;
    procedure InitIdent;
    function IdentKind(MayBe: PChar): TtkTokenKind;
    procedure MakeMethodTables;
    procedure NullProc;
    procedure SpaceProc;
    procedure CRProc;
    procedure LFProc;
    procedure XLispCommentProc;
    procedure StringOpenProc;
    procedure StringProc;
  protected
    function GetIdentChars: TSynIdentChars; override;
    function GetSampleSource: string; override;
    function IsFilterStored: Boolean; override;
  public
    constructor Create(AOwner: TComponent); override;
    {$IFNDEF SYN_CPPB_1} class {$ENDIF}
    function GetLanguageName: string; override;
    function GetRange: Pointer; override;
    procedure ResetRange; override;
    procedure SetRange(Value: Pointer); override;
    function GetDefaultAttribute(Index: integer): TSynHighlighterAttributes; override;
    function GetEol: Boolean; override;
    function GetKeyWords: string;
    function GetTokenID: TtkTokenKind;
    procedure SetLine(NewValue: String; LineNumber: Integer); override;
    function GetToken: String; override;
    function GetTokenAttribute: TSynHighlighterAttributes; override;
    function GetTokenKind: integer; override;
    function GetTokenPos: Integer; override;
    procedure Next; override;
  published
    property CommentAttri: TSynHighlighterAttributes read fCommentAttri write fCommentAttri;
    property IdentifierAttri: TSynHighlighterAttributes read fIdentifierAttri write fIdentifierAttri;
    property InvalidSymbolAttri: TSynHighlighterAttributes read fInvalidSymbolAttri write fInvalidSymbolAttri;
    property KeyAttri: TSynHighlighterAttributes read fKeyAttri write fKeyAttri;
    property MacroAttri: TSynHighlighterAttributes read fMacroAttri write fMacroAttri;
    property NumberAttri: TSynHighlighterAttributes read fNumberAttri write fNumberAttri;
    property ParameterAttri: TSynHighlighterAttributes read fParameterAttri write fParameterAttri;
    property SpaceAttri: TSynHighlighterAttributes read fSpaceAttri write fSpaceAttri;
    property StringAttri: TSynHighlighterAttributes read fStringAttri write fStringAttri;
    property SymbolAttri: TSynHighlighterAttributes read fSymbolAttri write fSymbolAttri;
  end;

implementation

uses
  SynEditStrConst;

{$IFDEF SYN_COMPILER_3_UP}
resourcestring
{$ELSE}
const
{$ENDIF}
  SYNS_FilterNyquist = 'Nyquist files (*.lsp)|*.lsp';
  SYNS_LangNyquist = 'Nyquist';
  SYNS_AttrParameter = 'Parameter';

var
  Identifiers: array[#0..#255] of ByteBool;
  mHashTable : array[#0..#255] of Integer;

procedure MakeIdentTable;
var
  I, J: Char;
begin
  for I := #0 to #255 do
  begin
    case I of
      #33, #35..#38, #42, #43, #45..#58, #60..#95, #97..#126: Identifiers[I] := True;
    else
      Identifiers[I] := False;
    end;
    J := UpCase(I);
    case I in ['_', 'A'..'Z', 'a'..'z'] of
      True: mHashTable[I] := Ord(J) - 64
    else
      mHashTable[I] := 0;
    end;
  end;
end;

procedure TSynNyquistSyn.InitIdent;
var
  I: Integer;
  pF: PIdentFuncTableFunc;
begin
  pF := PIdentFuncTableFunc(@fIdentFuncTable);
  for I := Low(fIdentFuncTable) to High(fIdentFuncTable) do
  begin
    pF^ := AltFunc;
    Inc(pF);
  end;
  fIdentFuncTable[0] := Func0;
  fIdentFuncTable[10] := Func10;
  fIdentFuncTable[14] := Func14;
  fIdentFuncTable[15] := Func15;
  fIdentFuncTable[19] := Func19;
  fIdentFuncTable[21] := Func21;
  fIdentFuncTable[22] := Func22;
  fIdentFuncTable[23] := Func23;
  fIdentFuncTable[24] := Func24;
  fIdentFuncTable[25] := Func25;
  fIdentFuncTable[26] := Func26;
  fIdentFuncTable[27] := Func27;
  fIdentFuncTable[28] := Func28;
  fIdentFuncTable[29] := Func29;
  fIdentFuncTable[30] := Func30;
  fIdentFuncTable[31] := Func31;
  fIdentFuncTable[32] := Func32;
  fIdentFuncTable[33] := Func33;
  fIdentFuncTable[34] := Func34;
  fIdentFuncTable[35] := Func35;
  fIdentFuncTable[36] := Func36;
  fIdentFuncTable[37] := Func37;
  fIdentFuncTable[38] := Func38;
  fIdentFuncTable[39] := Func39;
  fIdentFuncTable[40] := Func40;
  fIdentFuncTable[41] := Func41;
  fIdentFuncTable[42] := Func42;
  fIdentFuncTable[43] := Func43;
  fIdentFuncTable[44] := Func44;
  fIdentFuncTable[45] := Func45;
  fIdentFuncTable[46] := Func46;
  fIdentFuncTable[47] := Func47;
  fIdentFuncTable[48] := Func48;
  fIdentFuncTable[49] := Func49;
  fIdentFuncTable[50] := Func50;
  fIdentFuncTable[51] := Func51;
  fIdentFuncTable[52] := Func52;
  fIdentFuncTable[53] := Func53;
  fIdentFuncTable[54] := Func54;
  fIdentFuncTable[55] := Func55;
  fIdentFuncTable[56] := Func56;
  fIdentFuncTable[57] := Func57;
  fIdentFuncTable[58] := Func58;
  fIdentFuncTable[59] := Func59;
  fIdentFuncTable[60] := Func60;
  fIdentFuncTable[61] := Func61;
  fIdentFuncTable[62] := Func62;
  fIdentFuncTable[63] := Func63;
  fIdentFuncTable[64] := Func64;
  fIdentFuncTable[65] := Func65;
  fIdentFuncTable[66] := Func66;
  fIdentFuncTable[67] := Func67;
  fIdentFuncTable[68] := Func68;
  fIdentFuncTable[69] := Func69;
  fIdentFuncTable[70] := Func70;
  fIdentFuncTable[71] := Func71;
  fIdentFuncTable[72] := Func72;
  fIdentFuncTable[73] := Func73;
  fIdentFuncTable[74] := Func74;
  fIdentFuncTable[75] := Func75;
  fIdentFuncTable[76] := Func76;
  fIdentFuncTable[77] := Func77;
  fIdentFuncTable[78] := Func78;
  fIdentFuncTable[79] := Func79;
  fIdentFuncTable[80] := Func80;
  fIdentFuncTable[81] := Func81;
  fIdentFuncTable[82] := Func82;
  fIdentFuncTable[83] := Func83;
  fIdentFuncTable[84] := Func84;
  fIdentFuncTable[85] := Func85;
  fIdentFuncTable[86] := Func86;
  fIdentFuncTable[87] := Func87;
  fIdentFuncTable[88] := Func88;
  fIdentFuncTable[89] := Func89;
  fIdentFuncTable[90] := Func90;
  fIdentFuncTable[91] := Func91;
  fIdentFuncTable[92] := Func92;
  fIdentFuncTable[93] := Func93;
  fIdentFuncTable[94] := Func94;
  fIdentFuncTable[95] := Func95;
  fIdentFuncTable[96] := Func96;
  fIdentFuncTable[97] := Func97;
  fIdentFuncTable[98] := Func98;
  fIdentFuncTable[99] := Func99;
  fIdentFuncTable[100] := Func100;
  fIdentFuncTable[101] := Func101;
  fIdentFuncTable[102] := Func102;
  fIdentFuncTable[103] := Func103;
  fIdentFuncTable[104] := Func104;
  fIdentFuncTable[105] := Func105;
  fIdentFuncTable[107] := Func107;
  fIdentFuncTable[108] := Func108;
  fIdentFuncTable[109] := Func109;
  fIdentFuncTable[110] := Func110;
  fIdentFuncTable[111] := Func111;
  fIdentFuncTable[113] := Func113;
  fIdentFuncTable[114] := Func114;
  fIdentFuncTable[115] := Func115;
  fIdentFuncTable[116] := Func116;
  fIdentFuncTable[117] := Func117;
  fIdentFuncTable[118] := Func118;
  fIdentFuncTable[119] := Func119;
  fIdentFuncTable[120] := Func120;
  fIdentFuncTable[122] := Func122;
  fIdentFuncTable[123] := Func123;
  fIdentFuncTable[124] := Func124;
  fIdentFuncTable[125] := Func125;
  fIdentFuncTable[126] := Func126;
  fIdentFuncTable[127] := Func127;
  fIdentFuncTable[129] := Func129;
  fIdentFuncTable[130] := Func130;
  fIdentFuncTable[131] := Func131;
  fIdentFuncTable[133] := Func133;
  fIdentFuncTable[134] := Func134;
  fIdentFuncTable[135] := Func135;
  fIdentFuncTable[138] := Func138;
  fIdentFuncTable[140] := Func140;
  fIdentFuncTable[141] := Func141;
  fIdentFuncTable[142] := Func142;
  fIdentFuncTable[144] := Func144;
  fIdentFuncTable[145] := Func145;
  fIdentFuncTable[146] := Func146;
  fIdentFuncTable[147] := Func147;
  fIdentFuncTable[148] := Func148;
  fIdentFuncTable[149] := Func149;
  fIdentFuncTable[150] := Func150;
  fIdentFuncTable[151] := Func151;
  fIdentFuncTable[152] := Func152;
  fIdentFuncTable[153] := Func153;
  fIdentFuncTable[154] := Func154;
  fIdentFuncTable[155] := Func155;
  fIdentFuncTable[158] := Func158;
  fIdentFuncTable[159] := Func159;
  fIdentFuncTable[162] := Func162;
  fIdentFuncTable[164] := Func164;
  fIdentFuncTable[166] := Func166;
  fIdentFuncTable[169] := Func169;
  fIdentFuncTable[171] := Func171;
  fIdentFuncTable[172] := Func172;
  fIdentFuncTable[173] := Func173;
  fIdentFuncTable[177] := Func177;
  fIdentFuncTable[180] := Func180;
  fIdentFuncTable[182] := Func182;
  fIdentFuncTable[185] := Func185;
  fIdentFuncTable[188] := Func188;
  fIdentFuncTable[190] := Func190;
  fIdentFuncTable[204] := Func204;
  fIdentFuncTable[207] := Func207;
  fIdentFuncTable[208] := Func208;
  fIdentFuncTable[209] := Func209;
  fIdentFuncTable[210] := Func210;
  fIdentFuncTable[226] := Func226;
  fIdentFuncTable[228] := Func228;
  fIdentFuncTable[247] := Func247;
  fIdentFuncTable[273] := Func273;
  fIdentFuncTable[281] := Func281;
  fIdentFuncTable[282] := Func282;
  fIdentFuncTable[306] := Func306;
  fIdentFuncTable[308] := Func308;
end;

function TSynNyquistSyn.KeyHash(ToHash: PChar): Integer;
begin
  Result := 0;
  while ToHash^ in [#33, #35..#38, #42, #43, #45..#58, #60..#95, #97..#126] do
  begin
    inc(Result, mHashTable[ToHash^]);
    inc(ToHash);
  end;
  fStringLen := ToHash - fToIdent;
end;

function TSynNyquistSyn.KeyComp(const aKey: String): Boolean;
var
  I: Integer;
  Temp: PChar;
begin
  Temp := fToIdent;
  if Length(aKey) = fStringLen then
  begin
    Result := True;
    for i := 1 to fStringLen do
    begin
      if mHashTable[Temp^] <> mHashTable[aKey[i]] then
      begin
        Result := False;
        break;
      end;
      inc(Temp);
    end;
  end
  else
    Result := False;
end;

function TSynNyquistSyn.Func0: TtkTokenKind;
begin
  if KeyComp('<') then Result := tkKey else
    if KeyComp('<=') then Result := tkKey else
      if KeyComp('*') then Result := tkKey else
        if KeyComp('/') then Result := tkKey else
          if KeyComp('>=') then Result := tkKey else
            if KeyComp('>') then Result := tkKey else
              if KeyComp('=') then Result := tkKey else
                if KeyComp('/=') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func10: TtkTokenKind;
begin
  if KeyComp('gc') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func14: TtkTokenKind;
begin
  if KeyComp('gcd') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func15: TtkTokenKind;
begin
  if KeyComp('if') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func19: TtkTokenKind;
begin
  if KeyComp('do') then Result := tkKey else
    if KeyComp('and') then Result := tkKey else
      if KeyComp('do*') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func21: TtkTokenKind;
begin
  if KeyComp('at') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func22: TtkTokenKind;
begin
  if KeyComp('car') then Result := tkKey else
    if KeyComp('eq') then Result := tkKey else
      if KeyComp('abs') then Result := tkKey else
        if KeyComp('go') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func23: TtkTokenKind;
begin
  if KeyComp('caar') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func24: TtkTokenKind;
begin
  if KeyComp('hp') then Result := tkKey else
    if KeyComp('caaar') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func25: TtkTokenKind;
begin
  if KeyComp('diff') then Result := tkKey else
    if KeyComp('cdr') then Result := tkKey else
      if KeyComp('caaaar') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func26: TtkTokenKind;
begin
  if KeyComp('cdar') then Result := tkKey else
    if KeyComp('cadr') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func27: TtkTokenKind;
begin
  if KeyComp('cdaar') then Result := tkKey else
    if KeyComp('caadr') then Result := tkKey else
      if KeyComp('cadar') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func28: TtkTokenKind;
begin
  if KeyComp('cadaar') then Result := tkKey else
    if KeyComp('read') then Result := tkKey else
      if KeyComp('caaadr') then Result := tkKey else
        if KeyComp('cdaaar') then Result := tkKey else
          if KeyComp('caadar') then Result := tkKey else
            if KeyComp('lp') then Result := tkKey else
              if KeyComp('case') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func29: TtkTokenKind;
begin
  if KeyComp('cddr') then Result := tkKey else
    if KeyComp('cue') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func30: TtkTokenKind;
begin
  if KeyComp('char>') then Result := tkKey else
    if KeyComp('cddar') then Result := tkKey else
      if KeyComp('caddr') then Result := tkKey else
        if KeyComp('cdadr') then Result := tkKey else
          if KeyComp('char>=') then Result := tkKey else
            if KeyComp('char<') then Result := tkKey else
              if KeyComp('char') then Result := tkKey else
                if KeyComp('aref') then Result := tkKey else
                  if KeyComp('char=') then Result := tkKey else
                    if KeyComp('char/=') then Result := tkKey else
                      if KeyComp('char<=') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func31: TtkTokenKind;
begin
  if KeyComp('caaddr') then Result := tkKey else
    if KeyComp('pan') then Result := tkKey else
      if KeyComp('cadadr') then Result := tkKey else
        if KeyComp('cdaadr') then Result := tkKey else
          if KeyComp('cdadar') then Result := tkKey else
            if KeyComp('cddaar') then Result := tkKey else
              if KeyComp('caddar') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func32: TtkTokenKind;
begin
  if KeyComp('load') then Result := tkKey else
    if KeyComp('get') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func33: TtkTokenKind;
begin
  if KeyComp('or') then Result := tkKey else
    if KeyComp('comb') then Result := tkKey else
      if KeyComp('lfo') then Result := tkKey else
        if KeyComp('peak') then Result := tkKey else
          if KeyComp('cdddr') then Result := tkKey else
            if KeyComp('lambda') then Result := tkKey else
              if KeyComp('mapc') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func34: TtkTokenKind;
begin
  if KeyComp('eql') then Result := tkKey else
    if KeyComp('cdddar') then Result := tkKey else
      if KeyComp('log') then Result := tkKey else
        if KeyComp('cddadr') then Result := tkKey else
          if KeyComp('cdaddr') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func35: TtkTokenKind;
begin
  if KeyComp('tan') then Result := tkKey else
    if KeyComp('catch') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func36: TtkTokenKind;
begin
  if KeyComp('hash') then Result := tkKey else
    if KeyComp('min') then Result := tkKey else
      if KeyComp('rem') then Result := tkKey else
        if KeyComp('cond') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func37: TtkTokenKind;
begin
  if KeyComp('break') then Result := tkKey else
    if KeyComp('let') then Result := tkKey else
      if KeyComp('osc') then Result := tkKey else
        if KeyComp('let*') then Result := tkKey else
          if KeyComp('cddddr') then Result := tkKey else
            if KeyComp('peek') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func38: TtkTokenKind;
begin
  if KeyComp('max') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func39: TtkTokenKind;
begin
  if KeyComp('oddp') then Result := tkKey else
    if KeyComp('endp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func40: TtkTokenKind;
begin
  if KeyComp('eval') then Result := tkKey else
    if KeyComp('clip') then Result := tkKey else
      if KeyComp('scale') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func41: TtkTokenKind;
begin
  if KeyComp('env') then Result := tkKey else
    if KeyComp('sim') then Result := tkKey else
      if KeyComp('s-abs') then Result := tkKey else
        if KeyComp('seq') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func42: TtkTokenKind;
begin
  if KeyComp('sin') then Result := tkKey else
    if KeyComp('mapl') then Result := tkKey else
      if KeyComp('flatc') then Result := tkKey else
        if KeyComp('nth') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func43: TtkTokenKind;
begin
  if KeyComp('block') then Result := tkKey else
    if KeyComp('eq-band') then Result := tkKey else
      if KeyComp('flet') then Result := tkKey else
        if KeyComp('alloc') then Result := tkKey else
          if KeyComp('at-abs') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func44: TtkTokenKind;
begin
  if KeyComp('set') then Result := tkKey else
    if KeyComp('pwe') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func45: TtkTokenKind;
begin
  if KeyComp('exp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func46: TtkTokenKind;
begin
  if KeyComp('scale-db') then Result := tkKey else
    if KeyComp('snd-add') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func47: TtkTokenKind;
begin
  if KeyComp('sine') then Result := tkKey else
    if KeyComp('trace') then Result := tkKey else
      if KeyComp('save') then Result := tkKey else
        if KeyComp('poke') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func48: TtkTokenKind;
begin
  if KeyComp('ramp') then Result := tkKey else
    if KeyComp('sref') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func49: TtkTokenKind;
begin
  if KeyComp('atom') then Result := tkKey else
    if KeyComp('nconc') then Result := tkKey else
      if KeyComp('shape') then Result := tkKey else
        if KeyComp('not') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func50: TtkTokenKind;
begin
  if KeyComp('when') then Result := tkKey else
    if KeyComp('defun') then Result := tkKey else
      if KeyComp('setf') then Result := tkKey else
        if KeyComp('rms') then Result := tkKey else
          if KeyComp('open') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func51: TtkTokenKind;
begin
  if KeyComp('pwl') then Result := tkKey else
    if KeyComp('cons') then Result := tkKey else
      if KeyComp('amosc') then Result := tkKey else
        if KeyComp('labels') then Result := tkKey else
          if KeyComp('delete') then Result := tkKey else
            if KeyComp('rplaca') then Result := tkKey else
              if KeyComp('recip') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func52: TtkTokenKind;
begin
  if KeyComp('mapcar') then Result := tkKey else
    if KeyComp('last') then Result := tkKey else
      if KeyComp('loud') then Result := tkKey else
        if KeyComp('dribble') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func53: TtkTokenKind;
begin
  if KeyComp('logand') then Result := tkKey else
    if KeyComp('s-log') then Result := tkKey else
      if KeyComp('prod') then Result := tkKey else
        if KeyComp('prod') then Result := tkKey else
          if KeyComp('sum') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func54: TtkTokenKind;
begin
  if KeyComp('play') then Result := tkKey else
    if KeyComp('tone') then Result := tkKey else
      if KeyComp('close') then Result := tkKey else
        if KeyComp('biquad') then Result := tkKey else
          if KeyComp('rplacd') then Result := tkKey else
            if KeyComp('float') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func55: TtkTokenKind;
begin
  if KeyComp('atone') then Result := tkKey else
    if KeyComp('s-min') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func56: TtkTokenKind;
begin
  if KeyComp('fmosc') then Result := tkKey else
    if KeyComp('append') then Result := tkKey else
      if KeyComp('prog1') then Result := tkKey else
        if KeyComp('prog2') then Result := tkKey else
          if KeyComp('prog*') then Result := tkKey else
            if KeyComp('equal') then Result := tkKey else
              if KeyComp('prog') then Result := tkKey else
                if KeyComp('member') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func57: TtkTokenKind;
begin
  if KeyComp('snd-t0') then Result := tkKey else
    if KeyComp('s-max') then Result := tkKey else
      if KeyComp('exp-dec') then Result := tkKey else
        if KeyComp('prin1') then Result := tkKey else
          if KeyComp('code-char') then Result := tkKey else
            if KeyComp('assoc') then Result := tkKey else
              if KeyComp('char-code') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func58: TtkTokenKind;
begin
  if KeyComp('exit') then Result := tkKey else
    if KeyComp('loop') then Result := tkKey else
      if KeyComp('read-char') then Result := tkKey else
        if KeyComp('warp') then Result := tkKey else
          if KeyComp('congen') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func59: TtkTokenKind;
begin
  if KeyComp('snd-abs') then Result := tkKey else
    if KeyComp('null') then Result := tkKey else
      if KeyComp('third') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func60: TtkTokenKind;
begin
  if KeyComp('notch2') then Result := tkKey else
    if KeyComp('list') then Result := tkKey else
      if KeyComp('second') then Result := tkKey else
        if KeyComp('princ') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func61: TtkTokenKind;
begin
  if KeyComp('baktrace') then Result := tkKey else
    if KeyComp('room') then Result := tkKey else
      if KeyComp('setq') then Result := tkKey else
        if KeyComp('cue-file') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func62: TtkTokenKind;
begin
  if KeyComp('noise') then Result := tkKey else
    if KeyComp('evenp') then Result := tkKey else
      if KeyComp('rest') then Result := tkKey else
        if KeyComp('pwer') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func63: TtkTokenKind;
begin
  if KeyComp('pluck') then Result := tkKey else
    if KeyComp('abs-env') then Result := tkKey else
      if KeyComp('s-add-to') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func64: TtkTokenKind;
begin
  if KeyComp('expand') then Result := tkKey else
    if KeyComp('s-exp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func65: TtkTokenKind;
begin
  if KeyComp('siosc') then Result := tkKey else
    if KeyComp('random') then Result := tkKey else
      if KeyComp('snd-read') then Result := tkKey else
        if KeyComp('expt') then Result := tkKey else
          if KeyComp('defmacro') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func66: TtkTokenKind;
begin
  if KeyComp('s-save') then Result := tkKey else
    if KeyComp('mult') then Result := tkKey else
      if KeyComp('delete-if') then Result := tkKey else
        if KeyComp('pwev') then Result := tkKey else
          if KeyComp('length') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func67: TtkTokenKind;
begin
  if KeyComp('consp') then Result := tkKey else
    if KeyComp('biquad-m') then Result := tkKey else
      if KeyComp('slope') then Result := tkKey else
        if KeyComp('snd-avg') then Result := tkKey else
          if KeyComp('nthcdr') then Result := tkKey else
            if KeyComp('peek-char') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func68: TtkTokenKind;
begin
  if KeyComp('alpass') then Result := tkKey else
    if KeyComp('read-line') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func69: TtkTokenKind;
begin
  if KeyComp('sf-info') then Result := tkKey else
    if KeyComp('pwlr') then Result := tkKey else
      if KeyComp('funcall') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func70: TtkTokenKind;
begin
  if KeyComp('maketable') then Result := tkKey else
    if KeyComp('snd-gate') then Result := tkKey else
      if KeyComp('apply') then Result := tkKey else
        if KeyComp('floatp') then Result := tkKey else
          if KeyComp('progn') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func71: TtkTokenKind;
begin
  if KeyComp('objectp') then Result := tkKey else
    if KeyComp('read-int') then Result := tkKey else
      if KeyComp('const') then Result := tkKey else
        if KeyComp('hzosc') then Result := tkKey else
          if KeyComp('reson') then Result := tkKey else
            if KeyComp('snd-log') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func72: TtkTokenKind;
begin
  if KeyComp('areson') then Result := tkKey else
    if KeyComp('first') then Result := tkKey else
      if KeyComp('clean-up') then Result := tkKey else
        if KeyComp('boundp') then Result := tkKey else
          if KeyComp('sort') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func73: TtkTokenKind;
begin
  if KeyComp('sound') then Result := tkKey else
    if KeyComp('snd-chase') then Result := tkKey else
      if KeyComp('char-int') then Result := tkKey else
        if KeyComp('int-char') then Result := tkKey else
          if KeyComp('format') then Result := tkKey else
            if KeyComp('pwlv') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func74: TtkTokenKind;
begin
  if KeyComp('error') then Result := tkKey else
    if KeyComp('snd-up') then Result := tkKey else
      if KeyComp('tagbody') then Result := tkKey else
        if KeyComp('snd-osc') then Result := tkKey else
          if KeyComp('sqrt') then Result := tkKey else
            if KeyComp('loud-abs') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func75: TtkTokenKind;
begin
  if KeyComp('snd-max') then Result := tkKey else
    if KeyComp('buzz') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func76: TtkTokenKind;
begin
  if KeyComp('logior') then Result := tkKey else
    if KeyComp('bandpass2') then Result := tkKey else
      if KeyComp('listp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func77: TtkTokenKind;
begin
  if KeyComp('snd-scale') then Result := tkKey else
    if KeyComp('partial') then Result := tkKey else
      if KeyComp('snd-clip') then Result := tkKey else
        if KeyComp('psetq') then Result := tkKey else
          if KeyComp('print') then Result := tkKey else
            if KeyComp('cerror') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func78: TtkTokenKind;
begin
  if KeyComp('remove') then Result := tkKey else
    if KeyComp('fboundp') then Result := tkKey else
      if KeyComp('progv') then Result := tkKey else
        if KeyComp('snd-seq') then Result := tkKey else
          if KeyComp('quote') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func79: TtkTokenKind;
begin
  if KeyComp('digit-char') then Result := tkKey else
    if KeyComp('arrayp') then Result := tkKey else
      if KeyComp('stats') then Result := tkKey else
        if KeyComp('dolist') then Result := tkKey else
          if KeyComp('snd-fetch') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func80: TtkTokenKind;
begin
  if KeyComp('simrep') then Result := tkKey else
    if KeyComp('seqrep') then Result := tkKey else
      if KeyComp('read-byte') then Result := tkKey else
        if KeyComp('osc-saw') then Result := tkKey else
          if KeyComp('zerop') then Result := tkKey else
            if KeyComp('warp-abs') then Result := tkKey else
              if KeyComp('allpass2') then Result := tkKey else
                if KeyComp('intern') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func81: TtkTokenKind;
begin
  if KeyComp('strcat') then Result := tkKey else
    if KeyComp('profile') then Result := tkKey else
      if KeyComp('subst') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func82: TtkTokenKind;
begin
  if KeyComp('snd-exp') then Result := tkKey else
    if KeyComp('s-plot') then Result := tkKey else
      if KeyComp('untrace') then Result := tkKey else
        if KeyComp('sublis') then Result := tkKey else
          if KeyComp('read-float') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func83: TtkTokenKind;
begin
  if KeyComp('vector') then Result := tkKey else
    if KeyComp('gensym') then Result := tkKey else
      if KeyComp('lognot') then Result := tkKey else
        if KeyComp('subseq') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func84: TtkTokenKind;
begin
  if KeyComp('sampler') then Result := tkKey else
    if KeyComp('snd-time') then Result := tkKey else
      if KeyComp('osc-tri') then Result := tkKey else
        if KeyComp('get-loud') then Result := tkKey else
          if KeyComp('throw') then Result := tkKey else
            if KeyComp('snd-delay') then Result := tkKey else
              if KeyComp('plusp') then Result := tkKey else
                if KeyComp('snd-sine') then Result := tkKey else
                  if KeyComp('snd-save') then Result := tkKey else
                    if KeyComp('feedback-delay') then Result := tkKey else
                      if KeyComp('pwevr') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func85: TtkTokenKind;
begin
  if KeyComp('errset') then Result := tkKey else
    if KeyComp('dotimes') then Result := tkKey else
      if KeyComp('snd-sref') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func86: TtkTokenKind;
begin
  if KeyComp('snd-shape') then Result := tkKey else
    if KeyComp('terpri') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func87: TtkTokenKind;
begin
  if KeyComp('type-of') then Result := tkKey else
    if KeyComp('highpass8') then Result := tkKey else
      if KeyComp('string/=') then Result := tkKey else
        if KeyComp('string<') then Result := tkKey else
          if KeyComp('string<=') then Result := tkKey else
            if KeyComp('string=') then Result := tkKey else
              if KeyComp('string>=') then Result := tkKey else
                if KeyComp('highpass4') then Result := tkKey else
                  if KeyComp('highpass6') then Result := tkKey else
                    if KeyComp('string') then Result := tkKey else
                      if KeyComp('highpass2') then Result := tkKey else
                        if KeyComp('string>') then Result := tkKey else
                          if KeyComp('macrolet') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func88: TtkTokenKind;
begin
  if KeyComp('snd-amosc') then Result := tkKey else
    if KeyComp('fourth') then Result := tkKey else
      if KeyComp('snd-pwl') then Result := tkKey else
        if KeyComp('snd-recip') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func89: TtkTokenKind;
begin
  if KeyComp('soundp') then Result := tkKey else
    if KeyComp('numberp') then Result := tkKey else
      if KeyComp('evalhook') then Result := tkKey else
        if KeyComp('resample') then Result := tkKey else
          if KeyComp('both-case-p') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func90: TtkTokenKind;
begin
  if KeyComp('get-warp') then Result := tkKey else
    if KeyComp('snd-prod') then Result := tkKey else
      if KeyComp('unless') then Result := tkKey else
        if KeyComp('maplist') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func91: TtkTokenKind;
begin
  if KeyComp('osc-note') then Result := tkKey else
    if KeyComp('address-of') then Result := tkKey else
      if KeyComp('snd-biquad') then Result := tkKey else
        if KeyComp('snd-play') then Result := tkKey else
          if KeyComp('snd-tone') then Result := tkKey else
            if KeyComp('logxor') then Result := tkKey else
              if KeyComp('extract') then Result := tkKey else
                if KeyComp('pwlvr') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func92: TtkTokenKind;
begin
  if KeyComp('timed-seq') then Result := tkKey else
    if KeyComp('reverse') then Result := tkKey else
      if KeyComp('snd-atone') then Result := tkKey else
        if KeyComp('minusp') then Result := tkKey else
          if KeyComp('streamp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func93: TtkTokenKind;
begin
  if KeyComp('make-array') then Result := tkKey else
    if KeyComp('stretch') then Result := tkKey else
      if KeyComp('s-sqrt') then Result := tkKey else
        if KeyComp('snd-down') then Result := tkKey else
          if KeyComp('pprint') then Result := tkKey else
            if KeyComp('snd-fmosc') then Result := tkKey else
              if KeyComp('remove-if') then Result := tkKey else
                if KeyComp('characterp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func94: TtkTokenKind;
begin
  if KeyComp('integerp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func95: TtkTokenKind;
begin
  if KeyComp('snd-congen') then Result := tkKey else
    if KeyComp('digit-char-p') then Result := tkKey else
      if KeyComp('char-upcase') then Result := tkKey else
        if KeyComp('backquote') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func96: TtkTokenKind;
begin
  if KeyComp('snd-copy') then Result := tkKey else
    if KeyComp('return') then Result := tkKey else
      if KeyComp('snd-tapv') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func97: TtkTokenKind;
begin
  if KeyComp('control') then Result := tkKey else
    if KeyComp('snd-maxv') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func98: TtkTokenKind;
begin
  if KeyComp('flatsize') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func99: TtkTokenKind;
begin
  if KeyComp('integrate') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func100: TtkTokenKind;
begin
  if KeyComp('linear-to-db') then Result := tkKey else
    if KeyComp('sound-off') then Result := tkKey else
      if KeyComp('snd-srate') then Result := tkKey else
        if KeyComp('sound-off') then Result := tkKey else
          if KeyComp('db-to-linear') then Result := tkKey else
            if KeyComp('restore') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func101: TtkTokenKind;
begin
  if KeyComp('char-lessp') then Result := tkKey else
    if KeyComp('snd-zero') then Result := tkKey else
      if KeyComp('continue') then Result := tkKey else
        if KeyComp('remprop') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func102: TtkTokenKind;
begin
  if KeyComp('truncate') then Result := tkKey else
    if KeyComp('sound-on') then Result := tkKey else
      if KeyComp('function') then Result := tkKey else
        if KeyComp('char-equalp') then Result := tkKey else
          if KeyComp('snd-white') then Result := tkKey else
            if KeyComp('snd-siosc') then Result := tkKey else
              if KeyComp('symbolp') then Result := tkKey else
                if KeyComp('sound-on') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func103: TtkTokenKind;
begin
  if KeyComp('stringp') then Result := tkKey else
    if KeyComp('scale-srate') then Result := tkKey else
      if KeyComp('sustain') then Result := tkKey else
        if KeyComp('snd-length') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func104: TtkTokenKind;
begin
  if KeyComp('pwe-list') then Result := tkKey else
    if KeyComp('eq-highshelf') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func105: TtkTokenKind;
begin
  if KeyComp('snd-alpass') then Result := tkKey else
    if KeyComp('lowpass6') then Result := tkKey else
      if KeyComp('lowpass8') then Result := tkKey else
        if KeyComp('write-char') then Result := tkKey else
          if KeyComp('lowpass2') then Result := tkKey else
            if KeyComp('lowpass4') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func107: TtkTokenKind;
begin
  if KeyComp('top-level') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func108: TtkTokenKind;
begin
  if KeyComp('snd-reson') then Result := tkKey else
    if KeyComp('snd-const') then Result := tkKey else
      if KeyComp('convolve') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func109: TtkTokenKind;
begin
  if KeyComp('shift-time') then Result := tkKey else
    if KeyComp('snd-delaycv') then Result := tkKey else
      if KeyComp('snd-areson') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func110: TtkTokenKind;
begin
  if KeyComp('force-srate') then Result := tkKey else
    if KeyComp('osc-pulse') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func111: TtkTokenKind;
begin
  if KeyComp('snd-coterm') then Result := tkKey else
    if KeyComp('pwl-list') then Result := tkKey else
      if KeyComp('snd-sqrt') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func113: TtkTokenKind;
begin
  if KeyComp('quantize') then Result := tkKey else
    if KeyComp('snd-xform') then Result := tkKey else
      if KeyComp('extract-abs') then Result := tkKey else
        if KeyComp('snd-tonev') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func114: TtkTokenKind;
begin
  if KeyComp('macroexpand-1') then Result := tkKey else
    if KeyComp('macroexpand') then Result := tkKey else
      if KeyComp('snd-print') then Result := tkKey else
        if KeyComp('snd-partial') then Result := tkKey else
          if KeyComp('char-downcase') then Result := tkKey else
            if KeyComp('snd-atonev') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func115: TtkTokenKind;
begin
  if KeyComp('delete-if-not') then Result := tkKey else
    if KeyComp('stretch-abs') then Result := tkKey else
      if KeyComp('snd-flatten') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func116: TtkTokenKind;
begin
  if KeyComp('make-symbol') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func117: TtkTokenKind;
begin
  if KeyComp('lower-case-p') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func118: TtkTokenKind;
begin
  if KeyComp('write-int') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func119: TtkTokenKind;
begin
  if KeyComp('open-binary') then Result := tkKey else
    if KeyComp('symbol-name') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func120: TtkTokenKind;
begin
  if KeyComp('snd-follow') then Result := tkKey else
    if KeyComp('char-greaterp') then Result := tkKey else
      if KeyComp('upper-case-p') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func122: TtkTokenKind;
begin
  if KeyComp('eq-lowshelf') then Result := tkKey else
    if KeyComp('putprop') then Result := tkKey else
      if KeyComp('pwer-list') then Result := tkKey else
        if KeyComp('snd-samples') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func123: TtkTokenKind;
begin
  if KeyComp('snd-compose') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func124: TtkTokenKind;
begin
  if KeyComp('snd-maxsamp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func125: TtkTokenKind;
begin
  if KeyComp('sustain-abs') then Result := tkKey else
    if KeyComp('snd-extent') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func126: TtkTokenKind;
begin
  if KeyComp('snd-resample') then Result := tkKey else
    if KeyComp('pwev-list') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func127: TtkTokenKind;
begin
  if KeyComp('transpose') then Result := tkKey else
    if KeyComp('local-to-global') then Result := tkKey else
      if KeyComp('write-byte') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func129: TtkTokenKind;
begin
  if KeyComp('snd-inverse') then Result := tkKey else
    if KeyComp('pwlr-list') then Result := tkKey else
      if KeyComp('hz-to-step') then Result := tkKey else
        if KeyComp('write-float') then Result := tkKey else
          if KeyComp('build-harmonic') then Result := tkKey else
            if KeyComp('step-to-hz') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func130: TtkTokenKind;
begin
  if KeyComp('snd-alpasscv') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func131: TtkTokenKind;
begin
  if KeyComp('sound-warp') then Result := tkKey else
    if KeyComp('pwlvr-lis') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func133: TtkTokenKind;
begin
  if KeyComp('snd-resonvc') then Result := tkKey else
    if KeyComp('snd-resoncv') then Result := tkKey else
      if KeyComp('pwlv-list') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func134: TtkTokenKind;
begin
  if KeyComp('snd-aresoncv') then Result := tkKey else
    if KeyComp('get-duration') then Result := tkKey else
      if KeyComp('snd-aresonvc') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func135: TtkTokenKind;
begin
  if KeyComp('get-sustain') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func138: TtkTokenKind;
begin
  if KeyComp('soundfilename') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func140: TtkTokenKind;
begin
  if KeyComp('sref-inverse') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func141: TtkTokenKind;
begin
  if KeyComp('string-search') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func142: TtkTokenKind;
begin
  if KeyComp('remove-if-not') then Result := tkKey else
    if KeyComp('snd-fetch-array') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func144: TtkTokenKind;
begin
  if KeyComp('s-print-tree') then Result := tkKey else
    if KeyComp('snd-fromobject') then Result := tkKey else
      if KeyComp('autonorm-off') then Result := tkKey else
        if KeyComp('pwevr-list') then Result := tkKey else
          if KeyComp('autonorm-off') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func145: TtkTokenKind;
begin
  if KeyComp('snd-convolve') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func146: TtkTokenKind;
begin
  if KeyComp('autonorm-on') then Result := tkKey else
    if KeyComp('autonorm-on') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func147: TtkTokenKind;
begin
  if KeyComp('string-trim') then Result := tkKey else
    if KeyComp('symbol-value') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func148: TtkTokenKind;
begin
  if KeyComp('return-from') then Result := tkKey else
    if KeyComp('snd-resamplev') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func149: TtkTokenKind;
begin
  if KeyComp('transpose-abs') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func150: TtkTokenKind;
begin
  if KeyComp('char-not-lessp') then Result := tkKey else
    if KeyComp('snd-normalize') then Result := tkKey else
      if KeyComp('snd-quantize') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func151: TtkTokenKind;
begin
  if KeyComp('char-not-equalp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func152: TtkTokenKind;
begin
  if KeyComp('snd-resonvv') then Result := tkKey else
    if KeyComp('snd-from-array') then Result := tkKey else
      if KeyComp('snd-from-array') then Result := tkKey else
        if KeyComp('string-upcase') then Result := tkKey else
          if KeyComp('set-pitch-names') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func153: TtkTokenKind;
begin
  if KeyComp('snd-multiseq') then Result := tkKey else
    if KeyComp('snd-aresonvv') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func154: TtkTokenKind;
begin
  if KeyComp('snd-stop-time') then Result := tkKey else
    if KeyComp('s-overwrite') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func155: TtkTokenKind;
begin
  if KeyComp('control-warp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func158: TtkTokenKind;
begin
  if KeyComp('sound-srate-abs') then Result := tkKey else
    if KeyComp('string-lessp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func159: TtkTokenKind;
begin
  if KeyComp('string-equalp') then Result := tkKey else
    if KeyComp('get-transpose') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func162: TtkTokenKind;
begin
  if KeyComp('symbol-plist') then Result := tkKey else
    if KeyComp('snd-print-tree') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func164: TtkTokenKind;
begin
  if KeyComp('setup-console') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func166: TtkTokenKind;
begin
  if KeyComp('nstring-upcase') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func169: TtkTokenKind;
begin
  if KeyComp('char-not-greaterp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func171: TtkTokenKind;
begin
  if KeyComp('string-downcase') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func172: TtkTokenKind;
begin
  if KeyComp('snd-overwrite') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func173: TtkTokenKind;
begin
  if KeyComp('set-logical-stop') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func177: TtkTokenKind;
begin
  if KeyComp('string-greaterp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func180: TtkTokenKind;
begin
  if KeyComp('set-sound-srate') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func182: TtkTokenKind;
begin
  if KeyComp('control-srate-abs') then Result := tkKey else
    if KeyComp('unwind-protect') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func185: TtkTokenKind;
begin
  if KeyComp('nstring-downcase') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func188: TtkTokenKind;
begin
  if KeyComp('symbol-function') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func190: TtkTokenKind;
begin
  if KeyComp('string-left-trim') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func204: TtkTokenKind;
begin
  if KeyComp('set-control-srate') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func207: TtkTokenKind;
begin
  if KeyComp('string-not-lessp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func208: TtkTokenKind;
begin
  if KeyComp('string-not-equalp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func209: TtkTokenKind;
begin
  if KeyComp('string-right-trim') then Result := tkKey else
    if KeyComp('get-lambda-expression') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func210: TtkTokenKind;
begin
  if KeyComp('snd-set-logical-stop') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func226: TtkTokenKind;
begin
  if KeyComp('string-not-greaterp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func228: TtkTokenKind;
begin
  if KeyComp('snd-fromarraystream') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func247: TtkTokenKind;
begin
  if KeyComp('osc-pulsepulse-width') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func273: TtkTokenKind;
begin
  if KeyComp('make-string-input-stream') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func281: TtkTokenKind;
begin
  if KeyComp('get-output-stream-list') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func282: TtkTokenKind;
begin
  if KeyComp('continuous-sound-warp') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func306: TtkTokenKind;
begin
  if KeyComp('continuous-control-warp') then Result := tkKey else
    if KeyComp('make-string-output-stream') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.Func308: TtkTokenKind;
begin
  if KeyComp('get-output-stream-string') then Result := tkKey else Result := tkIdentifier;
end;

function TSynNyquistSyn.AltFunc: TtkTokenKind;
begin
  Result := tkIdentifier;
end;

function TSynNyquistSyn.IdentKind(MayBe: PChar): TtkTokenKind;
var
  HashKey: Integer;
begin
  fToIdent := MayBe;
  HashKey := KeyHash(MayBe);
  if HashKey <= MaxKey then
    Result := fIdentFuncTable[HashKey]
  else
    Result := tkIdentifier;
end;

procedure TSynNyquistSyn.MakeMethodTables;
var
  I: Char;
begin
  for I := #0 to #255 do
    case I of
      #0: fProcTable[I] := NullProc;
      #10: fProcTable[I] := LFProc;
      #13: fProcTable[I] := CRProc;
      '"': fProcTable[I] := StringOpenProc;
      #1..#9,
      #11,
      #12,
      #14..#32 : fProcTable[I] := SpaceProc;
      '+','-': fProcTable[I] := Add_MinusProc;
      ',': fProcTable[I] := CommaProc;
      '.': fProcTable[I] := DotProc;
      #33, #36..#38, #42, #47, #60..#95, #97..#126: fProcTable[I] := IdentProc;
      '0','2'..'9': fProcTable[I] := NumberProc;
      '1': fProcTable[I] := OneProc;
      ':': fProcTable[I] := ParameterProc;
      '#': fProcTable[I] := PoundProc;
      #39,'`': fProcTable[I] := QuoteProc;
      ')': fProcTable[I] := RoundCloseProc;
      '(': fProcTable[I] := RoundOpenProc;
      ';': fProcTable[I] := SemiColonProc;
    else
      fProcTable[I] := UnknownProc;
    end;
end;

procedure TSynNyquistSyn.SpaceProc;
begin
  fTokenID := tkSpace;
  repeat
    inc(Run);
  until not (fLine[Run] in [#1..#32]);
end;

procedure TSynNyquistSyn.NullProc;
begin
  fTokenID := tkNull;
end;

procedure TSynNyquistSyn.CRProc;
begin
  fTokenID := tkSpace;
  inc(Run);
  if fLine[Run] = #10 then
    inc(Run);
end;

procedure TSynNyquistSyn.LFProc;
begin
  fTokenID := tkSpace;
  inc(Run);
end;

procedure TSynNyquistSyn.XLispCommentProc;
begin
  case fLine[Run] of
     #0: NullProc;
    #10: LFProc;
    #13: CRProc;
  else
    begin
      fTokenID := tkComment;
      repeat
        if (fLine[Run] = '|') and
           (fLine[Run + 1] = '#') then
        begin
          Inc(Run, 2);
          fRange := rsUnKnown;
          Break;
        end;
        if not (fLine[Run] in [#0, #10, #13]) then
          Inc(Run);
      until fLine[Run] in [#0, #10, #13];
    end;
  end;
end;

procedure TSynNyquistSyn.StringOpenProc;
begin
  Inc(Run);
  fRange := rsString;
  StringProc;
  fTokenID := tkString;
end;

procedure TSynNyquistSyn.StringProc;
begin
  case fLine[Run] of
     #0: NullProc;
    #10: LFProc;
    #13: CRProc;
  else
    begin
      fTokenID := tkString;
      repeat
        if (fLine[Run] = '"') then
        begin
          Inc(Run, 1);
          fRange := rsUnKnown;
          Break;
        end;
        if not (fLine[Run] in [#0, #10, #13]) then
          Inc(Run);
      until fLine[Run] in [#0, #10, #13];
    end;
  end;
end;

constructor TSynNyquistSyn.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fCommentAttri := TSynHighLighterAttributes.Create(SYNS_AttrComment);
  fCommentAttri.Style := [fsItalic];
  fCommentAttri.Foreground := clNavy;
  AddAttribute(fCommentAttri);

  fIdentifierAttri := TSynHighLighterAttributes.Create(SYNS_AttrIdentifier);
  AddAttribute(fIdentifierAttri);

  fInvalidSymbolAttri := TSynHighLighterAttributes.Create(SYNS_AttrInvalidSymbol);
  AddAttribute(fInvalidSymbolAttri);

  fKeyAttri := TSynHighLighterAttributes.Create(SYNS_AttrReservedWord);
  fKeyAttri.Style := [fsBold];
  fKeyAttri.Foreground := clBlue;
  AddAttribute(fKeyAttri);

  fMacroAttri := TSynHighLighterAttributes.Create(SYNS_AttrMacro);
  AddAttribute(fMacroAttri);

  fNumberAttri := TSynHighLighterAttributes.Create(SYNS_AttrNumber);
  AddAttribute(fNumberAttri);

  fParameterAttri := TSynHighLighterAttributes.Create(SYNS_AttrParameter);
  AddAttribute(fParameterAttri);

  fSpaceAttri := TSynHighLighterAttributes.Create(SYNS_AttrSpace);
  AddAttribute(fSpaceAttri);

  fStringAttri := TSynHighLighterAttributes.Create(SYNS_AttrString);
  AddAttribute(fStringAttri);

  fSymbolAttri := TSynHighLighterAttributes.Create(SYNS_AttrSymbol);
  AddAttribute(fSymbolAttri);

  SetAttributesOnChange(DefHighlightChange);
  InitIdent;
  MakeMethodTables;
  fDefaultFilter := SYNS_FilterNyquist;
  fRange := rsUnknown;
end;

procedure TSynNyquistSyn.SetLine(NewValue: String; LineNumber: Integer);
begin
  fLine := PChar(NewValue);
  Run := 0;
  fLineNumber := LineNumber;
  Next;
end;

procedure TSynNyquistSyn.Add_MinusProc;
begin
  inc(Run);
  case fLine[Run] of 
  #0..#32, '(': fTokenID := tkKey;
  '0'..'9'    : NumberProc; 
  '.'	      : DotProc;
  #33, #35..#38, #42, #43, #45, #47, #58, #60..#95, #97..#126: IdentProc;      
  else fTokenID := tkInvalidSymbol;
  end;
end;

procedure TSynNyquistSyn.CommaProc;
begin
  inc(Run);
  case fLine[Run] of
  '@':begin
  	inc(Run);
  	fTokenID := tkMacro;
      end;  
  else fTokenID := tkMacro;
  end;
end;

procedure TSynNyquistSyn.DotProc;
var bEFlag, bSymFlag: Boolean;
begin
  inc(Run);
  fTokenID := tkIdentifier;
  if fLine[Run] in ['0'..'9'] then bEFlag := true
  else bEFlag := false;
  bSymFlag := false;
  while (fLine[Run] in ['0'..'9']) or ((fLine[Run] in ['e', 'E']) and bEFlag) or ((fLine[Run] in ['+', '-']) and bSymFlag) do
  begin
    case fLine[Run] of
      'E', 'e': begin
                  bEFlag := false;
       		  bSymFlag := true;
                end;  
      else bSymFlag := false;
    end;
    inc(Run);
    fTokenID := tkNumber;
  end;
  if not(fLine[Run] in [#0..#32, '"', #39, '(', ')', ',', ';', '`']) then IdentProc;
end;

procedure TSynNyquistSyn.IdentProc;
begin
  fTokenID := IdentKind((fLine + Run));
  inc(Run, fStringLen);
  while Identifiers[fLine[Run]] do
  	Inc(Run);
end;

procedure TSynNyquistSyn.NumberProc;
var bPtFlag, bEFlag, bSymflag: Boolean;
begin
  // inc(Run);
  fTokenID := tkNumber;
  bPtFlag := true;
  bEFlag := true;
  bSymFlag := false;
  while (fLine[Run] in ['0'..'9']) or ((fLine[Run] in ['e', 'E']) and bEFlag) 
    or ((fLine[Run] = '.') and bPtFlag) or ((fLine[Run] in ['+', '-']) and bSymFlag) do
  begin
    case fLine[Run] of
      'E', 'e': begin
                  bEFlag := false;
      	          bPtFlag := false;
      		  bSymFlag := true;
                end;
      '.': begin
             bPtFlag := false;
             bSymFlag := false;
           end;
      else bSymFlag := false;
    end;
    inc(Run);
  end;
  if not(fLine[Run] in [#0..#32, '"', #39, '(', ')', ',', ';', '`']) then IdentProc;
end;

procedure TSynNyquistSyn.OneProc;
begin
  inc(Run);  
  case fLine[Run] of
  '+','-': begin
             inc(Run);
             case fLine[Run] of 
  	     #0..#32, '(': fTokenID := tkKey;
             #33, #35..#38, #42, #43, #45..#58, #60..#95, #97..#126: IdentProc;      
             else fTokenID := tkInvalidSymbol;
             end;
           end;  
  #0..#32, '(', ')': fTokenID := tkNumber;
  '0'..'9', '.'    : NumberProc; 
  #33, #35..#38, #42, #47, #58, #60..#95, #97..#126: IdentProc;      
  else fTokenID := tkInvalidSymbol;
  end;
end;

procedure TSynNyquistSyn.ParameterProc;
begin
  fTokenID := tkParameter;
  repeat
    inc(Run);
  until fLine[Run] in [#0..#32, '"', #39, '(', ')', ',', ';', '`'];  
end;

procedure TSynNyquistSyn.PoundProc;
begin
  inc(Run);
  case fLine[Run] of
   #0..#32, '(', #39: fTokenID := tkMacro;
   'x', 'X': 
     begin
       inc(Run);
       fTokenID := tkNumber;
       while fLine[Run] in ['0'..'9', 'A'..'F'] do inc (Run);
     end;     
   'o', 'O':
     begin
       inc(Run);
       fTokenID := tkNumber;
       while fLine[Run] in ['0'..'7'] do inc (Run);
     end;    
   'b', 'B': 
     begin
       inc(Run);
       fTokenID := tkNumber;
       while fLine[Run] in ['0', '1'] do inc (Run);
     end;    
   '\':
     begin
       inc(Run);
       fTokenID := tkString;
       if fLine[Run] <> #0 then inc(Run);
     end;
   '|':
     begin
       fRange := rsXLispComment;
       XLispCommentProc;
       fTokenID := tkComment;
     end;  
   else fTokenID := tkInvalidSymbol;  
  end;          
end;

procedure TSynNyquistSyn.QuoteProc;
begin
  inc(Run);
  fTokenID := tkMacro;
  // if fLine[Run] in [#0..#32, '('] then fTokenID := tkMacro
  // else fTokenID := tkInvalidSymbol;  
end;

procedure TSynNyquistSyn.RoundCloseProc;
begin
  inc(Run);
  fTokenID := tkSymbol;
end;

procedure TSynNyquistSyn.RoundOpenProc;
begin
  inc(Run);
  fTokenID := tkSymbol;
end;

procedure TSynNyquistSyn.SemiColonProc;
begin
  repeat
    inc(Run);
  until fLine[Run] in [#0, #10, #13];
  fTokenID := tkComment;
end;

procedure TSynNyquistSyn.UnknownProc;
begin
{$IFDEF SYN_MBCSSUPPORT}
  if FLine[Run] in LeadBytes then
    Inc(Run,2)
  else
{$ENDIF}
  inc(Run);
  fTokenID := tkUnknown;
end;

procedure TSynNyquistSyn.Next;
begin
  fTokenPos := Run;
  case fRange of
    rsXLispComment: XLispCommentProc;
    rsString: StringProc;
  else
    begin
      fRange := rsUnknown;
      fProcTable[fLine[Run]];
    end;
  end;
end;

function TSynNyquistSyn.GetDefaultAttribute(Index: integer): TSynHighLighterAttributes;
begin
  case Index of
    SYN_ATTR_COMMENT    : Result := fCommentAttri;
    SYN_ATTR_IDENTIFIER : Result := fIdentifierAttri;
    SYN_ATTR_KEYWORD    : Result := fKeyAttri;
    SYN_ATTR_STRING     : Result := fStringAttri;
    SYN_ATTR_WHITESPACE : Result := fSpaceAttri;
    SYN_ATTR_SYMBOL     : Result := fSymbolAttri;
  else
    Result := nil;
  end;
end;

function TSynNyquistSyn.GetEol: Boolean;
begin
  Result := fTokenID = tkNull;
end;

function TSynNyquistSyn.GetKeyWords: string;
begin
  Result := 
    '*,/,/=,<,<=,=,>,>=,abs,abs-env,address-of,alloc,allpass2,alpass,amosc' +
    ',and,append,apply,aref,areson,arrayp,assoc,at,at-abs,atom,atone,autono' +
    'rm-off,autonorm-on,backquote,baktrace,bandpass2,biquad,biquad-m,block,' +
    'both-case-p,boundp,break,build-harmonic,buzz,caaaar,caaadr,caaar,caada' +
    'r,caaddr,caadr,caar,cadaar,cadadr,cadar,caddar,caddr,cadr,car,case,cat' +
    'ch,cdaaar,cdaadr,cdaar,cdadar,cdaddr,cdadr,cdar,cddaar,cddadr,cddar,cd' +
    'ddar,cddddr,cdddr,cddr,cdr,cerror,char,char/=,char<,char<=,char=,char>' +
    ',char>=,characterp,char-code,char-downcase,char-equalp,char-greaterp,c' +
    'har-int,char-lessp,char-not-equalp,char-not-greaterp,char-not-lessp,ch' +
    'ar-upcase,clean-up,clip,close,code-char,comb,cond,congen,cons,consp,co' +
    'nst,continue,continuous-control-warp,continuous-sound-warp,control,con' +
    'trol-srate-abs,control-warp,convolve,cue,cue-file,db-to-linear,defmacr' +
    'o,defun,delete,delete-if,delete-if-not,diff,digit-char,digit-char-p,do' +
    ',do*,dolist,dotimes,dribble,endp,env,eq,eq-band,eq-highshelf,eql,eq-lo' +
    'wshelf,equal,error,errset,eval,evalhook,evenp,exit,exp,expand,exp-dec,' +
    'expt,extract,extract-abs,fboundp,feedback-delay,first,flatc,flatsize,f' +
    'let,float,floatp,fmosc,force-srate,format,fourth,funcall,function,gc,g' +
    'cd,gensym,get,get-duration,get-lambda-expression,get-loud,get-output-s' +
    'tream-list,get-output-stream-string,get-sustain,get-transpose,get-warp' +
    ',go,hash,highpass2,highpass4,highpass6,highpass8,hp,hzosc,hz-to-step,i' +
    'f,int-char,integerp,integrate,intern,labels,lambda,last,length,let,let' +
    '*,lfo,linear-to-db,list,listp,load,local-to-global,log,logand,logior,l' +
    'ognot,logxor,loop,loud,loud-abs,lower-case-p,lowpass2,lowpass4,lowpass' +
    '6,lowpass8,lp,macroexpand,macroexpand-1,macrolet,make-array,make-strin' +
    'g-input-stream,make-string-output-stream,make-symbol,maketable,mapc,ma' +
    'pcar,mapl,maplist,max,member,min,minusp,mult,nconc,noise,not,notch2,ns' +
    'tring-downcase,nstring-upcase,nth,nthcdr,null,numberp,objectp,oddp,ope' +
    'n,open-binary,or,osc,osc-note,osc-pulse,osc-pulsepulse-width,osc-saw,o' +
    'sc-tri,pan,partial,peak,peek,peek-char,play,pluck,plusp,poke,pprint,pr' +
    'in1,princ,print,prod,profile,prog,prog*,prog1,prog2,progn,progv,psetq,' +
    'putprop,pwe,pwe-list,pwer,pwer-list,pwev,pwev-list,pwevr,pwevr-list,pw' +
    'l,pwl-list,pwlr,pwlr-list,pwlv,pwlv-list,pwlvr,pwlvr-lis,quantize,quot' +
    'e,ramp,random,read,read-byte,read-char,read-float,read-int,read-line,r' +
    'ecip,rem,remove,remove-if,remove-if-not,remprop,resample,reson,rest,re' +
    'store,return,return-from,reverse,rms,room,rplaca,rplacd,s-abs,s-add-to' +
    ',sampler,save,scale,scale-db,scale-srate,second,seq,seqrep,set,set-con' +
    'trol-srate,setf,set-logical-stop,set-pitch-names,setq,set-sound-srate,' +
    'setup-console,s-exp,sf-info,shape,shift-time,sim,simrep,sin,sine,siosc' +
    ',s-log,slope,s-max,s-min,snd-abs,snd-add,snd-alpass,snd-alpasscv,snd-a' +
    'mosc,snd-areson,snd-aresoncv,snd-aresonvc,snd-aresonvv,snd-atone,snd-a' +
    'tonev,snd-avg,snd-biquad,snd-chase,snd-clip,snd-compose,snd-congen,snd' +
    '-const,snd-convolve,snd-copy,snd-coterm,snd-delay,snd-delaycv,snd-down' +
    ',snd-exp,snd-extent,snd-fetch,snd-fetch-array,snd-flatten,snd-fmosc,sn' +
    'd-follow,snd-from-array,snd-fromarraystream,snd-fromobject,snd-gate,sn' +
    'd-inverse,snd-length,snd-log,snd-max,snd-maxsamp,snd-maxv,snd-multiseq' +
    ',snd-normalize,snd-osc,snd-overwrite,snd-partial,snd-play,snd-print,sn' +
    'd-print-tree,snd-prod,snd-pwl,snd-quantize,snd-read,snd-recip,snd-resa' +
    'mple,snd-resamplev,snd-reson,snd-resoncv,snd-resonvc,snd-resonvv,snd-s' +
    'amples,snd-save,snd-scale,snd-seq,snd-set-logical-stop,snd-shape,snd-s' +
    'ine,snd-siosc,snd-sqrt,snd-srate,snd-sref,snd-stop-time,snd-t0,snd-tap' +
    'v,snd-time,snd-tone,snd-tonev,snd-up,snd-white,snd-xform,snd-zero,sort' +
    ',sound,soundfilename,sound-off,sound-on,soundp,sound-srate-abs,sound-w' +
    'arp,s-overwrite,s-plot,s-print-tree,sqrt,sref,sref-inverse,s-save,s-sq' +
    'rt,stats,step-to-hz,strcat,streamp,stretch,stretch-abs,string,string/=' +
    ',string<,string<=,string=,string>,string>=,string-downcase,string-equa' +
    'lp,string-greaterp,string-left-trim,string-lessp,string-not-equalp,str' +
    'ing-not-greaterp,string-not-lessp,stringp,string-right-trim,string-sea' +
    'rch,string-trim,string-upcase,sublis,subseq,subst,sum,sustain,sustain-' +
    'abs,symbol-function,symbol-name,symbolp,symbol-plist,symbol-value,tagb' +
    'ody,tan,terpri,third,throw,timed-seq,tone,top-level,trace,transpose,tr' +
    'anspose-abs,truncate,type-of,unless,untrace,unwind-protect,upper-case-' +
    'p,vector,warp,warp-abs,when,write-byte,write-char,write-float,write-in' +
    't,zerop';
end;

function TSynNyquistSyn.GetToken: String;
var
  Len: LongInt;
begin
  Len := Run - fTokenPos;
  SetString(Result, (FLine + fTokenPos), Len);
end;

function TSynNyquistSyn.GetTokenID: TtkTokenKind;
begin
  Result := fTokenId;
end;

function TSynNyquistSyn.GetTokenAttribute: TSynHighLighterAttributes;
begin
  case GetTokenID of
    tkComment: Result := fCommentAttri;
    tkIdentifier: Result := fIdentifierAttri;
    tkInvalidSymbol: Result := fInvalidSymbolAttri;
    tkKey: Result := fKeyAttri;
    tkMacro: Result := fMacroAttri;
    tkNumber: Result := fNumberAttri;
    tkParameter: Result := fParameterAttri;
    tkSpace: Result := fSpaceAttri;
    tkString: Result := fStringAttri;
    tkSymbol: Result := fSymbolAttri;
    tkUnknown: Result := fIdentifierAttri;
  else
    Result := nil;
  end;
end;

function TSynNyquistSyn.GetTokenKind: integer;
begin
  Result := Ord(fTokenId);
end;

function TSynNyquistSyn.GetTokenPos: Integer;
begin
  Result := fTokenPos;
end;

function TSynNyquistSyn.GetIdentChars: TSynIdentChars;
begin
  Result := [#33, #35..#38, #42, #43, #45..#58, #60..#95, #97..#126];
end;

function TSynNyquistSyn.GetSampleSource: string;
begin
  Result := 'Sample source for: '#13#10 +
            'Nyquist Syntax Parser/Highlighter';
end;

function TSynNyquistSyn.IsFilterStored: Boolean;
begin
  Result := fDefaultFilter <> SYNS_FilterNyquist;
end;

{$IFNDEF SYN_CPPB_1} class {$ENDIF}
function TSynNyquistSyn.GetLanguageName: string;
begin
  Result := SYNS_LangNyquist;
end;

procedure TSynNyquistSyn.ResetRange;
begin
  fRange := rsUnknown;
end;

procedure TSynNyquistSyn.SetRange(Value: Pointer);
begin
  fRange := TRangeState(Value);
end;

function TSynNyquistSyn.GetRange: Pointer;
begin
  Result := Pointer(fRange);
end;

initialization
  MakeIdentTable;
{$IFNDEF SYN_CPPB_1}
  RegisterPlaceableHighlighter(TSynNyquistSyn);
{$ENDIF}
end.
