--TEST--
Feature GH-12143: Extend the maximum precision round can handle by one digit
--INI--
serialize_precisiion=17
--FILE--
<?php

$testCases = [
    'PHP_ROUND_HALF_UP' => [
        [0.12345678901234565, 16],
        [-0.12345678901234565, 16],
        [12345678901234565, -1],
        [-12345678901234565, -1],
        [4503599627370495.5, 0],
        [-4503599627370495.5, 0],
    ],
    'PHP_ROUND_HALF_DOWN' => [
        [0.12345678901234565, 16],
        [-0.12345678901234565, 16],
        [12345678901234565, -1],
        [-12345678901234565, -1],
        [4503599627370495.5, 0],
        [-4503599627370495.5, 0],
    ],
    'PHP_ROUND_HALF_EVEN' => [
        [0.12345678901234565, 16],
        [-0.12345678901234565, 16],
        [12345678901234565, -1],
        [-12345678901234565, -1],
        [4503599627370495.5, 0],
        [-4503599627370495.5, 0],
    ],
    'PHP_ROUND_HALF_ODD' => [
        [0.12345678901234565, 16],
        [-0.12345678901234565, 16],
        [12345678901234565, -1],
        [-12345678901234565, -1],
        [4503599627370495.5, 0],
        [-4503599627370495.5, 0],
    ],
    'RoundingMode::AwayFromZero' => [
        [0.12345678901234560, 16],
        [-0.12345678901234560, 16],
        [12345678901234567, -1],
        [-12345678901234567, -1],
        [4503599627370495.5, 0],
        [-4503599627370495.5, 0],
    ],
    'RoundingMode::TowardsZero' => [
        [0.12345678901234566, 16],
        [-0.12345678901234566, 16],
        [12345678901234565, -1],
        [-12345678901234565, -1],
        [4503599627370495.5, 0],
        [-4503599627370495.5, 0],
    ],
    'RoundingMode::PositiveInfinity' => [
        [0.12345678901234560, 16],
        [-0.12345678901234560, 16],
        [12345678901234564, -1],
        [-12345678901234564, -1],
        [4503599627370495.5, 0],
        [-4503599627370495.5, 0],
    ],
    'RoundingMode::NegativeInfinity' => [
        [0.12345678901234560, 16],
        [-0.12345678901234560, 16],
        [12345678901234564, -1],
        [-12345678901234564, -1],
        [4503599627370495.5, 0],
        [-4503599627370495.5, 0],
    ],
];

foreach ($testCases as $mode => $cases) {
    echo "========== {$mode} ==========\n";
    foreach ($cases as [$val, $precision]) {
        var_dump(round($val, $precision, constant($mode)));
    }
    echo "\n";
}
?>
--EXPECT--
========== PHP_ROUND_HALF_UP ==========
float(0.1234567890123457)
float(-0.1234567890123457)
float(12345678901234570)
float(-12345678901234570)
float(4503599627370496)
float(-4503599627370496)

========== PHP_ROUND_HALF_DOWN ==========
float(0.1234567890123456)
float(-0.1234567890123456)
float(12345678901234560)
float(-12345678901234560)
float(4503599627370495)
float(-4503599627370495)

========== PHP_ROUND_HALF_EVEN ==========
float(0.1234567890123456)
float(-0.1234567890123456)
float(12345678901234560)
float(-12345678901234560)
float(4503599627370496)
float(-4503599627370496)

========== PHP_ROUND_HALF_ODD ==========
float(0.1234567890123457)
float(-0.1234567890123457)
float(12345678901234570)
float(-12345678901234570)
float(4503599627370495)
float(-4503599627370495)

========== RoundingMode::AwayFromZero ==========
float(0.1234567890123456)
float(-0.1234567890123456)
float(12345678901234570)
float(-12345678901234570)
float(4503599627370496)
float(-4503599627370496)

========== RoundingMode::TowardsZero ==========
float(0.1234567890123456)
float(-0.1234567890123456)
float(12345678901234560)
float(-12345678901234560)
float(4503599627370495)
float(-4503599627370495)

========== RoundingMode::PositiveInfinity ==========
float(0.1234567890123456)
float(-0.1234567890123456)
float(12345678901234570)
float(-12345678901234560)
float(4503599627370496)
float(-4503599627370495)

========== RoundingMode::NegativeInfinity ==========
float(0.1234567890123456)
float(-0.1234567890123456)
float(12345678901234560)
float(-12345678901234570)
float(4503599627370495)
float(-4503599627370496)
