# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Action(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action of virtual network rule."""

    ALLOW = "Allow"


class DefaultAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The default action of allow or deny when no other rules match."""

    ALLOW = "Allow"
    DENY = "Deny"


class ImportMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """When Force, any existing target tags will be overwritten. When NoForce, any existing target
    tags will fail the operation before any copying begins.
    """

    NO_FORCE = "NoForce"
    FORCE = "Force"


class PasswordName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The password name."""

    PASSWORD = "password"
    PASSWORD2 = "password2"


class PolicyStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The value that indicates whether the policy is enabled or not."""

    ENABLED = "enabled"
    DISABLED = "disabled"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the container registry at the time the operation was called."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"


class RegistryUsageUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The unit of measurement."""

    COUNT = "Count"
    BYTES = "Bytes"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SKU name of the container registry. Required for registry creation."""

    CLASSIC = "Classic"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SKU tier based on the SKU name."""

    CLASSIC = "Classic"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class TrustPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of trust policy."""

    NOTARY = "Notary"


class WebhookAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WebhookAction."""

    PUSH = "push"
    DELETE = "delete"
    QUARANTINE = "quarantine"
    CHART_PUSH = "chart_push"
    CHART_DELETE = "chart_delete"


class WebhookStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the webhook at the time the operation was called."""

    ENABLED = "enabled"
    DISABLED = "disabled"
