# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, AsyncIterable, AsyncIterator, Callable, Dict, IO, Optional, Type, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ...operations._cloud_hsm_clusters_operations import (
    build_backup_request,
    build_create_or_update_request,
    build_delete_request,
    build_get_request,
    build_list_by_resource_group_request,
    build_list_by_subscription_request,
    build_restore_request,
    build_update_request,
    build_validate_backup_properties_request,
    build_validate_restore_properties_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class CloudHsmClustersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.hardwaresecuritymodules.aio.HardwareSecurityModulesMgmtClient`'s
        :attr:`cloud_hsm_clusters` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional[_models.ManagedServiceIdentity] = None,
        sku: Optional[_models.CloudHsmClusterSku] = None,
        properties: Optional[_models.CloudHsmClusterProperties] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _body = _models.CloudHsmCluster(identity=identity, location=location, properties=properties, sku=sku, tags=tags)
        _json = self._serialize.body(_body, "CloudHsmCluster")

        _request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            cloud_hsm_cluster_name=cloud_hsm_cluster_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional[_models.ManagedServiceIdentity] = None,
        sku: Optional[_models.CloudHsmClusterSku] = None,
        properties: Optional[_models.CloudHsmClusterProperties] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.CloudHsmCluster]:
        """Create or Update a Cloud HSM Cluster in the specified subscription.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param location: The geo-location where the resource lives. Required.
        :type location: str
        :param tags: Resource tags. Default value is None.
        :type tags: dict[str, str]
        :param identity: Managed service identity (system assigned and/or user assigned identities).
         Default value is None.
        :type identity: ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentity
        :param sku: SKU details. Default value is None.
        :type sku: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSku
        :param properties: Properties of the Cloud HSM Cluster. Default value is None.
        :type properties: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterProperties
        :return: An instance of AsyncLROPoller that returns either CloudHsmCluster or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.CloudHsmCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))
        cls: ClsType[_models.CloudHsmCluster] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                cloud_hsm_cluster_name=cloud_hsm_cluster_name,
                location=location,
                tags=tags,
                identity=identity,
                sku=sku,
                properties=properties,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("CloudHsmCluster", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncARMPolling(lro_delay, lro_options={"final-state-via": "original-uri"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.CloudHsmCluster].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.CloudHsmCluster](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_initial(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional[_models.ManagedServiceIdentity] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _body = _models.CloudHsmClusterPatchParameters(identity=identity, tags=tags)
        _json = self._serialize.body(_body, "CloudHsmClusterPatchParameters")

        _request = build_update_request(
            resource_group_name=resource_group_name,
            cloud_hsm_cluster_name=cloud_hsm_cluster_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_update(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional[_models.ManagedServiceIdentity] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.CloudHsmCluster]:
        """Update a Cloud HSM Cluster in the specified subscription.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param tags: The Cloud HSM Cluster's tags. Default value is None.
        :type tags: dict[str, str]
        :param identity: Managed service identity (system assigned and/or user assigned identities).
         Default value is None.
        :type identity: ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentity
        :return: An instance of AsyncLROPoller that returns either CloudHsmCluster or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.CloudHsmCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))
        cls: ClsType[_models.CloudHsmCluster] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_initial(
                resource_group_name=resource_group_name,
                cloud_hsm_cluster_name=cloud_hsm_cluster_name,
                tags=tags,
                identity=identity,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("CloudHsmCluster", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.CloudHsmCluster].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.CloudHsmCluster](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, cloud_hsm_cluster_name: str, **kwargs: Any
    ) -> _models.CloudHsmCluster:
        """Gets the specified Cloud HSM Cluster.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :return: CloudHsmCluster or the result of cls(response)
        :rtype: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmCluster
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.CloudHsmCluster] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_group_name=resource_group_name,
            cloud_hsm_cluster_name=cloud_hsm_cluster_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CloudHsmCluster", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(
        self, resource_group_name: str, cloud_hsm_cluster_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_delete_request(
            resource_group_name=resource_group_name,
            cloud_hsm_cluster_name=cloud_hsm_cluster_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, cloud_hsm_cluster_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified Cloud HSM Cluster.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                resource_group_name=resource_group_name,
                cloud_hsm_cluster_name=cloud_hsm_cluster_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, skiptoken: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.CloudHsmCluster"]:
        """The List operation gets information about the Cloud HSM Clusters associated with the
        subscription and within the specified resource group.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param skiptoken: The page-continuation token to use with a paged version of this API. Default
         value is None.
        :type skiptoken: str
        :return: An iterator like instance of either CloudHsmCluster or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.hardwaresecuritymodules.models.CloudHsmCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.CloudHsmClusterListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    skiptoken=skiptoken,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CloudHsmClusterListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_subscription(
        self, skiptoken: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.CloudHsmCluster"]:
        """The List operation gets information about the Cloud HSM Clusters associated with the
        subscription.

        :param skiptoken: The page-continuation token to use with a paged version of this API. Default
         value is None.
        :type skiptoken: str
        :return: An iterator like instance of either CloudHsmCluster or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.hardwaresecuritymodules.models.CloudHsmCluster]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.CloudHsmClusterListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    skiptoken=skiptoken,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CloudHsmClusterListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _validate_backup_properties_initial(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        backup_request_properties: Optional[Union[_models.BackupRequestProperties, IO[bytes]]] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(backup_request_properties, (IOBase, bytes)):
            _content = backup_request_properties
        else:
            if backup_request_properties is not None:
                _json = self._serialize.body(backup_request_properties, "BackupRequestProperties")
            else:
                _json = None

        _request = build_validate_backup_properties_request(
            resource_group_name=resource_group_name,
            cloud_hsm_cluster_name=cloud_hsm_cluster_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        if response.status_code == 202:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_validate_backup_properties(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        backup_request_properties: Optional[_models.BackupRequestProperties] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.BackupResult]:
        """Pre Backup operation to validate whether the customer can perform a backup on the Cloud HSM
        Cluster resource in the specified subscription.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param backup_request_properties: Backup Operation Required properties. Default value is None.
        :type backup_request_properties:
         ~azure.mgmt.hardwaresecuritymodules.models.BackupRequestProperties
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either BackupResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.BackupResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_validate_backup_properties(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        backup_request_properties: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.BackupResult]:
        """Pre Backup operation to validate whether the customer can perform a backup on the Cloud HSM
        Cluster resource in the specified subscription.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param backup_request_properties: Backup Operation Required properties. Default value is None.
        :type backup_request_properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either BackupResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.BackupResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_validate_backup_properties(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        backup_request_properties: Optional[Union[_models.BackupRequestProperties, IO[bytes]]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.BackupResult]:
        """Pre Backup operation to validate whether the customer can perform a backup on the Cloud HSM
        Cluster resource in the specified subscription.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param backup_request_properties: Backup Operation Required properties. Is either a
         BackupRequestProperties type or a IO[bytes] type. Default value is None.
        :type backup_request_properties:
         ~azure.mgmt.hardwaresecuritymodules.models.BackupRequestProperties or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either BackupResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.BackupResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._validate_backup_properties_initial(
                resource_group_name=resource_group_name,
                cloud_hsm_cluster_name=cloud_hsm_cluster_name,
                backup_request_properties=backup_request_properties,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

            deserialized = self._deserialize("BackupResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncARMPolling(lro_delay, lro_options={"final-state-via": "azure-async-operation"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.BackupResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.BackupResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _backup_initial(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        backup_request_properties: Optional[Union[_models.BackupRequestProperties, IO[bytes]]] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(backup_request_properties, (IOBase, bytes)):
            _content = backup_request_properties
        else:
            if backup_request_properties is not None:
                _json = self._serialize.body(backup_request_properties, "BackupRequestProperties")
            else:
                _json = None

        _request = build_backup_request(
            resource_group_name=resource_group_name,
            cloud_hsm_cluster_name=cloud_hsm_cluster_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        if response.status_code == 202:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_backup(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        backup_request_properties: Optional[_models.BackupRequestProperties] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.BackupResult]:
        """Create a backup of the Cloud HSM Cluster in the specified subscription.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param backup_request_properties: Azure storage Resource Uri. Default value is None.
        :type backup_request_properties:
         ~azure.mgmt.hardwaresecuritymodules.models.BackupRequestProperties
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either BackupResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.BackupResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_backup(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        backup_request_properties: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.BackupResult]:
        """Create a backup of the Cloud HSM Cluster in the specified subscription.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param backup_request_properties: Azure storage Resource Uri. Default value is None.
        :type backup_request_properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either BackupResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.BackupResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_backup(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        backup_request_properties: Optional[Union[_models.BackupRequestProperties, IO[bytes]]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.BackupResult]:
        """Create a backup of the Cloud HSM Cluster in the specified subscription.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param backup_request_properties: Azure storage Resource Uri. Is either a
         BackupRequestProperties type or a IO[bytes] type. Default value is None.
        :type backup_request_properties:
         ~azure.mgmt.hardwaresecuritymodules.models.BackupRequestProperties or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either BackupResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.BackupResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._backup_initial(
                resource_group_name=resource_group_name,
                cloud_hsm_cluster_name=cloud_hsm_cluster_name,
                backup_request_properties=backup_request_properties,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

            deserialized = self._deserialize("BackupResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncARMPolling(lro_delay, lro_options={"final-state-via": "azure-async-operation"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.BackupResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.BackupResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _validate_restore_properties_initial(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        restore_request_properties: Optional[Union[_models.RestoreRequestProperties, IO[bytes]]] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(restore_request_properties, (IOBase, bytes)):
            _content = restore_request_properties
        else:
            if restore_request_properties is not None:
                _json = self._serialize.body(restore_request_properties, "RestoreRequestProperties")
            else:
                _json = None

        _request = build_validate_restore_properties_request(
            resource_group_name=resource_group_name,
            cloud_hsm_cluster_name=cloud_hsm_cluster_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        if response.status_code == 202:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_validate_restore_properties(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        restore_request_properties: Optional[_models.RestoreRequestProperties] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreResult]:
        """Queued validating pre restore operation.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param restore_request_properties: Optional Parameters to validate prior performing a restore
         operation. Default value is None.
        :type restore_request_properties:
         ~azure.mgmt.hardwaresecuritymodules.models.RestoreRequestProperties
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RestoreResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.RestoreResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_validate_restore_properties(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        restore_request_properties: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreResult]:
        """Queued validating pre restore operation.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param restore_request_properties: Optional Parameters to validate prior performing a restore
         operation. Default value is None.
        :type restore_request_properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RestoreResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.RestoreResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_validate_restore_properties(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        restore_request_properties: Optional[Union[_models.RestoreRequestProperties, IO[bytes]]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreResult]:
        """Queued validating pre restore operation.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param restore_request_properties: Optional Parameters to validate prior performing a restore
         operation. Is either a RestoreRequestProperties type or a IO[bytes] type. Default value is
         None.
        :type restore_request_properties:
         ~azure.mgmt.hardwaresecuritymodules.models.RestoreRequestProperties or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either RestoreResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.RestoreResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RestoreResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._validate_restore_properties_initial(
                resource_group_name=resource_group_name,
                cloud_hsm_cluster_name=cloud_hsm_cluster_name,
                restore_request_properties=restore_request_properties,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

            deserialized = self._deserialize("RestoreResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncARMPolling(lro_delay, lro_options={"final-state-via": "azure-async-operation"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RestoreResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RestoreResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _restore_initial(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        restore_request_properties: Union[_models.RestoreRequestProperties, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(restore_request_properties, (IOBase, bytes)):
            _content = restore_request_properties
        else:
            _json = self._serialize.body(restore_request_properties, "RestoreRequestProperties")

        _request = build_restore_request(
            resource_group_name=resource_group_name,
            cloud_hsm_cluster_name=cloud_hsm_cluster_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        if response.status_code == 202:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_restore(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        restore_request_properties: _models.RestoreRequestProperties,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreResult]:
        """Restores all key materials of a specified Cloud HSM Cluster.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param restore_request_properties: Restore Operation Required properties. Required.
        :type restore_request_properties:
         ~azure.mgmt.hardwaresecuritymodules.models.RestoreRequestProperties
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RestoreResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.RestoreResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_restore(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        restore_request_properties: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreResult]:
        """Restores all key materials of a specified Cloud HSM Cluster.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param restore_request_properties: Restore Operation Required properties. Required.
        :type restore_request_properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RestoreResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.RestoreResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_restore(
        self,
        resource_group_name: str,
        cloud_hsm_cluster_name: str,
        restore_request_properties: Union[_models.RestoreRequestProperties, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RestoreResult]:
        """Restores all key materials of a specified Cloud HSM Cluster.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param cloud_hsm_cluster_name: The name of the Cloud HSM Cluster within the specified resource
         group. Cloud HSM Cluster names must be between 3 and 23 characters in length. Required.
        :type cloud_hsm_cluster_name: str
        :param restore_request_properties: Restore Operation Required properties. Is either a
         RestoreRequestProperties type or a IO[bytes] type. Required.
        :type restore_request_properties:
         ~azure.mgmt.hardwaresecuritymodules.models.RestoreRequestProperties or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either RestoreResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.hardwaresecuritymodules.models.RestoreResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RestoreResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restore_initial(
                resource_group_name=resource_group_name,
                cloud_hsm_cluster_name=cloud_hsm_cluster_name,
                restore_request_properties=restore_request_properties,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

            deserialized = self._deserialize("RestoreResult", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncARMPolling(lro_delay, lro_options={"final-state-via": "azure-async-operation"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RestoreResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RestoreResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )
