% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countGroupedDirection.R
\name{countGroupedDirection}
\alias{countGroupedDirection}
\title{Count directions of grouped tests}
\usage{
countGroupedDirection(
  p.values,
  grouping,
  effects,
  p.threshold = 0.05,
  effect.threshold = 0,
  method = c("BH", "holm"),
  log.p = FALSE
)
}
\arguments{
\item{p.values}{A numeric vector containing p-values for individual tests.}

\item{grouping}{A vector or factor of length equal to \code{p.values}, specifying the group to which each test is assigned.

Alternatively, an \link{rle} object where each run corresponds to a group and specifies the entries of \code{p.values} belonging to that group.
This assumes that \code{p.values} is ordered such that all entries in the same group are adjacent to each other.}

\item{effects}{A numeric vector of length equal to \code{p.values}, containing the effect size for each test.}

\item{p.threshold}{Numeric scalar defining the adjusted p-value threshold at which test is significant.}

\item{effect.threshold}{Numeric scalar defining the threshold at which an effect is \dQuote{"up"} or \dQuote{"down"}.}

\item{method}{String specifying how the multiple testing correction within each group is to be performed.}

\item{log.p}{Logical scalar indicating whether the \code{p.values} are log-transformed.}
}
\value{
A list with the \code{"up"} and \code{"down"} entries.
Both are integer vectors of length equal to the number of groups,
containing the number of significant tests changing each each direction in each group.
}
\description{
Count the number of grouped tests that are significant and changing in each direction.
Each group of tests is defined according to a grouping factor.
}
\details{
We apply a multiple testing correction within each group and define all significant tests as those with adjusted p-values below \code{p.threshold}.
We then count the number of tests with effects greater than \code{effect.threshold} (i.e., going up) or less than the threshold (i.e., going down).
This allows us to quantify the direction of change across the group into two counts.

The output of this function is simpler to interpret than the \code{summarize*Direction} functions.
However, \code{p.threshold} has no clear relationship to the significance threshold applied to the combined p-values.
Groups with many low p-values will have milder multiplicity corrections, resulting in more non-zero counts for both the \code{up} and \code{down} tests;
this often complicates matters by introducing mixed directions of effect, even when the most significant changes in the group are in one direction. 

Note that, if \code{log.p=TRUE}, the function will automatically handle the log-transformation of \code{p.threshold}.
}
\examples{
p <- rbeta(100, 0.5, 1)
eff <- rnorm(100)
g <- sample(20, 100, replace=TRUE)

(dirs <- countGroupedDirection(p, g, eff))

}
\seealso{
\code{\link{summarizeGroupedDirection}}, for another way to summarize the overall direction into a single string.

\code{\link{countParallelDirection}}, for the equivalent function operating on parallel tests.
}
\author{
Aaron Lun
}
