% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bootstrapped_contribution.R
\name{plot_bootstrapped_contribution}
\alias{plot_bootstrapped_contribution}
\title{Plot the bootstrapped signature contributions}
\usage{
plot_bootstrapped_contribution(
  contri_boots,
  mode = c("absolute", "relative"),
  plot_type = c("jitter", "barplot", "dotplot")
)
}
\arguments{
\item{contri_boots}{matrix showing  signature contributions across bootstrap iterations.}

\item{mode}{Either "absolute" for absolute number of mutations, or
"relative" for relative contribution, default = "absolute"}

\item{plot_type}{Either "jitter" for a jitter plot, "barplot" for a barplot, or "dotplot" for a dotplot}
}
\value{
A ggplot2 graph
}
\description{
Plot the signature contributions retrieved with 'fit_to_signatures_bootstrapped'.
The function can plot both the absolute or the relative signature contribution.
The graph can be plotted as either a jitter plot or as a barplot.
}
\examples{
## Get the bootstrapped signature contributions
## See 'count_indel_contexts()' for more info on how to do this.
contri_boots <- readRDS(system.file("states/bootstrapped_snv_refit.rds",
  package = "MutationalPatterns"
))

## Plot bootstrapped contribution
plot_bootstrapped_contribution(contri_boots)

## Plot bootstrapped contribution with relative contributions
plot_bootstrapped_contribution(contri_boots, mode = "relative")

## Plot bootstrapped contribution with a barplot
plot_bootstrapped_contribution(contri_boots, plot_type = "barplot")

## Plot bootstrapped contribution with a dotplot
plot_bootstrapped_contribution(contri_boots, plot_type = "dotplot", mode = "absolute")
}
