% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{methods}
\name{copyRccSet,RccSet-method}
\alias{copyRccSet,RccSet-method}
\alias{copyRccSet}
\title{Deep-copy a NanoString RccSet}
\usage{
\S4method{copyRccSet}{RccSet}(rccSet)
}
\arguments{
\item{rccSet}{A NanoString RccSet to be copied.}
}
\value{
A new RccSet that is a deep copy of the original.
}
\description{
Returns a copy of the input RccSet where the copy's assayData has been
produced via copyEnv() rather than a simple assignment -- hence deep-copying
the environment pointed to by assayData rather than just copying the
pointer. This guarantees that if the copy's assayData is affected later in
the code, assayData for the original won't be affected.
}
\examples{
data(example_rccSet)
example_rccSet_2 <- copyRccSet(example_rccSet)
assayData(example_rccSet)
assayData(example_rccSet_2) # Should be different

}
\author{
Robert Ziman
}
