/* Generated by re2c */
#line 1 "real_world/parse_date_b.re"
// re2c $INPUT -o $OUTPUT -b
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */



#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 0; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { return TIMELIB_ERROR; } else { s->time.have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	int           errors;

	struct timelib_time *time;
	timelib_tzdb        *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;
	}
}

static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	timelib_tz_lookup_table  *tp, *first_found_elem;
	timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_ABBR;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;
#line 846 "real_world/parse_date_b.re"



#line 744 "real_world/parse_date_b.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		104,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  96,  32,  96,   0, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 192, 128, 128, 128, 
		192, 128, 128, 128, 128, 128, 192, 128, 
		128, 128, 192, 192, 192, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	if ((YYLIMIT - YYCURSOR) < 26) YYFILL(26);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy2;
	case ' ':	goto yy6;
	case '(':	goto yy8;
	case '+':
	case '-':	goto yy9;
	case ',':
	case '.':	goto yy10;
	case '0':	goto yy11;
	case '1':	goto yy12;
	case '2':	goto yy13;
	case '3':	goto yy14;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy15;
	case '@':	goto yy16;
	case 'A':	goto yy17;
	case 'B':
	case 'C':
	case 'G':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy19;
	case 'D':	goto yy20;
	case 'E':	goto yy21;
	case 'F':	goto yy22;
	case 'I':	goto yy23;
	case 'J':	goto yy24;
	case 'L':	goto yy25;
	case 'M':	goto yy26;
	case 'N':	goto yy27;
	case 'O':	goto yy28;
	case 'P':	goto yy29;
	case 'S':	goto yy30;
	case 'T':	goto yy31;
	case 'V':	goto yy32;
	case 'W':	goto yy33;
	case 'X':	goto yy34;
	case 'Y':	goto yy35;
	case 'a':	goto yy36;
	case 'b':
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy37;
	case 'd':	goto yy38;
	case 'e':	goto yy39;
	case 'f':	goto yy40;
	case 'j':	goto yy41;
	case 'l':	goto yy42;
	case 'm':	goto yy43;
	case 'n':	goto yy44;
	case 'o':	goto yy45;
	case 'p':	goto yy46;
	case 's':	goto yy47;
	case 't':	goto yy48;
	case 'w':	goto yy49;
	case 'y':	goto yy50;
	default:	goto yy4;
	}
yy2:
	++YYCURSOR;
#line 1401 "real_world/parse_date_b.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 865 "real_world/parse_date_b.c"
yy4:
	++YYCURSOR;
yy5:
#line 1407 "real_world/parse_date_b.re"
	{
/*		printf("unexpected character: #%d, %c ", *s->tok, *s->tok); */
		s->errors++;
		goto std;
	}
#line 875 "real_world/parse_date_b.c"
yy6:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy51;
	}
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy54;
yy7:
#line 1396 "real_world/parse_date_b.re"
	{
		goto std;
	}
#line 889 "real_world/parse_date_b.c"
yy8:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy5;
	if (yych <= 'Z') goto yy37;
	if (yych <= '`') goto yy5;
	if (yych <= 'z') goto yy37;
	goto yy5;
yy9:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy51;
	}
	if (yych <= '/') goto yy5;
	if (yych <= '1') goto yy56;
	if (yych <= '2') goto yy57;
	if (yych <= '9') goto yy58;
	goto yy5;
yy10:
	++YYCURSOR;
	goto yy7;
yy11:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy60;
	case '-':	goto yy63;
	case '.':	goto yy64;
	case '/':	goto yy65;
	case '0':	goto yy66;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy67;
	case ':':	goto yy68;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy5;
	}
yy12:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy63;
	case '.':	goto yy91;
	case '/':	goto yy65;
	case '0':
	case '1':
	case '2':	goto yy67;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy92;
	case ':':	goto yy93;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy5;
	}
yy13:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy63;
	case '.':	goto yy91;
	case '/':	goto yy65;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy92;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy96;
	case ':':	goto yy93;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy5;
	}
yy14:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy63;
	case '.':	goto yy91;
	case '/':	goto yy65;
	case '0':
	case '1':	goto yy96;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy97;
	case ':':	goto yy93;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy5;
	}
yy15:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy90;
	case '-':	goto yy63;
	case '.':	goto yy91;
	case '/':	goto yy65;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy97;
	case ':':	goto yy93;
	case 'n':	goto yy85;
	case 'r':	goto yy86;
	case 's':	goto yy87;
	case 't':	goto yy88;
	default:	goto yy5;
	}
yy16:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy98;
	if (yych <= '0') goto yy5;
	if (yych <= '9') goto yy99;
	goto yy5;
yy17:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy102;
			if (yych >= 'A') goto yy103;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy104;
				goto yy103;
			} else {
				if (yych <= 'P') goto yy105;
				if (yych <= 'T') goto yy103;
				goto yy106;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
			} else {
				if (yych == 'g') goto yy108;
				goto yy107;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy109;
				goto yy107;
			} else {
				if (yych <= 'u') goto yy110;
				if (yych <= 'z') goto yy107;
			}
		}
	}
yy18:
#line 1341 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1276 "real_world/parse_date_b.c"
yy19:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy103;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy107;
		goto yy18;
	}
yy20:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy111;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy107;
		} else {
			if (yych <= 'e') goto yy112;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy21:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'I') goto yy113;
			if (yych <= 'K') goto yy103;
			goto yy114;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy107;
			goto yy115;
		} else {
			if (yych == 'l') goto yy116;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy22:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'D') goto yy103;
				goto yy117;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy118;
				goto yy103;
			} else {
				if (yych <= 'O') goto yy119;
				if (yych <= 'Q') goto yy103;
				goto yy120;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy103;
				if (yych <= '`') goto yy18;
				goto yy107;
			} else {
				if (yych <= 'e') goto yy121;
				if (yych <= 'h') goto yy107;
				goto yy122;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy123;
				goto yy107;
			} else {
				if (yych <= 'r') goto yy124;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy23:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			goto yy103;
		}
	} else {
		if (yych <= 'W') {
			if (yych <= 'I') goto yy132;
			if (yych == 'V') goto yy133;
			goto yy103;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'X') goto yy133;
				goto yy103;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy24:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= 'A') goto yy134;
			if (yych <= 'T') goto yy103;
			goto yy135;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy136;
		} else {
			if (yych == 'u') goto yy137;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy25:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		if (yych <= '@') goto yy18;
		goto yy138;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy103;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy139;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy26:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy140;
		} else {
			if (yych == 'I') goto yy141;
			if (yych <= 'N') goto yy103;
			goto yy142;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy143;
			goto yy107;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy144;
				goto yy107;
			} else {
				if (yych <= 'o') goto yy145;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy27:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy146;
				goto yy103;
			} else {
				if (yych <= 'I') goto yy147;
				if (yych <= 'N') goto yy103;
				goto yy148;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
				goto yy18;
			} else {
				if (yych == 'e') goto yy149;
				goto yy107;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy150;
				goto yy107;
			} else {
				if (yych <= 'o') goto yy151;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy28:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy103;
			goto yy152;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy107;
		} else {
			if (yych <= 'c') goto yy153;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy29:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy103;
			goto yy154;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy107;
		} else {
			if (yych <= 'r') goto yy155;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy30:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'A') goto yy156;
				goto yy103;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy157;
				goto yy103;
			} else {
				if (yych <= 'I') goto yy158;
				if (yych <= 'T') goto yy103;
				goto yy142;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
				goto yy18;
			} else {
				if (yych <= 'a') goto yy159;
				if (yych <= 'd') goto yy107;
				goto yy160;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy161;
				goto yy107;
			} else {
				if (yych <= 'u') goto yy145;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy31:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '@') {
				if (yych == ')') goto yy102;
				goto yy18;
			} else {
				if (yych == 'E') goto yy147;
				goto yy103;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'H') goto yy162;
				if (yych <= 'N') goto yy103;
				goto yy163;
			} else {
				if (yych == 'U') goto yy164;
				if (yych <= 'V') goto yy103;
				goto yy165;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy103;
				if (yych <= '`') goto yy18;
				goto yy107;
			} else {
				if (yych <= 'e') goto yy150;
				if (yych == 'h') goto yy166;
				goto yy107;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') goto yy167;
				if (yych <= 't') goto yy107;
				goto yy168;
			} else {
				if (yych == 'w') goto yy169;
				if (yych <= 'z') goto yy107;
				goto yy18;
			}
		}
	}
yy32:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy18;
			if (yych <= '(') goto yy126;
			goto yy127;
		} else {
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'I') {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy103;
			goto yy170;
		} else {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy33:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy171;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy107;
		} else {
			if (yych <= 'e') goto yy172;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy34:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy18;
			if (yych <= '(') goto yy126;
			goto yy127;
		} else {
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'I') {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy103;
			goto yy132;
		} else {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy35:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy173;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy107;
		} else {
			if (yych <= 'e') goto yy174;
			if (yych <= 'z') goto yy107;
			goto yy18;
		}
	}
yy36:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy104;
				goto yy103;
			} else {
				if (yych <= 'P') goto yy105;
				if (yych <= 'T') goto yy103;
				goto yy106;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
				goto yy18;
			} else {
				if (yych == 'g') goto yy104;
				goto yy103;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy105;
				goto yy103;
			} else {
				if (yych <= 'u') goto yy106;
				if (yych <= 'z') goto yy103;
				goto yy18;
			}
		}
	}
yy37:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy103;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy103;
		goto yy18;
	}
yy38:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy111;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'e') goto yy111;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy39:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'I') goto yy113;
			if (yych <= 'K') goto yy103;
			goto yy114;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy103;
			goto yy113;
		} else {
			if (yych == 'l') goto yy114;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy40:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'D') goto yy103;
				goto yy117;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy118;
				goto yy103;
			} else {
				if (yych <= 'O') goto yy119;
				if (yych <= 'Q') goto yy103;
				goto yy120;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy103;
				if (yych <= '`') goto yy18;
				goto yy103;
			} else {
				if (yych <= 'e') goto yy117;
				if (yych <= 'h') goto yy103;
				goto yy118;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy119;
				goto yy103;
			} else {
				if (yych <= 'r') goto yy120;
				if (yych <= 'z') goto yy103;
				goto yy18;
			}
		}
	}
yy41:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= 'A') goto yy134;
			if (yych <= 'T') goto yy103;
			goto yy135;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy134;
		} else {
			if (yych == 'u') goto yy135;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy42:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		if (yych <= '@') goto yy18;
		goto yy138;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy103;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy138;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy43:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy140;
		} else {
			if (yych == 'I') goto yy141;
			if (yych <= 'N') goto yy103;
			goto yy142;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy140;
			goto yy103;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy141;
				goto yy103;
			} else {
				if (yych <= 'o') goto yy142;
				if (yych <= 'z') goto yy103;
				goto yy18;
			}
		}
	}
yy44:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy146;
				goto yy103;
			} else {
				if (yych <= 'I') goto yy147;
				if (yych <= 'N') goto yy103;
				goto yy148;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
				goto yy18;
			} else {
				if (yych == 'e') goto yy146;
				goto yy103;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy147;
				goto yy103;
			} else {
				if (yych <= 'o') goto yy148;
				if (yych <= 'z') goto yy103;
				goto yy18;
			}
		}
	}
yy45:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy103;
			goto yy152;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'c') goto yy152;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy46:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy103;
			goto yy154;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'r') goto yy154;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy47:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'A') goto yy156;
				goto yy103;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy157;
				goto yy103;
			} else {
				if (yych <= 'I') goto yy158;
				if (yych <= 'T') goto yy103;
				goto yy142;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy103;
				goto yy18;
			} else {
				if (yych <= 'a') goto yy156;
				if (yych <= 'd') goto yy103;
				goto yy157;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy158;
				goto yy103;
			} else {
				if (yych <= 'u') goto yy142;
				if (yych <= 'z') goto yy103;
				goto yy18;
			}
		}
	}
yy48:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '@') {
				if (yych == ')') goto yy102;
				goto yy18;
			} else {
				if (yych == 'E') goto yy147;
				goto yy103;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'H') goto yy162;
				if (yych <= 'N') goto yy103;
				goto yy163;
			} else {
				if (yych == 'U') goto yy164;
				if (yych <= 'V') goto yy103;
				goto yy165;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy103;
				if (yych <= '`') goto yy18;
				goto yy103;
			} else {
				if (yych <= 'e') goto yy147;
				if (yych == 'h') goto yy162;
				goto yy103;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') goto yy163;
				if (yych <= 't') goto yy103;
				goto yy164;
			} else {
				if (yych == 'w') goto yy165;
				if (yych <= 'z') goto yy103;
				goto yy18;
			}
		}
	}
yy49:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy171;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'e') goto yy171;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy50:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy103;
			goto yy173;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy103;
			if (yych <= '`') goto yy18;
			goto yy103;
		} else {
			if (yych <= 'e') goto yy173;
			if (yych <= 'z') goto yy103;
			goto yy18;
		}
	}
yy51:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy51;
	}
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy54;
yy53:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 13) {
		if (yyaccept <= 6) {
			if (yyaccept <= 3) {
				if (yyaccept <= 1) {
					if (yyaccept == 0) {
						goto yy7;
					} else {
						goto yy5;
					}
				} else {
					if (yyaccept == 2) {
						goto yy18;
					} else {
						goto yy74;
					}
				}
			} else {
				if (yyaccept <= 5) {
					if (yyaccept == 4) {
						goto yy192;
					} else {
						goto yy197;
					}
				} else {
					goto yy256;
				}
			}
		} else {
			if (yyaccept <= 10) {
				if (yyaccept <= 8) {
					if (yyaccept == 7) {
						goto yy275;
					} else {
						goto yy129;
					}
				} else {
					if (yyaccept == 9) {
						goto yy304;
					} else {
						goto yy357;
					}
				}
			} else {
				if (yyaccept <= 12) {
					if (yyaccept == 11) {
						goto yy359;
					} else {
						goto yy363;
					}
				} else {
					goto yy443;
				}
			}
		}
	} else {
		if (yyaccept <= 20) {
			if (yyaccept <= 17) {
				if (yyaccept <= 15) {
					if (yyaccept == 14) {
						goto yy474;
					} else {
						goto yy583;
					}
				} else {
					if (yyaccept == 16) {
						goto yy586;
					} else {
						goto yy622;
					}
				}
			} else {
				if (yyaccept <= 19) {
					if (yyaccept == 18) {
						goto yy663;
					} else {
						goto yy775;
					}
				} else {
					goto yy505;
				}
			}
		} else {
			if (yyaccept <= 23) {
				if (yyaccept <= 22) {
					if (yyaccept == 21) {
						goto yy803;
					} else {
						goto yy855;
					}
				} else {
					goto yy860;
				}
			} else {
				if (yyaccept <= 25) {
					if (yyaccept == 24) {
						goto yy900;
					} else {
						goto yy947;
					}
				} else {
					goto yy1020;
				}
			}
		}
	}
yy54:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	switch (yych) {
	case ' ':	goto yy175;
	case 'D':
	case 'd':	goto yy177;
	case 'F':
	case 'f':	goto yy178;
	case 'H':
	case 'h':	goto yy72;
	case 'M':
	case 'm':	goto yy179;
	case 'S':
	case 's':	goto yy180;
	case 'T':
	case 't':	goto yy80;
	case 'W':
	case 'w':	goto yy82;
	case 'Y':
	case 'y':	goto yy84;
	default:	goto yy53;
	}
yy56:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy58;
	case ':':	goto yy181;
	default:	goto yy18;
	}
yy57:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy58;
	case '4':
	case '5':	goto yy182;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy183;
	case ':':	goto yy181;
	default:	goto yy18;
	}
yy58:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy182;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy183;
	case ':':	goto yy181;
	default:	goto yy18;
	}
yy59:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy60:
	switch (yych) {
	case ' ':	goto yy59;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy61;
	case 'A':
	case 'a':	goto yy69;
	case 'D':
	case 'd':	goto yy70;
	case 'F':
	case 'f':	goto yy71;
	case 'H':
	case 'h':	goto yy72;
	case 'I':	goto yy73;
	case 'J':
	case 'j':	goto yy75;
	case 'M':
	case 'm':	goto yy76;
	case 'N':
	case 'n':	goto yy77;
	case 'O':
	case 'o':	goto yy78;
	case 'S':
	case 's':	goto yy79;
	case 'T':
	case 't':	goto yy80;
	case 'V':	goto yy81;
	case 'W':
	case 'w':	goto yy82;
	case 'X':	goto yy83;
	case 'Y':
	case 'y':	goto yy84;
	default:	goto yy53;
	}
yy61:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy62:
	if (yybm[0+yych] & 32) {
		goto yy61;
	}
	switch (yych) {
	case 'A':
	case 'a':	goto yy69;
	case 'D':
	case 'd':	goto yy184;
	case 'F':
	case 'f':	goto yy185;
	case 'I':	goto yy73;
	case 'J':
	case 'j':	goto yy75;
	case 'M':
	case 'm':	goto yy186;
	case 'N':
	case 'n':	goto yy77;
	case 'O':
	case 'o':	goto yy78;
	case 'S':
	case 's':	goto yy187;
	case 'V':	goto yy81;
	case 'X':	goto yy83;
	default:	goto yy53;
	}
yy63:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy62;
	if (yych <= '0') goto yy188;
	if (yych <= '1') goto yy189;
	if (yych <= '9') goto yy190;
	goto yy62;
yy64:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy62;
		if (yych <= '0') goto yy191;
		goto yy193;
	} else {
		if (yych <= '5') goto yy194;
		if (yych <= '9') goto yy195;
		goto yy62;
	}
yy65:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy196;
	case '3':	goto yy198;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy199;
	case 'A':
	case 'a':	goto yy200;
	case 'D':
	case 'd':	goto yy201;
	case 'F':
	case 'f':	goto yy202;
	case 'J':
	case 'j':	goto yy203;
	case 'M':
	case 'm':	goto yy204;
	case 'N':
	case 'n':	goto yy205;
	case 'O':
	case 'o':	goto yy206;
	case 'S':
	case 's':	goto yy207;
	default:	goto yy53;
	}
yy66:
	yych = *++YYCURSOR;
	if (yych <= ':') {
		if (yych <= '.') {
			if (yych <= ',') goto yy60;
			if (yych <= '-') goto yy63;
			goto yy64;
		} else {
			if (yych <= '/') goto yy65;
			if (yych <= '5') goto yy208;
			if (yych <= '9') goto yy209;
			goto yy68;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy85;
			goto yy60;
		} else {
			if (yych <= 'r') goto yy86;
			if (yych <= 's') goto yy87;
			if (yych <= 't') goto yy88;
			goto yy60;
		}
	}
yy67:
	yych = *++YYCURSOR;
	if (yych <= ':') {
		if (yych <= '.') {
			if (yych <= ',') goto yy90;
			if (yych <= '-') goto yy63;
			goto yy91;
		} else {
			if (yych <= '/') goto yy65;
			if (yych <= '5') goto yy208;
			if (yych <= '9') goto yy209;
			goto yy93;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy85;
			goto yy90;
		} else {
			if (yych <= 'r') goto yy86;
			if (yych <= 's') goto yy87;
			if (yych <= 't') goto yy88;
			goto yy90;
		}
	}
yy68:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy210;
	if (yych <= '9') goto yy211;
	goto yy53;
yy69:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy212;
		if (yych <= 'T') goto yy53;
		goto yy213;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy212;
		} else {
			if (yych == 'u') goto yy213;
			goto yy53;
		}
	}
yy70:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy214;
		if (yych <= 'D') goto yy53;
		goto yy215;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy214;
		} else {
			if (yych == 'e') goto yy215;
			goto yy53;
		}
	}
yy71:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy216;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy217;
			if (yych <= 'Q') goto yy53;
			goto yy218;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy216;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy217;
			if (yych == 'r') goto yy218;
			goto yy53;
		}
	}
yy72:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy219;
	if (yych == 'o') goto yy219;
	goto yy53;
yy73:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych >= ' ') goto yy220;
		} else {
			if (yych <= '/') goto yy74;
			if (yych <= '9') goto yy222;
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'I') goto yy224;
			if (yych >= 'V') goto yy225;
		} else {
			if (yych == 'X') goto yy225;
		}
	}
yy74:
#line 1140 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 2666 "real_world/parse_date_b.c"
yy75:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy226;
		if (yych <= 'T') goto yy53;
		goto yy227;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy226;
		} else {
			if (yych == 'u') goto yy227;
			goto yy53;
		}
	}
yy76:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy228;
			goto yy53;
		} else {
			if (yych <= 'I') goto yy229;
			if (yych <= 'N') goto yy53;
			goto yy230;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy228;
			goto yy53;
		} else {
			if (yych <= 'i') goto yy229;
			if (yych == 'o') goto yy230;
			goto yy53;
		}
	}
yy77:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy231;
	if (yych == 'o') goto yy231;
	goto yy53;
yy78:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy232;
	if (yych == 'c') goto yy232;
	goto yy53;
yy79:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy233;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy234;
			if (yych <= 'T') goto yy53;
			goto yy235;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy233;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy234;
			if (yych == 'u') goto yy235;
			goto yy53;
		}
	}
yy80:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy236;
		if (yych <= 'T') goto yy53;
		goto yy237;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy236;
		} else {
			if (yych == 'u') goto yy237;
			goto yy53;
		}
	}
yy81:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		goto yy74;
	} else {
		if (yych <= '9') goto yy222;
		if (yych == 'I') goto yy83;
		goto yy74;
	}
yy82:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy238;
	if (yych == 'e') goto yy238;
	goto yy53;
yy83:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		goto yy74;
	} else {
		if (yych <= '9') goto yy222;
		if (yych == 'I') goto yy224;
		goto yy74;
	}
yy84:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy239;
	if (yych == 'e') goto yy239;
	goto yy53;
yy85:
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy231;
		goto yy53;
	} else {
		if (yych <= 'd') goto yy240;
		if (yych == 'o') goto yy231;
		goto yy53;
	}
yy86:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy240;
	goto yy53;
yy87:
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy233;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy234;
			if (yych == 'U') goto yy235;
			goto yy53;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy233;
			if (yych <= 'd') goto yy53;
			goto yy234;
		} else {
			if (yych <= 's') goto yy53;
			if (yych <= 't') goto yy240;
			if (yych <= 'u') goto yy235;
			goto yy53;
		}
	}
yy88:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy236;
		if (yych <= 'T') goto yy53;
		goto yy237;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy241;
		} else {
			if (yych == 'u') goto yy237;
			goto yy53;
		}
	}
yy89:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy90:
	switch (yych) {
	case ' ':	goto yy89;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy61;
	case 'A':
	case 'a':	goto yy94;
	case 'D':
	case 'd':	goto yy70;
	case 'F':
	case 'f':	goto yy71;
	case 'H':
	case 'h':	goto yy72;
	case 'I':	goto yy73;
	case 'J':
	case 'j':	goto yy75;
	case 'M':
	case 'm':	goto yy76;
	case 'N':
	case 'n':	goto yy77;
	case 'O':
	case 'o':	goto yy78;
	case 'P':
	case 'p':	goto yy95;
	case 'S':
	case 's':	goto yy79;
	case 'T':
	case 't':	goto yy80;
	case 'V':	goto yy81;
	case 'W':
	case 'w':	goto yy82;
	case 'X':	goto yy83;
	case 'Y':
	case 'y':	goto yy84;
	default:	goto yy53;
	}
yy91:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy62;
		if (yych <= '0') goto yy242;
		goto yy243;
	} else {
		if (yych <= '5') goto yy244;
		if (yych <= '9') goto yy245;
		goto yy62;
	}
yy92:
	yych = *++YYCURSOR;
	if (yych <= ':') {
		if (yych <= '.') {
			if (yych <= ',') goto yy60;
			if (yych <= '-') goto yy63;
			goto yy64;
		} else {
			if (yych <= '/') goto yy246;
			if (yych <= '5') goto yy208;
			if (yych <= '9') goto yy209;
			goto yy68;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy85;
			goto yy60;
		} else {
			if (yych <= 'r') goto yy86;
			if (yych <= 's') goto yy87;
			if (yych <= 't') goto yy88;
			goto yy60;
		}
	}
yy93:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy247;
	if (yych <= '9') goto yy248;
	goto yy53;
yy94:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy249;
			goto yy53;
		} else {
			if (yych <= 'M') goto yy250;
			if (yych == 'P') goto yy212;
			goto yy53;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy213;
			if (yych == 'm') goto yy250;
			goto yy53;
		} else {
			if (yych <= 'p') goto yy212;
			if (yych == 'u') goto yy213;
			goto yy53;
		}
	}
yy95:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy249;
		goto yy53;
	} else {
		if (yych <= 'M') goto yy250;
		if (yych == 'm') goto yy250;
		goto yy53;
	}
yy96:
	yych = *++YYCURSOR;
	if (yych <= 'm') {
		if (yych <= '.') {
			if (yych <= ',') goto yy60;
			if (yych <= '-') goto yy63;
			goto yy252;
		} else {
			if (yych <= '/') goto yy246;
			if (yych <= '9') goto yy209;
			goto yy60;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy85;
			if (yych <= 'q') goto yy60;
			goto yy86;
		} else {
			if (yych <= 's') goto yy87;
			if (yych <= 't') goto yy88;
			goto yy60;
		}
	}
yy97:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy253;
	if (yych <= '/') goto yy176;
	if (yych <= '9') goto yy209;
	goto yy176;
yy98:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych >= ':') goto yy53;
yy99:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy101;
	if (yych <= '9') goto yy99;
yy101:
#line 906 "real_world/parse_date_b.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3023 "real_world/parse_date_b.c"
yy102:
	++YYCURSOR;
	goto yy18;
yy103:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy254;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy254;
		goto yy18;
	}
yy104:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy254;
			goto yy255;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'o') goto yy255;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy105:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy254;
			goto yy257;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'r') goto yy257;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy106:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy254;
			goto yy258;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'g') goto yy258;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy107:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych == '/') goto yy259;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '^') goto yy18;
			goto yy259;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy108:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy254;
			goto yy255;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'o') goto yy261;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy109:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy254;
			goto yy257;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'r') goto yy262;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy110:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy254;
			goto yy258;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'g') goto yy263;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy111:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy254;
			goto yy264;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'c') goto yy264;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy112:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy254;
			goto yy264;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'c') goto yy265;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy113:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy254;
			goto yy266;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'g') goto yy266;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy114:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy254;
			goto yy267;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'e') goto yy267;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy115:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy254;
			goto yy266;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'g') goto yy268;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy116:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy254;
			goto yy267;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'e') goto yy269;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy117:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy254;
			goto yy270;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'b') goto yy270;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy118:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'F') goto yy271;
			if (yych <= 'Q') goto yy254;
			goto yy272;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			if (yych <= 'e') goto yy254;
			goto yy271;
		} else {
			if (yych == 'r') goto yy272;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy119:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy254;
			goto yy273;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'u') goto yy273;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy120:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy254;
			goto yy274;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'i') goto yy274;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy121:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy254;
			goto yy270;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'b') goto yy276;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy122:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy259;
		} else {
			if (yych <= 'E') {
				if (yych <= '@') goto yy18;
				goto yy254;
			} else {
				if (yych <= 'F') goto yy271;
				if (yych <= 'Q') goto yy254;
				goto yy272;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy18;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy18;
				goto yy260;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy277;
				goto yy260;
			} else {
				if (yych <= 'r') goto yy278;
				if (yych <= 'z') goto yy260;
				goto yy18;
			}
		}
	}
yy123:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy254;
			goto yy273;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'u') goto yy279;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy124:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy254;
			goto yy274;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'i') goto yy280;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy125:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
yy126:
	if (yych <= '/') {
		if (yych <= 0x1F) goto yy53;
		if (yych <= '.') goto yy125;
		goto yy53;
	} else {
		if (yych <= '2') goto yy128;
		if (yych <= '3') goto yy130;
		if (yych <= '9') goto yy131;
		goto yy53;
	}
yy127:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) goto yy18;
	if (yych == '/') goto yy18;
	if (yych <= '9') goto yy126;
	goto yy18;
yy128:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy282;
	if (yych <= '9') goto yy283;
	goto yy282;
yy129:
#line 1127 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3576 "real_world/parse_date_b.c"
yy130:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy282;
	if (yych <= '1') goto yy283;
	if (yych <= '2') goto yy284;
	if (yych <= '9') goto yy285;
	goto yy282;
yy131:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy282;
	if (yych <= '1') goto yy286;
	if (yych <= '2') goto yy284;
	if (yych <= '9') goto yy285;
	goto yy282;
yy132:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy18;
			if (yych <= '(') goto yy126;
			goto yy127;
		} else {
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'I') {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy254;
			goto yy287;
		} else {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy133:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych <= ')') goto yy127;
			if (yych <= '.') goto yy126;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			goto yy254;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy134:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy254;
			goto yy288;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'n') goto yy288;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy135:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'L') goto yy289;
			if (yych <= 'M') goto yy254;
			goto yy290;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			if (yych <= 'k') goto yy254;
			goto yy289;
		} else {
			if (yych == 'n') goto yy290;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy136:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy254;
			goto yy288;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'n') goto yy291;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy137:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy259;
		} else {
			if (yych <= 'K') {
				if (yych <= '@') goto yy18;
				goto yy254;
			} else {
				if (yych <= 'L') goto yy289;
				if (yych <= 'M') goto yy254;
				goto yy290;
			}
		}
	} else {
		if (yych <= 'k') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy18;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy18;
				goto yy260;
			}
		} else {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy292;
				goto yy260;
			} else {
				if (yych <= 'n') goto yy293;
				if (yych <= 'z') goto yy260;
				goto yy18;
			}
		}
	}
yy138:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy254;
			goto yy294;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 's') goto yy294;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy139:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy254;
			goto yy294;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 's') goto yy295;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy140:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'R') goto yy296;
			if (yych <= 'X') goto yy254;
			goto yy297;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			if (yych <= 'q') goto yy254;
			goto yy296;
		} else {
			if (yych == 'y') goto yy297;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy141:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy254;
			goto yy298;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'd') goto yy298;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy142:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy254;
			goto yy274;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'n') goto yy274;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy143:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy259;
		} else {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy18;
				goto yy254;
			} else {
				if (yych <= 'R') goto yy296;
				if (yych <= 'X') goto yy254;
				goto yy297;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy18;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy18;
				goto yy260;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'r') goto yy299;
				goto yy260;
			} else {
				if (yych <= 'y') goto yy300;
				if (yych <= 'z') goto yy260;
				goto yy18;
			}
		}
	}
yy144:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy254;
			goto yy298;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'd') goto yy301;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy145:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy254;
			goto yy274;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'n') goto yy280;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy146:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy254;
			goto yy294;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'x') goto yy294;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy147:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy254;
			goto yy271;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'n') goto yy271;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy148:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'O') goto yy302;
			if (yych <= 'U') goto yy254;
			if (yych <= 'V') goto yy264;
			goto yy303;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			if (yych <= 'n') goto yy254;
			goto yy302;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy254;
				goto yy264;
			} else {
				if (yych <= 'w') goto yy303;
				if (yych <= 'z') goto yy254;
				goto yy18;
			}
		}
	}
yy149:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy254;
			goto yy294;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'x') goto yy295;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy150:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy254;
			goto yy271;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'n') goto yy277;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy151:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych == '/') goto yy259;
				goto yy18;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'N') goto yy254;
				goto yy302;
			} else {
				if (yych <= 'U') goto yy254;
				if (yych <= 'V') goto yy264;
				goto yy303;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy18;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy18;
				goto yy260;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy305;
				if (yych <= 'u') goto yy260;
				goto yy265;
			} else {
				if (yych <= 'w') goto yy306;
				if (yych <= 'z') goto yy260;
				goto yy18;
			}
		}
	}
yy152:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy254;
			goto yy307;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 't') goto yy307;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy153:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy254;
			goto yy307;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 't') goto yy308;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy154:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy254;
			goto yy309;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'e') goto yy309;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy155:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy254;
			goto yy309;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'e') goto yy310;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy156:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy254;
			goto yy311;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 't') goto yy311;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy157:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy102;
			if (yych <= '@') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy312;
				goto yy254;
			} else {
				if (yych <= 'P') goto yy313;
				if (yych <= 'U') goto yy254;
				goto yy314;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy254;
				goto yy18;
			} else {
				if (yych == 'c') goto yy312;
				goto yy254;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy313;
				goto yy254;
			} else {
				if (yych <= 'v') goto yy314;
				if (yych <= 'z') goto yy254;
				goto yy18;
			}
		}
	}
yy158:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy254;
			goto yy271;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'x') goto yy271;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy159:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy254;
			goto yy311;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 't') goto yy315;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy160:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy102;
			} else {
				if (yych == '/') goto yy259;
				goto yy18;
			}
		} else {
			if (yych <= 'O') {
				if (yych == 'C') goto yy312;
				goto yy254;
			} else {
				if (yych <= 'P') goto yy313;
				if (yych <= 'U') goto yy254;
				goto yy314;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy254;
				if (yych <= '^') goto yy18;
				goto yy259;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'b') goto yy260;
				goto yy316;
			}
		} else {
			if (yych <= 'u') {
				if (yych == 'p') goto yy317;
				goto yy260;
			} else {
				if (yych <= 'v') goto yy318;
				if (yych <= 'z') goto yy260;
				goto yy18;
			}
		}
	}
yy161:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy254;
			goto yy271;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'x') goto yy277;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy162:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'I') goto yy319;
			if (yych <= 'T') goto yy254;
			goto yy320;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy254;
			goto yy319;
		} else {
			if (yych == 'u') goto yy320;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy163:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych == 'D') goto yy321;
			if (yych <= 'L') goto yy254;
			goto yy322;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			if (yych <= 'c') goto yy254;
			goto yy321;
		} else {
			if (yych == 'm') goto yy322;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy164:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy254;
			goto yy323;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'e') goto yy323;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy165:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy254;
			goto yy324;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'e') goto yy324;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy166:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy259;
		} else {
			if (yych <= 'H') {
				if (yych <= '@') goto yy18;
				goto yy254;
			} else {
				if (yych <= 'I') goto yy319;
				if (yych <= 'T') goto yy254;
				goto yy320;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy18;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy18;
				goto yy260;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'i') goto yy325;
				goto yy260;
			} else {
				if (yych <= 'u') goto yy326;
				if (yych <= 'z') goto yy260;
				goto yy18;
			}
		}
	}
yy167:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy259;
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy18;
				goto yy254;
			} else {
				if (yych <= 'D') goto yy321;
				if (yych <= 'L') goto yy254;
				goto yy322;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy18;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy18;
				goto yy260;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'd') goto yy327;
				goto yy260;
			} else {
				if (yych <= 'm') goto yy328;
				if (yych <= 'z') goto yy260;
				goto yy18;
			}
		}
	}
yy168:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy254;
			goto yy323;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'e') goto yy329;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy169:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy254;
			goto yy324;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'e') goto yy330;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy170:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy18;
			if (yych <= '(') goto yy126;
			goto yy127;
		} else {
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'I') {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy254;
			goto yy331;
		} else {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy171:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy254;
			goto yy332;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 'd') goto yy332;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy172:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy254;
			goto yy332;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'd') goto yy333;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy173:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy254;
			goto yy334;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy18;
			goto yy254;
		} else {
			if (yych <= 's') goto yy334;
			if (yych <= 'z') goto yy254;
			goto yy18;
		}
	}
yy174:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy254;
			goto yy334;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 's') goto yy335;
			if (yych <= 'z') goto yy260;
			goto yy18;
		}
	}
yy175:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy176:
	switch (yych) {
	case ' ':	goto yy175;
	case 'D':
	case 'd':	goto yy177;
	case 'F':
	case 'f':	goto yy178;
	case 'H':
	case 'h':	goto yy72;
	case 'M':
	case 'm':	goto yy179;
	case 'S':
	case 's':	goto yy180;
	case 'T':
	case 't':	goto yy80;
	case 'W':
	case 'w':	goto yy82;
	case 'Y':
	case 'y':	goto yy84;
	default:	goto yy53;
	}
yy177:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy214;
	if (yych == 'a') goto yy214;
	goto yy53;
yy178:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy217;
		if (yych <= 'Q') goto yy53;
		goto yy218;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy217;
		} else {
			if (yych == 'r') goto yy218;
			goto yy53;
		}
	}
yy179:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy229;
		if (yych <= 'N') goto yy53;
		goto yy230;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy53;
			goto yy229;
		} else {
			if (yych == 'o') goto yy230;
			goto yy53;
		}
	}
yy180:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy233;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy336;
			if (yych <= 'T') goto yy53;
			goto yy235;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy233;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy336;
			if (yych == 'u') goto yy235;
			goto yy53;
		}
	}
yy181:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '5') goto yy337;
	if (yych <= '9') goto yy102;
	goto yy18;
yy182:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy183;
	default:	goto yy18;
	}
yy183:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= 'C') {
				if (yych == ' ') goto yy176;
				goto yy18;
			} else {
				if (yych == 'E') goto yy18;
				if (yych <= 'F') goto yy176;
				goto yy18;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'H') goto yy176;
				if (yych == 'M') goto yy176;
				goto yy18;
			} else {
				if (yych <= 'T') goto yy176;
				if (yych == 'W') goto yy176;
				goto yy18;
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy176;
				if (yych == 'd') goto yy176;
				goto yy18;
			} else {
				if (yych == 'g') goto yy18;
				if (yych <= 'h') goto yy176;
				goto yy18;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'm') goto yy176;
				if (yych <= 'r') goto yy18;
				if (yych <= 't') goto yy176;
				goto yy18;
			} else {
				if (yych == 'x') goto yy18;
				if (yych <= 'y') goto yy176;
				goto yy18;
			}
		}
	}
yy184:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy215;
	if (yych == 'e') goto yy215;
	goto yy53;
yy185:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy216;
	if (yych == 'e') goto yy216;
	goto yy53;
yy186:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy228;
	if (yych == 'a') goto yy228;
	goto yy53;
yy187:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy338;
	if (yych == 'e') goto yy338;
	goto yy53;
yy188:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy339;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy190;
	goto yy53;
yy189:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy339;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy190:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy339;
	goto yy53;
yy191:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy340;
	} else {
		if (yych <= '9') goto yy195;
		if (yych <= ':') goto yy341;
	}
yy192:
#line 947 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 4948 "real_world/parse_date_b.c"
yy193:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy340;
		goto yy192;
	} else {
		if (yych <= '2') goto yy195;
		if (yych <= '9') goto yy211;
		if (yych <= ':') goto yy341;
		goto yy192;
	}
yy194:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy340;
		goto yy192;
	} else {
		if (yych <= '9') goto yy211;
		if (yych <= ':') goto yy341;
		goto yy192;
	}
yy195:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy340;
	if (yych == ':') goto yy341;
	goto yy192;
yy196:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy342;
		} else {
			if (yych <= '9') goto yy199;
			if (yych >= 'n') goto yy343;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy343;
		} else {
			if (yych <= 's') goto yy344;
			if (yych <= 't') goto yy345;
		}
	}
yy197:
#line 1034 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 5011 "real_world/parse_date_b.c"
yy198:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy197;
			goto yy342;
		} else {
			if (yych <= '1') goto yy199;
			if (yych <= 'm') goto yy197;
			goto yy343;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy197;
			goto yy343;
		} else {
			if (yych <= 's') goto yy344;
			if (yych <= 't') goto yy345;
			goto yy197;
		}
	}
yy199:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy342;
		if (yych <= 'm') goto yy197;
		goto yy343;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy197;
			goto yy343;
		} else {
			if (yych <= 's') goto yy344;
			if (yych <= 't') goto yy345;
			goto yy197;
		}
	}
yy200:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy346;
		if (yych <= 'T') goto yy53;
		goto yy347;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy346;
		} else {
			if (yych == 'u') goto yy347;
			goto yy53;
		}
	}
yy201:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy348;
	if (yych == 'e') goto yy348;
	goto yy53;
yy202:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy349;
	if (yych == 'e') goto yy349;
	goto yy53;
yy203:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy350;
		if (yych <= 'T') goto yy53;
		goto yy351;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy350;
		} else {
			if (yych == 'u') goto yy351;
			goto yy53;
		}
	}
yy204:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy352;
	if (yych == 'a') goto yy352;
	goto yy53;
yy205:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy353;
	if (yych == 'o') goto yy353;
	goto yy53;
yy206:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy354;
	if (yych == 'c') goto yy354;
	goto yy53;
yy207:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy355;
	if (yych == 'e') goto yy355;
	goto yy53;
yy208:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy253;
	if (yych <= '/') goto yy176;
	if (yych <= '9') goto yy356;
	goto yy176;
yy209:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy253;
	if (yych <= '/') goto yy176;
	if (yych <= '9') goto yy358;
	goto yy176;
yy210:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy341;
		goto yy192;
	} else {
		if (yych <= '9') goto yy211;
		if (yych <= ':') goto yy341;
		goto yy192;
	}
yy211:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy341;
	if (yych == ':') goto yy341;
	goto yy192;
yy212:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy360;
	if (yych == 'r') goto yy360;
	goto yy53;
yy213:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy361;
	if (yych == 'g') goto yy361;
	goto yy53;
yy214:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy362;
	if (yych == 'y') goto yy362;
	goto yy53;
yy215:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy364;
	if (yych == 'c') goto yy364;
	goto yy53;
yy216:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy365;
	if (yych == 'b') goto yy365;
	goto yy53;
yy217:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy366;
	if (yych == 'r') goto yy366;
	goto yy53;
yy218:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy367;
	if (yych == 'i') goto yy367;
	goto yy53;
yy219:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy368;
	if (yych == 'u') goto yy368;
	goto yy53;
yy220:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if (yych <= 0x1F) goto yy53;
	if (yych <= '.') goto yy220;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy222:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy223;
	if (yych <= '9') goto yy369;
yy223:
#line 1074 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 5206 "real_world/parse_date_b.c"
yy224:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		goto yy74;
	} else {
		if (yych <= '9') goto yy222;
		if (yych != 'I') goto yy74;
	}
yy225:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) goto yy74;
	if (yych <= '.') goto yy220;
	if (yych <= '/') goto yy74;
	if (yych <= '9') goto yy222;
	goto yy74;
yy226:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy370;
	if (yych == 'n') goto yy370;
	goto yy53;
yy227:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy371;
		if (yych <= 'M') goto yy53;
		goto yy372;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy371;
		} else {
			if (yych == 'n') goto yy372;
			goto yy53;
		}
	}
yy228:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy373;
		if (yych <= 'X') goto yy53;
		goto yy225;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy373;
		} else {
			if (yych == 'y') goto yy225;
			goto yy53;
		}
	}
yy229:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy374;
	if (yych == 'n') goto yy374;
	goto yy53;
yy230:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy375;
	if (yych == 'n') goto yy375;
	goto yy53;
yy231:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy364;
	if (yych == 'v') goto yy364;
	goto yy53;
yy232:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy376;
	if (yych == 't') goto yy376;
	goto yy53;
yy233:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy377;
	if (yych == 't') goto yy377;
	goto yy53;
yy234:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy378;
		if (yych <= 'O') goto yy53;
		goto yy379;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy378;
		} else {
			if (yych == 'p') goto yy379;
			goto yy53;
		}
	}
yy235:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy367;
	if (yych == 'n') goto yy367;
	goto yy53;
yy236:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy380;
	if (yych == 'u') goto yy380;
	goto yy53;
yy237:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy381;
	if (yych == 'e') goto yy381;
	goto yy53;
yy238:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy382;
		goto yy383;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy382;
		if (yych <= 'e') goto yy383;
		goto yy53;
	}
yy239:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy368;
	if (yych == 'a') goto yy368;
	goto yy53;
yy240:
	yych = *++YYCURSOR;
	if (yych <= '-') goto yy62;
	if (yych <= '.') goto yy252;
	if (yych <= '/') goto yy246;
	goto yy62;
yy241:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= '-') goto yy62;
		if (yych <= '.') goto yy252;
		if (yych <= '/') goto yy246;
		goto yy62;
	} else {
		if (yych <= 'U') goto yy380;
		if (yych == 'u') goto yy380;
		goto yy62;
	}
yy242:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy384;
		goto yy192;
	} else {
		if (yych <= '9') goto yy385;
		if (yych <= ':') goto yy386;
		goto yy192;
	}
yy243:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy384;
		goto yy192;
	} else {
		if (yych <= '2') goto yy385;
		if (yych <= '9') goto yy387;
		if (yych <= ':') goto yy386;
		goto yy192;
	}
yy244:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy384;
		goto yy192;
	} else {
		if (yych <= '9') goto yy387;
		if (yych <= ':') goto yy386;
		goto yy192;
	}
yy245:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy384;
	if (yych == ':') goto yy386;
	goto yy192;
yy246:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy200;
	case 'D':
	case 'd':	goto yy201;
	case 'F':
	case 'f':	goto yy202;
	case 'J':
	case 'j':	goto yy203;
	case 'M':
	case 'm':	goto yy204;
	case 'N':
	case 'n':	goto yy205;
	case 'O':
	case 'o':	goto yy206;
	case 'S':
	case 's':	goto yy207;
	default:	goto yy53;
	}
yy247:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy386;
		goto yy192;
	} else {
		if (yych <= '9') goto yy387;
		if (yych <= ':') goto yy386;
		goto yy192;
	}
yy248:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy386;
	if (yych == ':') goto yy386;
	goto yy192;
yy249:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy250;
	if (yych != 'm') goto yy53;
yy250:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy388;
yy251:
#line 930 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 5453 "real_world/parse_date_b.c"
yy252:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy62;
	if (yych <= '0') goto yy389;
	if (yych <= '1') goto yy390;
	if (yych <= '9') goto yy391;
	goto yy62;
yy253:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy188;
	case '1':	goto yy189;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy190;
	case 'A':
	case 'a':	goto yy392;
	case 'D':
	case 'd':	goto yy393;
	case 'F':
	case 'f':	goto yy394;
	case 'J':
	case 'j':	goto yy395;
	case 'M':
	case 'm':	goto yy396;
	case 'N':
	case 'n':	goto yy397;
	case 'O':
	case 'o':	goto yy398;
	case 'S':
	case 's':	goto yy399;
	default:	goto yy53;
	}
yy254:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy400;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy400;
		goto yy18;
	}
yy255:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
	} else {
		if (yych <= 'Z') goto yy400;
		if (yych <= '`') goto yy256;
		if (yych <= 'z') goto yy400;
	}
yy256:
#line 1293 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 5527 "real_world/parse_date_b.c"
yy257:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '-') goto yy401;
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			if (yych == 'I') goto yy402;
			goto yy400;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy18;
				goto yy400;
			} else {
				if (yych <= 'i') goto yy402;
				if (yych <= 'z') goto yy400;
				goto yy18;
			}
		}
	}
yy258:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '-') goto yy401;
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			if (yych == 'U') goto yy403;
			goto yy400;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy18;
				goto yy400;
			} else {
				if (yych <= 'u') goto yy403;
				if (yych <= 'z') goto yy400;
				goto yy18;
			}
		}
	}
yy259:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy404;
	goto yy53;
yy260:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych == '/') goto yy259;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '^') goto yy18;
			goto yy259;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy261:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy256;
			goto yy102;
		} else {
			if (yych == '/') goto yy259;
			goto yy256;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '^') goto yy256;
			goto yy259;
		} else {
			if (yych <= '`') goto yy256;
			if (yych <= 'z') goto yy405;
			goto yy256;
		}
	}
yy262:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy401;
				goto yy126;
			} else {
				if (yych <= '/') goto yy259;
				if (yych <= '9') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') {
				if (yych <= 'H') goto yy400;
				goto yy402;
			} else {
				if (yych <= 'Z') goto yy400;
				if (yych <= '^') goto yy18;
				goto yy259;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy18;
				goto yy405;
			} else {
				if (yych <= 'i') goto yy406;
				if (yych <= 'z') goto yy405;
				goto yy18;
			}
		}
	}
yy263:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy401;
				goto yy126;
			} else {
				if (yych <= '/') goto yy259;
				if (yych <= '9') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') {
				if (yych <= 'T') goto yy400;
				goto yy403;
			} else {
				if (yych <= 'Z') goto yy400;
				if (yych <= '^') goto yy18;
				goto yy259;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy18;
				goto yy405;
			} else {
				if (yych <= 'u') goto yy407;
				if (yych <= 'z') goto yy405;
				goto yy18;
			}
		}
	}
yy264:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '-') goto yy401;
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			if (yych == 'E') goto yy408;
			goto yy400;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy400;
			} else {
				if (yych <= 'e') goto yy408;
				if (yych <= 'z') goto yy400;
				goto yy18;
			}
		}
	}
yy265:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy401;
				goto yy126;
			} else {
				if (yych <= '/') goto yy259;
				if (yych <= '9') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy400;
				goto yy408;
			} else {
				if (yych <= 'Z') goto yy400;
				if (yych <= '^') goto yy18;
				goto yy259;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy405;
			} else {
				if (yych <= 'e') goto yy409;
				if (yych <= 'z') goto yy405;
				goto yy18;
			}
		}
	}
yy266:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy400;
			goto yy410;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 'h') goto yy410;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy267:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy400;
			goto yy411;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 'v') goto yy411;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy268:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy400;
			goto yy410;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'h') goto yy412;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy269:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy400;
			goto yy411;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'v') goto yy413;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy270:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '-') goto yy401;
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			if (yych == 'R') goto yy414;
			goto yy400;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy400;
			} else {
				if (yych <= 'r') goto yy414;
				if (yych <= 'z') goto yy400;
				goto yy18;
			}
		}
	}
yy271:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy400;
			goto yy415;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 't') goto yy415;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy272:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy400;
			goto yy410;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 's') goto yy410;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy273:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy400;
			goto yy416;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 'r') goto yy416;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy274:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych >= ')') goto yy102;
		} else {
			if (yych <= '@') goto yy275;
			if (yych <= 'C') goto yy400;
			goto yy417;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy400;
			if (yych >= 'a') goto yy400;
		} else {
			if (yych <= 'd') goto yy417;
			if (yych <= 'z') goto yy400;
		}
	}
yy275:
#line 1308 "real_world/parse_date_b.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 6005 "real_world/parse_date_b.c"
yy276:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy401;
				goto yy126;
			} else {
				if (yych <= '/') goto yy259;
				if (yych <= '9') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') {
				if (yych <= 'Q') goto yy400;
				goto yy414;
			} else {
				if (yych <= 'Z') goto yy400;
				if (yych <= '^') goto yy18;
				goto yy259;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy405;
			} else {
				if (yych <= 'r') goto yy418;
				if (yych <= 'z') goto yy405;
				goto yy18;
			}
		}
	}
yy277:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy400;
			goto yy415;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 't') goto yy419;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy278:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy400;
			goto yy410;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 's') goto yy412;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy279:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy400;
			goto yy416;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'r') goto yy420;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy280:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy275;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy275;
			if (yych <= 'C') goto yy400;
			goto yy417;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy275;
		} else {
			if (yych == 'd') goto yy421;
			if (yych <= 'z') goto yy405;
			goto yy275;
		}
	}
yy281:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 14) YYFILL(14);
	yych = *YYCURSOR;
yy282:
	if (yybm[0+yych] & 64) {
		goto yy281;
	}
	if (yych <= '/') goto yy129;
	if (yych <= '1') goto yy422;
	if (yych <= '2') goto yy423;
	if (yych <= '9') goto yy424;
	goto yy129;
yy283:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych == '.') goto yy425;
		if (yych <= '/') goto yy282;
		goto yy426;
	} else {
		if (yych <= '2') goto yy427;
		if (yych <= '9') goto yy428;
		if (yych <= ':') goto yy429;
		goto yy282;
	}
yy284:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy429;
		goto yy129;
	} else {
		if (yych <= '3') goto yy430;
		if (yych <= '9') goto yy431;
		if (yych <= ':') goto yy429;
		goto yy129;
	}
yy285:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy429;
		goto yy129;
	} else {
		if (yych <= '9') goto yy431;
		if (yych <= ':') goto yy429;
		goto yy129;
	}
yy286:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy429;
		goto yy129;
	} else {
		if (yych <= '9') goto yy430;
		if (yych <= ':') goto yy429;
		goto yy129;
	}
yy287:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych <= ')') goto yy127;
			if (yych <= '.') goto yy126;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			goto yy400;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy288:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '-') goto yy401;
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			if (yych == 'U') goto yy432;
			goto yy400;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy18;
				goto yy400;
			} else {
				if (yych <= 'u') goto yy432;
				if (yych <= 'z') goto yy400;
				goto yy18;
			}
		}
	}
yy289:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '-') goto yy401;
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			if (yych == 'Y') goto yy433;
			goto yy400;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy18;
				goto yy400;
			} else {
				if (yych <= 'y') goto yy433;
				if (yych <= 'z') goto yy400;
				goto yy18;
			}
		}
	}
yy290:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '-') goto yy401;
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			if (yych == 'E') goto yy433;
			goto yy400;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy400;
			} else {
				if (yych <= 'e') goto yy433;
				if (yych <= 'z') goto yy400;
				goto yy18;
			}
		}
	}
yy291:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy401;
				goto yy126;
			} else {
				if (yych <= '/') goto yy259;
				if (yych <= '9') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') {
				if (yych <= 'T') goto yy400;
				goto yy432;
			} else {
				if (yych <= 'Z') goto yy400;
				if (yych <= '^') goto yy18;
				goto yy259;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy18;
				goto yy405;
			} else {
				if (yych <= 'u') goto yy434;
				if (yych <= 'z') goto yy405;
				goto yy18;
			}
		}
	}
yy292:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy401;
				goto yy126;
			} else {
				if (yych <= '/') goto yy259;
				if (yych <= '9') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') {
				if (yych <= 'X') goto yy400;
				goto yy433;
			} else {
				if (yych <= 'Z') goto yy400;
				if (yych <= '^') goto yy18;
				goto yy259;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy18;
				goto yy405;
			} else {
				if (yych <= 'y') goto yy435;
				if (yych <= 'z') goto yy405;
				goto yy18;
			}
		}
	}
yy293:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy401;
				goto yy126;
			} else {
				if (yych <= '/') goto yy259;
				if (yych <= '9') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy400;
				goto yy433;
			} else {
				if (yych <= 'Z') goto yy400;
				if (yych <= '^') goto yy18;
				goto yy259;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy405;
			} else {
				if (yych <= 'e') goto yy435;
				if (yych <= 'z') goto yy405;
				goto yy18;
			}
		}
	}
yy294:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy400;
			goto yy436;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 't') goto yy436;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy295:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy400;
			goto yy436;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 't') goto yy437;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy296:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '-') goto yy401;
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			if (yych == 'C') goto yy438;
			goto yy400;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy18;
				goto yy400;
			} else {
				if (yych <= 'c') goto yy438;
				if (yych <= 'z') goto yy400;
				goto yy18;
			}
		}
	}
yy297:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy18;
			if (yych <= '(') goto yy126;
			goto yy127;
		} else {
			if (yych == '-') goto yy401;
			goto yy126;
		}
	} else {
		if (yych <= '@') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy126;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy298:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy400;
			goto yy439;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 'n') goto yy439;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy299:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy401;
				goto yy126;
			} else {
				if (yych <= '/') goto yy259;
				if (yych <= '9') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy400;
				goto yy438;
			} else {
				if (yych <= 'Z') goto yy400;
				if (yych <= '^') goto yy18;
				goto yy259;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy18;
				goto yy405;
			} else {
				if (yych <= 'c') goto yy440;
				if (yych <= 'z') goto yy405;
				goto yy18;
			}
		}
	}
yy300:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy18;
			if (yych <= '(') goto yy126;
			goto yy127;
		} else {
			if (yych == '-') goto yy401;
			if (yych <= '.') goto yy126;
			goto yy259;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '9') goto yy126;
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy400;
			goto yy18;
		} else {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy301:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy400;
			goto yy439;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'n') goto yy441;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy302:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy400;
			goto yy442;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 'n') goto yy442;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy303:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy102;
	} else {
		if (yych <= 'Z') goto yy400;
		if (yych <= '`') goto yy304;
		if (yych <= 'z') goto yy400;
	}
yy304:
#line 863 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 6678 "real_world/parse_date_b.c"
yy305:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy400;
			goto yy442;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'n') goto yy444;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy306:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy304;
			goto yy102;
		} else {
			if (yych == '/') goto yy259;
			goto yy304;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '^') goto yy304;
			goto yy259;
		} else {
			if (yych <= '`') goto yy304;
			if (yych <= 'z') goto yy405;
			goto yy304;
		}
	}
yy307:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '-') goto yy401;
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			if (yych == 'O') goto yy445;
			goto yy400;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy18;
				goto yy400;
			} else {
				if (yych <= 'o') goto yy445;
				if (yych <= 'z') goto yy400;
				goto yy18;
			}
		}
	}
yy308:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy401;
				goto yy126;
			} else {
				if (yych <= '/') goto yy259;
				if (yych <= '9') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') {
				if (yych <= 'N') goto yy400;
				goto yy445;
			} else {
				if (yych <= 'Z') goto yy400;
				if (yych <= '^') goto yy18;
				goto yy259;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy18;
				goto yy405;
			} else {
				if (yych <= 'o') goto yy446;
				if (yych <= 'z') goto yy405;
				goto yy18;
			}
		}
	}
yy309:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy400;
			goto yy447;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 'v') goto yy447;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy310:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy400;
			goto yy447;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'v') goto yy448;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy311:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy275;
			goto yy102;
		} else {
			if (yych <= '@') goto yy275;
			if (yych <= 'T') goto yy400;
			goto yy449;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy275;
			goto yy400;
		} else {
			if (yych <= 'u') goto yy449;
			if (yych <= 'z') goto yy400;
			goto yy275;
		}
	}
yy312:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy400;
			goto yy450;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 'o') goto yy450;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy313:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '-') goto yy401;
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			if (yych == 'T') goto yy451;
			goto yy400;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy400;
			} else {
				if (yych <= 't') goto yy451;
				if (yych <= 'z') goto yy400;
				goto yy18;
			}
		}
	}
yy314:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy400;
			goto yy452;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 'e') goto yy452;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy315:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy275;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy275;
			if (yych <= 'T') goto yy400;
			goto yy449;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy275;
		} else {
			if (yych == 'u') goto yy453;
			if (yych <= 'z') goto yy405;
			goto yy275;
		}
	}
yy316:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy400;
			goto yy450;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'o') goto yy454;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy317:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy401;
				goto yy126;
			} else {
				if (yych <= '/') goto yy259;
				if (yych <= '9') goto yy126;
				goto yy18;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') {
				if (yych <= 'S') goto yy400;
				goto yy451;
			} else {
				if (yych <= 'Z') goto yy400;
				if (yych <= '^') goto yy18;
				goto yy259;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy405;
			} else {
				if (yych <= 't') goto yy455;
				if (yych <= 'z') goto yy405;
				goto yy18;
			}
		}
	}
yy318:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy400;
			goto yy452;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'e') goto yy456;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy319:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= 'Q') goto yy400;
			if (yych <= 'R') goto yy457;
			goto yy436;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 'r') goto yy457;
			if (yych <= 's') goto yy436;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy320:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy275;
			goto yy102;
		} else {
			if (yych <= '@') goto yy275;
			if (yych <= 'Q') goto yy400;
			goto yy458;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy275;
			goto yy400;
		} else {
			if (yych <= 'r') goto yy458;
			if (yych <= 'z') goto yy400;
			goto yy275;
		}
	}
yy321:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		if (yych <= '@') goto yy18;
		goto yy459;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy459;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy322:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy400;
			goto yy460;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 'o') goto yy460;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy323:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy275;
			goto yy102;
		} else {
			if (yych <= '@') goto yy275;
			if (yych <= 'R') goto yy400;
			goto yy461;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy275;
			goto yy400;
		} else {
			if (yych <= 's') goto yy461;
			if (yych <= 'z') goto yy400;
			goto yy275;
		}
	}
yy324:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy400;
			goto yy462;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 'l') goto yy462;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy325:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '/') {
			if (yych == ')') goto yy102;
			if (yych <= '.') goto yy18;
			goto yy259;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy400;
			if (yych <= 'R') goto yy457;
			goto yy436;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy405;
				goto yy463;
			} else {
				if (yych <= 's') goto yy437;
				if (yych <= 'z') goto yy405;
				goto yy18;
			}
		}
	}
yy326:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy275;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy275;
			if (yych <= 'Q') goto yy400;
			goto yy458;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy275;
		} else {
			if (yych == 'r') goto yy464;
			if (yych <= 'z') goto yy405;
			goto yy275;
		}
	}
yy327:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			goto yy459;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '^') goto yy18;
			goto yy259;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy465;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy328:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy400;
			goto yy460;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'o') goto yy466;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy329:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy275;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy275;
			if (yych <= 'R') goto yy400;
			goto yy461;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy275;
		} else {
			if (yych == 's') goto yy467;
			if (yych <= 'z') goto yy405;
			goto yy275;
		}
	}
yy330:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy400;
			goto yy462;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'l') goto yy468;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy331:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy18;
			if (yych <= '(') goto yy126;
			goto yy127;
		} else {
			if (yych == '/') goto yy18;
			goto yy126;
		}
	} else {
		if (yych <= 'I') {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy400;
			goto yy433;
		} else {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy332:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy275;
			goto yy102;
		} else {
			if (yych <= '@') goto yy275;
			if (yych <= 'M') goto yy400;
			goto yy469;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy275;
			goto yy400;
		} else {
			if (yych <= 'n') goto yy469;
			if (yych <= 'z') goto yy400;
			goto yy275;
		}
	}
yy333:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy275;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy275;
			if (yych <= 'M') goto yy400;
			goto yy469;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy275;
		} else {
			if (yych == 'n') goto yy470;
			if (yych <= 'z') goto yy405;
			goto yy275;
		}
	}
yy334:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy102;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy400;
			goto yy471;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy400;
			if (yych <= '`') goto yy18;
			goto yy400;
		} else {
			if (yych <= 't') goto yy471;
			if (yych <= 'z') goto yy400;
			goto yy18;
		}
	}
yy335:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy400;
			goto yy471;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy400;
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 't') goto yy472;
			if (yych <= 'z') goto yy405;
			goto yy18;
		}
	}
yy336:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy378;
	if (yych == 'c') goto yy378;
	goto yy53;
yy337:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '9') goto yy102;
	goto yy18;
yy338:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy379;
	if (yych == 'p') goto yy379;
	goto yy53;
yy339:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy473;
	if (yych <= '3') goto yy475;
	if (yych <= '9') goto yy476;
	goto yy53;
yy340:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy477;
	if (yych <= '6') goto yy478;
	if (yych <= '9') goto yy479;
	goto yy53;
yy341:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy480;
	if (yych <= '6') goto yy481;
	if (yych <= '9') goto yy482;
	goto yy53;
yy342:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy483;
	goto yy53;
yy343:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy484;
	goto yy53;
yy344:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy484;
	goto yy53;
yy345:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy484;
	goto yy53;
yy346:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy485;
	if (yych == 'r') goto yy485;
	goto yy53;
yy347:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy485;
	if (yych == 'g') goto yy485;
	goto yy53;
yy348:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy485;
	if (yych == 'c') goto yy485;
	goto yy53;
yy349:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy485;
	if (yych == 'b') goto yy485;
	goto yy53;
yy350:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy485;
	if (yych == 'n') goto yy485;
	goto yy53;
yy351:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy485;
		if (yych <= 'M') goto yy53;
		goto yy485;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy485;
		} else {
			if (yych == 'n') goto yy485;
			goto yy53;
		}
	}
yy352:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy485;
		if (yych <= 'X') goto yy53;
		goto yy485;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy485;
		} else {
			if (yych == 'y') goto yy485;
			goto yy53;
		}
	}
yy353:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy485;
	if (yych == 'v') goto yy485;
	goto yy53;
yy354:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy485;
	if (yych == 't') goto yy485;
	goto yy53;
yy355:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy486;
	if (yych == 'p') goto yy486;
	goto yy53;
yy356:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy488;
	case '-':	goto yy491;
	case '.':	goto yy492;
	case '/':	goto yy493;
	case '0':	goto yy494;
	case '1':	goto yy495;
	case '2':	goto yy496;
	case '3':	goto yy497;
	case '4':
	case '5':	goto yy498;
	case '6':	goto yy499;
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy500;
	case 'W':	goto yy512;
	default:	goto yy357;
	}
yy357:
#line 971 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 7643 "real_world/parse_date_b.c"
yy358:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy488;
	case '-':	goto yy491;
	case '.':	goto yy492;
	case '/':	goto yy493;
	case '0':	goto yy514;
	case '1':	goto yy515;
	case '2':	goto yy516;
	case '3':	goto yy517;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy500;
	case 'W':	goto yy512;
	default:	goto yy359;
	}
yy359:
#line 1284 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 7713 "real_world/parse_date_b.c"
yy360:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		if (yych <= '/') goto yy74;
		goto yy222;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy74;
			goto yy518;
		} else {
			if (yych == 'i') goto yy518;
			goto yy74;
		}
	}
yy361:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		if (yych <= '/') goto yy74;
		goto yy222;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy74;
			goto yy519;
		} else {
			if (yych == 'u') goto yy519;
			goto yy74;
		}
	}
yy362:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy520;
	if (yych == 's') goto yy520;
yy363:
#line 1380 "real_world/parse_date_b.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7768 "real_world/parse_date_b.c"
yy364:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		if (yych <= '/') goto yy74;
		goto yy222;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy74;
			goto yy521;
		} else {
			if (yych == 'e') goto yy521;
			goto yy74;
		}
	}
yy365:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		if (yych <= '/') goto yy74;
		goto yy222;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy74;
			goto yy522;
		} else {
			if (yych == 'r') goto yy522;
			goto yy74;
		}
	}
yy366:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy523;
	if (yych == 't') goto yy523;
	goto yy53;
yy367:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy524;
	if (yych == 'd') goto yy524;
	goto yy363;
yy368:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy362;
	if (yych == 'r') goto yy362;
	goto yy53;
yy369:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy223;
	if (yych <= '9') goto yy525;
	goto yy223;
yy370:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		if (yych <= '/') goto yy74;
		goto yy222;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy74;
			goto yy526;
		} else {
			if (yych == 'u') goto yy526;
			goto yy74;
		}
	}
yy371:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		if (yych <= '/') goto yy74;
		goto yy222;
	} else {
		if (yych <= 'Y') {
			if (yych <= 'X') goto yy74;
			goto yy225;
		} else {
			if (yych == 'y') goto yy225;
			goto yy74;
		}
	}
yy372:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		if (yych <= '/') goto yy74;
		goto yy222;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy74;
			goto yy225;
		} else {
			if (yych == 'e') goto yy225;
			goto yy74;
		}
	}
yy373:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		if (yych <= '/') goto yy74;
		goto yy222;
	} else {
		if (yych <= 'C') {
			if (yych <= 'B') goto yy74;
			goto yy527;
		} else {
			if (yych == 'c') goto yy527;
			goto yy74;
		}
	}
yy374:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy520;
		if (yych <= 'T') goto yy363;
		goto yy528;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy363;
			goto yy520;
		} else {
			if (yych == 'u') goto yy528;
			goto yy363;
		}
	}
yy375:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy524;
		if (yych <= 'S') goto yy363;
		goto yy529;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy363;
			goto yy524;
		} else {
			if (yych == 't') goto yy529;
			goto yy363;
		}
	}
yy376:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		if (yych <= '/') goto yy74;
		goto yy222;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy74;
			goto yy530;
		} else {
			if (yych == 'o') goto yy530;
			goto yy74;
		}
	}
yy377:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy531;
	if (yych == 'u') goto yy531;
	goto yy363;
yy378:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy532;
		if (yych <= 'R') goto yy363;
		goto yy520;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy363;
			goto yy532;
		} else {
			if (yych == 's') goto yy520;
			goto yy363;
		}
	}
yy379:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy74;
		if (yych <= '.') goto yy220;
		if (yych <= '/') goto yy74;
		goto yy222;
	} else {
		if (yych <= 'T') {
			if (yych <= 'S') goto yy74;
			goto yy364;
		} else {
			if (yych == 't') goto yy364;
			goto yy74;
		}
	}
yy380:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy533;
	if (yych == 'r') goto yy533;
	goto yy363;
yy381:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy534;
	if (yych == 's') goto yy534;
	goto yy363;
yy382:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy535;
	if (yych == 'n') goto yy535;
	goto yy363;
yy383:
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy362;
	if (yych == 'k') goto yy362;
	goto yy53;
yy384:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy536;
	if (yych <= '6') goto yy537;
	if (yych <= '9') goto yy479;
	goto yy53;
yy385:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych == ' ') goto yy538;
			goto yy192;
		} else {
			if (yych <= '.') goto yy384;
			if (yych != ':') goto yy192;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy95;
			if (yych == 'P') goto yy95;
			goto yy192;
		} else {
			if (yych <= 'a') goto yy95;
			if (yych == 'p') goto yy95;
			goto yy192;
		}
	}
yy386:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy540;
	if (yych <= '6') goto yy541;
	if (yych <= '9') goto yy482;
	goto yy53;
yy387:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych == ' ') goto yy538;
			goto yy192;
		} else {
			if (yych <= '.') goto yy386;
			if (yych == ':') goto yy386;
			goto yy192;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy95;
			if (yych == 'P') goto yy95;
			goto yy192;
		} else {
			if (yych <= 'a') goto yy95;
			if (yych == 'p') goto yy95;
			goto yy192;
		}
	}
yy388:
	++YYCURSOR;
	goto yy251;
yy389:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy542;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy391;
	goto yy53;
yy390:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy542;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy391:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy542;
	goto yy53;
yy392:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy543;
		if (yych <= 'T') goto yy53;
		goto yy544;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy543;
		} else {
			if (yych == 'u') goto yy544;
			goto yy53;
		}
	}
yy393:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy545;
	if (yych == 'e') goto yy545;
	goto yy53;
yy394:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy546;
	if (yych == 'e') goto yy546;
	goto yy53;
yy395:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy547;
		if (yych <= 'T') goto yy53;
		goto yy548;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy547;
		} else {
			if (yych == 'u') goto yy548;
			goto yy53;
		}
	}
yy396:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy549;
	if (yych == 'a') goto yy549;
	goto yy53;
yy397:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy550;
	if (yych == 'o') goto yy550;
	goto yy53;
yy398:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy551;
	if (yych == 'c') goto yy551;
	goto yy53;
yy399:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy552;
	if (yych == 'e') goto yy552;
	goto yy53;
yy400:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy102;
	goto yy18;
yy401:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy126;
	if (yych <= '0') goto yy553;
	if (yych <= '2') goto yy554;
	if (yych <= '3') goto yy555;
	goto yy126;
yy402:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'L') goto yy125;
		if (yych == 'l') goto yy125;
		goto yy18;
	}
yy403:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'S') goto yy556;
		if (yych == 's') goto yy556;
		goto yy18;
	}
yy404:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 128) {
		goto yy557;
	}
	goto yy53;
yy405:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy102;
		if (yych <= '.') goto yy18;
		goto yy259;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy18;
			goto yy259;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy406:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'K') goto yy18;
			goto yy125;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'l') goto yy561;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy407:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'R') goto yy18;
			goto yy556;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 's') goto yy562;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy408:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'M') goto yy563;
		if (yych == 'm') goto yy563;
		goto yy18;
	}
yy409:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'L') goto yy18;
			goto yy563;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'm') goto yy564;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy410:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'T') goto yy565;
		if (yych == 't') goto yy565;
		goto yy18;
	}
yy411:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'E') goto yy567;
		if (yych == 'e') goto yy567;
		goto yy18;
	}
yy412:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'S') goto yy18;
			goto yy565;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 't') goto yy568;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy413:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'D') goto yy18;
			goto yy567;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'e') goto yy569;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy414:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'U') goto yy570;
		if (yych == 'u') goto yy570;
		goto yy18;
	}
yy415:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'H') goto yy565;
		if (yych == 'h') goto yy565;
		goto yy18;
	}
yy416:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'T') goto yy571;
		if (yych == 't') goto yy571;
		goto yy18;
	}
yy417:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'A') goto yy572;
		if (yych == 'a') goto yy572;
		goto yy18;
	}
yy418:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'T') goto yy18;
			goto yy570;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'u') goto yy573;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy419:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'G') goto yy18;
			goto yy565;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'h') goto yy568;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy420:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'S') goto yy18;
			goto yy571;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 't') goto yy574;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy421:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			goto yy572;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy575;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy422:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy429;
		goto yy129;
	} else {
		if (yych <= '9') goto yy576;
		if (yych <= ':') goto yy429;
		goto yy129;
	}
yy423:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy429;
		goto yy129;
	} else {
		if (yych <= '3') goto yy576;
		if (yych <= '9') goto yy577;
		if (yych <= ':') goto yy429;
		goto yy129;
	}
yy424:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy429;
		goto yy129;
	} else {
		if (yych <= '9') goto yy577;
		if (yych <= ':') goto yy429;
		goto yy129;
	}
yy425:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy282;
		if (yych <= '1') goto yy578;
		goto yy579;
	} else {
		if (yych <= '5') goto yy580;
		if (yych <= '9') goto yy581;
		goto yy282;
	}
yy426:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy429;
		goto yy129;
	} else {
		if (yych <= '9') goto yy582;
		if (yych <= ':') goto yy429;
		goto yy129;
	}
yy427:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy429;
		goto yy129;
	} else {
		if (yych <= '3') goto yy582;
		if (yych <= '9') goto yy584;
		if (yych <= ':') goto yy429;
		goto yy129;
	}
yy428:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy129;
	} else {
		if (yych <= '9') goto yy584;
		if (yych >= ';') goto yy129;
	}
yy429:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy585;
	if (yych <= '9') goto yy587;
	goto yy53;
yy430:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy429;
		goto yy129;
	} else {
		if (yych <= '9') goto yy588;
		if (yych <= ':') goto yy429;
		goto yy129;
	}
yy431:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy129;
	if (yych <= '9') goto yy588;
	goto yy129;
yy432:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'A') goto yy589;
		if (yych == 'a') goto yy589;
		goto yy18;
	}
yy433:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= 0x1F) goto yy18;
		if (yych <= '(') goto yy126;
		goto yy127;
	} else {
		if (yych == '/') goto yy18;
		if (yych <= '9') goto yy126;
		goto yy18;
	}
yy434:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy18;
			goto yy589;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy590;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy435:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= 0x1F) goto yy18;
			goto yy126;
		} else {
			if (yych <= ')') goto yy127;
			if (yych <= '.') goto yy126;
			goto yy259;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '9') goto yy126;
			if (yych <= '^') goto yy18;
			goto yy259;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy436:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy566;
	case ')':	goto yy102;
	default:	goto yy18;
	}
yy437:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':	goto yy566;
	case ')':	goto yy102;
	case '/':
	case '_':	goto yy259;
	case 'a':
	case 'b':
	case 'c':
	case 'e':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy559;
	case 'd':	goto yy599;
	case 'f':	goto yy600;
	case 'h':	goto yy601;
	case 'm':	goto yy602;
	case 's':	goto yy603;
	case 't':	goto yy604;
	case 'w':	goto yy605;
	case 'y':	goto yy606;
	default:	goto yy18;
	}
yy438:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'H') goto yy125;
		if (yych == 'h') goto yy125;
		goto yy18;
	}
yy439:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'I') goto yy607;
		if (yych == 'i') goto yy607;
		goto yy18;
	}
yy440:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'G') goto yy18;
			goto yy125;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'h') goto yy561;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy441:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'H') goto yy18;
			goto yy607;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'i') goto yy608;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy442:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy102;
yy443:
#line 872 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 8789 "real_world/parse_date_b.c"
yy444:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy102;
		if (yych <= '.') goto yy443;
		goto yy259;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy443;
			goto yy259;
		} else {
			if (yych <= '`') goto yy443;
			if (yych <= 'z') goto yy559;
			goto yy443;
		}
	}
yy445:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'B') goto yy609;
		if (yych == 'b') goto yy609;
		goto yy18;
	}
yy446:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'A') goto yy18;
			goto yy609;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'b') goto yy610;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy447:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'I') goto yy611;
		if (yych == 'i') goto yy611;
		goto yy18;
	}
yy448:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'H') goto yy18;
			goto yy611;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'i') goto yy612;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy449:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'R') goto yy613;
		if (yych == 'r') goto yy613;
		goto yy18;
	}
yy450:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'N') goto yy614;
		if (yych == 'n') goto yy614;
		goto yy18;
	}
yy451:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy18;
			if (yych <= '(') goto yy126;
			goto yy127;
		} else {
			if (yych == '-') goto yy401;
			goto yy126;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy126;
			goto yy18;
		} else {
			if (yych <= 'E') goto yy615;
			if (yych == 'e') goto yy615;
			goto yy18;
		}
	}
yy452:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'N') goto yy616;
		if (yych == 'n') goto yy616;
		goto yy18;
	}
yy453:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'Q') goto yy18;
			goto yy613;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'r') goto yy617;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy454:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'M') goto yy18;
			goto yy614;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'n') goto yy618;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy455:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy18;
			if (yych == ')') goto yy127;
			goto yy126;
		} else {
			if (yych <= '-') goto yy401;
			if (yych == '/') goto yy259;
			goto yy126;
		}
	} else {
		if (yych <= '_') {
			if (yych == 'E') goto yy615;
			if (yych <= '^') goto yy18;
			goto yy259;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy559;
			} else {
				if (yych <= 'e') goto yy619;
				if (yych <= 'z') goto yy559;
				goto yy18;
			}
		}
	}
yy456:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'M') goto yy18;
			goto yy616;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'n') goto yy620;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy457:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'D') goto yy565;
		if (yych == 'd') goto yy565;
		goto yy18;
	}
yy458:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'S') goto yy613;
		if (yych == 's') goto yy613;
		goto yy18;
	}
yy459:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy621;
		if (yych == 'y') goto yy621;
		goto yy18;
	}
yy460:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'R') goto yy623;
		if (yych == 'r') goto yy623;
		goto yy18;
	}
yy461:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'D') goto yy624;
		if (yych == 'd') goto yy624;
		goto yy18;
	}
yy462:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'F') goto yy616;
		if (yych == 'f') goto yy616;
		goto yy18;
	}
yy463:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'C') goto yy18;
			goto yy565;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'd') goto yy568;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy464:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'R') goto yy18;
			goto yy613;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 's') goto yy617;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy465:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'X') goto yy18;
			goto yy621;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'y') goto yy625;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy466:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'Q') goto yy18;
			goto yy623;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'r') goto yy626;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy467:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'C') goto yy18;
			goto yy624;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'd') goto yy627;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy468:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'E') goto yy18;
			goto yy616;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'f') goto yy620;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy469:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'E') goto yy628;
		if (yych == 'e') goto yy628;
		goto yy18;
	}
yy470:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'D') goto yy18;
			goto yy628;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'e') goto yy629;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy471:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy102;
		goto yy18;
	} else {
		if (yych <= 'E') goto yy630;
		if (yych == 'e') goto yy630;
		goto yy18;
	}
yy472:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy102;
			goto yy18;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'D') goto yy18;
			goto yy630;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy18;
		} else {
			if (yych == 'e') goto yy631;
			if (yych <= 'z') goto yy559;
			goto yy18;
		}
	}
yy473:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy474;
		if (yych <= '9') goto yy476;
		if (yych >= 'n') goto yy632;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy632;
		} else {
			if (yych <= 's') goto yy633;
			if (yych <= 't') goto yy634;
		}
	}
yy474:
#line 1061 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 9315 "real_world/parse_date_b.c"
yy475:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy474;
		if (yych <= '1') goto yy476;
		if (yych <= 'm') goto yy474;
		goto yy632;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy474;
			goto yy632;
		} else {
			if (yych <= 's') goto yy633;
			if (yych <= 't') goto yy634;
			goto yy474;
		}
	}
yy476:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy632;
		goto yy474;
	} else {
		if (yych <= 'r') goto yy632;
		if (yych <= 's') goto yy633;
		if (yych <= 't') goto yy634;
		goto yy474;
	}
yy477:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy635;
	if (yych <= '/') goto yy192;
	if (yych <= '9') goto yy636;
	goto yy192;
yy478:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy635;
		goto yy192;
	} else {
		if (yych <= '0') goto yy636;
		if (yych <= '9') goto yy637;
		goto yy192;
	}
yy479:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy635;
	if (yych <= '/') goto yy192;
	if (yych <= '9') goto yy637;
	goto yy192;
yy480:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy635;
	if (yych <= '/') goto yy192;
	if (yych <= '9') goto yy482;
	goto yy192;
yy481:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy635;
	if (yych != '0') goto yy192;
yy482:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy635;
	goto yy192;
yy483:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy197;
	if (yych <= '9') goto yy639;
	goto yy197;
yy484:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy342;
	goto yy197;
yy485:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy640;
	goto yy53;
yy486:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy640;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy485;
		if (yych == 't') goto yy485;
		goto yy53;
	}
yy487:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy488:
	switch (yych) {
	case ' ':	goto yy487;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy489;
	case 'A':
	case 'a':	goto yy501;
	case 'D':
	case 'd':	goto yy502;
	case 'F':
	case 'f':	goto yy503;
	case 'H':
	case 'h':	goto yy72;
	case 'I':	goto yy504;
	case 'J':
	case 'j':	goto yy506;
	case 'M':
	case 'm':	goto yy507;
	case 'N':
	case 'n':	goto yy508;
	case 'O':
	case 'o':	goto yy509;
	case 'S':
	case 's':	goto yy510;
	case 'T':
	case 't':	goto yy80;
	case 'V':	goto yy511;
	case 'W':
	case 'w':	goto yy82;
	case 'X':	goto yy513;
	case 'Y':
	case 'y':	goto yy84;
	default:	goto yy53;
	}
yy489:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy490:
	switch (yych) {
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy489;
	case 'A':
	case 'a':	goto yy501;
	case 'D':
	case 'd':	goto yy641;
	case 'F':
	case 'f':	goto yy642;
	case 'I':	goto yy504;
	case 'J':
	case 'j':	goto yy506;
	case 'M':
	case 'm':	goto yy643;
	case 'N':
	case 'n':	goto yy508;
	case 'O':
	case 'o':	goto yy509;
	case 'S':
	case 's':	goto yy644;
	case 'V':	goto yy511;
	case 'X':	goto yy513;
	default:	goto yy53;
	}
yy491:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy645;
	case '1':	goto yy646;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy647;
	case 'A':
	case 'a':	goto yy648;
	case 'D':
	case 'd':	goto yy649;
	case 'F':
	case 'f':	goto yy650;
	case 'J':
	case 'j':	goto yy651;
	case 'M':
	case 'm':	goto yy652;
	case 'N':
	case 'n':	goto yy653;
	case 'O':
	case 'o':	goto yy654;
	case 'S':
	case 's':	goto yy655;
	default:	goto yy490;
	}
yy492:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy490;
	if (yych <= '0') goto yy656;
	if (yych <= '2') goto yy657;
	if (yych <= '3') goto yy658;
	goto yy490;
yy493:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy659;
	if (yych <= '1') goto yy660;
	if (yych <= '9') goto yy661;
	goto yy53;
yy494:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '0') goto yy662;
	if (yych <= '9') goto yy664;
	goto yy176;
yy495:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '2') goto yy664;
	if (yych <= '9') goto yy665;
	goto yy176;
yy496:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '9') goto yy665;
	goto yy176;
yy497:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '5') goto yy665;
	if (yych <= '6') goto yy666;
	if (yych <= '9') goto yy667;
	goto yy176;
yy498:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '9') goto yy667;
	goto yy176;
yy499:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '0') goto yy667;
	if (yych <= '9') goto yy54;
	goto yy176;
yy500:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy668;
	if (yych <= '1') goto yy669;
	goto yy53;
yy501:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy670;
		if (yych <= 'T') goto yy53;
		goto yy671;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy670;
		} else {
			if (yych == 'u') goto yy671;
			goto yy53;
		}
	}
yy502:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy214;
		if (yych <= 'D') goto yy53;
		goto yy672;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy214;
		} else {
			if (yych == 'e') goto yy672;
			goto yy53;
		}
	}
yy503:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy673;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy217;
			if (yych <= 'Q') goto yy53;
			goto yy218;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy673;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy217;
			if (yych == 'r') goto yy218;
			goto yy53;
		}
	}
yy504:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'I') goto yy674;
	} else {
		if (yych == 'W') goto yy505;
		if (yych <= 'X') goto yy675;
	}
yy505:
#line 1114 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 9662 "real_world/parse_date_b.c"
yy506:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy676;
		if (yych <= 'T') goto yy53;
		goto yy677;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy676;
		} else {
			if (yych == 'u') goto yy677;
			goto yy53;
		}
	}
yy507:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy678;
			goto yy53;
		} else {
			if (yych <= 'I') goto yy229;
			if (yych <= 'N') goto yy53;
			goto yy230;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy678;
			goto yy53;
		} else {
			if (yych <= 'i') goto yy229;
			if (yych == 'o') goto yy230;
			goto yy53;
		}
	}
yy508:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy679;
	if (yych == 'o') goto yy679;
	goto yy53;
yy509:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy680;
	if (yych == 'c') goto yy680;
	goto yy53;
yy510:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy233;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy681;
			if (yych <= 'T') goto yy53;
			goto yy235;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy233;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy681;
			if (yych == 'u') goto yy235;
			goto yy53;
		}
	}
yy511:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy513;
	goto yy505;
yy512:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '0') goto yy682;
		if (yych <= '4') goto yy683;
		goto yy684;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy53;
			goto yy238;
		} else {
			if (yych == 'e') goto yy238;
			goto yy53;
		}
	}
yy513:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy674;
	goto yy505;
yy514:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '0') goto yy685;
	if (yych <= '9') goto yy686;
	goto yy176;
yy515:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '2') goto yy686;
	if (yych <= '9') goto yy687;
	goto yy176;
yy516:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '9') goto yy687;
	goto yy176;
yy517:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '5') goto yy687;
	if (yych <= '6') goto yy688;
	if (yych <= '9') goto yy54;
	goto yy176;
yy518:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy225;
	if (yych == 'l') goto yy225;
	goto yy53;
yy519:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy689;
	if (yych == 's') goto yy689;
	goto yy53;
yy520:
	++YYCURSOR;
	goto yy363;
yy521:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy530;
	if (yych == 'm') goto yy530;
	goto yy53;
yy522:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy526;
	if (yych == 'u') goto yy526;
	goto yy53;
yy523:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy690;
		if (yych <= 'M') goto yy53;
		goto yy691;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy690;
		} else {
			if (yych == 'n') goto yy691;
			goto yy53;
		}
	}
yy524:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy692;
	if (yych == 'a') goto yy692;
	goto yy53;
yy525:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy223;
	if (yych <= '9') goto yy693;
	goto yy223;
yy526:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy694;
	if (yych == 'a') goto yy694;
	goto yy53;
yy527:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy225;
	if (yych == 'h') goto yy225;
	goto yy53;
yy528:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy695;
	if (yych == 't') goto yy695;
	goto yy53;
yy529:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy362;
	if (yych == 'h') goto yy362;
	goto yy53;
yy530:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy696;
	if (yych == 'b') goto yy696;
	goto yy53;
yy531:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy534;
	if (yych == 'r') goto yy534;
	goto yy53;
yy532:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy697;
	if (yych == 'n') goto yy697;
	goto yy53;
yy533:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy534;
	if (yych != 's') goto yy53;
yy534:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy524;
	if (yych == 'd') goto yy524;
	goto yy53;
yy535:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy533;
	if (yych == 'e') goto yy533;
	goto yy53;
yy536:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy635;
	if (yych <= '/') goto yy192;
	if (yych <= '9') goto yy698;
	goto yy192;
yy537:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy635;
		goto yy192;
	} else {
		if (yych <= '0') goto yy698;
		if (yych <= '9') goto yy637;
		goto yy192;
	}
yy538:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ' ') {
			if (yych <= 0x1F) goto yy53;
			goto yy538;
		} else {
			if (yych == 'A') goto yy95;
			goto yy53;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy95;
			if (yych <= '`') goto yy53;
			goto yy95;
		} else {
			if (yych == 'p') goto yy95;
			goto yy53;
		}
	}
yy540:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy635;
	if (yych <= '/') goto yy192;
	if (yych <= '9') goto yy699;
	goto yy192;
yy541:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy635;
	if (yych == '0') goto yy699;
	goto yy192;
yy542:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy700;
	goto yy53;
yy543:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy701;
	if (yych == 'r') goto yy701;
	goto yy53;
yy544:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy701;
	if (yych == 'g') goto yy701;
	goto yy53;
yy545:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy701;
	if (yych == 'c') goto yy701;
	goto yy53;
yy546:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy701;
	if (yych == 'b') goto yy701;
	goto yy53;
yy547:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy701;
	if (yych == 'n') goto yy701;
	goto yy53;
yy548:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy701;
		if (yych <= 'M') goto yy53;
		goto yy701;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy701;
		} else {
			if (yych == 'n') goto yy701;
			goto yy53;
		}
	}
yy549:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy701;
		if (yych <= 'X') goto yy53;
		goto yy701;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy701;
		} else {
			if (yych == 'y') goto yy701;
			goto yy53;
		}
	}
yy550:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy701;
	if (yych == 'v') goto yy701;
	goto yy53;
yy551:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy701;
	if (yych == 't') goto yy701;
	goto yy53;
yy552:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy702;
	if (yych == 'p') goto yy702;
	goto yy53;
yy553:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy282;
	if (yych <= '0') goto yy283;
	if (yych <= '9') goto yy703;
	goto yy282;
yy554:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy282;
	if (yych <= '9') goto yy703;
	goto yy282;
yy555:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy282;
	if (yych <= '1') goto yy703;
	if (yych <= '2') goto yy284;
	if (yych <= '9') goto yy285;
	goto yy282;
yy556:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy125;
	if (yych == 't') goto yy125;
	goto yy53;
yy557:
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 128) {
		goto yy557;
	}
	if (yych == '/') goto yy259;
	if (yych == '_') goto yy259;
	goto yy18;
yy559:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy560:
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy53;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy53;
		if (yych <= 'z') goto yy559;
		goto yy53;
	}
yy561:
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy126;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy126;
		if (yych <= 'z') goto yy559;
		goto yy126;
	}
yy562:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy125;
	if (yych == 't') goto yy561;
	goto yy560;
yy563:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy609;
	if (yych == 'b') goto yy609;
	goto yy53;
yy564:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy609;
	if (yych == 'b') goto yy610;
	goto yy560;
yy565:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy566:
	switch (yych) {
	case ' ':	goto yy565;
	case 'D':
	case 'd':	goto yy591;
	case 'F':
	case 'f':	goto yy592;
	case 'H':
	case 'h':	goto yy593;
	case 'M':
	case 'm':	goto yy594;
	case 'S':
	case 's':	goto yy595;
	case 'T':
	case 't':	goto yy596;
	case 'W':
	case 'w':	goto yy597;
	case 'Y':
	case 'y':	goto yy598;
	default:	goto yy53;
	}
yy567:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy616;
	if (yych == 'n') goto yy616;
	goto yy53;
yy568:
	yych = *++YYCURSOR;
	if (yych <= 'h') {
		if (yych <= '`') {
			if (yych <= '/') {
				if (yych <= '.') goto yy566;
				goto yy259;
			} else {
				if (yych == '_') goto yy259;
				goto yy566;
			}
		} else {
			if (yych <= 'e') {
				if (yych == 'd') goto yy599;
				goto yy559;
			} else {
				if (yych <= 'f') goto yy600;
				if (yych <= 'g') goto yy559;
				goto yy601;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy559;
				goto yy602;
			} else {
				if (yych <= 'r') goto yy559;
				if (yych <= 's') goto yy603;
				goto yy604;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'w') goto yy605;
				goto yy559;
			} else {
				if (yych <= 'y') goto yy606;
				if (yych <= 'z') goto yy559;
				goto yy566;
			}
		}
	}
yy569:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy616;
	if (yych == 'n') goto yy620;
	goto yy560;
yy570:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy589;
	if (yych == 'a') goto yy589;
	goto yy53;
yy571:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy565;
	if (yych == 'h') goto yy565;
	goto yy53;
yy572:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy704;
	if (yych == 'y') goto yy704;
	goto yy53;
yy573:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy589;
	if (yych == 'a') goto yy590;
	goto yy560;
yy574:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy565;
	if (yych == 'h') goto yy568;
	goto yy560;
yy575:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy704;
	if (yych == 'y') goto yy705;
	goto yy560;
yy576:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy429;
		goto yy129;
	} else {
		if (yych <= '9') goto yy706;
		if (yych <= ':') goto yy429;
		goto yy129;
	}
yy577:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy129;
	if (yych <= '9') goto yy706;
	goto yy129;
yy578:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy707;
		goto yy129;
	} else {
		if (yych <= '9') goto yy708;
		if (yych <= ':') goto yy707;
		goto yy129;
	}
yy579:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy707;
		goto yy129;
	} else {
		if (yych <= '3') goto yy708;
		if (yych <= '9') goto yy709;
		if (yych <= ':') goto yy707;
		goto yy129;
	}
yy580:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy707;
		goto yy129;
	} else {
		if (yych <= '9') goto yy709;
		if (yych <= ':') goto yy707;
		goto yy129;
	}
yy581:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy707;
		goto yy129;
	} else {
		if (yych <= '9') goto yy577;
		if (yych <= ':') goto yy707;
		goto yy129;
	}
yy582:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy429;
	} else {
		if (yych <= '9') goto yy706;
		if (yych <= ':') goto yy429;
	}
yy583:
#line 1101 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 10267 "real_world/parse_date_b.c"
yy584:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy583;
	if (yych <= '9') goto yy706;
	goto yy583;
yy585:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy710;
	} else {
		if (yych <= '9') goto yy587;
		if (yych <= ':') goto yy710;
	}
yy586:
#line 1352 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 10310 "real_world/parse_date_b.c"
yy587:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy710;
	if (yych == ':') goto yy710;
	goto yy586;
yy588:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy583;
	if (yych <= '9') goto yy711;
	goto yy583;
yy589:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy712;
	if (yych == 'r') goto yy712;
	goto yy53;
yy590:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy712;
	if (yych == 'r') goto yy713;
	goto yy560;
yy591:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy714;
	if (yych == 'a') goto yy714;
	goto yy53;
yy592:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy715;
		if (yych <= 'Q') goto yy53;
		goto yy716;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy715;
		} else {
			if (yych == 'r') goto yy716;
			goto yy53;
		}
	}
yy593:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy717;
	if (yych == 'o') goto yy717;
	goto yy53;
yy594:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy718;
		if (yych <= 'N') goto yy53;
		goto yy719;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy53;
			goto yy718;
		} else {
			if (yych == 'o') goto yy719;
			goto yy53;
		}
	}
yy595:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy720;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy721;
			if (yych <= 'T') goto yy53;
			goto yy722;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy720;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy721;
			if (yych == 'u') goto yy722;
			goto yy53;
		}
	}
yy596:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy723;
		if (yych <= 'T') goto yy53;
		goto yy724;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy723;
		} else {
			if (yych == 'u') goto yy724;
			goto yy53;
		}
	}
yy597:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy725;
	if (yych == 'e') goto yy725;
	goto yy53;
yy598:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy726;
	if (yych == 'e') goto yy726;
	goto yy53;
yy599:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy714;
	if (yych == 'a') goto yy727;
	goto yy560;
yy600:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy715;
		if (yych <= 'Q') goto yy560;
		goto yy716;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy560;
			goto yy728;
		} else {
			if (yych == 'r') goto yy729;
			goto yy560;
		}
	}
yy601:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy717;
	if (yych == 'o') goto yy730;
	goto yy560;
yy602:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy718;
		if (yych <= 'N') goto yy560;
		goto yy719;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy560;
			goto yy731;
		} else {
			if (yych == 'o') goto yy732;
			goto yy560;
		}
	}
yy603:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy720;
			goto yy560;
		} else {
			if (yych <= 'E') goto yy721;
			if (yych <= 'T') goto yy560;
			goto yy722;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy733;
			goto yy560;
		} else {
			if (yych <= 'e') goto yy734;
			if (yych == 'u') goto yy735;
			goto yy560;
		}
	}
yy604:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy723;
		if (yych <= 'T') goto yy560;
		goto yy724;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy560;
			goto yy736;
		} else {
			if (yych == 'u') goto yy737;
			goto yy560;
		}
	}
yy605:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy725;
	if (yych == 'e') goto yy738;
	goto yy560;
yy606:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy726;
	if (yych == 'e') goto yy739;
	goto yy560;
yy607:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy740;
	if (yych == 'g') goto yy740;
	goto yy53;
yy608:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy740;
	if (yych == 'g') goto yy741;
	goto yy560;
yy609:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy742;
	if (yych == 'e') goto yy742;
	goto yy53;
yy610:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy742;
	if (yych == 'e') goto yy743;
	goto yy560;
yy611:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy744;
	if (yych == 'o') goto yy744;
	goto yy53;
yy612:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy744;
	if (yych == 'o') goto yy745;
	goto yy560;
yy613:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy624;
	if (yych == 'd') goto yy624;
	goto yy53;
yy614:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy565;
	if (yych == 'd') goto yy565;
	goto yy53;
yy615:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy563;
	if (yych == 'm') goto yy563;
	goto yy53;
yy616:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy571;
	if (yych == 't') goto yy571;
	goto yy53;
yy617:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy624;
	if (yych == 'd') goto yy627;
	goto yy560;
yy618:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy565;
	if (yych == 'd') goto yy568;
	goto yy560;
yy619:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy563;
	if (yych == 'm') goto yy564;
	goto yy560;
yy620:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy571;
	if (yych == 't') goto yy574;
	goto yy560;
yy621:
	++YYCURSOR;
yy622:
#line 884 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 10586 "real_world/parse_date_b.c"
yy623:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy746;
	if (yych == 'r') goto yy746;
	goto yy53;
yy624:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy572;
	if (yych == 'a') goto yy572;
	goto yy53;
yy625:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy622;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy622;
		if (yych <= 'z') goto yy559;
		goto yy622;
	}
yy626:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy746;
	if (yych == 'r') goto yy747;
	goto yy560;
yy627:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy572;
	if (yych == 'a') goto yy575;
	goto yy560;
yy628:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy613;
	if (yych == 's') goto yy613;
	goto yy53;
yy629:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy613;
	if (yych == 's') goto yy617;
	goto yy560;
yy630:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy748;
	if (yych == 'r') goto yy748;
	goto yy53;
yy631:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy748;
	if (yych == 'r') goto yy749;
	goto yy560;
yy632:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy750;
	goto yy53;
yy633:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy750;
	goto yy53;
yy634:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy750;
	goto yy53;
yy635:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy751;
	goto yy53;
yy636:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy635;
	if (yych <= '/') goto yy192;
	if (yych <= '9') goto yy753;
	goto yy192;
yy637:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy638;
	if (yych <= '9') goto yy753;
yy638:
#line 1088 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 10680 "real_world/parse_date_b.c"
yy639:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy197;
	if (yych <= '9') goto yy754;
	goto yy197;
yy640:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy755;
	goto yy53;
yy641:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy672;
	if (yych == 'e') goto yy672;
	goto yy53;
yy642:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy673;
	if (yych == 'e') goto yy673;
	goto yy53;
yy643:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy678;
	if (yych == 'a') goto yy678;
	goto yy53;
yy644:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy756;
	if (yych == 'e') goto yy756;
	goto yy53;
yy645:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy757;
		goto yy53;
	} else {
		if (yych <= '0') goto yy647;
		if (yych <= '9') goto yy758;
		goto yy53;
	}
yy646:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy757;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy758;
	goto yy53;
yy647:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy757;
	goto yy53;
yy648:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy759;
		if (yych <= 'T') goto yy53;
		goto yy760;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy759;
		} else {
			if (yych == 'u') goto yy760;
			goto yy53;
		}
	}
yy649:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy761;
	if (yych == 'e') goto yy761;
	goto yy53;
yy650:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy762;
	if (yych == 'e') goto yy762;
	goto yy53;
yy651:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy763;
		if (yych <= 'T') goto yy53;
		goto yy764;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy763;
		} else {
			if (yych == 'u') goto yy764;
			goto yy53;
		}
	}
yy652:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy765;
	if (yych == 'a') goto yy765;
	goto yy53;
yy653:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy766;
	if (yych == 'o') goto yy766;
	goto yy53;
yy654:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy767;
	if (yych == 'c') goto yy767;
	goto yy53;
yy655:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy768;
	if (yych == 'e') goto yy768;
	goto yy53;
yy656:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy769;
	if (yych <= '9') goto yy770;
	goto yy53;
yy657:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy770;
	goto yy53;
yy658:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy770;
	if (yych <= '6') goto yy771;
	goto yy53;
yy659:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy772;
	if (yych <= '0') goto yy661;
	if (yych <= '9') goto yy773;
	goto yy53;
yy660:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy772;
	if (yych <= '2') goto yy773;
	goto yy53;
yy661:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy772;
	goto yy53;
yy662:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':	goto yy54;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy774;
	default:	goto yy663;
	}
yy663:
#line 1016 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 10876 "real_world/parse_date_b.c"
yy664:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':	goto yy776;
	case '1':
	case '2':	goto yy777;
	case '3':	goto yy778;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy774;
	default:	goto yy663;
	}
yy665:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy774;
	default:	goto yy663;
	}
yy666:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy774;
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy663;
	}
yy667:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= 'C') {
				if (yych == ' ') goto yy176;
				goto yy663;
			} else {
				if (yych == 'E') goto yy663;
				if (yych <= 'F') goto yy176;
				goto yy663;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'H') goto yy176;
				if (yych == 'M') goto yy176;
				goto yy663;
			} else {
				if (yych <= 'T') goto yy176;
				if (yych == 'W') goto yy176;
				goto yy663;
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy176;
				if (yych == 'd') goto yy176;
				goto yy663;
			} else {
				if (yych == 'g') goto yy663;
				if (yych <= 'h') goto yy176;
				goto yy663;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'm') goto yy176;
				if (yych <= 'r') goto yy663;
				if (yych <= 't') goto yy176;
				goto yy663;
			} else {
				if (yych == 'x') goto yy663;
				if (yych <= 'y') goto yy176;
				goto yy663;
			}
		}
	}
yy668:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy779;
	goto yy53;
yy669:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy779;
	goto yy53;
yy670:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy780;
	if (yych == 'r') goto yy780;
	goto yy53;
yy671:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy781;
	if (yych == 'g') goto yy781;
	goto yy53;
yy672:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy782;
	if (yych == 'c') goto yy782;
	goto yy53;
yy673:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy783;
	if (yych == 'b') goto yy783;
	goto yy53;
yy674:
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy505;
yy675:
	++YYCURSOR;
	goto yy505;
yy676:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy784;
	if (yych == 'n') goto yy784;
	goto yy53;
yy677:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy785;
		if (yych <= 'M') goto yy53;
		goto yy786;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy785;
		} else {
			if (yych == 'n') goto yy786;
			goto yy53;
		}
	}
yy678:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy787;
		if (yych <= 'X') goto yy53;
		goto yy675;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy787;
		} else {
			if (yych == 'y') goto yy675;
			goto yy53;
		}
	}
yy679:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy782;
	if (yych == 'v') goto yy782;
	goto yy53;
yy680:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy788;
	if (yych == 't') goto yy788;
	goto yy53;
yy681:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy378;
		if (yych <= 'O') goto yy53;
		goto yy789;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy378;
		} else {
			if (yych == 'p') goto yy789;
			goto yy53;
		}
	}
yy682:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy790;
	goto yy53;
yy683:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy790;
	goto yy53;
yy684:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy790;
	goto yy53;
yy685:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '0') goto yy54;
	if (yych <= '9') goto yy774;
	goto yy176;
yy686:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy176;
		if (yych <= '0') goto yy776;
		goto yy777;
	} else {
		if (yych <= '3') goto yy778;
		if (yych <= '9') goto yy774;
		goto yy176;
	}
yy687:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '9') goto yy774;
	goto yy176;
yy688:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy176;
	if (yych <= '6') goto yy774;
	if (yych <= '9') goto yy54;
	goto yy176;
yy689:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy225;
	if (yych == 't') goto yy225;
	goto yy53;
yy690:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy691;
	if (yych != 'n') goto yy53;
yy691:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy792;
	if (yych == 'i') goto yy792;
	goto yy53;
yy692:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy520;
	if (yych == 'y') goto yy520;
	goto yy53;
yy693:
	++YYCURSOR;
	goto yy223;
yy694:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy793;
	if (yych == 'r') goto yy793;
	goto yy53;
yy695:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy362;
	if (yych == 'e') goto yy362;
	goto yy53;
yy696:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy794;
	if (yych == 'e') goto yy794;
	goto yy53;
yy697:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy362;
	if (yych == 'd') goto yy362;
	goto yy53;
yy698:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych == ' ') goto yy538;
			goto yy192;
		} else {
			if (yych <= '.') goto yy635;
			if (yych <= '/') goto yy192;
			if (yych <= '9') goto yy753;
			goto yy192;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy95;
			if (yych == 'P') goto yy95;
			goto yy192;
		} else {
			if (yych <= 'a') goto yy95;
			if (yych == 'p') goto yy95;
			goto yy192;
		}
	}
yy699:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ' ') goto yy538;
			goto yy192;
		} else {
			if (yych <= '.') goto yy635;
			if (yych <= '@') goto yy192;
			goto yy95;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy95;
			goto yy192;
		} else {
			if (yych <= 'a') goto yy95;
			if (yych == 'p') goto yy95;
			goto yy192;
		}
	}
yy700:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy638;
	if (yych <= '9') goto yy637;
	goto yy638;
yy701:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy795;
	goto yy53;
yy702:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy795;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy701;
		if (yych == 't') goto yy701;
		goto yy53;
	}
yy703:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy796;
	case '.':	goto yy425;
	case '0':
	case '1':	goto yy426;
	case '2':	goto yy427;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy428;
	case ':':	goto yy429;
	default:	goto yy282;
	}
yy704:
	++YYCURSOR;
	goto yy275;
yy705:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy275;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy275;
		if (yych <= 'z') goto yy559;
		goto yy275;
	}
yy706:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy129;
	if (yych <= '9') goto yy711;
	goto yy129;
yy707:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy797;
	if (yych <= '6') goto yy798;
	if (yych <= '9') goto yy587;
	goto yy53;
yy708:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy707;
		goto yy129;
	} else {
		if (yych <= '9') goto yy706;
		if (yych <= ':') goto yy707;
		goto yy129;
	}
yy709:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy129;
	} else {
		if (yych <= '9') goto yy706;
		if (yych >= ';') goto yy129;
	}
yy710:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy799;
	if (yych <= '6') goto yy800;
	if (yych <= '9') goto yy801;
	goto yy53;
yy711:
	++YYCURSOR;
	goto yy129;
yy712:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy125;
	if (yych == 'y') goto yy125;
	goto yy53;
yy713:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy125;
	if (yych == 'y') goto yy561;
	goto yy560;
yy714:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy802;
	if (yych == 'y') goto yy802;
	goto yy53;
yy715:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy804;
	if (yych == 'r') goto yy804;
	goto yy53;
yy716:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy805;
	if (yych == 'i') goto yy805;
	goto yy53;
yy717:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy806;
	if (yych == 'u') goto yy806;
	goto yy53;
yy718:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy807;
	if (yych == 'n') goto yy807;
	goto yy53;
yy719:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy808;
	if (yych == 'n') goto yy808;
	goto yy53;
yy720:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy809;
	if (yych == 't') goto yy809;
	goto yy53;
yy721:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy810;
	if (yych == 'c') goto yy810;
	goto yy53;
yy722:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy805;
	if (yych == 'n') goto yy805;
	goto yy53;
yy723:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy811;
	if (yych == 'u') goto yy811;
	goto yy53;
yy724:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy812;
	if (yych == 'e') goto yy812;
	goto yy53;
yy725:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy813;
		goto yy814;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy813;
		if (yych <= 'e') goto yy814;
		goto yy53;
	}
yy726:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy806;
	if (yych == 'a') goto yy806;
	goto yy53;
yy727:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy802;
	if (yych == 'y') goto yy815;
	goto yy560;
yy728:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy804;
	if (yych == 'r') goto yy816;
	goto yy560;
yy729:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy805;
	if (yych == 'i') goto yy817;
	goto yy560;
yy730:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy806;
	if (yych == 'u') goto yy818;
	goto yy560;
yy731:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy807;
	if (yych == 'n') goto yy819;
	goto yy560;
yy732:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy808;
	if (yych == 'n') goto yy820;
	goto yy560;
yy733:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy809;
	if (yych == 't') goto yy821;
	goto yy560;
yy734:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy810;
	if (yych == 'c') goto yy822;
	goto yy560;
yy735:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy805;
	if (yych == 'n') goto yy817;
	goto yy560;
yy736:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy811;
	if (yych == 'u') goto yy823;
	goto yy560;
yy737:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy812;
	if (yych == 'e') goto yy824;
	goto yy560;
yy738:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy560;
		if (yych <= 'D') goto yy813;
		goto yy814;
	} else {
		if (yych <= 'c') goto yy560;
		if (yych <= 'd') goto yy825;
		if (yych <= 'e') goto yy826;
		goto yy560;
	}
yy739:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy806;
	if (yych == 'a') goto yy818;
	goto yy560;
yy740:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy827;
	if (yych == 'h') goto yy827;
	goto yy53;
yy741:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy827;
	if (yych == 'h') goto yy828;
	goto yy560;
yy742:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy125;
	if (yych == 'r') goto yy125;
	goto yy53;
yy743:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy125;
	if (yych == 'r') goto yy561;
	goto yy560;
yy744:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy829;
	if (yych == 'u') goto yy829;
	goto yy53;
yy745:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy829;
	if (yych == 'u') goto yy830;
	goto yy560;
yy746:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy831;
	if (yych == 'o') goto yy831;
	goto yy53;
yy747:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy831;
	if (yych == 'o') goto yy832;
	goto yy560;
yy748:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy833;
	if (yych == 'd') goto yy833;
	goto yy53;
yy749:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy833;
	if (yych == 'd') goto yy834;
	goto yy560;
yy750:
	++YYCURSOR;
	goto yy474;
yy751:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy192;
	if (yych <= '9') goto yy751;
	goto yy192;
yy753:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy638;
	if (yych <= '9') goto yy835;
	goto yy638;
yy754:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy197;
	if (yych <= '9') goto yy836;
	goto yy197;
yy755:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy837;
	goto yy53;
yy756:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy789;
	if (yych == 'p') goto yy789;
	goto yy53;
yy757:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy838;
	if (yych <= '3') goto yy839;
	if (yych <= '9') goto yy840;
	goto yy53;
yy758:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy841;
	goto yy53;
yy759:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy842;
	if (yych == 'r') goto yy842;
	goto yy53;
yy760:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy843;
	if (yych == 'g') goto yy843;
	goto yy53;
yy761:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy844;
	if (yych == 'c') goto yy844;
	goto yy53;
yy762:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy845;
	if (yych == 'b') goto yy845;
	goto yy53;
yy763:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy846;
	if (yych == 'n') goto yy846;
	goto yy53;
yy764:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy847;
		if (yych <= 'M') goto yy53;
		goto yy848;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy847;
		} else {
			if (yych == 'n') goto yy848;
			goto yy53;
		}
	}
yy765:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy849;
		if (yych <= 'X') goto yy53;
		goto yy850;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy849;
		} else {
			if (yych == 'y') goto yy850;
			goto yy53;
		}
	}
yy766:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy844;
	if (yych == 'v') goto yy844;
	goto yy53;
yy767:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy851;
	if (yych == 't') goto yy851;
	goto yy53;
yy768:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy852;
	if (yych == 'p') goto yy852;
	goto yy53;
yy769:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy853;
	goto yy53;
yy770:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy853;
	goto yy53;
yy771:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '6') goto yy853;
	goto yy53;
yy772:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy854;
	if (yych <= '3') goto yy856;
	if (yych <= '9') goto yy857;
	goto yy53;
yy773:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy858;
	goto yy53;
yy774:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= 'C') {
				if (yych == ' ') goto yy176;
			} else {
				if (yych == 'E') goto yy775;
				if (yych <= 'F') goto yy176;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'H') goto yy176;
				if (yych == 'M') goto yy176;
			} else {
				if (yych <= 'T') goto yy176;
				if (yych == 'W') goto yy176;
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy176;
				if (yych == 'd') goto yy176;
			} else {
				if (yych == 'g') goto yy775;
				if (yych <= 'h') goto yy176;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'm') goto yy176;
				if (yych <= 'r') goto yy775;
				if (yych <= 't') goto yy176;
			} else {
				if (yych == 'x') goto yy775;
				if (yych <= 'y') goto yy176;
			}
		}
	}
yy775:
#line 1188 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 11746 "real_world/parse_date_b.c"
yy776:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':	goto yy54;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy859;
	default:	goto yy775;
	}
yy777:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy859;
	default:	goto yy775;
	}
yy778:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ' ':
	case 'D':
	case 'F':
	case 'H':
	case 'M':
	case 'S':
	case 'T':
	case 'W':
	case 'Y':
	case 'd':
	case 'f':
	case 'h':
	case 'm':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy176;
	case '0':
	case '1':	goto yy859;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	default:	goto yy775;
	}
yy779:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy861;
	goto yy53;
yy780:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy862;
	if (yych == 'i') goto yy862;
	goto yy505;
yy781:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy863;
	if (yych == 'u') goto yy863;
	goto yy505;
yy782:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy864;
	if (yych == 'e') goto yy864;
	goto yy505;
yy783:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy865;
	if (yych == 'r') goto yy865;
	goto yy505;
yy784:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy866;
	if (yych == 'u') goto yy866;
	goto yy505;
yy785:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy675;
	if (yych == 'y') goto yy675;
	goto yy505;
yy786:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy675;
	if (yych == 'e') goto yy675;
	goto yy505;
yy787:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy867;
	if (yych == 'c') goto yy867;
	goto yy505;
yy788:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy868;
	if (yych == 'o') goto yy868;
	goto yy505;
yy789:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy782;
	if (yych == 't') goto yy782;
	goto yy505;
yy790:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy791;
	if (yych <= '7') goto yy869;
yy791:
#line 1220 "real_world/parse_date_b.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 11930 "real_world/parse_date_b.c"
yy792:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy871;
	if (yych == 'g') goto yy871;
	goto yy53;
yy793:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy225;
	if (yych == 'y') goto yy225;
	goto yy53;
yy794:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy225;
	if (yych == 'r') goto yy225;
	goto yy53;
yy795:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy872;
	if (yych <= '2') goto yy873;
	if (yych <= '3') goto yy874;
	goto yy53;
yy796:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy875;
	goto yy53;
yy797:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy710;
		goto yy586;
	} else {
		if (yych <= '9') goto yy877;
		if (yych <= ':') goto yy710;
		goto yy586;
	}
yy798:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy710;
		goto yy586;
	} else {
		if (yych <= '0') goto yy878;
		if (yych == ':') goto yy710;
		goto yy586;
	}
yy799:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy586;
	if (yych <= '9') goto yy878;
	goto yy586;
yy800:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy878;
	goto yy586;
yy801:
	++YYCURSOR;
	goto yy586;
yy802:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy879;
	if (yych == 's') goto yy879;
yy803:
#line 1324 "real_world/parse_date_b.re"
	{
		timelib_sll i;
		int         behavior;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 12013 "real_world/parse_date_b.c"
yy804:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy880;
	if (yych == 't') goto yy880;
	goto yy53;
yy805:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy881;
	if (yych == 'd') goto yy881;
	goto yy803;
yy806:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy802;
	if (yych == 'r') goto yy802;
	goto yy53;
yy807:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy879;
		if (yych <= 'T') goto yy803;
		goto yy882;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy803;
			goto yy879;
		} else {
			if (yych == 'u') goto yy882;
			goto yy803;
		}
	}
yy808:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy881;
		if (yych <= 'S') goto yy803;
		goto yy883;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy803;
			goto yy881;
		} else {
			if (yych == 't') goto yy883;
			goto yy803;
		}
	}
yy809:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy884;
	if (yych == 'u') goto yy884;
	goto yy803;
yy810:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy885;
		if (yych <= 'R') goto yy803;
		goto yy879;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy803;
			goto yy885;
		} else {
			if (yych == 's') goto yy879;
			goto yy803;
		}
	}
yy811:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy886;
	if (yych == 'r') goto yy886;
	goto yy803;
yy812:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy887;
	if (yych == 's') goto yy887;
	goto yy803;
yy813:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy888;
	if (yych == 'n') goto yy888;
	goto yy803;
yy814:
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy802;
	if (yych == 'k') goto yy802;
	goto yy53;
yy815:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy803;
			goto yy259;
		} else {
			if (yych == 'S') goto yy879;
			goto yy803;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy803;
			goto yy559;
		} else {
			if (yych <= 's') goto yy889;
			if (yych <= 'z') goto yy559;
			goto yy803;
		}
	}
yy816:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy880;
	if (yych == 't') goto yy890;
	goto yy560;
yy817:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy803;
			goto yy259;
		} else {
			if (yych == 'D') goto yy881;
			goto yy803;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy803;
			goto yy559;
		} else {
			if (yych <= 'd') goto yy891;
			if (yych <= 'z') goto yy559;
			goto yy803;
		}
	}
yy818:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy802;
	if (yych == 'r') goto yy815;
	goto yy560;
yy819:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'R') {
			if (yych == '/') goto yy259;
			goto yy803;
		} else {
			if (yych <= 'S') goto yy879;
			if (yych == 'U') goto yy882;
			goto yy803;
		}
	} else {
		if (yych <= 's') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy803;
			if (yych <= 'r') goto yy559;
			goto yy889;
		} else {
			if (yych == 'u') goto yy892;
			if (yych <= 'z') goto yy559;
			goto yy803;
		}
	}
yy820:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'C') {
			if (yych == '/') goto yy259;
			goto yy803;
		} else {
			if (yych <= 'D') goto yy881;
			if (yych == 'T') goto yy883;
			goto yy803;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy803;
			if (yych <= 'c') goto yy559;
			goto yy891;
		} else {
			if (yych == 't') goto yy893;
			if (yych <= 'z') goto yy559;
			goto yy803;
		}
	}
yy821:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy803;
			goto yy259;
		} else {
			if (yych == 'U') goto yy884;
			goto yy803;
		}
	} else {
		if (yych <= 't') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy803;
			goto yy559;
		} else {
			if (yych <= 'u') goto yy894;
			if (yych <= 'z') goto yy559;
			goto yy803;
		}
	}
yy822:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'N') {
			if (yych == '/') goto yy259;
			goto yy803;
		} else {
			if (yych <= 'O') goto yy885;
			if (yych == 'S') goto yy879;
			goto yy803;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy803;
			if (yych <= 'n') goto yy559;
			goto yy895;
		} else {
			if (yych == 's') goto yy889;
			if (yych <= 'z') goto yy559;
			goto yy803;
		}
	}
yy823:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy803;
			goto yy259;
		} else {
			if (yych == 'R') goto yy886;
			goto yy803;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy803;
			goto yy559;
		} else {
			if (yych <= 'r') goto yy896;
			if (yych <= 'z') goto yy559;
			goto yy803;
		}
	}
yy824:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy803;
			goto yy259;
		} else {
			if (yych == 'S') goto yy887;
			goto yy803;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy803;
			goto yy559;
		} else {
			if (yych <= 's') goto yy897;
			if (yych <= 'z') goto yy559;
			goto yy803;
		}
	}
yy825:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy803;
			goto yy259;
		} else {
			if (yych == 'N') goto yy888;
			goto yy803;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy803;
			goto yy559;
		} else {
			if (yych <= 'n') goto yy898;
			if (yych <= 'z') goto yy559;
			goto yy803;
		}
	}
yy826:
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy802;
	if (yych == 'k') goto yy815;
	goto yy560;
yy827:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy621;
	if (yych == 't') goto yy621;
	goto yy53;
yy828:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy621;
	if (yych == 't') goto yy625;
	goto yy560;
yy829:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy565;
	if (yych == 's') goto yy565;
	goto yy53;
yy830:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy565;
	if (yych == 's') goto yy568;
	goto yy560;
yy831:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy899;
	if (yych == 'w') goto yy899;
	goto yy53;
yy832:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy899;
	if (yych == 'w') goto yy901;
	goto yy560;
yy833:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy902;
	if (yych == 'a') goto yy902;
	goto yy53;
yy834:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy902;
	if (yych == 'a') goto yy903;
	goto yy560;
yy835:
	++YYCURSOR;
	goto yy638;
yy836:
	++YYCURSOR;
	goto yy197;
yy837:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy904;
	goto yy53;
yy838:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy474;
			goto yy840;
		} else {
			if (yych == 'T') goto yy905;
			goto yy474;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy906;
			if (yych <= 'q') goto yy474;
			goto yy906;
		} else {
			if (yych <= 's') goto yy907;
			if (yych <= 't') goto yy908;
			goto yy474;
		}
	}
yy839:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy474;
		} else {
			if (yych == 'T') goto yy905;
			goto yy474;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy906;
			if (yych <= 'q') goto yy474;
			goto yy906;
		} else {
			if (yych <= 's') goto yy907;
			if (yych <= 't') goto yy908;
			goto yy474;
		}
	}
yy840:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy905;
		if (yych <= 'm') goto yy474;
		goto yy906;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy474;
			goto yy906;
		} else {
			if (yych <= 's') goto yy907;
			if (yych <= 't') goto yy908;
			goto yy474;
		}
	}
yy841:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych <= '0') goto yy909;
		goto yy910;
	} else {
		if (yych <= '3') goto yy911;
		if (yych <= '9') goto yy840;
		goto yy53;
	}
yy842:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy795;
		goto yy505;
	} else {
		if (yych <= 'I') goto yy862;
		if (yych == 'i') goto yy862;
		goto yy505;
	}
yy843:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy795;
		goto yy505;
	} else {
		if (yych <= 'U') goto yy863;
		if (yych == 'u') goto yy863;
		goto yy505;
	}
yy844:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy795;
		goto yy505;
	} else {
		if (yych <= 'E') goto yy864;
		if (yych == 'e') goto yy864;
		goto yy505;
	}
yy845:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy795;
		goto yy505;
	} else {
		if (yych <= 'R') goto yy865;
		if (yych == 'r') goto yy865;
		goto yy505;
	}
yy846:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy795;
		goto yy505;
	} else {
		if (yych <= 'U') goto yy866;
		if (yych == 'u') goto yy866;
		goto yy505;
	}
yy847:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy795;
		goto yy505;
	} else {
		if (yych <= 'Y') goto yy675;
		if (yych == 'y') goto yy675;
		goto yy505;
	}
yy848:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy795;
		goto yy505;
	} else {
		if (yych <= 'E') goto yy675;
		if (yych == 'e') goto yy675;
		goto yy505;
	}
yy849:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy795;
		goto yy505;
	} else {
		if (yych <= 'C') goto yy867;
		if (yych == 'c') goto yy867;
		goto yy505;
	}
yy850:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy795;
	goto yy505;
yy851:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy795;
		goto yy505;
	} else {
		if (yych <= 'O') goto yy868;
		if (yych == 'o') goto yy868;
		goto yy505;
	}
yy852:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy795;
		goto yy505;
	} else {
		if (yych <= 'T') goto yy844;
		if (yych == 't') goto yy844;
		goto yy505;
	}
yy853:
	++YYCURSOR;
	goto yy775;
yy854:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy855;
		if (yych <= '9') goto yy857;
		if (yych >= 'n') goto yy912;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy912;
		} else {
			if (yych <= 's') goto yy913;
			if (yych <= 't') goto yy914;
		}
	}
yy855:
#line 1049 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 12593 "real_world/parse_date_b.c"
yy856:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy855;
		if (yych <= '1') goto yy857;
		if (yych <= 'm') goto yy855;
		goto yy912;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy855;
			goto yy912;
		} else {
			if (yych <= 's') goto yy913;
			if (yych <= 't') goto yy914;
			goto yy855;
		}
	}
yy857:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy912;
		goto yy855;
	} else {
		if (yych <= 'r') goto yy912;
		if (yych <= 's') goto yy913;
		if (yych <= 't') goto yy914;
		goto yy855;
	}
yy858:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy53;
		if (yych <= '0') goto yy915;
		goto yy916;
	} else {
		if (yych <= '3') goto yy917;
		if (yych <= '9') goto yy857;
		goto yy53;
	}
yy859:
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy54;
	}
	switch (yych) {
	case ' ':	goto yy175;
	case 'D':
	case 'd':	goto yy177;
	case 'F':
	case 'f':	goto yy178;
	case 'H':
	case 'h':	goto yy72;
	case 'M':
	case 'm':	goto yy179;
	case 'S':
	case 's':	goto yy180;
	case 'T':	goto yy918;
	case 'W':
	case 'w':	goto yy82;
	case 'Y':
	case 'y':	goto yy84;
	case 't':	goto yy919;
	default:	goto yy860;
	}
yy860:
#line 1152 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 12673 "real_world/parse_date_b.c"
yy861:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy920;
	if (yych <= '2') goto yy921;
	if (yych <= '3') goto yy922;
	goto yy53;
yy862:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy675;
	if (yych == 'l') goto yy675;
	goto yy53;
yy863:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy923;
	if (yych == 's') goto yy923;
	goto yy53;
yy864:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy868;
	if (yych == 'm') goto yy868;
	goto yy53;
yy865:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy866;
	if (yych != 'u') goto yy53;
yy866:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy924;
	if (yych == 'a') goto yy924;
	goto yy53;
yy867:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy675;
	if (yych == 'h') goto yy675;
	goto yy53;
yy868:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy925;
	if (yych == 'b') goto yy925;
	goto yy53;
yy869:
	++YYCURSOR;
#line 1201 "real_world/parse_date_b.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 12735 "real_world/parse_date_b.c"
yy871:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy926;
	if (yych == 'h') goto yy926;
	goto yy53;
yy872:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy927;
	goto yy53;
yy873:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy927;
	goto yy53;
yy874:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy927;
	goto yy53;
yy875:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy876;
	if (yych <= '9') goto yy929;
yy876:
#line 1239 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 12773 "real_world/parse_date_b.c"
yy877:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= '(') {
			if (yych == ' ') goto yy930;
			if (yych <= '\'') goto yy586;
			goto yy932;
		} else {
			if (yych == '+') goto yy933;
			if (yych <= ',') goto yy586;
			goto yy933;
		}
	} else {
		if (yych <= '@') {
			if (yych <= '.') goto yy710;
			if (yych == ':') goto yy710;
			goto yy586;
		} else {
			if (yych <= 'Z') goto yy934;
			if (yych <= '`') goto yy586;
			if (yych <= 'z') goto yy935;
			goto yy586;
		}
	}
yy878:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '+') {
		if (yych <= '\'') {
			if (yych == ' ') goto yy930;
			goto yy586;
		} else {
			if (yych <= '(') goto yy932;
			if (yych <= '*') goto yy586;
			goto yy933;
		}
	} else {
		if (yych <= '@') {
			if (yych == '-') goto yy933;
			goto yy586;
		} else {
			if (yych <= 'Z') goto yy934;
			if (yych <= '`') goto yy586;
			if (yych <= 'z') goto yy935;
			goto yy586;
		}
	}
yy879:
	++YYCURSOR;
	goto yy803;
yy880:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy936;
		if (yych <= 'M') goto yy53;
		goto yy937;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy936;
		} else {
			if (yych == 'n') goto yy937;
			goto yy53;
		}
	}
yy881:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy938;
	if (yych == 'a') goto yy938;
	goto yy53;
yy882:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy939;
	if (yych == 't') goto yy939;
	goto yy53;
yy883:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy802;
	if (yych == 'h') goto yy802;
	goto yy53;
yy884:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy887;
	if (yych == 'r') goto yy887;
	goto yy53;
yy885:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy940;
	if (yych == 'n') goto yy940;
	goto yy53;
yy886:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy887;
	if (yych != 's') goto yy53;
yy887:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy881;
	if (yych == 'd') goto yy881;
	goto yy53;
yy888:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy886;
	if (yych == 'e') goto yy886;
	goto yy53;
yy889:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy803;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy803;
		if (yych <= 'z') goto yy559;
		goto yy803;
	}
yy890:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy936;
		if (yych <= 'M') goto yy560;
		goto yy937;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy560;
			goto yy941;
		} else {
			if (yych == 'n') goto yy942;
			goto yy560;
		}
	}
yy891:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy938;
	if (yych == 'a') goto yy943;
	goto yy560;
yy892:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy939;
	if (yych == 't') goto yy944;
	goto yy560;
yy893:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy802;
	if (yych == 'h') goto yy815;
	goto yy560;
yy894:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy887;
	if (yych == 'r') goto yy897;
	goto yy560;
yy895:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy940;
	if (yych == 'n') goto yy945;
	goto yy560;
yy896:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy887;
	if (yych != 's') goto yy560;
yy897:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy881;
	if (yych == 'd') goto yy891;
	goto yy560;
yy898:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy886;
	if (yych == 'e') goto yy896;
	goto yy560;
yy899:
	++YYCURSOR;
yy900:
#line 894 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 12959 "real_world/parse_date_b.c"
yy901:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy900;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy900;
		if (yych <= 'z') goto yy559;
		goto yy900;
	}
yy902:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy946;
	if (yych == 'y') goto yy946;
	goto yy53;
yy903:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy946;
	if (yych == 'y') goto yy948;
	goto yy560;
yy904:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy949;
	goto yy53;
yy905:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy950;
	if (yych <= '2') goto yy951;
	if (yych <= '9') goto yy952;
	goto yy53;
yy906:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy953;
	goto yy53;
yy907:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy953;
	goto yy53;
yy908:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy953;
	goto yy53;
yy909:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy474;
			if (yych <= '0') goto yy840;
			goto yy954;
		} else {
			if (yych == 'T') goto yy905;
			goto yy474;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy906;
			if (yych <= 'q') goto yy474;
			goto yy906;
		} else {
			if (yych <= 's') goto yy907;
			if (yych <= 't') goto yy908;
			goto yy474;
		}
	}
yy910:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy474;
			goto yy954;
		} else {
			if (yych == 'T') goto yy905;
			goto yy474;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy906;
			if (yych <= 'q') goto yy474;
			goto yy906;
		} else {
			if (yych <= 's') goto yy907;
			if (yych <= 't') goto yy908;
			goto yy474;
		}
	}
yy911:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy474;
			goto yy954;
		} else {
			if (yych == 'T') goto yy905;
			goto yy474;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy906;
			if (yych <= 'q') goto yy474;
			goto yy906;
		} else {
			if (yych <= 's') goto yy907;
			if (yych <= 't') goto yy908;
			goto yy474;
		}
	}
yy912:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy955;
	goto yy53;
yy913:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy955;
	goto yy53;
yy914:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy955;
	goto yy53;
yy915:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '0') {
			if (yych <= '/') goto yy855;
			goto yy857;
		} else {
			if (yych <= '9') goto yy956;
			if (yych <= 'm') goto yy855;
			goto yy912;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy855;
			goto yy912;
		} else {
			if (yych <= 's') goto yy913;
			if (yych <= 't') goto yy914;
			goto yy855;
		}
	}
yy916:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy855;
		if (yych <= '9') goto yy956;
		if (yych <= 'm') goto yy855;
		goto yy912;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy855;
			goto yy912;
		} else {
			if (yych <= 's') goto yy913;
			if (yych <= 't') goto yy914;
			goto yy855;
		}
	}
yy917:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy855;
		if (yych <= '1') goto yy956;
		if (yych <= 'm') goto yy855;
		goto yy912;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy855;
			goto yy912;
		} else {
			if (yych <= 's') goto yy913;
			if (yych <= 't') goto yy914;
			goto yy855;
		}
	}
yy918:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych <= '1') goto yy957;
			goto yy958;
		} else {
			if (yych <= '9') goto yy959;
			if (yych <= 'G') goto yy53;
			goto yy236;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy237;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy236;
			if (yych == 'u') goto yy237;
			goto yy53;
		}
	}
yy919:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych <= '1') goto yy960;
			goto yy961;
		} else {
			if (yych <= '9') goto yy962;
			if (yych <= 'G') goto yy53;
			goto yy236;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy237;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy236;
			if (yych == 'u') goto yy237;
			goto yy53;
		}
	}
yy920:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy963;
	goto yy53;
yy921:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy963;
	goto yy53;
yy922:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy963;
	goto yy53;
yy923:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy675;
	if (yych == 't') goto yy675;
	goto yy53;
yy924:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy964;
	if (yych == 'r') goto yy964;
	goto yy53;
yy925:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy965;
	if (yych == 'e') goto yy965;
	goto yy53;
yy926:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy362;
	if (yych == 't') goto yy362;
	goto yy53;
yy927:
	++YYCURSOR;
#line 1252 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 13236 "real_world/parse_date_b.c"
yy929:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy876;
	if (yych <= '9') goto yy966;
	goto yy876;
yy930:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	if (yych <= '+') {
		if (yych <= '\'') {
			if (yych == ' ') goto yy930;
			goto yy53;
		} else {
			if (yych <= '(') goto yy932;
			if (yych <= '*') goto yy53;
			goto yy933;
		}
	} else {
		if (yych <= '@') {
			if (yych == '-') goto yy933;
			goto yy53;
		} else {
			if (yych <= 'Z') goto yy934;
			if (yych <= '`') goto yy53;
			if (yych <= 'z') goto yy935;
			goto yy53;
		}
	}
yy932:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy935;
	if (yych <= '`') goto yy53;
	if (yych <= 'z') goto yy935;
	goto yy53;
yy933:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy967;
	if (yych <= '2') goto yy968;
	if (yych <= '9') goto yy969;
	goto yy53;
yy934:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy801;
		goto yy586;
	} else {
		if (yych <= 'Z') goto yy970;
		if (yych <= '`') goto yy586;
		if (yych <= 'z') goto yy971;
		goto yy586;
	}
yy935:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy801;
		goto yy586;
	} else {
		if (yych <= 'Z') goto yy970;
		if (yych <= '`') goto yy586;
		if (yych <= 'z') goto yy970;
		goto yy586;
	}
yy936:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy937;
	if (yych != 'n') goto yy53;
yy937:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy972;
	if (yych == 'i') goto yy972;
	goto yy53;
yy938:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy879;
	if (yych == 'y') goto yy879;
	goto yy53;
yy939:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy802;
	if (yych == 'e') goto yy802;
	goto yy53;
yy940:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy802;
	if (yych == 'd') goto yy802;
	goto yy53;
yy941:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy937;
	if (yych != 'n') goto yy560;
yy942:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy972;
	if (yych == 'i') goto yy973;
	goto yy560;
yy943:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy879;
	if (yych == 'y') goto yy889;
	goto yy560;
yy944:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy802;
	if (yych == 'e') goto yy815;
	goto yy560;
yy945:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy802;
	if (yych == 'd') goto yy815;
	goto yy560;
yy946:
	++YYCURSOR;
yy947:
#line 851 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 13364 "real_world/parse_date_b.c"
yy948:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy947;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy947;
		if (yych <= 'z') goto yy559;
		goto yy947;
	}
yy949:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy974;
	goto yy53;
yy950:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy952;
	if (yych <= ':') goto yy975;
	goto yy53;
yy951:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy952;
	if (yych == ':') goto yy975;
	goto yy53;
yy952:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy975;
	goto yy53;
yy953:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy905;
	goto yy474;
yy954:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy976;
		if (yych <= 'm') goto yy855;
		goto yy906;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy855;
			goto yy906;
		} else {
			if (yych <= 's') goto yy907;
			if (yych <= 't') goto yy908;
			goto yy855;
		}
	}
yy955:
	++YYCURSOR;
	goto yy855;
yy956:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy955;
		if (yych <= 'm') goto yy855;
		goto yy912;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy855;
			goto yy912;
		} else {
			if (yych <= 's') goto yy913;
			if (yych <= 't') goto yy914;
			goto yy855;
		}
	}
yy957:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy977;
	if (yych <= '9') goto yy959;
	if (yych <= ':') goto yy978;
	goto yy53;
yy958:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '3') goto yy977;
		goto yy979;
	} else {
		if (yych == ':') goto yy978;
		goto yy53;
	}
yy959:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy979;
	if (yych == ':') goto yy978;
	goto yy53;
yy960:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy980;
	if (yych <= '9') goto yy962;
	goto yy53;
yy961:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy980;
	if (yych <= '5') goto yy979;
	goto yy53;
yy962:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy979;
	goto yy53;
yy963:
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy981;
	goto yy53;
yy964:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy675;
	if (yych == 'y') goto yy675;
	goto yy53;
yy965:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy675;
	if (yych == 'r') goto yy675;
	goto yy53;
yy966:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy876;
	if (yych <= '9') goto yy982;
	goto yy876;
yy967:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy586;
	if (yych <= '9') goto yy969;
	if (yych <= ':') goto yy983;
	goto yy586;
yy968:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy586;
		if (yych >= '4') goto yy984;
	} else {
		if (yych <= '9') goto yy801;
		if (yych <= ':') goto yy983;
		goto yy586;
	}
yy969:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy586;
	if (yych <= '5') goto yy984;
	if (yych <= '9') goto yy801;
	if (yych <= ':') goto yy983;
	goto yy586;
yy970:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy801;
		goto yy586;
	} else {
		if (yych <= 'Z') goto yy985;
		if (yych <= '`') goto yy586;
		if (yych <= 'z') goto yy985;
		goto yy586;
	}
yy971:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy586;
			goto yy801;
		} else {
			if (yych == '/') goto yy986;
			goto yy586;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy985;
			if (yych <= '^') goto yy586;
			goto yy986;
		} else {
			if (yych <= '`') goto yy586;
			if (yych <= 'z') goto yy987;
			goto yy586;
		}
	}
yy972:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy988;
	if (yych == 'g') goto yy988;
	goto yy53;
yy973:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy988;
	if (yych == 'g') goto yy989;
	goto yy560;
yy974:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy990;
	if (yych <= '2') goto yy991;
	goto yy53;
yy975:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy992;
	if (yych <= '9') goto yy993;
	goto yy53;
yy976:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy994;
	if (yych <= '2') goto yy995;
	if (yych <= '9') goto yy952;
	goto yy53;
yy977:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy996;
	if (yych <= '9') goto yy997;
	if (yych >= ';') goto yy53;
yy978:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy998;
	goto yy53;
yy979:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy997;
	goto yy53;
yy980:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy996;
	if (yych <= '9') goto yy997;
	goto yy53;
yy981:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy999;
	if (yych <= '2') goto yy1000;
	goto yy53;
yy982:
	++YYCURSOR;
	goto yy876;
yy983:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy586;
	if (yych <= '5') goto yy984;
	if (yych <= '9') goto yy801;
	goto yy586;
yy984:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy586;
	if (yych <= '9') goto yy801;
	goto yy586;
yy985:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy801;
		goto yy586;
	} else {
		if (yych <= 'Z') goto yy1001;
		if (yych <= '`') goto yy586;
		if (yych <= 'z') goto yy1001;
		goto yy586;
	}
yy986:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy1002;
	goto yy53;
yy987:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy586;
			goto yy801;
		} else {
			if (yych == '/') goto yy986;
			goto yy586;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1001;
			if (yych <= '^') goto yy586;
			goto yy986;
		} else {
			if (yych <= '`') goto yy586;
			if (yych <= 'z') goto yy1003;
			goto yy586;
		}
	}
yy988:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1004;
	if (yych == 'h') goto yy1004;
	goto yy53;
yy989:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1004;
	if (yych == 'h') goto yy1005;
	goto yy560;
yy990:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1006;
	goto yy53;
yy991:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1006;
	goto yy53;
yy992:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy993;
	if (yych <= ':') goto yy1007;
	goto yy53;
yy993:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1007;
	goto yy53;
yy994:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1008;
	if (yych <= ':') goto yy975;
	goto yy53;
yy995:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1008;
	if (yych == ':') goto yy975;
	goto yy53;
yy996:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1007;
	if (yych <= '6') goto yy1009;
	if (yych >= ':') goto yy53;
yy997:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1010;
	if (yych <= '6') goto yy1011;
	goto yy53;
yy998:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1012;
	goto yy53;
yy999:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1013;
	goto yy53;
yy1000:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy1013;
	goto yy53;
yy1001:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy801;
	goto yy586;
yy1002:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '`') goto yy53;
	if (yych <= 'z') goto yy1014;
	goto yy53;
yy1003:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy801;
		if (yych <= '.') goto yy586;
		goto yy986;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy586;
			goto yy986;
		} else {
			if (yych <= '`') goto yy586;
			if (yych <= 'z') goto yy1016;
			goto yy586;
		}
	}
yy1004:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy802;
	if (yych == 't') goto yy802;
	goto yy53;
yy1005:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy802;
	if (yych == 't') goto yy815;
	goto yy560;
yy1006:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1018;
	goto yy53;
yy1007:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1019;
	if (yych <= '6') goto yy1021;
	if (yych <= '9') goto yy1022;
	goto yy53;
yy1008:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1023;
	goto yy53;
yy1009:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1019;
	if (yych <= '5') goto yy1010;
	if (yych <= '6') goto yy1011;
	goto yy53;
yy1010:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1022;
	goto yy53;
yy1011:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1022;
	goto yy53;
yy1012:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy997;
	goto yy53;
yy1013:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy978;
	goto yy53;
yy1014:
	yyaccept = 16;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '^') {
		if (yych == '/') goto yy986;
		goto yy586;
	} else {
		if (yych <= '_') goto yy986;
		if (yych <= '`') goto yy586;
		if (yych <= 'z') goto yy1014;
		goto yy586;
	}
yy1016:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '^') {
		if (yych == '/') goto yy986;
		goto yy53;
	} else {
		if (yych <= '_') goto yy986;
		if (yych <= '`') goto yy53;
		if (yych <= 'z') goto yy1016;
		goto yy53;
	}
yy1018:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1024;
	goto yy53;
yy1019:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1020;
	if (yych <= '9') goto yy1022;
yy1020:
#line 1164 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				s->errors += tz_not_found;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 13871 "real_world/parse_date_b.c"
yy1021:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1020;
yy1022:
	++YYCURSOR;
	goto yy1020;
yy1023:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1025;
	if (yych <= '9') goto yy993;
	goto yy53;
yy1024:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1026;
	goto yy53;
yy1025:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1027;
	if (yych <= ':') goto yy1007;
	goto yy53;
yy1026:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1028;
	goto yy53;
yy1027:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1029;
	goto yy53;
yy1028:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1030;
	if (yych <= '6') goto yy1031;
	goto yy53;
yy1029:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1032;
	if (yych <= '6') goto yy1033;
	if (yych <= '9') goto yy1022;
	goto yy53;
yy1030:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1034;
	goto yy53;
yy1031:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1034;
	goto yy53;
yy1032:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1020;
	if (yych <= '9') goto yy1035;
	goto yy1020;
yy1033:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1035;
	goto yy1020;
yy1034:
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1036;
	goto yy53;
yy1035:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1038;
	goto yy1020;
yy1036:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	if (yych <= '*') {
		if (yych == ' ') goto yy1036;
		goto yy53;
	} else {
		if (yych == ',') goto yy53;
		if (yych <= '-') goto yy1039;
		goto yy53;
	}
yy1038:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1040;
	goto yy53;
yy1039:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1042;
	if (yych <= '2') goto yy1044;
	if (yych <= '9') goto yy1045;
	goto yy53;
yy1040:
	yyaccept = 26;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	if (yych <= ',') {
		if (yych == '+') goto yy1046;
		goto yy1020;
	} else {
		if (yych <= '-') goto yy1046;
		if (yych <= '/') goto yy1020;
		if (yych <= '9') goto yy1040;
		goto yy1020;
	}
yy1042:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1043;
	if (yych <= '9') goto yy1045;
	if (yych <= ':') goto yy1047;
yy1043:
#line 1265 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 14005 "real_world/parse_date_b.c"
yy1044:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1043;
		if (yych >= '4') goto yy1048;
	} else {
		if (yych <= '9') goto yy1049;
		if (yych <= ':') goto yy1047;
		goto yy1043;
	}
yy1045:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1043;
	if (yych <= '5') goto yy1048;
	if (yych <= '9') goto yy1049;
	if (yych <= ':') goto yy1047;
	goto yy1043;
yy1046:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1050;
	if (yych <= '2') goto yy1051;
	if (yych <= '9') goto yy1052;
	goto yy53;
yy1047:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1043;
	if (yych <= '5') goto yy1048;
	if (yych <= '9') goto yy1049;
	goto yy1043;
yy1048:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1043;
	if (yych >= ':') goto yy1043;
yy1049:
	++YYCURSOR;
	goto yy1043;
yy1050:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1020;
	if (yych <= '9') goto yy1052;
	if (yych <= ':') goto yy1053;
	goto yy1020;
yy1051:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1020;
		if (yych >= '4') goto yy1019;
	} else {
		if (yych <= '9') goto yy1022;
		if (yych <= ':') goto yy1053;
		goto yy1020;
	}
yy1052:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1020;
	if (yych <= '5') goto yy1019;
	if (yych <= '9') goto yy1022;
	if (yych >= ';') goto yy1020;
yy1053:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1020;
	if (yych <= '5') goto yy1019;
	if (yych <= '9') goto yy1022;
	goto yy1020;
}
#line 1412 "real_world/parse_date_b.re"

}

#define YYMAXFILL 26


timelib_time* timelib_strtotime(char *s, int len, int *errors, timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	while (isspace(*s) && s < e) {
		s++;
	}
	while (isspace(*e) && e > s) {
		e--;
	}
	if (e - s < 1) {
		*errors = 1;
		in.time = timelib_time_ctor();
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->z = in.time->dst = -1;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	memset(&in, 0, sizeof(in));
	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.errors = 0;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	*errors = in.errors;
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
