#! /bin/sh

# Test update of a record.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g')

DB_DIR=db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}.db

sqlite3 ${TMP_DB_FILE} <<END
    create table bibliography (
        id integer primary key autoincrement,
        title text,
        isbn text
    );
    create unique index bibliography_isbn on bibliography (isbn);
END

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}/bibliography"
export HTTP_HOST=${TMP_TEST_DB}.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=boundary"
export REMOTE_USER=writer

tools/scripts/multipart-form-data boundary <<EOF |
column:bibliography:0.title=Book+I
column:bibliography:0.isbn=978-3-16-148410-0
db=${TMP_TEST_DB}.db
Save=Save
EOF
${INPUT_SCRIPT} \
| sed "s/${TMP_TEST_DB}/tmp${BASENAME}pid/"

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

rm -f ${TMP_DB_FILE}
