# 2024-09-16 Triage Log

A relatively quiet week, with overall neutral performance across our set of key
metrics (instructions, cycles, memory).

Triage done by **@simulacrum**.
Revision range: [263a3aee..170d6cb8](https://perf.rust-lang.org/?start=263a3aeeb8f2d0e9cc85eee61774d1f5f23dc3f5&end=170d6cb845c8c3f0dcec5cdd4210df9ecf990244&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.2%, 4.0%]   | 52    |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.2%, 1.4%]   | 48    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-2.6%, -0.2%] | 46    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.1%, -0.1%] | 25    |
| All ❌✅ (primary)                 | 0.0%  | [-2.6%, 4.0%]  | 98    |


2 Regressions, 3 Improvements, 4 Mixed; 2 of them in rollups
54 artifact comparisons made in total

#### Regressions

interpret: make typed copies lossy wrt provenance and padding [#129778](https://github.com/rust-lang/rust/pull/129778) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=712463de61c65033a6f333f0a14fbb65e34efc50&end=304b7f801bab31233680879ca4fb6eb294706a59&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 2.1% | [0.2%, 4.7%] | 13    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

Most of the performance is recovered in https://github.com/rust-lang/rust/pull/130197.

generalize: track relevant info in cache key [#130194](https://github.com/rust-lang/rust/pull/130194) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4c5fc2c334f1cc305eea79ed0b8fdb276342d101&end=5a2dd7d4f3210629e65879aeecbe643ba3b86bb4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.4%, 1.3%]   | 16    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |

Soundness fix and regressions only in secondary benchmarks.

#### Improvements

rustdoc: use strategic boxing to shrink `clean::Item` [#129789](https://github.com/rust-lang/rust/pull/129789) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c2f74c3f928aeb503f15b4e9ef5778e77f3058b8&end=712463de61c65033a6f333f0a14fbb65e34efc50&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.0%, -0.2%] | 15    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.3%] | 19    |
| All ❌✅ (primary)                 | -0.5% | [-1.0%, -0.2%] | 15    |


rustdoc: unify the short-circuit on all lints [#129975](https://github.com/rust-lang/rust/pull/129975) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6f7229c4da0471f1470bb1f86071848cba3a23d9&end=a9fb00bfa4b3038c855b2097b54e05e8c198c183&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-2.0%, -0.2%] | 10    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary)                 | -0.7% | [-2.0%, -0.2%] | 10    |


Rollup of 10 pull requests [#130253](https://github.com/rust-lang/rust/pull/130253) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8d6b88b168e45ee1624699c19443c49665322a91&end=3afb2bb76ce56e860e45d8858ef5b5f00059e1b1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.5%, -0.2%] | 13    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.7% | [-1.5%, 0.2%]  | 14    |


#### Mixed

Revert "Stabilize `-Znext-solver=coherence`" [#130249](https://github.com/rust-lang/rust/pull/130249) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7c7372b6a1b9a8d6b787a3e5a10e4f8325b1fdfc&end=f753bc769b16ca9673f11a4cc06e5cc681efd84e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.7%  | [2.9%, 4.5%]   | 7     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.9%, -0.2%] | 13    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.7%, -0.1%] | 9     |
| All ❌✅ (primary)                 | 1.0%  | [-0.9%, 4.5%]  | 20    |

Largely resets to the previous state on a couple benchmarks. Expected given the revert.

Rollup of 5 pull requests [#130281](https://github.com/rust-lang/rust/pull/130281) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c0ec05f7dc9ef185eea9f36c5638e74e43935bf&end=2e8db5e9e39c2bf7729113b3041ef4011d90ac5a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.6%, 0.6%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.8% | [-2.0%, -1.6%] | 6     |
| All ❌✅ (primary)                 | 0.2%  | [-0.2%, 0.6%]  | 2     |

Regressions are minor enough that given the rollup and lack of obviously
relevant PRs I'm just marking as triaged. The primary regressed benchmark is
webrender and only in full LLVM builds which doesn't seem like it maps well
onto the contained PRs.

Rescope temp lifetime in if-let into IfElse with migration lint [#107251](https://github.com/rust-lang/rust/pull/107251) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d3a8524e80244d66968ab4522d31145ccba610f4&end=a5efa01895e82fa705146507d15311b29c715450&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 1.3%]   | 19    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 1     |

Seems like the regression is primarily looking like a revert of #127313...
@cjgillot do you have thoughts on what the delta here might be? I don't see a
very obvious cause here. Regressions are minor enough that I'm not worried, but
just checking if there's an easy explanation.

Simplify the canonical clone method and the copy-like forms to copy [#128299](https://github.com/rust-lang/rust/pull/128299) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=02b1be16c65e5716ade771afde7116ebdfbf9b4a&end=e7386b361dda8c2222bee7a1ae79faba7e9a0351&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.8%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 2.1%]   | 16    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.7%, -0.3%] | 12    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-1.7%, 0.8%]  | 18    |

Likely expected regressions from direct changes to codegen, possibly giving
LLVM more freedom to optimize:

> This pass improves performance by reducing the amount of MIR. The generated
> copies will get merged/expanded/whatever by LLVM, with a completely different
> heuristic.

(https://github.com/rust-lang/rust/pull/128299#pullrequestreview-2217057820)


