/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd.basic;

import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroup;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseChoice;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Comment;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexType;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeComplexContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeNotAllowedContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeSimpleContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.GroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Include;
import com.thaiopensource.relaxng.output.xsd.basic.OptionalAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleAll;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleRepeat;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleSequence;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.RootDeclaration;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeList;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRef;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRestriction;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeUnion;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaTransformer
implements SchemaVisitor,
ParticleVisitor<Particle>,
ComplexTypeVisitor<ComplexType>,
AttributeUseVisitor<AttributeUse>,
SimpleTypeVisitor<SimpleType> {
    private final Schema schema;

    public SchemaTransformer(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void transform() {
        this.schema.accept(this);
    }

    @Override
    public void visitGroup(GroupDefinition groupDefinition) {
        groupDefinition.setParticle(groupDefinition.getParticle().accept(this));
    }

    @Override
    public void visitAttributeGroup(AttributeGroupDefinition attributeGroupDefinition) {
        attributeGroupDefinition.setAttributeUses(attributeGroupDefinition.getAttributeUses().accept(this));
    }

    @Override
    public void visitSimpleType(SimpleTypeDefinition simpleTypeDefinition) {
        simpleTypeDefinition.setSimpleType(simpleTypeDefinition.getSimpleType().accept(this));
    }

    @Override
    public void visitRoot(RootDeclaration rootDeclaration) {
        rootDeclaration.setParticle(rootDeclaration.getParticle().accept(this));
    }

    @Override
    public void visitInclude(Include include) {
        include.getIncludedSchema().accept(this);
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public Particle visitRepeat(ParticleRepeat particleRepeat) {
        Particle particle = particleRepeat.getChild().accept(this);
        if (particle == particleRepeat.getChild()) {
            return particleRepeat;
        }
        return new ParticleRepeat(particleRepeat.getLocation(), particleRepeat.getAnnotation(), particle, particleRepeat.getOccurs());
    }

    @Override
    public Particle visitGroupRef(GroupRef groupRef) {
        return groupRef;
    }

    @Override
    public Particle visitElement(Element element) {
        ComplexType complexType = element.getComplexType().accept(this);
        if (complexType == element.getComplexType()) {
            return element;
        }
        return new Element(element.getLocation(), element.getAnnotation(), element.getName(), complexType);
    }

    @Override
    public Particle visitWildcardElement(WildcardElement wildcardElement) {
        return wildcardElement;
    }

    @Override
    public Particle visitSequence(ParticleSequence particleSequence) {
        List<Particle> list = this.transformParticleList(particleSequence.getChildren());
        if (list == particleSequence.getChildren()) {
            return particleSequence;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 0) {
            return null;
        }
        return new ParticleSequence(particleSequence.getLocation(), particleSequence.getAnnotation(), list);
    }

    @Override
    public Particle visitChoice(ParticleChoice particleChoice) {
        List<Particle> list = this.transformParticleList(particleChoice.getChildren());
        if (list == particleChoice.getChildren()) {
            return particleChoice;
        }
        return new ParticleChoice(particleChoice.getLocation(), particleChoice.getAnnotation(), list);
    }

    @Override
    public Particle visitAll(ParticleAll particleAll) {
        List<Particle> list = this.transformParticleList(particleAll.getChildren());
        if (list == particleAll.getChildren()) {
            return particleAll;
        }
        return new ParticleAll(particleAll.getLocation(), particleAll.getAnnotation(), list);
    }

    @Override
    public ComplexType visitComplexContent(ComplexTypeComplexContent complexTypeComplexContent) {
        Particle particle = complexTypeComplexContent.getParticle();
        AttributeUse attributeUse = complexTypeComplexContent.getAttributeUses().accept(this);
        if (particle != null) {
            particle = particle.accept(this);
        }
        if (particle == complexTypeComplexContent.getParticle() && attributeUse == complexTypeComplexContent.getAttributeUses()) {
            return complexTypeComplexContent;
        }
        return new ComplexTypeComplexContent(attributeUse, particle, complexTypeComplexContent.isMixed());
    }

    @Override
    public ComplexType visitSimpleContent(ComplexTypeSimpleContent complexTypeSimpleContent) {
        SimpleType simpleType = complexTypeSimpleContent.getSimpleType().accept(this);
        AttributeUse attributeUse = complexTypeSimpleContent.getAttributeUses().accept(this);
        if (simpleType == complexTypeSimpleContent.getSimpleType() && attributeUse == complexTypeSimpleContent.getAttributeUses()) {
            return complexTypeSimpleContent;
        }
        return new ComplexTypeSimpleContent(attributeUse, simpleType);
    }

    @Override
    public ComplexType visitNotAllowedContent(ComplexTypeNotAllowedContent complexTypeNotAllowedContent) {
        return complexTypeNotAllowedContent;
    }

    @Override
    public AttributeUse visitAttribute(Attribute attribute) {
        SimpleType simpleType = attribute.getType();
        if (simpleType != null && ((simpleType = simpleType.accept(this)) == null || simpleType != attribute.getType())) {
            return new Attribute(attribute.getLocation(), attribute.getAnnotation(), attribute.getName(), simpleType);
        }
        return attribute;
    }

    @Override
    public AttributeUse visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
        return wildcardAttribute;
    }

    @Override
    public AttributeUse visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
        return attributeGroupRef;
    }

    @Override
    public AttributeUse visitOptionalAttribute(OptionalAttribute optionalAttribute) {
        Attribute attribute = (Attribute)optionalAttribute.getAttribute().accept(this);
        if (attribute == optionalAttribute.getAttribute()) {
            return optionalAttribute;
        }
        return new OptionalAttribute(optionalAttribute.getLocation(), optionalAttribute.getAnnotation(), attribute, optionalAttribute.getDefaultValue());
    }

    @Override
    public AttributeUse visitAttributeGroup(AttributeGroup attributeGroup) {
        List<AttributeUse> list = this.transformAttributeUseList(attributeGroup.getChildren());
        if (list == attributeGroup.getChildren()) {
            return attributeGroup;
        }
        return new AttributeGroup(attributeGroup.getLocation(), attributeGroup.getAnnotation(), list);
    }

    @Override
    public AttributeUse visitAttributeUseChoice(AttributeUseChoice attributeUseChoice) {
        List<AttributeUse> list = this.transformAttributeUseList(attributeUseChoice.getChildren());
        if (list == attributeUseChoice.getChildren()) {
            return attributeUseChoice;
        }
        return new AttributeUseChoice(attributeUseChoice.getLocation(), attributeUseChoice.getAnnotation(), list);
    }

    @Override
    public SimpleType visitRestriction(SimpleTypeRestriction simpleTypeRestriction) {
        return simpleTypeRestriction;
    }

    @Override
    public SimpleType visitUnion(SimpleTypeUnion simpleTypeUnion) {
        List<SimpleType> list = this.transformSimpleTypeList(simpleTypeUnion.getChildren());
        if (list == simpleTypeUnion.getChildren()) {
            return simpleTypeUnion;
        }
        return new SimpleTypeUnion(simpleTypeUnion.getLocation(), simpleTypeUnion.getAnnotation(), list);
    }

    @Override
    public SimpleType visitList(SimpleTypeList simpleTypeList) {
        SimpleType simpleType = simpleTypeList.getItemType().accept(this);
        if (simpleType == simpleTypeList.getItemType()) {
            return simpleTypeList;
        }
        return new SimpleTypeList(simpleTypeList.getLocation(), simpleTypeList.getAnnotation(), simpleType, simpleTypeList.getOccurs());
    }

    @Override
    public SimpleType visitRef(SimpleTypeRef simpleTypeRef) {
        return simpleTypeRef;
    }

    public List<AttributeUse> transformAttributeUseList(List<AttributeUse> list) {
        Vector<AttributeUse> vector = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeUse attributeUse = list.get(i).accept(this);
            if (vector != null) {
                vector.add(attributeUse);
                continue;
            }
            if (attributeUse == list.get(i)) continue;
            vector = new Vector<AttributeUse>();
            for (int j = 0; j < i; ++j) {
                vector.add(list.get(j));
            }
            if (attributeUse.equals(AttributeGroup.EMPTY)) continue;
            vector.add(attributeUse);
        }
        if (vector == null) {
            return list;
        }
        return vector;
    }

    public List<Particle> transformParticleList(List<Particle> list) {
        Vector<Particle> vector = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Particle particle = list.get(i).accept(this);
            if (vector != null) {
                if (particle == null) continue;
                vector.add(particle);
                continue;
            }
            if (particle == list.get(i)) continue;
            vector = new Vector<Particle>();
            for (int j = 0; j < i; ++j) {
                vector.add(list.get(j));
            }
            if (particle == null) continue;
            vector.add(particle);
        }
        if (vector == null) {
            return list;
        }
        return vector;
    }

    public List<SimpleType> transformSimpleTypeList(List<SimpleType> list) {
        Vector<SimpleType> vector = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SimpleType simpleType = list.get(i).accept(this);
            if (vector != null) {
                vector.add(simpleType);
                continue;
            }
            if (simpleType == list.get(i)) continue;
            vector = new Vector<SimpleType>();
            for (int j = 0; j < i; ++j) {
                vector.add(list.get(j));
            }
            vector.add(simpleType);
        }
        if (vector == null) {
            return list;
        }
        return vector;
    }
}

