#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    cgi
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/?p=software/sisu.git;a=summary>
#    <https://git.sisudoc.org/projects/?p=markup/sisu-markup-samples.git;a=summary>
module  SiSU_CGI_PgSQL                                  #% database building documents
  require_relative 'se'                                 # se.rb
  require_relative 'cgi_sql_common'                     # cgi_sql_common.rb
    include SiSU_CGI_SQL
  class SearchPgSQL < CGI_Common
    def initialize(opt,webserv)
      @opt,@webserv=opt,webserv
      @cX=SiSU_Screen::Ansi.new(opt.act[:color_state][:set]).cX
      @env=SiSU_Env::InfoEnv.new('',opt)
      @sys=SiSU_Env::SystemCall.new
      @db=SiSU_Env::InfoDb.new
      get_init=SiSU_Env::GetInit.new
      @rc=get_init.sisu_yaml.rc
      @name_of={}
      @name_of[:output_dir_structure]=if opt.dir_structure_by.to_s =~/(?:language|filetype|filename)/
        opt.dir_structure_by.to_s
      else 'language'
      end
      @name_of[:lingual]=if opt.lingual.to_s =~/(?:mono|multi)/
        opt.lingual.to_s
      else 'multi'
      end
      @name_of[:db]=if defined? @rc['search'] \
      and defined? @rc['search']['sisu'] \
      and defined? @rc['search']['sisu']['action'] \
      and @rc['search']['sisu']['action'] =~/https?:\/\/\S+?\.cgi/ \
      and defined? @rc['search']['sisu']['db'] \
      and @rc['search']['sisu']['db'] =~/\S+/
        @rc['search']['sisu']['db']
      else
        @env.path.base_markup_dir_stub #'sisu' #breaks if not present
      end
      @name_of[:host_url_cgi]=%q{http://#{ENV['HTTP_HOST']}#{ENV['PATH_INFO']}}
      @name_of[:host_url_docs]=%q{http://#{ENV['HTTP_HOST']}}
      @name_of[:cgi_script]=%q{#{ENV['SCRIPT_NAME']}}
      @name_of[:user]=@db.psql.user(opt)
      @image_src=%q{http://#{ENV['HTTP_HOST']}/_sisu/image_sys}
      @common=SiSU_CGI_SQL::CGI_Common.new(@webserv,opt,@image_src,@env)
      @cgi_file_name=@env.url.cgi_sample_search_form_name(opt)
    end
    def pgsql
      serve=[]
      if @sys.psql
        available_db_table=`psql --list`                            # system call requires psql
        available_db=available_db_table.scan(/(#{Db[:name_prefix]}\S+)/) if not available_db_table.nil?
        if available_db \
        and available_db.is_a?(Array)
          available_db.flatten.each do |x|
            serve << x.gsub(/#{Db[:name_prefix]}(\S+)/,'\1')
          end
        else STDERR.puts "WARNING: no postgresql database available, (have you created one?)"
        end
        serve=serve.sort
        f1,f2='',''
        serve.each do |x|
          f1 << %{              <option value="#{Db[:name_prefix]}#{x}">#{x}</option>\n} unless x =~/apache|sisu\/image/ #check
        end
      end
      f2 << %q{          selected_db=%{<option value="#{@db_name_prefix}#{@stub}">#{@stub}</option>}} + "\n"
      if FileTest.writable?('.')
        output=File.open(@cgi_file_name,'w')
        output << header0 << header1 << header_desc << header2 << f1 << buttons1 << buttons1_pgsql << buttons2 << search_request << search_statement << search_statement_common << search_query1 << @common.pages << search_query2 << @common.tail << @common.main1 << f2 << dbi_connect << @common.main2 << @common.dir_structure << @common.main3
        puts <<-WOK
            generated sample search form: #{@cX.green}#{@cgi_file_name}#{@cX.off}
            default database name:     #{@cX.green}#{Db[:name_prefix]}#{@name_of[:db]}#{@cX.off} (#{@name_of[:db]})
            db user:                   #{@cX.green}#{@name_of[:user]}#{@cX.off}
              to modify use:           #{@cX.brown}sisu --db-pg --db-user='#{@name_of[:user]}'#{@cX.off}

            #{@cX.fuchsia}BASED ON ALREADY EXISTING databases#{@cX.off} (default database name: #{@db.psql.db})
            NOTE it is first necessary to createdb,
            use sisu to create the tables & populate the postgresql db

            the database to be used for this directory (#{@db.psql.db})
            will have to be created manually if it does not exist:
            using postgresql tools directly (the following may work):
              (i) if you are not yet a postgresql user,
                #{@cX.brown}sudo su postgres
                  createuser -d -a #{@env.user}
                exit#{@cX.off}
              (ii) create the database:
                #{@cX.brown}createdb #{@db.psql.db}#{@cX.off}
            [for a list of existing databases try 'psql --list']"

            you can use sisu to create the database tables and populate the database with documents

            sisu --pg --dropall                              # removes existing postgresql db & tables
            sisu --pg --createall -v                         # creates postgresql db & tables
            sisu --pg --update -v *.sst  *.ssm               # populate the db
            sisu --sample-search-form --db-pg                # creates the postgresql search form
                                                             # this should be done after creating the db
                                                             # to be searched
            sisu --webrick &                                 # starts ruby webrick web server

            # if necessary make the directory '/usr/lib/cgi-bin'
            # here we copy the postgresql search form to cgi-bin
            # (copy #{@cgi_file_name} to your cgi directory)
            # set file permissions to 755
        WOK
        a=case @webserv
        when /pwd/ then ''
        else <<-WOK

              sudo cp -vi #{Dir.pwd}/#{@cgi_file_name} /usr/lib/cgi-bin/.; \\
              sudo chmod -v 755  /usr/lib/cgi-bin/#{@cgi_file_name}
          WOK
        end
        SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],a).warn
        a=<<-WOK
              #{@env.webserv_base_cgi(@opt)}/cgi-bin/#{@cgi_file_name}
        WOK
        SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],a).print_blue
        a="\n\t(to create and populate postgresql database see 'man sisu' and in particular the --pg option)\n\t[the database to be used for this directory (#{@db.psql.db}) will have to be created manually if it does not exist,\n\tusing postgresql tools directly: 'createdb #{@db.psql.db}' for a list of existing databases try 'psql --list']"
        SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],a).txt_grey
      else puts 'failed in attempt to write #{@cgi_file_name} to present directory,  is directory writable?'
      end
    end
    def header0
      <<-WOK_SQL
#!/usr/bin/env ruby
=begin
#{about}
 * Description: generates naive cgi search form for search of sisu database (pgsql)
#{gpl}
=end
      begin
        require 'cgi'
        require 'fcgi'
        require 'pg'
      rescue LoadError
        puts 'cgi, fcgi or pg NOT FOUND (LoadError)'
      end
      @stub_default='#{@name_of[:db]}'
      @image_src="#{@image_src}"
      @hosturl_cgi="#{@name_of[:host_url_cgi]}"
      @hosturl_files="#{@name_of[:host_url_docs]}"
      @output_dir_structure_by='#{@name_of[:output_dir_structure]}'
      @lingual='#{@name_of[:lingual]}'
      @port='#{@db.psql.port}'
      @db_name_prefix='#{Db[:name_prefix]}'
      @user='#{@name_of[:user]}'  # check user name for access to pg database: e.g. www-data or '#{@env.user}'
      @base="#{@name_of[:host_url_cgi]}#{@name_of[:cgi_script]}"
      WOK_SQL
    end
    def search_statement
      <<-'WOK_SQL'
      class DBI_SearchString
        def initialize(l,t,q,cse=false)
          @l,@t,@q,@c=l,t,q,cse
        end
        def string
          search={ search: [], flag: false }
          if @t =~/\S+/ or @q =~/\S+/
            if @t =~/\S+/    then unescaped_search=CGI.unescape(@t)
            elsif @q =~/\S+/ then unescaped_search=CGI.unescape(@q)
            end
            search_construct=[]
            unescaped_search=if @c
              unescaped_search.gsub(/\s*(AND|OR)\s*/,"' \) \\1 #{@l}~\( '").
                gsub(/(.+)/,"#{@l}~\( '\\1' \)")
            else
              unescaped_search.gsub(/\s*(AND|OR)\s*/,"' \) \\1 #{@l}~*\( '").
                gsub(/(.+)/,"#{@l}~*\( '\\1' \)")
            end
            search_construct << unescaped_search
            search_construct=search_construct.join(' ')
            search[:search]                    << search_construct
            search[:flag]=true
            search
          end
          search
        end
      end
      WOK_SQL
    end
    def search_query1
      <<-'WOK_SQL'
          @search_text=''
          @search_text=search[:text].flatten.join(' AND ')
          @search_text=@search_text.gsub(/(doc_objects\.clean~[*]?\(\s*'[^']+'\s*\)\s+(?:(?:AND|OR)\s+doc_objects\.clean~[*]?\(\s*'[^']+'\s*\))+)/,'(\1)')
        end
      WOK_SQL
    end
    def search_query2
      <<-'WOK_SQL'
        def sql_select_body
          limit ||=@@limit
          offset ||=@@offset
          @sql_statement[:body]=%{SELECT metadata_and_text.title, metadata_and_text.creator_author, metadata_and_text.src_filename, metadata_and_text.language_document_char, metadata_and_text.notes_suffix, doc_objects.body, doc_objects.seg, doc_objects.ocn, metadata_and_text.tid FROM doc_objects, metadata_and_text WHERE (#{@search_text}) AND doc_objects.metadata_tid = metadata_and_text.tid ORDER BY metadata_and_text.language_document_char, metadata_and_text.title, metadata_and_text.src_filename, doc_objects.ocn}
          @sql_statement[:range]=%{LIMIT #{limit} OFFSET #{offset} ;}
          select=@sql_statement[:body] + ' ' + @sql_statement[:range]
          select
        end
        def sql_select_body_format
          %{<font color="#666666" size="2">#{sql_select_body}</font>}
        end
        def contents
          @conn.exec(sql_select_body)
        end
      end
      WOK_SQL
    end
    def buttons1_pgsql
      <<-'WOK_SQL'
        <input type="checkbox" name="casesense" #{@checked_case}> case sensitive
      WOK_SQL
    end
    def dbi_connect
      <<-'WOK_SQL'
          @conn=PG::Connection.open(dbname: @db, port: @port, user: @user)
      WOK_SQL
    end
  end
end
__END__
